/*
 * Decompiled with CFR 0.152.
 */
package org.bluray.ti;

import java.util.Date;
import javax.tv.locator.Locator;
import javax.tv.service.ServiceInformationType;
import javax.tv.service.navigation.ServiceComponent;
import javax.tv.service.navigation.StreamType;
import org.bluray.net.BDLocator;
import org.bluray.ti.PlayItem;
import org.bluray.ti.Title;
import org.bluray.ti.TitleComponentImpl;
import org.bluray.ti.TitleInformationType;
import org.davic.net.InvalidLocatorException;
import org.videolan.Libbluray;
import org.videolan.StreamInfo;
import org.videolan.TIClip;

public class PlayItemImpl
implements PlayItem {
    private int playlistId;
    private int playitemId;
    private TIClip clip;
    private Title service;

    protected PlayItemImpl(int playlistId, int playitemId, TIClip clip, Title service) {
        this.playlistId = playlistId;
        this.playitemId = playitemId;
        this.clip = clip;
        this.service = service;
    }

    public int getPlayItemId() {
        return this.playitemId;
    }

    public int getPlayListId() {
        return this.playlistId;
    }

    public Locator getLocator() {
        int title = Libbluray.getCurrentTitle();
        try {
            return new BDLocator("bd://" + Integer.toHexString(title) + ".PLAYLIST:" + this.playlistId + ".ITEM:" + this.playitemId);
        }
        catch (InvalidLocatorException e) {
            return null;
        }
    }

    public ServiceInformationType getServiceInformationType() {
        return TitleInformationType.BD_ROM;
    }

    public Date getUpdateTime() {
        return null;
    }

    public ServiceComponent[] getComponents() {
        int j;
        StreamInfo[] video = this.clip.getVideoStreams();
        StreamInfo[] audio = this.clip.getVideoStreams();
        StreamInfo[] pg = this.clip.getVideoStreams();
        StreamInfo[] ig = this.clip.getVideoStreams();
        StreamInfo[] secVideo = this.clip.getVideoStreams();
        StreamInfo[] secAudio = this.clip.getVideoStreams();
        int count = video.length + audio.length + pg.length + ig.length + secVideo.length + secAudio.length;
        ServiceComponent[] components = new ServiceComponent[count];
        int i = 0;
        for (j = 0; j < video.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, video[j], StreamType.VIDEO, true, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        for (j = 0; j < audio.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, audio[j], StreamType.AUDIO, true, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        for (j = 0; j < pg.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, pg[j], StreamType.SUBTITLES, true, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        for (j = 0; j < ig.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, ig[j], StreamType.DATA, true, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        for (j = 0; j < secVideo.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, secVideo[j], StreamType.VIDEO, false, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        for (j = 0; j < secAudio.length; ++j) {
            components[i] = new TitleComponentImpl(j + 1, secAudio[j], StreamType.AUDIO, false, this.playlistId, this.playitemId, this.service);
            ++i;
        }
        return components;
    }
}

