/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.Map;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.AllPrimitives;

public class QueryExplainTest
extends AbstractQueryTest {
    @Override
    public Class<?> getInstanceType() {
        return AllPrimitives.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllPrimitivesInstances(10);
    }

    public void testExplainWithNoWhereClause() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with no where clause should have index none", "none", string);
        this.errorIfNotEqual("Query explain with no where clause should have scan type TABLE_SCAN", "TABLE_SCAN", string2);
        this.failOnError();
    }

    public void testExplainBeforeBindingParameters() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("int_null_none").equal(queryDomainType.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        try {
            query.explain();
            QueryExplainTest.fail("Explain before binding parameters should throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            this.errorIfNotEqual("Message should include parameter name \"equal\"", true, clusterJUserException.getMessage().contains("equal"));
        }
        this.failOnError();
    }

    public void testExplainAfterBindingParametersNoIndexEqual() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("int_null_none").equal(queryDomainType.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("equal", (Object)1);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with no index should have index none", "none", string);
        this.errorIfNotEqual("Query explain with no index should have scan type TABLE_SCAN", "TABLE_SCAN", string2);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersUniqueEqual() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("int_not_null_hash").equal(queryDomainType.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("equal", (Object)1);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have index int_not_null_hash", "idx_int_not_null_hash", string);
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have scan type UNIQUE_KEY", "UNIQUE_KEY", string2);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryEqual() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("id").equal(queryDomainType.param("equal")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("equal", (Object)1);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have index PRIMARY", "PRIMARY", string);
        this.errorIfNotEqual("Query explain with PRIMARY key equal should have scan type PRIMARY_KEY", "PRIMARY_KEY", string2);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryLessThan() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("id").lessThan(queryDomainType.param("lessThan")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("lessThan", (Object)1);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan should have index PRIMARY", "PRIMARY", string);
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan should have scan type INDEX_SCAN", "INDEX_SCAN", string2);
        this.failOnError();
    }

    public void testExplainAfterBindingParametersPrimaryLessThanNull() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(AllPrimitives.class);
        queryDomainType.where(queryDomainType.get("id").lessThan(queryDomainType.param("lessThan")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("lessThan", null);
        Map map = query.explain();
        String string = map.get("IndexUsed").toString();
        String string2 = map.get("ScanType").toString();
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan null should have index none", "none", string);
        this.errorIfNotEqual("Query explain with PRIMARY key lessThan null should have scan type TABLE_SCAN", "TABLE_SCAN", string2);
        this.failOnError();
    }
}

