/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.junit.Ignore;

public class TestSuite
implements Test {
    public final String name;
    public final List<String> testClasses = new ArrayList<String>();
    public final List<TestCase> tests = new ArrayList<TestCase>();

    public TestSuite(String string) {
        this.name = string;
    }

    public TestSuite(Class<?> clazz) {
        this.name = clazz.getName();
        if (!TestCase.class.isAssignableFrom(clazz)) {
            throw new RuntimeException("TestSuite<init>: " + clazz.getName());
        }
        this.addTestSuite(clazz);
    }

    public void addTestSuite(Class<? extends TestCase> clazz) {
        Ignore ignore = null;
        String string = null;
        for (Class<? extends TestCase> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            ignore = clazz2.getAnnotation(Ignore.class);
            if (ignore == null) continue;
            string = ignore.value();
            break;
        }
        this.testClasses.add(clazz.getName());
        Method[] methodArray = clazz.getMethods();
        Ignore ignore2 = null;
        String string2 = null;
        for (Method method : methodArray) {
            ignore2 = method.getAnnotation(Ignore.class);
            String string3 = ignore != null ? string : (string2 = ignore2 == null ? null : ignore2.value());
            if (!method.getName().startsWith("test") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Void.TYPE) || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                if (string2 != null) {
                    System.out.println(clazz.getName() + ":" + method.getName() + " @Ignored because: " + string2);
                    continue;
                }
                TestCase testCase = clazz.newInstance();
                testCase.name = clazz.getSimpleName() + "." + method.getName();
                testCase.method = method;
                this.tests.add(testCase);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public int testCount() {
        return this.tests.size();
    }

    public int countTestCases() {
        return this.tests.size();
    }

    @Override
    public void run(TestResult testResult) {
        for (TestCase testCase : this.tests) {
            testCase.run(testResult);
        }
    }
}

