/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreManager;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import org.apache.openjpa.kernel.OpenJPAStateManager;

public class NdbOpenJPAValueHandler
implements ValueHandler {
    protected OpenJPAStateManager sm;
    private NdbOpenJPAStoreManager store;
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAValueHandler.class);

    protected OpenJPAStateManager getStateManager() {
        return this.sm;
    }

    protected NdbOpenJPAStoreManager getStoreManager() {
        return this.store;
    }

    public NdbOpenJPAValueHandler(OpenJPAStateManager openJPAStateManager) {
        this.sm = openJPAStateManager;
    }

    public NdbOpenJPAValueHandler(OpenJPAStateManager openJPAStateManager, NdbOpenJPAStoreManager ndbOpenJPAStoreManager) {
        this.sm = openJPAStateManager;
        this.store = ndbOpenJPAStoreManager;
    }

    @Override
    public boolean isNull(int n) {
        return this.sm.fetchObject(n) == null;
    }

    @Override
    public boolean isModified(int n) {
        BitSet bitSet = this.sm.getDirty();
        return bitSet.get(n);
    }

    @Override
    public void resetModified() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void markModified(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getBoolean(int n) {
        return this.sm.fetchBoolean(n);
    }

    @Override
    public boolean[] getBooleans(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean getObjectBoolean(int n) {
        return this.sm.fetchBoolean(n);
    }

    @Override
    public byte getByte(int n) {
        return this.sm.fetchByte(n);
    }

    @Override
    public byte[] getBytes(int n) {
        return (byte[])this.sm.fetchObject(n);
    }

    @Override
    public short getShort(int n) {
        return this.sm.fetchShort(n);
    }

    @Override
    public int getInt(int n) {
        int n2 = this.sm.fetchInt(n);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + n + " value: " + n2);
        }
        return n2;
    }

    @Override
    public long getLong(int n) {
        long l = this.sm.fetchLong(n);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + n + " value: " + l);
        }
        return l;
    }

    @Override
    public float getFloat(int n) {
        return this.sm.fetchFloat(n);
    }

    @Override
    public double getDouble(int n) {
        return this.sm.fetchDouble(n);
    }

    @Override
    public Byte getObjectByte(int n) {
        return (Byte)this.sm.fetchObject(n);
    }

    @Override
    public Short getObjectShort(int n) {
        return (Short)this.sm.fetchObject(n);
    }

    @Override
    public Integer getObjectInt(int n) {
        Integer n2 = (Integer)this.sm.fetchObject(n);
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + n + " value: " + n2);
        }
        return n2;
    }

    @Override
    public Long getObjectLong(int n) {
        return (Long)this.sm.fetchObject(n);
    }

    @Override
    public Float getObjectFloat(int n) {
        return (Float)this.sm.fetchObject(n);
    }

    @Override
    public Double getObjectDouble(int n) {
        return (Double)this.sm.fetchObject(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) {
        return (BigDecimal)this.sm.fetchObject(n);
    }

    @Override
    public BigInteger getBigInteger(int n) {
        return (BigInteger)this.sm.fetchObject(n);
    }

    @Override
    public String getString(int n) {
        return this.sm.fetchString(n);
    }

    @Override
    public Date getJavaSqlDate(int n) {
        return (Date)this.sm.fetchObject(n);
    }

    @Override
    public java.util.Date getJavaUtilDate(int n) {
        return (java.util.Date)this.sm.fetchObject(n);
    }

    @Override
    public Time getJavaSqlTime(int n) {
        return (Time)this.sm.fetchObject(n);
    }

    @Override
    public Timestamp getJavaSqlTimestamp(int n) {
        return (Timestamp)this.sm.fetchObject(n);
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        this.sm.storeBoolean(n, bl);
    }

    @Override
    public void setBooleans(int n, boolean[] blArray) {
        this.sm.storeObject(n, (Object)blArray);
    }

    @Override
    public void setByte(int n, byte by) {
        this.sm.storeByte(n, by);
    }

    @Override
    public void setBytes(int n, byte[] byArray) {
        this.sm.storeObject(n, (Object)byArray);
    }

    @Override
    public void setShort(int n, short s) {
        this.sm.storeShort(n, s);
    }

    @Override
    public void setInt(int n, int n2) {
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + n + " value: " + n2);
        }
        this.sm.storeInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) {
        this.sm.storeLong(n, l);
    }

    @Override
    public void setFloat(int n, float f) {
        this.sm.storeFloat(n, f);
    }

    @Override
    public void setDouble(int n, double d) {
        this.sm.storeDouble(n, d);
    }

    @Override
    public void setObjectBoolean(int n, Boolean bl) {
        this.sm.storeObject(n, (Object)bl);
    }

    @Override
    public void setObjectByte(int n, Byte by) {
        this.sm.storeObject(n, (Object)by);
    }

    @Override
    public void setObjectShort(int n, Short s) {
        this.sm.storeObject(n, (Object)s);
    }

    @Override
    public void setObjectInt(int n, Integer n2) {
        if (logger.isDetailEnabled()) {
            logger.detail(" fieldNumber: " + n + " value: " + n2);
        }
        this.sm.storeObject(n, (Object)n2);
    }

    @Override
    public void setObjectLong(int n, Long l) {
        this.sm.storeObject(n, (Object)l);
    }

    @Override
    public void setObjectFloat(int n, Float f) {
        this.sm.storeObject(n, (Object)f);
    }

    @Override
    public void setObjectDouble(int n, Double d) {
        this.sm.storeObject(n, (Object)d);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) {
        this.sm.storeObject(n, (Object)bigDecimal);
    }

    @Override
    public void setBigInteger(int n, BigInteger bigInteger) {
        this.sm.storeObject(n, (Object)bigInteger);
    }

    @Override
    public void setString(int n, String string) {
        this.sm.storeString(n, string);
    }

    @Override
    public void setObject(int n, Object object) {
        this.sm.storeObject(n, object);
    }

    @Override
    public void setJavaSqlDate(int n, Date date) {
        this.sm.storeObject(n, (Object)date);
    }

    @Override
    public void setJavaUtilDate(int n, java.util.Date date) {
        this.sm.storeObject(n, (Object)date);
    }

    @Override
    public void setJavaSqlTime(int n, Time time) {
        this.sm.storeObject(n, (Object)time);
    }

    @Override
    public void setJavaSqlTimestamp(int n, Timestamp timestamp) {
        this.sm.storeObject(n, (Object)timestamp);
    }

    @Override
    public String pkToString(DomainTypeHandler<?> domainTypeHandler) {
        StringBuffer stringBuffer = new StringBuffer(" key: [");
        int[] nArray = domainTypeHandler.getKeyFieldNumbers();
        String string = "";
        for (int n : nArray) {
            stringBuffer.append(string);
            stringBuffer.append(this.sm.fetch(n));
            string = ";";
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void dumpStackTrace() {
        Throwable throwable = new Throwable();
        throwable.printStackTrace();
    }

    @Override
    public void found(Boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ColumnMetadata[] columnMetadata() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Boolean found() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object get(int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void set(int n, Object object) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getLobBytes(int n) {
        return (byte[])this.sm.fetchObject(n);
    }

    @Override
    public String getLobString(int n) {
        return this.sm.fetchString(n);
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
    }

    @Override
    public void setLobBytes(int n, byte[] byArray) {
        this.sm.storeObject(n, (Object)byArray);
    }

    @Override
    public void setLobString(int n, String string) {
        this.sm.storeString(n, string);
    }

    @Override
    public void setProxy(Object object) {
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getProxy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

