/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.query.QueryExecutionContextImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainFieldHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import com.mysql.clusterj.openjpa.NdbOpenJPAResult;
import com.mysql.clusterj.openjpa.NdbOpenJPAStoreQuery;
import com.mysql.clusterj.openjpa.NdbOpenJPAUtility;
import com.mysql.clusterj.query.QueryDomainType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryCacheStoreQuery;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.kernel.PreparedSQLStoreQuery;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.util.OpenJPAId;

public class NdbOpenJPAStoreManager
extends JDBCStoreManager {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAStoreManager.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAStoreManager.class);
    private StoreContext storeContext;
    private NdbOpenJPAConfiguration ndbConfiguration;
    private SessionFactory sessionFactory;
    private SessionSPI session;
    private Transaction tx;
    private Dictionary dictionary;

    public void setContext(StoreContext storeContext) {
        super.setContext(storeContext);
        this.setContext(storeContext, (NdbOpenJPAConfiguration)storeContext.getConfiguration());
    }

    public void setContext(StoreContext storeContext, NdbOpenJPAConfiguration ndbOpenJPAConfiguration) {
        this.storeContext = storeContext;
        this.ndbConfiguration = ndbOpenJPAConfiguration;
        this.sessionFactory = ndbOpenJPAConfiguration.getSessionFactory();
        this.getSession();
    }

    protected NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(OpenJPAStateManager openJPAStateManager) {
        ClassMapping classMapping = (ClassMapping)openJPAStateManager.getMetaData();
        return this.getDomainTypeHandler(classMapping);
    }

    protected NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(ClassMapping classMapping) {
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl = this.ndbConfiguration.getDomainTypeHandler(classMapping, this.dictionary);
        return ndbOpenJPADomainTypeHandlerImpl;
    }

    protected int deleteAll(DomainTypeHandler<?> domainTypeHandler) {
        int n = this.session.deletePersistentAll(domainTypeHandler);
        return n;
    }

    protected SessionSPI getSession() {
        if (this.session == null) {
            this.session = (SessionSPI)this.sessionFactory.getSession();
            this.dictionary = this.session.getDictionary();
        }
        return this.session;
    }

    public Object find(Object object, ValueMapping valueMapping, JDBCFetchConfiguration jDBCFetchConfiguration) {
        ClassMapping classMapping;
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl;
        ValueHandler valueHandler;
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.find(Object oid, ValueMapping vm, JDBCFetchConfiguration fetch) delegated to super with oid " + object + ".");
        }
        if ((valueHandler = (ndbOpenJPADomainTypeHandlerImpl = this.getDomainTypeHandler(classMapping = valueMapping.getDeclaredTypeMapping())).createKeyValueHandler(object, null)) == null) {
            return null;
        }
        return super.find(object, valueMapping, jDBCFetchConfiguration);
    }

    public boolean load(OpenJPAStateManager openJPAStateManager, BitSet bitSet, FetchConfiguration fetchConfiguration, int n, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) Id: " + openJPAStateManager.getId() + " requested fields: " + NdbOpenJPAUtility.printBitSet(openJPAStateManager, bitSet));
        }
        if (object != null && ((ConnectionInfo)object).result != null) {
            return super.load(openJPAStateManager, bitSet, fetchConfiguration, n, object);
        }
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl = this.getDomainTypeHandler(openJPAStateManager);
        if (!this.isSupportedType(ndbOpenJPADomainTypeHandlerImpl, "NdbOpenJPAStoreManager.load")) {
            return super.load(openJPAStateManager, bitSet, fetchConfiguration, n, object);
        }
        try {
            return ndbOpenJPADomainTypeHandlerImpl.load(openJPAStateManager, this, bitSet, (JDBCFetchConfiguration)fetchConfiguration, object);
        }
        catch (SQLException sQLException) {
            logger.error("Fatal error from NdbOpenJPAStoreManager.load " + sQLException);
            return false;
        }
    }

    public Object load(ClassMapping classMapping, JDBCFetchConfiguration jDBCFetchConfiguration, BitSet bitSet, Result result) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.load(ClassMapping mapping, JDBCFetchConfiguration fetch, BitSet exclude, Result result) for " + classMapping.getDescribedType().getName() + " delegated to super.");
        }
        return super.load(classMapping, jDBCFetchConfiguration, bitSet, result);
    }

    public Collection loadAll(Collection collection, PCState pCState, int n, FetchConfiguration fetchConfiguration, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object context) delegated to super.");
        }
        return super.loadAll(collection, pCState, n, fetchConfiguration, object);
    }

    public boolean initialize(OpenJPAStateManager openJPAStateManager, PCState pCState, FetchConfiguration fetchConfiguration, Object object) {
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl;
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context)");
        }
        if (object != null) {
            ConnectionInfo connectionInfo = (ConnectionInfo)object;
            ClassMapping classMapping = connectionInfo.mapping;
            Result result = connectionInfo.result;
            logger.info("info mapping: " + classMapping.getDescribedType().getName() + " result: " + result);
            try {
                return this.initializeState(openJPAStateManager, pCState, (JDBCFetchConfiguration)fetchConfiguration, connectionInfo);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"), classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new ClusterJDatastoreException(local.message("ERR_Datastore_Exception"), sQLException);
            }
        }
        OpenJPAId openJPAId = (OpenJPAId)openJPAStateManager.getId();
        if (logger.isTraceEnabled()) {
            logger.trace("Id: " + openJPAId.getClass() + " " + openJPAId);
        }
        if (!this.isSupportedType(ndbOpenJPADomainTypeHandlerImpl = this.getDomainTypeHandler(openJPAStateManager), "NdbOpenJPAStoreManager.initialize")) {
            boolean bl = super.initialize(openJPAStateManager, pCState, fetchConfiguration, object);
            if (logger.isDebugEnabled()) {
                logger.debug("NdbOpenJPAStoreManager.initialize delegated to super: returned " + bl);
            }
            return bl;
        }
        try {
            this.getSession();
            this.session.startAutoTransaction();
            ValueHandler valueHandler = ndbOpenJPADomainTypeHandlerImpl.createKeyValueHandler(openJPAId.getIdObject(), null);
            ResultData resultData = this.session.selectUnique(ndbOpenJPADomainTypeHandlerImpl, valueHandler, null);
            NdbOpenJPAResult ndbOpenJPAResult = new NdbOpenJPAResult(resultData, ndbOpenJPADomainTypeHandlerImpl, null);
            if (ndbOpenJPAResult.next()) {
                ndbOpenJPADomainTypeHandlerImpl.newInstance(openJPAStateManager);
                ndbOpenJPADomainTypeHandlerImpl.load(openJPAStateManager, this, (JDBCFetchConfiguration)fetchConfiguration, ndbOpenJPAResult);
            }
            if (logger.isDetailEnabled()) {
                logger.detail("After initializing PCState: " + openJPAStateManager.getPCState().getClass().getSimpleName() + " " + this.printLoaded(openJPAStateManager));
            }
            this.session.endAutoTransaction();
            return true;
        }
        catch (ClusterJException clusterJException) {
            this.session.failAutoTransaction();
            throw clusterJException;
        }
        catch (Exception exception) {
            this.session.failAutoTransaction();
            throw new ClusterJFatalInternalException("Unexpected exception.", exception);
        }
    }

    protected boolean initializeState(OpenJPAStateManager openJPAStateManager, PCState pCState, JDBCFetchConfiguration jDBCFetchConfiguration, ConnectionInfo connectionInfo) throws ClassNotFoundException, SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("NdbStoreManager.initializeState(OpenJPAStateManager, PCState, JDBCFetchConfiguration, ConnectionInfo) delegated to super.");
        }
        return super.initializeState(openJPAStateManager, pCState, jDBCFetchConfiguration, connectionInfo);
    }

    public Collection<Exception> flush(Collection collection) {
        ArrayList<Exception> arrayList;
        Collection collection2 = collection;
        StringBuffer stringBuffer = null;
        if (logger.isTraceEnabled()) {
            stringBuffer = new StringBuffer();
        }
        boolean bl = true;
        for (Object object : collection2) {
            OpenJPAStateManager openJPAStateManager = this.getDomainTypeHandler((OpenJPAStateManager)object);
            if (!openJPAStateManager.isSupportedType()) {
                if (logger.isDetailEnabled()) {
                    logger.detail("Found unsupported class " + openJPAStateManager.getName());
                }
                if (this.ndbConfiguration.getFailOnJDBCPath()) {
                    throw new ClusterJFatalUserException(local.message("ERR_JDBC_Path", (Object)openJPAStateManager.getName()));
                }
                bl = false;
            }
            if (!logger.isTraceEnabled()) continue;
            stringBuffer.append(this.printState((OpenJPAStateManager)object));
        }
        if (logger.isTraceEnabled()) {
            logger.trace(stringBuffer.toString());
        }
        if (!bl) {
            arrayList = super.flush(collection);
            if (logger.isDetailEnabled()) {
                logger.detail("Found unsupported class(es); super resulted in exceptions: " + arrayList);
            }
            return arrayList;
        }
        this.getSession();
        arrayList = new ArrayList<Exception>();
        for (OpenJPAStateManager openJPAStateManager : collection2) {
            NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl = this.getDomainTypeHandler(openJPAStateManager);
            ValueHandler valueHandler = ndbOpenJPADomainTypeHandlerImpl.getValueHandler(openJPAStateManager, this);
            PCState pCState = openJPAStateManager.getPCState();
            try {
                if (pCState == PCState.PNEW) {
                    this.session.insert(ndbOpenJPADomainTypeHandlerImpl, valueHandler);
                    continue;
                }
                if (pCState == PCState.PDELETED) {
                    this.session.delete(ndbOpenJPADomainTypeHandlerImpl, valueHandler);
                    continue;
                }
                if (pCState == PCState.PDIRTY) {
                    this.session.update(ndbOpenJPADomainTypeHandlerImpl, valueHandler);
                    continue;
                }
                if (pCState == PCState.PNEWFLUSHEDDELETED) {
                    this.session.delete(ndbOpenJPADomainTypeHandlerImpl, valueHandler);
                    continue;
                }
                if (pCState == PCState.PNEWFLUSHEDDELETEDFLUSHED) continue;
                throw new ClusterJUserException(local.message("ERR_Unsupported_Flush_Operation", (Object)pCState.toString()));
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Exception caught: " + exception.toString());
                }
                arrayList.add(exception);
            }
        }
        this.session.flush();
        return arrayList;
    }

    private boolean isSupportedType(NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl, String string) {
        boolean bl = ndbOpenJPADomainTypeHandlerImpl.isSupportedType();
        if (!bl) {
            if (logger.isDebugEnabled()) {
                logger.debug(string + " found unsupported class " + ndbOpenJPADomainTypeHandlerImpl.getName());
            }
            if (this.ndbConfiguration.getFailOnJDBCPath()) {
                throw new ClusterJFatalUserException(local.message("ERR_JDBC_Path", (Object)ndbOpenJPADomainTypeHandlerImpl.getName()));
            }
        }
        return bl;
    }

    public void beforeStateChange(OpenJPAStateManager openJPAStateManager, PCState pCState, PCState pCState2) {
        if (logger.isDetailEnabled()) {
            logger.detail(this.printState("from ", pCState) + this.printState(" to ", pCState2));
        }
        super.beforeStateChange(openJPAStateManager, pCState, pCState2);
    }

    public StoreQuery newQuery(String string) {
        ExpressionParser expressionParser = QueryLanguages.parserForLanguage((String)string);
        StoreQuery storeQuery = this.newStoreQuery(string, expressionParser);
        if (logger.isDetailEnabled()) {
            logger.detail("NdbOpenJPAStoreManager.newQuery language: " + string + " parser: " + expressionParser);
        }
        if (storeQuery == null || expressionParser == null) {
            return storeQuery;
        }
        QueryCache queryCache = this.storeContext.getConfiguration().getDataCacheManagerInstance().getSystemQueryCache();
        if (queryCache == null) {
            return storeQuery;
        }
        return new QueryCacheStoreQuery(storeQuery, queryCache);
    }

    private StoreQuery newStoreQuery(String string, ExpressionParser expressionParser) {
        if (expressionParser != null) {
            return new NdbOpenJPAStoreQuery(this, expressionParser);
        }
        if ("openjpa.SQL".equals(string)) {
            return new SQLStoreQuery((JDBCStore)this);
        }
        if ("openjpa.prepared.SQL".equals(string)) {
            return new PreparedSQLStoreQuery((JDBCStore)this);
        }
        return null;
    }

    public void beginOptimistic() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        super.beginOptimistic();
        try {
            this.getSession();
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.tx.begin();
        }
        catch (Exception exception) {
            logger.detail("NdbOpenJPAStoreManager.beginOptimistic():caught exception in session.currentTransaction.begin().");
            throw new ClusterJDatastoreException(local.message("ERR_Datastore_Exception"), exception);
        }
    }

    public void begin() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        this.getSession();
        try {
            this.tx = this.session.currentTransaction();
            if (this.tx.isActive()) {
                this.tx.commit();
            }
            this.tx.begin();
        }
        catch (Exception exception) {
            logger.detail("Caught exception in session.currentTransaction.commit()." + exception.getMessage());
        }
        super.begin();
    }

    public void commit() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        try {
            this.session.commit();
        }
        catch (Exception exception) {
            logger.detail(" failed" + exception.toString());
            throw new ClusterJException(local.message("ERR_Commit_Failed", (Object)exception.toString()));
        }
        super.commit();
    }

    public void rollback() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        this.session.rollback();
        super.rollback();
    }

    public void close() {
        if (logger.isTraceEnabled()) {
            logger.trace(" Transaction " + ((Object)((Object)this)).hashCode() + this.printIsActive(this.tx));
        }
        if (this.session != null && !this.session.isClosed()) {
            if (this.session.currentTransaction().isActive()) {
                this.tx.commit();
            }
            this.session.close();
        }
    }

    protected String printState(OpenJPAStateManager openJPAStateManager) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class: ");
        stringBuffer.append(openJPAStateManager.getPersistenceCapable().getClass().getName());
        stringBuffer.append(" objectId: ");
        stringBuffer.append(openJPAStateManager.getObjectId());
        stringBuffer.append(" PCState: ");
        stringBuffer.append(openJPAStateManager.getPCState());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected String printState(String string, PCState pCState) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(pCState.getClass().getSimpleName());
        return stringBuffer.toString();
    }

    protected String printLoaded(OpenJPAStateManager openJPAStateManager) {
        BitSet bitSet = openJPAStateManager.getLoaded();
        return "Loaded: " + NdbOpenJPAUtility.printBitSet(openJPAStateManager, bitSet);
    }

    protected String printIsActive(Transaction transaction) {
        return transaction == null ? " is null." : (transaction.isActive() ? " is active." : " is not active.");
    }

    public <T> QueryDomainType<T> createQueryDomainType(Class<T> clazz) {
        return this.session.getQueryBuilder().createQueryDefinition(clazz);
    }

    public NdbOpenJPAResult executeQuery(DomainTypeHandler<?> domainTypeHandler, QueryDomainType<?> queryDomainType, Map<String, Object> map) {
        QueryExecutionContextImpl queryExecutionContextImpl = new QueryExecutionContextImpl(this.session, map);
        ResultData resultData = queryExecutionContextImpl.getResultData(queryDomainType);
        NdbOpenJPAResult ndbOpenJPAResult = new NdbOpenJPAResult(resultData, domainTypeHandler, null);
        return ndbOpenJPAResult;
    }

    public NdbOpenJPAResult lookup(OpenJPAStateManager openJPAStateManager, NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl, List<NdbOpenJPADomainFieldHandlerImpl> list) {
        Table table = ndbOpenJPADomainTypeHandlerImpl.getStoreTable();
        this.session.startAutoTransaction();
        try {
            Operation operation = this.session.getSelectOperation(table);
            operation.beginDefinition();
            int[] nArray = ndbOpenJPADomainTypeHandlerImpl.getKeyFieldNumbers();
            BitSet bitSet = new BitSet();
            for (int n : nArray) {
                bitSet.set(n);
            }
            ValueHandler valueHandler = ndbOpenJPADomainTypeHandlerImpl.getValueHandler(openJPAStateManager, this);
            ndbOpenJPADomainTypeHandlerImpl.operationSetKeys(valueHandler, operation);
            ndbOpenJPADomainTypeHandlerImpl.operationGetKeys(operation);
            for (NdbOpenJPADomainFieldHandlerImpl ndbOpenJPAResult : list) {
                ndbOpenJPAResult.operationGetValue(operation);
                bitSet.set(ndbOpenJPAResult.getFieldNumber());
            }
            operation.endDefinition();
            ResultData resultData = operation.resultData();
            NdbOpenJPAResult ndbOpenJPAResult = new NdbOpenJPAResult(resultData, ndbOpenJPADomainTypeHandlerImpl, bitSet);
            this.session.endAutoTransaction();
            return ndbOpenJPAResult;
        }
        catch (RuntimeException runtimeException) {
            this.session.failAutoTransaction();
            throw runtimeException;
        }
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }
}

