/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.util.List;

class DbImplForNdbRecord
implements Db {
    static final I18NHelper local = I18NHelper.getInstance(DbImplForNdbRecord.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbImplForNdbRecord.class);
    private Ndb ndb;
    private int errorBufferSize = 300;
    private ByteBuffer errorBuffer = ByteBuffer.allocateDirect(this.errorBufferSize);
    private NdbDictionary.Dictionary ndbDictionary;
    private ClusterConnectionImpl clusterConnection;

    public DbImplForNdbRecord(ClusterConnectionImpl clusterConnectionImpl, Ndb ndb) {
        this.clusterConnection = clusterConnectionImpl;
        this.ndb = ndb;
        int n = ndb.init(1);
        this.handleError(n, ndb);
        this.ndbDictionary = ndb.getDictionary();
        this.handleError(this.ndbDictionary, ndb);
    }

    @Override
    public void close() {
        Ndb.delete(this.ndb);
        this.clusterConnection.close(this);
    }

    @Override
    public Dictionary getDictionary() {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }

    @Override
    public ClusterTransaction startTransaction(String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    protected void handleError(int n, Ndb ndb) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(n, ndbErrorConst, string);
    }

    protected void handleError(Object object, Ndb ndb) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    @Override
    public boolean isRetriable(ClusterJDatastoreException clusterJDatastoreException) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public String getNdbErrorDetail(NdbErrorConst ndbErrorConst) {
        return this.ndb.getNdbErrorDetail(ndbErrorConst, this.errorBuffer, this.errorBuffer.capacity());
    }

    public NdbTransaction enlist(String string, List<KeyPart> list) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbTransaction enlist(String string, int n) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public NdbTransaction joinTransaction(String string) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }
}

