/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.kde.kjas.server.Console;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.KJASConsoleStream;
import org.kde.kjas.server.Main;

public class KJASSwingConsole
implements Console {
    private JFrame frame = null;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton clearButton;
    private JTextArea textField;
    private JButton closeButton;
    private JButton copyButton;
    static final int NR_BUFFERS = 3;
    static final int MAX_BUF_LENGTH = 3000;
    private int queue_pos = 0;
    private StringBuffer[] output_buffer = new StringBuffer[3];
    private PrintStream real_stderr = new PrintStream(System.err);

    public KJASSwingConsole() {
        PrintStream printStream = new PrintStream(new KJASConsoleStream(this));
        System.setOut(printStream);
        System.setErr(printStream);
    }

    private void initComponents() {
        this.frame = new JFrame("Konqueror Java Console");
        this.jPanel1 = new JPanel();
        this.clearButton = new JButton();
        this.closeButton = new JButton();
        this.copyButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.textField = new JTextArea();
        this.frame.setFont(new Font("Monospaced", 0, 10));
        this.frame.setName("KJAS Console");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KJASSwingConsole.this.exitForm(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.clearButton.setText("clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.clearButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.clearButton, "West");
        this.closeButton.setText("close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.closeButton, "East");
        this.copyButton.setText("copy");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KJASSwingConsole.this.copyButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.copyButton, "Center");
        this.frame.getContentPane().add((Component)this.jPanel1, "South");
        this.textField.setColumns(40);
        this.textField.setEditable(false);
        this.textField.setRows(10);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                KJASSwingConsole.this.textFieldKeyPressed(keyEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.textField);
        this.frame.getContentPane().add((Component)this.jScrollPane1, "Center");
        try {
            URL uRL = this.getClass().getClassLoader().getResource("images/beanicon.png");
            if (uRL != null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.createImage(uRL);
                this.frame.setIconImage(image);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.frame.pack();
        this.frame.setSize(500, 300);
    }

    private void textFieldKeyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case 'h': {
                this.showHelp();
                break;
            }
            case 'g': {
                this.append("Running Garbage Collection ...\n", true);
                System.gc();
            }
            case 'm': {
                this.append("Total Memory: " + Runtime.getRuntime().totalMemory() + " bytes\n", true);
                this.append("Free Memory : " + Runtime.getRuntime().freeMemory() + " bytes\n", true);
                break;
            }
            case 'c': {
                this.clear();
                break;
            }
            case 's': {
                this.showSystemProperties();
                break;
            }
            case 't': {
                this.showThreads();
                break;
            }
            case 'x': {
                KJASAppletClassLoader.removeLoaders();
                this.append("Emptied Classloader Cache\n", true);
            }
        }
    }

    private void showHelp() {
        SecurityManager securityManager;
        this.append("Java VM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + "\n", true);
        String string = System.getProperty("http.proxyHost");
        if (string != null) {
            this.append("Proxy: " + string + ":" + System.getProperty("java.proxyPort") + "\n", true);
        }
        if ((securityManager = System.getSecurityManager()) == null) {
            this.append("WARNING: Security Manager disabled!\n", true);
        } else {
            this.append("SecurityManager=" + securityManager + "\n", true);
        }
        this.appendSeparator();
        this.append("Konqueror Java Console Help\n", true);
        this.append("  c: clear console\n", true);
        this.append("  g: run garbage collection\n", true);
        this.append("  h: show help\n", true);
        this.append("  m: show memory info\n", true);
        this.append("  s: print system properties\n", true);
        this.append("  t: list threads\n", true);
        this.append("  x: empty classloader cache\n", true);
        this.appendSeparator();
    }

    private void showSystemProperties() {
        this.append("Printing System Properties ...\n", true);
        this.appendSeparator();
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if ("line.separator".equals(object)) {
                String string = (String)properties.get(object);
                StringBuffer stringBuffer = new StringBuffer(10);
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\n') {
                        stringBuffer.append("\\n");
                        continue;
                    }
                    if (c == '\r') {
                        stringBuffer.append("\\n");
                        continue;
                    }
                    stringBuffer.append(c);
                }
                this.append(object + " = " + stringBuffer + "\n", true);
                continue;
            }
            this.append(object + " = " + properties.get(object) + "\n", true);
        }
        this.appendSeparator();
    }

    private void showThreads() {
        ThreadGroup threadGroup;
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup2 = thread.getThreadGroup();
        while ((threadGroup = threadGroup2.getParent()) != null) {
            threadGroup2 = threadGroup;
        }
        threadGroup2.list();
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        this.textField.selectAll();
        this.textField.copy();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.frame.setVisible(false);
    }

    private void clearButtonActionPerformed(ActionEvent actionEvent) {
        this.clear();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.frame.setVisible(false);
    }

    public void setVisible(boolean bl) {
        if (this.frame == null && bl) {
            this.initComponents();
            this.frame.setVisible(bl);
            System.out.println("Java VM version: " + System.getProperty("java.version"));
            System.out.println("Java VM vendor:  " + System.getProperty("java.vendor"));
            String string = System.getProperty("http.proxyHost");
            String string2 = System.getProperty("http.proxyPort");
            if (string != null) {
                System.out.println("Proxy: " + string + ":" + string2);
            }
            SecurityManager securityManager = System.getSecurityManager();
            Main.debug("SecurityManager=" + securityManager);
            if (securityManager == null) {
                System.out.println("WARNING: Security Manager disabled!");
                this.textField.setForeground(Color.red);
            }
            this.showHelp();
        } else if (this.frame != null) {
            this.frame.setVisible(bl);
        }
        if (bl) {
            for (int i = 0; i < 3; ++i) {
                if (this.output_buffer[(this.queue_pos + i + 1) % 3] == null) continue;
                this.textField.append(this.output_buffer[(this.queue_pos + i + 1) % 3].toString());
                this.output_buffer[(this.queue_pos + i + 1) % 3] = null;
            }
        }
    }

    public static void main(String[] stringArray) {
        new KJASSwingConsole().setVisible(true);
    }

    public void clear() {
        this.textField.setText("");
    }

    private void appendSeparator() {
        this.append("----------------------------------------------------\n", true);
    }

    public void append(String string) {
        this.append(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String string, boolean bl) {
        if (string == null) {
            return;
        }
        if (this.frame == null || !this.frame.isVisible()) {
            if (Main.Debug) {
                this.real_stderr.print(string);
            }
            if (this.output_buffer[this.queue_pos] != null && this.output_buffer[this.queue_pos].length() > 3000) {
                ++this.queue_pos;
                this.queue_pos %= 3;
                if (this.output_buffer[this.queue_pos] != null) {
                    if (this.frame != null) {
                        this.textField.setText("");
                    }
                    this.output_buffer[this.queue_pos] = null;
                }
            }
            if (this.output_buffer[this.queue_pos] == null) {
                this.output_buffer[this.queue_pos] = new StringBuffer(string);
            } else {
                this.output_buffer[this.queue_pos].append(string);
            }
            return;
        }
        int n = string.length();
        JTextArea jTextArea = this.textField;
        synchronized (jTextArea) {
            int n2 = this.textField.getCaretPosition();
            this.textField.append(string);
            this.textField.setCaretPosition(n2 + n);
        }
    }
}

