;;; ZIRANMA.el  -*- lexical-binding:t -*-
;; Quail package `chinese-ziranma'
;;   Generated by the command `miscdic-convert'
;;   Source dictionary file: ziranma.cin
;;   Copyright notice of the source file
;;------------------------------------------------------
;; "ziranma.cin" is included in a free package called CCE.  It is
;; available at: [link needs updating  -- SK 2021-09-27]
;;	https://ftp.debian.org/debian/dists/potato/main
;;		/source/utils/cce_0.36.orig.tar.gz
;; This package contains the following copyright notice.
;;
;;
;;             Copyright (C) 1999, Rui He, herui@cs.duke.edu
;;
;;
;;                  CCE(Console Chinese Environment) 0.32
;;
;; CCE is free software; you can redistribute it and/or modify it under the
;; terms of the GNU General Public License as published by the Free Software
;; Foundation; either version 1, or (at your option) any later version.
;;
;; CCE is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
;; FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
;; details.
;;
;; You should have received a copy of the GNU General Public License along with
;; CCE.  If not, see <https://www.gnu.org/licenses/>.
;;------------------------------------------------------

;;; Code:

(require 'quail)
(quail-define-package "chinese-ziranma" "Chinese-GB" "自然" t
"汉字输入∷【自然】∷

                            键盘对照表:
 ┏━━┳━━┳━━┳━━┳━━┳━━┳━━┳━━┳━━┳━━┓
 ┃Ｑ  ┃Ｗ  ┃Ｅ  ┃Ｒ  ┃Ｔ  ┃Ｙ  ┃Ｕsh┃Ｉch┃Ｏ  ┃Ｐ  ┃
 ┃  iu┃  ua┃   e┃ uan┃  ue┃ uai┃   u┃   i┃   o┃  un┃
 ┃    ┃  ia┃    ┃ van┃  ve┃ ing┃    ┃    ┃  uo┃  vn┃
 ┗┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┛
   ┃Ａ  ┃Ｓ  ┃Ｄ  ┃Ｆ  ┃Ｇ  ┃Ｈ  ┃Ｊ  ┃Ｋ  ┃Ｌ  ┃
   ┃   a┃iong┃uang┃  en┃ eng┃ ang┃  an┃  ao┃  ai┃
   ┃    ┃ ong┃iang┃    ┃  ng┃    ┃    ┃    ┃    ┃
   ┗┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━┻┳━━┓
     ┃Ｚ  ┃Ｘ  ┃Ｃ  ┃Ｖzh┃Ｂ  ┃Ｎ  ┃Ｍ  ┃，  ┃．  ┃ ／ ┃
     ┃  ei┃  ie┃ iao┃  ui┃  ou┃  in┃ ian┃前页┃后页┃符号┃
     ┃    ┃    ┃    ┃   v┃    ┃    ┃    ┃    ┃    ┃    ┃
     ┗━━┻━━┻━━┻━━┻━━┻━━┻━━┻━━┻━━┻━━┛


Pinyin base input method for Chinese GB2312 characters (`chinese-gb2312').

Pinyin is the standard roman transliteration method for Chinese.
For the details of Pinyin system, see the documentation of the input
method `chinese-py'.

Unlike the standard spelling of Pinyin, in this input method all
initials and finals are assigned to single keys (see the above table).
For instance, the initial \"ch\" is assigned to the key `i', the final
\"iu\" is assigned to the key `q', and tones 1, 2, 3, 4, and 轻声 are
assigned to the keys `q', `w', `e', `r', `t' respectively.

\\<quail-translation-docstring>

To input one-letter words, you type 4 keys, the first two for the
Pinyin of the letter, next one for tone, and the last one is always a
quote (').  For instance, \"vsq'\" input 中.  Exceptions are these
letters.  You can input them just by typing a single key.

	Character: 按 不 次 的 二 发 个 和 出 及 可 了 没
	Key:	   a  b  c  d  e  f  g  h  i  j  k  l  m
	Character: 你 欧 片 七 人 三 他 是 着 我 小 一 在
	Key:	   n  o  p  q  r  s  t  u  v  w  x  y  z

To input two-letter words, you have two ways.  One way is to type 4
keys, two for the first Pinyin, two for the second Pinyin.  For
instance, \"vsgo\" inputs 中国.  Another way is to type 3 keys: 2
initials of two letters, and quote (').  For instance, \"vg'\" also
inputs 中国.

To input three-letter words, you type 4 keys: initials of three
letters, and the last is quote (').  For instance, \"bjy'2\" inputs 北
京鸭 (the last `2' is to select one of the candidates).

To input words of more than three letters, you type 4 keys, initials
of the first three letters and the last letter.  For instance,
\"bjdt\" inputs 北京电视台.

To input symbols and punctuation, type `/' followed by one of `a' to
`z', then select one of the candidates."
  '(("" . quail-delete-last-char)
   ("." . quail-next-translation)
   ("[" . quail-next-translation)
   ("," . quail-prev-translation)
   ("]" . quail-prev-translation))
  nil nil nil nil)

(quail-define-rules
("/a" "ａＡ☆★○●◎◇◆□■△▲※〓→←↑↓♂♀°¤‰§№")
("/b" "ｂＢ，＜、〈《≮≤")
("/c" "ｃＣ─━│┃┄┅┆┇┈┉┊┋┌┍┎┏┐┑┒┓└┕┖┗┘┙┚┛├┝┞┟┠┡┢┣")
("/d" "ｄＤ")
("/e" "ｅＥ３＃～｀⒊⒔⑶⒀③㈢Ⅲ￣∽∝∞‘’")
("/f" "ｆＦ")
("/g" "ｇＧ")
("/h" "ｈＨ")
("/i" "ｉＩ８＊－＿＝＋＼｜⒏⒙⑻⒅⑧㈧Ⅷ×∏∩ˉ―～⊥≠≈≡≌±∑∨∪‖∥")
("/j" "ｊＪ；：∷")
("/k" "ｋＫ＇＂‘’′“”″＠⊙")
("/l" "ｌＬ～｀＃‘’￣∽∝∞")
("/m" "ｍＭ／？÷√")
("/n" "ｎＮ．＞。・¨…∵∴°⊙〉》≯≥")
("/o" "ｏＯ９（［｛⒐⒚⑼⒆⑨㈨Ⅸ「『〔〖【")
("/p" "ｐＰ０）］｝⒑⒛⑽⒇⑩㈩Ⅹ」』〕〗】")
("/q" "ｑＱ１！＼｜⒈⒒⑴⑾①㈠Ⅰ‖∥")
("/r" "ｒＲ４￥⒋⒕⑷⒁④㈣Ⅳ＄￠￡")
("/s" "ｓＳ☆★○●◎◇◆□■△▲※〓→←↑↓♂♀°¤‰§№")
("/t" "ｔＴ５％⒌⒖⑸⒂⑤㈤Ⅴ‰")
("/u" "ｕＵ７＆⒎⒘⑺⒄⑦㈦Ⅶ")
("/v" "ｖＶ┤┥┦┧┨┩┪┫┬┭┮┯┰┱┲┳┴┵┶┷┸┹┺┻┼┽┾┿╀╁╂╃╄╅╆╇╈╉╊╋")
("/w" "ｗＷ２＠＇＂⒉⒓⑵⑿②㈡Ⅱ⊙‘’′“”″")
("/x" "ｘＸｚＺ　｜＼‖∥")
("/y" "ｙＹ６＾＜＞，．、。⒍⒗⑹⒃⑥㈥Ⅵˇ⌒〈《≮≤〉》≯≥・¨…∵∴°⊙")
("a" "按")
("aaba" ["阿爸"])
("aabk" ["阿宝"])
("aae'" "啊呵")
("aaer" ["阿尔"])
("aaha" ["啊哈"])
("aajj" ["安安静静"])
("aali" ["阿里"])
("aamj" ["阿曼"])
("aamk" ["阿毛"])
("aamy" ["阿明"])
("aapo" ["阿婆"])
("aaq'" "啊阿呵吖腌锕")
("aar'" "啊呵")
("aat'" "啊阿呵")
("aaw'" "啊呵嗄")
("aayi" ["阿姨"])
("abbd" ["按兵不动"])
("abjb" ["按步就班"])
("ablv" ["按比例发展"])
("abvb" ["阿布扎比"])
("ad'" ["安定"])
("adl'" ["暗地里" "奥地利"])
("adly" ["澳大利亚"])
("adsm" ["安第斯山脉"])
("adsu" ["安第斯山"])
("adu'" ["爱迪生"])
("aebm" ["阿尔卑斯山脉"])
("aeby" ["阿尔巴尼亚"])
("aeje" ["阿尔及尔"])
("aejy" ["阿尔及利亚"])
("ael'" ["爱尔兰"])
("aetu" ["阿尔泰山"])
("afh'" ["阿富汗"])
("afuj" ["安分守己"])
("agd'" ["按规定"])
("aggv" ["昂贵"])
("agl'" ["安哥拉"])
("agq'" "肮")
("agr'" "盎")
("agrj" ["盎然"])
("agru" ["爱国人士"])
("agsd" ["奥古斯丁"])
("agsi" ["盎司"])
("agt'" ["阿根廷"])
("agub" ["昂首"])
("agvy" ["爱国主义"])
("agw'" "昂")
("agwd" ["爱国卫生运动"])
("agyh" ["昂扬"])
("agzh" ["肮脏"])
("agzw" ["矮秆作物"])
("ahu'" ["安徽省"])
("ahv'" ["爱好者"])
("aibj" ["呆板"])
("aida" ["挨打" "捱打"])
("aidk" ["哀悼" "捱到"])
("aidl" ["爱戴"])
("aie'" "哎蔼矮嗳霭")
("aiee" ["挨饿" "捱饿"])
("aifu" ["爱抚"])
("aige" ["哀歌" "矮个"])
("aigo" ["爱国"])
("aihk" ["哀号" "爱好"])
("aihu" ["爱护"])
("aiib" ["哀愁"])
("aiji" ["埃及"])
("aijn" ["捱近"])
("ailm" ["爱恋"])
("aima" ["挨骂"])
("aimn" ["爱民"])
("aimu" ["爱慕"])
("aimy" ["哀鸣"])
("aimz" ["暧昧"])
("aiq'" "埃挨哎唉哀捱锿")
("aiqq" ["哀求"])
("aiqy" ["爱情"])
("air'" "哎唉艾碍爱隘嗳嗌嫒瑷暧砹")
("airf" ["爱人"])
("aisi" ["哀思"])
("aitj" ["哀叹"])
("aits" ["哀痛"])
("aiuh" ["哀伤" "爱上"])
("aiui" ["碍事"])
("aive" ["捱着"])
("aivg" ["癌症"])
("aiw'" "挨皑癌呆捱")
("aixc" ["矮小"])
("aixi" ["爱惜"])
("aiya" ["哎呀" "唉呀"])
("aiyo" ["哎哟"])
("aiyt" ["哀乐"])
("aizg" ["爱憎"])
("aizi" ["艾子"])
("aj'" ["安静"])
("ajh'" ["按计划"])
("ajlh" ["安家落户"])
("ajly" ["安居乐业"])
("ajs'" ["氨基酸"])
("ajsl" ["氨基塑料"])
("akl'" ["安卡拉"])
("albd" ["阿拉伯半岛"])
("albr" ["阿拉伯人"])
("alfp" ["按劳分配"])
("alft" ["阿拉法特"])
("alh'" ["安理会"])
("alqi" ["按劳取酬"])
("alu'" ["安禄山"])
("amj'" ["凹面镜"])
("anan" ["暗暗"])
("anbk" ["暗堡"])
("anbm" ["岸边"])
("anch" ["暗藏"])
("anci" ["按次"])
("andj" ["暗淡"])
("andp" ["安顿"])
("ands" ["安东"])
("andy" ["安定"])
("ane'" "俺埯揞铵")
("anfh" ["安放"])
("anfu" ["安福" "安抚"])
("angh" ["鞍钢"])
("ango" ["安国"])
("angr" ["暗管"])
("anhk" ["暗号"])
("anhl" ["暗害"])
("anhv" ["安徽"])
("anhw" ["氨化"])
("ania" ["安插"])
("anjc" ["暗礁"])
("anji" ["氨基"])
("anjm" ["案件"])
("anjr" ["案卷"])
("anju" ["安居"])
("anjw" ["安家"])
("anjy" ["安静"])
("anle" ["安乐"])
("anli" ["按理"])
("anlq" ["暗流"])
("anma" ["鞍马"])
("anmf" ["俺们"])
("anmm" ["安眠"])
("anmn" ["安民"])
("anmo" ["按摩"])
("anna" ["安娜" "按捺"])
("annj" ["安南"])
("annq" ["按钮"])
("anny" ["安宁"])
("anpl" ["安排"])
("anpz" ["安培"])
("anq'" "鞍氨安厂广谙庵桉鹌")
("anqi" ["按期"])
("anqr" ["安全"])
("anqy" ["案情"])
("anr'" "按暗岸胺案犴黯")
("anrj" ["安然"])
("anua" ["暗杀"])
("anuf" ["安身"])
("anug" ["安生"])
("anui" ["按时" "暗示" "暗室"])
("anuj" ["鞍山"])
("anuo" ["按说"])
("anuu" ["桉树"])
("anuv" ["氨水"])
("anvd" ["安装"])
("anvi" ["安置"])
("anvk" ["按照"])
("anvs" ["暗中"])
("anwf" ["安稳"])
("anwz" ["安危" "安慰"])
("anxc" ["暗笑"])
("anxd" ["安祥"])
("anxi" ["安息"])
("anxm" ["安闲" "暗线"])
("anxn" ["安心"])
("anya" ["按压"])
("anyh" ["安阳"])
("anyi" ["安逸"])
("anyj" ["铵盐"])
("anyr" ["安源"])
("anyu" ["安于" "按语"])
("anzh" ["安葬"])
("anzi" ["暗自" "案子"])
("aobl" ["鳌拜"])
("aoe'" "袄拗媪")
("aogo" ["熬过"])
("aohv" ["懊悔"])
("aojn" ["凹进"])
("aoln" ["奥林"])
("aomc" ["奥妙"])
("aomf" ["澳门"])
("aomi" ["奥秘"])
("aomj" ["傲慢"])
("aonk" ["懊恼"])
("aoq'" "凹熬")
("aor'" "傲奥懊澳坳拗岙骜鏊")
("aosh" ["懊丧"])
("aotb" ["凹透"])
("aotu" ["凹凸"])
("aovb" ["澳洲"])
("aow'" "敖熬翱嚣嗷廒遨獒聱螯鳌鏖")
("aoxd" ["翱翔"])
("aoxm" ["凹陷"])
("aoyb" ["遨游"])
("aoye" ["熬夜"])
("aoyk" ["熬药"])
("ap'" ["安排"])
("aq'" ["安全"])
("aqcu" ["安全措施"])
("aqd'" ["安全带"])
("aqf'" ["安全阀"])
("aqji" ["安全检查"])
("aqlh" ["安全理事会"])
("aqui" ["安全生产"])
("aqxu" ["安全系数"])
("asey" ["埃塞俄比亚"])
("ashe" ["艾森豪威尔"])
("ast'" ["奥斯特"])
("au'" ["按时"])
("autq" ["唉声叹气"])
("auvl" ["安史之乱"])
("auwi" ["按时完成"])
("av'" ["按照"])
("avny" ["阿扎尼亚"])
("axfp" ["按需分配"])
("ayh'" ["奥运会"])
("ayst" ["爱因斯坦"])
("b" "不")
("baba" ["巴巴" "爸爸"])
("babk" ["八宝"])
("babl" ["八百"])
("baby" ["把柄"])
("baci" ["八次"])
("back" ["拔草"])
("bad'" ["保安队"])
("badb" ["笆斗"])
("badc" ["拔掉"])
("badk" ["霸道"])
("badp" ["巴顿"])
("bae'" "靶把钯")
("bael" ["北爱尔兰"])
("baer" ["把儿"])
("baff" ["八分"])
("bafg" ["把风"])
("bafh" ["八方"])
("bage" ["八个"])
("bagr" ["把关" "罢官"])
("bags" ["罢工"])
("bagu" ["八股"])
("bahe" ["巴赫" "拔河"])
("bahf" ["疤痕"])
("bahu" ["八户"])
("baie" ["扒车"])
("baig" ["八成"])
("baih" ["靶场"])
("baii" ["把持"])
("baiu" ["拔除" "罢黜"])
("bajc" ["芭蕉" "八角" "罢教"])
("bajm" ["拔尖"])
("bajq" ["把酒"])
("bajw" ["八家" "把家"])
("bajx" ["八节" "巴结" "拔节"])
("bake" ["罢课"])
("bakl" ["扒开"])
("baku" ["巴库"])
("balc" ["罢了"])
("bald" ["八两"])
("bali" ["巴黎"])
("baln" ["巴林"])
("balu" ["八路"])
("balz" ["芭蕾"])
("bamf" ["把门"])
("bamm" ["罢免"])
("bani" ["巴尼"])
("baq'" "芭捌扒叭吧笆八疤巴岜粑")
("baqi" ["八旗"])
("baqm" ["八千"])
("baqr" ["霸权"])
("bar'" "把耙坝霸罢爸灞鲅")
("barj" ["拔染"])
("bat'" "吧罢")
("baub" ["把手" "把守"])
("baue" ["跋涉"])
("baui" ["八十" "把式" "罢市"])
("bauj" ["巴山"])
("bavh" ["巴掌"])
("bavj" ["霸占"])
("bavu" ["霸主"])
("baw'" "八拔跋茇菝魃")
("bawh" ["霸王"])
("bawo" ["把握"])
("baxi" ["巴西" "把戏"])
("baxq" ["罢休"])
("baya" ["拔牙"])
("baye" ["霸业"])
("bayt" ["八月"])
("bazi" ["八字" "靶子" "把子" "坝子"])
("bb'" ["并把"])
("bbd'" ["巴不得" "办不到"])
("bbjl" ["变本加厉"])
("bbju" ["比比皆是"])
("bbku" ["必不可少"])
("bbl'" ["巴比伦"])
("bbm'" ["比表面"])
("bbq'" ["北半球"])
("bbt'" ["半边天"])
("bbu'" ["比不上" "并不是"])
("bbv'" ["保不住"])
("bbw'" ["北部湾"])
("bbx'" ["八边形" "被剥削" "本报讯"])
("bbxj" ["被剥削阶级"])
("bbxr" ["被保险人"])
("bby'" ["北冰洋" "不必要"])
("bbz'" ["半辈子"])
("bbzb" ["不变资本"])
("bc'" ["并从"])
("bcbc" ["表表"])
("bcbf" ["标本"])
("bcbh" ["标榜"])
("bcbi" ["表笔"])
("bcbk" ["表报"])
("bcbl" ["表白"])
("bcby" ["标兵"])
("bccg" ["表层"])
("bcda" ["表达"])
("bcdg" ["标灯"])
("bcdi" ["标的"])
("bcdm" ["标点"])
("bcdy" ["标定"])
("bce'" "表婊裱")
("bcfz" ["膘肥"])
("bcge" ["表格"])
("bcgj" ["标杆"])
("bcgk" ["标高"])
("bcgm" ["本草纲目"])
("bcgr" ["表观"])
("bchk" ["标号"])
("bcii" ["标尺"])
("bcji" ["标记"])
("bcjt" ["表决"])
("bcjw" ["标价"])
("bcld" ["标量"])
("bcli" ["表里"])
("bclu" ["表露"])
("bcmm" ["表面"])
("bcmy" ["标明" "表明"])
("bcmz" ["表妹"])
("bcpi" ["表皮"])
("bcpj" ["表盘"])
("bcq'" "标彪膘勺骠杓飑飙飚镖镳瘭髟")
("bcqd" ["标枪"])
("bcqm" ["标签"])
("bcqy" ["表情"])
("bcr'" "鳔")
("bctb" ["表头"])
("bcti" ["标题"])
("bctl" ["表态"])
("bcts" ["标统"])
("bctu" ["表土"])
("bcui" ["表示"])
("bcuu" ["表述"])
("bcuy" ["表率"])
("bcvf" ["表针"])
("bcvh" ["表章" "表彰"])
("bcvi" ["标志"])
("bcvp" ["标准"])
("bcwn" ["博茨瓦纳"])
("bcwz" ["表尾"])
("bcxd" ["表象"])
("bcxm" ["表现"])
("bcxy" ["彪形"])
("bcyh" ["表扬"])
("bcyj" ["表演"])
("bcyu" ["标语"])
("bd'" ["不但"])
("bdb'" ["不得不"])
("bdd'" ["办得到" "别动队" "不道德"])
("bddj" ["不大对劲"])
("bdei" ["背道而驰"])
("bdev" ["不得而知"])
("bdf'" ["贝多芬"])
("bdfh" ["标点符号"])
("bdg'" ["波导管" "不定根"])
("bdgl" ["彼得格勒"])
("bdgm" ["不断革命"])
("bdgs" ["毕达哥拉斯"])
("bdh'" ["北大荒" "北戴河" "不等号"])
("bdi'" ["白帝城" "不动产"])
("bdj'" ["不多见"])
("bdjh" ["不等价交换"])
("bdl'" ["背地里" "不得了"])
("bdlg" ["波多黎各" "布达拉宫"])
("bdps" ["布达佩斯"])
("bdq'" ["不定期"])
("bdrx" ["不得人心"])
("bds'" ["变电所"])
("bdt'" ["半导体" "不对头"])
("bdu'" ["不但是" "不等式"])
("bdus" ["不动声色"])
("bdy'" ["不得已"])
("bdyu" ["彼得一世"])
("bedy" ["波尔多液"])
("beg'" ["巴尔干"])
("begd" ["贝尔格莱德"])
("bels" ["白俄罗斯"])
("ben'" ["伯尔尼"])
("beqy" ["布尔乔亚"])
("beuk" ["布尔什维克"])
("bf'" ["部分"])
("bfan" ["苯胺"])
("bfb'" ["百分比"])
("bfbf" ["本本"])
("bfbk" ["本报"])
("bfbo" ["奔波"])
("bfbu" ["本部"])
("bfcc" ["白发苍苍"])
("bfck" ["本草"])
("bfdi" ["本地"])
("bfdj" ["笨蛋"])
("bfdv" ["本队"])
("bfe'" "苯本畚")
("bfer" ["本儿"])
("bfff" ["苯酚" "本分"])
("bffh" ["奔放"])
("bffu" ["奔赴"])
("bfgo" ["本国"])
("bfh'" ["暴发户"])
("bfhh" ["本行"])
("bfhr" ["苯环"])
("bfhv" ["本会"])
("bfii" ["奔驰"])
("bfj'" ["半封建" "北伐军"])
("bfjd" ["半封建半殖民地"])
("bfji" ["苯基"])
("bfju" ["本句"])
("bfjw" ["本家"])
("bfjx" ["本届" "百废具兴"])
("bfke" ["本科"])
("bfl'" ["百分率"])
("bfli" ["本利"])
("bfll" ["本来"])
("bflp" ["本论"])
("bflq" ["奔流"])
("bfly" ["本领"])
("bflz" ["本垒"])
("bfmh" ["奔忙"])
("bfmo" ["本末"])
("bfng" ["本能"])
("bfnm" ["本年"])
("bfpc" ["本票"])
("bfpk" ["奔跑"])
("bfq'" "奔贲锛")
("bfqi" ["本期"])
("bfqm" ["本钱"])
("bfr'" ["奔" "笨" "夯" "坌" "北方人"])
("bfrf" ["本人"])
("bfse" ["本色"])
("bfso" ["本所"])
("bftg" ["奔腾"])
("bfti" ["本题" "本体"])
("bftl" ["本台"])
("bftu" ["本土"])
("bfu'" ["百分数"])
("bfuf" ["本身"])
("bfug" ["本生"])
("bfui" ["本事" "本市"])
("bfuu" ["本书"])
("bfv'" ["百分之"])
("bfvb" ["百分之百" "本周" "本州"])
("bfve" ["本着"])
("bfvi" ["本职" "本质"])
("bfvo" ["笨拙"])
("bfvs" ["笨重"])
("bfvu" ["本主"])
("bfvv" ["北伐战争"])
("bfwf" ["本文"])
("bfwz" ["本位"])
("bfx'" ["暴风雪"])
("bfxd" ["奔向"])
("bfxi" ["本溪"])
("bfxn" ["本心"])
("bfxy" ["本性"])
("bfy'" ["暴风雨"])
("bfye" ["本业"])
("bfyf" ["八分音符"])
("bfyi" ["本意"])
("bfyr" ["本源"])
("bfyt" ["本月"])
("bfzb" ["奔走"])
("bfzi" ["本子"])
("bg'" ["报告"])
("bgbd" ["半工半读"])
("bgbg" ["不管不顾"])
("bgbu" ["蚌埠"])
("bgd'" ["巴格达" "波哥大" "不敢当"])
("bgdl" ["绷带"])
("bgdt" ["不共戴天"])
("bge'" ["绷" "冰棍儿"])
("bgfa" ["迸发"])
("bgi'" ["兵工厂"])
("bgjn" ["绷紧"])
("bgkv" ["崩溃"])
("bglh" ["不甘落后"])
("bglj" ["八国联军"])
("bglx" ["崩裂" "迸裂"])
("bgn'" ["布谷鸟"])
("bgq'" "崩绷嘣")
("bgr'" ["蚌" "绷" "泵" "蹦" "迸" "甏" "被告人"])
("bgt'" ["办公厅"])
("bgta" ["崩塌"])
("bgu'" ["办公室" "不干涉"])
("bgvc" ["闭关政策"])
("bgw'" "甭")
("bgwx" ["报告文学"])
("bgx'" ["不甘心"])
("bgyq" ["不顾一切"])
("bgz'" ["不规则"])
("bgzu" ["闭关自守"])
("bh'" ["变化"])
("bhbf" ["邦本"])
("bhbj" ["帮办"])
("bhd'" ["保皇党" "饱和点" "饱和度" "北海道"])
("bhdl" ["饱和电流" "闭合电路"])
("bhe'" "榜膀绑")
("bhel" ["不寒而栗"])
("bhg'" ["保护国"])
("bhgd" ["膀胱"])
("bhgs" ["百货公司" "帮工"])
("bhgu" ["保护关税"])
("bhh'" ["白花花" "不含糊"])
("bhhv" ["帮会"])
("bhig" ["磅秤"])
("bhjc" ["邦交"])
("bhjw" ["绑架"])
("bhke" ["蚌壳"])
("bhlm" ["邦联"])
("bhmh" ["帮忙"])
("bhpl" ["帮派"])
("bhq'" ["邦" "帮" "梆" "浜" "变换器" "辩护权"])
("bhqd" ["帮腔"])
("bhqf" ["百花齐放"])
("bhqq" ["棒球"])
("bhr'" ["膀" "棒" "磅" "蚌" "镑" "傍" "谤" "蒡" "保护人" "被害人" "辩护人"])
("bhry" ["饱和溶液"])
("bhtv" ["绑腿"])
("bhu'" ["辩护士"])
("bhub" ["帮手" "榜首"])
("bhud" ["百货商店"])
("bhuy" ["饱和水汽压" "不合时宜"])
("bhvt" ["饱和状态"])
("bhvu" ["帮助"])
("bhw'" ["白话文" "渤海湾"])
("bhwj" ["傍晚"])
("bhxs" ["帮凶"])
("bhyh" ["榜样"])
("bhys" ["不好意思"])
("bhzi" ["梆子" "膀子" "棒子"])
("bi'" ["保持"])
("bian" ["彼岸"])
("bibh" ["臂膀"])
("bibi" ["比比"])
("bibk" ["壁报"])
("bibl" ["必败"])
("bibo" ["碧波"])
("biby" ["弊病"])
("bici" ["彼此"])
("bid'" ["白炽灯"])
("bidb" ["鼻痘"])
("bidc" ["笔调"])
("bide" ["逼得" "彼得" "必得"])
("bidh" ["包产到户"])
("bidr" ["弊端"])
("bidv" ["比对"])
("bidy" ["必定"])
("bie'" "比鄙笔彼匕俾吡妣秕舭")
("bier" ["比尔"])
("bifa" ["笔法"])
("biff" ["比分"])
("bifg" ["笔锋" "避风"])
("bifh" ["比方"])
("bifu" ["比附"])
("bigj" ["笔杆"])
("bigk" ["比高"])
("bigr" ["闭关"])
("bigs" ["逼供"])
("bih'" ["病虫害"])
("bihe" ["闭合"])
("bihu" ["庇护" "壁虎"])
("bihv" ["闭会"])
("bihw" ["笔画" "壁画"])
("biiu" ["笔触" "壁橱"])
("bijc" ["比较"])
("bijd" ["必将"])
("biji" ["笔迹" "笔记" "哔叽"])
("bijm" ["鼻尖" "笔尖"])
("bijn" ["逼近"])
("bijt" ["保持警惕"])
("bijw" ["比价"])
("bijy" ["毕竟"])
("bikb" ["闭口"])
("bikl" ["避开"])
("biks" ["鼻孔"])
("bilc" ["毙了"])
("bild" ["鼻梁"])
("bili" ["比例" "笔力"])
("bilr" ["避乱"])
("bilu" ["笔录" "壁炉" "秘鲁"])
("bilv" ["比率" "碧绿"])
("bilz" ["壁垒"])
("bima" ["蓖麻"])
("bimf" ["闭门"])
("bimm" ["避免"])
("bimo" ["笔墨"])
("bimu" ["闭幕"])
("bimy" ["笔名" "毙命"])
("bing" ["必能"])
("bini" ["比拟"])
("binj" ["避难"])
("binm" ["比年"])
("bip'" ["半成品"])
("bipo" ["逼迫"])
("biq'" "逼")
("biqd" ["鼻腔"])
("biqi" ["比起"])
("bir'" "碧蓖蔽毕毙毖币庇痹闭敝弊必辟壁臂避陛拂秘泌埤芘荜萆薜哔狴庳愎滗濞弼婢嬖璧贲畀铋裨筚箅篦襞跸髀")
("bire" ["比热"])
("birf" ["逼人" "鄙人"])
("birj" ["必然"])
("birs" ["比容"])
("biru" ["比如"])
("bise" ["闭塞"])
("bisi" ["逼死"])
("bisl" ["比赛"])
("bita" ["比他" "比它" "比她"])
("bitb" ["笔头"])
("biti" ["鼻涕"])
("bitk" ["笔套"])
("bitl" ["宝成铁路"])
("biu'" ["被乘数" "被除数"])
("biub" ["匕手"])
("biue" ["笔舌"])
("biug" ["毕生" "毕升" "必胜"])
("biui" ["比试" "鄙视"])
("biuk" ["比绍"])
("biup" ["笔顺"])
("biuu" ["避暑"])
("bive" ["笔者"])
("bivf" ["逼真"])
("bivg" ["痹症"])
("bivi" ["比值" "笔直" "币值" "币制"])
("bivk" ["比照"])
("bivs" ["比重"])
("biw'" "鼻荸")
("biwo" ["比我"])
("bix'" ["北朝鲜"])
("bixi" ["鼻息"])
("bixq" ["必修"])
("bixu" ["必需" "必须"])
("bixw" ["笔下" "陛下"])
("bixx" ["避邪"])
("bixy" ["笔形"])
("biye" ["毕业"])
("biyi" ["鄙夷"])
("biyj" ["鼻烟"])
("biyk" ["必要"])
("biyn" ["鼻音"])
("biyp" ["避孕"])
("biyu" ["比喻" "碧玉"])
("bizi" ["鼻子" "箅子"])
("bizo" ["比做"])
("bj'" ["北京"])
("bjan" ["办案"])
("bjb'" ["编辑部"])
("bjbf" ["版本"])
("bjbi" ["半壁"])
("bjbj" ["斑斑"])
("bjbk" ["板报"])
("bjbl" ["斑白"])
("bjbm" ["半边"])
("bjbu" ["颁布" "半部"])
("bjc'" ["边界层"])
("bjci" ["班次"])
("bjcl" ["板材"])
("bjd'" ["不简单" "不见得"])
("bjda" ["半大"])
("bjdg" ["板凳"])
("bjdk" ["半岛" "办到"])
("bjdm" ["斑点" "半点"])
("bjds" ["搬动"])
("bjdt" ["北京电视台"])
("bjdx" ["北京大学"])
("bje'" "板版阪坂钣舨")
("bjfa" ["颁发" "办法"])
("bjge" ["半个"])
("bjgs" ["办公"])
("bjgu" ["班固"])
("bjhk" ["办好"])
("bjho" ["办货"])
("bjhu" ["板胡"])
("bjhw" ["版画"])
("bji'" ["捕鲸船"])
("bjie" ["班车"])
("bjih" ["半场"])
("bjij" ["班禅"])
("bjj'" ["不仅仅" "不经济"])
("bjjc" ["半角"])
("bjji" ["班机" "班级"])
("bjjn" ["半斤"])
("bjju" ["不仅仅是"])
("bjjw" ["搬家"])
("bjjx" ["板结" "半截"])
("bjjy" ["半径"])
("bjkl" ["搬开"])
("bjky" ["北京烤鸭"])
("bjl'" ["边角料" "不见了"])
("bjli" ["板栗" "办理"])
("bjlt" ["布加勒斯特"])
("bjlu" ["半路"])
("bjlv" ["伴侣"])
("bjly" ["保加利亚"])
("bjm'" ["不结盟"])
("bjma" ["斑马"])
("bjmd" ["不结盟运动"])
("bjmj" ["不结盟国家"])
("bjmm" ["版面"])
("bjmo" ["瓣膜"])
("bjnm" ["半年"])
("bjpz" ["般配"])
("bjq'" ["斑" "班" "搬" "扳" "般" "颁" "瘢" "癍" "表决权" "不景气"])
("bjqi" ["办起"])
("bjqq" ["半球" "并驾齐驱"])
("bjqr" ["版权"])
("bjqu" ["不计其数"])
("bjr'" ["扮" "拌" "伴" "瓣" "半" "办" "绊" "不尽然"])
("bjri" ["半日"])
("bjs'" ["苯甲酸"])
("bjsi" ["半死"])
("bjst" ["巴基斯坦" "北京四通"])
("bjsv" ["伴随"])
("bjtj" ["不讲条件"])
("bjtl" ["步军统领"])
("bjtm" ["半天"])
("bjtu" ["版图" "半途"])
("bju'" ["绊脚石" "北京市" "被加数" "被减数"])
("bjub" ["扳手"])
("bjug" ["半生"])
("bjuh" ["半晌"])
("bjui" ["半世" "办事"])
("bjuu" ["版书" "半数"])
("bjuv" ["版税"])
("bjv'" ["八进制"])
("bjvd" ["本机振荡"])
("bjve" ["伴着"])
("bjvh" ["班长"])
("bjvm" ["百家争鸣"])
("bjvq" ["本机振荡器"])
("bjvs" ["拌种"])
("bjwf" ["斑纹"])
("bjwt" ["边界问题"])
("bjx'" ["北极星"])
("bjxj" ["不拘小节"])
("bjxt" ["办学"])
("bjxy" ["颁行"])
("bjy'" ["白居易" "北京鸭"])
("bjya" ["板牙"])
("bjye" ["半夜"])
("bjyi" ["搬移"])
("bjyj" ["扮演"])
("bjyn" ["伴音" "半音"])
("bjyp" ["搬运"])
("bjyr" ["半圆"])
("bjys" ["搬用"])
("bjyt" ["半月"])
("bjzb" ["伴奏"])
("bjzi" ["班子" "扳子" "板子"])
("bjzu" ["班组"])
("bjzv" ["并肩作战"])
("bk'" ["包括"])
("bkan" ["保安"])
("bkb'" ["不可不"])
("bkbc" ["保镳" "报表"])
("bkbi" ["包庇"])
("bkbj" ["包办"])
("bkbk" ["宝宝"])
("bkbm" ["褒贬" "不可避免"])
("bkby" ["暴病"])
("bkbz" ["宝贝"])
("bkch" ["包藏"])
("bkcj" ["饱餐"])
("bkcp" ["保存"])
("bkda" ["报答"])
("bkdd" ["不可多得"])
("bkdk" ["报导" "报到" "报道"])
("bkdm" ["宝殿"])
("bkds" ["暴动"])
("bkdx" ["暴跌"])
("bkdy" ["保定"])
("bke'" "保堡饱宝葆鸨褓")
("bkfa" ["暴发" "爆发"])
("bkfg" ["暴风"])
("bkfr" ["不可否认"])
("bkfu" ["包袱" "抱负" "报复"])
("bkfz" ["报废"])
("bkgd" ["曝光"])
("bkgj" ["包干"])
("bkgk" ["报告"])
("bkgo" ["包裹" "报国"])
("bkgr" ["保管" "报馆" "不可告人"])
("bkgs" ["包工"])
("bkgu" ["苞谷" "包谷"])
("bkgv" ["宝贵"])
("bkhe" ["饱和"])
("bkhj" ["包含" "包涵" "饱含"])
("bkhu" ["保护"])
("bkhw" ["刨花"])
("bkib" ["报酬" "报仇"])
("bkid" ["刨床"])
("bkie" ["包车"])
("bkih" ["包场"])
("bkii" ["保持"])
("bkij" ["包产"])
("bkik" ["包抄"])
("bkil" ["宝钗"])
("bkjd" ["褒奖"])
("bkji" ["宝鸡"])
("bkjm" ["保荐" "保健" "宝剑"])
("bkjn" ["包紧"])
("bkjp" ["暴君"])
("bkjw" ["保驾"])
("bkjx" ["报界"])
("bkjy" ["报警"])
("bkkj" ["报刊"])
("bkkk" ["报考"])
("bkko" ["包括"])
("bkku" ["宝库"])
("bklb" ["暴露"])
("bkle" ["贝克勒耳"])
("bkli" ["暴利" "暴力"])
("bklj" ["包揽"])
("bklo" ["包罗"])
("bklq" ["保留"])
("bklr" ["暴乱"])
("bklx" ["暴烈" "爆裂"])
("bklz" ["堡垒"])
("bkmc" ["保苗"])
("bkmi" ["苞米" "保密"])
("bkmj" ["饱满"])
("bkmm" ["不可磨灭"])
("bkmu" ["保姆" "鸨母"])
("bkmy" ["报名"])
("bknt" ["暴虐"])
("bkpi" ["包皮"])
("bkpo" ["爆破"])
("bkpu" ["抱朴"])
("bkq'" ["苞" "胞" "包" "褒" "剥" "炮" "孢" "煲" "龅" "不客气"])
("bkqi" ["抱起"])
("bkqm" ["抱歉"])
("bkqr" ["保全"])
("bkqu" ["百科全书"])
("bkqy" ["报请"])
("bkr'" "抱报暴豹鲍爆刨曝瀑趵")
("bkrf" ["保人"])
("bkss" ["保送"])
("bksy" ["不可思议"])
("bkt'" ["白口铁"])
("bkta" ["宝塔"])
("bktb" ["包头"])
("bktl" ["胞胎"])
("bktu" ["暴徒"])
("bkub" ["保守"])
("bkue" ["报社"])
("bkuf" ["包身"])
("bkuh" ["保墒"])
("bkui" ["宝石"])
("bkul" ["曝晒"])
("bkum" ["别开生面"])
("bkuu" ["不可胜数"])
("bkux" ["不堪设想"])
("bkva" ["包扎" "爆炸"])
("bkvd" ["包装"])
("bkve" ["抱着"])
("bkvf" ["保真"])
("bkvg" ["保证" "暴政"])
("bkvh" ["保障" "暴涨"])
("bkvi" ["报纸"])
("bkvl" ["不可知论"])
("bkvm" ["不可捉摸"])
("bkvr" ["不可终日"])
("bkvs" ["保重"])
("bkvu" ["爆竹"])
("bkw'" "薄雹")
("bkwf" ["保温"])
("bkwu" ["宝物" "报务"])
("bkwz" ["包围" "保卫"])
("bkxc" ["包销" "报销"])
("bkxi" ["报喜"])
("bkxm" ["保险"])
("bkxn" ["报信"])
("bkxq" ["保修"])
("bkxx" ["不可想象"])
("bkxy" ["暴行"])
("bkyb" ["保佑" "抱有"])
("bkyh" ["保养"])
("bkyi" ["褒义"])
("bkyr" ["抱怨"])
("bkyu" ["保育" "暴雨" "鲍鱼" "不可一世"])
("bkzh" ["宝藏"])
("bkzi" ["包子" "雹子" "豹子" "孢子"])
("bkzk" ["暴躁"])
("bkzl" ["雹灾"])
("bkzo" ["宝座"])
("bkzv" ["报刊杂志"])
("blb'" ["玻璃板" "玻璃杯"])
("blbh" ["病理变化"])
("blbj" ["百般"])
("blbl" ["白白"])
("blbu" ["白布" "摆布"])
("blbz" ["百倍"])
("blcl" ["白菜"])
("bld'" ["白兰地" "布隆迪"])
("blda" ["白打"])
("bldh" ["波罗的海"])
("bldi" ["白底"])
("bldm" ["白点"])
("bldp" ["百吨"])
("blds" ["摆动"])
("bldt" ["不良导体"])
("bldu" ["摆渡"])
("ble'" "柏百摆佰伯捭")
("blee" ["白垩"])
("bleh" ["不劳而获"])
("bler" ["百二"])
("blfa" ["白发"])
("blff" ["白粉" "百分"])
("blfh" ["拜访"])
("blfv" ["拨乱反正"])
("blfz" ["白匪" "白费"])
("blg'" ["玻璃钢" "布拉格"])
("blgm" ["暴力革命"])
("blgr" ["百官"])
("blgs" ["白宫"])
("blgu" ["巴黎公社" "白骨"])
("blh'" ["白兰花" "博览会"])
("blhe" ["白河"])
("blhk" ["摆好"])
("blho" ["百货"])
("blhu" ["白虎"])
("blhv" ["白灰" "拜会"])
("blhw" ["白花" "白化" "白话" "白桦"])
("blhy" ["败坏"])
("bli'" ["比例尺" "碧螺春"])
("blie" ["布拉柴维尔"])
("blii" ["白痴"])
("bliu" ["百出"])
("blj'" ["八路军" "白莲教"])
("bljd" ["败将"])
("blji" ["百计"])
("bljm" ["拜见"])
("bljn" ["白金"])
("bljp" ["白军"])
("bljq" ["白酒"])
("blju" ["败局"])
("bljw" ["百家"])
("bljy" ["白净"])
("blke" ["百科"])
("blla" ["白蜡"])
("blld" ["百两"])
("bllh" ["白朗"])
("blli" ["百里"])
("bllj" ["白兰"])
("blln" ["白磷"])
("bllu" ["白露"])
("bllv" ["不了了之"])
("blly" ["白领"])
("bllz" ["败类"])
("blma" ["白马"])
("blmi" ["白米"])
("blmm" ["白面"])
("blmu" ["柏木"])
("bln'" ["布鲁诺"])
("blnm" ["百年" "拜年"])
("blns" ["摆弄"])
("blq'" ["掰" "变流器"])
("blqi" ["白旗"])
("blqu" ["白区"])
("blqx" ["不良倾向"])
("blr'" "败拜稗呗")
("blrb" ["白肉"])
("blre" ["白热"])
("blrf" ["白人"])
("blri" ["白日" "百日"])
("bls'" ["玻璃丝"])
("blse" ["白色" "布鲁塞尔"])
("blst" ["巴勒斯坦"])
("blsu" ["败诉"])
("blt'" ["柏拉图" "贝鲁特"])
("blta" ["白塔"])
("bltb" ["白头"])
("blth" ["白糖"])
("bltk" ["白陶"])
("bltm" ["白天"])
("blto" ["摆脱" "拜托"])
("blts" ["白铜"])
("bltv" ["败退"])
("bltx" ["白铁"])
("blty" ["百里挑一"])
("blu'" ["白蜡树" "比利时"])
("blua" ["白沙"])
("blue" ["摆设"])
("blug" ["百胜"])
("blut" ["比例失调"])
("bluu" ["白薯" "柏树"])
("bluv" ["白水"])
("blv'" ["避雷针" "玻璃纸"])
("blvb" ["白昼"])
("blvg" ["摆正"])
("blvh" ["败仗"])
("blvi" ["白纸"])
("blvj" ["百战"])
("blvk" ["波澜壮阔"])
("blvo" ["白浊"])
("blvs" ["白种"])
("blvx" ["比例中项"])
("blw'" ["白" "芭蕾舞"])
("blwh" ["败亡"])
("blwj" ["百万"])
("blwy" ["玻利维亚"])
("blx'" ["病理学"])
("blxd" ["白相"])
("blxm" ["摆线"])
("blxs" ["白熊"])
("blxt" ["白雪"])
("blxw" ["玻璃纤维"])
("blxx" ["拜谢"])
("blxy" ["百姓" "败兴"])
("blyb" ["柏油"])
("blyd" ["布朗运动"])
("blyh" ["白杨"])
("blyi" ["白蚁"])
("blyj" ["白眼"])
("blyn" ["白银"])
("blyp" ["白云"])
("blyr" ["百元"])
("blyu" ["白玉"])
("blzi" ["稗子"])
("blzl" ["摆在"])
("blzu" ["白族"])
("bm'" ["表明"])
("bmbo" ["辩驳"])
("bmbu" ["遍布"])
("bmbx" ["辨别"])
("bmce" ["鞭策"])
("bmcl" ["边材"])
("bmcr" ["编篡"])
("bmcs" ["便从"])
("bmda" ["鞭打" "变大"])
("bmdb" ["扁豆"])
("bmdh" ["便当"])
("bmdi" ["贬低" "遍地"])
("bmdj" ["扁担"])
("bmdk" ["编导" "便道"])
("bmdl" ["边带"])
("bmdm" ["变电"])
("bmds" ["变动"])
("bmdv" ["编队"])
("bmdy" ["编订"])
("bme'" "贬扁匾碥窆褊")
("bmee" ["匾额"])
("bmeh" ["不谋而合"])
("bmer" ["边儿"])
("bmfa" ["变法"])
("bmfg" ["边锋"])
("bmfh" ["边防"])
("bmfj" ["便饭"])
("bmfu" ["便服"])
("bmgd" ["表面光洁度"])
("bmge" ["变革"])
("bmgg" ["变更"])
("bmgu" ["变故"])
("bmgw" ["变卦"])
("bmh'" ["表面化"])
("bmhj" ["表面活性剂"])
("bmhk" ["编号"])
("bmhr" ["变换" "变幻"])
("bmhs" ["变红"])
("bmhu" ["辩护"])
("bmhv" ["便会"])
("bmhw" ["变化"])
("bmig" ["编程" "变成"])
("bmiv" ["边陲"])
("bmj'" ["表面积"])
("bmjd" ["边疆"])
("bmji" ["边际" "编辑"])
("bmju" ["编剧"])
("bmjx" ["边界" "辩解"])
("bmjy" ["边境"])
("bmk'" ["巴马科"])
("bmkd" ["边框"])
("bmke" ["便可"])
("bmld" ["变量"])
("bmli" ["便利"])
("bmll" ["八面玲珑"])
("bmlp" ["辩论"])
("bmlr" ["变乱"])
("bmm'" ["白茫茫"])
("bmma" ["编码"])
("bmmk" ["鞭毛"])
("bmml" ["变卖"])
("bmmn" ["边民"])
("bmn'" ["白毛女"])
("bmng" ["便能"])
("bmpk" ["鞭炮"])
("bmpl" ["编排"])
("bmpn" ["变频"])
("bmpy" ["扁平"])
("bmq'" "鞭边编煸砭蝙笾鳊")
("bmqm" ["变迁"])
("bmqt" ["扁鹊"])
("bmqu" ["边区"])
("bmr'" "便变卞辨辩辫遍弁苄忭汴缏")
("bmrf" ["辨认"])
("bmru" ["编入"])
("bmse" ["变色"])
("bmsu" ["变速"])
("bmt'" "边")
("bmta" ["鞭挞"])
("bmtc" ["便条"])
("bmtl" ["变态"])
("bmts" ["变通"])
("bmu'" ["不名数"])
("bmuf" ["编审"])
("bmuh" ["边上"])
("bmui" ["便是"])
("bmuu" ["变数"])
("bmv'" ["北美洲"])
("bmve" ["编者"])
("bmvg" ["辩证"])
("bmvi" ["编织" "编制" "贬值" "变质"])
("bmvl" ["表面张力" "表面质量"])
("bmvs" ["变种"])
("bmvu" ["编著"])
("bmvx" ["不明真相"])
("bmwz" ["变为"])
("bmxd" ["变相"])
("bmxm" ["边线"])
("bmxn" ["变心"])
("bmxq" ["编修" "变修"])
("bmxr" ["编选"])
("bmxx" ["编写" "便携"])
("bmxy" ["变形" "变性"])
("bmy'" ["比目鱼" "并没有"])
("bmya" ["变压"])
("bmye" ["遍野"])
("bmyh" ["变样"])
("bmyi" ["编译" "便衣" "变异"])
("bmyj" ["边沿"])
("bmyn" ["编印"])
("bmyr" ["边缘" "边远" "扁圆"])
("bmyu" ["便于" "鳊鱼"])
("bmzi" ["鞭子" "辫子"])
("bmzk" ["编造"])
("bmzr" ["编纂"])
("bn'" ["不能"])
("bnb'" ["不能不"])
("bnbn" ["彬彬"])
("bnd'" ["本年度"])
("bndj" ["百年大计"])
("bnfa" ["鬓发"])
("bnff" ["缤纷"])
("bngr" ["宾馆"])
("bnh'" ["百年后"])
("bnhl" ["滨海"])
("bnii" ["摈斥"])
("bniu" ["摈除"])
("bnjc" ["鬓角"])
("bnke" ["宾客"])
("bnln" ["濒临"])
("bnm'" ["巴拿马"])
("bnmh" ["巴拿马运河"])
("bnq'" "彬斌濒滨宾傧豳缤玢槟镔")
("bnqi" ["摈弃"])
("bnr'" "摈殡膑髌鬓")
("bnvb" ["宾州"])
("bnvu" ["宾主"])
("bnxf" ["笨鸟先飞"])
("bnyu" ["濒于" "宾语"])
("bnzh" ["殡葬"])
("boai" ["博爱"])
("bobi" ["薄壁"])
("bobj" ["薄板"])
("bobo" ["薄薄" "勃勃" "伯伯" "饽饽"])
("bocg" ["薄层"])
("bocl" ["菠菜"])
("bodb" ["搏斗"])
("bode" ["博得"])
("bodk" ["波导" "驳倒"])
("bodo" ["剥夺"])
("bodr" ["波段"])
("bods" ["波动"])
("boe'" "簸跛")
("boen" ["波恩"])
("boer" ["玻尔"])
("bofa" ["勃发"])
("bofg" ["波峰"])
("bofh" ["播放"])
("bofu" ["伯父"])
("boge" ["鹁鸽"])
("bogu" ["波谷"])
("bohe" ["薄荷"])
("bohl" ["渤海"])
("bohv" ["驳回"])
("boih" ["波长"])
("boii" ["驳斥"])
("boir" ["驳船"])
("boiu" ["播出"])
("boji" ["波及" "簸箕"])
("bojt" ["伯爵"])
("bokl" ["剥开"])
("bokr" ["拨款"])
("bolh" ["波浪"])
("boli" ["剥离" "薄利" "玻璃"])
("bolj" ["波兰" "波澜"])
("boln" ["柏林"])
("bolo" ["剥落" "菠萝"])
("bomo" ["薄膜"])
("bomu" ["伯母"])
("bomz" ["波美"])
("bopm" ["薄片"])
("boq'" "般剥玻菠播拨钵波饽趵")
("boqi" ["勃起"])
("bor'" "柏薄檗掰擘簸")
("borj" ["勃然"])
("boro" ["薄弱"])
("bosi" ["波斯"])
("boss" ["播送"])
("bot'" "卜啵")
("bote" ["波特"])
("botk" ["波涛"])
("boui" ["剥蚀" "博士"])
("bouu" ["波束"])
("bove" ["波折"])
("bovi" ["箔纸"])
("bovs" ["播种"])
("bow'" "柏百薄博勃搏铂箔伯帛舶脖膊渤泊驳魄孛亳礴钹鹁踣")
("bowf" ["波纹"])
("bowu" ["薄雾" "博物"])
("bowz" ["泊位"])
("boxt" ["剥削" "博学"])
("boxy" ["波形"])
("boyn" ["播音"])
("boyp" ["薄云"])
("boyr" ["波源"])
("bozi" ["脖子"])
("bp'" ["不怕"])
("bpbl" ["不破不立"])
("bpdy" ["不平等条约"])
("bpg'" ["变频管"])
("bph'" ["不平衡"])
("bpq'" ["变频器"])
("bq'" ["并且"])
("bqbn" ["不屈不挠"])
("bquj" ["不切实际" "不求甚解"])
("bqvy" ["霸权主义"])
("br'" ["不如"])
("brdw" ["哺乳动物"])
("brhj" ["薄弱环节"])
("brm'" ["白日梦"])
("brwg" ["必然王国"])
("brx'" ["必然性"])
("bsbs" ["不三不四"])
("bsj'" ["比色计"])
("bskb" ["白色恐怖"])
("bsq'" ["变速器"])
("bsw'" ["波斯湾"])
("bsyd" ["变速运动"])
("bt'" ["不同"])
("btc'" ["表土层"])
("btdj" ["八抬大轿"])
("btef" ["半途而废"])
("btfx" ["不同凡响"])
("btlu" ["遍体鳞伤"])
("btm'" ["半透明" "不透明"])
("btp'" ["白铁皮"])
("btq'" ["表同情"])
("btu'" ["不透水"])
("btvj" ["被统治阶级"])
("btvv" ["被统治者"])
("btxd" ["冰天雪地"])
("bty'" ["不同意"])
("bu'" ["不是"])
("buan" ["不安"])
("bubi" ["不比" "不必"])
("bubj" ["笨手笨脚"])
("bubm" ["不便" "不变"])
("bubo" ["布帛"])
("bubu" ["步步"])
("buby" ["步兵"])
("bubz" ["不备"])
("buce" ["不测" "簿册"])
("bucg" ["不曾"])
("buci" ["卜辞"])
("buco" ["不错"])
("bud'" ["波士顿"])
("buda" ["不大"])
("budc" ["不掉" "步调"])
("bude" ["不得"])
("budg" ["不等"])
("budh" ["不当"])
("budi" ["不第"])
("budj" ["不单" "不但"])
("budk" ["不到"])
("budl" ["不待"])
("budo" ["不多"])
("budr" ["不短" "不断"])
("buds" ["不懂"])
("budu" ["不独"])
("budv" ["不对" "部队"])
("budx" ["不迭"])
("budy" ["补丁" "不定"])
("bue'" "堡捕卜哺补卟")
("bufa" ["补发" "不乏" "不法" "步伐"])
("buff" ["不分" "部分"])
("bufg" ["捕风"])
("bufh" ["不妨" "布防"])
("bufj" ["不凡"])
("bufu" ["不符" "不服"])
("bugb" ["不够"])
("bugd" ["不光"])
("bugf" ["不根"])
("bugj" ["不甘" "不敢"])
("bugk" ["布告"])
("bugl" ["不该"])
("bugo" ["不果" "不过"])
("bugr" ["不关" "不管" "不惯"])
("bugs" ["不公"])
("bugu" ["不顾"])
("bugv" ["不轨"])
("buhe" ["不和" "不合"])
("buho" ["捕获"])
("buhv" ["不会"])
("bui'" ["办事处"])
("buig" ["不成"])
("buih" ["补偿"])
("buii" ["不迟" "不齿"])
("buis" ["补充"])
("buj'" ["本世纪"])
("bujc" ["补角"])
("buji" ["补给" "不及" "不计" "部级"])
("bujm" ["不见" "部件"])
("bujn" ["不仅" "不禁" "不尽"])
("bujq" ["补救" "不久"])
("buju" ["不拘" "布局"])
("bujx" ["避实击虚" "不解" "不借"])
("bujy" ["捕鲸" "不敬" "布景"])
("buke" ["补课" "不可" "不克"])
("bukj" ["不堪"])
("bukk" ["补考"])
("bukv" ["不愧"])
("buky" ["不快"])
("bulc" ["不了" "不料"])
("buld" ["不良"])
("bulh" ["布朗"])
("buli" ["不理" "不利" "不力"])
("bulk" ["捕捞"])
("bulo" ["部落"])
("bulp" ["不论"])
("bulv" ["步履"])
("buly" ["不灵"])
("bulz" ["布雷"])
("bumc" ["不妙"])
("bumf" ["部门"])
("bumh" ["不忙"])
("bumj" ["不满" "布满"])
("bumm" ["不免" "布面"])
("bumn" ["不敏"])
("bumy" ["不明"])
("bung" ["不能"])
("bupa" ["不怕"])
("bupc" ["补票"])
("bupi" ["布匹"])
("bupy" ["不平"])
("bupz" ["不配"])
("buq'" ["逋" "晡" "钸" "半衰期"])
("buqc" ["不巧"])
("buqd" ["步枪"])
("buqi" ["补齐"])
("buqt" ["补缺"])
("buqu" ["不屈"])
("bur'" "不布步簿部埠怖埔瓿钚")
("burf" ["不仁" "不忍"])
("buri" ["不日"])
("burj" ["不然"])
("burs" ["不容"])
("buru" ["哺乳" "不如"])
("buse" ["补色"])
("busj" ["不散"])
("buss" ["不送"])
("butb" ["布头"])
("bute" ["不特"])
("buto" ["不妥"])
("buts" ["不通" "不同"])
("butu" ["不图"])
("butx" ["补贴"])
("buub" ["部首"])
("buuf" ["不慎"])
("buug" ["不胜"])
("buui" ["捕食" "不时" "不是" "不适" "布什"])
("buuj" ["不善" "不失时机"])
("buuk" ["不少"])
("buuu" ["跋山涉水" "部署" "部属"])
("buuv" ["避暑山庄"])
("buvb" ["步骤"])
("buvf" ["不振" "布阵"])
("buvg" ["补正"])
("buvh" ["部长"])
("buvi" ["不知" "不值" "不止" "不只" "不致" "不置" "布置"])
("buvo" ["捕捉"])
("buvp" ["不准"])
("buvr" ["饱食终日"])
("buvs" ["不中"])
("buvu" ["补助" "不住"])
("buw'" ["不" "醭" "白沙瓦" "不失为"])
("buwf" ["不文" "不稳" "不问"])
("buwl" ["不外"])
("buwu" ["不无"])
("buwz" ["不惟" "部委" "部位"])
("buxc" ["不消" "不孝" "不肖"])
("buxd" ["不祥"])
("buxi" ["补习" "不惜"])
("buxm" ["布线"])
("buxq" ["不休" "不朽"])
("buxr" ["补选"])
("buxu" ["不许"])
("buxw" ["不暇" "部下"])
("buxx" ["不懈" "不屑"])
("buxy" ["不兴" "不行" "不幸" "步行"])
("buy'" ["半失业" "不说有" "办事员"])
("buyi" ["不一" "不依" "不宜" "不已" "不意" "布衣"])
("buyj" ["不厌"])
("buyk" ["不要"])
("buyp" ["不孕"])
("buys" ["不用"])
("buyu" ["哺育" "补语" "不予"])
("buzi" ["步子"])
("buzl" ["不在"])
("buzu" ["补足" "不足" "部族"])
("bv'" ["标准"])
("bva'" ["编者按"])
("bvbj" ["不知不觉" "不着边际"])
("bvbk" ["不折不扣"])
("bvbn" ["百折不挠"])
("bvbu" ["百战百胜"])
("bvd'" ["包装袋" "不知道"])
("bvdy" ["标准大气压"])
("bvf'" ["辩证法"])
("bvg'" ["标准规"])
("bvgy" ["保证供应"])
("bvgz" ["标准工资"])
("bvh'" ["标准化"])
("bvhy" ["部长会议"])
("bvi'" ["标准差"])
("bvil" ["变质处理"])
("bvj'" ["播种机" "补助金" "标准件"])
("bvl'" ["贬值率"])
("bvm'" ["标准木"])
("bvmd" ["半殖民地"])
("bvmj" ["播种面积"])
("bvp'" ["半制品"])
("bvq'" ["不争气"])
("bvr'" ["班主任" "保证人"])
("bvry" ["标准溶液"])
("bvsc" ["不知所措"])
("bvu'" ["爆炸声" "标准时"])
("bvux" ["本质属性"])
("bvv'" ["标志着"])
("bvvf" ["不正之风"])
("bvvk" ["标准状况"])
("bvvt" ["标准状态"])
("bvy'" ["不至于" "不中用"])
("bw'" ["并未"])
("bwe'" ["鲍威尔"])
("bwfw" ["百万富翁"])
("bwg'" ["博物馆"])
("bwhp" ["保卫和平"])
("bwl'" ["备忘录"])
("bwm'" ["比我们"])
("bwp'" ["保温瓶"])
("bwq'" ["包围圈"])
("bwv'" ["保卫者"])
("bwvy" ["本位主义"])
("bwzg" ["保卫祖国"])
("bx'" ["必须"])
("bxb'" ["白细胞"])
("bxba" ["别把"])
("bxd'" ["把兄弟"])
("bxde" ["别的"])
("bxds" ["别动"])
("bxdx" ["表现对象"])
("bxe'" "瘪")
("bxf'" ["变戏法"])
("bxg'" ["保险柜" "不相干" "不锈钢"])
("bxge" ["别个"])
("bxgo" ["别国"])
("bxgr" ["别管"])
("bxgs" ["保险公司"])
("bxh'" ["不象话"])
("bxhb" ["别后"])
("bxi'" ["变形虫"])
("bxiu" ["别处"])
("bxje" ["保险金额"])
("bxjj" ["剥削阶级"])
("bxjq" ["被选举权"])
("bxk'" ["必修课"])
("bxkj" ["别看"])
("bxl'" ["包下来" "不行了"])
("bxly" ["巴西利亚" "标新立异"])
("bxmy" ["别名"])
("bxnq" ["别扭"])
("bxp'" ["必需品"])
("bxq'" ["鳖" "憋" "瘪" "白血球"])
("bxqi" ["憋气"])
("bxqy" ["背信弃义"])
("bxr'" ["别" "不相容"])
("bxrf" ["别人"])
("bxrh" ["别让"])
("bxs'" ["保险丝"])
("bxsj" ["瘪三"])
("bxti" ["别提"])
("bxu'" ["半小时"])
("bxui" ["别是"])
("bxuo" ["别说"])
("bxuu" ["别墅"])
("bxux" ["不相上下"])
("bxv'" ["八仙桌"])
("bxvi" ["别致"])
("bxvy" ["八项注意"])
("bxw'" "别蹩")
("bxwu" ["不学无术"])
("bxx'" ["表现型" "表现形"])
("bxxc" ["别笑"])
("bxxd" ["别想"])
("bxy'" ["不象样"])
("bxyg" ["不屑一顾"])
("bxzi" ["别字"])
("by'" ["不要"])
("byba" ["并把"])
("bybk" ["冰雹" "禀报"])
("bybm" ["兵变" "病变"])
("bybu" ["兵部" "并不"])
("bybz" ["兵备" "并被"])
("bycp" ["并存"])
("bycs" ["并从"])
("byd'" ["不由得"])
("bydh" ["并当"])
("bydk" ["冰岛" "病倒"])
("bydm" ["冰点"])
("bydq" ["边远地区"])
("byds" ["冰冻"])
("bydu" ["病毒"])
("bydy" ["兵丁"])
("bye'" "柄丙秉饼炳屏禀邴")
("byet" ["不约而同"])
("byey" ["不言而喻"])
("byez" ["不一而足"])
("byfa" ["兵法" "并发"])
("byfg" ["冰封"])
("byfh" ["丙方" "病房"])
("byfu" ["不由分说"])
("byfz" ["并非"])
("bygf" ["病根"])
("bygj" ["饼干"])
("bygp" ["冰棍"])
("bygs" ["秉公"])
("byhe" ["并合"])
("byhk" ["病号"])
("byhl" ["病害"])
("byid" ["病床"])
("byig" ["秉承" "病程"])
("byih" ["冰场"])
("byip" ["丙醇"])
("byir" ["兵船" "冰川"])
("byj'" ["不要紧"])
("byjd" ["并将"])
("byjf" ["北洋军阀"])
("byjm" ["兵舰" "并肩"])
("byjn" ["并进"])
("byjp" ["病菌"])
("byjq" ["并就"])
("byju" ["并举"])
("byjw" ["兵家" "病假"])
("byjy" ["冰晶" "并经"])
("byk'" ["半月刊"])
("byke" ["并可"])
("bykx" ["边缘科学"])
("byl'" ["不要脸"])
("byld" ["必要劳动" "冰凉"])
("bylg" ["冰冷"])
("bylh" ["槟榔"])
("byli" ["兵力" "病理" "病历" "病例" "并立"])
("bylm" ["并联"])
("bylp" ["丙纶" "并论"])
("bylx" ["并列"])
("byly" ["冰凌"])
("bylz" ["丙类"])
("byma" ["兵马"])
("bymo" ["病魔"])
("byng" ["并能"])
("byns" ["布宜诺斯艾利斯"])
("byp'" ["被压迫"])
("bypj" ["被压迫阶级"])
("bypl" ["并排"])
("bypz" ["被压迫民族"])
("byq'" ["兵" "冰" "并" "槟" "变压器"])
("byqi" ["兵器" "冰期"])
("byqq" ["冰球"])
("byqr" ["兵权"])
("byqx" ["并且"])
("byqy" ["病情" "并请"])
("byr'" "病并摒")
("byrf" ["病人"])
("byru" ["并入"])
("bys'" ["表演赛"])
("bysg" ["半夜三更"])
("byt'" ["病原体"])
("bytc" ["并条"])
("bytd" ["别有天地"])
("byth" ["冰糖"])
("bytl" ["病态"])
("bytm" ["冰天"])
("bytp" ["并吞"])
("bytr" ["兵团"])
("byts" ["丙酮"])
("byu'" ["白杨树" "毕业生" "不用说"])
("byuf" ["比翼双飞"])
("byui" ["兵士" "病势"])
("byuj" ["冰山"])
("byuu" ["兵书"])
("byvd" ["病状"])
("byvf" ["冰镇"])
("byvg" ["病症"])
("byvi" ["兵制"])
("byvl" ["必由之路"])
("byvs" ["兵种" "病重" "并重"])
("byvu" ["病株"])
("bywj" ["丙烷"])
("bywr" ["不以为然"])
("bywu" ["并无"])
("bywz" ["病危" "并未"])
("byx'" ["必要性"])
("byxd" ["冰箱"])
("byxi" ["丙稀"])
("byxt" ["冰雪"])
("byxu" ["变异系数"])
("byxy" ["并行"])
("byy'" ["保育员" "避孕药"])
("byyh" ["冰洋"])
("byyi" ["兵役" "并以"])
("byyk" ["并要"])
("byyl" ["不遗余力"])
("byyn" ["病因"])
("byyr" ["兵员" "病员" "病原" "病院"])
("byys" ["并用"])
("byyu" ["表演艺术" "病愈"])
("byyx" ["别有用心"])
("byyy" ["兵营"])
("byz'" ["布依族"])
("byzi" ["饼子"])
("byzk" ["病灶"])
("byzl" ["并在"])
("byzv" ["不由自主"])
("bz'" ["不在"])
("bzai" ["悲哀"])
("bzan" ["备案"])
("bzbi" ["卑鄙" "被逼"])
("bzbk" ["背包"])
("bzbm" ["北边"])
("bzbu" ["北部" "背部" "被捕"])
("bzbz" ["鞴鞴"])
("bzci" ["被刺"])
("bzcj" ["悲惨"])
("bzd'" ["半自动"])
("bzdi" ["背地"])
("bzdj" ["被单"])
("bzdk" ["被盗"])
("bzds" ["被动"])
("bze'" "北")
("bzer" ["贝尔"])
("bzff" ["悲愤" "辈分" "备份"])
("bzfg" ["北风" "背风"])
("bzfh" ["北方" "北房"])
("bzfu" ["背负" "被俘"])
("bzfz" ["北非"])
("bzgd" ["背光"])
("bzge" ["悲歌"])
("bzgg" ["备耕"])
("bzgk" ["被告"])
("bzgr" ["悲观"])
("bzh'" ["不在乎"])
("bzhb" ["背后"])
("bzhd" ["备荒"])
("bzhl" ["北海" "被害"])
("bzia" ["备查"])
("bzik" ["北朝"])
("bziu" ["辈出"])
("bzjc" ["北郊"])
("bzji" ["北极" "背脊"])
("bzjm" ["卑贱" "备件"])
("bzju" ["悲剧"])
("bzjx" ["被劫"])
("bzjy" ["北京" "背景"])
("bzke" ["贝壳" "备课"])
("bzku" ["悲苦"])
("bzl'" ["不在了"])
("bzla" ["贝拉"])
("bzlc" ["备料"])
("bzld" ["悲凉"])
("bzle" ["贝勒"])
("bzli" ["背离"])
("bzlx" ["卑劣"])
("bzlz" ["贝类"])
("bzm'" ["不怎么"])
("bzmm" ["北面" "背面" "被面"])
("bzn'" ["孢子囊"])
("bzou" ["北欧"])
("bzpj" ["背叛"])
("bzpn" ["备品"])
("bzpo" ["被迫"])
("bzq'" ["杯" "碑" "悲" "卑" "背" "陂" "埤" "萆" "鹎" "变阻器"])
("bzqi" ["背弃"])
("bzr'" "辈背贝钡倍狈备惫焙被孛邶蓓悖碚褙鐾鞴")
("bzru" ["被褥"])
("bzss" ["北宋" "背诵"])
("bzt'" "臂呗")
("bzts" ["悲痛"])
("bzu'" ["不做声"])
("bzud" ["不择手段"])
("bzuh" ["悲伤"])
("bzuj" ["北山"])
("bzuk" ["焙烧"])
("bzuu" ["背书" "倍数"])
("bzvb" ["北周"])
("bzvd" ["悲壮"])
("bzvi" ["备至"])
("bzvj" ["备战"])
("bzvu" ["备注"])
("bzvw" ["被子植物"])
("bzwf" ["碑文"])
("bzwh" ["备忘"])
("bzwo" ["被窝"])
("bzwq" ["不足为奇"])
("bzwz" ["北纬"])
("bzxf" ["八字宪法"])
("bzxg" ["奔走相告"])
("bzxn" ["背心"])
("bzxw" ["卑下"])
("bzxx" ["背斜"])
("bzy'" ["不在意"])
("bzyb" ["备有"])
("bzyh" ["北洋"])
("bzys" ["备用"])
("bzyu" ["倍于"])
("bzyy" ["背影"])
("bzz'" ["不自在"])
("bzzg" ["倍增"])
("bzzi" ["杯子" "辈子" "被子"])
("c" "次")
("cadc" ["擦掉"])
("cae'" "礤")
("cagj" ["擦干"])
("caiu" ["擦除"])
("cajy" ["擦净"])
("cald" ["擦亮"])
("capo" ["擦破"])
("caq'" "擦拆嚓")
("cauh" ["擦伤"])
("cb'" ["从不"])
("cbdk" ["凑到"])
("cbhe" ["凑合"])
("cbji" ["凑集"])
("cbqc" ["凑巧"])
("cbr'" "凑楱辏腠")
("cc'" ["从此"])
("ccbq" ["参差不齐"])
("ccmm" ["匆匆忙忙"])
("cdbv" ["粗蛋白质"])
("ce'" ["从而"])
("ceds" ["策动"])
("cedy" ["测定"])
("ceer" ["侧耳"])
("cegf" ["侧根"])
("cehd" ["测谎"])
("cehv" ["测绘"])
("cehw" ["策划"])
("ceiu" ["测出"])
("ceju" ["测距"])
("celd" ["测量"])
("celt" ["策略"])
("cemf" ["侧门"])
("cemm" ["侧面"])
("cequ" ["测取"])
("cer'" "厕策侧册测恻")
("ceso" ["厕所"])
("cesu" ["测速"])
("ceuf" ["侧身" "测深"])
("ceui" ["测试"])
("cevi" ["侧枝"])
("cevj" ["测站"])
("cevs" ["侧重"])
("cexm" ["侧线" "测线"])
("ceya" ["侧芽"])
("ceye" ["册页"])
("ceyi" ["侧翼"])
("ceyj" ["测验"])
("ceyy" ["策应"])
("cezi" ["册子"])
("cfci" ["参差"])
("cfdq" ["磁放大器"])
("cfq'" "参")
("cfw'" "岑涔")
("cg'" ["参观"])
("cgcg" ["层层"])
("cgci" ["层次"])
("cgdj" ["从古到今"])
("cggk" ["层高"])
("cgjd" ["曾将"])
("cgjy" ["曾经"])
("cglb" ["层楼"])
("cgli" ["层理"])
("cglq" ["层流"])
("cgq'" "噌")
("cgr'" "蹭")
("cgui" ["曾使"])
("cgw'" "层曾")
("cgwz" ["曾为"])
("cgy'" ["磁感应"])
("cgya" ["层压"])
("cgyb" ["曾有"])
("cgzl" ["曾在"])
("ch'" ["此后"])
("chbl" ["苍白"])
("chch" ["苍苍"])
("chcu" ["仓促" "仓卒"])
("chcv" ["苍翠"])
("chhd" ["苍黄" "仓皇"])
("chhl" ["沧海"])
("chj'" ["催化剂"])
("chjx" ["仓颉"])
("chjy" ["苍劲"])
("chku" ["仓库"])
("chlh" ["催化裂化"])
("chlk" ["苍老"])
("chln" ["仓廪"])
("chmh" ["苍茫"])
("chni" ["藏匿"])
("chq'" "苍舱仓沧伧")
("chsh" ["沧桑"])
("chss" ["苍松"])
("chtm" ["苍天"])
("chuf" ["藏身"])
("chui" ["舱室"])
("chuu" ["藏书"])
("chvb" ["沧州"])
("chw'" "藏")
("chwz" ["舱位"])
("chyy" ["苍蝇"])
("chzy" ["催化作用"])
("ciai" ["慈爱"])
("cibi" ["次比"])
("cibq" ["层出不穷"])
("cibz" ["慈悲"])
("cidg" ["次等"])
("cidi" ["此地" "次第"])
("cidk" ["刺刀"])
("cidl" ["磁带"])
("cidm" ["辞典" "词典"])
("cie'" "此")
("cier" ["词儿" "刺耳"])
("cifu" ["伺服"])
("cigf" ["词根"])
("cigu" ["刺骨"])
("cigx" ["财产关系"])
("cihb" ["此后" "伺候"])
("cihd" ["雌黄"])
("cihv" ["词汇"])
("cihw" ["磁化" "雌花" "此话"])
("cihy" ["刺槐"])
("ciih" ["磁场"])
("ciiu" ["此处"])
("cijc" ["赐教"])
("ciji" ["磁极" "刺激"])
("cijm" ["此间"])
("cijp" ["此君"])
("ciju" ["磁矩" "词句"])
("cijy" ["从长计议"])
("cike" ["此刻" "刺客"])
("ciku" ["词库"])
("cili" ["磁力"])
("cilz" ["此类"])
("cimu" ["慈母"])
("cing" ["磁能"])
("cipj" ["磁盘"])
("cipn" ["次品"])
("cipy" ["茨坪"])
("ciq'" ["差" "疵" "刺" "呲" "财产权" "存储器"])
("ciqd" ["磁场强度"])
("ciqi" ["财产清查" "瓷器"])
("ciqu" ["辞去" "词曲"])
("cir'" "刺赐次伺")
("cirf" ["词人"])
("ciri" ["次日"])
("cirv" ["雌蕊"])
("citb" ["磁头"])
("cith" ["祠堂"])
("citi" ["磁体"])
("citj" ["刺探"])
("cits" ["磁通"])
("citu" ["瓷土"])
("citv" ["辞退"])
("citx" ["磁铁"])
("ciu'" ["财产税"])
("ciua" ["刺杀"])
("ciug" ["次生"])
("ciuh" ["刺伤"])
("ciui" ["此时" "此事" "刺史"])
("ciuj" ["慈善"])
("ciuu" ["次数"])
("civf" ["磁针"])
("civh" ["次长"])
("civi" ["辞职" "此致" "次之"])
("civr" ["瓷砖"])
("ciw'" "茨磁雌辞慈瓷词兹茈祠鹚糍")
("ciwh" ["刺网"])
("ciwl" ["此外"])
("ciwz" ["词尾" "刺猬"])
("cix'" ["岑春煊"])
("cixd" ["慈祥" "此项"])
("cixi" ["慈禧"])
("cixn" ["磁芯" "磁心"])
("cixq" ["刺绣"])
("cixr" ["磁选"])
("cixs" ["雌雄"])
("cixu" ["词序" "次序"])
("cixy" ["磁性" "雌性" "辞行"])
("ciyb" ["此由"])
("ciyi" ["词义"])
("ciyj" ["刺眼"])
("ciyk" ["次要"])
("ciyu" ["词语" "赐予" "次于"])
("cizi" ["次子"])
("cizu" ["词组"])
("cj'" ["参加"])
("cjan" ["惨案"])
("cjb'" ["材积表"])
("cjbk" ["残暴"])
("cjbl" ["惨白" "惨败"])
("cjbu" ["残部"])
("cjby" ["残兵"])
("cjcp" ["残存"])
("cjdb" ["蚕豆"])
("cjdj" ["惨淡"])
("cje'" "惨黪")
("cjee" ["蚕蛾"])
("cjeg" ["擦肩而过"])
("cjfz" ["残废"])
("cjg'" ["粗加工"])
("cjgr" ["参观"])
("cjhe" ["掺和"])
("cjhl" ["残骸" "残害"])
("cjjc" ["惨叫"])
("cjji" ["残疾"])
("cjjm" ["参见" "蚕茧"])
("cjjp" ["参军"])
("cjju" ["餐具" "残局"])
("cjjw" ["参加" "掺假"])
("cjkj" ["参看"])
("cjkk" ["参考"])
("cjku" ["残酷"])
("cjkv" ["惭愧"])
("cjld" ["参量"])
("cjlj" ["灿烂"])
("cjlq" ["残留"])
("cjlr" ["蚕卵"])
("cjmb" ["参谋"])
("cjp'" ["促进派"])
("cjpo" ["残破"])
("cjq'" "餐参骖")
("cjqt" ["残缺"])
("cjr'" "惨灿掺孱璨粲")
("cjrf" ["残忍"])
("cjs'" ["葱姜蒜"])
("cjsh" ["蚕桑"])
("cjsi" ["蚕丝" "惨死"])
("cjtm" ["参天"])
("cjts" ["惨痛"])
("cjty" ["餐厅"])
("cjua" ["残杀" "惨杀"])
("cjui" ["参事" "蚕食"])
("cjuu" ["参数"])
("cjvd" ["惨状"])
("cjvg" ["参政"])
("cjvj" ["参战"])
("cjvk" ["参照"])
("cjvo" ["餐桌"])
("cjvs" ["惨重"])
("cjw'" "蚕残惭")
("cjxq" ["次级线圈"])
("cjyi" ["参议"])
("cjys" ["蚕蛹"])
("cjyt" ["参阅"])
("cjyu" ["参与" "参预" "残余"])
("cjza" ["掺杂"])
("cjzj" ["参赞"])
("cjzk" ["惨遭"])
("cjzo" ["蚕座"])
("ckan" ["草案"])
("ckbf" ["草本"])
("ckbk" ["草包"])
("ckcj" ["曹参"])
("ckck" ["曹操" "草草"])
("ckcs" ["草丛"])
("ckdi" ["草地"])
("ckdm" ["草甸"])
("cke'" "草")
("ckff" ["采矿方法"])
("ckfh" ["草房"])
("ckgh" ["槽钢"])
("ckgk" ["草稿"])
("ckgy" ["采矿工业"])
("ckid" ["草创"])
("ckih" ["操场" "草场"])
("ckii" ["操持"])
("ckis" ["草虫"])
("cklc" ["草料"])
("cklk" ["操劳"])
("cklm" ["操练"])
("cklv" ["草绿"])
("ckmh" ["草莽"])
("ckmi" ["糙米"])
("ckmk" ["草帽"])
("ckmu" ["草木"])
("ckmz" ["草莓"])
("ckni" ["草拟"])
("ckpg" ["草棚"])
("ckpi" ["曹丕" "草皮"])
("ckpy" ["草坪"])
("ckq'" ["操" "糙" "采空区"])
("ckqm" ["草签"])
("cksr" ["草酸"])
("ckth" ["草堂"])
("cktu" ["草图"])
("cku'" ["参考书"])
("ckud" ["曹爽"])
("ckug" ["草绳"])
("ckuu" ["草书"])
("ckuy" ["草率"])
("ckvi" ["草纸"])
("ckw'" "槽曹嘈漕螬艚")
("ckwz" ["曹魏"])
("ckxi" ["草席"])
("ckxn" ["操心"])
("ckxx" ["草鞋" "参考消息"])
("ckye" ["草叶"])
("ckyk" ["草药"])
("ckyp" ["漕运"])
("ckyr" ["草原"])
("ckyt" ["草约"])
("ckyu" ["曹禺" "草鱼"])
("ckza" ["嘈杂"])
("ckzi" ["槽子"])
("ckzl" ["参考资料"])
("ckzo" ["操作"])
("ckzs" ["操纵"])
("clba" ["才把"])
("clbj" ["采办"])
("clbk" ["财宝"])
("clce" ["猜测"])
("cldb" ["菜豆"])
("cldc" ["裁掉"])
("cldi" ["菜地"])
("cldj" ["菜单"])
("cldk" ["菜刀"])
("cldl" ["彩带"])
("cldm" ["彩电"])
("cldy" ["裁定"])
("cle'" "睬踩采彩")
("clfa" ["财阀" "采伐"])
("clff" ["才分"])
("clfg" ["裁缝"])
("clfh" ["采访"])
("clfu" ["财富"])
("clgb" ["采购"])
("clgd" ["采光"])
("clgj" ["才干"])
("clho" ["财货"])
("clhs" ["彩虹"])
("clhv" ["彩绘"])
("clhw" ["才华" "菜花"])
("cli'" ["草履虫"])
("clie" ["裁撤"])
("clig" ["裁成"])
("clih" ["菜场"])
("clij" ["财产"])
("clj'" ["测力计"])
("cljd" ["才将"])
("clji" ["猜忌" "采集"])
("cljm" ["裁剪" "裁减"])
("cljp" ["裁军"])
("cljt" ["裁决" "采掘"])
("clju" ["才具"])
("cljy" ["财经"])
("clkd" ["采矿"])
("clke" ["才可"])
("clkl" ["裁开"])
("clkv" ["财会"])
("cllc" ["材料"])
("clli" ["财力" "彩礼"])
("clmi" ["猜谜"])
("clmk" ["财贸"])
("clml" ["采买"])
("clna" ["采纳"])
("clng" ["才能"])
("clnr" ["采暖"])
("clpj" ["裁判"])
("clpu" ["菜谱"])
("clq'" "猜")
("clqi" ["才气"])
("clqr" ["财权"])
("clqu" ["采取"])
("clr'" "采菜蔡")
("cls'" ["次氯酸"])
("clse" ["彩色"])
("clt'" ["磁流体"])
("cltk" ["彩陶"])
("cltl" ["菜苔"])
("cltr" ["财团"])
("cluf" ["财神"])
("clui" ["才是" "彩饰"])
("cluu" ["菜蔬"])
("cluv" ["财税"])
("clvg" ["财政"])
("clvi" ["才智" "采制"])
("clvl" ["采摘"])
("clvs" ["猜中"])
("clvu" ["财主" "彩珠"])
("clw'" "裁材才财")
("clwh" ["藏龙卧虎"])
("clwu" ["财物" "财务"])
("clx'" ["磁力线"])
("clxd" ["猜想"])
("clxm" ["彩显"])
("clxw" ["彩霞"])
("clxy" ["才行"])
("cly'" ["磁力仪"])
("clyb" ["才有" "采油" "菜油"])
("clyh" ["采样"])
("clyi" ["猜疑"])
("clyk" ["菜肴"])
("clyp" ["彩云"])
("clyr" ["财源" "菜园"])
("clys" ["采用"])
("clzi" ["才子" "菜籽" "菜子"])
("cmcv" ["聪明才智"])
("cmg'" ["刺毛辊"])
("cmh'" ["草木灰"])
("cmv'" ["参谋长"])
("cmy'" ["粗毛羊"])
("cn'" ["才能"])
("cncy" ["从难从严"])
("coan" ["错案"])
("cobj" ["搓板"])
("cobl" ["挫败"])
("coci" ["措辞"])
("codk" ["锉刀"])
("coe'" "撮脞")
("cogo" ["错过"])
("cohe" ["撮合"])
("cohw" ["错话"])
("coiu" ["错处"])
("cojt" ["错觉"])
("cokl" ["错开"])
("colc" ["错了"])
("colo" ["错落"])
("colr" ["错乱"])
("coq'" "磋撮搓蹉")
("cor'" "措挫错厝锉")
("couh" ["磋商" "挫伤"])
("coui" ["措施"])
("cove" ["挫折"])
("covi" ["措置"])
("cow'" "嵯矬痤瘥鹾")
("cowu" ["错误"])
("cowz" ["错位"])
("coza" ["错杂"])
("cozi" ["错字"])
("cozs" ["错综"])
("cpbu" ["寸步"])
("cpdh" ["存档"])
("cpe'" "忖")
("cpfh" ["存放"])
("cpgf" ["存根"])
("cpho" ["存货"])
("cphu" ["存户"])
("cpih" ["寸长"])
("cpiu" ["存储"])
("cpkr" ["存款"])
("cplj" ["存栏"])
("cplo" ["村落"])
("cpmn" ["村民"])
("cppj" ["存盘"])
("cpq'" "村皴")
("cpqu" ["存取"])
("cpr'" "寸")
("cpru" ["存入"])
("cptu" ["寸土"])
("cpvd" ["村庄"])
("cpve" ["存折"])
("cpvf" ["村镇"])
("cpvh" ["村长"])
("cpvu" ["存贮"])
("cpw'" "存蹲")
("cpwh" ["存亡"])
("cpxn" ["存心"])
("cpy'" ["裁判员"])
("cpzi" ["村子"])
("cpzl" ["存在"])
("cqbf" ["此起彼伏"])
("crbp" ["从容不迫"])
("crdo" ["篡夺"])
("crfj" ["窜犯"])
("crgl" ["篡改"])
("crq'" "蹿汆撺镩")
("crr'" "篡窜爨")
("crru" ["窜入"])
("crw'" "攒")
("crwz" ["篡位"])
("csbl" ["葱白"])
("csbu" ["从不"])
("csci" ["从此"])
("cscs" ["匆匆"])
("cscu" ["匆促"])
("cscv" ["葱翠"])
("csda" ["从打"])
("csds" ["从动"])
("csdu" ["彩色电视"])
("cser" ["从而"])
("csfg" ["从风"])
("csfj" ["从犯"])
("csfu" ["从父"])
("cshw" ["葱花"])
("csjd" ["葱姜"])
("csjm" ["从简"])
("csjn" ["从今"])
("csjp" ["从军"])
("cskj" ["丛刊"])
("cskr" ["从宽"])
("csl'" ["粗饲料"])
("csll" ["从来"])
("csln" ["丛林"])
("cslp" ["从轮"])
("cslt" ["从略"])
("cslu" ["葱绿"])
("csmh" ["匆忙"])
("csmu" ["从母"])
("csmy" ["聪明"])
("csp'" ["彩色片"])
("csq'" "聪葱囱匆从苁骢璁枞")
("csqm" ["从前"])
("csrs" ["从容"])
("cssu" ["从速"])
("cstb" ["葱头" "从头"])
("cstj" ["丛谈"])
("csug" ["丛生"])
("csui" ["从事"])
("csuu" ["从属" "丛书"])
("csve" ["从这"])
("csvg" ["从政"])
("csvs" ["从中"])
("csw'" "从丛淙琮")
("cswz" ["从未"])
("csxc" ["从小"])
("csxm" ["从先"])
("csxn" ["从新"])
("csye" ["从业"])
("csyj" ["从严"])
("csyy" ["聪颖"])
("cszi" ["从子"])
("ctk'" ["磁铁矿"])
("ctl'" ["磁通量"])
("ctm'" ["磁通门"])
("cu'" ["此时"])
("cubf" ["粗笨"])
("cubj" ["措手不及"])
("cubk" ["粗暴"])
("cubu" ["粗布"])
("cuck" ["粗糙"])
("cucu" ["粗粗"])
("cuda" ["粗大"])
("cufh" ["粗纺" "粗放"])
("cugd" ["粗犷"])
("cugx" ["从属关系"])
("cui'" ["促生产"])
("cuig" ["促成"])
("cujn" ["促进"])
("cul'" ["次生林"])
("culd" ["粗粮"])
("cult" ["粗略"])
("culu" ["粗鲁"])
("culx" ["粗劣"])
("cumk" ["粗毛"])
("cuq'" "粗")
("cuqm" ["粗浅"])
("cur'" "醋簇促卒蔟猝酢蹙蹴")
("cusr" ["醋酸"])
("cuua" ["粗纱"])
("cuui" ["促使"])
("cuvd" ["粗壮"])
("cuvi" ["粗枝"])
("cuvs" ["粗重"])
("cuw'" "徂殂")
("cux'" ["测树学"])
("cuxi" ["粗细"])
("cuxn" ["粗心"])
("cuxr" ["粗选"])
("cuy'" ["从事于"])
("cuye" ["粗野"])
("cuys" ["簇拥"])
("cvb'" ["财政部"])
("cvcj" ["摧残"])
("cvcu" ["催促"])
("cvdy" ["粗枝大叶"])
("cve'" "璀")
("cvf'" ["粗脂肪"])
("cvfz" ["催肥"])
("cvgj" ["操之过急"])
("cvho" ["淬火"])
("cvhv" ["摧毁"])
("cvhw" ["催化"])
("cvij" ["催产"])
("cvlv" ["翠绿"])
("cvlz" ["粗制滥造"])
("cvmm" ["催眠"])
("cvnd" ["财政年度"])
("cvp'" ["粗制品"])
("cvq'" ["摧" "崔" "催" "衰" "榱" "隹" "参政权" "存贮器"])
("cvqu" ["萃取"])
("cvr'" "脆瘁粹淬翠萃啐悴毳")
("cvro" ["脆弱"])
("cvvu" ["翠竹"])
("cvw'" ["参照物"])
("cvwj" ["财政危机"])
("cvxy" ["脆性"])
("cvya" ["催芽"])
("cvzj" ["财政资金"])
("cw'" ["此外"])
("cwj'" ["蔡文姬"])
("cwyg" ["从未有过"])
("cxc'" ["磁性瓷"])
("cxcl" ["磁性材料"])
("cxdy" ["粗心大意"])
("cxq'" ["曹雪芹"])
("cxtx" ["磁性天线"])
("cxw'" ["粗纤维"])
("cxxs" ["促性腺激素"])
("cxy'" ["磁效应"])
("cxyv" ["雌雄异株"])
("cy'" ["采用"])
("cyb'" ["层压板"])
("cyd'" ["策源地"])
("cyg'" ["测压管"])
("cymd" ["次要矛盾"])
("cyp'" ["蔡元培"])
("cyv'" ["参与制"])
("cyy'" ["参议员" "参议院"])
("cz'" ["存在"])
("czfz" ["错综复杂"])
("czgi" ["操作规程"])
("czt'" ["操纵台" "操作台"])
("czx'" ["操纵性"])
("czxt" ["操作系统"])
("czy'" ["操作员"])
("d" "的")
("daan" ["答案"])
("daba" ["打靶" "大坝"])
("dabh" ["大棒"])
("dabi" ["大比" "大笔"])
("dabj" ["打扮" "大半"])
("dabk" ["打包"])
("dabl" ["打败" "大败"])
("dabm" ["答辩" "大便"])
("dabo" ["大伯"])
("dabu" ["大步" "大部"])
("daby" ["大兵" "大饼"])
("dacl" ["大菜"])
("daco" ["大错"])
("dacs" ["大葱"])
("dada" ["大大" "鞑鞑"])
("dadb" ["大豆" "大都"])
("dadc" ["打掉" "大调"])
("dade" ["大德"])
("dadg" ["大灯"])
("dadi" ["大敌" "大抵" "大地"])
("dadj" ["达旦" "大胆"])
("dadk" ["达到" "打倒" "大刀" "大道"])
("dadm" ["打点" "大典" "大殿"])
("dado" ["大多"])
("dadr" ["打断"])
("dads" ["打动"])
("dadu" ["大都"])
("dadv" ["大队"])
("dady" ["大定"])
("dae'" "打")
("daee" ["大颚"])
("daer" ["大二"])
("dafa" ["打发" "大法"])
("daff" ["大粪"])
("dafg" ["大风"])
("dafh" ["大方"])
("dafj" ["打翻" "大凡"])
("dafu" ["答复"])
("dagd" ["打光"])
("dage" ["大哥"])
("dagg" ["打更"])
("dagh" ["大纲" "大港"])
("dagj" ["大干"])
("dagl" ["大概"])
("dago" ["大国" "大过"])
("dagp" ["打滚"])
("dagr" ["达官" "大观"])
("dags" ["大功" "大公"])
("dagu" ["打鼓" "大鼓"])
("dagv" ["打鬼"])
("dagw" ["大褂"])
("dahb" ["大吼"])
("dahd" ["大黄"])
("dahe" ["大河"])
("dahj" ["大汉"])
("dahk" ["大好" "大号"])
("dahl" ["大海"])
("daho" ["大伙" "大火"])
("dahr" ["大患"])
("dahs" ["大红"])
("dahu" ["大湖" "大户"])
("dahv" ["大会"])
("dahw" ["答话" "打滑" "大话"])
("dahy" ["打坏"])
("daia" ["打杈"])
("daie" ["搭车" "大车"])
("daif" ["大臣"])
("daig" ["搭乘" "达成"])
("daih" ["打场" "大肠"])
("daip" ["大春"])
("dair" ["大川"])
("dajc" ["打搅" "大脚"])
("dajd" ["打浆" "大将" "大江" "大奖"])
("daji" ["打击" "大计"])
("dajm" ["大建"])
("dajn" ["打紧" "打进"])
("dajp" ["大军"])
("dajq" ["搭救"])
("dajr" ["答卷"])
("daju" ["大局" "大举"])
("dajw" ["打架" "大家"])
("dajx" ["打劫" "大街" "大捷" "大姐"])
("dajy" ["大经"])
("daka" ["达卡"])
("dakl" ["打开"])
("daku" ["大哭"])
("dakw" ["打垮"])
("daky" ["大块"])
("dala" ["搭拉" "耷拉"])
("dalb" ["大楼"])
("dalc" ["大料"])
("dald" ["打量" "大量"])
("dali" ["答理" "大理" "大力"])
("dalk" ["打捞"])
("dall" ["达赖"])
("dalm" ["大连"])
("daln" ["大林"])
("dalo" ["打落"])
("dalq" ["大流"])
("dalr" ["打乱"])
("dalt" ["大略"])
("dalu" ["大路" "大陆"])
("dalx" ["打猎"])
("dalz" ["打雷"])
("dama" ["大妈" "大麻"])
("damc" ["大庙"])
("damf" ["大门"])
("damh" ["大忙"])
("dami" ["大米"])
("damk" ["大毛"])
("daml" ["大麦"])
("damm" ["大面"])
("damo" ["打磨" "大漠"])
("damy" ["大名"])
("dand" ["大娘"])
("dani" ["大逆"])
("danj" ["大难"])
("dank" ["大脑"])
("danm" ["大年"])
("dapi" ["大批"])
("dapk" ["打炮" "大炮"])
("dapo" ["打破"])
("dapy" ["大平"])
("dapz" ["搭配"])
("daq'" "搭答耷哒嗒褡")
("daqc" ["搭桥"])
("daqd" ["打枪"])
("daqi" ["打气"])
("daqm" ["大钱"])
("daqn" ["大秦"])
("daqq" ["打球"])
("daqr" ["大权"])
("daqu" ["打趣" "大曲"])
("daqy" ["大庆"])
("dar'" "大")
("darf" ["达人" "大人"])
("dark" ["打扰"])
("daru" ["打入" "大儒"])
("dasi" ["大肆" "大四"])
("dasj" ["打散" "大三"])
("dask" ["打扫" "大嫂"])
("dasr" ["打算" "大蒜"])
("dasv" ["打碎"])
("dat'" "塔疸")
("datb" ["打头" "大头"])
("dath" ["大堂"])
("dati" ["大体"])
("datm" ["大田"])
("dats" ["打通" "大同"])
("datu" ["大土"])
("datv" ["打退" "大腿"])
("datx" ["打铁"])
("daty" ["打听" "大厅"])
("daua" ["大厦"])
("daub" ["打手"])
("daue" ["大赦"])
("daug" ["大声"])
("daui" ["大师" "大使" "大事" "大势"])
("dauj" ["搭讪"])
("daup" ["大顺"])
("dauu" ["大叔" "大数"])
("dauv" ["大水"])
("davb" ["大洲"])
("davd" ["打桩"])
("davf" ["打针"])
("davh" ["打仗"])
("davi" ["大志" "大致" "大治"])
("davj" ["大战"])
("davk" ["大诰"])
("davl" ["大寨"])
("davr" ["打转"])
("davs" ["打中" "大众"])
("davu" ["大竹"])
("daw'" "达答瘩打怛妲沓笪靼鞑")
("dawh" ["大王"])
("dawu" ["大悟"])
("dawz" ["大尉" "大卫"])
("daxc" ["打消" "大小" "大校"])
("daxd" ["打响" "大象"])
("daxi" ["大喜" "大戏"])
("daxm" ["大限"])
("daxn" ["大新"])
("daxq" ["大修"])
("daxr" ["大选"])
("daxs" ["大熊"])
("daxt" ["大学" "大雪"])
("daxw" ["打下" "大侠"])
("daxx" ["答谢" "大写"])
("daxy" ["大兴" "大型"])
("daya" ["大雅"])
("dayb" ["大油" "大有"])
("daye" ["大爷" "大冶" "大业"])
("dayh" ["大洋"])
("dayi" ["达意" "大一" "大衣" "大意"])
("dayj" ["打眼" "大烟" "大雁"])
("dayk" ["大要"])
("dayn" ["达因" "打印" "大印"])
("dayr" ["大员" "大圆" "大院"])
("days" ["大用"])
("dayt" ["大约" "大月"])
("dayu" ["大于" "大雨"])
("dayy" ["答应"])
("daza" ["打杂"])
("dazi" ["打字"])
("dazo" ["大作"])
("dazs" ["大宗"])
("dazu" ["大族"])
("db'" ["代表"])
("dbb'" ["大笨伯"])
("dbba" ["都把"])
("dbbj" ["豆办"])
("dbbu" ["都不"])
("dbby" ["豆饼"])
("dbbz" ["都被"])
("dbc'" ["大白菜"])
("dbd'" ["动不动"])
("dbdb" ["兜兜" "抖抖"])
("dbde" ["都得"])
("dbdh" ["代表大会"])
("dbdk" ["斗倒"])
("dbdm" ["逗点"])
("dbds" ["抖动"])
("dbdv" ["都对"])
("dbdy" ["篼钉"])
("dbe'" "抖斗陡蚪")
("dbef" ["对苯二酚"])
("dbes" ["对苯二甲酸"])
("dbf'" ["大部分"])
("dbfg" ["兜风"])
("dbfu" ["豆腐"])
("dbg'" ["打不过"])
("dbgh" ["电报挂号"])
("dbhf" ["都很"])
("dbhk" ["逗号"])
("dbhv" ["都会"])
("dbi'" ["代办处" "敌百虫"])
("dbiu" ["得不偿失"])
("dbj'" ["东北军"])
("dbjd" ["豆浆" "都将"])
("dbjx" ["篼接"])
("dbke" ["豆科"])
("dbl'" ["大辩论" "大不了"])
("dbld" ["大不列颠"])
("dbli" ["斗笠" "豆粒"])
("dblq" ["逗留"])
("dblx" ["大步流星"])
("dblz" ["豆类"])
("dbm'" ["蛋白酶"])
("dbmc" ["豆苗" "痘苗"])
("dbmf" ["斗门"])
("dbmz" ["都没"])
("dbpo" ["陡坡"])
("dbq'" ["兜" "都" "蔸" "篼" "对不起"])
("dbqc" ["陡峭"])
("dbqr" ["兜圈"])
("dbr'" "斗豆逗痘读窦")
("dbrj" ["陡然"])
("dbs'" ["顿巴斯"])
("dbsb" ["抖擞"])
("dbt'" ["代表团" "单倍体" "多倍体"])
("dbu'" ["大白鼠" "大别山"])
("dbua" ["豆沙"])
("dbub" ["兜售"])
("dbui" ["都是"])
("dbul" ["等比数列"])
("dbv'" ["蛋白质" "对不住"])
("dbva" ["豆渣"])
("dbvg" ["斗争"])
("dbvi" ["斗志" "斗智"])
("dbw'" ["董必武"])
("dbx'" ["电冰箱" "多边形"])
("dbxd" ["都想"])
("dbxj" ["短兵相接"])
("dby'" ["大本营"])
("dbyb" ["豆油" "都有"])
("dbyi" ["都已"])
("dbyk" ["都要"])
("dbys" ["都用"])
("dbyu" ["都与"])
("dbyy" ["都应"])
("dbzi" ["豆子"])
("dbzl" ["都在"])
("dc'" ["对此"])
("dcb'" ["电磁波"])
("dcbi" ["凋敝"])
("dcbk" ["碉堡" "调包"])
("dcbo" ["调拨"])
("dcby" ["调兵"])
("dcds" ["调动"])
("dcdu" ["调度"])
("dcdv" ["掉队"])
("dce'" "鸟")
("dcfu" ["电磁辐射"])
("dcgb" ["吊钩"])
("dcgj" ["吊杆"])
("dcgy" ["电磁感应"])
("dchk" ["调号"])
("dchr" ["掉换" "吊环" "调换"])
("dchv" ["调回"])
("dci'" ["电磁场"])
("dcia" ["调查"])
("dcie" ["吊车" "调车"])
("dciu" ["调出"])
("dcji" ["调集" "督促检查"])
("dcjw" ["吊架"])
("dcke" ["雕刻"])
("dcli" ["调离"])
("dcnj" ["刁难"])
("dcpi" ["貂皮"])
("dcpj" ["吊盘"])
("dcq'" "碉叼雕凋刁貂鲷")
("dcqc" ["吊桥"])
("dcqm" ["调遣"])
("dcr'" "掉吊钓调铞铫")
("dcrf" ["调任"])
("dcru" ["调入"])
("dcsi" ["吊死"])
("dcso" ["吊索"])
("dcsu" ["雕塑"])
("dct'" ["电磁铁"])
("dctb" ["掉头"])
("dcts" ["吊桶"])
("dcui" ["调式"])
("dcv'" ["独裁者"])
("dcvd" ["电磁振荡"])
("dcve" ["叼着"])
("dcvi" ["调质"])
("dcvo" ["雕琢"])
("dcvr" ["掉转"])
("dcwv" ["到此为止"])
("dcx'" ["电磁学"])
("dcxc" ["吊销"])
("dcxd" ["雕像"])
("dcxw" ["掉下"])
("dcxx" ["凋谢"])
("dcxy" ["调性"])
("dcy'" ["大草原"])
("dcyn" ["调音"])
("dcyp" ["调运"])
("dcys" ["调用"])
("dcyu" ["钓鱼"])
("dczi" ["调子"])
("dd'" ["达到"])
("ddb'" ["党代表"])
("ddbx" ["喋喋不休"])
("dddd" ["地地道道"])
("dddz" ["斗大的字"])
("ddg'" ["道德感" "滴定管"])
("ddgf" ["道德规范"])
("ddh'" ["大渡河" "点电荷" "打电话"])
("ddhb" ["颠倒黑白"])
("ddiu" ["大打出手"])
("ddj'" ["电动机" "对顶角"])
("ddkf" ["大刀阔斧"])
("ddl'" ["大道理"])
("ddm'" ["大动脉"])
("ddp'" ["电灯泡"])
("ddq'" ["对得起"])
("ddt'" ["滴滴涕"])
("ddu'" ["大多数" "电动势"])
("dduf" ["颠倒是非"])
("ddvx" ["道德哲学"])
("ddw'" ["东帝汶"])
("ddwb" ["地大物博"])
("ddxx" ["断断续续"])
("ddy'" ["端电压" "短大衣"])
("ddz'" ["大肚子"])
("dean" ["得安"])
("deby" ["得病"])
("dec'" ["第二次"])
("decv" ["第二次世界大战"])
("dedh" ["得当"])
("dedk" ["得到"])
("defa" ["得法"])
("deff" ["得分"])
("degj" ["第二国际"])
("dego" ["德国"])
("dehj" ["德汉"])
("dehw" ["的话"])
("deig" ["得逞"])
("deiu" ["得出"])
("dejd" ["得奖"])
("dejq" ["得救"])
("delc" ["得了"])
("deli" ["得力"])
("dem'" ["第二名"])
("deqi" ["得气"])
("der'" "的")
("dese" ["得色"])
("det'" "的地得底")
("deti" ["得体"])
("deu'" ["第二审"])
("deub" ["得手"])
("deug" ["得胜"])
("deui" ["得失" "得势"])
("deuj" ["第二世界"])
("deuu" ["得数"])
("devb" ["德州"])
("devi" ["得知" "得志"])
("dew'" ["德" "得" "锝" "达尔文"])
("dewf" ["德文"])
("dex'" ["第二性"])
("dexi" ["得悉"])
("dexy" ["德兴" "德行"])
("dey'" ["窦娥冤"])
("deyd" ["第二宇宙速度"])
("deyi" ["得以" "得意" "得益"])
("deys" ["得用"])
("deyu" ["德语" "德育"])
("dezi" ["得子"])
("dezv" ["得罪"])
("df'" ["地方"])
("dfb'" ["地方病"])
("dfbd" ["地方部队"])
("dfd'" ["大幅度"])
("dfdl" ["大风大浪"])
("dffq" ["地方分权"])
("dfg'" ["大法官"])
("dfgy" ["地方工业" "地方国营"])
("dfh'" ["东方红"])
("dfj'" ["地方军"])
("dfm'" ["单方面" "多方面"])
("dfp'" ["豆腐皮"])
("dfr'" ["豆腐乳"])
("dfu'" ["带分数" "地方税" "电风扇"])
("dfvf" ["地方政府"])
("dfwv" ["地方武装"])
("dfx'" ["大方向" "地方戏"])
("dfz'" ["大分子"])
("dfzj" ["登峰造极"])
("dfzv" ["地方自治"])
("dgan" ["登岸"])
("dgb'" ["大公报"])
("dgbc" ["灯标"])
("dgbk" ["登报"])
("dgbm" ["等边"])
("dgdg" ["等等"])
("dgdk" ["等到"])
("dgdl" ["等待"])
("dge'" ["等" "戥" "大个儿"])
("dgf'" ["大锅饭"])
("dgff" ["等分" "等份"])
("dggd" ["灯光"])
("dggi" ["大功告成"])
("dggk" ["登高" "等高"])
("dgh'" ["单干户"])
("dghb" ["等候"])
("dghk" ["等号"])
("dgho" ["灯火"])
("dghz" ["灯黑"])
("dgi'" ["胆固醇"])
("dgia" ["等差"])
("dgih" ["登场"])
("dgjc" ["等角"])
("dgjd" ["等奖"])
("dgji" ["登极" "登记" "等级"])
("dgju" ["灯具" "等距"])
("dgjw" ["等价"])
("dgl'" ["大功率" "戴高乐" "电功率"])
("dgld" ["等量"])
("dgls" ["灯笼"])
("dglu" ["登陆"])
("dgm'" ["大革命" "大规模"])
("dgmf" ["登门"])
("dgml" ["大规模集成电路"])
("dgn'" ["大姑娘" "大闺女" "多功能"])
("dgpk" ["灯泡"])
("dgpn" ["等品"])
("dgq'" ["蹬" "灯" "登" "噔" "簦" "地滚球"])
("dgqg" ["得过且过"])
("dgr'" "澄蹬瞪凳邓嶝磴镫")
("dgrf" ["等人"])
("dgri" ["等日"])
("dgs'" ["打官司"])
("dgsi" ["灯丝"])
("dgta" ["灯塔"])
("dgtl" ["登台"])
("dgts" ["等同"])
("dguh" ["登上"])
("dgui" ["等式"])
("dguj" ["登山"])
("dgve" ["等着"])
("dgvk" ["灯罩"])
("dgvy" ["帝国主义"])
("dgvz" ["帝国主义分子"])
("dgwf" ["等温"])
("dgwl" ["等外"])
("dgwm" ["大革文化命"])
("dgws" ["大公无私"])
("dgx'" ["等高线"])
("dgxc" ["等效"])
("dgxm" ["等闲"])
("dgyb" ["灯油"])
("dgyj" ["瞪眼"])
("dgyk" ["等腰"])
("dgyu" ["等于"])
("dgyy" ["灯影"])
("dgz'" ["打棍子" "大个子"])
("dgzi" ["凳子"])
("dgzl" ["登载"])
("dh'" ["大会"])
("dhan" ["档案"])
("dhbj" ["挡板"])
("dhbk" ["党报"])
("dhby" ["当兵"])
("dhci" ["档次"])
("dhde" ["党的"])
("dhdh" ["当当" "荡荡"])
("dhdi" ["当地"])
("dhdj" ["大喊大叫"])
("dhdk" ["当道"])
("dhdl" ["当代"])
("dhe'" ["挡" "党" "谠" "大伙儿"])
("dher" ["当儿"])
("dhf'" ["大后方"])
("dhfg" ["挡风" "党风"])
("dhfu" ["荡妇"])
("dhfz" ["党费"])
("dhg'" ["读后感"])
("dhgh" ["党纲"])
("dhgo" ["当过"])
("dhgr" ["当官"])
("dhh'" ["电火花"])
("dhhm" ["电话号码"])
("dhhy" ["电话会议"])
("dhi'" ["大合唱"])
("dhie" ["挡车"])
("dhig" ["当成"])
("dhih" ["当场"])
("dhil" ["当差"])
("dhiu" ["当初"])
("dhj'" ["碘化钾"])
("dhjg" ["低合金钢"])
("dhji" ["当即" "党籍" "党纪"])
("dhjn" ["当今"])
("dhju" ["当局"])
("dhjw" ["当家"])
("dhjy" ["电化教育"])
("dhke" ["党课"])
("dhks" ["当空"])
("dhl'" ["德黑兰" "定滑轮" "动滑轮"])
("dhld" ["当量"])
("dhlu" ["挡路"])
("dhly" ["当令"])
("dhmm" ["当面"])
("dhnm" ["当年"])
("dhnz" ["党内"])
("dhpl" ["党派"])
("dhpu" ["当铺"])
("dhpy" ["荡平"])
("dhq'" "当铛裆")
("dhqm" ["当前"])
("dhqr" ["当权"])
("dhr'" "当挡荡档凼菪宕砀")
("dhrf" ["党人"])
("dhri" ["当日"])
("dhrj" ["当然"])
("dhs'" ["导火索"])
("dhtb" ["当头"])
("dhtm" ["当天"])
("dhtr" ["党团"])
("dhui" ["当时" "当世" "当事" "党史"])
("dhvf" ["当真"])
("dhvg" ["当政" "党政"])
("dhvh" ["党章"])
("dhvs" ["当中" "当众"])
("dhvu" ["挡住"])
("dhwj" ["当晚"])
("dhwl" ["党外"])
("dhwu" ["党务"])
("dhwz" ["党委"])
("dhx'" ["电化学"])
("dhxc" ["党校"])
("dhxm" ["当先"])
("dhxn" ["当心"])
("dhxr" ["当选"])
("dhxw" ["当下"])
("dhxy" ["党性"])
("dhy'" ["大黄鱼" "碘化银"])
("dhyh" ["荡漾"])
("dhyr" ["党员"])
("dhyt" ["当月"])
("dhyu" ["党羽"])
("dhzl" ["党在"])
("dhzo" ["当做" "当作"])
("dhzu" ["党组"])
("diai" ["低矮"])
("dian" ["堤岸"])
("diba" ["堤坝" "第八"])
("dibc" ["地表"])
("dibf" ["底本"])
("dibj" ["底版" "地板"])
("dibk" ["地保" "地堡"])
("dibm" ["底边"])
("dibo" ["地波"])
("dibu" ["地步"])
("dicg" ["底层" "地层"])
("dici" ["地磁"])
("dida" ["抵达"])
("didg" ["低等"])
("didh" ["低档" "抵挡"])
("didi" ["低低" "低地" "弟弟"])
("didk" ["地道"])
("didl" ["地带"])
("didm" ["地点" "地电"])
("didr" ["地段"])
("dids" ["地动" "地洞"])
("didv" ["敌对"])
("didy" ["滴定"])
("die'" "抵底氐诋邸坻柢砥骶")
("diee" ["帝俄"])
("dier" ["第二"])
("difh" ["堤防" "地方"])
("difz" ["底肥"])
("digj" ["大肠杆菌"])
("digk" ["底稿"])
("digo" ["敌国" "帝国"])
("digr" ["滴管"])
("digu" ["低估" "嘀咕"])
("digv" ["递归"])
("digw" ["地瓜"])
("dihb" ["敌后"])
("dihd" ["帝皇"])
("dihk" ["低耗"])
("dihv" ["诋毁"])
("diif" ["低沉"])
("diih" ["抵偿"])
("diij" ["低产" "地产"])
("diik" ["低潮"])
("diiq" ["电除尘器"])
("diiu" ["抵触"])
("diiv" ["低垂"])
("dij'" ["电唱机" "电传机"])
("dijc" ["地窖" "递交"])
("diji" ["低级" "敌机" "地基"])
("dijm" ["递减"])
("dijp" ["敌军"])
("dijq" ["第九"])
("dijw" ["地价"])
("dijx" ["地界" "缔结"])
("dikb" ["敌寇"])
("dikh" ["抵抗"])
("diks" ["低空"])
("diky" ["地块"])
("dila" ["地蜡"])
("dili" ["地理" "地利"])
("dilj" ["低栏"])
("dill" ["抵赖"])
("dilm" ["低廉"])
("dilo" ["低落"])
("dilp" ["涤纶"])
("dilq" ["第六"])
("dils" ["地龙"])
("dilx" ["低劣"])
("dilz" ["地雷"])
("dimj" ["地幔"])
("dimk" ["地貌"])
("dimm" ["地面"])
("dimo" ["笛膜"])
("dimu" ["地亩"])
("dimy" ["地名"])
("dimz" ["弟妹"])
("ding" ["低能"])
("dipi" ["地皮" "地痞"])
("dipj" ["底盘" "地盘"])
("dipm" ["底片"])
("dipn" ["低频"])
("dipy" ["地平"])
("diq'" ["堤" "低" "滴" "提" "氐" "嘀" "镝" "羝" "东城区"])
("diqc" ["地壳"])
("diqi" ["第七"])
("diqn" ["嫡亲"])
("diqq" ["地球"])
("diqt" ["的确"])
("diqu" ["地区"])
("diqy" ["敌情"])
("dir'" "的地蒂第帝弟递缔谛娣绨棣碲睇")
("dire" ["地热"])
("dirf" ["敌人"])
("dise" ["底色"])
("disi" ["第四"])
("disj" ["第三"])
("diss" ["递送"])
("disu" ["低速"])
("ditb" ["低头" "地头"])
("dite" ["敌特"])
("ditj" ["地坛" "地毯"])
("ditu" ["地图"])
("ditx" ["地铁"])
("dity" ["谛听"])
("diub" ["敌手"])
("diug" ["低声"])
("diuh" ["地上"])
("diui" ["敌视" "地势" "第十"])
("diul" ["等差数列"])
("diuu" ["底数"])
("diuv" ["滴水"])
("div'" ["对称轴"])
("divb" ["地轴"])
("divf" ["地震"])
("divg" ["地政"])
("divi" ["抵制" "地支" "地址" "地质"])
("divl" ["抵债"])
("divu" ["底柱" "地主"])
("divx" ["对称中心"])
("diw'" "的迪敌笛狄涤翟嫡籴荻嘀觌镝")
("diwa" ["低洼"])
("diwf" ["低温" "地温"])
("diwh" ["帝王"])
("diwo" ["敌我"])
("diwu" ["地物" "第五"])
("diwz" ["低微" "敌伪" "地位"])
("dix'" ["独创性"])
("dixc" ["抵销" "抵消"])
("dixi" ["嫡系" "底细"])
("dixm" ["地线"])
("dixn" ["地心"])
("dixs" ["弟兄"])
("dixt" ["地学"])
("dixw" ["低下" "底下" "地下"])
("dixy" ["地形"])
("diy'" ["都察院"])
("diya" ["低压" "抵押"])
("diyi" ["敌意" "第一"])
("diyj" ["调查研究"])
("diyn" ["低音"])
("diyp" ["打成一片"])
("diyt" ["缔约"])
("diyu" ["低于" "低语" "抵御" "地域" "地狱"])
("diz'" ["电池组"])
("dizg" ["递增"])
("dizi" ["笛子" "弟子"])
("dizk" ["缔造"])
("dizo" ["底座"])
("dizu" ["地租"])
("dizv" ["抵罪"])
("dj'" ["大家"])
("djbf" ["打击报复"])
("djbk" ["担保"])
("djbl" ["单摆" "蛋白"])
("djbm" ["单边"])
("djbo" ["单薄" "淡薄"])
("djbu" ["但不"])
("djc'" ["电解槽"])
("djci" ["单词"])
("djcs" ["但从"])
("djd'" ["打交道"])
("djda" ["单打" "胆大"])
("djdc" ["单调"])
("djdh" ["担当"])
("djdj" ["单单" "淡淡"])
("djdk" ["弹道"])
("djdp" ["丹顿"])
("djdq" ["电解电容器"])
("djdu" ["单独"])
("djdv" ["但对"])
("dje'" "担掸胆赕疸瘅")
("djfh" ["单方"])
("djfj" ["但凡"])
("djfu" ["担负"])
("djfz" ["氮肥"])
("djge" ["耽搁"])
("djgf" ["党纪国法"])
("djgh" ["单杠"])
("djgj" ["单干" "胆敢"])
("djgk" ["蛋糕"])
("djgr" ["胆管"])
("djh'" ["定计划"])
("djhd" ["蛋黄"])
("djhk" ["单号"])
("djhl" ["但还"])
("djhw" ["氮化" "淡化"])
("djie" ["单车"])
("djif" ["诞辰"])
("djig" ["单程"])
("djij" ["单产"])
("djip" ["单纯"])
("djj'" ["大将军"])
("djjc" ["单交"])
("djji" ["单机" "淡季"])
("djjm" ["单间" "但见"])
("djju" ["单据"])
("djjw" ["担架" "单价"])
("djke" ["但可" "蛋壳"])
("djl'" ["等距离"])
("djld" ["胆量" "当机立断"])
("djlt" ["胆略"])
("djma" ["但马"])
("djml" ["丹麦"])
("djmz" ["但没"])
("djng" ["但能"])
("djnh" ["胆囊"])
("djny" ["单宁"])
("djq'" "耽担丹单郸儋殚眈瘅聃箪")
("djqi" ["氮气"])
("djqx" ["胆怯"])
("djqy" ["淡青" "蛋清"])
("djr'" ["担" "旦" "氮" "但" "惮" "淡" "诞" "弹" "蛋" "石" "萏" "啖" "澹" "瘅" "奠基人"])
("djrf" ["担任" "单人"])
("djrj" ["淡然"])
("djru" ["但如"])
("djse" ["单色"])
("djsi" ["单丝"])
("djt'" ["大家庭" "大教堂"])
("djta" ["但他"])
("djtb" ["弹头"])
("djth" ["单糖"])
("djti" ["单体"])
("djtm" ["丹田"])
("djtu" ["丹徒"])
("djuf" ["单身"])
("djug" ["诞生"])
("djui" ["胆识" "但是"])
("djuu" ["单数"])
("djuv" ["淡水"])
("djv'" ["电解质" "电介质"])
("djvi" ["单质" "胆汁"])
("djw'" ["等价物"])
("djwu" ["耽误"])
("djwz" ["单位"])
("djx'" ["对角线" "多角形"])
("djxc" ["胆小"])
("djxd" ["单相" "单项" "单向"])
("djxg" ["大惊小怪"])
("djxi" ["旦夕"])
("djxm" ["单线"])
("djxn" ["担心" "丹心"])
("djxy" ["单行"])
("djy'" ["都江堰"])
("djyb" ["担忧"])
("djyh" ["丹阳"])
("djyi" ["单一" "单衣"])
("djyj" ["单眼"])
("djyk" ["弹药"])
("djyr" ["单元" "但愿"])
("djyu" ["单于"])
("djyy" ["但应"])
("djzi" ["担子" "单子" "单字" "胆子"])
("djzl" ["但在"])
("djzo" ["单作"])
("djzv" ["当家作主"])
("dkb'" ["地矿部"])
("dkba" ["刀把" "倒把"])
("dkbi" ["倒闭"])
("dkbj" ["导板"])
("dkby" ["刀柄"])
("dkbz" ["刀背"])
("dkci" ["悼词"])
("dkck" ["稻草"])
("dkda" ["到达"])
("dkde" ["道德"])
("dkdi" ["到底"])
("dkdj" ["捣蛋" "导弹"])
("dkdk" ["道道" "叨叨"])
("dkdm" ["导电"])
("dkdy" ["到顶" "道钉"])
("dke'" ["捣" "蹈" "倒" "岛" "祷" "导" "达喀尔" "笛卡儿"])
("dkfa" ["刀法"])
("dkfg" ["刀锋"])
("dkfh" ["倒放"])
("dkfj" ["倒反"])
("dkfu" ["倒伏"])
("dkfz" ["盗匪"])
("dkgd" ["道光"])
("dkge" ["倒戈"])
("dkgk" ["祷告"])
("dkgo" ["岛国"])
("dkgr" ["倒灌" "导管"])
("dkgu" ["稻谷"])
("dkgv" ["捣鬼" "导轨"])
("dkhe" ["道贺" "氘核"])
("dkhh" ["导航"])
("dkhk" ["倒好"])
("dkhr" ["倒换"])
("dkhu" ["多快好省"])
("dkhv" ["捣毁" "到会"])
("dki'" ["大客车"])
("dkia" ["道岔"])
("dkie" ["倒车"])
("dkih" ["到场"])
("dkiu" ["到处"])
("dkjc" ["道教"])
("dkjm" ["刀尖"])
("dkju" ["刀具" "道具"])
("dkjw" ["刀架" "到家" "道家"])
("dkkb" ["刀口" "道口"])
("dkl'" ["抵抗力"])
("dklc" ["到了"])
("dkli" ["倒立" "道理"])
("dklk" ["叨唠"])
("dkll" ["到来"])
("dklp" ["导轮"])
("dklq" ["倒流" "导流"])
("dklr" ["捣乱"])
("dklu" ["道路"])
("dkmf" ["道门"])
("dkmi" ["稻米"])
("dkml" ["倒卖"])
("dkmz" ["倒霉" "倒楣"])
("dkna" ["导纳"])
("dknm" ["悼念"])
("dkpj" ["导盘"])
("dkpm" ["刀片"])
("dkq'" "刀叨忉氘")
("dkqd" ["刀枪"])
("dkqi" ["到期"])
("dkqm" ["道歉"])
("dkqu" ["盗取"])
("dkqx" ["盗窃"])
("dkqy" ["道情"])
("dkr'" "倒到稻悼道盗帱焘纛")
("dkre" ["导热"])
("dkrf" ["刀刃" "到任"])
("dksl" ["多孔塑料"])
("dksv" ["捣碎" "稻穗"])
("dkta" ["倒塌"])
("dktb" ["到头"])
("dktg" ["倒腾"])
("dkti" ["导体"])
("dktl" ["倒台"])
("dktm" ["稻田"])
("dktv" ["倒退"])
("dku'" ["打瞌睡"])
("dkub" ["到手"])
("dkuh" ["岛上"])
("dkui" ["倒是" "导师" "道士"])
("dkuj" ["刀山"])
("dkuu" ["倒数" "导数"])
("dkve" ["到这"])
("dkvi" ["倒置" "导致"])
("dkvj" ["到站"])
("dkvr" ["倒转"])
("dkvs" ["稻种"])
("dkw'" "叨")
("dkx'" ["对抗性"])
("dkxd" ["导向"])
("dkxi" ["道喜"])
("dkxm" ["导线"])
("dkxr" ["倒悬"])
("dkxt" ["道学"])
("dkxu" ["对口相声"])
("dkxw" ["倒下"])
("dkxx" ["道谢"])
("dkyb" ["导游"])
("dkye" ["倒爷"])
("dkyh" ["稻秧"])
("dkyi" ["道义"])
("dkyj" ["导言" "导演"])
("dkyr" ["道员"])
("dkys" ["盗用"])
("dkyu" ["岛屿"])
("dkyy" ["倒影"])
("dkzi" ["刀子" "稻子"])
("dkzz" ["盗贼"])
("dlb'" ["电流表"])
("dlbc" ["代表"])
("dlbj" ["代办"])
("dlbu" ["逮捕"])
("dlby" ["带病"])
("dlc'" ["电离层" "对流层"])
("dlci" ["代词"])
("dld'" ["多伦多"])
("dldd" ["多劳多得"])
("dldm" ["带电"])
("dlds" ["带动"])
("dldv" ["带队"])
("dle'" "歹傣逮")
("dlfh" ["带方" "贷方"])
("dlfu" ["大夫"])
("dlg'" ["独立国"])
("dlgb" ["代购"])
("dlgg" ["代耕"])
("dlgh" ["带钢"])
("dlgr" ["代管"])
("dlgs" ["怠工"])
("dlgy" ["电力工业"])
("dlgz" ["带给"])
("dlh'" ["度量衡"])
("dlhk" ["代号"])
("dlhs" ["独立核算"])
("dlhv" ["代会" "待会"])
("dlia" ["待查"])
("dlih" ["代偿"])
("dliu" ["带出"])
("dlj'" ["大陆架" "电流计"])
("dljn" ["代金"])
("dljq" ["电流继电器"])
("dlju" ["带锯"])
("dljw" ["代价"])
("dlkr" ["贷款"])
("dll'" ["对硫磷"])
("dlli" ["代理"])
("dllk" ["代劳"])
("dlll" ["带来"])
("dllm" ["达赖喇嘛"])
("dllu" ["带路"])
("dlly" ["带领"])
("dlm'" ["杜鲁门" "对立面"])
("dlma" ["代码"])
("dlmj" ["怠慢"])
("dlmk" ["戴帽"])
("dlmy" ["待命"])
("dln'" ["地拉那" "电离能"])
("dlnd" ["当量浓度"])
("dlq'" "呆待呔")
("dlqd" ["电流强度" "断裂强度"])
("dlr'" ["大" "戴" "带" "殆" "代" "贷" "袋" "待" "逮" "怠" "埭" "甙" "岱" "迨" "骀" "绐" "玳" "黛" "代理人"])
("dls'" ["大理寺"])
("dlt'" ["电烙铁" "电路图"])
("dltb" ["带头"])
("dlti" ["代替"])
("dltu" ["歹徒"])
("dlty" ["对立统一"])
("dlu'" ["大理石"])
("dlug" ["打落水狗"])
("dluh" ["戴上"])
("dlui" ["大量生产"])
("dluu" ["代数"])
("dlve" ["带着"])
("dlvi" ["呆滞" "待制"])
("dlvu" ["呆住"])
("dlvv" ["动力装置"])
("dlw'" ["电力网"])
("dlwg" ["独立王国"])
("dlwo" ["代我"])
("dlwv" ["地理位置"])
("dlwz" ["代为"])
("dlx'" ["地理学" "电力线" "动力学" "独立性"])
("dlxc" ["代销"])
("dlxd" ["带向"])
("dlxw" ["带下"])
("dlxx" ["代谢"])
("dlxy" ["代行"])
("dly'" ["大理院"])
("dlyb" ["带有"])
("dlye" ["待业"])
("dlys" ["代用"])
("dlyu" ["带鱼" "待遇"])
("dlz'" ["等离子"])
("dlzb" ["带走"])
("dlzi" ["带子" "袋子"])
("dlzt" ["等离子体"])
("dlzu" ["傣族"])
("dlzv" ["独立自主"])
("dmbc" ["电表"])
("dmbd" ["地面部队"])
("dmbj" ["垫板"])
("dmbk" ["电报"])
("dmbo" ["颠簸" "点播" "点拨" "电波"])
("dmbz" ["垫背"])
("dmc'" ["代名词" "动名词"])
("dmci" ["电磁"])
("dmcl" ["点菜"])
("dmdg" ["点灯" "电灯"])
("dmdh" ["典当"])
("dmdi" ["点滴"])
("dmdk" ["颠倒" "电导"])
("dmdm" ["点点"])
("dmds" ["电动"])
("dmdu" ["电镀"])
("dmdy" ["大模大样" "奠定"])
("dme'" "碘点典丶踮")
("dmer" ["点儿"])
("dmfa" ["点发"])
("dmff" ["淀粉"])
("dmfj" ["典范"])
("dmfu" ["颠覆" "颠复" "垫付"])
("dmg'" ["动脉弓"])
("dmgd" ["电光"])
("dmgj" ["电感"])
("dmgk" ["电告"])
("dmgs" ["电工"])
("dmgu" ["典故"])
("dmh'" ["多玛河"])
("dmhe" ["电荷" "电贺"])
("dmhj" ["电焊"])
("dmho" ["点火"])
("dmhu" ["电弧" "佃户"])
("dmhw" ["电话"])
("dmie" ["电车"])
("dmih" ["电场"])
("dmii" ["电池"])
("dmij" ["电铲"])
("dmiu" ["点出"])
("dmj'" ["独幕剧"])
("dmjd" ["点将"])
("dmjh" ["点面结合"])
("dmji" ["典籍" "电机" "电极" "惦记" "奠基"])
("dmjm" ["电键"])
("dmjq" ["碘酒"])
("dmjw" ["店家"])
("dmjx" ["电解"])
("dmk'" ["大门口"])
("dmke" ["佃客"])
("dmkh" ["电抗"])
("dmld" ["掂量" "电量"])
("dmli" ["典礼" "电离" "电力"])
("dmlj" ["靛蓝" "电缆"])
("dmlq" ["电流"])
("dmlu" ["电炉" "电路"])
("dmly" ["电铃"])
("dmma" ["电码"])
("dmmy" ["点名"])
("dmng" ["电能"])
("dmnj" ["多米尼加"])
("dmnk" ["电脑"])
("dmnm" ["惦念"])
("dmns" ["佃农"])
("dmpm" ["垫片"])
("dmpo" ["点破"])
("dmpu" ["店铺"])
("dmpy" ["垫平" "电瓶"])
("dmq'" ["颠" "掂" "滇" "巅" "癫" "独木桥"])
("dmqc" ["电桥"])
("dmqi" ["电器" "电气"])
("dmqr" ["垫圈"])
("dmqy" ["点清"])
("dmr'" "靛垫电佃甸店惦奠淀殿阽坫玷钿癜簟")
("dmre" ["电热"])
("dmrj" ["点燃"])
("dmrs" ["电容"])
("dmt'" ["多面体"])
("dmtb" ["点头"])
("dmti" ["电梯"])
("dmtl" ["电台"])
("dmts" ["电筒"])
("dmu'" ["单名数" "地面水" "多面手"])
("dmug" ["大马士革"])
("dmui" ["电视"])
("dmuj" ["电扇"])
("dmuu" ["点数"])
("dmuw" ["电刷"])
("dmv'" ["大民主" "大拇指" "地面站" "独木舟"])
("dmvf" ["点阵"])
("dmvh" ["典章"])
("dmvj" ["电站"])
("dmvv" ["点缀"])
("dmw'" ["大门外"])
("dmwd" ["地面温度"])
("dmwf" ["电文"])
("dmwh" ["电网"])
("dmwu" ["玷污"])
("dmwz" ["电位"])
("dmx'" ["动脉血"])
("dmxm" ["电线"])
("dmxn" ["点心" "电信"])
("dmxp" ["电讯"])
("dmxt" ["电学"])
("dmxw" ["殿下"])
("dmxy" ["点醒" "典型"])
("dmya" ["电压"])
("dmyp" ["电晕"])
("dmyr" ["店员" "电源"])
("dmys" ["电泳"])
("dmyy" ["电影"])
("dmz'" ["大帽子"])
("dmzi" ["垫子" "电子"])
("dmzj" ["多民族国家"])
("dmzr" ["电钻"])
("dmzu" ["电阻"])
("dnbd" ["大逆不道"])
("dndv" ["党内斗争"])
("dngh" ["对内搞活"])
("dnj'" ["动脑筋"])
("dnl'" ["多年来"])
("dnpc" ["大脑皮层"])
("dnu'" ["多年生"])
("dnwl" ["电脑网络"])
("dny'" ["东南亚"])
("dnym" ["东南亚国家联盟"])
("dobc" ["夺标"])
("dobi" ["躲避"])
("dobj" ["多半"])
("dobm" ["多边" "多变"])
("doch" ["躲藏"])
("doci" ["多次"])
("doda" ["多达" "多大"])
("dode" ["多德" "夺得"])
("dodk" ["多到"])
("dodm" ["多点"])
("dodo" ["多多"])
("dodr" ["多端"])
("doe'" "垛躲朵哚缍")
("dofa" ["多发"])
("doff" ["多分"])
("dofh" ["多方"])
("doge" ["多哥" "多个"])
("dogk" ["多高"])
("dogw" ["多寡"])
("dohv" ["夺回"])
("doih" ["多长"])
("doiu" ["多处"])
("dojc" ["跺脚"])
("dojq" ["多久"])
("dojw" ["多加"])
("dokl" ["躲开"])
("doks" ["多孔"])
("dokv" ["多亏"])
("dola" ["多拉"])
("dolo" ["堕落"])
("dolp" ["舵轮"])
("dolu" ["多路"])
("dome" ["多么"])
("domm" ["多面"])
("domu" ["夺目"])
("donm" ["多年"])
("dopy" ["东欧平原"])
("doq'" "多掇哆咄裰")
("doqi" ["躲起"])
("doqr" ["夺权"])
("doqu" ["夺取"])
("doqy" ["多情"])
("dor'" "垛跺舵剁惰堕驮沲柁")
("dorb" ["剁肉"])
("doru" ["堕入"])
("doso" ["哆嗦"])
("dosv" ["剁碎"])
("dotb" ["多头"])
("doth" ["多醣"])
("dotl" ["多肽"])
("doub" ["舵手"])
("doui" ["多时" "多事"])
("douj" ["躲闪"])
("douk" ["多少"])
("douu" ["多数"])
("dovs" ["多种"])
("dow'" "度夺铎踱")
("doxd" ["多相" "多项"])
("doxn" ["多心"])
("doxx" ["多谢"])
("doxy" ["惰性"])
("doyh" ["多样"])
("doyp" ["多云"])
("doyr" ["多元" "多远"])
("doys" ["多用"])
("doyu" ["多于" "多余"])
("dozj" ["多咱"])
("dozl" ["躲在"])
("dozv" ["多嘴"])
("dpbp" ["颠扑不破"])
("dpbu" ["墩布"])
("dpco" ["顿挫"])
("dpcu" ["敦促"])
("dpdm" ["蹲点"])
("dpe'" "盹趸")
("dpg'" ["斗批改"])
("dph'" ["动配合"])
("dphd" ["敦煌"])
("dphe" ["顿河"])
("dphk" ["顿号"])
("dpig" ["打破常规"])
("dpjc" ["钝角"])
("dpl'" ["多普勒"])
("dppl" ["盾牌"])
("dpq'" "墩吨蹲敦礅镦")
("dpr'" "顿囤钝盾遁沌炖砘")
("dpub" ["顿首"])
("dpui" ["顿时"])
("dpwz" ["吨位"])
("dpx'" ["地平线"])
("dpxu" ["短篇小说"])
("dpxw" ["蹲下"])
("dpyl" ["盾皮鱼类"])
("dpyn" ["顿音"])
("dpz'" ["打拍子"])
("dpzu" ["顿足"])
("dq'" ["当前"])
("dqc'" ["大气层"])
("dqdc" ["丢掉"])
("dqh'" ["电气化" "电器化"])
("dqhx" ["地球化学"])
("dqj'" ["大曲酒"])
("dql'" ["的确良"])
("dqlm" ["丢脸"])
("dqp'" ["当权派"])
("dqq'" "丢铥")
("dqqi" ["丢弃"])
("dqr'" ["段祺瑞"])
("dqrf" ["丢人"])
("dqt'" ["大前提"])
("dqui" ["丢失"])
("dqwi" ["大器晚成"])
("dqwl" ["地球物理"])
("dqws" ["地球物理研究所"])
("dqxw" ["丢下"])
("dqy'" ["大气压" "低气压"])
("dqzi" ["丢字"])
("dr'" ["当然"])
("dran" ["断案"])
("drbo" ["短波"])
("drcg" ["断层"])
("drcu" ["短粗" "短促"])
("drdm" ["断点" "断电"])
("drdr" ["短短"])
("drdy" ["断定"])
("dre'" "短")
("drfa" ["短发"])
("drfh" ["端方"])
("drgs" ["短工" "锻工"])
("drhb" ["断後"])
("dria" ["端茶"])
("drig" ["短程"])
("drih" ["短长"])
("drir" ["短传"])
("driu" ["短处"])
("driv" ["锻锤"])
("drjc" ["断交"])
("drjm" ["短见" "锻件"])
("drjt" ["断绝"])
("drjw" ["待人接物"])
("drkb" ["端口" "断口"])
("drkl" ["断开"])
("drlm" ["锻炼"])
("drlo" ["段落"])
("drlu" ["短路" "锻炉" "断路"])
("drlx" ["断裂"])
("drma" ["短码"])
("drmm" ["端面" "断面"])
("drmu" ["锻模"])
("drmy" ["短命"])
("drnl" ["断奶"])
("drpk" ["短跑"])
("drpm" ["短篇"])
("drpy" ["短评"])
("drq'" ["端" "电容器"])
("drqi" ["短期" "断气"])
("drqt" ["短缺"])
("drr'" "锻段断缎椴煅簖")
("drrj" ["断然"])
("drss" ["断送"])
("drtb" ["断头"])
("druk" ["短少" "煅烧"])
("druv" ["端水"])
("drvd" ["端庄"])
("drvg" ["端正"])
("drw'" ["大人物"])
("drwf" ["短文"])
("drxc" ["短小"])
("drxd" ["端详"])
("drxm" ["端线" "断线"])
("drya" ["锻压"])
("dryh" ["端阳"])
("dryj" ["断言"])
("dryn" ["短音"])
("dryu" ["短语" "断狱"])
("drzi" ["缎子"])
("drzj" ["短暂"])
("drzk" ["锻造"])
("drzo" ["端坐"])
("dsan" ["东安"])
("dsbi" ["动笔"])
("dsbm" ["东边"])
("dsbu" ["东部"])
("dsby" ["冻冰"])
("dsbz" ["东北"])
("dsci" ["动词"])
("dsde" ["东德" "懂得"])
("dsdh" ["动荡"])
("dsdi" ["动地"])
("dsdj" ["东单"])
("dsdk" ["东道"])
("dsdu" ["东都"])
("dse'" "董懂硐")
("dsfg" ["东风"])
("dsfh" ["东方" "洞房"])
("dsfz" ["东非"])
("dsg'" ["单色光"])
("dsgg" ["冬耕"])
("dsgs" ["东宫" "动工"])
("dsgw" ["冬瓜"])
("dshe" ["恫吓"])
("dshj" ["东汉"])
("dshl" ["东海" "冻害"])
("dshu" ["东湖"])
("dshw" ["动画"])
("dshy" ["冻坏"])
("dsia" ["洞察"])
("dsid" ["冻疮"])
("dsig" ["东城"])
("dsih" ["东厂"])
("dsij" ["动产"])
("dsiy" ["第三产业"])
("dsj'" ["第三纪" "第四纪"])
("dsjc" ["东郊"])
("dsjd" ["冻僵"])
("dsji" ["冬季" "动机"])
("dsjn" ["东晋"])
("dsjt" ["动觉"])
("dsjw" ["东家"])
("dsjx" ["冻结"])
("dsjy" ["东京" "东经" "动静"])
("dskb" ["洞口"])
("dsld" ["动量" "栋梁"])
("dsli" ["动力"])
("dsll" ["东来"])
("dslq" ["东流"])
("dslr" ["动乱"])
("dsly" ["东陵"])
("dsm'" ["大司马"])
("dsmf" ["东门"])
("dsmg" ["东盟"])
("dsml" ["冬麦" "动脉"])
("dsmm" ["东面" "冬眠"])
("dsng" ["动能"])
("dsnj" ["东南"])
("dsou" ["东欧"])
("dsp'" ["打算盘"])
("dspo" ["东坡"])
("dspx" ["斗私批修"])
("dspy" ["东平"])
("dsq'" "东冬咚岽氡鸫")
("dsqy" ["动情"])
("dsr'" "动栋侗恫冻洞垌峒胨胴硐")
("dsrf" ["动人"])
("dssi" ["东四" "冻死"])
("dssp" ["冬笋"])
("dsti" ["胴体"])
("dstj" ["动弹"])
("dstl" ["动态"])
("dstm" ["冬天"])
("dstu" ["冻土"])
("dsty" ["动听"])
("dsu'" ["东三省"])
("dsub" ["动手"])
("dsuf" ["动身"])
("dsug" ["东升"])
("dsuh" ["冻伤"])
("dsui" ["董事" "懂事"])
("dsuj" ["第三世界"])
("dsv'" ["第三者"])
("dsvb" ["东周"])
("dsvd" ["冬装"])
("dsve" ["动辄"])
("dsvh" ["冻胀"])
("dsvi" ["东芝" "冬至"])
("dswu" ["东吴" "动物"])
("dswz" ["东魏"])
("dsxd" ["东乡" "动向"])
("dsxi" ["东西"])
("dsxm" ["冬闲"])
("dsxn" ["动心"])
("dsxs" ["低三下四"])
("dsxt" ["洞穴"])
("dsya" ["东亚"])
("dsyh" ["东洋"])
("dsyi" ["动议"])
("dsyk" ["动摇"])
("dsyr" ["动员"])
("dsys" ["动用"])
("dszi" ["洞子"])
("dszo" ["动作"])
("dszu" ["侗族"])
("dtb'" ["大踏步"])
("dtdh" ["得天独厚"])
("dtfw" ["动态范围"])
("dtfy" ["待摊费用"])
("dtg'" ["低碳钢"])
("dtl'" ["到头来"])
("dtld" ["顶天立地"])
("dtph" ["动态平衡"])
("dttu" ["道听途说"])
("dtu'" ["大体上"])
("dtus" ["顶头上司"])
("dtv'" ["打头阵" "大头针"])
("dtx'" ["打天下"])
("dtxy" ["大同小异"])
("du'" ["当时"])
("duba" ["独霸"])
("dubj" ["督办"])
("dubk" ["读报"])
("dubl" ["独白"])
("dubo" ["赌博"])
("duc'" ["多少次"])
("ducg" ["镀层"])
("duck" ["毒草"])
("ducl" ["独裁"])
("ducu" ["督促"])
("duda" ["毒打"])
("dudk" ["独到"])
("dudr" ["独断"])
("dudu" ["都督" "独独" "嘟嘟"])
("due'" "堵睹赌肚笃")
("duer" ["毒饵"])
("dufi" ["对数方程"])
("dufu" ["督抚" "杜甫"])
("dug'" ["大使馆"])
("dugb" ["电视广播"])
("duge" ["镀铬"])
("dugo" ["度过" "渡过"])
("duh'" ["代数和" "到时候" "董事会"])
("duhb" ["读后"])
("duhe" ["渡河"])
("duhl" ["毒害"])
("duhu" ["对数函数"])
("duhv" ["都会"])
("duhw" ["毒化"])
("duia" ["督察"])
("duid" ["独创"])
("duig" ["都城"])
("duih" ["独唱"])
("duir" ["渡船"])
("duis" ["毒虫"])
("duiu" ["读出"])
("duj'" ["大使级" "大世界" "电视机"])
("dujd" ["渡江"])
("duji" ["毒计" "妒忌"])
("dujj" ["电视接收机"])
("dujn" ["镀金"])
("dujp" ["督军" "毒菌"])
("dujr" ["杜鹃"])
("dujt" ["杜绝"])
("duju" ["独具"])
("dujw" ["独家"])
("dujx" ["堵截"])
("dujy" ["读经"])
("dukb" ["渡口"])
("dula" ["毒辣"])
("duld" ["度量"])
("duli" ["独立"])
("dulj" ["独揽"])
("dulp" ["渡轮"])
("dulq" ["毒瘤"])
("dum'" ["等势面"])
("dun'" ["多少年"])
("dunh" ["嘟囔"])
("dunq" ["犊牛"])
("dupd" ["电视频道"])
("dupi" ["肚皮"])
("dupj" ["读盘"])
("dupn" ["毒品"])
("duq'" "都督嘟")
("duqi" ["毒气" "赌气"])
("duqu" ["读取"])
("dur'" ["杜" "镀" "肚" "度" "渡" "妒" "芏" "蠹" "当事人" "读书人"])
("duri" ["度日"])
("duse" ["堵塞"])
("dusi" ["毒死"])
("dusq" ["大势所趋"])
("dusu" ["毒素"])
("dusw" ["大失所望"])
("dut'" ["电视台" "多少天"])
("dute" ["独特"])
("duti" ["独体"])
("duts" ["都统" "镀铜"])
("dutu" ["读图"])
("duu'" ["代数式" "动手术"])
("duua" ["毒杀"])
("duub" ["毒手"])
("duue" ["毒蛇"])
("duuf" ["独身"])
("duug" ["独生"])
("duui" ["都市"])
("duuu" ["读书" "读数" "度数"])
("duv'" ["打胜仗"])
("duvb" ["赌咒"])
("duve" ["读者"])
("duvj" ["督战" "独占"])
("duvr" ["杜撰"])
("duvu" ["堵住" "赌注"])
("duw'" "毒犊独读顿渎椟牍髑黩")
("duwu" ["毒物" "读物"])
("duwz" ["都尉"])
("dux'" ["电渗析"])
("duxn" ["镀锌"])
("duxy" ["毒性"])
("duy'" ["大少爷" "淡水鱼"])
("duyk" ["毒药"])
("duyn" ["读音" "镀银"])
("duyq" ["大势已去"])
("duz'" ["独生子"])
("duzb" ["独奏"])
("duzf" ["独生子女费"])
("duzi" ["独资" "独子" "独自" "肚子"])
("duzn" ["独生子女"])
("dv'" ["地址"])
("dvan" ["对岸" "对案"])
("dvay" ["斗志昂扬"])
("dvb'" ["党支部"])
("dvbf" ["对本"])
("dvbi" ["对比"])
("dvbj" ["对半"])
("dvbk" ["对保"])
("dvbl" ["对白"])
("dvbu" ["队部" "对不"])
("dvce" ["对策"])
("dvci" ["对此"])
("dvda" ["对答"])
("dvdc" ["对调"])
("dvdg" ["对等"])
("dvdh" ["对当"])
("dvdl" ["对待"])
("dvdu" ["对读"])
("dvdy" ["多种多样"])
("dvf'" ["大丈夫"])
("dvfh" ["堆放" "对方"])
("dvfu" ["对付"])
("dvfz" ["堆肥"])
("dvgd" ["对光"])
("dvgo" ["对过"])
("dvh'" ["打招呼" "大众化" "地中海"])
("dvhj" ["堆焊"])
("dvhr" ["兑换"])
("dvhs" ["对红"])
("dvhw" ["对话"])
("dvif" ["对称"])
("dvj'" ["大主教"])
("dvjc" ["对角"])
("dvjg" ["党政机关"])
("dvji" ["堆积"])
("dvjj" ["地主阶级"])
("dvju" ["对局"])
("dvjy" ["多种经营"])
("dvkb" ["对口"])
("dvkh" ["对抗"])
("dvkl" ["对开"])
("dvli" ["对立"])
("dvlm" ["对联"])
("dvlq" ["对流"])
("dvlu" ["对路"])
("dvlx" ["队列"])
("dvm'" ["大仲马"])
("dvmf" ["对门"])
("dvmm" ["对面"])
("dvnz" ["对内"])
("dvou" ["对偶"])
("dvp'" ["地主婆"])
("dvq'" "堆")
("dvqg" ["大张旗鼓"])
("dvqy" ["断章取义"])
("dvr'" "兑队对敦怼憝碓镦")
("dvs'" ["大昭寺"])
("dvt'" ["德智体" "地质图"])
("dvtb" ["对头"])
("dvub" ["对手"])
("dvug" ["对生"])
("dvui" ["对峙"])
("dvuj" ["对山"])
("dvuu" ["对数"])
("dvve" ["对折" "对着"])
("dvvg" ["对症" "对证"])
("dvvh" ["队长"])
("dvvi" ["对质"])
("dvvk" ["对照"])
("dvvp" ["对准"])
("dvvr" ["对转"])
("dvwf" ["对文"])
("dvwl" ["对外"])
("dvws" ["丁种维生素"])
("dvwu" ["队伍"])
("dvwz" ["对位"])
("dvx'" ["等值线" "地震学" "地质学" "斗争性"])
("dvxc" ["对消"])
("dvxd" ["对象"])
("dvxj" ["胆战心惊"])
("dvxm" ["兑现"])
("dvxn" ["对心"])
("dvxu" ["斗争形式"])
("dvxw" ["东张西望" "对虾"])
("dvxy" ["队形" "对症下药"])
("dvxz" ["单株选择"])
("dvy'" ["打主意" "党中央"])
("dvyb" ["地震预报"])
("dvyj" ["对眼"])
("dvyr" ["队员"])
("dvyu" ["对于"])
("dvyv" ["斗争意志"])
("dvyx" ["大专院校"])
("dvyy" ["对应"])
("dvz'" ["大侄子"])
("dvzb" ["垫支资本"])
("dvzi" ["对子"])
("dw'" ["单位"])
("dwb'" ["稻瘟病"])
("dwe'" "嗲")
("dwg'" ["单位根"])
("dwgi" ["单位工程"])
("dwh'" ["党委会"])
("dwi'" ["电位差"])
("dwj'" ["地位级"])
("dwjx" ["帝王将相"])
("dwjy" ["等位基因"])
("dwkf" ["对外开放"])
("dwmd" ["敌我矛盾"])
("dwml" ["单位面积产量"])
("dwmy" ["对外贸易"])
("dwq'" ["电位器"])
("dwu'" ["多位数"])
("dwuj" ["党委书记"])
("dwv'" ["单位制"])
("dwvj" ["当务之急"])
("dww'" ["大无畏"])
("dwwu" ["大无畏精神"])
("dwwy" ["党委委员"])
("dwx'" ["等温线" "动物学"])
("dwy'" ["动物园"])
("dxal" ["大兴安岭"])
("dxb'" ["单细胞" "短训班"])
("dxbk" ["谍报"])
("dxd'" ["抵消掉"])
("dxdi" ["典型调查"])
("dxdk" ["跌倒"])
("dxdl" ["迭代"])
("dxdx" ["爹爹"])
("dxf'" ["单向阀"])
("dxff" ["跌份"])
("dxg'" ["胆小鬼"])
("dxgi" ["单项工程"])
("dxh'" ["低消耗" "典型化" "电信号"])
("dxhi" ["地下害虫"])
("dxj'" ["地下茎"])
("dxjh" ["短小精悍"])
("dxjw" ["跌价" "迭加"])
("dxl'" ["大修理"])
("dxlo" ["跌落"])
("dxm'" ["冬小麦"])
("dxma" ["爹妈"])
("dxn'" ["代谢能"])
("dxnu" ["倒行逆施"])
("dxp'" ["邓小平"])
("dxq'" "跌爹踮")
("dxqi" ["迭起"])
("dxqy" ["大型企业"])
("dxt'" ["地形图"])
("dxtm" ["大兴土木"])
("dxtx" ["定向天线"])
("dxu'" ["大学生" "单项式" "地下室" "地下水" "多项式"])
("dxuu" ["大显身手"])
("dxuw" ["地下水位"])
("dxvq" ["大行政区"])
("dxw'" ["碟" "蝶" "迭" "谍" "叠" "佚" "垤" "堞" "揲" "喋" "牒" "瓞" "耋" "蹀" "鲽" "短纤维"])
("dxx'" ["大行星" "典型性"])
("dxy'" ["大西洋"])
("dxyp" ["叠韵"])
("dxys" ["蝶泳"])
("dxyu" ["得心应手"])
("dxz'" ["党小组"])
("dxzi" ["碟子"])
("dy'" ["对于"])
("dya'" ["大叶桉"])
("dyan" ["定案"])
("dybf" ["定本"])
("dybj" ["顶板"])
("dybk" ["订报"])
("dycv" ["第一次世界大战"])
("dyd'" ["东印度"])
("dydc" ["定调"])
("dydh" ["叮当" "定当"])
("dydj" ["定单"])
("dydm" ["顶点" "定点"])
("dydo" ["顶多"])
("dydr" ["顶端"])
("dyds" ["东印度公司"])
("dydu" ["定都"])
("dydy" ["鼎鼎"])
("dye'" "顶鼎酊")
("dyee" ["定额"])
("dyfg" ["顶峰" "顶风"])
("dyfu" ["定幅"])
("dyg'" ["缔约国"])
("dygb" ["订购"])
("dygk" ["定稿"])
("dygv" ["定规"])
("dyh'" ["大运河" "多样化"])
("dyhk" ["顶好"])
("dyhl" ["定海"])
("dyho" ["定货" "订货"])
("dyhp" ["定婚" "订婚"])
("dyhq" ["电压互感器"])
("dyhu" ["定户" "订户"])
("dyij" ["定产"])
("dyip" ["丁醇"])
("dyiv" ["钉锤"])
("dyj'" ["打印机" "第一卷" "大跃进"])
("dyjb" ["电影剧本"])
("dyjc" ["顶角"])
("dyji" ["定级"])
("dyjm" ["顶尖"])
("dyjn" ["定金"])
("dyju" ["定居" "定局"])
("dyjw" ["定价"])
("dykw" ["大有可为"])
("dyl'" ["第一流"])
("dyld" ["定量"])
("dyli" ["鼎立" "定理" "订立"])
("dylp" ["定论"])
("dylv" ["定律"])
("dym'" ["第一名"])
("dymc" ["定苗"])
("dymy" ["定名"])
("dyng" ["定能"])
("dynj" ["丁男"])
("dyny" ["叮咛"])
("dyp'" ["代用品"])
("dypa" ["钉耙"])
("dypg" ["顶棚"])
("dyq'" "丁盯叮钉仃玎町疔耵酊")
("dyqi" ["定期"])
("dyqn" ["待业青年"])
("dyqq" ["顶球"])
("dyqx" ["掉以轻心"])
("dyr'" ["钉" "锭" "定" "订" "啶" "腚" "碇" "铤" "代言人"])
("dyri" ["定日"])
("dyrj" ["定然"])
("dysr" ["丁酸"])
("dysx" ["等腰三角形"])
("dyt'" ["大一统"])
("dytb" ["顶头"])
("dyti" ["顶替"])
("dytm" ["顶天"])
("dyu'" ["第一手"])
("dyuf" ["定神"])
("dyug" ["鼎盛"])
("dyui" ["顶事" "定时"])
("dyv'" ["大洋洲" "德意志"])
("dyvb" ["定州"])
("dyvd" ["顶撞"])
("dyve" ["顶着"])
("dyvf" ["顶针"])
("dyvg" ["订正"])
("dyvi" ["定制"])
("dyvp" ["定准"])
("dyvu" ["盯住" "叮嘱" "顶住"])
("dyw'" ["大亚湾"])
("dywe" ["独一无二"])
("dywj" ["丁烷"])
("dywz" ["定位"])
("dyx'" ["第一线"])
("dyxd" ["丁香" "定向"])
("dyxi" ["丁烯"])
("dyxm" ["定弦"])
("dyxn" ["定心"])
("dyxt" ["第一信号系统"])
("dyxy" ["定型" "定形" "定性"])
("dyy'" ["电影院"])
("dyya" ["顶芽"])
("dyye" ["顶叶"])
("dyyi" ["定义"])
("dyyk" ["定要"])
("dyyr" ["定员"])
("dyys" ["顶用"])
("dyyt" ["订约" "订阅"])
("dyyu" ["定于" "定语"])
("dyyy" ["得意洋洋" "定影"])
("dyze" ["定则"])
("dyzi" ["钉子" "锭子"])
("dyzo" ["定做"])
("dyzu" ["鼎足"])
("dyzv" ["定罪"])
("dyzw" ["大有作为"])
("dzb'" ["大字报"])
("dzdl" ["电子电路"])
("dze'" "得")
("dzft" ["电子伏特"])
("dzg'" ["电子管"])
("dzgy" ["电子工业"])
("dzij" ["大资产阶级"])
("dzj'" ["打字机"])
("dzjj" ["电子计算机"])
("dzkx" ["电子科技大学"])
("dzl'" ["电子流"])
("dzq'" ["打砸抢"])
("dzr'" ["大自然"])
("dzt'" ["大总统"])
("dzu'" ["电子束"])
("dzv'" ["党总支"])
("dzx'" ["电子学"])
("dzxj" ["电子显微镜"])
("dzy'" ["电子云"])
("dzyj" ["电子元件"])
("dzyw" ["单子叶植物"])
("e" "二")
("ebdv" ["恶霸地主"])
("ebe'" ["二百二"])
("ebt'" ["二倍体"])
("ebu'" ["而不是" "二把手"])
("ebw'" ["二百五"])
("ecdz" ["二次电子"])
("ecfi" ["二次方程"])
("ecgm" ["二次革命"])
("ecps" ["二次破碎"])
("edgl" ["额定功率"])
("edu'" ["二段式"])
("edv'" ["额定值"])
("eeba" ["恶霸"])
("eedu" ["恶毒"])
("eedy" ["额定"])
("eee'" "恶")
("eeer" ["俄而"])
("eegj" ["恶感"])
("eego" ["俄国" "恶果"])
("eegp" ["恶棍"])
("eehw" ["恶化"])
("eeib" ["恶臭"])
("eeis" ["蛾虫"])
("eejc" ["额角"])
("eelc" ["饿了"])
("eelo" ["俄罗"])
("eelx" ["恶劣"])
("eemg" ["恶梦"])
("eemk" ["鹅毛"])
("eemo" ["恶魔"])
("eemz" ["峨嵋"])
("eeq'" "阿屙婀")
("eer'" "恶厄扼遏鄂饿噩谔垩苊萼呃愕阏轭腭锷鹗颚鳄")
("eerf" ["恶人"])
("eerj" ["愕然"])
("eesi" ["饿死"])
("eet'" "呃")
("eetb" ["额头"])
("eeua" ["扼杀"])
("eeub" ["扼守"])
("eeva" ["讹榨" "讹诈"])
("eevi" ["遏制"])
("eew'" "蛾峨鹅俄额讹娥哦莪锇")
("eewf" ["俄文"])
("eewl" ["额外"])
("eexi" ["恶习"])
("eexn" ["恶心"])
("eexy" ["恶性"])
("eeyi" ["恶意"])
("eeyj" ["恶言"])
("eeyk" ["扼要"])
("eeyp" ["厄运"])
("eeyu" ["俄语" "鳄鱼"])
("eezi" ["蛾子"])
("eezu" ["颚足"])
("egde" ["厄瓜多尔"])
("egs'" ["恩格斯"])
("ehh'" ["恶狠狠"])
("eie'" "诶")
("eif'" ["儿茶酚"])
("eir'" "诶")
("eiw'" "诶")
("eix'" ["二重性"])
("ejb'" ["二甲苯"])
("ejfh" ["二极分化"])
("ejg'" ["二极管"])
("ejv'" ["二进制"])
("ejwv" ["二进位制"])
("eklm" ["恩克鲁玛"])
("elb'" ["二老板"])
("elhm" ["二硫化钼"])
("elht" ["二硫化碳"])
("eli'" ["鄂伦春"])
("elq'" ["扼流圈"])
("elu'" ["二郎山"])
("elyw" ["二氯乙烷"])
("elz'" ["二流子"])
("emj'" ["二面角"])
("emu'" ["峨眉山"])
("emyx" ["耳目一新"])
("enai" ["恩爱"])
("enci" ["恩赐"])
("ende" ["恩德"])
("endm" ["恩典"])
("enhv" ["恩惠"])
("enj'" ["二年级"])
("enq'" "恩蒽")
("enqy" ["恩情"])
("enr'" "摁")
("enrf" ["恩人"])
("enu'" ["二年生"])
("enyr" ["恩怨"])
("eq'" ["而且"])
("erba" ["二八"])
("erbl" ["二百"])
("erbm" ["耳边"])
("erci" ["二次"])
("erdg" ["二等"])
("erdo" ["耳朵"])
("erdv" ["而对"])
("ere'" "耳尔饵洱迩珥铒")
("erfu" ["二副"])
("ergd" ["耳光"])
("erge" ["儿歌" "尔格" "二哥"])
("erhb" ["而后" "尔后"])
("erhd" ["二簧"])
("erhr" ["耳环"])
("erhu" ["二胡"])
("erhw" ["二话"])
("erji" ["耳机" "二级"])
("erjn" ["而今"])
("erjx" ["二姐"])
("erkd" ["而况"])
("erke" ["儿科"])
("erld" ["二两"])
("erli" ["而立"])
("erlk" ["二老"])
("erll" ["二来"])
("erlp" ["二轮"])
("erls" ["耳聋"])
("ermf" ["二门"])
("ermu" ["耳目"])
("ernv" ["儿女"])
("erqm" ["二千"])
("erqx" ["而且"])
("err'" "二贰佴")
("errf" ["二人"])
("ersj" ["二三"])
("ersp" ["儿孙"])
("ertm" ["二天"])
("erts" ["儿童"])
("erui" ["而是" "儿时" "二十"])
("erve" ["二者"])
("ervi" ["二指"])
("ervj" ["二战"])
("erw'" "而儿鸸鲕")
("erwf" ["耳闻"])
("erwj" ["二万"])
("erwl" ["而外"])
("erxi" ["儿媳" "儿戏"])
("erxm" ["二弦"])
("erxn" ["二心"])
("erya" ["尔雅"])
("eryb" ["而又"])
("eryh" ["二氧"])
("eryi" ["而已"])
("eryk" ["而要"])
("eryn" ["儿音"])
("eryr" ["二元"])
("eryt" ["二月"])
("eryu" ["耳语"])
("erzi" ["儿子"])
("erzl" ["而在"])
("ett'" ["儿童团"])
("eu'" ["而是"])
("eusu" ["二十四史"])
("eut'" ["二十天"])
("euyt" ["二十一条"])
("ewfd" ["额外负担"])
("ewwv" ["二万五千里长征"])
("exf'" ["儿媳妇"])
("exu'" ["二项式"])
("exx'" ["二象性"])
("exxh" ["恶性循环"])
("eyhd" ["二氧化氮"])
("eyhg" ["二氧化硅"])
("eyhl" ["二氧化硫"])
("eyhm" ["二氧化锰"])
("eyht" ["二氧化碳"])
("eyl'" ["二元论"])
("f" "发")
("fa'" ["方案"])
("faan" ["法案"])
("fabc" ["发表"])
("fabh" ["发榜"])
("fabi" ["法币"])
("fabj" ["法办"])
("fabk" ["发报" "法宝"])
("fabl" ["发白"])
("fabm" ["发辫"])
("fabu" ["发布"])
("faby" ["发病"])
("facl" ["发财" "发菜"])
("fada" ["发达"])
("fadb" ["发抖"])
("fadl" ["发呆"])
("fadm" ["发电" "法典"])
("fadr" ["发端"])
("fads" ["发动"])
("fadu" ["法度"])
("fady" ["法定"])
("fae'" "法砝")
("faer" ["法儿"])
("faff" ["发奋"])
("fafg" ["发疯"])
("fafh" ["发放"])
("fagd" ["发光"])
("fago" ["法国"])
("fagr" ["法官"])
("fagv" ["法规"])
("fagz" ["发给"])
("fahf" ["发狠"])
("faho" ["发火" "发货"])
("fahp" ["发昏"])
("fahr" ["发还"])
("fahs" ["发红"])
("fahv" ["发挥"])
("fahz" ["发黑"])
("faib" ["发愁" "发臭"])
("faij" ["发颤"])
("faiu" ["发出"])
("fajc" ["发酵"])
("fajd" ["发奖"])
("faji" ["发迹" "法纪"])
("fajn" ["罚金"])
("fajt" ["发掘" "发觉"])
("fajw" ["发家" "法家"])
("fajy" ["法警"])
("fakd" ["发狂"])
("fakj" ["发刊"])
("fakr" ["罚款"])
("fala" ["法拉"])
("fald" ["发亮"])
("falg" ["发冷"])
("falh" ["法郎" "珐琅"])
("fali" ["法理"])
("falj" ["发蓝"])
("falk" ["法老"])
("falv" ["法律"])
("faly" ["法令"])
("fama" ["砝码"])
("famf" ["阀门"])
("famk" ["发毛"])
("famm" ["发面"])
("famu" ["伐木"])
("famy" ["发明"])
("famz" ["发霉"])
("fanj" ["发难"])
("fanu" ["发怒"])
("fapc" ["发票"])
("fapk" ["发炮"])
("fapz" ["发配"])
("faq'" "发")
("faqi" ["发起"])
("faqm" ["罚钱"])
("faqq" ["发球" "罚球"])
("faqr" ["法权"])
("faqu" ["伐区"])
("faqy" ["发情"])
("far'" "发珐")
("fare" ["发热"])
("farf" ["法人"])
("farr" ["发软"])
("fasj" ["发散"])
("fasr" ["发酸"])
("fass" ["发送"])
("fatc" ["发条"])
("fats" ["法统"])
("faty" ["法庭"])
("faue" ["发射"])
("faug" ["发声" "发生"])
("faui" ["发誓" "法师"])
("fauk" ["发烧"])
("favg" ["法政"])
("favh" ["发胀"])
("favi" ["法制" "法治"])
("favj" ["发展"])
("faw'" "罚筏伐乏阀垡")
("fawf" ["法文"])
("fawz" ["乏味"])
("faxc" ["发笑"])
("faxm" ["发现" "法线"])
("faxn" ["发信"])
("faxt" ["法学"])
("faxx" ["发泄"])
("faxy" ["发行"])
("faya" ["发芽"])
("fayh" ["发扬"])
("fayi" ["法医"])
("fayj" ["发言" "发炎"])
("fayn" ["发音"])
("fayr" ["发源" "法院"])
("fayu" ["发育" "法语"])
("faze" ["法则"])
("fazi" ["发紫" "法子"])
("fazo" ["发作"])
("fbdy" ["否定"])
("fbe'" "否缶")
("fbgu" ["奋不顾身"])
("fbjt" ["否决"])
("fbl'" ["发病率" "反比例" "分辨率"])
("fbq'" ["分布区"])
("fbrf" ["否认"])
("fbud" ["腹背受敌"])
("fbv'" ["府兵制"])
("fbze" ["否则"])
("fcvv" ["凡此种种"])
("fcy'" ["服从于"])
("fdd'" ["反对党"])
("fddu" ["反电动势"])
("fddx" ["复旦大学"])
("fdfz" ["反动分子"])
("fdgj" ["发达国家"])
("fdgx" ["反对关系"])
("fdh'" ["负电荷"])
("fdi'" ["发电厂"])
("fdj'" ["发电机" "发动机" "放大镜" "佛得角"])
("fdjv" ["非电解质"])
("fdkx" ["非对抗性"])
("fdl'" ["发电量" "放大率"])
("fdll" ["反杜林论"])
("fdlt" ["范德林特"])
("fdmj" ["防毒面具"])
("fdp'" ["反动派" "反对派"])
("fdq'" ["放大器"])
("fdt'" ["分度头"])
("fdv'" ["发电站"])
("fdvd" ["否定之否定"])
("fdxu" ["放大系数"])
("fdy'" ["辅导员"])
("fdyb" ["分道扬镳"])
("fdyq" ["否定一切"])
("febh" ["费尔巴哈"])
("fejh" ["伏尔加河"])
("feml" ["福尔马林"])
("fes'" ["凡尔赛"])
("ff'" ["方法"])
("ffbi" ["分泌" "粉笔"])
("ffbm" ["分辨" "分辩" "粪便"])
("ffbp" ["愤愤不平"])
("ffbu" ["分布"])
("ffbx" ["分别"])
("ffbz" ["分贝"])
("ffcp" ["分寸"])
("ffcs" ["分葱"])
("ffdb" ["奋斗"])
("ffdc" ["丰富多采" "丰富多彩"])
("ffde" ["分得"])
("ffdg" ["分等"])
("ffdi" ["坟地"])
("ffdj" ["分担"])
("ffdk" ["分道"])
("ffdm" ["分点"])
("ffdr" ["分段"])
("ffdv" ["分队" "粪堆"])
("ffe'" "粉")
("ffee" ["份额"])
("fffa" ["分发" "奋发"])
("ffff" ["纷纷" "忿忿" "愤愤"])
("fffg" ["分封"])
("fffh" ["芬芳"])
("fffu" ["吩咐" "分赴"])
("fffz" ["粪肥"])
("ffgd" ["分光"])
("ffge" ["分割" "分隔"])
("ffgr" ["分管"])
("ffgs" ["分工"])
("ffgz" ["分给"])
("ffhe" ["汾河"])
("ffhf" ["愤恨"])
("ffhh" ["分行"])
("ffhs" ["分红" "粉红"])
("ffhv" ["分会" "焚毁"])
("ffhw" ["分化"])
("ffif" ["粉尘"])
("ffig" ["分成"])
("ffih" ["分场"])
("ffj'" ["防腐剂"])
("ffji" ["分机" "分级" "粉剂"])
("ffjq" ["汾酒"])
("ffju" ["分居" "分局" "分句"])
("ffjw" ["分家"])
("ffjx" ["分解" "分界"])
("ffjy" ["复分解反应"])
("ffk'" ["负反馈"])
("ffkl" ["分开" "愤慨"])
("ffl'" ["方法论"])
("ffld" ["分量"])
("ffli" ["分离" "分立" "分力" "奋力"])
("fflj" ["芬兰"])
("fflq" ["分馏" "分流"])
("fflr" ["纷乱"])
("fflu" ["分路"])
("fflx" ["分裂"])
("fflz" ["分类"])
("ffmc" ["分秒"])
("ffmf" ["愤懑"])
("ffmi" ["分米"])
("ffmm" ["分娩"])
("ffmo" ["粉末"])
("ffmu" ["分母" "坟墓"])
("ffmy" ["分明"])
("ffmz" ["粉煤"])
("ffnu" ["愤怒"])
("ffnx" ["分蘖"])
("ffnz" ["分内" "份内"])
("ffpi" ["分批"])
("ffpl" ["分派"])
("ffpz" ["分配"])
("ffq'" "芬酚吩氛分纷玢")
("ffqi" ["芬奇" "分期" "分歧" "奋起"])
("ffqp" ["分群"])
("ffqr" ["酚醛"])
("ffqy" ["分清"])
("ffr'" "分奋份忿愤粪偾瀵鲼")
("ffrj" ["愤然"])
("ffse" ["分色"])
("ffsi" ["粉丝"])
("ffsj" ["分散"])
("ffss" ["分送"])
("ffsv" ["粉碎"])
("fftb" ["分头"])
("fftc" ["粉条"])
("fftj" ["分摊"])
("fftl" ["酚酞"])
("fftq" ["奋发图强"])
("ffub" ["分手"])
("ffue" ["分设"])
("ffui" ["分式" "粉饰"])
("ffuk" ["焚烧"])
("ffuo" ["分说"])
("ffuu" ["分数" "焚书"])
("ffuv" ["分水"])
("ffuw" ["粉刷"])
("ffvd" ["粉状"])
("ffvg" ["纷争"])
("ffvi" ["分支" "分之"])
("ffvj" ["奋战"])
("ffvs" ["分钟" "分种"])
("ffvy" ["泛非主义"])
("ffw'" "坟焚汾棼鼢")
("ffwf" ["分文"])
("ffwl" ["分外"])
("ffwz" ["分为"])
("ffxd" ["分享"])
("ffxi" ["分析"])
("ffxn" ["分心"])
("ffxr" ["分选"])
("ffxs" ["反法西斯"])
("ffxw" ["非法行为"])
("ffy'" ["副反应"])
("ffyh" ["汾阳"])
("ffyi" ["分宜"])
("ffyp" ["纷纭"])
("ffys" ["奋勇"])
("ffzh" ["分赃"])
("ffzi" ["分子" "份子"])
("ffzu" ["分组"])
("fgbi" ["封闭"])
("fgbk" ["风暴"])
("fgbo" ["风波"])
("fgbu" ["缝补"])
("fgci" ["讽刺"])
("fgcp" ["封存"])
("fgdb" ["风斗"])
("fgdi" ["封地"])
("fgdk" ["风道"])
("fgds" ["反攻倒算" "封冻" "风洞"])
("fgdu" ["风度"])
("fge'" "讽唪")
("fgfg" ["峰峰"])
("fgfh" ["蜂房"])
("fgfu" ["丰富"])
("fggd" ["风光"])
("fgge" ["风格"])
("fggj" ["风干"])
("fggk" ["奉告"])
("fggs" ["奉公"])
("fghb" ["丰厚"])
("fghd" ["凤凰"])
("fghe" ["缝合"])
("fgho" ["烽火"])
("fghw" ["风化"])
("fgie" ["风车"])
("fgif" ["风尘"])
("fgig" ["奉承"])
("fgij" ["丰产"])
("fgik" ["蜂巢" "风潮"])
("fgir" ["风传"])
("fgj'" ["反光镜" "分光镜"])
("fgjm" ["封建"])
("fgjy" ["风景"])
("fgkb" ["封口" "风口"])
("fgkd" ["疯狂"])
("fgl'" ["反过来"])
("fgla" ["蜂蜡"])
("fgld" ["风量"])
("fglh" ["风浪"])
("fgli" ["锋利" "风力"])
("fglq" ["风流"])
("fglr" ["峰峦"])
("fglu" ["反过来说" "俸禄"])
("fglz" ["风雷"])
("fgm'" ["反革命"])
("fgmf" ["风门"])
("fgmh" ["锋芒"])
("fgmi" ["蜂蜜"])
("fgmj" ["丰满"])
("fgmk" ["风貌"])
("fgmm" ["封面" "锋面"])
("fgmy" ["蜂鸣" "奉命"])
("fgmz" ["反革命分子"])
("fgnj" ["丰南"])
("fgnm" ["丰年"])
("fgpi" ["封皮"])
("fgpz" ["丰沛" "奉陪"])
("fgq'" "丰封枫蜂峰锋风疯烽酆葑沣砜")
("fgqi" ["蜂起" "风气"])
("fgqn" ["风琴"])
("fgqp" ["蜂群"])
("fgqr" ["奉劝"])
("fgqu" ["风趣"])
("fgr'" "缝奉凤俸葑")
("fgrf" ["缝纫"])
("fgs'" ["福公司"])
("fgso" ["封锁"])
("fgss" ["奉送"])
("fgsu" ["风俗" "风速"])
("fgtb" ["风头"])
("fgtc" ["封条"])
("fgtl" ["丰台"])
("fgtm" ["丰田"])
("fgtu" ["风土"])
("fgua" ["风沙"])
("fgub" ["丰收"])
("fgud" ["风霜"])
("fgug" ["丰盛" "风声"])
("fguh" ["风尚"])
("fgui" ["风湿"])
("fguj" ["封山" "风扇"])
("fguo" ["丰硕"])
("fguu" ["枫树"])
("fguv" ["风水"])
("fgv'" ["冯国璋"])
("fgvi" ["峰值"])
("fgw'" "逢冯缝")
("fgwh" ["蜂王"])
("fgwj" ["丰功伟绩"])
("fgwo" ["蜂窝"])
("fgwz" ["风味"])
("fgxd" ["蜂箱" "风箱" "风向"])
("fgxi" ["缝隙"])
("fgxm" ["风险" "奉献"])
("fgxr" ["风选"])
("fgxt" ["风雪"])
("fgxy" ["风行" "奉行"])
("fgya" ["风压"])
("fgye" ["枫叶"])
("fgyh" ["凤阳"])
("fgyp" ["风云"])
("fgys" ["蜂拥"])
("fgyt" ["风月"])
("fgyu" ["风雨"])
("fgzi" ["疯子"])
("fgzr" ["风钻"])
("fh'" ["符合"])
("fhai" ["妨碍"])
("fhan" ["方案"])
("fhbm" ["方便"])
("fhbo" ["方伯"])
("fhbz" ["防备"])
("fhci" ["防磁"])
("fhcl" ["方才" "复合材料"])
("fhda" ["放大"])
("fhdh" ["放荡"])
("fhdm" ["放电"])
("fhds" ["房东" "防冻"])
("fhdu" ["防毒" "放毒"])
("fhdy" ["房顶"])
("fhe'" "仿访纺彷舫")
("fhfa" ["方法"])
("fhfg" ["防风" "放风"])
("fhfj" ["防范"])
("fhfu" ["防腐" "仿佛"])
("fhg'" ["氟化钙"])
("fhgd" ["放光"])
("fhge" ["方格"])
("fhgf" ["方根"])
("fhgo" ["放过"])
("fhgu" ["仿古"])
("fhhj" ["防旱"])
("fhhl" ["妨害"])
("fhho" ["防火" "放火"])
("fhhs" ["防洪"])
("fhhu" ["防护"])
("fhhw" ["访华"])
("fhia" ["方差"])
("fhie" ["纺车"])
("fhif" ["防尘"])
("fhig" ["方程"])
("fhij" ["房产"])
("fhik" ["防潮"])
("fhiu" ["放出"])
("fhiv" ["纺锤"])
("fhj'" ["方鸿渐"])
("fhjm" ["房间"])
("fhjp" ["防军"])
("fhjr" ["房捐"])
("fhjw" ["放假"])
("fhkd" ["方框"])
("fhkl" ["放开"])
("fhkr" ["放宽"])
("fhks" ["防空"])
("fhky" ["方块"])
("fhl'" ["防护林" "孵化率"])
("fhla" ["方腊"])
("fhlk" ["防涝"])
("fhlt" ["方略"])
("fhmj" ["放慢"])
("fhmm" ["方面"])
("fhmu" ["放牧"])
("fhpi" ["放屁"])
("fhpk" ["放炮"])
("fhq'" ["坊" "芳" "方" "妨" "邡" "枋" "钫" "氟化氢"])
("fhqi" ["放弃"])
("fhqu" ["防区"])
("fhr'" "放")
("fhre" ["放热"])
("fhrf" ["放任"])
("fhsi" ["纺丝" "放肆"])
("fhsj" ["放散"])
("fhss" ["仿宋" "放松"])
("fhty" ["芳烃"])
("fhu'" ["反函数"])
("fhua" ["纺纱"])
("fhub" ["防守" "放手"])
("fhue" ["放射"])
("fhuf" ["防身"])
("fhug" ["仿生" "放声" "放生"])
("fhui" ["方式" "方士"])
("fhuj" ["房山"])
("fhuk" ["放哨"])
("fhul" ["发号施令"])
("fhun" ["非婚生子女"])
("fhuu" ["方书"])
("fhuv" ["防水" "放水"])
("fhvf" ["方针" "防震"])
("fhvg" ["方正"])
("fhvi" ["防止" "防治" "仿制" "纺织" "放置"])
("fhvk" ["仿照"])
("fhvl" ["放债"])
("fhvo" ["方桌"])
("fhvu" ["放逐"])
("fhw'" ["坊" "肪" "房" "防" "妨" "鲂" "氟化物"])
("fhwf" ["访问"])
("fhwu" ["房屋" "防务"])
("fhwz" ["方位" "防卫"])
("fhxc" ["仿效"])
("fhxd" ["芳香" "方向"])
("fhxm" ["防线"])
("fhxn" ["放心"])
("fhxp" ["防汛"])
("fhxq" ["防修" "防锈"])
("fhxt" ["放学"])
("fhxw" ["放下"])
("fhxy" ["方形" "放行"])
("fhyh" ["放养"])
("fhyi" ["防疫"])
("fhyj" ["方言"])
("fhyr" ["方圆"])
("fhyu" ["防雨" "防御"])
("fhyy" ["放映"])
("fhzi" ["方子" "房子"])
("fhzk" ["仿造"])
("fhzl" ["放在"])
("fhzs" ["放纵"])
("fhzu" ["房租"])
("fi'" ["非常"])
("fij'" ["富春江"])
("fik'" ["妇产科"])
("fip'" ["副产品"])
("fit'" ["丰产田"])
("fiu'" ["方程式"])
("fiyd" ["风吹雨打"])
("fiz'" ["方程组"])
("fjan" ["翻案"])
("fjba" ["反霸"])
("fjbf" ["范本"])
("fjbi" ["反比"])
("fjbj" ["翻版"])
("fjbl" ["凡百"])
("fjbo" ["反驳"])
("fjbu" ["帆布"])
("fjch" ["分级淬火"])
("fjcl" ["饭菜"])
("fjcy" ["封建残余"])
("fjdd" ["封建道德"])
("fjdi" ["翻地"])
("fjdk" ["翻到" "反倒"])
("fjdm" ["饭店"])
("fjdo" ["繁多"])
("fjds" ["翻动" "反动"])
("fjdv" ["反对"])
("fje'" "反返")
("fjer" ["反而"])
("fjfa" ["犯法"])
("fjfj" ["翻翻" "反反" "泛泛"])
("fjfu" ["繁复" "反复"])
("fjgd" ["反光"])
("fjgj" ["反感"])
("fjgo" ["饭锅"])
("fjgp" ["翻滚"])
("fjgr" ["饭馆"])
("fjgs" ["反攻" "返工"])
("fjgv" ["犯规"])
("fjhe" ["饭盒"])
("fjhh" ["返航"])
("fjhk" ["番号"])
("fjhv" ["返回"])
("fjhw" ["繁华"])
("fji'" ["飞机场"])
("fjia" ["反差"])
("fjib" ["范畴"])
("fjie" ["翻车"])
("fjig" ["翻成"])
("fjih" ["反常"])
("fjii" ["泛池"])
("fjik" ["返潮"])
("fjir" ["帆船"])
("fjis" ["反冲"])
("fjiu" ["反刍"])
("fjji" ["反击"])
("fjjr" ["翻卷"])
("fjjx" ["反接"])
("fjjy" ["反经"])
("fjke" ["凡可"])
("fjkh" ["反抗"])
("fjkl" ["翻开"])
("fjkv" ["反馈"])
("fjlc" ["犯了"])
("fjli" ["凡例" "范例"])
("fjlj" ["泛滥"])
("fjlr" ["烦乱"])
("fjma" ["反码"])
("fjmf" ["烦闷"])
("fjmh" ["繁忙"])
("fjmk" ["繁茂"])
("fjml" ["贩卖"])
("fjmm" ["反面"])
("fjnj" ["繁难"])
("fjnk" ["烦恼"])
("fjpc" ["饭票"])
("fjpj" ["反叛"])
("fjpu" ["反扑"])
("fjq'" ["藩" "帆" "番" "翻" "蕃" "幡" "否决权"])
("fjqi" ["泛起"])
("fjqm" ["反潜"])
("fjqx" ["番茄"])
("fjqy" ["烦请"])
("fjr'" "范贩犯饭泛梵畈")
("fjrf" ["凡人" "犯人"])
("fjrk" ["烦扰"])
("fjrs" ["繁荣"])
("fjse" ["反色"])
("fjsl" ["发酵饲料"])
("fjso" ["繁琐" "烦琐"])
("fjsr" ["泛酸"])
("fjsu" ["反诉"])
("fjtg" ["翻腾"])
("fjti" ["繁体"])
("fjtm" ["翻天"])
("fjty" ["饭厅"])
("fju'" ["方解石" "非金属" "福建省" "副教授"])
("fjub" ["反手"])
("fjue" ["反射"])
("fjuf" ["翻身"])
("fjug" ["繁盛"])
("fjuh" ["封建社会"])
("fjui" ["凡事" "凡是"])
("fjus" ["非金属元素"])
("fjuu" ["番薯"])
("fjv'" ["封建主"])
("fjvd" ["饭庄"])
("fjvf" ["藩镇" "反震"])
("fjvg" ["反正" "反证"])
("fjvi" ["繁殖" "反之" "泛指"])
("fjvo" ["饭桌"])
("fjvr" ["翻转" "反转"])
("fjvs" ["繁重"])
("fjvy" ["封建主义"])
("fjw'" "樊矾钒繁凡烦泛蕃蘩燔蹯")
("fjwf" ["反问" "范文"])
("fjwh" ["封建文化"])
("fjwj" ["饭碗"])
("fjwz" ["范围"])
("fjx'" ["分界线" "封建性"])
("fjxd" ["反响" "反向"])
("fjxn" ["翻新"])
("fjxq" ["翻修" "反修"])
("fjxy" ["反省"])
("fjye" ["翻页"])
("fjyh" ["范阳"])
("fjyi" ["翻译"])
("fjyj" ["反演"])
("fjyn" ["翻印" "泛音"])
("fjyp" ["贩运"])
("fjyt" ["翻越" "翻阅"])
("fjyu" ["繁育"])
("fjyy" ["反应" "反映"])
("fjza" ["繁杂"])
("fjzi" ["贩子"])
("fjzk" ["烦躁"])
("fjzl" ["凡在"])
("fjzv" ["犯罪"])
("fkc'" ["发刊词"])
("fkt'" ["方框图"])
("fl'" ["附录"])
("flb'" ["菲律宾"])
("fld'" ["法拉第"])
("flf'" ["反浪费"])
("flfq" ["翻来复去" "翻来覆去"])
("flge" ["弗兰格尔"])
("flgw" ["法律顾问"])
("flhf" ["夫琅和费"])
("fliz" ["泛滥成灾"])
("fljj" ["福利基金"])
("flk'" ["法兰克"])
("flkf" ["法兰克福"])
("flp'" ["法兰盘"])
("flt'" ["分馏塔"])
("flth" ["富丽堂皇"])
("flv'" ["分类帐"])
("flvy" ["分离主义" "分裂主义"])
("flx'" ["分类学"])
("flxf" ["伏罗希洛夫"])
("flxg" ["法兰西共和国"])
("flxw" ["法律行为"])
("flxy" ["扶老携幼"])
("fly'" ["傅立叶"])
("flz'" ["负离子"])
("fm'" ["方面"])
("fmbl" ["分门别类"])
("fmiz" ["发明创造"])
("fmjy" ["反面教员"])
("fmrw" ["反面人物"])
("fmu'" ["复名数"])
("fmv'" ["反民主"])
("fmyj" ["粉末冶金"])
("fnfz" ["富农分子"])
("fngj" ["逢年过节"])
("fnjj" ["富农经济"])
("fofa" ["佛法"])
("fojc" ["佛教"])
("fojy" ["佛经"])
("fouj" ["佛山"])
("fow'" "佛")
("foxd" ["佛像"])
("foxt" ["佛学"])
("foye" ["佛爷"])
("fpf'" ["分配阀"])
("fpj'" ["发泡剂"])
("fpl'" ["废品率" "分配律"])
("fplj" ["风平浪静"])
("fpq'" ["发脾气"])
("fqk'" ["方铅矿"])
("fqlv" ["反侵略战争"])
("fqq'" ["发情期"])
("fqr'" ["发起人"])
("fqsl" ["酚醛塑料"])
("fquv" ["酚醛树脂"])
("fqv'" ["父权制"])
("fqvq" ["发情周期"])
("fqw'" ["废弃物"])
("fqwu" ["废寝忘食"])
("fqyy" ["风起云涌"])
("frfy" ["放热反应"])
("friu" ["繁荣昌盛"])
("frj'" ["缝纫机"])
("frl'" ["发热量"])
("fryh" ["防染印花"])
("fsd'" ["分散度"])
("fsjv" ["分散介质"])
("fsrl" ["分散染料"])
("fsvy" ["分散主义"])
("fsx'" ["分散相"])
("ftf'" ["肥田粉"])
("ftfd" ["翻天覆地" "翻天复地"])
("ftg'" ["沸腾钢"])
("ftj'" ["伏特计"])
("ftl'" ["反推力"])
("ftm'" ["废醣蜜"])
("ftq'" ["丰台区"])
("ftxk" ["非同小可"])
("ftz'" ["繁体字"])
("fu'" ["方式"])
("fuan" ["伏安"])
("fub'" ["放射病"])
("fubc" ["浮标"])
("fubf" ["副本" "父本"])
("fubi" ["复辟"])
("fubj" ["腹板"])
("fubl" ["腐败"])
("fubu" ["腹部"])
("fubv" ["副食补助"])
("fuby" ["伏兵"])
("fubz" ["腹背"])
("fuci" ["副词"])
("fucs" ["服从"])
("fudc" ["浮雕"])
("fudi" ["伏地"])
("fudj" ["负担"])
("fudk" ["辅导"])
("fudl" ["反射定律" "附带"])
("fudm" ["浮点" "附点"])
("fuds" ["浮动"])
("fudu" ["幅度" "服毒"])
("fue'" "甫抚辅俯釜斧脯腑府腐父拊滏黼")
("fufa" ["复发"])
("fufh" ["付方"])
("fufi" ["分式方程"])
("fufu" ["夫妇"])
("fug'" ["附属国"])
("fugh" ["福冈"])
("fugk" ["附睾"])
("fugl" ["覆盖" "复盖"])
("fugo" ["复国"])
("fugr" ["副官"])
("fugs" ["复工"])
("fugu" ["复古"])
("fugv" ["富贵"])
("fugz" ["付给"])
("fuh'" ["反射弧"])
("fuhe" ["符合" "复核" "复合" "负荷" "附和"])
("fuhk" ["符号" "负号" "富豪"])
("fuhl" ["富海"])
("fuho" ["俘获" "复活"])
("fuhu" ["伏虎"])
("fuhv" ["附会"])
("fuhw" ["孵化" "腐化"])
("fuia" ["复查"])
("fuib" ["府绸" "复仇"])
("fuif" ["浮沉"])
("fuig" ["府城"])
("fuii" ["扶持"])
("fuis" ["俯冲"])
("fuiu" ["付出"])
("fuix" ["非生产性"])
("fuj'" ["发射机"])
("fujc" ["俯角"])
("fujd" ["副将"])
("fuji" ["伏击" "负极"])
("fujm" ["福建" "附件"])
("fujn" ["附近"])
("fujq" ["复旧"])
("fuju" ["复句"])
("fujw" ["附加"])
("fukd" ["富矿"])
("fuke" ["复课" "妇科"])
("fukj" ["俯瞰" "副刊"])
("fukr" ["幅宽" "付款"])
("fuku" ["府库"])
("fukw" ["浮夸"])
("ful'" ["凡士林" "分水岭"])
("fuli" ["扶犁" "浮力" "福利" "复利" "富丽"])
("fulj" ["腐烂"])
("fulk" ["父老"])
("fulm" ["妇联"])
("fulr" ["孵卵"])
("fulu" ["俘虏" "附录"])
("fuly" ["涪陵"])
("fuma" ["驸马"])
("fumm" ["幅面"])
("fumn" ["富民"])
("fumo" ["抚摸" "抚摩"])
("fumu" ["父母"])
("fumx" ["覆灭"])
("fumz" ["赴美"])
("fun'" ["辐射能"])
("funj" ["呋喃"])
("funs" ["富农"])
("funv" ["妇女"])
("fupi" ["麸皮"])
("fupm" ["负片"])
("fupy" ["浮萍"])
("fuq'" ["夫" "敷" "肤" "孵" "呋" "稃" "麸" "趺" "跗" "发生器"])
("fuqc" ["浮桥"])
("fuqd" ["腹腔" "富强"])
("fuqi" ["夫妻" "服气" "福气" "付讫"])
("fuqm" ["肤浅"])
("fuqn" ["父亲"])
("fuqr" ["夫权"])
("fuqu" ["麸曲"])
("fuqy" ["付清"])
("fur'" ["服" "赴" "副" "覆" "赋" "复" "傅" "付" "阜" "父" "腹" "负" "富" "讣" "附" "妇" "缚" "咐" "驸" "赙" "馥" "蝮" "鲋" "鳆" "辐射热"])
("furf" ["夫人" "赴任" "富人" "妇人"])
("furi" ["赴日"])
("furk" ["富饶"])
("furs" ["芙蓉"])
("fuse" ["肤色"])
("fusg" ["粉身碎骨"])
("fusl" ["复赛"])
("fusu" ["复苏"])
("fut'" ["咐" "俯视图"])
("futb" ["斧头"])
("futc" ["辐条"])
("fute" ["伏特" "福特"])
("futi" ["扶梯"])
("futu" ["附图"])
("fuub" ["扶手" "俯首"])
("fuue" ["敷设" "辐射" "附设"])
("fuuf" ["复审"])
("fuug" ["腐生"])
("fuuh" ["府上" "负伤" "附上"])
("fuui" ["服侍" "服饰" "俯视" "腐蚀" "副食"])
("fuup" ["抚顺"])
("fuuu" ["复述" "复数" "负数" "富庶" "附属"])
("fuuv" ["赋税"])
("fuvb" ["福州"])
("fuvd" ["服装"])
("fuvf" ["复诊"])
("fuvi" ["扶植" "副职" "复制"])
("fuvl" ["负债"])
("fuvo" ["附着"])
("fuvs" ["浮肿" "负重"])
("fuvu" ["辅助"])
("fuw'" "福服扶拂辐幅氟符伏俘浮涪袱弗匐凫郛芙芾苻茯莩菔幞怫艴孚绂绋桴祓砩黻罘稃蚨蜉蝠")
("fuwg" ["富翁"])
("fuwh" ["福王"])
("fuwu" ["服务"])
("fuwz" ["抚慰" "复位"])
("fux'" ["仿生学" "放射线" "放射性"])
("fuxc" ["拂晓"])
("fuxi" ["复习"])
("fuxm" ["浮现"])
("fuxn" ["复信"])
("fuxq" ["腐朽"])
("fuxr" ["浮选" "复选"])
("fuxs" ["放射性同位素" "放射性元素" "父兄"])
("fuxu" ["抚恤"])
("fuxx" ["复写" "腹泻"])
("fuxy" ["福星"])
("fuyb" ["浮游" "负有" "富有" "妇幼"])
("fuye" ["副业"])
("fuyh" ["扶养" "抚养"])
("fuyi" ["服役" "赋役" "复议"])
("fuyj" ["敷衍"])
("fuyl" ["翻山越岭" "封山育林"])
("fuyn" ["福音" "辅音" "复音" "复印"])
("fuyp" ["浮云"])
("fuyr" ["幅员" "复员" "复原"])
("fuys" ["服用" "附庸"])
("fuyu" ["抚育" "赋予" "富于" "富裕"])
("fuyy" ["赴英"])
("fuza" ["复杂"])
("fuze" ["负责"])
("fuzh" ["腑脏"])
("fuzi" ["夫子" "浮子" "斧子" "父子"])
("fuzl" ["犯上作乱" "负载"])
("fuzo" ["辅佐"])
("fuzu" ["富足"])
("fuzv" ["分生组织"])
("fv'" ["发展"])
("fvbh" ["发展不平衡"])
("fvcl" ["辅助材料"])
("fvf'" ["反证法"])
("fvg'" ["发展观"])
("fvgy" ["纺织工业"])
("fvi'" ["纺织厂"])
("fvl'" ["繁殖力"])
("fvp'" ["反转片" "纺织品" "复制品"])
("fvr'" ["副主任"])
("fvsd" ["发展速度"])
("fvtv" ["非洲统一组织"])
("fvu'" ["非正式" "福州市"])
("fvui" ["发展生产" "辅助生产"])
("fvv'" ["腐植质"])
("fvvj" ["发展中国家"])
("fvvu" ["复种指数"])
("fvxg" ["防治效果"])
("fvxu" ["繁殖系数"])
("fw'" ["服务"])
("fwhy" ["服务行业"])
("fwi'" ["俯卧撑"])
("fwj'" ["方位角"])
("fwm'" ["蜂窝煤"])
("fwt'" ["防卫厅"])
("fwtd" ["服务态度"])
("fwv'" ["服务站"])
("fwvl" ["服务质量"])
("fwy'" ["服务业" "服务员"])
("fx'" ["发现"])
("fxgy" ["芳香工业"])
("fxh'" ["肺循环"])
("fxhh" ["分析和综合"])
("fxj'" ["浮选机"])
("fxjf" ["奉系军阀"])
("fxp'" ["方向盘"])
("fxq'" ["飞行器"])
("fxs'" ["法西斯"])
("fxsy" ["法西斯主义"])
("fxt'" ["芳香烃"])
("fxu'" ["复兴社"])
("fxvw" ["芳香植物"])
("fxwa" ["方兴未艾"])
("fxxj" ["非线性元件"])
("fxxv" ["非线性失真"])
("fxy'" ["飞行员"])
("fxz'" ["芳香族"])
("fy'" ["反应"])
("fyd'" ["发源地" "反应堆"])
("fydw" ["浮游动物"])
("fydx" ["奋勇当先"])
("fyf'" ["翻一番"])
("fyfi" ["反应方程"])
("fyfy" ["风言风语"])
("fygd" ["发扬光大"])
("fyj'" ["复印机"])
("fyjr" ["复员军人"])
("fyl'" ["反映论"])
("fymd" ["放养密度"])
("fypv" ["反右派斗争"])
("fyq'" ["发言权"])
("fyr'" ["发言人"])
("fyt'" ["菲亚特"])
("fytj" ["发育条件"])
("fyu'" ["反应式"])
("fyuj" ["反应时间"])
("fyuw" ["浮游生物"])
("fyvw" ["浮游植物"])
("fywk" ["负隅顽抗"])
("fyx'" ["法医学" "冯玉祥"])
("fz'" ["否则"])
("fzai" ["肺癌"])
("fzbf" ["飞奔"])
("fzbh" ["匪帮" "诽谤"])
("fzbu" ["肺部"])
("fzby" ["肺病"])
("fzcv" ["翡翠"])
("fzda" ["肥大"])
("fzde" ["非得"])
("fzdj" ["非但"])
("fzdl" ["分子电流"])
("fzdm" ["沸点"])
("fzds" ["肥东"])
("fzdu" ["非独"])
("fze'" "菲匪诽悱榧斐蜚篚翡")
("fzer" ["费尔"])
("fzf'" ["房租费"])
("fzfa" ["非法"])
("fzff" ["肥分"])
("fzfj" ["非凡"])
("fzfu" ["肺腑"])
("fzgo" ["飞过"])
("fzgs" ["费工"])
("fzhb" ["肥厚"])
("fzhs" ["绯红"])
("fzhw" ["飞花" "废话"])
("fzig" ["肥城"])
("fzih" ["非常"])
("fzii" ["飞驰"])
("fzir" ["飞船"])
("fzis" ["飞虫"])
("fziu" ["废除"])
("fzjg" ["分子结构"])
("fzji" ["飞机"])
("fzjm" ["飞溅"])
("fzjn" ["飞进" "费尽" "费劲"])
("fzjp" ["匪军"])
("fzky" ["飞快"])
("fzl'" ["分子量" "副总理"])
("fzlc" ["肥料" "废料"])
("fzld" ["复杂劳动"])
("fzli" ["非礼" "费力"])
("fzll" ["飞来"])
("fzlm" ["蜚廉"])
("fzlp" ["飞轮"])
("fzmz" ["肥美"])
("fznc" ["飞鸟"])
("fznj" ["非难"])
("fzph" ["肥胖"])
("fzpk" ["飞跑" "肺泡"])
("fzpn" ["废品"])
("fzq'" "菲非啡飞妃绯扉蜚霏鲱")
("fzqi" ["废气" "废弃"])
("fzqm" ["费钱"])
("fzqn" ["飞禽"])
("fzqt" ["肥缺"])
("fzr'" "吠肺废沸费芾狒镄痱")
("fzrb" ["肥肉"])
("fzrf" ["非人"])
("fzsu" ["飞速"])
("fzte" ["非特"])
("fztg" ["飞腾" "沸腾"])
("fztm" ["飞天"])
("fztu" ["匪徒"])
("fztx" ["废铁"])
("fzty" ["飞艇"])
("fzu'" ["分子筛" "分子式"])
("fzub" ["匪首"])
("fzud" ["房租水电"])
("fzui" ["沸石" "费时" "费事"])
("fzuv" ["废水" "沸水"])
("fzux" ["分子生物学"])
("fzv'" ["负责制"])
("fzva" ["废渣"])
("fzvb" ["非洲"])
("fzvd" ["肥壮"])
("fzvh" ["飞涨"])
("fzvi" ["废止" "废纸"])
("fzw'" "肥淝腓")
("fzwh" ["飞往"])
("fzwo" ["非我" "肥沃"])
("fzwu" ["飞舞" "废物"])
("fzxc" ["肥效"])
("fzxd" ["飞翔"])
("fzxn" ["费心"])
("fzxu" ["废墟"])
("fzxy" ["飞行"])
("fzy'" ["反作用" "副作用"])
("fzye" ["废液"])
("fzyh" ["飞扬"])
("fzyi" ["非议"])
("fzyj" ["肺炎"])
("fzyk" ["非要"])
("fzyl" ["反作用力" "分子运动论"])
("fzyr" ["肥源"])
("fzys" ["费用"])
("fzyt" ["飞跃"])
("fzyu" ["肥育"])
("fzzb" ["飞走"])
("fzzh" ["肺脏"])
("fzzi" ["非子"])
("fzzk" ["肥皂"])
("g" "个")
("gab'" ["公安部"])
("gabd" ["公安部队"])
("gae'" "嘎尕")
("gaga" ["嘎嘎"])
("gaj'" ["公安局"])
("gaq'" "嘎胳夹咖伽旮")
("gar'" "尬")
("gas'" ["谷氨酸"])
("gatb" ["港澳同胞"])
("gaw'" "噶嘎轧尜钆")
("gb'" ["改变"])
("gban" ["苟安"])
("gbb'" ["干巴巴"])
("gbci" ["构词"])
("gbd'" ["顾不得" "怪不得"])
("gbde" ["购得"])
("gbdh" ["勾当"])
("gbdt" ["广播电台"])
("gbdv" ["寡不敌众"])
("gbe'" "苟狗岣枸笱")
("gbf'" ["根本法"])
("gbge" ["够格"])
("gbh'" ["过饱和"])
("gbhe" ["沟壑" "媾和"])
("gbhg" ["哥本哈根"])
("gbho" ["购货" "篝火"])
("gbhw" ["勾画"])
("gbig" ["构成"])
("gbiy" ["个别差异"])
("gbjm" ["构件"])
("gbjn" ["购进"])
("gbjx" ["勾结"])
("gbkp" ["高不可攀"])
("gblc" ["够了"])
("gbmd" ["根本矛盾"])
("gbml" ["购买"])
("gbn'" ["哥白尼"])
("gbq'" ["钩" "勾" "沟" "句" "佝" "缑" "枸" "篝" "鞲" "过不去"])
("gbqm" ["勾芡"])
("gbqu" ["沟渠"])
("gbqx" ["苟且"])
("gbr'" "勾垢构购够诟遘媾觏彀")
("gbsi" ["构思"])
("gbtc" ["广播体操"])
("gbts" ["沟通"])
("gbtu" ["构图"])
("gbu'" ["赶不上" "公倍数" "顾不上" "过半数"])
("gbui" ["沟施"])
("gbvi" ["购置"])
("gbvu" ["钩住" "构筑"])
("gbw'" ["各部委"])
("gbwu" ["购物"])
("gbx'" ["根本性"])
("gbxc" ["购销"])
("gbxd" ["构想"])
("gbxs" ["狗熊"])
("gbxy" ["构型"])
("gby'" ["冈比亚"])
("gbyk" ["狗咬"])
("gbyn" ["勾引"])
("gbyq" ["供不应求"])
("gbzf" ["故步自封"])
("gbzi" ["钩子"])
("gbzk" ["构造"])
("gc'" ["刚才"])
("gcf'" ["干草粉"])
("gcub" ["顾此失彼"])
("gd'" ["规定"])
("gdan" ["广安"])
("gdb'" ["高蛋白"])
("gdbc" ["光标"])
("gdbo" ["光波" "广播" "广博"])
("gdc'" ["古地磁"])
("gdcl" ["光彩"])
("gdda" ["光大" "广大"])
("gddl" ["光带"])
("gddm" ["光电"])
("gdds" ["广东"])
("gddu" ["光度" "广度"])
("gddw" ["高等动物"])
("gde'" "广犷")
("gdeg" ["光电二极管"])
("gdfj" ["广泛"])
("gdfu" ["光复"])
("gdg'" ["高低杠" "光电管"])
("gdgk" ["广告"])
("gdgp" ["哥达纲领批判" "光棍"])
("gdgu" ["光顾"])
("gdh'" ["广东话"])
("gdhe" ["光和"])
("gdhj" ["广汉"])
("gdhv" ["光辉"])
("gdhw" ["光华" "光滑"])
("gdi'" ["干电池" "光电池"])
("gdih" ["广场"])
("gdir" ["广川"])
("gdjc" ["广角"])
("gdjq" ["各大军区"])
("gdjx" ["光洁"])
("gdjy" ["高等教育" "光景"])
("gdko" ["广阔"])
("gdl'" ["光电流"])
("gdld" ["光亮"])
("gdlj" ["光缆"])
("gdln" ["光临"])
("gdly" ["广陵"])
("gdmc" ["滚动摩擦"])
("gdmh" ["光芒"])
("gdmj" ["耕地面积"])
("gdmm" ["光面"])
("gdmn" ["光敏"])
("gdmy" ["光明"])
("gdng" ["光能"])
("gdnj" ["广南"])
("gdnm" ["光年"])
("gdpu" ["光谱"])
("gdq'" ["光" "咣" "桄" "胱" "过得去"])
("gdqi" ["光气"])
("gdqr" ["光圈"])
("gdqs" ["各得其所"])
("gdqv" ["广大群众"])
("gdr'" "逛桄")
("gdrp" ["光润"])
("gdrs" ["光荣"])
("gdsu" ["光速"])
("gdt'" ["关东糖"])
("gdtb" ["光头"])
("gdu'" ["广东省"])
("gdui" ["光是"])
("gduj" ["光栅"])
("gdup" ["高档商品"])
("gduq" ["过渡时期"])
("gduu" ["光束"])
("gdvb" ["光轴" "广州"])
("gdvi" ["滚动轴承"])
("gdvk" ["光照"])
("gdvy" ["古典主义"])
("gdw'" ["各单位"])
("gdwu" ["光武"])
("gdwx" ["古典文学"])
("gdwz" ["广为"])
("gdx'" ["规定性"])
("gdxi" ["广西"])
("gdxm" ["光纤" "光线"])
("gdxt" ["光学"])
("gdxu" ["光绪" "过渡形式"])
("gdxx" ["高等学校"])
("gdxy" ["光电效应"])
("gdy'" ["过电压"])
("gdyi" ["广义"])
("gdyn" ["光阴"])
("gdyr" ["光源"])
("gdyx" ["高等院校"])
("gdz'" ["光电子"])
("gdzb" ["固定资本"])
("gdze" ["光泽"])
("gdzi" ["固定资产" "光子"])
("gdzj" ["固定资产折旧" "固定资金"])
("gdzs" ["广宗"])
("gdzy" ["固氮作用"])
("geba" ["个把"])
("gebi" ["戈壁" "胳臂" "隔壁"])
("gebj" ["隔板" "各半"])
("gebo" ["胳膊"])
("gebx" ["个别" "各别"])
("geci" ["歌词"])
("ged'" ["共轭点"])
("geda" ["疙瘩"])
("gede" ["歌德"])
("gedi" ["割地" "各地"])
("gedr" ["割断" "隔断"])
("gee'" "盖葛个各合哿舸")
("geer" ["哥儿" "个儿"])
("geff" ["归而复返"])
("gefu" ["共轭复数"])
("gege" ["哥哥" "格格" "个个" "各个" "各各"])
("gegh" ["铬钢"])
("gego" ["各国"])
("gehb" ["歌喉"])
("gehe" ["隔阂"])
("geih" ["歌唱"])
("geik" ["高尔察克"])
("geiu" ["割除" "革除" "各处"])
("gej'" ["高尔基"])
("geji" ["各级"])
("gejq" ["个旧"])
("gejt" ["隔绝"])
("geju" ["歌剧" "割据" "隔距"])
("gejx" ["各界"])
("gekl" ["隔开"])
("gel'" ["哥儿俩"])
("gelb" ["阁楼"])
("geli" ["隔离"])
("geln" ["格林"])
("gelv" ["格律"])
("gelx" ["割裂"])
("gelz" ["各类"])
("gemo" ["隔膜"])
("gemy" ["革命"])
("genv" ["歌女"])
("gepu" ["歌谱"])
("geq'" "哥歌搁戈鸽胳疙割格咯屹仡圪纥袼")
("geqd" ["隔墙"])
("geqm" ["搁浅"])
("gequ" ["歌曲"])
("ger'" "铬个各硌虼")
("gere" ["隔热"])
("gerf" ["个人" "各人"])
("gerh" ["割让"])
("gers" ["割绒"])
("gese" ["各色"])
("gesk" ["哥嫂"])
("gess" ["歌颂"])
("geti" ["个体"])
("getj" ["歌坛"])
("geub" ["歌手"])
("geug" ["歌声"])
("geui" ["格式"])
("geuu" ["个数"])
("geve" ["隔着"])
("gevi" ["搁置" "革职"])
("gevs" ["各种"])
("gew'" "搁胳革葛格蛤阁隔鬲塥嗝搿膈镉颌骼")
("gewl" ["格外"])
("gewu" ["歌舞"])
("gewz" ["个位" "各位"])
("gexd" ["各项"])
("gexm" ["割线"])
("gexn" ["革新"])
("gexw" ["阁下"])
("gexy" ["个性"])
("geyb" ["各有"])
("geyh" ["各样"])
("geyj" ["格言"])
("geyk" ["歌谣"])
("geyn" ["隔音"])
("geys" ["歌咏"])
("gezi" ["鸽子" "格子" "个子" "各自"])
("gezu" ["各族"])
("gf'" ["广泛"])
("gfb'" ["国防部"])
("gfba" ["根拔"])
("gfbf" ["根本"])
("gfbj" ["跟班"])
("gfdi" ["根底"])
("gfe'" "艮")
("gfer" ["根儿"])
("gfgr" ["根冠"])
("gfgy" ["国防工业"])
("gfh'" ["规范化"])
("gfhk" ["根号"])
("gfiu" ["根除"])
("gfj'" ["鼓风机" "国防军"])
("gfji" ["根基"])
("gfjm" ["根尖"])
("gfjn" ["跟紧" "跟进"])
("gfjt" ["根绝"])
("gfju" ["根据"])
("gfjy" ["根茎"])
("gfl'" ["鼓风炉"])
("gfll" ["国防力量"])
("gflq" ["根瘤"])
("gfmc" ["根苗"])
("gfmk" ["根毛"])
("gfq'" "根跟")
("gfqm" ["跟前"])
("gfr'" "亘茛艮")
("gfsv" ["跟随"])
("gftb" ["跟头"])
("gfu'" ["光辐射"])
("gfuh" ["跟上"])
("gfui" ["根式"])
("gfuj" ["共发射极"])
("gfve" ["跟着"])
("gfvi" ["根治"])
("gfvu" ["根竹"])
("gfw'" "哏")
("gfwh" ["国防委员会"])
("gfxi" ["根系"])
("gfyn" ["根音"])
("gfyr" ["根源"])
("gfys" ["股份有限公司"])
("gfz'" ["高分子"])
("gfzi" ["根子"])
("gfzs" ["跟踪"])
("gg'" ["各个"])
("ggbr" ["格格不入"])
("ggbu" ["更不"])
("ggd'" ["感光度"])
("ggda" ["更大"])
("ggdd" ["归根到底"])
("ggdi" ["耕地"])
("ggdl" ["勾股定理"])
("ggdo" ["更多"])
("ggds" ["更动"])
("gge'" "埂耿梗颈哽绠鲠")
("ggfj" ["耕翻"])
("ggfu" ["更夫"])
("gggi" ["灌溉工程"])
("gggk" ["更高"])
("gggl" ["更改" "梗概"])
("ggh'" ["规格化"])
("gghk" ["更好"])
("gghl" ["高官厚禄"])
("gghr" ["更换"])
("ggih" ["更长"])
("ggis" ["公共场所"])
("ggiu" ["耕畜"])
("ggj'" ["骨骼肌"])
("ggjd" ["归根结蒂"])
("ggjj" ["干干净净" "恭恭敬敬" "规规矩矩"])
("ggjl" ["公共积累"])
("ggjp" ["各个击破"])
("ggjw" ["更加"])
("ggkf" ["改革开放"])
("ggkr" ["更宽"])
("ggky" ["更快"])
("gglu" ["滚瓜烂熟"])
("ggmj" ["灌溉面积"])
("ggmy" ["更名"])
("ggnq" ["耕牛"])
("ggp'" ["感光片" "硅钢片"])
("ggq'" "耕更庚羹赓")
("ggqi" ["更其" "公共汽车"])
("ggr'" "更")
("ggsd" ["歌功颂德"])
("ggsi" ["梗死"])
("ggss" ["鬼鬼祟祟"])
("ggti" ["更替"])
("ggtm" ["耕田"])
("ggug" ["更生"])
("ggui" ["更是"])
("gguk" ["更少"])
("ggv'" ["感光纸"])
("ggvg" ["更正"])
("ggvh" ["更张"])
("ggvs" ["耕种"])
("ggwz" ["更为"])
("ggxg" ["过共析钢"])
("ggxn" ["更新"])
("ggxt" ["灌溉系统"])
("ggxx" ["高高兴兴"])
("ggyb" ["更有"])
("ggye" ["哽咽"])
("ggyi" ["更衣"])
("ggyk" ["更要"])
("ggyp" ["耕耘"])
("ggz'" ["高个子"])
("ggzi" ["庚子"])
("ggzo" ["耕作"])
("ggzw" ["高秆作物"])
("gh'" ["规划"])
("ghao" ["港澳"])
("ghbi" ["钢笔" "港币"])
("ghbj" ["钢板"])
("ghcl" ["刚才" "钢材" "光辉灿烂"])
("ghcs" ["刚从"])
("ghd'" ["共和党"])
("ghdi" ["岗地"])
("ghdk" ["钢刀"])
("ghdu" ["刚度"])
("ghdy" ["钢锭"])
("ghe'" "岗港")
("ghg'" ["共和国"])
("ghgh" ["刚刚"])
("ghgj" ["杠杆"])
("ghgo" ["刚果"])
("ghgr" ["钢管"])
("ghgu" ["钢箍"])
("ghgv" ["钢轨"])
("ghgy" ["各行各业"])
("ghhk" ["刚好"])
("ghih" ["纲常"])
("ghj'" ["固化剂"])
("ghjm" ["刚健"])
("ghjn" ["钢筋"])
("ghkb" ["港口"])
("ghld" ["钢梁"])
("ghll" ["刚来"])
("ghly" ["纲领" "杠铃"])
("ghmf" ["肛门"])
("ghmk" ["刚毛"])
("ghmu" ["纲目"])
("ghn'" ["共患难"])
("ghpi" ["钢坯"])
("ghq'" "冈刚钢缸肛纲杠扛罡")
("ghqd" ["刚强"])
("ghqm" ["钢钎"])
("ghqn" ["钢琴"])
("ghr'" "钢杠戆筻")
("ghsi" ["钢丝"])
("ghti" ["刚体"])
("ghtl" ["港台"])
("ghtx" ["钢铁"])
("ghuk" ["岗哨"])
("ghuv" ["钢水"])
("ghv'" ["共和制" "国会制"])
("ghvf" ["钢针"])
("ghvs" ["钢种"])
("ghvu" ["钢珠"])
("ghwj" ["港湾"])
("ghwz" ["岗位"])
("ghxy" ["刚性"])
("ghyi" ["刚毅"])
("ghyk" ["纲要"])
("ghyu" ["刚玉"])
("ghzi" ["杠子"])
("ghzy" ["光合作用"])
("gi'" ["过程"])
("gib'" ["工程兵"])
("gid'" ["共产党"])
("gidr" ["共产党人"])
("gidy" ["共产党员"])
("gigj" ["共产国际"])
("gih'" ["国产化"])
("gihd" ["改朝换代"])
("gij'" ["观察家"])
("gis'" ["观察所"])
("gisl" ["工程塑料"])
("giu'" ["高潮时" "工程师"])
("giuj" ["工程设计"])
("giuy" ["工场手工业"])
("givv" ["共产主义者"])
("givx" ["贯彻执行"])
("givy" ["共产主义"])
("gix'" ["公垂线"])
("gixm" ["工程项目"])
("giy'" ["观察员"])
("gj'" ["国家"])
("gjai" ["肝癌"])
("gjb'" ["国家报"])
("gjbh" ["国际博览会"])
("gjbk" ["敢保"])
("gjbu" ["干部"])
("gjbv" ["国际标准" "国家标准"])
("gjbx" ["干瘪"])
("gjby" ["干冰"])
("gjbz" ["干杯" "干贝"])
("gjck" ["甘草"])
("gjcl" ["干菜"])
("gjcv" ["干脆"])
("gjd'" ["感觉到" "根据地" "光洁度"])
("gjdc" ["干掉"])
("gjdh" ["甘当"])
("gjdi" ["甘地"])
("gjdj" ["肝胆" "国家地震局"])
("gjdk" ["赶到" "感到"])
("gjds" ["感动"])
("gjdv" ["国际单位制"])
("gjdw" ["各级党委"])
("gje'" "杆赶感秆敢擀澉橄")
("gjf'" ["国际法" "国家法"])
("gjff" ["干粉"])
("gjfy" ["共聚反应" "国际法院"])
("gjg'" ["工具钢" "国际歌"])
("gjgd" ["感光"])
("gjge" ["干戈"])
("gjgj" ["敢干"])
("gjgl" ["国际惯例"])
("gjgr" ["感官"])
("gjgs" ["肝功"])
("gjgy" ["国际公约"])
("gjh'" ["共进会"])
("gjhe" ["干涸"])
("gjhj" ["干旱"])
("gjho" ["干活"])
("gjht" ["钢筋混凝土"])
("gjhv" ["赶回"])
("gjhw" ["感化"])
("gjie" ["赶车"])
("gjig" ["杆秤"])
("gjih" ["赶场"])
("gjik" ["赶超"])
("gjit" ["干劲冲天"])
("gjiu" ["感触"])
("gjj'" ["共基极" "共价键"])
("gjjd" ["干将" "高级阶段"])
("gjjg" ["国家机构" "国家机关"])
("gjji" ["赶集" "感激"])
("gjjj" ["国际经济" "国家基金"])
("gjjl" ["高级将领" "国家积累"])
("gjjm" ["国家机密"])
("gjjn" ["干劲" "赶紧"])
("gjjp" ["杆菌"])
("gjjq" ["国家机器"])
("gjjr" ["国际金融"])
("gjjt" ["感觉"])
("gjju" ["柑桔" "柑橘" "国际局势"])
("gjjx" ["甘结"])
("gjjy" ["干净"])
("gjkh" ["感抗"])
("gjkj" ["敢看"])
("gjkl" ["感慨"])
("gjku" ["干枯" "甘苦"])
("gjky" ["赶快"])
("gjl'" ["高渐离"])
("gjlc" ["干了"])
("gjld" ["干粮"])
("gjlj" ["国际劳动节" "橄榄"])
("gjlk" ["干酪"])
("gjlm" ["国际联盟"])
("gjlq" ["干馏" "干流"])
("gjlu" ["干路" "甘露" "赶路"])
("gjlx" ["干裂"])
("gjly" ["国家利益"])
("gjm'" ["干酵母"])
("gjma" ["干嘛" "干吗"])
("gjmh" ["赶忙"])
("gjmk" ["感冒"])
("gjmu" ["国计民生"])
("gjmy" ["国际贸易"])
("gjny" ["甘宁"])
("gjpk" ["赶跑"])
("gjq'" "干甘杆柑竿肝乾坩苷尴泔矸疳酐")
("gjqg" ["感觉器官"])
("gjql" ["国家权力"])
("gjqr" ["甘泉"])
("gjqu" ["干渠"])
("gjqy" ["感情" "敢情"])
("gjr'" "干赣淦绀旰")
("gjrf" ["感人"])
("gjrj" ["感染"])
("gjrk" ["干扰"])
("gjs'" ["高加索"])
("gjsf" ["国际私法"])
("gjsi" ["敢死"])
("gjsn" ["各尽所能"])
("gjsu" ["甘肃"])
("gjt'" ["管接头"])
("gjtj" ["感叹"])
("gju'" ["工具书" "贵金属"])
("gjub" ["感受"])
("gjue" ["干涉"])
("gjug" ["感生"])
("gjuh" ["赶上" "感伤"])
("gjui" ["干事"])
("gjuj" ["感觉神经"])
("gjuo" ["敢说"])
("gjuu" ["甘薯"])
("gjuv" ["国际收支"])
("gjv'" ["耿精忠"])
("gjvb" ["赣州"])
("gjvd" ["国家制度"])
("gjve" ["甘蔗"])
("gjvi" ["干支" "感知"])
("gjvk" ["感召"])
("gjvw" ["古今中外"])
("gjvy" ["国际主义"])
("gjw'" ["高聚物" "共聚物"])
("gjwt" ["国际舞台"])
("gjxc" ["干校" "干笑"])
("gjxd" ["感想" "敢想"])
("gjxm" ["干线"])
("gjxn" ["甘心"])
("gjxu" ["国家形式"])
("gjxx" ["感谢"])
("gjxy" ["感性"])
("gjy'" ["关节炎"])
("gjyb" ["甘油"])
("gjyh" ["国家银行"])
("gjyj" ["肝炎"])
("gjyr" ["甘愿"])
("gjys" ["国家预算"])
("gjyu" ["干预" "敢于" "国家元首"])
("gjyy" ["感应"])
("gjzb" ["赶走"])
("gjzh" ["肝脏"])
("gjzi" ["杆子" "竿子"])
("gjzk" ["干燥"])
("gjzo" ["敢做"])
("gk'" ["顾客"])
("gkag" ["高昂"])
("gkai" ["高矮"])
("gkao" ["高傲"])
("gkbx" ["告别"])
("gkcg" ["高层"])
("gkci" ["告辞"])
("gkda" ["高达" "高大"])
("gkdc" ["高调"])
("gkdg" ["高等" "高凳"])
("gkdh" ["高档"])
("gkdi" ["高低" "高地"])
("gkdm" ["糕点"])
("gkdu" ["高度"])
("gke'" "搞镐稿藁缟槁杲")
("gkee" ["高额"])
("gkfa" ["告发"])
("gkfg" ["高峰" "高风"])
("gkfu" ["高夫"])
("gkfz" ["稿费"])
("gkge" ["高歌"])
("gkgh" ["高岗"])
("gkgk" ["高高"])
("gkgv" ["高贵" "搞鬼"])
("gkhj" ["高寒" "高喊"])
("gkhk" ["搞好"])
("gkho" ["搞活"])
("gkhr" ["高欢"])
("gkhu" ["高呼"])
("gkhv" ["高会"])
("gkia" ["高差"])
("gkib" ["稿酬"])
("gkie" ["高车"])
("gkig" ["高程" "告成"])
("gkih" ["高唱"])
("gkij" ["高产"])
("gkik" ["高超" "高潮"])
("gkji" ["高级" "告急"])
("gkjm" ["高见" "稿件"])
("gkjp" ["高峻"])
("gkjq" ["高就"])
("gkju" ["高举"])
("gkjw" ["高价"])
("gkjx" ["告诫"])
("gkjy" ["告警"])
("gkkh" ["高亢"])
("gkks" ["高空"])
("gkkw" ["搞垮"])
("gklb" ["高楼"])
("gkld" ["高粱"])
("gkli" ["高丽" "高利"])
("gklu" ["高炉"])
("gkly" ["高龄"])
("gkmi" ["高密" "告密"])
("gkmm" ["高棉"])
("gkmy" ["高明"])
("gkng" ["高能"])
("gknm" ["高年"])
("gkpj" ["高攀"])
("gkpn" ["高频"])
("gkpy" ["高平"])
("gkq'" ["篙" "皋" "高" "膏" "羔" "糕" "睾" "槔" "国库券"])
("gkqd" ["高强"])
("gkqq" ["高球"])
("gkqy" ["搞清" "工矿企业"])
("gkr'" "膏告诰郜锆")
("gkre" ["高热"])
("gksg" ["高僧"])
("gksi" ["高斯"])
("gkss" ["高耸"])
("gksu" ["高速" "告诉"])
("gkub" ["高手"])
("gkuf" ["高深"])
("gkug" ["高声" "高升"])
("gkuh" ["高尚"])
("gkui" ["告示"])
("gkuj" ["高山"])
("gkuk" ["高烧"])
("gkv'" ["顾恺之"])
("gkvb" ["高州"])
("gkvd" ["告状"])
("gkvh" ["高涨"])
("gkvi" ["稿纸" "告知" "告之"])
("gkvs" ["高中" "告终"])
("gkwf" ["高温"])
("gkwj" ["睾丸"])
("gkwz" ["高位"])
("gkx'" ["公开信"])
("gkxc" ["高小" "高校" "高效"])
("gkxd" ["高相" "高翔"])
("gkxw" ["高下"])
("gkxy" ["高兴"])
("gkya" ["高压"])
("gkyh" ["羔羊"])
("gkyk" ["膏药"])
("gkyn" ["高音"])
("gkyr" ["高原"])
("gkyu" ["高于"])
("gkzi" ["稿子"])
("gkzk" ["高燥"])
("gkzu" ["高祖"])
("gl'" ["管理"])
("glb'" ["哥伦布" "佝偻病"])
("glbm" ["改编" "改变"])
("glby" ["哥伦比亚"])
("glcg" ["盖层"])
("gldb" ["高利贷资本"])
("gldh" ["该当"])
("gldk" ["改道"])
("glds" ["改动"])
("gldv" ["高利贷者"])
("gldy" ["改订"])
("gle'" "改")
("glfq" ["功率放大器"])
("glfy" ["管理费用"])
("glgd" ["戈兰高地"])
("glge" ["改革"])
("glgo" ["改过"])
("glgr" ["改观"])
("glgw" ["孤陋寡闻"])
("glh'" ["哥老会"])
("glhk" ["盖好"])
("glhr" ["改换"])
("glhv" ["改悔"])
("glhw" ["钙化"])
("gli'" ["甘露醇"])
("glih" ["该厂"])
("glj'" ["根瘤菌" "过滤机"])
("gljd" ["该将"])
("gljm" ["改建"])
("gljn" ["改进"])
("gljw" ["改嫁"])
("glkb" ["改口"])
("glkd" ["概况"])
("glko" ["概括"])
("gll'" ["孤零零"])
("glld" ["改良"])
("gllp" ["概论"])
("gllt" ["概略"])
("gllv" ["概率"])
("glmk" ["葛罗米柯"])
("glnm" ["概念"])
("glpm" ["钙片"])
("glpv" ["改良品种"])
("glq'" "该陔垓赅")
("glr'" "概钙盖溉芥丐戤")
("glrf" ["改任"])
("gls'" ["管理所"])
("glsg" ["过磷酸钙"])
("glsi" ["该死"])
("glsr" ["概算"])
("glt'" ["高岭土"])
("gltm" ["改天"])
("gltu" ["改土"])
("gltv" ["管理体制"])
("glu'" ["高岭石" "橄榄石"])
("gluh" ["盖上"])
("glui" ["该是"])
("gluj" ["改善"])
("gluo" ["概说"])
("gluu" ["概述"])
("glvd" ["改装"])
("glvg" ["改正"])
("glvh" ["盖章"])
("glvi" ["改制"])
("glvy" ["改良主义" "功利主义" "官僚主义"])
("glwz" ["改为"])
("glx'" ["规律性"])
("glxr" ["改选"])
("glxx" ["改写"])
("glxy" ["改性"])
("glyk" ["概要"])
("glyr" ["改元"])
("glyu" ["功率因数"])
("glzb" ["官僚资本"])
("glzi" ["盖子"])
("glzk" ["改造"])
("glzu" ["改组"])
("glzw" ["谷类作物"])
("gm'" ["革命"])
("gmb'" ["革命报"])
("gmd'" ["国民党"])
("gmdv" ["革命斗志"])
("gmg'" ["鬼门关"])
("gmgj" ["革命干劲" "国民革命军"])
("gmh'" ["革命化"])
("gmhy" ["国民会议"])
("gmj'" ["革命家" "革命军"])
("gmjd" ["国民警卫队"])
("gmjh" ["国民经济计划"])
("gmjj" ["国民经济"])
("gmjr" ["革命军人"])
("gmjx" ["革命积极性"])
("gml'" ["购买力"])
("gmlf" ["钙镁磷肥"])
("gmlh" ["革命烈火"])
("gmll" ["光明磊落"])
("gmlu" ["革命烈士"])
("gmq'" ["公民权"])
("gmr'" ["郭沫若"])
("gmrb" ["光明日报"])
("gmsj" ["高锰酸钾"])
("gmsy" ["顾名思义"])
("gmth" ["冠冕堂皇"])
("gmur" ["国民收入"])
("gmuv" ["国民生产总值"])
("gmvd" ["光明正大"])
("gmvf" ["国民政府"])
("gmvv" ["革命战争"])
("gmwh" ["革命委员会"])
("gmwx" ["革命文学"])
("gmx'" ["革命性"])
("gmxk" ["刮目相看"])
("gmyv" ["革命意志"])
("gn'" ["功能"])
("gnb'" ["工农兵"])
("gnf'" ["归纳法" "国内法"])
("gnh'" ["概念化"])
("gnhj" ["工农红军"])
("gnj'" ["姑娘家"])
("gnlm" ["工农联盟"])
("gnm'" ["给你们"])
("gnt'" ["官能团"])
("gnvv" ["国内战争"])
("gnw'" ["国内外"])
("gnxt" ["观念形态"])
("gny'" ["工农业"])
("gnyv" ["工农业总产值"])
("gobc" ["国标"])
("gobj" ["过半"])
("goby" ["果柄"])
("goce" ["国策"])
("goco" ["过错"])
("gocv" ["国粹"])
("gode" ["过得"])
("godh" ["过当"])
("godi" ["锅底" "过低"])
("godk" ["过道"])
("godo" ["过多"])
("godr" ["果断"])
("gods" ["过冬"])
("godu" ["国都" "国度" "过度" "过渡"])
("goe'" "果裹猓椁蜾")
("gofa" ["国法"])
("goff" ["过分"])
("gofg" ["国风"])
("gofh" ["国防"])
("gofj" ["锅饭"])
("goge" ["国歌"])
("gogj" ["果敢"])
("gogk" ["过高"])
("gogl" ["锅盖"])
("gogo" ["蝈蝈"])
("gogr" ["过关"])
("gogs" ["国共"])
("gogu" ["国故"])
("gohb" ["过后"])
("gohk" ["国号"])
("goho" ["国货" "过活" "过火"])
("gohu" ["过户"])
("gohv" ["国徽" "国会"])
("gohw" ["国画" "过话"])
("goig" ["过程" "过秤"])
("goih" ["过场"])
("goij" ["国产"])
("gojc" ["果胶"])
("gojd" ["果酱"])
("goji" ["国籍" "国际" "过激" "过急" "过继"])
("gojp" ["国君"])
("gojq" ["国舅" "果酒"])
("gojw" ["国家"])
("gojx" ["国界" "过节"])
("gojy" ["国境" "过境"])
("goku" ["国库"])
("goky" ["过快"])
("golc" ["过了"])
("gold" ["过量"])
("golg" ["过冷"])
("goli" ["国立" "国力"])
("goll" ["过来"])
("golm" ["国联"])
("golu" ["锅炉" "过路"])
("golv" ["过滤"])
("gomf" ["过门"])
("gomn" ["国民" "过敏"])
("gomu" ["果木" "过目"])
("gonj" ["国难"])
("gonm" ["过年"])
("gonz" ["国内"])
("gopi" ["果皮"])
("gopn" ["果品"])
("goq'" "锅郭过涡埚呙崞聒蝈")
("goqc" ["过桥"])
("goqi" ["国戚" "国旗" "过期"])
("goqu" ["过去"])
("goqy" ["国情" "国庆"])
("gor'" "过")
("gorb" ["果肉"])
("gorf" ["国人" "果仁" "过人"])
("gorj" ["果然"])
("goso" ["过所"])
("gosv" ["果穗"])
("gotb" ["过头"])
("goth" ["果糖"])
("goti" ["国体"])
("gotl" ["锅台"])
("gotu" ["国土"])
("goub" ["过手"])
("gouf" ["过甚"])
("goug" ["过剩"])
("goui" ["国事" "国是" "果实" "过失" "过时"])
("gouk" ["过少"])
("goul" ["过筛"])
("gouu" ["国书" "果树"])
("gove" ["裹着" "过着"])
("govf" ["果真"])
("govh" ["过帐"])
("govi" ["果枝" "果汁"])
("govl" ["国债"])
("govs" ["过重"])
("gow'" "国馘掴帼虢")
("gowf" ["国文" "过问"])
("gowh" ["国王" "过往"])
("gowl" ["国外"])
("gowu" ["国务"])
("goxd" ["郭象"])
("goxi" ["过细"])
("goxn" ["过心"])
("goxt" ["国学"])
("goyb" ["国有"])
("goye" ["过夜"])
("goyn" ["国音"])
("goyr" ["果园"])
("goys" ["国用"])
("goyu" ["国语" "过于"])
("goyy" ["国营" "果蝇" "过硬"])
("gozi" ["果子"])
("gozl" ["过载"])
("gozz" ["国贼"])
("gpbh" ["棍棒"])
("gpbm" ["滚边"])
("gpdj" ["滚蛋"])
("gpds" ["滚动"])
("gpe'" "辊滚衮绲磙鲧")
("gpfj" ["滚翻"])
("gpfx" ["光谱分析"])
("gpgp" ["滚滚"])
("gpkl" ["滚开"])
("gplp" ["滚轮"])
("gpr'" "棍")
("gpth" ["滚烫"])
("gpts" ["滚筒"])
("gpvu" ["滚珠"])
("gpx'" ["光谱线"])
("gpzi" ["辊子" "滚子" "棍子"])
("gq'" ["过去"])
("gqd'" ["高强度"])
("gqdj" ["顾全大局"])
("gqgx" ["干群关系"])
("gqj'" ["国庆节"])
("gql'" ["过去了"])
("gqt'" ["共青团"])
("gqty" ["共青团员"])
("gqwd" ["干球温度"])
("gqx'" ["公切线"])
("gr'" ["工人"])
("grb'" ["光荣榜"])
("grbi" ["关闭"])
("grbj" ["官办"])
("grbk" ["管保"])
("grby" ["官兵"])
("grce" ["观测"])
("grcl" ["棺材" "管材"])
("grdi" ["官地"])
("grdk" ["管道"])
("grdl" ["管带"])
("grdm" ["观点"])
("grds" ["关东"])
("grdu" ["个人得失" "官渡"])
("gre'" "管馆莞")
("grfh" ["官方"])
("grfj" ["惯犯"])
("grfu" ["官府"])
("grgd" ["观光"])
("grgj" ["观感"])
("grgl" ["灌溉"])
("grhw" ["官话"])
("grhy" ["关怀"])
("gria" ["观察"])
("grid" ["关窗"])
("grie" ["罐车" "贯彻"])
("grih" ["官场"])
("grir" ["贯穿"])
("grjc" ["管脚" "管教"])
("grjd" ["灌浆"])
("grji" ["关机"])
("grjj" ["工人阶级"])
("grjm" ["关键"])
("grjn" ["关紧"])
("grjp" ["官军" "冠军"])
("grjt" ["官爵"])
("grjw" ["官家" "官价" "管家"])
("grjx" ["关节"])
("grka" ["关卡"])
("grkb" ["关口"])
("grkj" ["观看"])
("grl'" ["感染率"])
("grlc" ["官僚"])
("grli" ["官吏" "管理" "惯例"])
("grlm" ["关联"])
("grls" ["罐笼"])
("grlu" ["管路"])
("grly" ["个人利益"])
("grmf" ["关门"])
("grmo" ["观摩"])
("grmu" ["棺木" "灌木"])
("grng" ["官能"])
("grnm" ["观念"])
("grnz" ["关内"])
("grq'" ["棺" "关" "官" "冠" "观" "纶" "倌" "莞" "矜" "鳏" "过热器"])
("grqi" ["官气"])
("grqu" ["灌区"])
("grqw" ["关卡"])
("grqx" ["关切"])
("grr'" "冠观罐惯灌贯掼涫盥鹳")
("grrb" ["工人日报"])
("grrf" ["官人"])
("grsi" ["官司"])
("grt'" ["固溶体"])
("grtb" ["关头" "罐头"])
("grtm" ["官田"])
("grts" ["贯通"])
("grua" ["管纱"])
("gruh" ["关上" "观赏"])
("grui" ["管事"])
("gruu" ["关书" "官署" "管束" "灌输"])
("gruv" ["关税" "灌水"])
("grvd" ["官庄"])
("grvh" ["馆长"])
("grvi" ["官职" "管制"])
("grvk" ["关照"])
("grvs" ["观众"])
("grvu" ["关注" "灌注" "贯注"])
("grvy" ["个人主义"])
("grw'" ["赶任务"])
("grwh" ["观望"])
("grwl" ["关外"])
("grxf" ["个人消费"])
("grxi" ["关系" "盥洗"])
("grxm" ["管弦"])
("grxn" ["关心"])
("grxw" ["管辖"])
("grxy" ["惯性"])
("gry'" ["给人以"])
("grya" ["关押"])
("gryd" ["工人运动"])
("gryk" ["官窑"])
("gryn" ["观音"])
("gryr" ["官员"])
("grys" ["管用" "惯用"])
("gryu" ["关于"])
("grz'" ["过日子"])
("grzi" ["管子" "馆子" "罐子"])
("grzl" ["关在"])
("grzo" ["管座"])
("gs'" ["公司"])
("gsan" ["公安" "公案"])
("gsbf" ["工本"])
("gsbi" ["公比"])
("gsbk" ["公报" "宫保"])
("gsbu" ["公布"])
("gsby" ["工兵"])
("gsbz" ["弓背"])
("gsci" ["供词"])
("gscp" ["共存"])
("gsd'" ["敢死队"])
("gsda" ["攻打"])
("gsdc" ["宫调"])
("gsdh" ["工党"])
("gsdi" ["工地" "公敌"])
("gsdj" ["哥斯达黎加"])
("gsdk" ["公道"])
("gsdm" ["供电" "宫殿"])
("gsdr" ["工段" "公断"])
("gsdu" ["工读" "攻读"])
("gse'" "巩汞拱珙")
("gsee" ["共轭"])
("gsf'" ["公司法"])
("gsfa" ["公法"])
("gsff" ["工分" "公分" "公愤"])
("gsfg" ["工蜂"])
("gsfj" ["共犯"])
("gsfu" ["工夫" "功夫"])
("gsfz" ["公费"])
("gsg'" ["高速钢"])
("gsgk" ["公告"])
("gsgo" ["功过"])
("gsgr" ["攻关" "公馆"])
("gsgs" ["公公" "公共"])
("gsgu" ["巩固"])
("gshb" ["恭候"])
("gshe" ["恭贺" "共和"])
("gshj" ["公函"])
("gshk" ["功耗"])
("gshl" ["公海" "公害"])
("gshv" ["工会" "公会"])
("gshy" ["公私合营"])
("gsia" ["公差"])
("gsif" ["功臣"])
("gsig" ["工程" "公称"])
("gsih" ["工场" "工厂"])
("gsii" ["公尺"])
("gsij" ["公产" "共产"])
("gsil" ["公差"])
("gsiu" ["公畜" "共处"])
("gsjd" ["工匠"])
("gsji" ["攻击" "功绩" "供给" "公鸡" "共计"])
("gsjm" ["工件" "弓箭"])
("gsjn" ["公斤"])
("gsjt" ["公爵"])
("gsju" ["工具" "公举" "共聚"])
("gsjw" ["公家"])
("gsjy" ["恭敬"])
("gskd" ["工矿"])
("gske" ["工科" "攻克" "功课"])
("gskl" ["公开"])
("gskr" ["公款"])
("gsl'" ["公孙龙"])
("gsld" ["公粮"])
("gsli" ["功利" "功力" "公理" "公里" "公历" "公立"])
("gslk" ["功劳"])
("gslp" ["公论"])
("gslq" ["公刘"])
("gslu" ["公路"])
("gslv" ["功率"])
("gsly" ["工龄"])
("gsmf" ["拱门"])
("gsmn" ["公民"])
("gsmu" ["公亩" "公墓"])
("gsmy" ["功名" "共鸣"])
("gsn'" ["硅酸钠"])
("gsng" ["功能"])
("gsnr" ["供暖"])
("gsns" ["工农"])
("gsnv" ["宫女"])
("gspn" ["贡品"])
("gspo" ["攻破" "公婆"])
("gspu" ["公仆"])
("gspy" ["公平"])
("gsq'" ["工" "攻" "功" "恭" "龚" "供" "躬" "公" "宫" "弓" "共" "红" "肱" "蚣" "觥" "钢丝圈"])
("gsqc" ["拱桥"])
("gsqd" ["宫墙"])
("gsqi" ["工期"])
("gsqm" ["工钱"])
("gsqq" ["供求"])
("gsqu" ["工区" "攻取"])
("gsqy" ["公倾" "公顷"])
("gsr'" ["供" "贡" "共" "公诉人"])
("gsrf" ["工人" "供认" "公认"])
("gsri" ["工日"])
("gsrj" ["公然"])
("gssi" ["公私" "公司"])
("gssu" ["公诉"])
("gstb" ["工头"])
("gsth" ["公堂"])
("gsts" ["共通" "共同"])
("gstv" ["公推"])
("gsty" ["宫廷"])
("gsu'" ["甘肃省" "钢丝绳"])
("gsub" ["攻守" "拱手"])
("gsue" ["公社" "公设"])
("gsuf" ["躬身" "公审"])
("gsug" ["公升" "共生"])
("gsuh" ["工伤" "工商"])
("gsui" ["工时" "工事" "攻势" "公使" "公式" "公事" "共事"])
("gsup" ["恭顺"])
("gsuu" ["公署"])
("gsvf" ["共振"])
("gsvg" ["工整" "公正" "公证"])
("gsvh" ["工长"])
("gsvi" ["工质" "供职" "公职"])
("gsvj" ["攻占"])
("gsvl" ["公债"])
("gsvr" ["公转"])
("gsvs" ["工种" "公众"])
("gsvu" ["公主"])
("gswf" ["公文"])
("gswu" ["公物" "公务"])
("gswz" ["恭维"])
("gsxc" ["工效" "功效" "供销"])
("gsxd" ["共享"])
("gsxi" ["恭喜"])
("gsxm" ["攻陷" "贡献"])
("gsxp" ["功勋"])
("gsxu" ["工序" "共需"])
("gsxw" ["攻下"])
("gsxy" ["弓形" "拱形" "共性"])
("gsy'" ["硅酸盐"])
("gsyb" ["工友" "公有" "共有"])
("gsye" ["工业"])
("gsyh" ["供养" "公羊"])
("gsyi" ["工艺" "公益" "公议"])
("gsyj" ["公演"])
("gsyp" ["工运"])
("gsyr" ["公元" "公园"])
("gsys" ["公用" "共用"])
("gsyu" ["公寓"])
("gsyy" ["供应" "公营"])
("gszi" ["工资" "公子" "弓子"])
("gszo" ["工作"])
("gszu" ["公族"])
("gszz" ["工贼"])
("gtfy" ["个体发育"])
("gtg'" ["高碳钢"])
("gtgl" ["共同纲领"])
("gth'" ["个体户"])
("gthd" ["改天换地"])
("gthm" ["改头换面"])
("gthr" ["光天化日"])
("gths" ["共同海损"])
("gtjj" ["个体经济"])
("gtkl" ["高谈阔论"])
("gtm'" ["给他们" "给它们"])
("gtrl" ["固体燃料"])
("gtsv" ["个体所有制"])
("gtt'" ["共同体" "光秃秃"])
("gtui" ["共同市场"])
("gtup" ["罐头食品"])
("gtuy" ["个体手工业"])
("gty'" ["共同语"])
("gtz'" ["狗腿子"])
("gu'" ["公式"])
("guba" ["古巴"])
("gubf" ["股本"])
("guce" ["估测"])
("guch" ["谷仓"])
("guci" ["故此"])
("guck" ["谷草"])
("gudg" ["根深蒂固"])
("gudi" ["故地"])
("gudj" ["孤单" "固氮"])
("gudl" ["感生电流" "古代" "瓜熟蒂落"])
("gudm" ["古典"])
("guds" ["鼓动" "古董" "股东"])
("gudu" ["咕嘟" "孤独" "古都"])
("gudy" ["固定"])
("gue'" "鼓古蛊骨谷股贾嘏诂汩牯臌毂瞽罟钴鹄蛄鹘")
("guer" ["孤儿" "故而"])
("guff" ["股份"])
("gufg" ["鼓风"])
("gufu" ["辜负" "姑父"])
("gug'" ["公使馆"])
("guge" ["骨骼"])
("gugj" ["骨干"])
("gugo" ["故国"])
("gugs" ["故宫" "雇工"])
("gugu" ["咕咕" "姑姑"])
("gugy" ["各式各样" "古怪"])
("guh'" ["公社化" "公式化" "古时候"])
("guhv" ["骨灰"])
("guhw" ["古话" "骨化" "固化"])
("guig" ["古城" "谷城"])
("guih" ["故常"])
("guip" ["固醇"])
("guiv" ["鼓吹"])
("guj'" ["工商界"])
("guji" ["估计" "古迹" "古籍" "顾及" "顾忌"])
("gujn" ["古今" "股金"])
("gujp" ["孤军"])
("gujq" ["古旧" "故旧"])
("guju" ["故居"])
("gujw" ["估价" "骨架"])
("gujx" ["骨节"])
("guke" ["骨科" "顾客"])
("guku" ["孤苦"])
("gul'" ["工商联"])
("gulb" ["鼓楼"])
("gulc" ["骨料"])
("guld" ["估量"])
("guli" ["孤立" "鼓励" "故吏"])
("gulk" ["古老"])
("gull" ["古来"])
("gulu" ["轱辘"])
("gulv" ["顾虑"])
("gulz" ["谷类"])
("gum'" ["干什么"])
("guma" ["姑妈"])
("gumo" ["鼓膜"])
("gumu" ["姑母"])
("gund" ["姑娘"])
("guns" ["雇农"])
("gup'" ["高射炮"])
("gupc" ["股票"])
("guq'" ["辜" "菇" "咕" "箍" "估" "沽" "孤" "姑" "骨" "菰" "呱" "轱" "毂" "鸪" "蛄" "酤" "觚" "感受器"])
("guqi" ["骨气"])
("guqr" ["顾全"])
("guqx" ["姑且"])
("gur'" "估故顾固雇崮梏牿锢痼鲴")
("gurb" ["骨肉"])
("gurf" ["古人" "故人"])
("gurj" ["固然"])
("gurk" ["过剩人口"])
("gusr" ["估算"])
("gusv" ["骨髓"])
("gutb" ["骨头"])
("guti" ["固体"])
("gutl" ["固态"])
("gutu" ["故土"])
("guu'" ["各省市" "光闪闪"])
("guub" ["固守"])
("guui" ["古诗" "故事"])
("guuj" ["固山"])
("guuu" ["古书"])
("guve" ["骨折"])
("guvh" ["鼓掌" "故障"])
("guvi" ["故知" "固执"])
("guvu" ["雇主"])
("guw'" ["骨" "古生物"])
("guwf" ["古文" "顾问"])
("guwl" ["格杀勿论"])
("guwo" ["故我"])
("guwu" ["鼓舞" "古物"])
("gux'" ["感受性"])
("guxd" ["谷象" "故乡"])
("guxi" ["姑息" "股息"])
("guxx" ["干涉现象"])
("guy'" ["工商业"])
("guya" ["古雅"])
("guyb" ["固有"])
("guye" ["姑爷"])
("guyi" ["故意"])
("guyj" ["骨眼"])
("guyl" ["更上一层楼"])
("guyr" ["雇员"])
("guys" ["雇佣"])
("guyt" ["鼓乐"])
("guyu" ["谷雨"])
("guz'" ["高山族"])
("guzi" ["谷子"])
("guzk" ["鼓噪"])
("guzu" ["鼓足"])
("gv'" ["各种"])
("gvan" ["归案"])
("gvbi" ["规避"])
("gvbm" ["诡辩"])
("gvbn" ["贵宾"])
("gvby" ["归并"])
("gvdh" ["归档"])
("gvdk" ["轨道" "跪倒"])
("gvdm" ["轨电"])
("gvdv" ["归队"])
("gvdy" ["规定"])
("gve'" "轨鬼诡癸匦庋宄晷簋")
("gvfh" ["闺房"])
("gvfj" ["规范"])
("gvfu" ["归附"])
("gvfz" ["贵妃"])
("gvge" ["规格"])
("gvgo" ["归国" "贵国"])
("gvgr" ["桂冠"])
("gvgs" ["归功" "归公"])
("gvgu" ["硅谷"])
("gvgy" ["各种各样" "鬼怪"])
("gvh'" ["广州话"])
("gvhp" ["鬼魂"])
("gvhr" ["归还"])
("gvhw" ["规划" "归化" "鬼话" "桂花"])
("gvig" ["规程" "诡称"])
("gviu" ["贵处"])
("gvjd" ["光照阶段"])
("gvji" ["轨迹" "诡计"])
("gvjm" ["贵贱"])
("gvjq" ["归咎"])
("gvju" ["规矩" "轨距"])
("gvjx" ["归结"])
("gvkb" ["归口"])
("gvli" ["瑰丽"])
("gvlm" ["鬼脸"])
("gvln" ["桂林"])
("gvlu" ["归路"])
("gvlv" ["规律"])
("gvlz" ["归类"])
("gvmo" ["规模"])
("gvna" ["归纳"])
("gvnv" ["闺女"])
("gvpi" ["桂皮"])
("gvpm" ["硅片"])
("gvq'" "瑰规圭硅归龟闺傀妫皈鲑")
("gvqc" ["归侨"])
("gvr'" "桂柜跪贵刽炔刿桧炅鳜")
("gvrf" ["贵人"])
("gvru" ["狗仗人势"])
("gvso" ["龟缩"])
("gvsr" ["硅酸"])
("gvsu" ["归宿"])
("gvtl" ["柜台"])
("gvu'" ["根指数" "广州市" "贵州省"])
("gvuf" ["鬼神"])
("gvuh" ["柜上"])
("gvui" ["硅石"])
("gvuj" ["龟山"])
("gvuo" ["鬼说"])
("gvup" ["归顺"])
("gvuu" ["归属"])
("gvva" ["诡诈"])
("gvvb" ["贵州"])
("gvvd" ["规章制度"])
("gvvg" ["规整"])
("gvvh" ["规章"])
("gvvi" ["滚珠轴承" "滚柱轴承"])
("gvvr" ["硅砖"])
("gvvs" ["贵重"])
("gvw'" ["构筑物"])
("gvxq" ["闺秀"])
("gvxw" ["跪下"])
("gvxy" ["贵姓"])
("gvyb" ["硅油"])
("gvyh" ["贵阳"])
("gvyr" ["归原"])
("gvyt" ["规约"])
("gvyu" ["归于" "鳜鱼"])
("gvyv" ["孤注一掷" "高瞻远嘱"])
("gvze" ["规则"])
("gvzi" ["鬼子" "柜子"])
("gvzk" ["硅藻"])
("gvzu" ["贵族"])
("gwbv" ["国务部长"])
("gwcl" ["挂彩"])
("gwd'" ["高纬度"])
("gwdk" ["刮刀"])
("gwe'" "剐寡呱")
("gwff" ["瓜分"])
("gwfg" ["刮风"])
("gwfu" ["寡妇"])
("gwgb" ["挂钩"])
("gwgw" ["呱呱"])
("gwh'" ["革委会"])
("gwhk" ["挂号"])
("gwhy" ["国务会议"])
("gwi'" ["盖碗茶"])
("gwie" ["挂车"])
("gwj'" ["港务局"])
("gwjd" ["港务监督"])
("gwjl" ["古往今来"])
("gwjy" ["古为今用"])
("gwlm" ["剐脸"])
("gwm'" ["给我们"])
("gwmj" ["拐弯抹角"])
("gwmm" ["挂面"])
("gwmu" ["寡母"])
("gwmy" ["挂名"])
("gwnm" ["挂念"])
("gwpm" ["瓜片"])
("gwq'" ["刮" "瓜" "括" "呱" "栝" "胍" "鸹" "国务卿"])
("gwr'" "挂褂卦诖")
("gwtb" ["寡头"])
("gwtu" ["挂图"])
("gwuy" ["挂帅"])
("gwwy" ["国务委员"])
("gwy'" ["公务员" "国务院"])
("gwyj" ["刮研"])
("gwyl" ["国务院总理"])
("gwzi" ["瓜子" "褂子"])
("gwzv" ["岗位责任制"])
("gx'" ["关系"])
("gxb'" ["冠心病"])
("gxbl" ["光学玻璃"])
("gxd'" ["工宣队" "光绪帝"])
("gxdj" ["勾心斗角"])
("gxdl" ["惯性定律"])
("gxg'" ["共析钢"])
("gxgv" ["改邪归正"])
("gxh'" ["关系户"])
("gxhd" ["更新换代"])
("gxhu" ["供销合作社"])
("gxhx" ["共性和个性"])
("gxij" ["购销差价"])
("gxj'" ["硅橡胶"])
("gxl'" ["惯性力"])
("gxq'" ["滚雪球"])
("gxqu" ["各行其是" "各行其事"])
("gxqy" ["甘心情愿"])
("gxru" ["感性认识"])
("gxt'" ["观象台"])
("gxtx" ["光纤通信"])
("gxu'" ["广西省"])
("gxvz" ["广西壮族"])
("gxy'" ["干性油" "高血压" "管弦乐"])
("gxyd" ["管弦乐队"])
("gxyx" ["各向异性"])
("gy'" ["关于"])
("gyb'" ["工业部"])
("gybm" ["工业部门"])
("gybq" ["过意不去"])
("gyci" ["苟延残喘"])
("gyd'" ["高压电"])
("gydl" ["感应电流" "告一段落"])
("gydu" ["工业电视"])
("gydx" ["工业大学"])
("gye'" "拐")
("gyg'" ["工业国"])
("gygm" ["工业革命"])
("gygp" ["拐棍"])
("gygy" ["乖乖"])
("gyh'" ["工业化" "国有化"])
("gyhq" ["过氧化氢"])
("gyhw" ["怪话" "过氧化物"])
("gyix" ["工艺程序"])
("gyj'" ["公益金"])
("gyjd" ["工业基地"])
("gyli" ["工艺流程"])
("gylz" ["国语罗马字"])
("gymu" ["工艺美术"])
("gyn'" ["圭亚那"])
("gyni" ["国营农场"])
("gyp'" ["工业品" "工艺品"])
("gypl" ["固有频率"])
("gyq'" ["乖" "掴" "管乐器"])
("gyqq" ["各有千秋"])
("gyqy" ["国营企业"])
("gyr'" "怪")
("gytx" ["工业体系"])
("gyu'" ["公因式" "公因数" "公约数" "贵阳市"])
("gyui" ["怪事"])
("gyuy" ["公用事业" "国营商业"])
("gyv'" ["甘油酯" "公有制"])
("gyvh" ["拐杖"])
("gyvx" ["工业战线" "工业中心"])
("gyw'" ["顾炎武"])
("gywj" ["拐弯"])
("gywu" ["怪物"])
("gyx'" ["高压线"])
("gyxn" ["工艺性能"])
("gyyl" ["工业原料"])
("gyzi" ["拐子"])
("gyzl" ["怪哉"])
("gz'" ["工作"])
("gzc'" ["耕作层"])
("gzd'" ["工作地"])
("gze'" "给")
("gzf'" ["工作服"])
("gzg'" ["工字钢"])
("gziu" ["给出"])
("gzj'" ["干燥机" "国子监"])
("gzjb" ["工资级别"])
("gzl'" ["骨子里"])
("gzld" ["工资劳动"])
("gzm'" ["工作面"])
("gzni" ["给你"])
("gznn" ["给您"])
("gzq'" ["干燥器"])
("gzr'" ["工作日"])
("gzrf" ["给人"])
("gzta" ["给他" "给它" "给她"])
("gzu'" ["工作上" "刽子手"])
("gzv'" ["工作者" "龚自珍"])
("gzvd" ["工作制度"])
("gzvv" ["贵族政治"])
("gzwo" ["给我"])
("gzwv" ["各自为政"])
("gzwy" ["革左五营"])
("gzx'" ["干燥箱"])
("gzxy" ["工作需要"])
("gzy'" ["归罪于"])
("gzyi" ["给以"])
("gzyu" ["给予"])
("gzze" ["工资总额"])
("h" "和")
("hada" ["哈达"])
("hae'" "哈")
("haha" ["哈哈"])
("haji" ["哈吉"])
("hake" ["哈克"])
("hali" ["哈利"])
("hama" ["蛤蟆"])
("hami" ["哈密"])
("haq'" "哈铪")
("har'" "哈")
("hash" ["哈桑"])
("hasz" ["磺胺噻唑"])
("hate" ["哈特"])
("haw'" "蛤虾")
("hax'" ["海岸线"])
("hb'" ["合并"])
("hbb'" ["黑板报"])
("hbbm" ["后边"])
("hbbo" ["厚薄"])
("hbbu" ["候补"])
("hbbz" ["后辈" "后备"])
("hbd'" ["恨不得"])
("hbdl" ["后代"])
("hbdp" ["后盾"])
("hbdu" ["黑白电视" "厚度"])
("hbe'" "吼")
("hber" ["后儿"])
("hbfh" ["后方"])
("hbgf" ["后跟"])
("hbgo" ["后果"])
("hbgr" ["喉管"])
("hbgs" ["后宫"])
("hbgv" ["互不干涉内政"])
("hbh'" ["好不好" "会不会"])
("hbhj" ["后汉"])
("hbhl" ["货币回笼"])
("hbhr" ["后患"])
("hbhv" ["后悔"])
("hbie" ["后车"])
("hbif" ["后尘"])
("hbix" ["汇编程序"])
("hbj'" ["后备军"])
("hbjc" ["吼叫" "后脚"])
("hbji" ["候机" "后记"])
("hbjm" ["后件"])
("hbjn" ["后进"])
("hbk'" ["禾本科"])
("hblc" ["厚了"])
("hbld" ["后梁"])
("hbli" ["厚利"])
("hbll" ["后来"])
("hbls" ["喉咙"])
("hblt" ["活蹦乱跳" "货币流通"])
("hblu" ["后路"])
("hbmf" ["后门"])
("hbmm" ["后面"])
("hbmu" ["后母"])
("hbnc" ["候鸟"])
("hbnk" ["后脑"])
("hbnm" ["后年"])
("hbpl" ["后排"])
("hbpy" ["华北平原"])
("hbqc" ["后桥"])
("hbqi" ["后期" "后起"])
("hbqn" ["后勤"])
("hbqy" ["互不侵犯条约"])
("hbr'" "侯厚候后堠後逅鲎")
("hbrf" ["后人" "后任"])
("hbss" ["后送"])
("hbtb" ["喉头" "猴头" "后头"])
("hbth" ["后唐"])
("hbtl" ["后台"])
("hbtm" ["后天"])
("hbtu" ["后土"])
("hbtv" ["后退"])
("hbu'" ["河北省" "湖北省"])
("hbub" ["后手"])
("hbue" ["喉舌"])
("hbuf" ["候审"])
("hbug" ["吼声" "后生"])
("hbui" ["厚实" "后世" "后事"])
("hbv'" ["核爆炸"])
("hbvb" ["后周"])
("hbve" ["后者"])
("hbvf" ["候诊"])
("hbvi" ["后肢"])
("hbvu" ["后主"])
("hbw'" "喉侯猴瘊篌糇骺")
("hbwz" ["后卫"])
("hbxc" ["后效"])
("hbxd" ["后项"])
("hbxr" ["候选"])
("hbxt" ["后学"])
("hbxu" ["后续"])
("hbxy" ["后行"])
("hby'" ["后半夜"])
("hbyi" ["后裔"])
("hbyj" ["后燕"])
("hbyr" ["后院"])
("hbyu" ["后于"])
("hbyy" ["汇编语言"])
("hbzb" ["货币资本"])
("hbzi" ["猴子"])
("hbzj" ["货币资金"])
("hbzo" ["后作"])
("hczm" ["花刺子模"])
("hd'" ["活动"])
("hdan" ["磺胺"])
("hdb'" ["核蛋白"])
("hdba" ["黄霸"])
("hdbj" ["黄斑"])
("hdbk" ["谎报"])
("hdbl" ["黄白"])
("hdd'" ["好端端" "黑洞洞"])
("hddb" ["黄豆"])
("hddh" ["晃荡"])
("hddi" ["荒地" "皇帝"])
("hddj" ["荒诞"])
("hddk" ["荒岛" "黄道"])
("hdds" ["晃动"])
("hde'" "晃幌恍谎")
("hdfg" ["黄蜂"])
("hdfz" ["荒废"])
("hdgh" ["黄冈"])
("hdgr" ["皇冠"])
("hdgs" ["皇宫"])
("hdgw" ["黄瓜"])
("hdhb" ["皇后"])
("hdhd" ["惶惶" "晃晃"])
("hdhe" ["黄河"])
("hdhl" ["黄海"])
("hdho" ["惶惑"])
("hdhp" ["黄昏"])
("hdhu" ["恍惚" "或多或少"])
("hdhw" ["黄花" "谎话"])
("hdig" ["谎称"])
("hdik" ["皇朝"])
("hdis" ["蝗虫"])
("hdiu" ["很大程度上"])
("hdj'" ["活动家"])
("hdjc" ["荒郊"])
("hdjn" ["黄金"])
("hdjq" ["黄酒"])
("hdjw" ["皇家"])
("hdks" ["惶恐"])
("hdl'" ["耗电量" "核动力"])
("hdla" ["黄蜡"])
("hdld" ["荒凉"])
("hdli" ["黄鹂"])
("hdlm" ["黄连"])
("hdlr" ["慌乱"])
("hdls" ["洪都拉斯" "黄龙"])
("hdly" ["黄陵"])
("hdm'" ["横断面"])
("hdma" ["黄麻"])
("hdmc" ["滑动摩擦"])
("hdmh" ["慌忙"])
("hdmo" ["荒漠"])
("hdmq" ["荒谬"])
("hdmz" ["黄梅"])
("hdn'" ["华达呢"])
("hdnm" ["荒年"])
("hdnq" ["黄牛"])
("hdp'" ["黄道婆"])
("hdpm" ["簧片"])
("hdpu" ["黄埔" "黄浦"])
("hdq'" ["荒" "慌" "肓" "海淀区"])
("hdqc" ["黄桥"])
("hdqr" ["皇权"])
("hdr'" ["晃" "很多人"])
("hdrh" ["黄壤"])
("hdrj" ["恍然"])
("hdse" ["黄色"])
("hdsr" ["磺酸"])
("hdth" ["荒唐"])
("hdti" ["黄体"])
("hdtm" ["皇天"])
("hdts" ["黄铜"])
("hdtu" ["黄土"])
("hdu'" ["恒等式"])
("hduh" ["皇上"])
("hdui" ["黄石" "皇室"])
("hduj" ["荒山" "黄山"])
("hduu" ["荒疏"])
("hdv'" ["火电站"])
("hdvb" ["黄州"])
("hdvd" ["皇庄"])
("hdvh" ["慌张"])
("hdvi" ["滑动轴承"])
("hdvs" ["黄钟" "黄种"])
("hdw'" "黄磺蝗簧皇凰惶煌隍徨湟潢遑璜癀蟥篁鳇")
("hdwu" ["荒芜"])
("hdxm" ["黄县"])
("hdxw" ["海盗行为"])
("hdxy" ["黄兴"])
("hdy'" ["活动于"])
("hdyb" ["黄油"])
("hdye" ["荒野"])
("hdyh" ["黄杨"])
("hdyi" ["黄衣"])
("hdyj" ["谎言"])
("hdyn" ["荒淫"])
("hdyr" ["荒原"])
("hdyu" ["黄鱼"])
("hdzi" ["幌子"])
("hdzu" ["皇族"])
("heai" ["和蔼"])
("hean" ["河岸"])
("heb'" ["哈尔滨"])
("hebi" ["何必"])
("hebk" ["荷包"])
("hebu" ["何不" "华而不实" "哈尔滨市"])
("heby" ["合并"])
("hebz" ["河北"])
("hecg" ["何曾"])
("heci" ["贺词"])
("hecl" ["喝采" "喝彩"])
("hecp" ["和村"])
("hedg" ["何等"])
("hedi" ["河堤"])
("hedk" ["喝道" "河道"])
("hedm" ["贺电"])
("heds" ["河东"])
("hedv" ["核对"])
("hedy" ["核定"])
("heer" ["赫尔"])
("hefa" ["合法"])
("hefg" ["和风"])
("hefh" ["何妨"])
("hefu" ["和服"])
("hefz" ["合肥"])
("hegb" ["河沟"])
("hege" ["合格"])
("hego" ["何国"])
("hegs" ["河工"])
("hegu" ["合股" "河梏"])
("hehe" ["呵呵" "荷荷" "赫赫"])
("hehk" ["和好"])
("heho" ["合伙"])
("hehr" ["和缓" "合欢"])
("hehu" ["合乎"])
("hehv" ["和会"])
("hehw" ["荷花"])
("heia" ["喝茶" "核查"])
("heid" ["河床"])
("heig" ["合称" "合成"])
("heih" ["何尝" "合唱"])
("heii" ["呵斥"])
("heip" ["和春"])
("heir" ["河川"])
("heiu" ["何处"])
("heji" ["合剂" "合计"])
("hejm" ["河间"])
("hejn" ["合金"])
("hejq" ["喝酒"])
("heju" ["和局"])
("hejw" ["和加"])
("hejx" ["和解"])
("hejy" ["和静"])
("hekb" ["合口" "河口"])
("hekd" ["何况"])
("heku" ["何苦"])
("heli" ["合理" "合力"])
("helj" ["荷兰"])
("helq" ["合流" "河流"])
("hels" ["合拢"])
("hemb" ["合谋"])
("hemc" ["禾苗"])
("heml" ["和买"])
("hemm" ["河面"])
("hemo" ["核膜"])
("hemu" ["和睦"])
("hemz" ["褐煤"])
("heni" ["和你" "河泥"])
("henj" ["河南"])
("henn" ["和您"])
("henr" ["和暖"])
("henz" ["河内"])
("hepj" ["河畔"])
("hepl" ["合拍"])
("hepy" ["和平"])
("heq'" "呵喝诃嗬")
("heqi" ["和棋" "和气"])
("heqm" ["呵欠"])
("heqn" ["和亲"])
("heqp" ["合群"])
("hequ" ["河渠"])
("her'" "喝荷和何赫褐鹤贺吓壑")
("herf" ["核仁"])
("herj" ["赫然"])
("heru" ["何如"])
("hese" ["褐色"])
("hesi" ["赫斯"])
("hesr" ["核酸" "核算" "合算"])
("heta" ["和他"])
("hetb" ["和头"])
("heth" ["核糖"])
("hetj" ["和谈" "河滩"])
("hetk" ["核桃" "河套"])
("hetm" ["和田"])
("hets" ["合同"])
("heuf" ["合身"])
("heug" ["和声"])
("heuh" ["和尚"])
("heui" ["核实" "和诗" "何时" "合适"])
("heuj" ["和善" "河山"])
("heup" ["和顺"])
("heuu" ["和数" "合数"])
("heuv" ["喝水" "河水"])
("heva" ["合闸"])
("hevb" ["和州"])
("hevg" ["和政"])
("hevi" ["何止"])
("hevp" ["核准"])
("hevs" ["荷重" "何种"])
("hevu" ["合著"])
("hew'" "荷菏核禾和何合盒貉阂河涸劾阖纥曷盍颌蚵翮")
("hewf" ["和文"])
("hewh" ["河网"])
("hewo" ["和我"])
("hewy" ["合而为一"])
("hewz" ["何谓"])
("hexi" ["河西" "贺喜"])
("hexj" ["赫尔辛基"])
("hexm" ["和弦"])
("hexn" ["核心" "贺信"])
("hexx" ["和谐" "河蟹"])
("heye" ["荷叶"])
("heyi" ["和易" "和议" "何以" "合宜" "合意"])
("heyj" ["河沿"])
("heys" ["合用"])
("heyt" ["和约"])
("heyy" ["合营" "合影"])
("hezb" ["合奏"])
("hezh" ["合葬"])
("hezi" ["核子" "合资" "合子" "盒子" "赫兹"])
("hezl" ["荷载" "何在"])
("hezo" ["合作"])
("hf'" ["合法"])
("hfbu" ["很不"])
("hfda" ["很大"])
("hfdi" ["很低"])
("hfdo" ["很多"])
("hfdr" ["很短"])
("hfdu" ["狠毒"])
("hfdv" ["合法斗争" "很对"])
("hfdx" ["哈佛大学"])
("hfe'" "很狠")
("hfg'" ["花粉管"])
("hfgd" ["很广"])
("hfgk" ["很高"])
("hfhf" ["很很" "狠狠"])
("hfhk" ["很好"])
("hfhy" ["很坏"])
("hfia" ["很差"])
("hfih" ["很长"])
("hfji" ["痕迹"])
("hfjq" ["很久"])
("hfky" ["很快"])
("hfl'" ["汉弗莱"])
("hfmj" ["很慢"])
("hfnj" ["很难"])
("hfpo" ["很破"])
("hfqd" ["很强"])
("hfqy" ["合法权益"])
("hfr'" "恨")
("hfs'" ["皇甫嵩"])
("hftb" ["恨透"])
("hfu'" ["合肥市"])
("hfub" ["很受"])
("hfuf" ["很深"])
("hfuk" ["很少"])
("hfvw" ["狠抓"])
("hfw'" ["痕" "挥发物"])
("hfwj" ["很晚"])
("hfxc" ["很小"])
("hfxd" ["很象"])
("hfxn" ["狠心"])
("hfy'" ["核反应" "挥发油"])
("hfyb" ["很有"])
("hfyd" ["核反应堆"])
("hfyr" ["很远"])
("hfz'" ["坏分子"])
("hfzk" ["很早"])
("hg'" ["合格"])
("hgbk" ["横暴"])
("hgbo" ["横波"])
("hgcl" ["横财"])
("hgd'" ["弧光灯"])
("hgdg" ["恒等"])
("hgdu" ["横渡"])
("hgdy" ["恒定"])
("hge'" ["黑格尔"])
("hgfh" ["横放"])
("hgfu" ["横幅"])
("hgg'" ["函梏关"])
("hggr" ["横贯"])
("hghg" ["哼哼"])
("hgi'" ["化工厂"])
("hgj'" ["烘干机"])
("hgjw" ["横加" "桁架"])
("hgkw" ["横跨"])
("hgld" ["横梁" "衡量" "恒量"])
("hgli" ["亨利"])
("hglq" ["横流"])
("hgmj" ["横蛮"])
("hgpl" ["横排"])
("hgq'" "哼亨")
("hgqx" ["横切"])
("hgr'" "横")
("hgs'" ["核苷酸" "惠更斯"])
("hgsk" ["横扫"])
("hgth" ["横躺"])
("hgug" ["横生"])
("hgui" ["恒湿"])
("hguj" ["横山" "衡山" "宏观世界"])
("hguu" ["横竖"])
("hgvb" ["横轴"])
("hgvi" ["横直"])
("hgvy" ["后顾之忧"])
("hgw'" "横衡恒行蘅珩桁")
("hgwf" ["恒温"])
("hgwl" ["回过味来"])
("hgws" ["化公为私"])
("hgwy" ["好高鹜远"])
("hgxd" ["横向"])
("hgxm" ["横线"])
("hgxy" ["横行" "恒星"])
("hgy'" ["花岗岩"])
("hgya" ["恒压"])
("hgyb" ["核工业部"])
("hgyd" ["护国运动"])
("hgyh" ["衡阳"])
("hgym" ["祸国殃民"])
("hgzu" ["海关总署"])
("hh'" ["很好"])
("hhbc" ["航标"])
("hhbj" ["航班"])
("hhd'" ["黑黑的" "红红的" "厚厚的"])
("hhdd" ["浩浩荡荡"])
("hhdk" ["航道" "巷道"])
("hhfd" ["火花放电"])
("hhhl" ["航海"])
("hhht" ["呼和浩特"])
("hhhv" ["行会"])
("hhhw" ["行话"])
("hhig" ["航程"])
("hhir" ["航船"])
("hhj'" ["化合价" "活化剂"])
("hhjg" ["混合结构"])
("hhjm" ["行间"])
("hhju" ["行距"])
("hhjw" ["行家"])
("hhkb" ["巷口"])
("hhks" ["航空"])
("hhlj" ["合乎逻辑"])
("hhll" ["轰轰烈烈" "花花绿绿"])
("hhlu" ["航路"])
("hhlx" ["行列"])
("hhm'" ["胡汉民"])
("hhn'" ["活化能"])
("hhq'" ["夯" "混合器"])
("hhqy" ["行情"])
("hhr'" "巷行沆")
("hhs'" ["核黄素" "黄褐色" "火花塞"])
("hhsu" ["航速"])
("hhtm" ["航天"])
("hhu'" ["后汉书"])
("hhui" ["行市"])
("hhvb" ["杭州"])
("hhvj" ["巷战"])
("hhw'" ["杭" "航" "吭" "行" "绗" "珩" "颃" "化合物" "混合物"])
("hhx'" ["互换性"])
("hhxd" ["航向"])
("hhxm" ["航线"])
("hhxy" ["航行"])
("hhy'" ["黄花鱼"])
("hhye" ["行业"])
("hhyp" ["航运"])
("hhz'" ["好孩子"])
("hi'" ["会场"])
("hia'" ["合成氨"])
("hii'" ["黑沉沉"])
("hil'" ["回潮率"])
("hiq'" ["缓冲器" "缓冲区"])
("hiry" ["缓冲溶液"])
("hit'" ["火车头"])
("hiu'" ["候车室"])
("hiuv" ["合成树脂"])
("hiv'" ["火车站"])
("hixj" ["合成洗涤剂" "合成橡胶"])
("hixw" ["合成纤维"])
("hj'" ["会见" "会计"])
("hjbh" ["环境保护"])
("hjbk" ["汉堡"])
("hjcp" ["韩村"])
("hjdi" ["旱地"])
("hjdj" ["邯郸"])
("hjdk" ["喊到"])
("hjdl" ["寒带" "汉代"])
("hjdm" ["函电"])
("hjds" ["涵洞" "寒冬"])
("hje'" "喊罕阚")
("hjfg" ["寒风" "焊缝"])
("hjfj" ["火箭发动机"])
("hjg'" ["好几个" "合金钢"])
("hjgb" ["函购"])
("hjgd" ["寒光"])
("hjgo" ["韩国"])
("hjgs" ["焊工"])
("hjh'" ["好家伙"])
("hjhb" ["憨厚"])
("hjhp" ["含混"])
("hjhu" ["含糊" "换句话说"])
("hjhw" ["汉化"])
("hjif" ["寒碜"])
("hjig" ["汉城"])
("hjik" ["寒潮" "汉朝"])
("hjir" ["汉川"])
("hjjc" ["喊叫"])
("hjjd" ["汉江"])
("hjji" ["旱季"])
("hjjm" ["函件" "罕见" "汉奸"])
("hjjw" ["寒假"])
("hjjx" ["焊接"])
("hjka" ["汉卡"])
("hjkb" ["汉口"])
("hjl'" ["含金量" "好极了"])
("hjla" ["含蜡"])
("hjld" ["海军陆战队" "含量"])
("hjlg" ["寒冷"])
("hjln" ["翰林"])
("hjlq" ["寒流"])
("hjlu" ["寒露"])
("hjlv" ["汉律"])
("hjmn" ["汉民"])
("hjq'" "酣憨顸蚶鼾")
("hjqi" ["寒气"])
("hjqy" ["旱情"])
("hjr'" "翰撼捍旱憾悍焊汗汉菡撖瀚颔")
("hjre" ["寒热"])
("hjrf" ["汉人"])
("hjrj" ["悍然"])
("hjs'" ["火炬松"])
("hjt'" ["火箭筒"])
("hjtb" ["焊头"])
("hjtc" ["焊条"])
("hjtl" ["酣态"])
("hjtm" ["旱田"])
("hju'" ["候机室"])
("hjub" ["函授"])
("hjud" ["黄金时代"])
("hjug" ["鼾声"])
("hjuu" ["函数" "汉书"])
("hjuv" ["酣睡" "含水" "汗水"])
("hjv'" ["花键轴"])
("hjvs" ["汉中"])
("hjvu" ["汗珠"])
("hjw'" "邯韩含涵寒函汗邗晗焓")
("hjwr" ["环境污染"])
("hjwu" ["环境卫生"])
("hjwz" ["捍卫"])
("hjxc" ["含笑"])
("hjxi" ["焊锡"])
("hjxn" ["寒心"])
("hjxq" ["含羞"])
("hjxt" ["汉学"])
("hjxu" ["含蓄"])
("hjyb" ["含有"])
("hjyh" ["涵养" "汉阳"])
("hjyi" ["含义" "涵义" "寒衣"])
("hjyj" ["旱烟"])
("hjyr" ["含冤" "后继有人"])
("hjyu" ["汉语"])
("hjyy" ["汉英"])
("hjzi" ["汉子" "汉字"])
("hjzl" ["旱灾"])
("hjzu" ["汉族"])
("hk'" ["很快"])
("hkan" ["毫安"])
("hkba" ["毫巴"])
("hkbi" ["好比"])
("hkbu" ["毫不" "好不"])
("hkda" ["浩大"])
("hkde" ["好的"])
("hkdh" ["浩荡"])
("hkdl" ["好歹"])
("hkdm" ["耗电"])
("hkdo" ["好多"])
("hke'" "好郝")
("hkf'" ["后空翻"])
("hkfh" ["豪放"])
("hkfu" ["豪富" "毫伏"])
("hkfz" ["耗费"])
("hkgb" ["壕沟"])
("hkgj" ["好感"])
("hkgo" ["好过"])
("hkhg" ["毫亨"])
("hkhj" ["好汉" "浩瀚"])
("hkhk" ["好好" "浩浩"])
("hkhw" ["豪华" "好话"])
("hkhy" ["好坏"])
("hkig" ["号称"])
("hkii" ["好吃"])
("hkiu" ["好处"])
("hkjc" ["嚎叫" "号角"])
("hkjn" ["耗尽"])
("hkjq" ["好久"])
("hkjx" ["豪杰" "浩劫"])
("hkke" ["毫克" "好客"])
("hkkj" ["好看"])
("hklc" ["好了"])
("hkly" ["号令"])
("hkma" ["号码"])
("hkmc" ["毫秒"])
("hkmf" ["豪门"])
("hkmi" ["毫米"])
("hkmj" ["航空母舰"])
("hkmk" ["毫毛"])
("hkml" ["豪迈"])
("hkpy" ["好评"])
("hkq'" "蒿薅嚆")
("hkqd" ["豪强"])
("hkqi" ["好奇"])
("hkqq" ["好球"])
("hkqy" ["豪情"])
("hkr'" "镐好耗号浩灏昊皓颢")
("hkrf" ["好人"])
("hksi" ["好似"])
("hksj" ["耗散"])
("hksp" ["耗损"])
("hkt'" ["灰口铁"])
("hkty" ["好听"])
("hkub" ["好手" "好受"])
("hkuf" ["豪绅"])
("hkug" ["毫升" "好生"])
("hkui" ["好使" "好事"])
("hkul" ["海枯石烂"])
("hkuo" ["好说"])
("hkuu" ["号数"])
("hkuv" ["耗水"])
("hkvj" ["好战"])
("hkvk" ["号召"])
("hkvr" ["好转"])
("hkvu" ["豪猪"])
("hkw'" "壕嚎豪毫号貉嗥濠蚝")
("hkwj" ["好玩"])
("hkwu" ["毫无"])
("hkwz" ["毫微"])
("hkxc" ["好笑"])
("hkxd" ["好像" "好象"])
("hkxi" ["好戏"])
("hkxn" ["好心"])
("hkxt" ["好学"])
("hkxx" ["好些"])
("hkyb" ["好友"])
("hkyi" ["好意"])
("hkys" ["好用"])
("hkyu" ["航空运输"])
("hkzi" ["耗资" "耗子" "号子"])
("hkzl" ["好在"])
("hl'" ["合理"])
("hlan" ["海岸"])
("hlb'" ["核裂变" "胡萝卜"])
("hlba" ["海拔"])
("hlbj" ["合理布局"])
("hlbm" ["海边"])
("hlbn" ["海滨"])
("hlbo" ["海波"])
("hlbs" ["胡萝卜素"])
("hlbu" ["旱涝保收" "还不"])
("hlbz" ["海北"])
("hld'" ["惠灵顿"])
("hlde" ["海德"])
("hldi" ["海底" "海地"])
("hldk" ["海岛" "海盗"])
("hldl" ["海带"])
("hldm" ["海淀"])
("hle'" "海胲醢")
("hler" ["孩儿"])
("hlfd" ["火力发电"])
("hlfg" ["海风"])
("hlfh" ["海防" "护林防火"])
("hlfi" ["火力发电厂"])
("hlgh" ["海港"])
("hlgr" ["海关"])
("hlgv" ["海龟"])
("hlh'" ["合理化"])
("hlhe" ["海河"])
("hlhf" ["还很"])
("hlhk" ["还好"])
("hlht" ["糊里糊涂"])
("hlhv" ["还会"])
("hlij" ["海产"])
("hlik" ["海潮"])
("hlir" ["海船"])
("hlis" ["害虫"])
("hliu" ["害处"])
("hlj'" ["黑龙江" "红领巾" "后掠角" "回老家"])
("hljb" ["汗流浃背"])
("hljd" ["海疆" "还将"])
("hljn" ["海禁"])
("hljp" ["海军"])
("hlju" ["黑龙江省"])
("hlkb" ["海口"])
("hlke" ["还可"])
("hll'" ["哗啦啦" "灰溜溜"])
("hllh" ["海浪"])
("hlli" ["海里"])
("hllp" ["海轮"])
("hllq" ["海流"])
("hlls" ["海龙"])
("hlm'" ["红楼梦"])
("hlma" ["海马"])
("hlmm" ["海绵" "海面"])
("hlmv" ["合理密植"])
("hlng" ["还能"])
("hlnj" ["海南"])
("hlnl" ["氦氖"])
("hlnx" ["海涅"])
("hlnz" ["海内"])
("hlou" ["海鸥"])
("hlpa" ["害怕"])
("hlq'" ["嘿" "咳" "嗨" "环流器"])
("hlqi" ["氦气"])
("hlqu" ["海区"])
("hlr'" "氦亥害骇")
("hlsi" ["害死"])
("hlsk" ["害臊"])
("hlsp" ["海损"])
("hlth" ["海棠"])
("hltj" ["海滩"])
("hlts" ["孩童"])
("hlu'" ["行列式"])
("hluf" ["海参"])
("hluh" ["海上"])
("hlui" ["还是"])
("hluv" ["海水"])
("hlve" ["海蜇"])
("hlvj" ["海战"])
("hlw'" "还孩骸")
("hlwj" ["海湾"])
("hlwl" ["海外"])
("hlwz" ["海味" "还未"])
("hlxc" ["还小"])
("hlxd" ["海相"])
("hlxf" ["赫鲁晓夫"])
("hlxm" ["海鲜"])
("hlxq" ["害羞"])
("hlxu" ["翰林学士"])
("hlxw" ["海峡"])
("hlya" ["海牙"])
("hlyb" ["还有"])
("hlyh" ["海洋"])
("hlyj" ["海盐" "海燕"])
("hlyk" ["还要"])
("hlyp" ["海运"])
("hlyr" ["海员"])
("hlyu" ["海域"])
("hlyy" ["还应"])
("hlz'" ["滑轮组"])
("hlzi" ["孩子"])
("hlzk" ["海藻"])
("hlzl" ["还在"])
("hm'" ["毫米"])
("hmb'" ["毫米波"])
("hmgl" ["汗马功劳"])
("hmjl" ["荒谬绝伦"])
("hmxu" ["黑幕小说"])
("hn'" ["还能"])
("hnd'" ["海南岛"])
("hngt'" "哼")
("hnj'" ["混凝剂"])
("hnt'" ["混凝土"])
("hnu'" ["河南省" "很难说" "湖南省"])
("hnz'" ["哈尼族"])
("hoba" ["火把"])
("hobi" ["货币"])
("hobj" ["伙伴"])
("hoch" ["货舱"])
("hode" ["获得"])
("hods" ["活动"])
("hoe'" "伙火夥钬")
("hoer" ["活儿"])
("hofh" ["伙房"])
("hofo" ["活佛"])
("hogf" ["祸根"])
("hogl" ["活该"])
("hogs" ["火攻"])
("hohb" ["火候"])
("hohl" ["火海" "祸害"])
("hoho" ["活活"])
("hohs" ["火红"])
("hohw" ["活化" "火花"])
("hoia" ["霍查"])
("hoie" ["火车" "货车"])
("hoil" ["火柴"])
("hoir" ["货船"])
("hojd" ["获奖"])
("hoji" ["活计" "伙计"])
("hojm" ["火箭"])
("hoju" ["火炬"])
("hojx" ["活结"])
("hojy" ["火井"])
("hokb" ["豁口"])
("hokh" ["火炕"])
("hokr" ["货款"])
("holc" ["活了"])
("holi" ["活力" "火力" "获利"])
("holo" ["活络"])
("holp" ["货轮"])
("holr" ["霍乱" "祸乱"])
("hols" ["火龙"])
("holu" ["活路" "火炉"])
("homc" ["火苗"])
("homf" ["活门"])
("homl" ["活埋"])
("homm" ["豁免"])
("homy" ["活命"])
("hong" ["或能"])
("hopk" ["火炮"])
("hopn" ["货品"])
("hopo" ["活泼"])
("hoq'" "豁劐攉锪耠")
("hoqd" ["火墙"])
("hoqi" ["活期" "火器" "火气"])
("hoqu" ["获取"])
("hor'" "和豁获或惑霍货祸藿嚯镬蠖")
("hore" ["火热"])
("horj" ["或然"])
("hose" ["货色"])
("hosh" ["霍桑"])
("hosl" ["活塞"])
("hosu" ["火速"])
("hotb" ["火头"])
("hoti" ["或体"])
("hotj" ["货摊"])
("hots" ["伙同"])
("hotv" ["火腿"])
("houb" ["祸首"])
("houe" ["火舌"])
("houg" ["获胜"])
("houi" ["伙食" "火势" "获释" "或是"])
("houj" ["火山" "霍山"])
("houk" ["火烧"])
("houv" ["活水"])
("hove" ["或者"])
("hovj" ["货栈"])
("hovo" ["活捉"])
("hovp" ["获准"])
("hovs" ["火种"])
("hovu" ["货主"])
("how'" "活和")
("howh" ["火网"])
("howu" ["货物"])
("howz" ["或为"])
("hoxd" ["活象" "货箱"])
("hoxi" ["获悉"])
("hoxm" ["活现" "火线"])
("hoxu" ["或许"])
("hoxy" ["活性" "火星"])
("hoyb" ["火油" "或有"])
("hoyj" ["火焰"])
("hoyk" ["火药"])
("hoyp" ["货运"])
("hoyr" ["货源"])
("hoys" ["或用"])
("hoyt" ["活跃"])
("hozi" ["活字"])
("hozl" ["火灾"])
("hozv" ["豁嘴"])
("hp'" ["和平"])
("hpan" ["昏暗"])
("hpcl" ["荤菜"])
("hpdj" ["混蛋"])
("hpdp" ["混沌"])
("hpfb" ["婚否"])
("hpfh" ["混纺"])
("hpgd" ["和平过渡"])
("hpgi" ["和平共处"])
("hphb" ["浑厚"])
("hphd" ["昏黄"])
("hphe" ["混和" "混合"])
("hphk" ["诨号"])
("hphp" ["馄馄"])
("hpif" ["昏沉"])
("hpig" ["混成"])
("hpj'" ["黄埔江"])
("hpjn" ["混进"])
("hpli" ["婚礼"])
("hplm" ["混炼"])
("hplr" ["混乱"])
("hpm'" ["海平面"])
("hpmi" ["昏迷"])
("hpmm" ["混棉"])
("hppu" ["浑朴"])
("hppz" ["婚配"])
("hpq'" ["荤" "昏" "婚" "阍" "混频器"])
("hpqi" ["婚期"])
("hpr'" "混诨溷")
("hpru" ["混入"])
("hptp" ["和平谈判"])
("hpts" ["混同"])
("hpuf" ["浑身"])
("hpui" ["婚事"])
("hpvh" ["混帐"])
("hpvj" ["混战"])
("hpvo" ["浑浊" "混浊"])
("hpw'" "魂浑混馄珲")
("hpxc" ["混淆"])
("hpxd" ["混响"])
("hpyb" ["荤油"])
("hpyh" ["混养"])
("hpyn" ["婚姻"])
("hpys" ["昏庸"])
("hpyt" ["婚约"])
("hpza" ["混杂"])
("hpzo" ["混作"])
("hq'" ["活期"])
("hqb'" ["后勤部"])
("hqhc" ["何去何从"])
("hqhl" ["合情合理"])
("hqj'" ["黑旗军"])
("hql'" ["好起来"])
("hqm'" ["横切面" "黄曲霉"])
("hqs'" ["花青素"])
("hqt'" ["核潜艇"])
("hqu'" ["红旗手"])
("hqvx" ["后起之秀"])
("hqx'" ["好奇心"])
("hrb'" ["黑热病"])
("hrbf" ["还本"])
("hrbj" ["换班"])
("hrbk" ["环抱"])
("hrby" ["患病"])
("hrcp" ["缓存"])
("hrdc" ["换掉"])
("hrdg" ["幻灯"])
("hrdl" ["环带"])
("hrdu" ["欢度"])
("hrdw" ["恍然大悟"])
("hre'" "缓")
("hrfa" ["焕发"])
("hrfh" ["换防"])
("hrg'" ["洪仁柑"])
("hrgr" ["宦官"])
("hrgs" ["换工"])
("hrgu" ["环顾"])
("hrgz" ["还给"])
("hrhe" ["缓和"])
("hrhh" ["换行"])
("hrhr" ["缓缓"])
("hrhu" ["欢呼"])
("hria" ["换茬"])
("hrie" ["换车"])
("hrig" ["环城"])
("hrih" ["欢畅"])
("hris" ["缓冲"])
("hrji" ["还击" "缓急"])
("hrjt" ["幻觉"])
("hrju" ["欢聚"])
("hrjx" ["环节" "缓解"])
("hrjy" ["环境"])
("hrky" ["欢快"])
("hrl'" ["核燃料"])
("hrle" ["欢乐"])
("hrlq" ["环流"])
("hrmj" ["缓慢"])
("hrmx" ["幻灭"])
("hrnj" ["患难"])
("hrq'" ["欢" "獾" "换热器"])
("hrqi" ["缓期" "换气" "唤起"])
("hrqq" ["环球"])
("hrqu" ["换取"])
("hrqy" ["还清"])
("hrr'" "换患唤痪豢焕涣宦幻奂擐浣漶逭鲩")
("hrrf" ["换人"])
("hrrk" ["环绕"])
("hrsj" ["涣散"])
("hrsr" ["换算"])
("hrss" ["欢送"])
("hrsu" ["还俗"])
("hrt'" ["怀仁堂"])
("hrtg" ["欢腾"])
("hrtw" ["骇人听闻"])
("hrub" ["还手"])
("hrug" ["欢声"])
("hrui" ["环视"])
("hrve" ["患者"])
("hrvg" ["痪症"])
("hrvl" ["还债"])
("hrvs" ["环中"])
("hrw'" "环桓还郇萑圜洹寰缳锾鬟")
("hrwf" ["换文"])
("hrwj" ["环烷"])
("hrxc" ["欢笑"])
("hrxd" ["还乡" "换向" "幻想"])
("hrxi" ["欢喜"])
("hrxn" ["欢欣" "欢心"])
("hrxr" ["桓玄"])
("hrxy" ["环形" "环行" "缓刑" "唤醒"])
("hry'" ["好容易"])
("hrye" ["换页"])
("hryh" ["豢养"])
("hryr" ["还原"])
("hryt" ["浑然一体"])
("hryu" ["换羽"])
("hryx" ["焕然一新"])
("hryy" ["欢迎"])
("hrz'" ["好日子"])
("hsb'" ["黑穗病"])
("hsbz" ["烘焙"])
("hsda" ["洪大" "宏大"])
("hsdb" ["红豆"])
("hsdg" ["红灯"])
("hsdj" ["红丹"])
("hsds" ["轰动"])
("hse'" "哄")
("hsfg" ["洪峰"])
("hsg'" ["活塞杆"])
("hsgb" ["鸿沟"])
("hsgd" ["红光"])
("hsgh" ["黄色工会"])
("hsgj" ["烘干"])
("hsgo" ["红果"])
("hsgr" ["宏观"])
("hsh'" ["活塞环"])
("hshe" ["红河"])
("hshl" ["红海"])
("hsho" ["红火"])
("hshu" ["洪湖"])
("hshw" ["红花"])
("hsia" ["红茶"])
("hsj'" ["红四军"])
("hsji" ["轰击"])
("hsjm" ["鸿渐"])
("hsjp" ["红军"])
("hsju" ["黑色金属"])
("hskb" ["虹口"])
("hskk" ["烘烤"])
("hslb" ["红楼"])
("hsld" ["洪亮"])
("hslm" ["红脸"])
("hsln" ["红磷"])
("hslq" ["洪流" "红柳"])
("hsls" ["轰隆"])
("hslu" ["烘炉"])
("hslx" ["胡思乱想"])
("hsma" ["红麻"])
("hsmf" ["洪门"])
("hsmu" ["红木"])
("hsmy" ["轰鸣"])
("hsns" ["弘农"])
("hspm" ["哄骗"])
("hsq'" "轰哄烘訇薨")
("hsqi" ["红旗"])
("hsqr" ["红圈"])
("hsqu" ["红曲"])
("hsqy" ["烘青"])
("hsr'" "哄讧蕻")
("hsre" ["红热"])
("hsrf" ["红人"])
("hsrh" ["红壤"])
("hsrp" ["红润"])
("hss'" ["黑色素"])
("hsse" ["红色"])
("hsss" ["红松"])
("hsth" ["红糖"])
("hstl" ["哄抬"])
("hsto" ["烘托"])
("hsts" ["红铜"])
("hstu" ["宏图"])
("hsuk" ["红烧" "红苕"])
("hsuu" ["红薯"])
("hsuv" ["洪水"])
("hsva" ["轰炸"])
("hsvh" ["红色中华"])
("hsvq" ["红色政权"])
("hsvs" ["红肿"])
("hsw'" "虹鸿洪宏弘红黉荭蕻闳泓")
("hswu" ["洪武"])
("hswz" ["宏伟"])
("hsxd" ["烘箱"])
("hsxi" ["虹吸"])
("hsxm" ["红线"])
("hsxn" ["红心"])
("hsxy" ["红星"])
("hsye" ["红叶"])
("hsyh" ["宏扬" "弘扬"])
("hsyj" ["红岩" "红颜"])
("hszp" ["虹鳟"])
("ht'" ["合同"])
("hte'" ["好天儿"])
("htfj" ["航天飞机"])
("htgy" ["黄土高原"])
("hth'" ["皇太后"])
("hthn" ["昏头昏脑"])
("hths" ["核糖核酸"])
("htk'" ["黄铁矿" "黄铜矿"])
("htl'" ["化铁炉" "混铁炉"])
("htu'" ["红塔山"])
("htxd" ["欢天喜地"])
("htyk" ["回头一看"])
("htyw" ["互通有无"])
("htz'" ["皇太子"])
("hu'" ["还是"])
("hub'" ["花生饼"])
("hubd" ["胡说八道"])
("hubn" ["湖滨"])
("hubu" ["互补" "户部"])
("huby" ["护兵"])
("hubz" ["湖北"])
("huc'" ["含水层"])
("hud'" ["华盛顿" "划时代"])
("hudc" ["户调"])
("hudi" ["忽地"])
("hudm" ["好事多磨"])
("hudu" ["弧度"])
("hudx" ["蝴蝶"])
("hue'" "虎唬浒琥")
("huer" ["忽而"])
("hufa" ["护法"])
("hufh" ["互访"])
("hugd" ["湖广" "弧光"])
("hugj" ["互感"])
("huhh" ["护航"])
("huhj" ["呼喊"])
("huhk" ["呼号"])
("huhl" ["胡海"])
("huhr" ["呼唤" "互换"])
("huhs" ["绘声绘色"])
("huhu" ["忽忽" "虎虎"])
("huhv" ["互惠"])
("huhw" ["胡话"])
("hujc" ["呼叫" "胡椒"])
("hujd" ["虎将"])
("huji" ["户籍"])
("hujp" ["弧菌"])
("hujq" ["呼救"])
("hujy" ["函授教育" "火上加油"])
("hukb" ["糊口" "湖口" "虎口" "户口"])
("hul'" ["含水量" "黄鼠狼" "回收率"])
("huld" ["欢声雷动"])
("hulh" ["虎狼"])
("huli" ["狐狸" "护理" "互利"])
("hull" ["胡来"])
("huln" ["护林"])
("hulr" ["胡乱"])
("hult" ["忽略"])
("hulu" ["葫芦"])
("hum'" ["花生米"])
("huma" ["胡麻"])
("humf" ["虎门"])
("humi" ["忽米"])
("humm" ["湖面"])
("hunj" ["湖南"])
("hunk" ["胡闹"])
("hupl" ["互派"])
("hupo" ["湖泊"])
("huq'" "呼乎忽糊戏唿惚滹轷烀")
("huqi" ["呼气"])
("huqn" ["胡琴"])
("huqq" ["虎丘"])
("hur'" "糊虎护互沪户冱岵怙戽扈祜瓠鹱笏")
("hurj" ["忽然"])
("hurs" ["互溶"])
("huss" ["护送"])
("hutb" ["户头"])
("hutk" ["胡桃"])
("huts" ["胡同" "互通"])
("hutu" ["胡涂" "糊涂"])
("huu'" ["活生生"])
("huug" ["呼声" "互生"])
("huui" ["忽视" "护士"])
("huul" ["海市蜃楼"])
("huuo" ["胡说"])
("huuv" ["湖水"])
("huvb" ["胡诌"])
("huvc" ["海事仲裁"])
("huvk" ["护照"])
("huvu" ["互助" "户主"])
("huw'" "核和瑚壶葫胡蝴狐糊湖弧囫猢槲觳煳鹄鹕醐斛鹘")
("huwz" ["护卫" "互为"])
("hux'" ["好胜心"])
("huxc" ["呼啸"])
("huxd" ["互相"])
("huxi" ["呼吸"])
("huxm" ["弧线"])
("huxt" ["虎穴"])
("huxu" ["胡须"])
("huxy" ["弧形"])
("huy'" ["核试验" "花生油"])
("huyj" ["胡言"])
("huyu" ["海上运输" "呼吁"])
("huyy" ["呼应"])
("huzh" ["红十字会"])
("huzi" ["胡子" "虎子"])
("hv'" ["或者"])
("hvan" ["灰暗" "晦暗"])
("hvba" ["会把"])
("hvbi" ["回避"])
("hvbj" ["回转半径" "会办"])
("hvbk" ["汇报"])
("hvbl" ["横征暴敛" "灰白"])
("hvbm" ["汇编"])
("hvbo" ["回波"])
("hvcl" ["回采"])
("hvda" ["回答"])
("hvdc" ["毁掉"])
("hvdh" ["回荡" "会当"])
("hvdk" ["回到"])
("hvdm" ["回电"])
("hvds" ["挥动" "回动"])
("hvdv" ["汇兑"])
("hve'" "毁悔虺")
("hver" ["会儿"])
("hvfa" ["挥发"])
("hvff" ["灰分"])
("hvfg" ["回风"])
("hvfh" ["回放"])
("hvfu" ["恢复" "回复"])
("hvge" ["挥戈"])
("hvgl" ["悔改"])
("hvgo" ["回国"])
("hvgr" ["会馆"])
("hvgu" ["回顾"])
("hvgv" ["回归"])
("hvhb" ["会后"])
("hvhd" ["辉煌"])
("hvhe" ["回合" "会合" "汇合"])
("hvhf" ["悔恨"])
("hvho" ["挥霍"])
("hvhv" ["回回"])
("hvhw" ["会话" "绘画"])
("hvhy" ["毁坏"])
("hvie" ["回车"])
("hvif" ["灰尘"])
("hvig" ["回程"])
("hvih" ["会场"])
("hvik" ["回潮"])
("hvis" ["蛔虫"])
("hviu" ["绘出"])
("hvj'" ["轰炸机"])
("hvjc" ["回教"])
("hvjd" ["灰浆"])
("hvji" ["回击" "会集" "汇集"])
("hvjm" ["回见" "会见"])
("hvjn" ["灰烬"])
("hvju" ["会聚" "汇聚" "货真价实"])
("hvjw" ["回家"])
("hvkb" ["回扣"])
("hvke" ["会客"])
("hvkr" ["汇款"])
("hvli" ["会理"])
("hvll" ["回来"])
("hvlq" ["汇流"])
("hvls" ["回笼"])
("hvlu" ["回路" "贿赂"])
("hvlv" ["汇率"])
("hvm'" ["胡志明"])
("hvmm" ["会面"])
("hvmn" ["回民"])
("hvmx" ["毁灭"])
("hvp'" ["化妆品"])
("hvpc" ["汇票"])
("hvq'" "堕灰挥辉徽恢诙咴隳珲晖虺麾")
("hvqi" ["晦气"])
("hvqu" ["回去"])
("hvr'" "慧卉惠晦贿秽会烩汇讳诲绘溃荟蕙哕喙浍彗缋桧恚蟪")
("hvru" ["汇入"])
("hvse" ["灰色"])
("hvsi" ["回丝"])
("hvsp" ["毁损"])
("hvt'" ["灰铸铁"])
("hvtb" ["回头"])
("hvth" ["会堂"])
("hvtj" ["会谈"])
("hvtm" ["回填"])
("hvts" ["会同"])
("hvtu" ["灰土" "绘图"])
("hvu'" ["杭州市"])
("hvub" ["挥手" "回收" "回手" "回首"])
("hvuf" ["会审"])
("hvug" ["回声" "回升"])
("hvuh" ["会商" "会上"])
("hvui" ["回师" "会师" "会使" "会试"])
("hvuo" ["会说"])
("hvuu" ["回赎"])
("hvuv" ["回水"])
("hvv'" ["核战争" "慌张张"])
("hvvb" ["惠州"])
("hvvf" ["会诊"])
("hvvh" ["徽章"])
("hvvi" ["绘制"])
("hvvj" ["会战"])
("hvvr" ["回转"])
("hvvs" ["回中"])
("hvw'" "徊蛔回茴洄")
("hvwl" ["化整为零"])
("hvwu" ["灰雾" "挥舞" "悔悟" "会晤"])
("hvwz" ["回味"])
("hvxd" ["回乡" "回想" "回响" "茴香"])
("hvxn" ["灰心" "回信" "会心"])
("hvxr" ["回旋"])
("hvxx" ["恢谐" "诙谐"])
("hvyb" ["回游" "会有" "洄游"])
("hvyh" ["惠阳"])
("hvyi" ["回忆" "会意" "会议"])
("hvyj" ["会演"])
("hvyn" ["回音"])
("hvyr" ["会员" "慧远"])
("hvyu" ["毁誉"])
("hvyy" ["辉映"])
("hvz'" ["互助组"])
("hvzg" ["回赠"])
("hvzi" ["会子"])
("hvzs" ["汇总"])
("hvzu" ["回族"])
("hw'" ["会晤"])
("hwb'" ["红卫兵"])
("hwbf" ["话本"])
("hwbi" ["画笔"])
("hwbj" ["花瓣" "滑板"])
("hwbk" ["画报"])
("hwbl" ["花白"])
("hwbm" ["花边" "哗变"])
("hwbu" ["花布" "画布"])
("hwby" ["滑冰"])
("hwbz" ["花被" "华北"])
("hwce" ["画册"])
("hwck" ["花草"])
("hwd'" ["汉武帝"])
("hwdg" ["华灯"])
("hwdk" ["滑道"])
("hwdo" ["花朵"])
("hwds" ["华东" "滑动"])
("hwdy" ["划定"])
("hwdz" ["核外电子"])
("hwee" ["花萼"])
("hwer" ["花儿" "画儿"])
("hwfa" ["画法"])
("hwff" ["花粉" "划分"])
("hwfu" ["画幅"])
("hwfz" ["花费" "化肥"])
("hwgk" ["画稿"])
("hwgr" ["花冠"])
("hwgs" ["化工"])
("hwgv" ["划归"])
("hwh'" ["河网化"])
("hwhe" ["化合"])
("hwhr" ["滑环"])
("hwhs" ["花红"])
("hwhv" ["花卉"])
("hwia" ["花茶"])
("hwie" ["滑车"])
("hwih" ["花厂"])
("hwiu" ["画出"])
("hwj'" ["护卫舰"])
("hwjc" ["花椒" "花轿"])
("hwji" ["滑稽"])
("hwjm" ["花键"])
("hwjr" ["画卷"])
("hwju" ["话剧"])
("hwjw" ["花甲" "画家" "画架"])
("hwkj" ["画刊"])
("hwla" ["哗啦"])
("hwlh" ["画廊"])
("hwli" ["华里" "华丽"])
("hwlm" ["花脸"])
("hwln" ["桦林"])
("hwlp" ["滑轮"])
("hwlz" ["花蕾"])
("hwm'" ["毫微米"])
("hwmi" ["花蜜"])
("hwmm" ["画面"])
("hwmu" ["花木"])
("hwmz" ["华美"])
("hwn'" ["哈瓦那"])
("hwnc" ["花鸟"])
("hwnd" ["花娘"])
("hwni" ["花呢"])
("hwnj" ["华南"])
("hwns" ["化脓"])
("hwpf" ["花盆"])
("hwpi" ["画皮"])
("hwpk" ["花炮"])
("hwpm" ["画片"])
("hwpo" ["滑坡" "划破"])
("hwpy" ["花瓶"])
("hwq'" ["花" "哗" "华" "化" "砉" "核武器"])
("hwqc" ["华侨"])
("hwqi" ["花期" "花旗"])
("hwqm" ["花钱"])
("hwqp" ["花裙"])
("hwqr" ["花圈"])
("hwqy" ["花青" "划清"])
("hwr'" "华画划化话桦")
("hwrf" ["华人"])
("hwrj" ["哗然"])
("hwrp" ["滑润"])
("hwse" ["花色"])
("hwsi" ["花丝"])
("hwt'" ["环烷烃"])
("hwtb" ["话头"])
("hwti" ["话题"])
("hwtj" ["花坛"])
("hwto" ["华佗"])
("hwts" ["话筒"])
("hwtu" ["画图"])
("hwua" ["华沙"])
("hwuf" ["化身"])
("hwug" ["花生"])
("hwui" ["花市" "滑石" "画室" "化石"])
("hwuj" ["华山"])
("hwuo" ["话说"])
("hwuu" ["花束"])
("hwvb" ["花轴"])
("hwvd" ["化装" "化妆"])
("hwvj" ["画展"])
("hwvk" ["花招"])
("hwvs" ["华中"])
("hwvu" ["花柱"])
("hww'" "哗华猾滑划豁骅铧")
("hwwf" ["花纹"])
("hwwy" ["化为乌有"])
("hwx'" ["海王星" "红外线"])
("hwxd" ["红外线灯" "滑翔" "画像"])
("hwxi" ["华西"])
("hwxm" ["划线" "化纤"])
("hwxt" ["滑雪" "化学"])
("hwxu" ["花序"])
("hwxw" ["华夏"])
("hwxx" ["河外星系"])
("hwxy" ["滑行"])
("hwy'" ["画外音"])
("hwya" ["花芽"])
("hwyh" ["花样"])
("hwyi" ["花衣" "华裔" "滑移" "画一" "划一"])
("hwyj" ["化验"])
("hwyk" ["花药"])
("hwyn" ["滑音"])
("hwyr" ["花园"])
("hwyt" ["混为一谈"])
("hwyu" ["话语"])
("hwyw" ["毫无疑问"])
("hwyy" ["毫无疑义"])
("hwzi" ["花子"])
("hwzo" ["化作"])
("hx'" ["化学"])
("hxah" ["互相爱护"])
("hxb'" ["红细胞" "红小兵"])
("hxbd" ["横行霸道"])
("hxbh" ["化学变化"])
("hxbv" ["互相帮助"])
("hxd'" ["汉献帝" "呼吸道"])
("hxfl" ["化学肥料"])
("hxfu" ["化学方程式"])
("hxfx" ["化学分析"])
("hxfy" ["化学反应"])
("hxg'" ["虹吸管"])
("hxgw" ["欢欣鼓舞"])
("hxgy" ["化学工业"])
("hxh'" ["华兴会"])
("hxhi" ["化学合成"])
("hxj'" ["化学键"])
("hxjq" ["回旋加速器"])
("hxkn" ["呼吸困难"])
("hxn'" ["化学能"])
("hxph" ["化学平衡"])
("hxq'" ["红血球" "换向器"])
("hxr'" ["候选人"])
("hxrl" ["活性染料"])
("hxsq" ["灰心丧气"])
("hxt'" ["还乡团" "活性炭"])
("hxv'" ["红袖章"])
("hxvx" ["活性中心"])
("hxwq" ["化学武器"])
("hxwv" ["华夏文摘"])
("hxxt" ["呼吸系统"])
("hxxv" ["化学性质"])
("hxxw" ["化学纤维"])
("hxys" ["化学元素"])
("hy'" ["会议"])
("hyan" ["淮安"])
("hybc" ["怀表"])
("hybk" ["怀抱"])
("hybz" ["淮北"])
("hyde" ["怀德"])
("hydj" ["坏蛋"])
("hyf'" ["婚姻法"])
("hyfh" ["花芽分化"])
("hyg'" ["好一个" "会员国"])
("hygu" ["怀古"])
("hygv" ["华阳国志"])
("hyh'" ["花月痕"])
("hyhb" ["花样滑冰"])
("hyhe" ["淮河"])
("hyhf" ["怀恨"])
("hyhl" ["淮海"])
("hyhw" ["坏话"])
("hyhy" ["晃悠晃悠"])
("hyiu" ["坏处"])
("hyj'" ["还原剂"])
("hyjq" ["怀旧"])
("hyl'" ["耗油率" "回忆录"])
("hylc" ["坏了"])
("hynj" ["淮南"])
("hynm" ["怀念"])
("hyq'" ["海洋权" "化油器"])
("hyr'" "坏")
("hyrb" ["怀柔"])
("hyrf" ["坏人"])
("hyrl" ["还原染料" "还原熔炼"])
("hys'" ["好意思"])
("hysi" ["坏死"])
("hyt'" ["划" "合议庭"])
("hyu'" ["回忆说"])
("hyui" ["坏事"])
("hyuu" ["槐树"])
("hyuv" ["环氧树脂"])
("hyv'" ["合议制" "换言之"])
("hyvd" ["婚姻制度"])
("hyve" ["怀着"])
("hyw'" "槐徊怀淮踝")
("hywi" ["荒淫无耻"])
("hyy'" ["黑压压" "黑黝黝"])
("hyyi" ["怀疑"])
("hyyp" ["怀孕"])
("hyyw" ["环氧乙烷"])
("hyzy" ["婚姻自由"])
("hz'" ["汉字"])
("hzan" ["黑暗"])
("hzb'" ["横坐标"])
("hzbh" ["黑帮"])
("hzbj" ["黑板"])
("hzbl" ["黑白"])
("hzbx" ["火灾保险"])
("hzdb" ["黑豆"])
("hzdi" ["黑地"])
("hzfw" ["胡作非为"])
("hzgd" ["黑光"])
("hzge" ["黑格"])
("hzh'" ["合作化" "洪泽湖"])
("hzhl" ["黑海"])
("hzho" ["黑货"])
("hzhz" ["嘿嘿"])
("hzml" ["黑麦"])
("hzmu" ["黑幕"])
("hzmz" ["黑霉"])
("hzng" ["皇族内阁"])
("hzq'" ["嘿" "黑" "嗨" "孩子气"])
("hzrf" ["黑人"])
("hzse" ["黑色"])
("hzss" ["黑松"])
("hzti" ["黑体"])
("hztk" ["黑陶"])
("hztm" ["黑天"])
("hztu" ["黑土"])
("hzu'" ["合作社"])
("hzub" ["黑手" "黑瘦"])
("hzud" ["合作商店"])
("hzui" ["汉字输出" "黑市"])
("hzuj" ["黑山"])
("hzur" ["汉字输入"])
("hzuv" ["黑水"])
("hzxn" ["黑心"])
("hzxw" ["黑下"])
("hzye" ["黑夜"])
("hzyq" ["很早以前"])
("hzyu" ["活字印刷"])
("i" "出")
("iabj" ["插班" "查办"])
("iabx" ["差别"])
("iabz" ["茶杯"])
("iaco" ["差错"])
("iade" ["差得"])
("iadg" ["差等"])
("iadk" ["岔道"])
("iadm" ["茶点" "查点" "差点"])
("iads" ["差动"])
("iadv" ["插队" "查对"])
("iae'" "叉镲衩")
("iaee" ["差额"])
("iaff" ["差分"])
("iafg" ["查封"])
("iafh" ["茶房" "察访"])
("iago" ["查过"])
("iagr" ["茶馆"])
("iahk" ["插好"])
("iaho" ["查获"])
("iahu" ["茶壶"])
("iahv" ["茶会"])
("iahw" ["插话"])
("iaih" ["茶场"])
("iaiu" ["查出" "查处"])
("iaj'" ["长安街"])
("iaji" ["茶几"])
("iajm" ["插件"])
("iajn" ["查禁"])
("iajq" ["查究"])
("iajt" ["察觉"])
("iaju" ["差距"])
("iajw" ["差价"])
("iakb" ["插口" "茬口"])
("iakj" ["查勘" "查看" "察看"])
("iakk" ["查考"])
("iakl" ["岔开"])
("ialb" ["茶楼"])
("ialu" ["岔路"])
("iamy" ["查明"])
("iana" ["刹那"])
("ians" ["茶农"])
("iaq'" "插叉碴差喳嚓馇杈锸")
("iaqu" ["插曲"])
("iaqy" ["查清"])
("iar'" "叉岔差诧刹汊姹杈衩")
("iaru" ["插入"])
("iase" ["茶色"])
("iatb" ["插头"])
("iatc" ["插条"])
("iath" ["茶汤"])
("iatr" ["察团"])
("iatu" ["插图"])
("iaub" ["插手"])
("iauh" ["插上"])
("iauu" ["茶树" "差数"])
("iauv" ["茶水"])
("iavg" ["查证"])
("iavh" ["查帐"])
("iavi" ["差值"])
("iavk" ["查找"])
("iaw'" "叉茬茶查碴搽察猹楂槎檫")
("iawf" ["查问"])
("iawj" ["茶碗" "查完"])
("iaxc" ["插销"])
("iaxp" ["查询"])
("iayb" ["茶油"])
("iaye" ["插页" "茶叶"])
("iayh" ["插秧"])
("iayi" ["差异" "诧异"])
("iayr" ["茶园"])
("iayt" ["查阅"])
("iazi" ["叉子" "查字" "岔子"])
("iazo" ["插座"])
("iazu" ["插足"])
("iazv" ["插嘴"])
("ibbj" ["筹办"])
("ibbz" ["筹备"])
("ibco" ["筹措"])
("ibd'" ["差不多"])
("ibda" ["抽打"])
("ibdc" ["抽调"])
("ibdi" ["仇敌"])
("ibdr" ["绸缎"])
("ibds" ["抽动"])
("ibdu" ["稠度"])
("ibe'" "瞅丑")
("ibee" ["丑恶"])
("ibfg" ["抽风"])
("ibhf" ["仇恨"])
("ibhs" ["成本核算"])
("ibhw" ["筹划" "丑化"])
("ibia" ["抽查"])
("ibis" ["臭虫"])
("ibiu" ["抽搐" "踌躇"])
("ibj'" ["常备军"])
("ibjc" ["丑角"])
("ibji" ["筹集"])
("ibjm" ["筹建" "瞅见"])
("ibjn" ["抽筋" "酬金"])
("ibjs" ["成本计算"])
("ibju" ["丑剧"])
("ibk'" ["吃不开"])
("ibkr" ["筹款"])
("ibks" ["抽空"])
("ibku" ["愁苦"])
("ibl'" ["差不离" "储备粮"])
("iblb" ["丑陋"])
("iblk" ["酬劳"])
("ibmf" ["愁闷"])
("ibmi" ["稠密"])
("ibq'" "抽瘳")
("ibqi" ["抽泣" "臭气"])
("ibqm" ["抽签"])
("ibr'" "臭")
("ibrf" ["仇人"])
("ibrs" ["愁容"])
("ibsv" ["抽穗"])
("ibtb" ["抽头"])
("ibti" ["抽屉"])
("ibtl" ["丑态"])
("ibu'" ["长白山" "吃不上" "出版社"])
("ibuh" ["筹商"])
("ibui" ["仇视" "丑事"])
("ibuj" ["称霸世界"])
("ibuv" ["抽水" "抽税"])
("ibv'" ["吃败仗"])
("ibve" ["瞅着"])
("ibw'" "酬畴踌稠愁筹仇绸俦帱惆雠")
("ibwf" ["丑闻"])
("ibwz" ["臭味"])
("ibx'" ["吃不下" "吃不消"])
("ibxd" ["抽象"])
("ibxx" ["酬谢"])
("ibyh" ["抽样" "臭氧"])
("ibyj" ["抽烟"])
("ibzi" ["绸子"])
("ic'" ["除此"])
("icj'" ["除草剂"])
("icvw" ["除此之外"])
("id'" ["程度"])
("idb'" ["超短波"])
("idba" ["疮疤"])
("idbj" ["创办"])
("idd'" ["沉甸甸" "传动带"])
("iddj" ["床单"])
("iddl" ["传导电流"])
("idds" ["窗洞"])
("ide'" "闯")
("idf'" ["沉淀法"])
("idgo" ["闯过"])
("idho" ["闯祸"])
("idhu" ["窗户"])
("idhv" ["创汇"])
("idiu" ["闯出"])
("idj'" ["产蛋鸡"])
("idjd" ["闯将"])
("idjm" ["创见" "创建"])
("idju" ["创举"])
("idjy" ["赤道几内亚"])
("idkb" ["窗口" "创口"])
("idkd" ["窗框"])
("idkj" ["创刊"])
("idli" ["创立"])
("idlm" ["窗帘"])
("idpu" ["床铺"])
("idq'" ["疮" "窗" "创" "称得起"])
("idqi" ["彻底清除"])
("idr'" "创怆")
("idru" ["闯入"])
("idtb" ["床头"])
("idtl" ["窗台"])
("idu'" ["成都市"])
("idue" ["创设"])
("iduh" ["创伤"])
("idui" ["创始"])
("idv'" ["传动轴"])
("idvi" ["创制"])
("idw'" "幢床")
("idwh" ["闯王"])
("idwz" ["床位"])
("idx'" ["传递性"])
("idxn" ["创新"])
("idye" ["创业"])
("idzi" ["窗子"])
("idzk" ["创造"])
("idzo" ["创作"])
("ieba" ["车把"])
("ieby" ["撤兵"])
("ieci" ["车次"])
("iedc" ["撤掉"])
("iedg" ["车灯"])
("iedi" ["彻底"])
("iedk" ["车刀" "车道"])
("iedv" ["车队"])
("iedy" ["车顶"])
("iee'" "扯尺")
("iefh" ["撤防"])
("iefu" ["车夫"])
("iegb" ["车钩"])
("iegs" ["车工"])
("iehd" ["扯谎"])
("ieho" ["车祸"])
("iehr" ["撤换"])
("iehv" ["撤回"])
("ieid" ["车床"])
("ieir" ["车船"])
("ieiu" ["撤除"])
("iejm" ["车间"])
("iejp" ["撤军"])
("iejw" ["车驾"])
("ield" ["车辆"])
("ieli" ["车里" "撤离"])
("ielp" ["车轮"])
("ielq" ["车流"])
("ielr" ["超额利润"])
("iemf" ["车门"])
("ienj" ["车尔尼雪夫斯基"])
("iepc" ["车票"])
("iepi" ["车皮"])
("ieq'" "车砗")
("ieqm" ["车前"])
("ier'" "撤掣彻澈坼")
("iesu" ["车速"])
("ietb" ["车头"])
("ieti" ["车体"])
("ietl" ["车胎"])
("ietv" ["撤退"])
("ieuf" ["车身"])
("ievb" ["车轴"])
("ieve" ["扯着"])
("ievi" ["撤职"])
("ievj" ["车站"])
("iexc" ["撤销" "撤消"])
("iexd" ["车厢" "车箱"])
("iexy" ["车型"])
("ieye" ["彻夜"])
("iezb" ["撤走"])
("iezi" ["车子"])
("if'" ["出发"])
("ifai" ["尘埃"])
("ifbk" ["晨报"])
("ifbu" ["衬布"])
("ifcu" ["陈醋"])
("ifd'" ["出发点"])
("ifdm" ["沉淀" "衬垫"])
("ife'" "碜")
("iffg" ["晨风"])
("iffu" ["臣服" "陈腐"])
("ifgd" ["辰光" "晨光"])
("ifgv" ["陈规"])
("ifho" ["陈货"])
("ifif" ["沉沉"])
("ifii" ["陈炽"])
("ifjd" ["沉降"])
("ifji" ["沉积" "沉寂" "陈迹" "趁机"])
("ifjn" ["沉浸"])
("ifjq" ["陈旧"])
("ifjy" ["沉静"])
("ifli" ["衬里"])
("iflp" ["沉沦"])
("iflx" ["陈列"])
("ifmf" ["沉闷"])
("ifmi" ["沉迷"])
("ifmn" ["臣民"])
("ifmo" ["沉没" "沉默"])
("ifni" ["沉溺"])
("ifpl" ["乘风破浪"])
("ifq'" ["郴" "抻" "嗔" "琛" "冲锋枪" "触发器"])
("ifqi" ["衬砌"])
("ifqu" ["晨曲"])
("ifqx" ["臣妾"])
("ifr'" "趁衬称秤谶榇龀")
("ifre" ["趁热"])
("ifsi" ["沉思"])
("ift'" ["伧" "长方体" "出风头"])
("iftj" ["充分条件"])
("ifto" ["衬托"])
("ifts" ["沉痛"])
("iftu" ["尘土"])
("ifua" ["辰砂"])
("ifug" ["陈胜"])
("ifui" ["尘世" "趁势"])
("ifuj" ["衬衫"])
("ifuu" ["陈述"])
("ifuv" ["沉睡"])
("ifve" ["趁着"])
("ifvo" ["沉着"])
("ifvs" ["沉重"])
("ifw'" "臣辰尘晨忱沉陈橙沈谌宸")
("ifx'" ["长方形"])
("ifxi" ["晨曦"])
("ifxn" ["称心"])
("ifxv" ["冲锋陷阵"])
("ifxy" ["晨星"])
("ifyi" ["陈毅" "衬衣"])
("ifyn" ["沉吟"])
("ifyp" ["陈云"])
("ifzi" ["臣子"])
("ifzk" ["趁早"])
("ifzv" ["沉醉"])
("ig'" ["成果"])
("igba" ["称霸"])
("igbf" ["成本"])
("igbi" ["撑臂"])
("igbj" ["惩办" "承办"])
("igbk" ["呈报" "承包" "承保"])
("igbl" ["成败"])
("igby" ["称病"])
("igbz" ["成倍"])
("igcl" ["成材"])
("igd'" ["唱高调"])
("igde" ["承德"])
("igdh" ["承当"])
("igdi" ["呈递"])
("igdj" ["承担"])
("igdk" ["称道"])
("igdu" ["成都" "程度"])
("igdv" ["成堆"])
("ige'" "逞骋裎")
("igfa" ["乘法" "惩罚"])
("igff" ["成分"])
("igfg" ["成风"])
("igfh" ["城防" "成方" "乘方"])
("igfz" ["乘飞"])
("iggb" ["秤钩"])
("iggo" ["城郭" "成果"])
("iggs" ["成功"])
("iggv" ["成规"])
("ighd" ["橙黄"])
("ighk" ["称号" "乘号"])
("igho" ["成活"])
("ighs" ["橙红"])
("ighu" ["称呼"])
("ighw" ["成化"])
("igie" ["乘车"])
("igii" ["城池"])
("igir" ["乘船"])
("igis" ["成虫"])
("igiu" ["乘除" "惩处"])
("igiv" ["秤锤"])
("igjc" ["城郊" "成交"])
("igjd" ["澄江"])
("igji" ["成绩" "乘机" "乘积"])
("igjm" ["成见"])
("igjq" ["成就"])
("igjw" ["成家"])
("igjx" ["承接"])
("igke" ["乘客"])
("igkf" ["诚恳"])
("iglb" ["城楼"])
("iglc" ["成了"])
("igli" ["城里" "成立"])
("iglj" ["橙兰"])
("igmf" ["城门"])
("igmg" ["承蒙"])
("igmi" ["乘幂"])
("igmy" ["成名"])
("igng" ["逞能"])
("ignj" ["城南"])
("ignm" ["成年"])
("igno" ["承诺"])
("ignz" ["城内"])
("igp'" ["超高频"])
("igpi" ["成批"])
("igpn" ["成品"])
("igpu" ["城堡"])
("igq'" ["撑" "称" "秤" "噌" "柽" "瞠" "铛" "蛏" "传感器"])
("igqd" ["城墙" "逞强"])
("igqi" ["撑起"])
("igqn" ["成亲"])
("igqp" ["成群"])
("igqr" ["成全"])
("igqu" ["城区"])
("igqy" ["澄清"])
("igr'" "称秤")
("igrf" ["成人" "承认"])
("igrj" ["诚然"])
("igse" ["成色"])
("igss" ["称颂"])
("igt'" ["撑竿跳"])
("igti" ["成体"])
("igtk" ["成套"])
("igtm" ["成天" "承天"])
("igto" ["秤砣"])
("igu'" ["吹鼓手"])
("igub" ["承受"])
("igug" ["乘胜"])
("iguh" ["呈上"])
("igui" ["城市" "成事" "程式" "诚实"])
("iguo" ["成说"])
("iguu" ["称述" "成熟" "乘数"])
("igvd" ["盛装"])
("igvf" ["城镇"])
("igvh" ["成长"])
("igvi" ["惩治" "诚挚"])
("igvs" ["承重"])
("igw'" "城橙成呈乘程惩澄诚承盛丞埕枨塍铖裎酲")
("igwf" ["成文" "呈文"])
("igwl" ["城外"])
("igwq" ["常规武器"])
("igwu" ["乘务"])
("igwz" ["称为" "称谓" "成为"])
("igxc" ["成效"])
("igxd" ["城乡" "成象" "丞相"])
("igxi" ["城西" "承袭"])
("igxm" ["呈现"])
("igxn" ["成心" "诚心"])
("igxs" ["逞凶"])
("igxu" ["程序"])
("igxy" ["成型" "成行"])
("igy'" ["超高压"])
("igyi" ["成衣" "乘以" "诚意"])
("igyk" ["撑腰" "成药"])
("igyn" ["成因"])
("igyp" ["承运"])
("igyr" ["成员"])
("igys" ["骋用"])
("igyt" ["成约"])
("igyu" ["成语"])
("igzj" ["称赞"])
("igzl" ["成灾" "承载"])
("igzo" ["称作"])
("ihai" ["肠癌"])
("ihan" ["长安"])
("ihba" ["常把"])
("ihbf" ["唱本"])
("ihbl" ["长白"])
("ihbm" ["长编"])
("ihbo" ["长波"])
("ihbz" ["常备"])
("ihci" ["唱词"])
("ihcp" ["长存"])
("ihda" ["长达"])
("ihde" ["常德"])
("ihdi" ["场地"])
("ihdk" ["尝到" "倡导"])
("ihdr" ["长短"])
("ihdu" ["长度"])
("ihe'" ["场" "厂" "敞" "惝" "昶" "氅" "察哈尔"])
("ihee" ["嫦娥"])
("ihfa" ["长发"])
("ihfh" ["长方" "厂房"])
("ihfu" ["偿付"])
("ihge" ["唱歌"])
("ihgr" ["肠管"])
("ihgs" ["长工"])
("ihgv" ["常规"])
("ihh'" ["茶话会"])
("ihhe" ["场合" "长河"])
("ihhl" ["长海"])
("ihhr" ["偿还"])
("ihhs" ["长虹"])
("ihhv" ["常会"])
("ihig" ["长城"])
("ihih" ["常常"])
("ihik" ["诚惶诚恐"])
("ihip" ["长春"])
("ihis" ["长虫"])
("ihiu" ["长处"])
("ihjd" ["长江"])
("ihji" ["唱机" "娼妓"])
("ihjm" ["常见"])
("ihjq" ["长久"])
("ihjt" ["猖獗"])
("ihjw" ["厂家"])
("ihjy" ["场景"])
("ihkb" ["敞口"])
("ihkd" ["猖狂" "厂矿"])
("ihkl" ["敞开"])
("ihku" ["长裤"])
("ihky" ["畅快"])
("ihl'" ["成活率"])
("ihld" ["常量"])
("ihle" ["长乐"])
("ihlh" ["长廊"])
("ihm'" ["城隍庙"])
("ihmk" ["长毛"])
("ihmm" ["场面" "长眠"])
("ihmy" ["偿命" "唱名"])
("ihnm" ["常年" "长年"])
("ihny" ["长宁"])
("ihpj" ["唱盘"])
("ihpk" ["长袍" "长跑"])
("ihpm" ["长篇" "唱片"])
("ihpn" ["场频"])
("ihpu" ["菖蒲"])
("ihpy" ["昌平"])
("ihq'" "昌猖伥菖阊娼鲳")
("ihqd" ["场强" "长枪" "唱腔"])
("ihqi" ["长期"])
("ihqu" ["长驱"])
("ihqy" ["常青" "常情" "偿清"])
("ihr'" "畅唱倡鬯怅")
("ihrf" ["常人" "常任"])
("ihrj" ["怅然"])
("ihsi" ["长丝"])
("ihso" ["场所"])
("ihtc" ["长条"])
("ihtj" ["长叹" "畅谈"])
("ihtl" ["常态"])
("ihts" ["畅通"])
("ihtu" ["长途"])
("ihua" ["长沙"])
("ihub" ["长寿"])
("ihue" ["常设"])
("ihug" ["昌盛" "长生"])
("ihuh" ["厂商"])
("ihui" ["尝试" "常识" "长诗" "长石"])
("ihuj" ["长衫"])
("ihup" ["长顺"])
("ihuu" ["常数"])
("ihvb" ["常州"])
("ihvg" ["长征"])
("ihvh" ["厂长"])
("ihvi" ["长治" "厂址"])
("ihvu" ["常住" "常驻" "厂主"])
("ihw'" "场尝常长偿肠裳倘苌徜嫦")
("ihwf" ["常温"])
("ihwu" ["常务"])
("ihwz" ["常委" "肠胃"])
("ihxc" ["畅销"])
("ihxi" ["唱戏"])
("ihxn" ["长信"])
("ihyb" ["常有" "畅游"])
("ihye" ["长夜"])
("ihyi" ["倡议"])
("ihyj" ["常言" "肠炎" "倡言"])
("ihyl" ["出乎意料"])
("ihyn" ["畅饮"])
("ihyr" ["场院" "长圆" "长远"])
("ihys" ["常用"])
("ihyu" ["长于"])
("ihzi" ["场子" "肠子" "厂子"])
("ii'" ["常常"])
("iibh" ["翅膀"])
("iibi" ["赤壁" "赤臂"])
("iibv" ["出差补助"])
("iicp" ["尺寸"])
("iicu" ["吃醋"])
("iid'" ["长长的"])
("iide" ["吃得"])
("iidk" ["迟到" "赤道"])
("iidl" ["痴呆"])
("iidp" ["迟钝"])
("iidu" ["尺度"])
("iie'" "耻齿侈尺褫豉")
("iifj" ["吃饭"])
("iigd" ["吃光"])
("iihr" ["迟缓"])
("iihs" ["赤红"])
("iiig" ["驰骋" "赤橙" "赤诚"])
("iiii" ["吃吃" "迟迟"])
("iijc" ["赤脚"])
("iijg" ["出厂价格"])
("iijn" ["吃紧" "吃尽"])
("iijq" ["持久"])
("iijw" ["持家"])
("iijy" ["吃惊"])
("iiku" ["吃苦"])
("iikv" ["吃亏"])
("iild" ["吃粮"])
("iili" ["吃力" "斥力"])
("iilo" ["赤裸"])
("iilp" ["齿轮"])
("iilx" ["炽烈"])
("iimy" ["驰名"])
("iimz" ["赤眉"])
("iinl" ["吃奶"])
("iipn" ["赤贫"])
("iipy" ["持平"])
("iiq'" "吃痴哧嗤媸眵鸱蚩螭笞魑")
("iiqd" ["持枪"])
("iiqq" ["持球"])
("iir'" "赤翅斥炽傺叱啻彳饬敕瘛")
("iire" ["炽热"])
("iirr" ["吵吵嚷嚷"])
("iiru" ["耻辱"])
("iiss" ["赤松"])
("iitb" ["吃透"])
("iitc" ["齿条"])
("iith" ["池塘"])
("iitj" ["侈谈"])
("iiu'" ["长春市"])
("iiub" ["赤手"])
("iiuf" ["赤身"])
("iiuh" ["吃上"])
("iiui" ["吃食"])
("iiuv" ["吃水"])
("iivi" ["迟滞"])
("iivk" ["池沼"])
("iivs" ["吃重"])
("iiw'" "持匙池迟弛驰坻墀茌篪踟")
("iixd" ["吃香"])
("iixu" ["持续"])
("iiyb" ["持有"])
("iiyh" ["赤杨"])
("iiyi" ["迟疑"])
("iiyj" ["池盐" "迟延"])
("iiyn" ["齿音"])
("iiyu" ["池鱼"])
("iiyy" ["绰绰有余"])
("iize" ["斥责"])
("iizi" ["池子" "赤字"])
("iizk" ["迟早"])
("ij'" ["成绩"])
("ijb'" ["冲击波"])
("ijdb" ["颤抖"])
("ijdc" ["铲掉"])
("ijdg" ["超级大国"])
("ijdi" ["产地"])
("ijds" ["颤动"])
("ije'" "铲产阐冁谄蒇骣")
("ijer" ["产儿"])
("ijf'" ["沉降缝"])
("ijfa" ["阐发"])
("ijfu" ["搀扶" "产妇"])
("ijh'" ["超计划"])
("ijhb" ["产后"])
("ijib" ["车间成本"])
("ijid" ["产床"])
("ijij" ["潺潺"])
("ijiu" ["铲除" "产出"])
("ijj'" ["超阶级"])
("ijjf" ["车间经费"])
("ijke" ["产科"])
("ijl'" ["长距离"])
("ijld" ["产量"])
("ijlm" ["蝉联"])
("ijlr" ["产卵"])
("ijm'" ["陈炯明"])
("ijmf" ["禅门"])
("ijmm" ["缠绵"])
("ijmy" ["阐明"])
("ijpn" ["产品"])
("ijpo" ["产婆"])
("ijpy" ["铲平" "冲积平原"])
("ijqm" ["产前"])
("ijqr" ["产权"])
("ijr'" "颤忏羼")
("ijrk" ["缠绕"])
("ijsd" ["沉降速度"])
("ijsh" ["成吉思汗"])
("ijsv" ["长江三角洲"])
("ijsx" ["长江三峡"])
("ijtu" ["铲土"])
("iju'" ["初级社" "传教士"])
("ijug" ["产生"])
("ijui" ["禅师"])
("ijuu" ["阐述"])
("ijv'" ["持久战"])
("ijvd" ["产状"])
("ijvi" ["产值"])
("ijw'" ["蝉" "馋" "谗" "缠" "单" "廛" "潺" "澶" "孱" "婵" "禅" "镡" "蟾" "躔" "沉积物"])
("ijwu" ["产物"])
("ijxc" ["产销"])
("ijxq" ["初级线圈"])
("ijy'" ["常见于"])
("ijye" ["产业"])
("ijyj" ["谗言"])
("ijyn" ["颤音"])
("ijyu" ["赤脚医生"])
("ijzi" ["产仔"])
("ijzs" ["禅宗"])
("ijzu" ["缠足"])
("ik'" ["出口"])
("ikbf" ["抄本"])
("ikbk" ["抄报"])
("ikbl" ["朝拜"])
("ikbm" ["超编"])
("ikcl" ["炒菜"])
("ikdk" ["超导"])
("ikdl" ["朝代"])
("ikdr" ["超短"])
("ike'" "吵炒")
("ikee" ["超额"])
("ikfg" ["嘲讽"])
("ikgk" ["超高"])
("ikgo" ["超过"])
("ikgs" ["朝贡"])
("ikh'" ["创刊号"])
("ikij" ["超产"])
("ikik" ["吵吵"])
("ikiu" ["超出"])
("ikj'" ["穿孔机"])
("ikjg" ["猖狂进攻"])
("ikji" ["超级"])
("ikjm" ["朝见"])
("ikjw" ["抄家" "吵架"])
("ikjx" ["潮解"])
("iklq" ["潮流"])
("iklu" ["抄录"])
("ikmm" ["炒面"])
("iknk" ["吵闹"])
("iknl" ["吃苦耐劳"])
("ikns" ["嘲弄"])
("ikpc" ["钞票"])
("ikpi" ["巢脾"])
("ikq'" "超抄钞吵绰剿怊焯")
("ikqi" ["潮气"])
("ikqm" ["超前"])
("ikqy" ["炒青"])
("ikr'" "耖")
("ikre" ["嘲热"])
("ikrf" ["超人"])
("ikrh" ["吵嚷"])
("ikrj" ["超然"])
("ikss" ["抄送"])
("ikto" ["超脱"])
("ikty" ["朝廷"])
("ikug" ["超声" "朝圣"])
("ikui" ["潮湿"])
("ikuj" ["潮汕"])
("ikuk" ["炒勺"])
("ikuu" ["抄书"])
("ikuv" ["潮水"])
("ikvb" ["潮州"])
("ikve" ["朝着"])
("ikvg" ["朝政"])
("ikvi" ["超支"])
("ikvs" ["超重"])
("ikvx" ["出口转内销"])
("ikw'" "朝嘲潮巢晁")
("ikxc" ["嘲笑"])
("ikxd" ["朝向"])
("ikxi" ["抄袭" "潮汐"])
("ikxm" ["朝鲜"])
("ikxt" ["巢穴"])
("ikxx" ["抄写"])
("ikye" ["朝野"])
("ikyn" ["超音"])
("ikyr" ["超员"])
("ikyt" ["超越"])
("ikzb" ["抄走"])
("ikzl" ["超载"])
("ikzs" ["朝宗"])
("ikzv" ["吵嘴"])
("il'" ["处理"])
("ilbx" ["川流不息"])
("ilck" ["柴草"])
("ildc" ["拆掉"])
("ilf'" ["吃了饭"])
("ilhe" ["柴禾"])
("ilho" ["柴火"])
("ilhv" ["拆毁"])
("ilhy" ["产卵洄游"])
("ili'" ["产卵场"])
("ilir" ["拆穿"])
("iliu" ["拆除"])
("ilj'" ["处理机"])
("ilkl" ["拆开" "常绿阔叶林"])
("ill'" ["赤裸裸"])
("illh" ["豺狼"])
("ilmi" ["柴米"])
("ilp'" ["处理品"])
("ilpt" ["触类旁通"])
("ilq'" "差拆钗")
("ilqm" ["拆迁"])
("ilr'" "瘥虿")
("ilrf" ["差人"])
("ilsj" ["拆散"])
("iltl" ["拆台"])
("ilui" ["差使" "差事"])
("ilvd" ["拆装"])
("ilw'" "柴豺侪")
("ilxi" ["拆洗"])
("ilxm" ["拆线"])
("ilxx" ["拆卸"])
("ilyb" ["柴油"])
("ilyi" ["差役"])
("ilz'" ["出乱子"])
("imb'" ["出毛病"])
("imhc" ["出谋划策"])
("imjx" ["触目惊心"])
("imkl" ["愁眉苦脸"])
("iml'" ["出苗率"])
("imr'" ["长毛绒"])
("ims'" ["赤霉素"])
("imvv" ["臭名昭著"])
("inr'" ["成年人"])
("iohk" ["绰号"])
("ioir" ["戳穿"])
("iopo" ["戳破"])
("ioq'" "戳踔")
("ior'" "绰啜辍龊")
("iouh" ["戳伤"])
("ip'" ["产品"])
("ipbo" ["春播"])
("ipcl" ["蠢才"])
("ipcv" ["纯粹"])
("ipdu" ["纯度"])
("ipe'" "蠢")
("ipff" ["春分"])
("ipfg" ["春风"])
("ipgd" ["春光"])
("ipgg" ["春耕"])
("iphb" ["醇厚"])
("iphw" ["春花" "醇化" "淳化"])
("ipji" ["春季"])
("ipjm" ["纯碱"])
("ipjx" ["春节" "纯洁"])
("ipjy" ["纯净"])
("ipl'" ["成品率"])
("ipli" ["纯利"])
("iplj" ["春兰"])
("iplm" ["春联"])
("ipln" ["纯林"])
("iplv" ["纯律"])
("iplz" ["春雷"])
("ipml" ["春麦"])
("ippu" ["淳朴" "纯朴"])
("ipq'" "春椿蝽")
("ipqq" ["春秋"])
("ipsp" ["春笋"])
("iptm" ["春天"])
("ipuu" ["纯熟"])
("ipvf" ["纯真"])
("ipvg" ["纯正"])
("ipvs" ["纯种"])
("ipw'" "醇唇淳纯莼鹑")
("ipxp" ["春汛"])
("ipxu" ["长篇小说"])
("ipxw" ["春夏"])
("ipyb" ["春游"])
("ipyi" ["春意"])
("iqby" ["出其不意"])
("iqgc" ["长期共存"])
("iqiw" ["成千成万"])
("iql'" ["充其量" "出勤率"])
("iquw" ["成千上万"])
("iqvr" ["长驱直入"])
("ir'" ["承认"])
("irb'" ["传染病"])
("irbh" ["川帮"])
("irbi" ["穿鼻"])
("irbm" ["传遍"])
("irbo" ["传播" "船舶"])
("irbu" ["传布"])
("irch" ["船舱"])
("irci" ["穿刺"])
("ircl" ["川菜"])
("ircw" ["承认错误"])
("irda" ["传达"])
("irde" ["穿得"])
("irdi" ["传递"])
("irdj" ["传单"])
("irdk" ["传导" "传到"])
("irdl" ["穿戴"])
("irds" ["传动"])
("irdt" ["趁热打铁"])
("irdv" ["船队"])
("ire'" "喘舛")
("irfu" ["船夫"])
("irgo" ["穿过"])
("irgs" ["船工"])
("irgz" ["传给"])
("irhr" ["传唤"])
("irhu" ["传呼"])
("iria" ["穿插"])
("irih" ["船厂"])
("irjc" ["传教"])
("irjd" ["川江"])
("irjp" ["川军"])
("irke" ["船壳"])
("irks" ["穿孔"])
("irll" ["传来"])
("irlm" ["串联"])
("irly" ["传令"])
("irmf" ["串门"])
("irnz" ["船内"])
("irpc" ["传票" "船票"])
("irq'" "川穿巛氚")
("irqi" ["传奇" "喘气"])
("irqq" ["传球"])
("irr'" "串钏")
("irre" ["传热"])
("irrj" ["传染"])
("irso" ["穿梭"])
("irss" ["传送" "传诵"])
("irtb" ["穿透" "船头"])
("irti" ["船体"])
("irtl" ["船台"])
("irts" ["传统" "串通"])
("irub" ["传授" "船首"])
("iruf" ["传神"])
("iruh" ["穿上"])
("irui" ["传世"])
("iruj" ["传入神经"])
("iruo" ["传说"])
("iruu" ["传输"])
("irva" ["船闸"])
("irve" ["穿着"])
("irvf" ["传真"])
("irvh" ["船长"])
("irvi" ["传质" "船只"])
("irvu" ["船主"])
("irw'" "椽传船遄舡")
("irwf" ["传闻"])
("irwl" ["船外"])
("irwu" ["船坞"])
("irwz" ["船位"])
("irxi" ["传习" "喘息"])
("irxm" ["船舷"])
("irxp" ["传讯"])
("irxu" ["传热系数"])
("iryi" ["穿衣"])
("iryj" ["传言"])
("iryr" ["船员"])
("iryt" ["穿越" "传阅"])
("isai" ["宠爱"])
("isbj" ["重版"])
("isbl" ["崇拜"])
("isbo" ["重播"])
("isci" ["冲刺"])
("isd'" ["传送带"])
("isdh" ["充当"])
("isdj" ["冲淡"])
("isdk" ["冲到"])
("isdm" ["充电"])
("isds" ["冲动"])
("isdx" ["重叠"])
("ise'" "宠")
("iser" ["宠儿"])
("isff" ["充分"])
("isfg" ["冲锋" "重逢"])
("isfj" ["重返"])
("isfu" ["重复"])
("isgb" ["冲沟"])
("isgk" ["崇高"])
("ishe" ["重合"])
("ishl" ["虫害"])
("isho" ["重活"])
("ishp" ["重婚"])
("isia" ["冲茶"])
("isig" ["冲程"])
("isis" ["冲冲" "重重"])
("isiu" ["冲出"])
("isjc" ["虫胶"])
("isjd" ["重奖"])
("isji" ["充饥" "冲击" "冲积"])
("isjm" ["重建"])
("isjp" ["充军"])
("isjt" ["冲决"])
("isjy" ["崇敬" "憧憬"])
("iskl" ["冲开"])
("isli" ["冲力"])
("islr" ["虫卵"])
("isma" ["重码"])
("ismj" ["充满"])
("ismy" ["崇明"])
("ispo" ["冲破"])
("ispz" ["充沛"])
("isq'" ["充" "冲" "涌" "茺" "忡" "憧" "舂" "艟" "差速器" "抽穗期"])
("isqy" ["虫情" "重庆"])
("isr'" "冲铳")
("isrf" ["充任" "重人"])
("istm" ["充填" "冲天"])
("istu" ["冲突"])
("isuf" ["重申"])
("isug" ["冲绳"])
("isui" ["充实"])
("isuw" ["冲刷"])
("isvd" ["冲撞"])
("isvf" ["崇祯"])
("isvv" ["垂死挣扎"])
("isw'" "虫崇种重")
("iswf" ["重温"])
("iswu" ["宠物"])
("iswz" ["重围"])
("isxi" ["冲洗"])
("isxm" ["重现"])
("isxn" ["宠信" "重新"])
("isxq" ["重修"])
("isxt" ["充血"])
("isya" ["冲压"])
("isyh" ["重洋"])
("isyj" ["重演"])
("isyn" ["重音" "重印"])
("isyu" ["充裕"])
("isyy" ["畅所欲言"])
("iszi" ["虫子"])
("iszl" ["虫灾" "重载"])
("iszu" ["充足"])
("itdh" ["长途电话"])
("itdl" ["穿透电流"])
("itiw" ["彻头彻尾"])
("itjy" ["传统教育"])
("itk'" ["赤铁矿"])
("itl'" ["冲天炉"])
("itsq" ["垂头丧气"])
("itub" ["成套设备"])
("itww" ["出土文物"])
("iu'" ["初始"])
("iub'" ["超声波"])
("iuba" ["初八"])
("iubj" ["初版" "出版"])
("iubu" ["初步"])
("iuby" ["出兵"])
("iubz" ["储备"])
("iuch" ["储藏"])
("iuci" ["初次" "除此" "楚辞"])
("iuck" ["出操" "锄草" "除草"])
("iuco" ["出错"])
("iucp" ["储存"])
("iudc" ["除掉"])
("iudg" ["初等"])
("iudm" ["出典" "触电"])
("iuds" ["出动" "触动"])
("iue'" "楚础储处杵楮褚")
("iuer" ["初二"])
("iufa" ["出发" "除伐" "除法" "触发" "处罚"])
("iuff" ["处分"])
("iufh" ["出访" "厨房" "处方"])
("iufj" ["触犯"])
("iufz" ["除非"])
("iug'" ["出水管"])
("iugh" ["城市规划"])
("iugj" ["城市国家"])
("iugk" ["初稿"])
("iugo" ["出国"])
("iugs" ["出工"])
("iugv" ["出轨" "橱柜"])
("iuhh" ["出航"])
("iuhk" ["除号"])
("iuhl" ["出海" "除害"])
("iuho" ["出活"])
("iuhu" ["出乎"])
("iuid" ["橱窗"])
("iuie" ["出车"])
("iuif" ["除尘"])
("iuih" ["出场" "出厂"])
("iuij" ["出产"])
("iuik" ["出超"])
("iuil" ["出差"])
("iuiu" ["出处" "处处"])
("iuj'" ["抽水机"])
("iujc" ["触礁" "触角"])
("iujd" ["出江"])
("iuji" ["初级" "出击" "触及"])
("iujl" ["崇山峻岭"])
("iujt" ["触觉" "处决"])
("iuju" ["出局" "出具"])
("iujw" ["出家" "出嫁"])
("iujx" ["出界"])
("iujy" ["出境" "处境"])
("iukb" ["出口"])
("iuke" ["出科"])
("iukl" ["除开"])
("iukq" ["赤手空拳"])
("iul'" ["出生率"])
("iulc" ["除了"])
("iuld" ["储量"])
("iuli" ["出力" "矗立" "处理" "畜力"])
("iull" ["出来"])
("iulm" ["初恋"])
("iuls" ["出笼"])
("iulu" ["出路"])
("iuma" ["出马"])
("iumc" ["出苗"])
("iumf" ["出门"])
("iuml" ["出卖"])
("iumm" ["出面"])
("iumo" ["出没"])
("iumy" ["出名" "除名"])
("iumz" ["触媒"])
("iuna" ["出纳"])
("iunv" ["处女"])
("iupm" ["城市贫民"])
("iupn" ["出品"])
("iuq'" "初出樗")
("iuqi" ["初期" "出奇" "出气"])
("iuqn" ["出勤"])
("iuqt" ["出缺"])
("iuqu" ["出去" "除去"])
("iur'" ["矗" "搐" "触" "处" "畜" "亍" "怵" "憷" "绌" "黜" "纯收入"])
("iurf" ["出任"])
("iurh" ["出让"])
("iurs" ["出生入死"])
("iuru" ["出入"])
("iuse" ["出色"])
("iusi" ["处死"])
("iusj" ["初三"])
("iusl" ["出塞"])
("iuso" ["处所"])
("iusu" ["初速"])
("iutb" ["出头" "锄头"])
("iutk" ["出逃"])
("iutl" ["出台"])
("iutu" ["出土"])
("iutx" ["出铁"])
("iuty" ["出庭"])
("iuu'" ["长沙市"])
("iuub" ["出手" "出售" "触手"])
("iuuf" ["初审" "出身" "出神"])
("iuug" ["出声" "出生" "畜生"])
("iuui" ["初十" "初始" "出师" "出使" "出世" "厨师" "处事"])
("iuuj" ["出山"])
("iuuu" ["除数" "处暑"])
("iuvg" ["出征"])
("iuvh" ["处长"])
("iuvi" ["处置" "处治"])
("iuvs" ["初中" "出众"])
("iuw'" "橱厨躇锄雏滁除刍蜍蹰")
("iuwl" ["出外" "除外"])
("iuxc" ["初小"])
("iuxi" ["出息" "出席" "除夕"])
("iuxm" ["出险" "出现"])
("iuxp" ["出巡"])
("iuxt" ["初学" "出血"])
("iuxu" ["储蓄"])
("iuxy" ["雏形" "处刑"])
("iuy'" ["炊事员"])
("iuya" ["出芽"])
("iuyb" ["储油"])
("iuyh" ["出洋"])
("iuyi" ["初一"])
("iuyr" ["出院"])
("iuyu" ["出于" "处于"])
("iuzb" ["出走"])
("iuzi" ["出自" "厨子"])
("iuzl" ["处在"])
("iuzu" ["出租"])
("ivdc" ["垂钓"])
("ivdk" ["吹倒"])
("ivds" ["吹动"])
("ivfg" ["吹风"])
("ivfu" ["吹拂"])
("ivg'" ["插针管"])
("ivju" ["炊具"])
("ivlm" ["吹炼" "锤炼"])
("ivm'" ["垂直面"])
("ivmx" ["吹灭"])
("ivnq" ["吹牛"])
("ivpg" ["吹捧"])
("ivpx" ["垂直平分线"])
("ivq'" "吹炊")
("ivqg" ["重整旗鼓"])
("ivsi" ["垂死"])
("ivti" ["垂体"])
("ivui" ["炊事"])
("ivvi" ["垂直"])
("ivw'" ["捶" "锤" "垂" "椎" "陲" "棰" "槌" "称之为" "斥之为"])
("ivwz" ["垂危"])
("ivx'" ["垂直线"])
("ivxm" ["垂线"])
("ivxn" ["垂心"])
("ivxu" ["吹嘘"])
("ivyh" ["持之以恒"])
("ivyj" ["炊烟"])
("ivzb" ["吹奏"])
("ivzi" ["锤子"])
("ivzu" ["垂足"])
("iw'" ["成为"])
("iwd'" ["赤卫队"])
("iwh'" ["常委会"])
("iwi'" ["超外差"])
("iwib" ["称王称霸"])
("iwij" ["超外差式收音机"])
("iwj'" ["赤卫军"])
("iwq'" ["崇文区"])
("iwt'" ["成问题"])
("iwy'" ["乘务员"])
("ix'" ["出现"])
("ixb'" ["出血病"])
("ixd'" ["长辛店"])
("ixgn" ["抽象概念"])
("ixh'" ["盛宣怀"])
("ixht" ["产销合同"])
("ixiy" ["诚心诚意"])
("ixjl" ["处心积虑"])
("ixkv" ["程序控制"])
("ixld" ["抽象劳动"])
("ixm'" ["春小麦"])
("ixsw" ["抽象思维"])
("ixu'" ["纯小数"])
("ixuj" ["程序设计"])
("ixyg" ["场效应晶体管"])
("ixz'" ["朝鲜族"])
("iy'" ["处于"])
("iyce" ["揣测"])
("iyd'" ["常言道" "厂用电"])
("iydu" ["常用对数"])
("iye'" "揣")
("iygm" ["产业革命"])
("iygr" ["产业工人"])
("iyhj" ["产业后备军"])
("iyj'" ["插秧机" "柴油机" "程咬金" "除莠剂"])
("iyly" ["长远利益"])
("iymo" ["揣摩"])
("iyq'" ["揣" "搋" "朝阳区"])
("iyr'" ["揣" "啜" "嘬" "膪" "踹" "承运人"])
("iys'" ["超音速"])
("iysx" ["超音速飞行"])
("iyt'" ["常压塔"])
("iyy'" ["陈圆圆"])
("iyzb" ["产业资本"])
("iz'" ["称作"])
("izff" ["创作方法"])
("izqi" ["出租汽车"])
("izr'" ["超自然"])
("izu'" ["超再生"])
("izuj" ["创作实践"])
("izx'" ["创造性"])
("j" "及")
("jazm" ["骄傲自满"])
("jb'" ["基本"])
("jbbw" ["津巴布韦"])
("jbd'" ["见不得"])
("jbf'" ["加班费"])
("jbfy" ["聚变反应"])
("jbg'" ["基本功"])
("jbh'" ["金不换"])
("jbj'" ["搅拌机"])
("jbjs" ["军备竞赛"])
("jbju" ["基本建设"])
("jbjz" ["基本建设投资"])
("jbll" ["进步力量"])
("jblx" ["基本路线"])
("jblz" ["基本粒子"])
("jbm'" ["基本苗"])
("jbmd" ["基本矛盾"])
("jbn'" ["几百年"])
("jbp'" ["聚宝盆"])
("jbq'" ["检波器" "搅拌器" "经不起" "警备区"])
("jbr'" ["接班人"])
("jbru" ["进步人士"])
("jbs'" ["锦标赛"])
("jbt'" ["吉布提"])
("jbu'" ["基本上"])
("jbui" ["基本生产"])
("jbuj" ["举不胜举"])
("jbuy" ["进步事业"])
("jbv'" ["禁不住"])
("jbx'" ["聚丙烯"])
("jby'" ["贾宝玉"])
("jbyx" ["聚苯乙烯"])
("jbyz" ["基本原则"])
("jbzu" ["饥不择食"])
("jc'" ["几次"])
("jcan" ["教案"])
("jcao" ["骄傲"])
("jcba" ["局促不安"])
("jcbf" ["脚本" "教本"])
("jcbi" ["焦比"])
("jcbj" ["交班" "搅拌" "脚板"])
("jcbm" ["交变" "狡辩"])
("jcbu" ["胶布" "脚步"])
("jccl" ["教材"])
("jcco" ["交错"])
("jcda" ["较大"])
("jcdi" ["较低"])
("jcdk" ["铰刀" "绞刀" "教导"])
("jcdl" ["胶带" "交代" "交待"])
("jcdm" ["焦点" "交点"])
("jcdo" ["较多"])
("jcdr" ["较短"])
("jcds" ["胶东" "搅动"])
("jcdu" ["角度"])
("jcdv" ["校对"])
("jce'" "搅铰矫侥脚狡角饺缴绞剿佼挢徼湫敫皎")
("jcer" ["焦耳"])
("jcfg" ["交锋"])
("jcfu" ["交付" "缴付" "轿夫"])
("jcfz" ["剿匪"])
("jcgf" ["脚跟"])
("jcgh" ["角钢"])
("jcgk" ["较高"])
("jcgo" ["角果"])
("jcgr" ["浇灌" "娇惯" "教官"])
("jcgs" ["交工"])
("jcgz" ["交给"])
("jchd" ["焦黄" "教皇"])
("jche" ["胶合"])
("jchg" ["骄横"])
("jchj" ["叫喊"])
("jchk" ["较好" "叫好"])
("jcho" ["交货" "缴获"])
("jchr" ["交还" "交换" "叫唤"])
("jchu" ["交互"])
("jchv" ["教会"])
("jchw" ["焦化" "浇花" "狡猾" "教化"])
("jcia" ["交叉" "较差"])
("jcie" ["绞车" "轿车"])
("jcig" ["交城" "教程"])
("jcih" ["较长"])
("jcii" ["角尺"])
("jciu" ["交出"])
("jcjc" ["交角"])
("jcji" ["焦急" "交集" "交际"])
("jcjm" ["矫健" "脚尖"])
("jcjr" ["胶卷"])
("jcjt" ["叫绝"])
("jcju" ["焦距" "教具"])
("jcjw" ["交加" "绞架"])
("jcjx" ["胶结" "交接" "交界" "铰接" "酵解"])
("jckb" ["浇口"])
("jckj" ["校勘"])
("jckr" ["缴款"])
("jcku" ["叫苦"])
("jcky" ["较快"])
("jclc" ["脚镣"])
("jcld" ["较量"])
("jcli" ["胶粒"])
("jcll" ["叫来"])
("jclm" ["铰链" "教练"])
("jclo" ["角落"])
("jclq" ["交流"])
("jclr" ["搅乱"])
("jcls" ["蛟龙"])
("jclv" ["焦虑"])
("jcma" ["叫骂"])
("jcmf" ["叫门"])
("jcmj" ["较慢"])
("jcml" ["叫卖"])
("jcmn" ["教民"])
("jcmo" ["角膜"])
("jcmu" ["胶木" "酵母"])
("jcmx" ["剿灭"])
("jcmz" ["焦煤"])
("jcna" ["交纳" "缴纳"])
("jcnf" ["娇嫩"])
("jcni" ["胶泥"])
("jcpi" ["胶皮"])
("jcpj" ["绞盘"])
("jcpm" ["胶片"])
("jcpz" ["交配"])
("jcq'" ["蕉" "椒" "礁" "焦" "胶" "交" "郊" "浇" "骄" "娇" "教" "僬" "艽" "茭" "姣" "鹪" "蛟" "跤" "鲛" "寄存器"])
("jcqd" ["缴枪" "较强"])
("jcqi" ["娇妻" "娇气"])
("jcqm" ["较浅"])
("jcqq" ["角球"])
("jcqu" ["郊区"])
("jcqy" ["交情" "较轻"])
("jcr'" "嚼教酵轿较叫窖觉校噍峤徼醮")
("jcrb" ["饺肉"])
("jcrh" ["叫嚷"])
("jcrk" ["搅扰"])
("jcro" ["较弱"])
("jcrs" ["交融"])
("jcru" ["胶乳"])
("jcse" ["角色"])
("jcso" ["绞索" "教唆"])
("jcsu" ["酵素"])
("jctc" ["教条"])
("jcth" ["教堂"])
("jcti" ["胶体" "交替"])
("jctj" ["焦炭" "交谈"])
("jcts" ["交通"])
("jctu" ["教徒"])
("jcua" ["绞杀" "叫啥"])
("jcub" ["交售" "教授"])
("jcue" ["交涉"])
("jcuf" ["较深"])
("jcui" ["礁石" "教师" "教士" "教室"])
("jcuk" ["较少"])
("jcuu" ["教书"])
("jcuv" ["胶水" "浇水"])
("jcva" ["狡诈"])
("jcvg" ["矫正" "校正"])
("jcvh" ["脚掌"])
("jcvi" ["交织" "交趾" "矫直" "脚趾" "角质"])
("jcvj" ["交战"])
("jcvo" ["焦灼" "胶着"])
("jcvs" ["较重"])
("jcvu" ["浇铸" "浇筑" "脚注" "教主"])
("jcw'" "嚼矫峤")
("jcwh" ["交往"])
("jcwl" ["郊外"])
("jcwu" ["教务"])
("jcwz" ["交尾" "较为"])
("jcxc" ["叫嚣"])
("jcxd" ["交响"])
("jcxi" ["教习"])
("jcxp" ["教训"])
("jcxt" ["教学"])
("jcxw" ["脚下"])
("jcxx" ["胶鞋" "缴械" "缴卸"])
("jcxy" ["矫形" "侥幸" "绞刑"])
("jcy'" ["仅次于"])
("jcyb" ["焦油" "郊游"])
("jcyh" ["教养"])
("jcyi" ["交易" "交谊" "教义"])
("jcyn" ["脚印"])
("jcyr" ["教员"])
("jcyu" ["教育"])
("jczi" ["饺子" "轿子"])
("jczo" ["焦作" "叫做"])
("jd'" ["季度"])
("jdan" ["江岸"])
("jdbf" ["绝大部分"])
("jdbi" ["将比"])
("jdbu" ["将不"])
("jdby" ["坚定不移"])
("jdbz" ["江北"])
("jdcl" ["酱菜"])
("jdcs" ["将从"])
("jdd'" ["近地点"])
("jddb" ["豇豆"])
("jddi" ["降低"])
("jddk" ["讲到" "降到"])
("jdds" ["江东"])
("jddu" ["江都" "绝大多数"])
("jddv" ["将对"])
("jde'" "蒋桨奖讲耩")
("jdf'" ["焦达峰"])
("jdfa" ["奖罚" "讲法"])
("jdgk" ["讲稿"])
("jdgn" ["绝对观念"])
("jdgo" ["浆果" "讲过"])
("jdgr" ["将官"])
("jdgy" ["静电感应"])
("jdgz" ["将给"])
("jdh'" ["简单化" "绝对化" "鉴定会"])
("jdhe" ["江河" "讲和"])
("jdhj" ["江汉"])
("jdhk" ["降号"])
("jdhu" ["浆糊" "江湖"])
("jdhv" ["将会"])
("jdhw" ["僵化" "江华" "讲话"])
("jdhz" ["将黑"])
("jdi'" ["集大成" "剪刀差"])
("jdig" ["奖惩"])
("jdih" ["疆场"])
("jdii" ["僵持"])
("jdiu" ["介电常数"])
("jdj'" ["基督教" "集电极"])
("jdjd" ["讲讲"])
("jdji" ["降级"])
("jdjn" ["将近" "奖金"])
("jdjp" ["将军"])
("jdjq" ["将就" "讲究"])
("jdju" ["僵局"])
("jdjw" ["蒋家" "讲价" "降价"])
("jdjx" ["简单机械" "疆界" "讲解" "降解"])
("jdke" ["讲课"])
("jdl'" ["讲道理" "静电力" "决定论"])
("jdlc" ["浆料" "讲了"])
("jdld" ["简单劳动" "绝对零度"])
("jdli" ["奖励" "讲理"])
("jdll" ["将来"])
("jdln" ["降临"])
("jdlo" ["降落"])
("jdly" ["既得利益" "将领" "江陵"])
("jdmd" ["加德满都"])
("jdmi" ["江米"])
("jdmo" ["浆膜"])
("jdmy" ["讲明"])
("jdng" ["将能"])
("jdnj" ["江南"])
("jdny" ["江宁"])
("jdpl" ["奖牌"])
("jdpn" ["奖品"])
("jdpo" ["浆粕"])
("jdpy" ["讲评"])
("jdq'" ["僵" "姜" "将" "浆" "江" "疆" "茳" "缰" "礓" "豇" "继电器"])
("jdqc" ["就地取材"])
("jdqq" ["讲求"])
("jdr'" "虹将浆匠酱降强洚绛犟糨")
("jdrf" ["匠人"])
("jdsi" ["僵死"])
("jdsu" ["江苏"])
("jdth" ["姜汤" "讲堂"])
("jdtj" ["讲坛"])
("jdtl" ["讲台"])
("jdts" ["将同"])
("jdtu" ["疆土"])
("jdu'" ["节度使" "绝对数"])
("jdua" ["浆纱"])
("jdub" ["奖售" "讲授"])
("jdud" ["绝对湿度"])
("jdug" ["降生" "缰绳" "见多识广"])
("jduh" ["江上" "奖赏"])
("jdui" ["简单生产" "僵尸" "将使" "将士" "将是" "讲师" "讲史"])
("jduj" ["江山"])
("jduu" ["讲述"])
("jduv" ["降水"])
("jduy" ["将帅"])
("jdv'" ["景德镇" "绝对值"])
("jdvb" ["江州"])
("jdvd" ["奖状"])
("jdvh" ["奖章"])
("jdvz" ["经典著作"])
("jdwb" ["绝对温标"])
("jdwd" ["绝对温度"])
("jdwf" ["降温"])
("jdwi" ["绝对误差"])
("jdwu" ["讲武"])
("jdx'" ["机动性" "决定性"])
("jdxc" ["将校"])
("jdxi" ["江西" "讲席" "讲习"])
("jdxn" ["江心" "匠心"])
("jdxs" ["精打细算"])
("jdxt" ["讲学"])
("jdxw" ["江夏" "降下"])
("jdxz" ["简单协作"])
("jdy'" ["教导员"])
("jdya" ["降压"])
("jdyb" ["酱油"])
("jdye" ["浆液"])
("jdyi" ["讲义"])
("jdyj" ["讲演"])
("jdyk" ["将要"])
("jdyn" ["江阴"])
("jdyu" ["疆域" "降雨"])
("jdyy" ["僵硬"])
("jdz'" ["价电子"])
("jdzb" ["借贷资本"])
("jdzj" ["经典作家"])
("jdzl" ["将在"])
("jdzo" ["讲座"])
("jdzv" ["结缔组织"])
("je'" ["金额"])
("jegd" ["加尔各答"])
("jehf" ["基尔霍夫"])
("jejv" ["久而久之"])
("jels" ["接二连三"])
("jes'" ["己二酸"])
("jf'" ["甲方"])
("jfdl" ["积分电路"])
("jfj'" ["解放军"])
("jfjb" ["解放军报"])
("jfl'" ["惊飞了"])
("jfq'" ["解放前" "解放区" "军分区"])
("jfrb" ["解放日报"])
("jfsx" ["解放思想"])
("jft'" ["激发态"])
("jfu'" ["假分数"])
("jfvv" ["解放战争"])
("jfyd" ["解放运动"])
("jg'" ["经过"])
("jgb'" ["机关报"])
("jgck" ["仅供参考"])
("jgdg" ["建国大纲"])
("jgdh" ["加工订货"])
("jgeq" ["揭竿而起"])
("jgg'" ["结构钢"])
("jggg" ["机构改革"])
("jggy" ["加工工业"])
("jgkw" ["机关刊物"])
("jgl'" ["进给量"])
("jglx" ["居高临下"])
("jgny" ["坚固耐用"])
("jgq'" ["机关枪" "激光器"])
("jgu'" ["结构式" "金刚石" "井冈山"])
("jgux" ["举国上下"])
("jgv'" ["结果枝" "紧箍咒"])
("jgvy" ["军国主义"])
("jgw'" ["甲骨文"])
("jgxz" ["精耕细作"])
("jgy'" ["几个月"])
("jgyh" ["加工硬化"])
("jgyl" ["加工余量"])
("jgz'" ["金龟子"])
("jh'" ["计划"])
("jhb'" ["胶合板" "结核病"])
("jhf'" ["交会法"])
("jhfy" ["聚合反应"])
("jhh'" ["经互会"])
("jhi'" ["救护车"])
("jhjj" ["计划经济"])
("jhjp" ["饥寒交迫"])
("jhjv" ["交换价值"])
("jhl'" ["结合律" "进化论"])
("jhm'" ["接合面"])
("jhn'" ["结合能"])
("jht'" ["几何体"])
("jhtb" ["襟怀坦白"])
("jhtl" ["京汉铁路"])
("jhtx" ["几何图形"])
("jhu'" ["结合水"])
("jhuc" ["惊惶失措"])
("jhuj" ["结合实际"])
("jhuy" ["计划生育"])
("jhvv" ["机会主义者"])
("jhvy" ["机会主义"])
("jhw'" ["聚合物"])
("jhx'" ["几何学" "计划性"])
("ji'" ["建成"])
("jiag" ["激昂"])
("jian" ["积案" "吉安"])
("jibf" ["基本"])
("jibi" ["击毙" "积弊"])
("jibj" ["极板"])
("jibl" ["击败" "几百"])
("jibm" ["激变" "急变" "即便"])
("jibo" ["激波" "瘠薄"])
("jibu" ["缉捕" "既不"])
("jibx" ["级别" "坚持不懈"])
("jiby" ["积冰" "疾病"])
("jibz" ["几倍" "脊背"])
("jice" ["计策"])
("jicg" ["基层"])
("jich" ["机舱"])
("jici" ["激磁" "几次"])
("jicl" ["集材"])
("jicp" ["积存" "寄存"])
("jicu" ["急促"])
("jida" ["极大"])
("jidb" ["箕斗"])
("jidc" ["基调"])
("jide" ["急的" "记得"])
("jidh" ["激荡"])
("jidi" ["基底" "基地" "迹地" "极地" "及第"])
("jidj" ["鸡蛋"])
("jidl" ["集成电路" "几代" "亟待"])
("jidm" ["基点" "机电" "极点" "急电" "几点" "祭奠"])
("jidr" ["极端"])
("jids" ["机动" "激动"])
("jidu" ["基督" "极度" "嫉妒" "几度" "季度"])
("jidv" ["挤兑"])
("jidy" ["既定"])
("jidz" ["级差地租"])
("jie'" "革给挤几脊己济纪掎戟虮麂")
("jiee" ["饥饿"])
("jier" ["基尔" "吉尔" "既而" "继而"])
("jif'" ["接触法"])
("jifa" ["激发" "技法"])
("jiff" ["积分" "激愤" "几分" "计分" "记分"])
("jifg" ["讥讽" "疾风" "季风"])
("jifh" ["机房"])
("jifu" ["基辅" "继父"])
("jifz" ["基肥" "积肥"])
("jigb" ["机构"])
("jigd" ["激光"])
("jige" ["及格" "几个"])
("jigg" ["机耕"])
("jigj" ["基干"])
("jigr" ["机关" "籍贯"])
("jigs" ["机工" "技工" "记工"])
("jihd" ["饥荒"])
("jihe" ["集合" "几何"])
("jihj" ["饥寒"])
("jihk" ["记号"])
("jiho" ["激活" "即或"])
("jihu" ["疾呼" "几乎"])
("jihv" ["击毁" "机会" "集会" "寄回" "忌讳"])
("jihw" ["激化" "极化" "计划"])
("jiia" ["稽查" "级差"])
("jiib" ["计酬"])
("jiid" ["机床"])
("jiie" ["机车"])
("jiif" ["击沉" "集尘"])
("jiig" ["集成" "继承"])
("jiih" ["机场"])
("jiii" ["疾驰"])
("jiir" ["击穿"])
("jiiu" ["基础"])
("jijc" ["计较"])
("jijd" ["即将"])
("jiji" ["基极" "积极" "几几" "唧唧"])
("jijm" ["击键" "击剑" "基建" "机件" "急件" "计件"])
("jijn" ["基金" "激进" "急进"])
("jijq" ["急救" "祭酒"])
("jiju" ["机具" "积聚" "集聚" "急剧" "急遽"])
("jijx" ["集结" "季节"])
("jijy" ["机井" "机警" "即景" "寂静"])
("jik'" ["基础课" "进出口"])
("jike" ["即可" "即刻" "既可"])
("jikg" ["基坑"])
("jikj" ["季刊"])
("jiku" ["疾苦"])
("jikv" ["击溃"])
("jikx" ["基础科学"])
("jilc" ["极了"])
("jild" ["脊梁" "伎俩" "剂量" "计量"])
("jili" ["激励" "吉利" "极力"])
("jill" ["基础理论"])
("jiln" ["吉林"])
("jilo" ["击落"])
("jilp" ["棘轮"])
("jilq" ["激流" "急流"])
("jilu" ["辑录" "记录" "纪录"])
("jilv" ["几率" "纪律"])
("jilx" ["激烈"])
("jily" ["机灵" "即令"])
("jilz" ["积累"])
("jimb" ["计谋"])
("jimh" ["急忙"])
("jimi" ["机密"])
("jimj" ["挤满"])
("jimk" ["鸡毛"])
("jimn" ["机敏" "饥民"])
("jimo" ["寂寞"])
("jimu" ["积木" "极目" "继母"])
("jimy" ["记名"])
("jina" ["缉拿"])
("jing" ["机能" "技能" "既能"])
("jinj" ["济南"])
("jinl" ["挤奶"])
("jinm" ["几年" "记念" "纪年" "纪念"])
("jinu" ["激怒"])
("jinv" ["妓女"])
("jiny" ["济宁"])
("jipi" ["鸡皮"])
("jipm" ["几篇"])
("jipn" ["济贫"])
("jipo" ["击破" "急迫"])
("jipu" ["吉普" "记谱"])
("jiq'" ["击" "圾" "基" "机" "畸" "稽" "积" "箕" "肌" "饥" "迹" "激" "讥" "鸡" "姬" "绩" "缉" "几" "期" "其" "奇" "丌" "乩" "剞" "墼" "芨" "叽" "咭" "唧" "屐" "畿" "玑" "赍" "犄" "齑" "矶" "羁" "嵇" "笄" "跻" "继承权" "接触器"])
("jiqc" ["技巧"])
("jiqd" ["机枪" "极强"])
("jiqi" ["机器" "激起" "极其" "及其"])
("jiqm" ["几千"])
("jiqp" ["集群"])
("jiqq" ["击球"])
("jiqr" ["集权"])
("jiqu" ["汲取" "记取"])
("jiqx" ["急切"])
("jiqy" ["激情" "吉庆"])
("jir'" ["蓟" "技" "冀" "季" "伎" "祭" "剂" "悸" "济" "寄" "寂" "计" "记" "既" "忌" "际" "妓" "继" "纪" "齐" "系" "偈" "芰" "荠" "哜" "洎" "骥" "觊" "稷" "暨" "跽" "霁" "鲚" "鲫" "髻" "继承人"])
("jirb" ["肌肉" "鸡肉"])
("jirf" ["己任" "继任"])
("jiri" ["即日"])
("jirj" ["既然"])
("jise" ["基色"])
("jisi" ["祭祀"])
("jiso" ["几所" "脊索"])
("jisr" ["计算"])
("jisu" ["激素" "急速"])
("jisv" ["脊髓"])
("jita" ["吉他"])
("jitc" ["几条"])
("jiti" ["机体" "肌体" "集体"])
("jitl" ["基态"])
("jitm" ["几天" "祭天"])
("jito" ["寄托"])
("jitr" ["基团" "集团"])
("jitv" ["击退"])
("jiub" ["棘手"])
("jiue" ["鸡舍"])
("jiuf" ["机身"])
("jiug" ["极盛" "寄生"])
("jiuh" ["击伤"])
("jiui" ["基石" "集市" "及时" "急事" "即时" "即使" "即是" "几十" "几时" "技师" "计时" "记时" "记事" "既使" "既是" "纪实"])
("jiuj" ["积善"])
("jiuk" ["极少"])
("jiuu" ["基数" "级数" "技术" "计数" "记述" "既成事实"])
("jiuv" ["击水" "积水" "集水"])
("jivb" ["极洲"])
("jivd" ["集装"])
("jive" ["记者"])
("jivf" ["集镇" "急诊"])
("jivh" ["记帐"])
("jivi" ["基质" "机制" "机智" "极值" "及至"])
("jivj" ["激战"])
("jivp" ["基准"])
("jivs" ["击中" "集中" "几种"])
("jivu" ["集注" "脊柱" "寄主" "记住"])
("jivv" ["脊椎"])
("jivw" ["棘爪"])
("jiw'" "革吉极棘辑籍集及急疾汲即嫉级脊藉亟佶诘蒺蕺岌嵴楫殛戢瘠笈")
("jiwf" ["积温"])
("jiwj" ["几万"])
("jiwu" ["继武"])
("jiwz" ["极为" "即位" "几微" "纪委"])
("jixc" ["讥笑" "极小" "技校"])
("jixd" ["迹象" "吉祥" "几项"])
("jixi" ["积习" "鸡西" "即席"])
("jixm" ["基线" "极限" "集贤"])
("jixn" ["寄信"])
("jixp" ["集训"])
("jixq" ["机绣"])
("jixt" ["积雪"])
("jixu" ["积蓄" "急需" "几许" "继续"])
("jixw" ["稷下"])
("jixx" ["机械"])
("jixy" ["机型" "畸形" "极性" "急性" "即兴" "记性"])
("jiya" ["积压" "挤压" "羁押"])
("jiyb" ["机油" "极右" "计有"])
("jiyi" ["机翼" "极移" "技艺" "计议" "记忆"])
("jiyj" ["基岩"])
("jiyk" ["机要" "纪要"])
("jiyl" ["接触应力"])
("jiyn" ["基因" "基音"])
("jiyp" ["积云"])
("jiyr" ["妓院" "纪元"])
("jiys" ["急用"])
("jiyt" ["激越" "集约"])
("jiyu" ["基于" "急于" "寄予" "寄寓"])
("jizg" ["激增"])
("jizi" ["机子" "鸡子" "集资" "集子"])
("jizk" ["及早" "急躁"])
("jizl" ["记载"])
("jizo" ["机座" "极左"])
("jizu" ["机组"])
("jj'" ["简介"])
("jjb'" ["九九表"])
("jjbb" ["结结巴巴"])
("jjbv" ["阶级本质"])
("jjdr" ["极间电容"])
("jjdv" ["阶级斗争"])
("jjfh" ["阶级分化"])
("jjfi" ["经济范畴"])
("jjfx" ["阶级分析"])
("jjfy" ["加聚反应"])
("jjfz" ["积极分子"])
("jjgd" ["阶级观点"])
("jjgg" ["经济杠杆"])
("jjgl" ["经济管理"])
("jjgz" ["计件工资"])
("jjh'" ["基金会"])
("jjhh" ["家家户户"])
("jjhs" ["经济核算"])
("jjhu" ["聚精会神"])
("jji'" ["军机处"])
("jjif" ["经济成分"])
("jjj'" ["歼击机"])
("jjji" ["经济基础"])
("jjjj" ["将计就计"])
("jjjw" ["阶级觉悟"])
("jjjz" ["戒骄戒躁"])
("jjkh" ["经济恐慌"])
("jjli" ["阶级立场"])
("jjlx" ["阶级路线"])
("jjmd" ["阶级矛盾"])
("jjnl" ["近几年来"])
("jjq'" ["结晶器"])
("jjql" ["经济侵略" "竭尽全力"])
("jjr'" ["节假日"])
("jjsd" ["角加速度"])
("jjt'" ["结晶体"])
("jjtg" ["经济体制改革"])
("jjtv" ["经济体制"])
("jju'" ["尖晶石" "碱金属" "蒋介石" "结晶水" "旧金山"])
("jjuh" ["阶级社会"])
("jjvb" ["精简整编"])
("jjvd" ["经济制度"])
("jjvv" ["叽叽喳喳"])
("jjvy" ["经济主义"])
("jjwj" ["经济危机"])
("jjwt" ["解决问题"])
("jjx'" ["积极性" "季节性" "阶级性" "经济学"])
("jjxj" ["经济学家"])
("jjxy" ["经济效益"])
("jjya" ["阶级友爱"])
("jjys" ["积极因素"])
("jjyu" ["阶级意识"])
("jjyw" ["津津有味" "经济业务"])
("jjyy" ["兢兢业业"])
("jjzj" ["级进杂交"])
("jjzw" ["经济作物"])
("jk'" ["进口"])
("jkfd" ["艰苦奋斗"])
("jkn'" ["尽可能"])
("jksk" ["捷克斯洛伐克"])
("jku'" ["教科书"])
("jkwv" ["惊恐万状"])
("jky'" ["就可以"])
("jl'" ["建立"])
("jlb'" ["接力棒" "俱乐部"])
("jlbh" ["加勒比海"])
("jld'" ["交流电"])
("jlf'" ["基洛夫" "节流阀"])
("jlfy" ["加利福尼亚"])
("jlif" ["纪律处分"])
("jlj'" ["教练机"])
("jljj" ["积累基金"])
("jljs" ["加拉加斯"])
("jll'" ["伽利略"])
("jlmq" ["焦炉煤气"])
("jln'" ["加里宁"])
("jlp'" ["吉隆坡"])
("jlru" ["加力燃烧室"])
("jls'" ["降落伞"])
("jlt'" ["精馏塔"])
("jlu'" ["吉林省"])
("jlwm" ["价廉物美"])
("jlx'" ["纪律性" "静力学"])
("jlyl" ["聚氯乙烯塑料"])
("jlyx" ["聚氯乙烯"])
("jmai" ["兼爱"])
("jman" ["建安"])
("jmao" ["煎熬"])
("jmbh" ["肩膀"])
("jmbk" ["简报"])
("jmbm" ["简编" "简便" "渐变"])
("jmbo" ["检波"])
("jmbu" ["健步"])
("jmbx" ["鉴别"])
("jmby" ["尖兵" "煎饼" "兼并"])
("jmbz" ["兼备"])
("jmce" ["监测" "检测"])
("jmcg" ["茧层"])
("jmci" ["渐次"])
("jmck" ["键槽"])
("jmcl" ["剪裁" "建材" "静摩擦力"])
("jmco" ["检错"])
("jmd'" ["精密度" "居民点"])
("jmdc" ["剪掉"])
("jmde" ["见得"])
("jmdh" ["建党"])
("jmdi" ["歼敌" "碱地" "减低" "见地"])
("jmdj" ["简单"])
("jmdk" ["尖刀" "剪刀" "见到"])
("jmdl" ["肩带"])
("jmdm" ["检点"])
("jmdr" ["尖端" "间断" "简短"])
("jmdu" ["监督" "碱度" "建都"])
("jmdv" ["舰队"])
("jmdx" ["间谍"])
("jmdy" ["坚定" "尖顶" "检定" "鉴定"])
("jme'" "茧检柬碱硷拣捡简俭剪减谫囝蹇謇枧戬睑锏裥笕翦趼")
("jmer" ["健儿"])
("jmfa" ["减法"])
("jmfh" ["减方" "见方"])
("jmfu" ["肩负"])
("jmfz" ["减肥"])
("jmge" ["间隔"])
("jmgg" ["加盟共和国"])
("jmgj" ["鸡鸣狗叫"])
("jmgo" ["见过" "建国"])
("jmgr" ["监管" "兼管"])
("jmgs" ["监工"])
("jmgu" ["坚固" "兼顾"])
("jmgv" ["见鬼"])
("jmgy" ["见怪"])
("jmhe" ["建和"])
("jmhk" ["减号"])
("jmho" ["间或"])
("jmhr" ["减缓"])
("jmhu" ["监护"])
("jmhw" ["碱化" "简化"])
("jmia" ["监查" "监察" "检查" "检察"])
("jmif" ["奸臣"])
("jmig" ["兼程" "简称" "建成"])
("jmih" ["见长"])
("jmii" ["坚持"])
("jmij" ["减产"])
("jmiu" ["拣出"])
("jmj'" ["假面具" "剪毛机" "酵母菌"])
("jmjc" ["建交"])
("jmjd" ["健将"])
("jmji" ["简记"])
("jmjm" ["渐渐" "戋戋"])
("jmjn" ["监禁" "渐进"])
("jmjp" ["建军"])
("jmjt" ["坚决"])
("jmju" ["艰巨" "检举" "荐举"])
("jmjw" ["肩胛" "减价"])
("jmjx" ["间接" "简捷" "简洁" "简介" "见解"])
("jmke" ["尖刻"])
("jmkh" ["健康" "建康"])
("jmkl" ["剪开"])
("jmks" ["监控"])
("jmku" ["艰苦"])
("jmlb" ["简陋"])
("jmli" ["尖利" "简历" "剪力" "建立"])
("jmlk" ["监牢"])
("jmlm" ["简炼" "简练"])
("jmlo" ["溅落"])
("jmlt" ["简略"])
("jmlu" ["检录"])
("jmma" ["简码" "剑麻"])
("jmmc" ["间苗"])
("jmmj" ["减慢"])
("jmmk" ["剪毛"])
("jmmm" ["减免" "见面"])
("jmmo" ["缄默"])
("jmmx" ["歼灭"])
("jmmy" ["简明" "键名"])
("jmmz" ["健美"])
("jmnj" ["艰难"])
("jmny" ["建宁"])
("jmou" ["建瓯"])
("jmpj" ["键盘"])
("jmpn" ["鉴频"])
("jmpu" ["简朴" "简谱"])
("jmq'" "歼监坚尖笺间煎兼肩艰奸缄渐溅浅菅蒹搛湔缣戋犍鹣鲣鞯")
("jmqc" ["剑桥"])
("jmqd" ["坚强"])
("jmqi" ["捡起"])
("jmqr" ["健全"])
("jmqu" ["减去"])
("jmqx" ["剪切"])
("jmqy" ["减轻"])
("jmr'" "监间荐槛鉴践贱见键箭件健舰剑饯渐溅涧建僭谏楗牮毽腱锏踺")
("jmrf" ["坚韧" "兼任" "贱人"])
("jmro" ["减弱"])
("jmrs" ["兼容" "碱熔"])
("jmru" ["键入"])
("jmrv" ["尖锐"])
("jms'" ["佳木斯"])
("jmsi" ["茧丝"])
("jmso" ["检索"])
("jmsu" ["减速"])
("jmta" ["践踏"])
("jmtb" ["尖头" "肩头" "箭头"])
("jmti" ["简体"])
("jmtk" ["检讨"])
("jmtm" ["见天"])
("jmtu" ["简图"])
("jmtv" ["减退"])
("jmtx" ["剪贴"])
("jmty" ["舰艇"])
("jmub" ["坚守"])
("jmue" ["建设"])
("jmuf" ["健身"])
("jmuh" ["肩上" "奸商" "鉴赏"])
("jmui" ["监视" "坚实" "检视" "简史" "见识"])
("jmuk" ["减少"])
("jmuu" ["简述" "减数" "建树"])
("jmv'" ["歼灭战"])
("jmva" ["奸诈"])
("jmvb" ["建州"])
("jmvd" ["健壮"])
("jmvf" ["减震" "鉴真"])
("jmvg" ["见证"])
("jmvh" ["简章"])
("jmvi" ["笺纸" "兼职" "简直" "剪纸" "建制"])
("jmvo" ["见著"])
("jmvs" ["建中"])
("jmvu" ["建筑"])
("jmwf" ["见闻"])
("jmwj" ["剪完"])
("jmwl" ["见外"])
("jmwu" ["建武"])
("jmwz" ["键位"])
("jmx'" ["静脉血"])
("jmxc" ["减小" "见笑" "见效"])
("jmxi" ["间隙" "奸细" "见习"])
("jmxm" ["艰险"])
("jmxn" ["坚信" "艰辛"])
("jmxp" ["简讯"])
("jmxq" ["检修"])
("jmxs" ["奸雄"])
("jmxw" ["剪下" "剑侠"])
("jmxx" ["间歇" "简写"])
("jmxy" ["碱性" "减刑"])
("jmya" ["减压"])
("jmyb" ["兼有"])
("jmye" ["剑叶" "建业"])
("jmyi" ["坚毅" "检疫" "简易" "建议"])
("jmyj" ["检验"])
("jmyk" ["简要"])
("jmyn" ["奸淫"])
("jmyq" ["精密仪器"])
("jmyr" ["建元"])
("jmyt" ["检阅"])
("jmyu" ["监狱" "鉴于" "见于"])
("jmyy" ["坚硬" "兼营"])
("jmzi" ["尖子" "检字" "剪子"])
("jmzk" ["建造"])
("jmzl" ["健在"])
("jmzo" ["间作"])
("jn'" ["今年"])
("jnb'" ["纪念碑"])
("jnbc" ["锦标"])
("jnbi" ["金笔" "金币" "进逼" "禁闭"])
("jnbk" ["金宝"])
("jnbm" ["金边"])
("jnbu" ["进步"])
("jnby" ["进兵"])
("jnbz" ["金杯"])
("jncb" ["紧凑"])
("jnd'" ["加拿大"])
("jndb" ["筋斗" "金斗"])
("jnde" ["进德"])
("jndk" ["进刀"])
("jndl" ["近代"])
("jnds" ["金东" "近东"])
("jndu" ["进度"])
("jne'" "紧锦仅谨尽卺堇馑廑瑾槿")
("jnee" ["金额"])
("jner" ["今儿" "进而"])
("jnfa" ["进发"])
("jnfj" ["进犯"])
("jng'" ["纪念馆"])
("jngd" ["金光"])
("jngh" ["金刚"])
("jngr" ["尽管"])
("jngs" ["金工" "进攻" "进贡"])
("jngu" ["筋骨" "禁锢"])
("jnhb" ["今后"])
("jnhd" ["金黄"])
("jnhe" ["金和"])
("jnhl" ["近海"])
("jnho" ["进货"])
("jnhu" ["近乎"])
("jnhw" ["金华" "进化"])
("jnig" ["进程"])
("jnih" ["进场"])
("jnii" ["进尺" "矜持"])
("jniu" ["进出"])
("jnjc" ["近郊"])
("jnjd" ["金奖"])
("jnji" ["金鸡" "紧急" "进击" "禁忌"])
("jnjm" ["仅见" "晋见"])
("jnjn" ["斤斤" "紧紧" "仅仅"])
("jnjp" ["进军" "禁军"])
("jnjt" ["禁绝"])
("jnkb" ["进口"])
("jnkd" ["金矿" "近况"])
("jnke" ["尽可"])
("jnku" ["金库"])
("jnky" ["尽快"])
("jnl'" ["近年来"])
("jnld" ["斤两" "尽量"])
("jnli" ["尽力"])
("jnll" ["进来" "近来"])
("jnln" ["近邻"])
("jnlo" ["筋络"])
("jnlp" ["锦纶"])
("jnls" ["金龙"])
("jnlu" ["近路"])
("jnly" ["金陵" "禁令"])
("jnmi" ["紧密"])
("jnng" ["仅能"])
("jnnm" ["今年"])
("jnp'" ["纪念品"])
("jnph" ["近旁"])
("jnpk" ["浸泡"])
("jnpl" ["金牌"])
("jnpo" ["紧迫"])
("jnpx" ["晶内偏析"])
("jnq'" "巾筋斤金今津襟禁衿矜")
("jnqi" ["锦旗" "近期"])
("jnqm" ["金钱" "近前"])
("jnqn" ["近亲"])
("jnqu" ["进取" "进去" "禁区"])
("jnqv" ["艰难曲折"])
("jnqy" ["尽情"])
("jnr'" ["仅" "进" "靳" "晋" "禁" "近" "烬" "浸" "尽" "劲" "荩" "噤" "妗" "缙" "赆" "觐" "纪念日"])
("jnrb" ["筋肉"])
("jnrf" ["今人" "近人"])
("jnri" ["今日" "近日"])
("jnrj" ["浸染"])
("jnrp" ["浸润"])
("jnrs" ["金融"])
("jnru" ["进入" "浸入"])
("jnse" ["金色"])
("jnsi" ["近似"])
("jnso" ["紧缩"])
("jnt'" ["纪念堂"])
("jntb" ["浸透" "尽头" "劲头"])
("jntm" ["今天"])
("jntv" ["进退"])
("jntx" ["津贴"])
("jnu'" ["济南市"])
("jnua" ["金沙"])
("jnuf" ["谨慎" "进深"])
("jnug" ["金声" "今生" "晋生" "晋升"])
("jnui" ["金石" "今世" "进食" "进士" "近世" "近视" "浸湿" "浸蚀" "尽是"])
("jnuj" ["金山"])
("jnuu" ["金属" "晋书"])
("jnuv" ["金水" "进水" "浸水"])
("jnv'" ["纪念章"])
("jnvb" ["锦州"])
("jnvh" ["紧张"])
("jnvi" ["仅只" "禁止"])
("jnvj" ["进展" "进占"])
("jnvk" ["今朝" "紧着"])
("jnvs" ["浸种" "尽忠"])
("jnvu" ["金珠" "进驻"])
("jnwf" ["金文" "今文"])
("jnwj" ["今晚"])
("jnwo" ["紧握"])
("jnwz" ["禁卫"])
("jnxd" ["金相"])
("jnxi" ["今昔"])
("jnxm" ["尽先"])
("jnxn" ["尽心"])
("jnxq" ["进修"])
("jnxt" ["进学"])
("jnxy" ["金星" "进行"])
("jny'" ["几内亚"])
("jnyb" ["仅有"])
("jnye" ["今夜"])
("jnyh" ["晋阳"])
("jnyi" ["襟翼"])
("jnyj" ["谨严" "禁烟"])
("jnyk" ["紧要"])
("jnyp" ["禁运"])
("jnyr" ["金元"])
("jnyu" ["几内亚比绍" "金鱼"])
("jnzi" ["金子" "浸渍" "尽自"])
("jnzk" ["尽早"])
("jnzl" ["仅在"])
("jpbu" ["军部"])
("jpbz" ["军备"])
("jpdg" ["均等"])
("jpdv" ["军队"])
("jpf'" ["均贫富"])
("jpfa" ["军阀" "军法"])
("jpff" ["均分"])
("jpfh" ["军方"])
("jpfu" ["军服"])
("jpfz" ["军费"])
("jpgr" ["军官" "军管"])
("jpgs" ["军工" "军功" "竣工"])
("jph'" ["静配合" "静平衡"])
("jphe" ["菌核"])
("jphg" ["均衡"])
("jphk" ["军号"])
("jpho" ["军火"])
("jphu" ["军户"])
("jpi'" ["吉普车"])
("jpie" ["军车"])
("jpji" ["军机" "军纪"])
("jpjm" ["军舰"])
("jpjx" ["俊杰"])
("jpjy" ["军警"])
("jpke" ["均可"])
("jpl'" ["角频率"])
("jpld" ["军粮"])
("jpli" ["军力"])
("jplo" ["菌落"])
("jply" ["军龄" "军令" "峻岭"])
("jplz" ["菌类"])
("jpma" ["骏马"])
("jpmc" ["菌苗"])
("jpmk" ["军帽"])
("jpmn" ["军民"])
("jpq'" ["龟" "均" "菌" "钧" "军" "君" "皲" "筠" "麇" "鉴频器"])
("jpqr" ["君权"])
("jpqu" ["军区"])
("jpqy" ["军情"])
("jpr'" "菌峻俊竣浚郡骏捃隽")
("jpre" ["均热"])
("jprf" ["军人"])
("jprw" ["家破人亡"])
("jpsi" ["菌丝"])
("jptm" ["均田"])
("jptp" ["军屯"])
("jptr" ["军团"])
("jpts" ["军统"])
("jpui" ["均势" "军师" "军士" "军事"])
("jpuu" ["军属"])
("jpv'" ["柬埔寨"])
("jpvd" ["军装"])
("jpvg" ["军政"])
("jpvh" ["军长"])
("jpvi" ["军制"])
("jpvs" ["军种"])
("jpvu" ["菌株" "君主"])
("jpvv" ["九品中正"])
("jpwh" ["君王"])
("jpwu" ["军务"])
("jpwz" ["军委"])
("jpx'" ["解剖学"])
("jpxc" ["军校"])
("jpxd" ["均相" "军饷"])
("jpxn" ["军心"])
("jpxp" ["军训"])
("jpxu" ["军需"])
("jpxx" ["军械"])
("jpyi" ["均一" "均已" "军医"])
("jpyp" ["均匀"])
("jpys" ["军用"])
("jpyu" ["均与"])
("jpyy" ["军营"])
("jpzi" ["君子"])
("jpzs" ["军总"])
("jq'" ["及其"])
("jqba" ["酒吧"])
("jqbj" ["旧版"])
("jqbl" ["九百"])
("jqbm" ["就便"])
("jqbq" ["坚强不屈"])
("jqbu" ["就不"])
("jqby" ["救兵"])
("jqbz" ["酒杯" "就被"])
("jqci" ["九次" "就此"])
("jqcj" ["就餐"])
("jqcl" ["韭菜" "酒菜"])
("jqcs" ["就从"])
("jqd'" ["精确度"])
("jqdb" ["就都"])
("jqde" ["旧的"])
("jqdi" ["旧地" "就地"])
("jqdm" ["酒店"])
("jqe'" "玖韭久灸九酒")
("jqff" ["纠纷"])
("jqfj" ["就范"])
("jqfl" ["奖勤罚懒"])
("jqfu" ["舅父"])
("jqfz" ["厩肥"])
("jqge" ["九个"])
("jqgk" ["九皋"])
("jqgo" ["救国" "旧国"])
("jqgr" ["酒馆" "旧观"])
("jqgs" ["舅公"])
("jqhd" ["韭黄"])
("jqhe" ["纠合"])
("jqho" ["救活" "救火" "旧货"])
("jqhu" ["救护"])
("jqhv" ["酒会" "就会"])
("jqhw" ["酒花"])
("jqia" ["纠察"])
("jqig" ["九成"])
("jqih" ["酒厂"])
("jqii" ["臼齿"])
("jqij" ["纠缠"])
("jqiu" ["揪出"])
("jqjc" ["旧教"])
("jqjd" ["九江"])
("jqji" ["纠集" "救急" "救济"])
("jqjn" ["就近"])
("jqjq" ["久久" "九九" "舅舅"])
("jqju" ["旧居"])
("jqjv" ["加氢精制"])
("jqjw" ["酒家"])
("jqjy" ["究竟" "九经" "酒精"])
("jqke" ["就可"])
("jqlh" ["加氢裂化"])
("jqli" ["旧历"])
("jqll" ["就来"])
("jqlq" ["久留"])
("jqls" ["九龙"])
("jqma" ["舅妈"])
("jqmy" ["救命"])
("jqn'" ["几千年"])
("jqng" ["就能"])
("jqpn" ["九品"])
("jqq'" ["揪" "究" "纠" "啾" "阄" "鸠" "赳" "鬏" "静悄悄"])
("jqqi" ["酒器"])
("jqqr" ["九泉"])
("jqqy" ["九卿"])
("jqr'" ["就" "厩" "救" "旧" "臼" "舅" "咎" "疚" "僦" "柩" "桕" "鹫" "机器人"])
("jqrf" ["就任"])
("jqrh" ["就让"])
("jqri" ["旧日"])
("jqsr" ["就算"])
("jqtm" ["九天"])
("jqug" ["救生" "旧生"])
("jqui" ["九十" "旧诗" "旧时" "旧事" "就事" "就势" "就是"])
("jquu" ["旧书"])
("jqvb" ["九州"])
("jqvg" ["纠正" "就正"])
("jqvh" ["九章"])
("jqvi" ["救治" "旧址" "旧制" "就职"])
("jqvs" ["就中"])
("jqvu" ["救助"])
("jqvv" ["急起直追"])
("jqwf" ["旧闻"])
("jqwh" ["救亡"])
("jqwo" ["酒涡" "酒窝"])
("jqwu" ["九五" "旧物"])
("jqwz" ["久违"])
("jqxd" ["就象"])
("jqxi" ["酒席"])
("jqxt" ["旧学" "就学"])
("jqxu" ["就绪"])
("jqxy" ["救星"])
("jqyb" ["就有"])
("jqyd" ["技巧运动"])
("jqye" ["就业"])
("jqyh" ["久仰"])
("jqyi" ["久已" "就医" "就义"])
("jqyk" ["酒药" "就要"])
("jqyr" ["久远" "救援"])
("jqys" ["就用"])
("jqyt" ["九月"])
("jqzk" ["酒糟"])
("jqzl" ["救灾" "就在"])
("jqzo" ["就座"])
("jr'" ["进入"])
("jrbb" ["坚韧不拔"])
("jrbt" ["截然不同" "迥然不同"])
("jre'" "卷锩")
("jrgi" ["绝热过程"])
("jrgt" ["金融寡头"])
("jri'" ["金日成"])
("jrii" ["卷尺"])
("jrj'" ["绞肉机"])
("jrjv" ["尽人皆知"])
("jrkr" ["捐款"])
("jrl'" ["加热炉" "均热炉"])
("jrlm" ["眷恋"])
("jrq'" ["捐" "鹃" "娟" "圈" "涓" "蠲" "镌" "加热器"])
("jrqu" ["卷曲" "卷取"])
("jrr'" "倦眷卷绢俊圈鄄狷桊隽")
("jrrf" ["鹃人"])
("jrrj" ["卷染"])
("jrrk" ["卷绕"])
("jrru" ["卷入"])
("jrts" ["卷筒"])
("jrui" ["金融市场"])
("jruu" ["眷属"])
("jruv" ["捐税"])
("jrvd" ["卷装"])
("jrvu" ["捐助"])
("jrwz" ["卷纬"])
("jrx'" ["兼容性"])
("jrxm" ["捐献"])
("jryi" ["倦意"])
("jryj" ["卷烟"])
("jrzb" ["金融资本"])
("jrzi" ["卷子"])
("jrzs" ["卷宗"])
("jrzz" ["骄柔造作"])
("jsb'" ["加速泵"])
("jsd'" ["角速度"])
("jse'" "炯窘迥炅")
("jsfx" ["聚四氟乙烯"])
("jsgy" ["集思广益"])
("jsi'" ["计算尺"])
("jsj'" ["计算机" "减速剂"])
("jsjs" ["近似计算" "炯炯"])
("jsjy" ["窘境"])
("jsl'" ["精饲料"])
("jspo" ["窘迫"])
("jsq'" ["扃" "加速器" "减速器"])
("jst'" ["菌丝体"])
("jsu'" ["近似商" "江苏省"])
("jsv'" ["近似值"])
("jsvx" ["计算中心"])
("jsx'" ["贾思勰"])
("jsyd" ["加速运动"])
("jt'" ["今天"])
("jtb'" ["交通部"])
("jtbi" ["绝壁"])
("jtbu" ["决不"])
("jtce" ["决策"])
("jtdb" ["决斗"])
("jtdd" ["惊天动地"])
("jtde" ["觉得"])
("jtdi" ["绝地"])
("jtdr" ["决断"])
("jtdu" ["具体地说"])
("jtdv" ["绝对"])
("jtdy" ["决定" "绝顶"])
("jte'" "蹶")
("jteg" ["晶体二极管"])
("jtfl" ["集体福利"])
("jtfy" ["家庭副业"])
("jtg'" ["晶体管"])
("jtgj" ["交通工具"])
("jth'" ["集体化" "具体化"])
("jthl" ["惊涛骇浪"])
("jti'" ["脚踏车"])
("jtia" ["觉察"])
("jtiu" ["家庭出身"])
("jtj'" ["集团军"])
("jtjc" ["绝交"])
("jtjd" ["倔强"])
("jtjg" ["晶体结构"])
("jtji" ["决计" "绝迹"])
("jtjj" ["集体经济"])
("jtjn" ["掘进"])
("jtju" ["碱土金属" "绝句"])
("jtjy" ["绝境"])
("jtkb" ["决口" "绝口"])
("jtld" ["集体领导" "具体劳动"])
("jtlp" ["绝伦"])
("jtlu" ["绝路"])
("jtlx" ["决裂"])
("jtly" ["集体利益"])
("jtmc" ["绝妙"])
("jtmi" ["绝密"])
("jtnv" ["集体农庄"])
("jtq'" "撅嗟噘")
("jtqc" ["诀窍"])
("jtqi" ["崛起"])
("jtqu" ["攫取"])
("jtqy" ["金田起义"])
("jtr'" "倔")
("jtre" ["绝热"])
("jtrj" ["决然"])
("jtry" ["胶体溶液"])
("jtsg" ["晶体三极管"])
("jtsl" ["决赛"])
("jtsr" ["决算"])
("jtsv" ["集体所有制"])
("jttb" ["镢头"])
("jttu" ["掘土"])
("jtud" ["脚踏实地"])
("jtui" ["爵士" "绝食"])
("jtuk" ["绝少"])
("jtul" ["具体说来"])
("jtuy" ["家庭手工业"])
("jtv'" ["井田制" "均田制"])
("jtvj" ["决战"])
("jtvl" ["卷土重来"])
("jtvq" ["晶体振荡器"])
("jtvs" ["绝种"])
("jtvy" ["集体主义" "教条主义"])
("jtw'" "嚼脚角攫抉掘倔爵觉决诀绝厥劂谲矍蕨噱崛獗孓珏桷橛爝镢蹶觖")
("jtwh" ["绝望"])
("jtwu" ["觉悟"])
("jtwz" ["爵位"])
("jtx'" ["交通线"])
("jtxn" ["决心"])
("jtxw" ["街头巷尾"])
("jtxy" ["觉醒"])
("jtyi" ["决意" "决议"])
("jtyr" ["绝缘"])
("jtze" ["抉择"])
("ju'" ["结束" "几十"])
("jub'" ["精神病"])
("jubf" ["剧本"])
("jubj" ["举办"])
("jubm" ["聚变" "巨变"])
("jubu" ["局部"])
("jubz" ["举杯" "具备"])
("juci" ["据此"])
("jucj" ["聚餐"])
("jucl" ["金属材料"])
("jucu" ["局促"])
("jud'" ["旧时代"])
("juda" ["巨大"])
("judm" ["据点"])
("judo" ["居多"])
("juds" ["精神抖擞" "举动"])
("judw" ["建设单位"])
("jue'" "柜咀矩举沮莒枸榉踽龃")
("juee" ["巨额"])
("jufa" ["句法"])
("jufg" ["聚砜" "飓风"])
("jufj" ["举凡"])
("jufl" ["减数分裂"])
("juft" ["军事法庭"])
("jufu" ["金属腐蚀" "巨幅"])
("jugg" ["桔梗"])
("jugm" ["技术革命"])
("jugo" ["举国"])
("jugs" ["鞠躬"])
("jugx" ["技术革新"])
("jugz" ["计时工资" "金属光泽"])
("juh'" ["军事化"])
("juhb" ["金属货币"])
("juhe" ["聚合"])
("juhf" ["精神焕发"])
("juhk" ["句号"])
("juhs" ["桔红"])
("juhv" ["聚会"])
("juhw" ["菊花"])
("jui'" ["寄生虫"])
("juid" ["锯床" "积少成多"])
("juih" ["剧场"])
("juii" ["锯齿"])
("juir" ["据传"])
("juiu" ["举出"])
("juj'" ["脚手架" "金沙江" "金属键" "军事家"])
("jujc" ["聚焦"])
("jujd" ["军事基地"])
("juji" ["聚积" "聚集"])
("jujm" ["尽善尽美"])
("jujn" ["拘谨" "拘禁"])
("jujt" ["咀嚼" "拒绝"])
("juju" ["聚居"])
("jujx" ["具结"])
("juki" ["金属矿床"])
("jukr" ["巨款"])
("jul'" ["降水量"])
("jule" ["俱乐"])
("juli" ["居里" "举例" "距离"])
("julm" ["聚敛"])
("julq" ["拘留" "居留"])
("julx" ["剧烈"])
("jum'" ["金属模"])
("jumm" ["局面"])
("jumn" ["居民"])
("jumu" ["举目" "剧目"])
("jumy" ["集市贸易"])
("jun'" ["几十年"])
("juni" ["拘泥"])
("jupa" ["惧怕"])
("juq'" ["车" "鞠" "拘" "狙" "疽" "居" "驹" "据" "锯" "俱" "且" "苴" "掬" "琚" "椐" "锔" "裾" "趄" "雎" "鞫" "计数器"])
("juqi" ["举起"])
("juqr" ["俱全"])
("juqy" ["剧情"])
("jur'" ["沮" "聚" "拒" "据" "巨" "具" "距" "踞" "锯" "俱" "句" "惧" "炬" "剧" "倨" "讵" "苣" "遽" "屦" "榘" "犋" "飓" "钜" "窭" "趄" "醵" "瞿" "介绍人"])
("jurf" ["举人" "巨人"])
("jurj" ["居然"])
("jus'" ["金沙萨" "金属丝" "酒石酸"])
("jush" ["沮丧"])
("jutb" ["巨头"])
("jutc" ["锯条"])
("juti" ["具体"])
("jutr" ["剧团"])
("juu'" ["就是说"])
("juub" ["举手"])
("juuh" ["巨商"])
("juui" ["居士" "局势" "举世" "举事"])
("juuj" ["精神世界"])
("juuo" ["据说"])
("juup" ["技术水平"])
("juuu" ["拘束"])
("juuv" ["技术水准"])
("juvb" ["技术装备"])
("juvd" ["技术指导"])
("juvf" ["矩阵"])
("juvh" ["局长"])
("juvi" ["举止" "聚酯"])
("juvs" ["居中" "举重" "剧种"])
("juvu" ["居住" "巨著"])
("juvy" ["金属主义"])
("juw'" ["桔" "菊" "局" "橘" "锔" "寄生物"])
("juwf" ["具文"])
("juwl" ["局外"])
("juwm" ["举世闻名"])
("juwz" ["局委"])
("jux'" ["技术性" "建设性" "介绍信"])
("juxi" ["据悉"])
("juxl" ["军事训练"])
("juxm" ["局限"])
("juxn" ["居心"])
("juxy" ["矩形" "举行" "聚星" "巨型"])
("juy'" ["技术员" "驾驶员" "结束语"])
("juyb" ["具有"])
("juyi" ["拘役"])
("juyr" ["剧院"])
("juys" ["金属元素"])
("juyu" ["居于"])
("juzi" ["桔子" "句子" "橘子"])
("jv'" ["截至"])
("jvc'" ["角质层"])
("jvcl" ["建筑材料"])
("jvdw" ["脊椎动物" "节肢动物"])
("jvf'" ["军政府"])
("jvfy" ["集中反映"])
("jvg'" ["交战国" "旧中国" "君主国"])
("jvgd" ["建筑工地"])
("jvgi" ["建筑工程"])
("jvgl" ["价值规律"])
("jvgy" ["建筑工业"])
("jvh'" ["金仲华"])
("jvid" ["价值尺度"])
("jvj'" ["矫直机"])
("jvjg" ["建筑结构"])
("jvjx" ["建筑机械"])
("jvl'" ["价值量" "价值论" "竞争力"])
("jvlv" ["君主立宪制"])
("jvlx" ["君主立宪"])
("jvm'" ["基准面"])
("jvmj" ["建筑面积"])
("jvpl" ["截止频率"])
("jvr'" ["见证人" "剧中人"])
("jvsu" ["九章算术"])
("jvu'" ["急诊室"])
("jvuj" ["建筑设计"])
("jvuv" ["聚酯树脂"])
("jvv'" ["家长制" "君主制"])
("jvvv" ["君主专制"])
("jvw'" ["建筑物" "胶州湾"])
("jvws" ["甲种维生素"])
("jvx'" ["甲状腺"])
("jvxu" ["价值形式"])
("jvxv" ["甲状腺肿"])
("jvxw" ["聚酯纤维"])
("jvy'" ["集中营" "建筑业" "教职员"])
("jvyl" ["甲胄鱼类"])
("jvyu" ["建筑艺术"])
("jvzb" ["节制资本"])
("jw'" ["极为"])
("jwan" ["假案"])
("jwbf" ["甲苯"])
("jwbj" ["夹板" "加班" "甲板"])
("jwby" ["甲兵"])
("jwbz" ["加倍"])
("jwcg" ["夹层"])
("jwci" ["架次"])
("jwcj" ["家蚕"])
("jwcl" ["家财"])
("jwd'" ["机务段" "晋武帝"])
("jwda" ["加大"])
("jwde" ["假的"])
("jwdh" ["家当"])
("jwdi" ["家底" "甲第"])
("jwdk" ["夹道"])
("jwdl" ["夹带"])
("jwdm" ["加点"])
("jwdo" ["加多"])
("jwdy" ["嘉定" "假定"])
("jwe'" "贾甲钾假搅铰矫侥脚狡角饺缴绞剿嘏佼挢岬徼湫敫胛皎瘕")
("jwfa" ["家法" "加法"])
("jwff" ["甲酚"])
("jwfg" ["夹缝"])
("jwfh" ["甲方"])
("jwfu" ["家父"])
("jwfz" ["钾肥"])
("jwge" ["家鸽" "价格"])
("jwgk" ["加高"])
("jwgl" ["加盖"])
("jwgo" ["荚果"])
("jwgs" ["夹攻" "加工"])
("jwgu" ["加固"])
("jwgz" ["嫁给"])
("jwhb" ["加厚" "贾后"])
("jwhe" ["嘉禾"])
("jwho" ["家伙"])
("jwhw" ["佳话" "假话"])
("jwih" ["家常"])
("jwij" ["家产"])
("jwip" ["甲醇"])
("jwis" ["甲虫"])
("jwiu" ["家畜"])
("jwjc" ["夹角"])
("jwjd" ["嘉奖"])
("jwji" ["夹击" "加急" "甲基"])
("jwjn" ["加紧"])
("jwju" ["夹具" "家具" "加剧"])
("jwjw" ["家家"])
("jwjx" ["佳节" "假借" "嫁接" "今文经学"])
("jwjy" ["嘉靖" "家境"])
("jwke" ["甲壳"])
("jwkl" ["继往开来"])
("jwkr" ["加宽"])
("jwks" ["架空"])
("jwky" ["加快"])
("jwlc" ["加料"])
("jwli" ["加力"])
("jwlp" ["加仑"])
("jwmf" ["家门"])
("jwmi" ["加密"])
("jwmk" ["假冒"])
("jwmo" ["荚膜"])
("jwmu" ["价目"])
("jwmy" ["假名"])
("jwna" ["加纳"])
("jwni" ["加尼"])
("jwnm" ["加拈" "加捻"])
("jwnu" ["家奴"])
("jwpg" ["加蓬"])
("jwpu" ["家谱"])
("jwq'" "嘉枷夹佳家加茄挟伽葭浃迦珈镓痂笳袈跏")
("jwqd" ["加强"])
("jwqi" ["假期"])
("jwqm" ["价钱"])
("jwqn" ["家禽"])
("jwqr" ["甲醛"])
("jwqu" ["嫁娶"])
("jwqy" ["嘉庆" "加氢"])
("jwr'" ["假" "稼" "价" "架" "驾" "嫁" "局外人"])
("jwre" ["加热"])
("jwrf" ["佳人" "家人"])
("jwri" ["假日"])
("jwro" ["假若"])
("jwru" ["加入" "假如"])
("jwso" ["枷锁"])
("jwsr" ["甲酸"])
("jwsu" ["加速"])
("jwt'" "家")
("jwto" ["假托"])
("jwtu" ["家兔"])
("jwty" ["家庭"])
("jwue" ["假设" "架设"])
("jwuf" ["加深"])
("jwug" ["夹生"])
("jwuh" ["加上"])
("jwui" ["家史" "家世" "家事" "家室" "甲士" "假使" "假释" "架式" "架势" "驾驶"])
("jwuj" ["家山" "假山"])
("jwuo" ["假说"])
("jwuu" ["家书" "家属" "加数"])
("jwuv" ["节外生枝"])
("jwvd" ["假装" "嫁妆"])
("jwve" ["架着"])
("jwvh" ["家长"])
("jwvi" ["假植" "价值"])
("jwvs" ["加重"])
("jwvu" ["加注"])
("jwvv" ["甲午战争"])
("jww'" "夹荚颊郏戛恝铗袷蛱")
("jwwj" ["甲烷"])
("jwwu" ["家务" "甲午"])
("jwxd" ["家乡" "假想" "假象"])
("jwxn" ["夹心" "家信"])
("jwxt" ["家学"])
("jwxy" ["嘉兴"])
("jwy'" ["军务院"])
("jwya" ["加压"])
("jwyb" ["加油"])
("jwye" ["家业"])
("jwyi" ["加以" "贾谊" "甲乙" "假意"])
("jwyj" ["钾盐"])
("jwyn" ["佳音"])
("jwyr" ["家园"])
("jwys" ["家用"])
("jwyu" ["甲鱼" "驾驭"])
("jwza" ["夹杂"])
("jwzi" ["夹子" "甲子" "架子"])
("jwzl" ["架在"])
("jwzo" ["佳作"])
("jwzu" ["家族"])
("jx'" ["举行"])
("jxa'" ["聚酰胺"])
("jxan" ["结案"])
("jxbf" ["节本"])
("jxbj" ["接班" "结伴"])
("jxbk" ["捷报"])
("jxbl" ["洁白"])
("jxby" ["结冰"])
("jxbz" ["戒备" "界碑"])
("jxcg" ["阶层"])
("jxci" ["介词"])
("jxcl" ["芥菜"])
("jxcp" ["结存"])
("jxda" ["解答"])
("jxdc" ["借调"])
("jxdg" ["教学大纲"])
("jxdi" ["接地"])
("jxdk" ["接到" "街道"])
("jxdl" ["接待" "借贷"])
("jxdm" ["接点" "节点"])
("jxdo" ["劫夺"])
("jxdp" ["惊心动魄"])
("jxdr" ["阶段" "截断" "借端"])
("jxds" ["解冻"])
("jxdu" ["解毒"])
("jxdv" ["结队"])
("jxe'" "解姐")
("jxf'" ["急先锋" "教学法"])
("jxfa" ["揭发"])
("jxfh" ["街坊" "解放" "借方"])
("jxfu" ["姐夫"])
("jxg'" ["基辛格" "精细管"])
("jxgb" ["结构"])
("jxgd" ["借光"])
("jxgi" ["机械工程"])
("jxgk" ["接羔"])
("jxgl" ["节概"])
("jxgm" ["继续革命"])
("jxgo" ["结果"])
("jxgr" ["接管"])
("jxgu" ["解雇" "借故"])
("jxh'" ["机械化"])
("jxhe" ["接合" "结核" "结合"])
("jxho" ["劫获"])
("jxhp" ["结婚"])
("jxi'" ["机修厂"])
("jxid" ["疥疮"])
("jxig" ["竭诚"])
("jxii" ["劫持"])
("jxil" ["解差"])
("jxir" ["揭穿"])
("jxiu" ["接触" "杰出" "解除"])
("jxj'" ["极性键" "急行军"])
("jxjc" ["结焦" "结交"])
("jxjh" ["教学计划" "解析几何"])
("jxji" ["接济" "阶级" "截击" "劫机" "结集"])
("jxjm" ["接见" "节间" "节俭" "借鉴"])
("jxjn" ["接近" "竭尽"])
("jxjq" ["解救"])
("jxjt" ["解决"])
("jxju" ["结局" "借据"])
("jxjx" ["节节" "结节" "姐姐"])
("jxjy" ["捷径" "洁净" "结晶"])
("jxkb" ["接口" "藉口" "借口"])
("jxke" ["捷克" "解渴"])
("jxkl" ["揭开" "解开"])
("jxkr" ["借款"])
("jxky" ["结块"])
("jxl'" ["机械论"])
("jxlc" ["戒了"])
("jxli" ["接力" "节理" "竭力"])
("jxlm" ["接连"])
("jxlp" ["结论"])
("jxlq" ["截留"])
("jxlt" ["劫掠"])
("jxlu" ["揭露" "节录"])
("jxlv" ["节律" "戒律"])
("jxlx" ["节烈"])
("jxmf" ["街门"])
("jxmg" ["结盟"])
("jxmi" ["解密"])
("jxmj" ["届满"])
("jxmk" ["睫毛"])
("jxmm" ["截面" "界面"])
("jxmu" ["揭幕" "节目"])
("jxmz" ["姐妹"])
("jxn'" ["机械能"])
("jxna" ["接纳"])
("jxpb" ["解剖"])
("jxpi" ["揭批"])
("jxpl" ["碱性平炉" "节拍"])
("jxpm" ["节片"])
("jxpo" ["揭破"])
("jxq'" ["揭" "接" "皆" "秸" "街" "阶" "节" "结" "楷" "喈" "嗟" "疖" "交响曲" "进行曲"])
("jxqi" ["节气" "借期"])
("jxqw" ["接洽"])
("jxr'" "价解戒藉芥界借介疥诫届蚧骱")
("jxrf" ["接任" "解人"])
("jxrh" ["接壤"])
("jxri" ["节日"])
("jxrj" ["截然"])
("jxru" ["介入"])
("jxsj" ["解散"])
("jxsr" ["结算"])
("jxsv" ["接穗"])
("jxt'" "家价")
("jxtb" ["接头" "街头"])
("jxtc" ["解调"])
("jxti" ["接替" "阶梯" "解体"])
("jxto" ["解脱"])
("jxts" ["接通"])
("jxu'" ["江西省"])
("jxub" ["接收" "接手" "接受" "界首"])
("jxue" ["结社"])
("jxug" ["接生" "节省"])
("jxui" ["揭示" "街市" "节食" "结石" "结实" "结识" "解释" "届时"])
("jxuk" ["介绍"])
("jxuo" ["解说" "界说"])
("jxuu" ["结束"])
("jxuw" ["谨小慎微"])
("jxv'" ["郡县制"])
("jxva" ["结扎"])
("jxve" ["接着"])
("jxvh" ["结帐"])
("jxvi" ["截止" "截至" "节制" "解职" "戒指" "介质"])
("jxvl" ["借债"])
("jxvs" ["接种" "接踵"])
("jxvu" ["截住" "借助"])
("jxw'" "截劫节桔杰捷睫竭洁结偈讦诘拮婕孑桀碣颉羯鲒")
("jxws" ["碱纤维素"])
("jxwy" ["机械唯物主义"])
("jxwz" ["结尾" "解围"])
("jxx'" ["假惺惺" "局限性"])
("jxxc" ["揭晓"])
("jxxi" ["解析" "解吸"])
("jxxl" ["机械效率"])
("jxxm" ["接线" "界限" "界线"])
("jxxn" ["机械性能" "街心" "戒心"])
("jxxu" ["接续"])
("jxy'" ["机械油" "加西亚" "交响乐"])
("jxya" ["聚酰亚胺"])
("jxyd" ["机械运动"])
("jxye" ["结业"])
("jxyi" ["结义" "借以" "介意"])
("jxyj" ["戒严"])
("jxyr" ["节圆"])
("jxys" ["节用" "借用"])
("jxyt" ["节约"])
("jxyu" ["节余" "节育" "结余" "结语" "介于"])
("jxyw" ["碱性氧化物"])
("jxyy" ["接应"])
("jxz'" ["急性子"])
("jxzb" ["节奏"])
("jxzi" ["节子" "结子" "介子"])
("jxzo" ["杰作"])
("jy'" ["建议"])
("jyai" ["敬爱"])
("jyb'" ["进一步" "教育部"])
("jybk" ["警报"])
("jybz" ["警备"])
("jycl" ["精采" "精彩" "绝缘材料"])
("jyde" ["经得"])
("jydi" ["劲敌" "井底" "境地"])
("jydk" ["粳稻"])
("jydm" ["经典" "静电"])
("jydq" ["家用电器"])
("jyds" ["惊动"])
("jydu" ["京都" "精度" "经度"])
("jydv" ["井队"])
("jye'" "井警景颈刭儆阱憬肼")
("jyee" ["惊愕"])
("jyfh" ["京房" "精纺"])
("jyfv" ["教育方针"])
("jyfz" ["经费"])
("jygd" ["京广" "精光"])
("jyge" ["晶格"])
("jygj" ["精干" "竟敢"])
("jygk" ["警告"])
("jygo" ["经过"])
("jygr" ["经管" "井灌" "警官" "景观" "静观"])
("jyhb" ["静候"])
("jyhd" ["惊慌" "惊惶"])
("jyhe" ["晶核"])
("jyhl" ["惊骇"])
("jyhu" ["京胡"])
("jyhv" ["竟会"])
("jyhw" ["京华" "精华" "净化"])
("jyhx" ["家喻户晓"])
("jyia" ["惊诧" "警察"])
("jyig" ["京城"])
("jyih" ["经常"])
("jyik" ["精巢"])
("jyj'" ["卷扬机"])
("jyji" ["京畿" "经籍" "经济" "静寂" "竞技"])
("jyjj" ["加以解决"])
("jyjm" ["精简"])
("jyjn" ["净尽"])
("jyjq" ["经久" "敬酒"])
("jyjt" ["警觉"])
("jyju" ["京剧" "警句"])
("jyjw" ["井架"])
("jyjx" ["精解" "经解" "警戒" "境界"])
("jyjy" ["静静"])
("jykb" ["京口" "井口"])
("jykd" ["精矿" "景况" "境况" "镜框"])
("jyks" ["惊恐"])
("jyl'" ["记忆力" "剪应力" "降雨量" "焦裕禄"])
("jyld" ["精良"])
("jyli" ["晶粒" "精力" "经理" "经历" "敬礼"])
("jylm" ["精炼" "精练"])
("jylo" ["经络"])
("jylp" ["腈纶"])
("jylq" ["精馏" "径流"])
("jylr" ["痉挛"])
("jylt" ["经略"])
("jylv" ["劲旅"])
("jyly" ["精灵" "竟陵"])
("jymc" ["精妙"])
("jymi" ["精密" "经密"])
("jyml" ["静脉"])
("jymm" ["镜面"])
("jymo" ["静默"])
("jymu" ["静穆"])
("jymy" ["精明"])
("jymz" ["精美"])
("jynh" ["精囊"])
("jynz" ["境内"])
("jypd" ["假言判断"])
("jypf" ["井喷"])
("jypi" ["精辟" "精僻"])
("jypm" ["镜片"])
("jypo" ["景颇"])
("jypz" ["敬佩"])
("jyq'" "荆兢茎睛晶鲸京惊精粳经菁泾腈旌")
("jyqc" ["精巧"])
("jyqi" ["惊奇" "旌旗"])
("jyqj" ["精益求精"])
("jyqr" ["警犬"])
("jyqt" ["精确"])
("jyr'" "劲经静境敬镜径痉靖竟竞净獍迳弪婧胫靓")
("jyrf" ["惊人"])
("jyrj" ["井然" "竟然"])
("jyrv" ["精锐"])
("jys'" ["交易所"])
("jyse" ["景色"])
("jysl" ["径赛" "竞赛"])
("jysv" ["精髓"])
("jyt'" ["减压塔" "绝缘体"])
("jytb" ["镜头"])
("jytc" ["荆条"])
("jyti" ["晶体" "警惕"])
("jytj" ["惊叹"])
("jytl" ["井台" "静态"])
("jytm" ["井田"])
("jyts" ["精通" "井筒"])
("jyu'" ["教研室"])
("jyua" ["经纱"])
("jyub" ["经手" "经受"])
("jyuf" ["精神" "景深"])
("jyug" ["净剩"])
("jyuh" ["经商"])
("jyui" ["京师" "竟是" "净是"])
("jyuj" ["京山" "景山"])
("jyuu" ["精梳" "经书"])
("jyuv" ["井水"])
("jyv'" ["加油站"])
("jyvb" ["荆州" "晶轴" "经轴"])
("jyvd" ["教育制度" "晶状" "精壮"])
("jyve" ["惊蜇"])
("jyvg" ["竞争"])
("jyvi" ["精致" "精制" "景致" "静止" "敬之" "径直" "竟至"])
("jyvj" ["精湛" "九阳真经"])
("jyvl" ["减压蒸馏"])
("jyvs" ["警钟" "敬重" "净重"])
("jyvv" ["颈椎"])
("jyvy" ["减压渣油" "禁欲主义" "经验主义"])
("jyw'" ["锦衣卫" "尽义务"])
("jywu" ["景物"])
("jywz" ["精微" "经纬" "警卫" "敬畏"])
("jyx'" ["基因型" "教育学" "聚乙烯"])
("jyxc" ["经销"])
("jyxd" ["景象" "颈项" "径向"])
("jyxi" ["京西" "京戏" "惊喜" "精细" "聚乙烯醇"])
("jyxm" ["惊险" "经线"])
("jyxn" ["精心" "经心"])
("jyxr" ["精选" "竞选"])
("jyxt" ["经学"])
("jyxv" ["教育行政"])
("jyxw" ["惊吓"])
("jyxy" ["晶形" "惊醒" "井陉"])
("jyy'" ["积雨云"])
("jyya" ["惊讶" "静压"])
("jyyb" ["鲸油" "经由"])
("jyye" ["精液"])
("jyyh" ["敬仰"])
("jyyi" ["惊疑" "惊异" "经义" "敬意"])
("jyyj" ["精盐" "经验" "井盐"])
("jyyu" ["鲸鱼" "境域" "境遇"])
("jyyw" ["见义勇为"])
("jyyy" ["晶莹" "经营"])
("jyz'" ["教研组"])
("jyzb" ["竞走"])
("jyzg" ["敬赠"])
("jyzi" ["精子" "镜子" "径自"])
("jzf'" ["军谘府"])
("jzj'" ["剧作家"])
("jzjx" ["减租减息"])
("jzm'" ["江泽民"])
("jzqv" ["举足轻重"])
("jzt'" ["金字塔"])
("jzx'" ["节奏性"])
("k" "可")
("kae'" "卡咯佧咔胩")
("kaer" ["卡尔"])
("kafz" ["咖啡"])
("kaia" ["喀嚓"])
("kaie" ["卡车"])
("kaii" ["卡尺"])
("kaka" ["咯咯"])
("kali" ["卡里"])
("kamf" ["卡门"])
("kano" ["卡诺"])
("kapj" ["卡盘"])
("kapm" ["卡片"])
("kaq'" "喀咖咔")
("kaqi" ["卡其"])
("kate" ["卡特"])
("kaxx" ["咯血"])
("kban" ["口岸"])
("kbcl" ["口才"])
("kbdl" ["口袋"])
("kbdq" ["可变电容器"])
("kbe'" ["口" "喀布尔"])
("kbfa" ["扣发"])
("kbfg" ["口风"])
("kbfu" ["口服"])
("kbfz" ["恐怖分子"])
("kbg'" ["看不惯"])
("kbgj" ["口感"])
("kbgl" ["口盖"])
("kbgs" ["口供"])
("kbhk" ["口号"])
("kbi'" ["看不出"])
("kbii" ["口吃"])
("kbiu" ["扣除"])
("kbjc" ["口角"])
("kbji" ["口技"])
("kbjy" ["口径"])
("kbke" ["口渴"])
("kbky" ["可不可以"])
("kbld" ["口粮"])
("kblq" ["扣留"])
("kbly" ["口令"])
("kbpv" ["抗病品种"])
("kbq'" ["抠" "芤" "眍" "看不起"])
("kbqd" ["口腔"])
("kbqi" ["口器" "口气"])
("kbqn" ["口琴"])
("kbr'" "扣寇蔻叩筘")
("kbrh" ["刻不容缓"])
("kbtb" ["口头" "叩头"])
("kbub" ["口授"])
("kbue" ["口舌"])
("kbui" ["口实"])
("kbuu" ["口述"])
("kbuv" ["口水"])
("kbv'" ["靠不住"])
("kbvk" ["口罩"])
("kbvs" ["口中"])
("kbvy" ["恐怖主义"])
("kbwf" ["口吻"])
("kbwl" ["口外"])
("kbwz" ["口味"])
("kbxy" ["口形"])
("kbya" ["扣压" "扣押"])
("kbyn" ["口音"])
("kbyu" ["口语"])
("kbzb" ["可变资本"])
("kbzi" ["口子" "扣子"])
("kce'" ["康采恩"])
("kcgj" ["枯草杆菌"])
("kcj'" ["考茨基"])
("kcm'" ["快餐面"])
("kdbk" ["狂暴"])
("kdcg" ["矿层"])
("kdch" ["矿藏"])
("kde'" "夼")
("kdfg" ["狂风"])
("kdfh" ["矿房"])
("kdfu" ["匡复"])
("kdgs" ["矿工" "旷工"])
("kdh'" ["扩大化"])
("kdhr" ["狂欢"])
("kdhu" ["狂呼"])
("kdhy" ["扩大会议"])
("kdi'" ["刻度尺"])
("kdid" ["矿床"])
("kdie" ["矿车"])
("kdij" ["矿产"])
("kdjd" ["矿浆"])
("kdjw" ["框架"])
("kdjy" ["矿井"])
("kdkd" ["框框"])
("kdke" ["旷课"])
("kdkg" ["矿坑"])
("kdlj" ["狂澜"])
("kdml" ["矿脉"])
("kdni" ["矿泥"])
("kdnu" ["狂怒"])
("kdq'" ["匡" "筐" "框" "诓" "哐" "看得起"])
("kdqr" ["矿泉"])
("kdqu" ["矿区"])
("kdqx" ["况且"])
("kdr'" "框矿眶旷况邝圹纩贶")
("kdre" ["狂热"])
("kdrf" ["狂人"])
("kdri" ["旷日"])
("kdti" ["矿体"])
("kdtu" ["框图"])
("kdu'" ["看电视"])
("kdua" ["矿砂"])
("kdui" ["矿石"])
("kduj" ["矿山"])
("kdv'" ["靠得住"])
("kdva" ["矿渣"])
("kdvh" ["矿长"])
("kdvi" ["矿质"])
("kdvt" ["可锻铸铁"])
("kdvu" ["矿柱"])
("kdw'" "狂诳")
("kdwh" ["狂妄"])
("kdwu" ["矿物"])
("kdxc" ["狂笑"])
("kdxi" ["狂喜"])
("kdye" ["矿业" "旷野"])
("kdyj" ["狂言"])
("kdzi" ["筐子" "框子" "扩大再生产"])
("keai" ["可爱"])
("kean" ["可按"])
("keba" ["可把"])
("kebf" ["刻本" "课本"])
("kebi" ["可比"])
("kebj" ["科班" "刻板"])
("kebm" ["可变"])
("kebo" ["刻薄"])
("kebu" ["可不"])
("kebz" ["可悲"])
("kech" ["客舱"])
("kecs" ["可从"])
("keda" ["可达"])
("kedi" ["克敌"])
("kedm" ["客店"])
("kedu" ["刻毒" "刻度"])
("kee'" "坷可渴岢轲")
("keer" ["科尔" "克尔"])
("kefb" ["可否"])
("keff" ["可分"])
("kefg" ["可风"])
("kefh" ["客房"])
("kefu" ["克服" "克复"])
("kegr" ["可观" "客观"])
("kegs" ["可供"])
("kegu" ["刻骨"])
("kegv" ["可贵"])
("kehf" ["可恨"])
("kehj" ["可汗"])
("kehk" ["可好"])
("keho" ["客货"])
("kehu" ["客户"])
("kehw" ["刻画" "刻划"])
("keie" ["客车"])
("keig" ["课程"])
("keii" ["可耻"])
("keir" ["客船"])
("kejc" ["科教"])
("kejd" ["可将"])
("keji" ["科技" "客机"])
("kejm" ["可见"])
("keju" ["科举"])
("kejy" ["可敬"])
("kekb" ["可口" "克扣"])
("keke" ["苛刻" "科克" "可可"])
("kekk" ["可靠"])
("keks" ["可控"])
("keku" ["刻苦"])
("kela" ["克拉"])
("keli" ["颗粒" "克里" "克利"])
("kell" ["克莱"])
("kelm" ["可怜"])
("kelp" ["客轮"])
("kem'" ["库尔曼"])
("kemj" ["客满"])
("kemu" ["科目"])
("kenf" ["科尔尼洛夫"])
("keng" ["可能"])
("keni" ["可逆"])
("kepa" ["可怕"])
("kepu" ["科普"])
("keq'" "呵坷苛柯棵磕颗科嗑珂轲瞌钶稞疴窠颏蝌髁")
("keqc" ["可巧"])
("keqi" ["客气"])
("keqn" ["可亲"])
("keqq" ["苛求" "渴求"])
("kequ" ["可取"])
("keqy" ["可卿"])
("ker'" "可克刻客课嗑恪溘骒缂氪锞蚵")
("kerf" ["可人" "客人"])
("kes'" ["凯恩斯"])
("kesb" ["咳嗽"])
("kesk" ["库尔斯克"])
("ketb" ["磕头"])
("ketc" ["可调"])
("keth" ["客堂" "课堂"])
("keti" ["客体" "课题"])
("ketu" ["客土"])
("kety" ["客厅"])
("keub" ["恪守"])
("keuh" ["客商"])
("keui" ["可是" "克食" "课时"])
("keuu" ["棵树"])
("keuv" ["课税" "瞌睡"])
("kevh" ["科长"])
("kevi" ["可知" "克制"])
("kew'" "壳咳颏")
("kewf" ["课文"])
("kewh" ["可望" "渴望"])
("kewl" ["课外"])
("kewu" ["可恶"])
("kewz" ["科委" "可谓"])
("kexc" ["可笑"])
("kexi" ["可惜" "可喜"])
("kexr" ["可选"])
("kext" ["科学"])
("kexw" ["刻下"])
("kexx" ["科协"])
("kexy" ["可行"])
("keyi" ["可疑" "可以" "刻意"])
("keyj" ["科研"])
("keyp" ["客运"])
("keys" ["可用"])
("keyu" ["课余"])
("kezi" ["刻字"])
("kezo" ["可作"])
("kf'" ["开发"])
("kfby" ["狂风暴雨"])
("kfdl" ["开放电路"])
("kfdy" ["肯定"])
("kfe'" "肯啃垦恳龈")
("kffu" ["垦复"])
("kfgh" ["开放搞活"])
("kfhd" ["垦荒"])
("kfk'" ["考夫卡"])
("kfkn" ["克服困难"])
("kfqq" ["恳求"])
("kfqu" ["垦区"])
("kfqx" ["恳切"])
("kfqy" ["恳请"])
("kfr'" "裉")
("kfs'" ["咖啡色"])
("kfvi" ["垦殖"])
("kfyk" ["卡芬雅克"])
("kfz'" ["克分子"])
("kfzd" ["克分子浓度"])
("kgcz" ["客观存在"])
("kgdk" ["坑道"])
("kggs" ["跨国公司"])
("kgmu" ["坑木"])
("kgq'" "坑吭铿")
("kgqd" ["铿锵"])
("kgqi" ["吭气"])
("kgt'" ["啃骨头"])
("kgug" ["吭声"])
("kguz" ["客观实在"])
("kgvl" ["客观真理"])
("kgvy" ["客观主义"])
("kgx'" ["考古学"])
("kh'" ["开会"])
("khbk" ["抗暴"])
("khby" ["抗病"])
("khda" ["抗大"])
("khde" ["康德"])
("khfu" ["康复"])
("khhg" ["抗衡"])
("khhj" ["抗旱"])
("khhs" ["抗洪"])
("khjg" ["开花结果"])
("khji" ["抗击"])
("khjn" ["亢进"])
("khju" ["抗拒"])
("khkl" ["慷慨"])
("khle" ["康乐"])
("khli" ["抗力"])
("khlk" ["抗涝"])
("khmz" ["抗美"])
("khq'" ["康" "慷" "糠" "闶" "开花期"])
("khqr" ["糠醛"])
("khr'" "抗亢炕伉闶钪")
("khre" ["抗热"])
("khri" ["抗日"])
("khsu" ["抗诉"])
("khtb" ["炕头"])
("khti" ["抗体"])
("khuv" ["抗税"])
("khvf" ["抗震"])
("khvg" ["抗争"])
("khvj" ["抗战"])
("khvo" ["炕桌"])
("khw'" "扛")
("khxd" ["炕箱"])
("khxi" ["康熙"])
("khxs" ["抗坏血酸"])
("khxw" ["糠虾"])
("khxy" ["抗性"])
("khyi" ["抗议"])
("khyj" ["炕沿"])
("khyr" ["抗原"])
("khyu" ["抗御"])
("kibg" ["开诚布公"])
("kivj" ["可乘之机"])
("kix'" ["昆虫学"])
("kizy" ["矿产资源"])
("kjbb" ["会计报表"])
("kjbk" ["看报"])
("kjbu" ["刊布"])
("kjbv" ["扩军备战"])
("kjby" ["看病"])
("kjce" ["勘测"])
("kjdc" ["砍掉"])
("kjdg" ["刊登"])
("kjdh" ["空间电荷"])
("kjdk" ["看到"])
("kjdl" ["看待"])
("kje'" "槛坎砍侃莰阚")
("kjfa" ["砍伐" "看法"])
("kjfg" ["克己奉公"])
("kjfl" ["会计分录" "克己复礼"])
("kjg'" ["可见光"])
("kjgo" ["看过"])
("kjgr" ["看管"])
("kjhj" ["空间和时间"])
("kjhs" ["会计核算"])
("kjhu" ["看护"])
("kjia" ["勘察"])
("kjig" ["看成"])
("kjir" ["看穿"])
("kjiu" ["看出"])
("kjjd" ["空军基地"])
("kjjg" ["空间结构"])
("kjjm" ["看见"])
("kjjw" ["看家"])
("kjke" ["坎坷"])
("kjkj" ["看看"])
("kjlc" ["看了"])
("kjll" ["看来"])
("kjmf" ["看门"])
("kjpo" ["看破"])
("kjpv" ["会计凭证"])
("kjq'" "刊堪勘看戡龛")
("kjqi" ["看齐"])
("kjr'" "看嵌阚瞰")
("kjs'" ["抗菌素" "科技司"])
("kjtb" ["看透"])
("kjtj" ["勘探"])
("kjtl" ["看台"])
("kjub" ["看守"])
("kjuh" ["看上"])
("kjuu" ["看书"])
("kjvd" ["会计制度"])
("kjve" ["看着"])
("kjvp" ["看准"])
("kjvs" ["看中" "看重"])
("kjwh" ["看望"])
("kjwu" ["刊物" "勘误"])
("kjxd" ["看相"])
("kjxy" ["刊行"])
("kjyn" ["刊印"])
("kjzl" ["刊载"])
("kjzo" ["看做" "看作"])
("kjzu" ["苛捐杂税"])
("kkan" ["靠岸"])
("kkbm" ["靠边"])
("kkbz" ["拷贝" "靠背"])
("kkda" ["拷打"])
("kke'" "考拷烤栲")
("kkg'" ["可控硅"])
("kkgu" ["考古"])
("kkhe" ["考核"])
("kkho" ["烤火"])
("kkia" ["考查" "考察"])
("kkja" ["慷慨激昂"])
("kkjn" ["靠近"])
("kkjq" ["考究"])
("kkju" ["考据"])
("kkls" ["靠拢"])
("kklv" ["考虑"])
("kkpx" ["苦口婆心"])
("kkq'" "尻")
("kkqn" ["考勤"])
("kkqu" ["考取"])
("kkr'" "靠犒铐")
("kktt" ["哭哭啼啼"])
("kkug" ["考生"])
("kkui" ["考试"])
("kkuj" ["靠山"])
("kkuu" ["口口声声"])
("kkve" ["靠着"])
("kkvg" ["考证"])
("kkvs" ["考种"])
("kkwf" ["拷问"])
("kkx'" ["可靠性"])
("kkya" ["烤鸭"])
("kkyj" ["考验" "烤烟"])
("klbj" ["开办"])
("klbk" ["开包"])
("klcl" ["开采"])
("kldk" ["开刀" "开导"])
("kldl" ["库仑定律"])
("kldr" ["开端"])
("klds" ["开动"])
("kle'" "楷凯慨剀垲蒈恺铠锴")
("klfa" ["开发"])
("klfg" ["开封"])
("klfh" ["开方" "开放"])
("klfj" ["开饭"])
("klfu" ["开赴"])
("klge" ["凯歌"])
("klgo" ["开国"])
("klgr" ["开关"])
("klgs" ["开工"])
("klhd" ["开荒" "开皇"])
("klho" ["开火"])
("klhu" ["开户"])
("klhv" ["开会"])
("klhw" ["开花" "开化"])
("klid" ["开创"])
("klie" ["开车"])
("klig" ["开城"])
("klih" ["开场"])
("klip" ["开春"])
("klir" ["开船"])
("kliu" ["开除"])
("kljm" ["开间"])
("kljt" ["开掘"])
("klju" ["开局"])
("klkb" ["开口"])
("klkd" ["开矿"])
("klke" ["开课"])
("klkf" ["开垦"])
("klko" ["开阔"])
("klks" ["克鲁克斯"])
("kllh" ["开朗"])
("kllo" ["开罗"])
("kllu" ["开路"])
("kllx" ["开列"])
("klmf" ["开门"])
("klmg" ["克里姆林宫"])
("klmo" ["楷模"])
("klmu" ["开幕"])
("klmy" ["开明"])
("klp'" ["科伦坡"])
("klpc" ["开票"])
("klpi" ["开辟"])
("klpj" ["开盘"])
("klpk" ["开炮"])
("klpy" ["开平"])
("klq'" ["开" "揩" "锎" "卡拉奇" "克罗齐"])
("klqd" ["开枪" "抗拉强度"])
("klqi" ["开契"])
("klqq" ["开球"])
("klqt" ["开缺"])
("klr'" "忾")
("klrj" ["慨然"])
("kls'" ["卡洛斯"])
("klsl" ["颗粒饲料"])
("kltb" ["开头"])
("klth" ["开膛"])
("klti" ["楷体"])
("kltj" ["慨叹"])
("klto" ["开脱" "开拓"])
("klts" ["开通"])
("klty" ["开庭"])
("klue" ["开设"])
("klui" ["开始" "开市"])
("kluj" ["开山"])
("kluu" ["楷书"])
("kluv" ["开水"])
("klvg" ["开征"])
("klvh" ["开张"])
("klvi" ["开支"])
("klvj" ["开展" "开战"])
("klwl" ["开外"])
("klxc" ["开销"])
("klxn" ["开心"])
("klxr" ["凯旋"])
("klxt" ["开学"])
("klye" ["开业"])
("klyj" ["开眼"])
("klyr" ["开元" "开远"])
("klzk" ["开凿"])
("kmbx" ["开门办学"])
("kmc'" ["开幕词"])
("kmj'" ["开棉机"])
("kmju" ["开门见山"])
("kml'" ["喀麦隆" "科摩罗"])
("kmu'" ["开幕式" "昆明市"])
("kmvd" ["孔孟之道"])
("kmz'" ["扣帽子"])
("kn'" ["可能"])
("knd'" ["肯尼迪"])
("knfy" ["可逆反应"])
("knx'" ["抗逆性" "可能性"])
("kny'" ["肯尼亚"])
("kobm" ["扩编"])
("kobu" ["阔步"])
("kobx" ["阔别"])
("koda" ["扩大"])
("kohk" ["括号"])
("kohu" ["括弧"])
("kois" ["扩充"])
("kojm" ["扩建"])
("kojp" ["扩军"])
("koks" ["扩孔"])
("koqi" ["阔气"])
("kor'" "括扩廓阔适栝蛞")
("kosj" ["扩散"])
("kovh" ["扩张"])
("kovj" ["扩展"])
("koyn" ["扩音"])
("kpbh" ["捆绑"])
("kpe'" "捆悃阃")
("kpfa" ["困乏"])
("kpho" ["困惑"])
("kpis" ["昆虫"])
("kpjr" ["困倦"])
("kpjy" ["困境"])
("kpku" ["困苦"])
("kpl'" ["坎帕拉"])
("kplp" ["昆仑"])
("kpmy" ["昆明"])
("kpnj" ["困难"])
("kpq'" "坤昆琨锟醌鲲髡")
("kpqu" ["昆曲"])
("kpr'" "困")
("kpvu" ["捆住"])
("kpyh" ["昆阳"])
("kqdf" ["孔雀东南飞"])
("kql'" ["看起来"])
("kqmd" ["空气密度"])
("kqu'" ["孔雀石"])
("kqzl" ["空气阻力"])
("krda" ["宽大"])
("krdl" ["款待"])
("krdu" ["宽度"])
("kre'" "款")
("kree" ["款额"])
("krgd" ["宽广"])
("krhb" ["宽厚"])
("krih" ["宽敞"])
("krko" ["宽阔"])
("krq'" "宽髋")
("krrj" ["狂人日记"])
("krrs" ["宽容"])
("kruu" ["宽恕"])
("krvl" ["宽窄"])
("krvv" ["抗日战争"])
("krwz" ["宽慰"])
("krx'" ["可燃性" "可溶性"])
("krxd" ["款项"])
("krxh" ["口若悬河"])
("krxm" ["宽限"])
("krxy" ["宽行"])
("kryu" ["宽裕"])
("krzi" ["款子"])
("ksbl" ["空白"])
("ksbu" ["恐怖"])
("ksde" ["孔德"])
("ksdi" ["空地"])
("ksdk" ["孔道"])
("ksds" ["空洞" "孔洞"])
("kse'" "恐孔倥")
("ksee" ["空额"])
("ksfj" ["空翻"])
("ksge" ["空格"])
("ksgk" ["控告"])
("kshd" ["恐慌"])
("kshe" ["恐吓"])
("kshj" ["空喊"])
("kshw" ["空话"])
("ksig" ["空城"])
("ksjc" ["孔教"])
("ksjd" ["空降"])
("ksjm" ["空间"])
("ksjp" ["空军"])
("ksju" ["恐惧"])
("ksjy" ["孔径"])
("kskb" ["孔口"])
("kskd" ["空旷"])
("ksks" ["空空"])
("ksls" ["恐龙"])
("ksmc" ["孔庙"])
("ksmo" ["孔墨"])
("ksnj" ["恐难"])
("kspa" ["恐怕"])
("kspk" ["空泡"])
("ksq'" "空倥崆箜")
("ksqi" ["空气"])
("ksqm" ["空前"])
("ksqq" ["孔丘"])
("ksqt" ["孔雀"])
("ksr'" "空控")
("kssu" ["空速" "控诉"])
("kst'" ["喀斯特"])
("kstb" ["空投" "空头"])
("kstc" ["空调"])
("kstj" ["空谈"])
("kstu" ["喀斯特水"])
("ksub" ["空手"])
("ksuu" ["孔数"])
("ksvi" ["控制"])
("ksvj" ["空战"])
("ksvl" ["哭丧着脸"])
("ksvr" ["空转"])
("ksvs" ["空中"])
("kswz" ["空位"])
("ksx'" ["可塑性"])
("ksxd" ["空想"])
("ksxi" ["空袭" "空隙" "孔隙"])
("ksxm" ["空闲"])
("ksxn" ["空心"])
("ksxt" ["空穴" "孔穴"])
("ksxu" ["空虚"])
("ksxw" ["恐吓"])
("ksxy" ["孔型"])
("ksyp" ["空运"])
("ksyu" ["空余"])
("kszi" ["空子"])
("kszl" ["空载"])
("kte'" ["卡塔尔" "卡特尔"])
("ktgi" ["勘探工程"])
("kthd" ["矿体厚度"])
("ktm'" ["喀土穆"])
("ktv'" ["课田制"])
("kty'" ["口头语"])
("ku'" ["可是"])
("kuai" ["酷爱"])
("kuch" ["库藏"])
("kuck" ["枯草"])
("kucp" ["库存"])
("kudj" ["苦胆"])
("kue'" "苦")
("kufh" ["库房"])
("kugj" ["枯干" "苦干"])
("kugs" ["苦功"])
("kuhd" ["枯黄"])
("kuhj" ["哭喊"])
("kuhl" ["苦海"])
("kuiu" ["苦楚" "苦处"])
("kujc" ["裤脚"])
("kujx" ["枯竭"])
("kuku" ["苦苦"])
("kuli" ["苦力"])
("kulm" ["苦练"])
("kulp" ["库仑"])
("kuls" ["窟窿"])
("kulu" ["苦卤"])
("kumf" ["苦闷"])
("kumu" ["枯木"])
("kumy" ["苦命"])
("kunj" ["苦难"])
("kunk" ["哭闹" "苦恼"])
("kuq'" ["枯" "哭" "窟" "刳" "堀" "骷" "枯水期"])
("kuqi" ["哭泣"])
("kur'" "酷库裤喾绔")
("kure" ["酷热"])
("kurf" ["苦人"])
("kurs" ["库容"])
("kus'" ["看守所"])
("kuse" ["苦涩"])
("kusi" ["酷似"])
("kusu" ["哭诉"])
("kutb" ["苦头"])
("kuti" ["哭啼"])
("kuts" ["苦痛"])
("kutv" ["裤腿"])
("kuug" ["哭声"])
("kuuu" ["苦树" "酷暑"])
("kuuv" ["枯水" "苦水"])
("kuvj" ["苦战"])
("kuvs" ["苦衷"])
("kuwz" ["枯萎" "苦味"])
("kuxc" ["苦笑"])
("kuxf" ["口是心非"])
("kuxn" ["苦心"])
("kuxy" ["酷刑"])
("kuyi" ["苦役"])
("kuyk" ["裤腰"])
("kuyl" ["矿山压力"])
("kuyu" ["苦于"])
("kuzi" ["裤子"])
("kuzk" ["枯燥"])
("kv'" ["开展"])
("kvb'" ["控制棒"])
("kvbf" ["亏本"])
("kvbl" ["溃败"])
("kvce" ["窥测"])
("kvdd" ["康庄大道"])
("kve'" "傀跬")
("kvfa" ["匮乏"])
("kvgz" ["开展工作"])
("kvhf" ["愧恨"])
("kvho" ["魁祸"])
("kvhw" ["葵花"])
("kvji" ["会计"])
("kvjw" ["盔甲"])
("kvks" ["亏空"])
("kvlj" ["溃烂"])
("kvlz" ["傀儡"])
("kvq'" "亏盔岿窥悝")
("kvqd" ["抗张强度"])
("kvr'" "馈愧溃匮蒉喟愦聩篑")
("kvrk" ["脍炙人口"])
("kvsi" ["窥伺"])
("kvsj" ["溃散"])
("kvsp" ["亏损"])
("kvss" ["馈送"])
("kvt'" ["控制台"])
("kvtv" ["溃退"])
("kvu'" ["控制室"])
("kvub" ["魁首"])
("kvui" ["窥视"])
("kvw'" "葵奎魁馗夔隗揆喹逵暌睽蝰")
("kvwu" ["魁梧"])
("kvwz" ["魁伟"])
("kvxn" ["亏心"])
("kvyh" ["溃疡"])
("kvz'" ["快中子"])
("kvzg" ["馈赠"])
("kwbk" ["挎包"])
("kwd'" ["卡翁达"])
("kwda" ["夸大"])
("kwdu" ["跨度"])
("kwe'" "垮侉")
("kwgo" ["跨过"])
("kwjd" ["夸奖"])
("kwkb" ["夸口"])
("kwlj" ["跨栏"])
("kwq'" "夸")
("kwr'" "挎跨胯")
("kws'" ["苦味酸"])
("kwt'" ["科威特"])
("kwtl" ["垮台" "跨台"])
("kwto" ["夸脱"])
("kwv'" ["矿物质"])
("kwvh" ["夸张"])
("kwx'" ["开玩笑" "矿物学"])
("kwy'" ["矿物油"])
("kwyk" ["夸耀"])
("kwyt" ["跨越"])
("kx'" ["科学"])
("kxev" ["可想而知"])
("kxgl" ["科学管理"])
("kxh'" ["科学化"])
("kxi'" ["开小差"])
("kxj'" ["苛性钾" "苛性碱" "科学家" "科学界"])
("kxju" ["科学技术"])
("kxn'" ["苛性钠"])
("kxuy" ["科学社会主义"])
("kxv'" ["空心砖"])
("kxx'" ["可行性"])
("kxy'" ["科学院"])
("kxyj" ["科学研究"])
("ky'" ["可以"])
("kyb'" ["科研部"])
("kybj" ["快板"])
("kybk" ["快报"])
("kybu" ["快步"])
("kycj" ["快餐"])
("kydk" ["快到"])
("kye'" "蒯")
("kyer" ["块儿"])
("kygf" ["块根"])
("kygj" ["快干" "快感"])
("kygs" ["快攻"])
("kyho" ["快活"])
("kyie" ["快车"])
("kyig" ["科研成果"])
("kyj'" ["扩音机"])
("kyjl" ["开源节流"])
("kyjy" ["块茎"])
("kykw" ["可有可无"])
("kyky" ["块块" "快快"])
("kyl'" ["阔叶林"])
("kyle" ["快乐"])
("kyma" ["快马"])
("kymf" ["快门"])
("kymj" ["快慢"])
("kymz" ["块煤"])
("kyq'" ["扩音器"])
("kyqd" ["抗压强度"])
("kyr'" "块筷侩快会郐哙狯浍脍")
("kysu" ["快速"])
("kyty" ["快艇"])
("kyu'" ["阔叶树"])
("kyui" ["快事"])
("kyvd" ["块状"])
("kyw'" ["康有为"])
("kyyi" ["快意"])
("kyyk" ["快要"])
("kyz'" ["看样子"])
("kyzi" ["筷子"])
("kzml" ["开足马力"])
("l" "了")
("laba" ["拉巴" "喇叭"])
("labi" ["蜡笔"])
("labj" ["蜡版"])
("lade" ["拉得"])
("ladk" ["拉倒"])
("lado" ["拉多"])
("lady" ["拉丁"])
("lae'" "拉喇")
("lafu" ["拉夫" "拉幅"])
("lagj" ["拉杆"])
("lagr" ["拉管"])
("lahd" ["拉簧"])
("laie" ["拉车" "拉扯"])
("laih" ["拉长"])
("lajc" ["辣椒"])
("lajd" ["辣酱"])
("laji" ["垃圾"])
("lak'" ["拉奥孔"])
("lakl" ["拉开"])
("lali" ["拉力"])
("lalm" ["拉链"])
("lals" ["拉拢"])
("lama" ["喇嘛"])
("lamz" ["拉美" "腊梅"])
("lapy" ["拉平"])
("laq'" "垃拉喇啦邋")
("lar'" "拉蜡腊辣落剌瘌")
("las'" ["赖氨酸" "酪氨酸" "硫胺素"])
("lasa" ["拉萨"])
("lasi" ["拉丝"])
("lat'" "啦蓝")
("laub" ["拉手"])
("lauf" ["拉伸"])
("laui" ["拉屎"])
("lavi" ["拉制" "蜡纸"])
("lavu" ["蜡烛"])
("law'" "拉喇旯砬")
("laxi" ["拉稀"])
("layt" ["腊月"])
("lb'" ["利弊"])
("lbb'" ["冷冰冰"])
("lbbj" ["楼板"])
("lbbk" ["狼狈不堪" "搂抱"])
("lbcx" ["力不从心"])
("lbd'" ["了不得"])
("lbdb" ["漏斗"])
("lbdm" ["漏电"])
("lbds" ["漏洞"])
("lbdy" ["楼顶"])
("lbe'" ["搂" "篓" "嵝" "老伴儿"])
("lbfg" ["漏风"])
("lbfh" ["楼房"])
("lbgd" ["漏光"])
("lbge" ["楼阁"])
("lbgl" ["楼盖"])
("lbgu" ["蝼蛄"])
("lbh'" ["脸不红"])
("lbir" ["楼船"])
("lbiu" ["漏出"])
("lbj'" ["来不及" "淋巴结"])
("lbk'" ["喇叭口"])
("lbkp" ["牢不可破"])
("lbkx" ["李卜克内西"])
("lblk" ["罗布林卡"])
("lblp" ["礼拜六派"])
("lbly" ["利比里亚"])
("lbmm" ["楼面"])
("lbn'" ["黎巴嫩"])
("lbnz" ["楼内"])
("lbq'" ["搂" "了不起" "滤波器"])
("lbqi" ["漏气"])
("lbqp" ["楼群"])
("lbr'" "漏陋露镂瘘")
("lbs'" ["拉巴斯" "礼宾司"])
("lbsu" ["乐不思蜀"])
("lbt'" ["喽" "拉巴特" "罗伯特"])
("lbti" ["楼梯"])
("lbtl" ["楼台"])
("lbuh" ["楼上"])
("lbuk" ["漏勺"])
("lbuv" ["漏水" "漏税"])
("lbve" ["搂着"])
("lbw'" "楼娄偻蒌喽耧蝼髅")
("lbwh" ["漏网"])
("lbwj" ["狼狈为奸"])
("lbx'" ["老百姓" "六边形"])
("lbxb" ["淋巴细胞"])
("lbxi" ["陋习"])
("lbxm" ["漏馅"])
("lbxw" ["楼下" "漏下"])
("lby'" ["利比亚"])
("lbzi" ["漏字"])
("lcbp" ["乐此不疲"])
("lcck" ["潦草"])
("lcdb" ["料斗"])
("lcde" ["了得"])
("lcdk" ["料到"])
("lcdl" ["楞次定律"])
("lcds" ["辽东"])
("lce'" "燎潦了蓼钌")
("lcfa" ["疗法"])
("lche" ["辽河"])
("lcie" ["料车"])
("lcig" ["疗程"])
("lcj'" ["澜沧江" "励磁机"])
("lcjq" ["料酒"])
("lcjx" ["了结" "了解"])
("lckk" ["镣铐"])
("lcko" ["辽阔"])
("lclc" ["寥寥"])
("lcld" ["料量" "嘹亮"])
("lcli" ["料理"])
("lcny" ["辽宁"])
("lcq'" "撩撂")
("lcqi" ["料器"])
("lcr'" "撩了撂镣廖料尥钌")
("lcrk" ["缭绕"])
("lctm" ["聊天"])
("lcui" ["了事"])
("lcw'" "撩聊僚疗燎寥辽撂嘹獠寮缭鹩")
("lcwh" ["了望"])
("lcxc" ["疗效"])
("lcxd" ["料想"])
("lcxi" ["辽西"])
("lcyh" ["疗养" "辽阳"])
("lcyr" ["燎原"])
("lczi" ["料子"])
("ld'" ["领导"])
("ldba" ["两霸"])
("ldbd" ["辽东半岛"])
("ldbh" ["劳动保护"])
("ldbj" ["两班"])
("ldbm" ["两边" "量变"])
("ldbn" ["两鬓"])
("ldbx" ["劳动保险" "力多边形"])
("ldch" ["粮仓"])
("ldci" ["量词"])
("ldck" ["粮草"])
("ldde" ["劳动定额"])
("lddm" ["粮店"])
("lddr" ["两端"])
("lddu" ["量度" "亮度"])
("lddx" ["劳动对象"])
("lddy" ["路端电压"])
("lde'" "俩两魉")
("ldf'" ["劳动法"])
("ldfg" ["凉风"])
("ldfh" ["两方"])
("ldgd" ["两广" "亮光"])
("ldge" ["两个"])
("ldgf" ["劳动工分"])
("ldgh" ["量纲"])
("ldgi" ["劳动过程"])
("ldgj" ["劳动工具" "晾干"])
("ldgo" ["两国"])
("ldgv" ["量规"])
("ldgz" ["劳动改造"])
("ldh'" ["劳动化"])
("ldhe" ["两河"])
("ldhj" ["两汉"])
("ldhk" ["良好"])
("ldhu" ["两湖"])
("ldhy" ["两淮"])
("ldia" ["凉茶"])
("ldig" ["量程"])
("ldip" ["劳动产品"])
("ldis" ["两重"])
("ldj'" ["来得及"])
("ldjd" ["两江"])
("ldjg" ["垄断价格"])
("ldji" ["良机" "两极"])
("ldjl" ["劳动纪律"])
("ldjn" ["两晋"])
("ldjq" ["良久"])
("ldjs" ["劳动竞赛"])
("ldju" ["量具"])
("ldjx" ["谅解"])
("ldks" ["量控"])
("ldku" ["粮库"])
("ldky" ["凉快" "两块"])
("ldl'" ["劳动力" "劳动量"])
("ldlc" ["凉了"])
("ldli" ["两利" "两立" "量力"])
("ldlr" ["垄断利润"])
("ldlz" ["两肋" "两类"])
("ldm'" ["陆地棉"])
("ldmf" ["劳动模范"])
("ldmm" ["两面"])
("ldmn" ["良民"])
("ldmv" ["拉丁美洲"])
("ldmy" ["灵丹妙药"])
("ldn'" ["老大难" "老大娘"])
("ldnm" ["两年"])
("ldpc" ["粮票"])
("ldph" ["两旁"])
("ldpj" ["两潘"])
("ldpl" ["两排"])
("ldqd" ["劳动强度" "踉跄"])
("ldqi" ["两栖" "量器"])
("ldqm" ["两千"])
("ldqq" ["两求"])
("ldqv" ["劳动群众"])
("ldr'" ["凉" "辆" "量" "晾" "亮" "谅" "踉" "靓" "劳动日"])
("ldrf" ["良人"])
("ldrm" ["劳动人民"])
("ldtb" ["两头"])
("ldtc" ["两条"])
("ldth" ["亮堂"])
("ldtj" ["劳动条件" "立地条件"])
("ldtm" ["良田"])
("ldts" ["量筒"])
("ldub" ["两手"])
("ldud" ["凉爽"])
("ldui" ["劳动生产" "粮食"])
("lduj" ["劳动时间" "凉山" "梁山"])
("ldul" ["劳动生产力" "劳动生产率" "晾晒"])
("lduu" ["梁书"])
("lduv" ["凉水"])
("ldv'" ["劳动者" "李大钊"])
("ldve" ["两者"])
("ldvf" ["劳动致富"])
("ldvi" ["良知" "两只"])
("ldvs" ["良种" "两种"])
("ldw'" ["粮" "凉" "梁" "粱" "良" "量" "墚" "莨" "椋" "踉" "拉丁文"])
("ldxd" ["粮饷" "两相" "亮相"])
("ldxj" ["氯丁橡胶"])
("ldxn" ["良心"])
("ldxw" ["劳动新闻"])
("ldxx" ["凉鞋"])
("ldxy" ["良性" "两性" "量刑" "罗得西亚"])
("ldy'" ["老大爷" "略大于" "略低于"])
("ldyb" ["良友"])
("ldyh" ["两样"])
("ldyi" ["两伊" "两翼"])
("ldyk" ["良药"])
("ldyx" ["劳动英雄"])
("ldzb" ["流动资本" "垄断资本"])
("ldzi" ["量子"])
("ldzk" ["两造"])
("ldzl" ["劳动资料"])
("ldzm" ["拉丁字母"])
("ldzv" ["垄断组织"])
("lede" ["乐得"])
("legr" ["乐观"])
("lely" ["勒令"])
("leq'" "肋")
("lequ" ["乐趣"])
("ler'" "勒乐仂叻泐鳓")
("leso" ["勒索"])
("let'" "了")
("letm" ["乐天"])
("letu" ["乐土"])
("leuj" ["乐山"])
("leyi" ["乐意"])
("leyr" ["乐园"])
("leyu" ["乐于"])
("lfg'" ["立方根"])
("lfgz" ["林分改造"])
("lfjg" ["立法机关"])
("lfq'" ["立法权"])
("lft'" ["雷峰塔" "立方体"])
("lfy'" ["罗非鱼"])
("lfzw" ["绿肥作物"])
("lg'" ["两国"])
("lgb'" ["老干部"])
("lgch" ["冷藏"])
("lgdj" ["冷淡"])
("lgds" ["冷冻"])
("lge'" "冷")
("lgfg" ["冷风"])
("lggd" ["冷光"])
("lghj" ["冷汗"])
("lgj'" ["老规矩"])
("lgjc" ["棱角"])
("lgjg" ["连杆机构"])
("lgjy" ["棱镜" "冷静"])
("lgku" ["冷酷" "冷库"])
("lgl'" ["利滚利"])
("lglc" ["愣了"])
("lglo" ["冷落"])
("lgmo" ["冷漠"])
("lgnr" ["冷暖"])
("lgny" ["冷凝"])
("lgq'" ["棱" "芦沟桥" "泸沟桥"])
("lgqi" ["冷气"])
("lgqt" ["冷却"])
("lgr'" "愣")
("lgs'" ["拉各斯" "逻各斯"])
("lgtl" ["棱台"])
("lgtm" ["冷天"])
("lguj" ["冷杉"])
("lguv" ["冷水"])
("lgva" ["冷轧"])
("lgvj" ["冷战"])
("lgvu" ["棱柱" "楞住" "愣住"])
("lgvv" ["棱椎" "棱锥"])
("lgw'" "棱楞塄")
("lgx'" ["拉关系"])
("lgxc" ["冷笑"])
("lgy'" ["略高于"])
("lgyn" ["冷饮"])
("lgyu" ["冷遇"])
("lgzo" ["冷作"])
("lh'" ["联合"])
("lha'" ["氯化铵"])
("lhb'" ["拦河坝"])
("lhbz" ["狼狈"])
("lhdu" ["朗读"])
("lhe'" "朗")
("lhfh" ["廊坊"])
("lhfz" ["浪费"])
("lhg'" ["联合国" "氯化钙"])
("lhgb" ["狼狗" "联合公报"])
("lhge" ["朗格"])
("lhh'" ["联合会" "连环画" "硫化黑" "乱哄哄"])
("lhhw" ["浪花"])
("lhi'" ["流化床"])
("lhik" ["浪潮"])
("lhj'" ["联合机" "硫化碱" "氯化钾"])
("lhk'" ["氯化苦"])
("lhl'" ["氯化铝"])
("lhlh" ["朗朗"])
("lhlu" ["落花流水"])
("lhm'" ["氯化镁"])
("lhmj" ["浪漫"])
("lhn'" ["老黄牛" "硫化钠" "氯化钠"])
("lhq'" ["啷" "离合器" "硫化铅" "硫化氢" "氯化氢" "氯化氰"])
("lhr'" "郎浪莨蒗阆")
("lhrl" ["硫化染料"])
("lhss" ["朗诵"])
("lht'" ["氯化铁" "联合体"])
("lhtb" ["榔头" "浪头"])
("lhtk" ["浪涛"])
("lhu'" ["两回事"])
("lhum" ["联合声明"])
("lhv'" ["李鸿章" "联合制"])
("lhvf" ["联合政府"])
("lhvs" ["郎中"])
("lhw'" ["琅" "榔" "狼" "廊" "郎" "阆" "锒" "稂" "螂" "硫化物" "卤化物" "氯化物" "络合物"])
("lhx'" ["硫化锌" "氯化锌"])
("lhy'" ["赖汉英" "老花眼"])
("lhya" ["琅琊"])
("lhyx" ["氯化亚锡"])
("liag" ["里昂"])
("lian" ["立案"])
("lib'" ["里程碑"])
("liba" ["篱笆"])
("libi" ["利弊" "力臂"])
("libl" ["李白" "礼拜"])
("libm" ["里边"])
("libu" ["礼部" "吏部"])
("libx" ["离别"])
("lici" ["历次"])
("licl" ["理财" "理睬"])
("lid'" ["链传动"])
("lide" ["李德"])
("lidh" ["理当"])
("lidi" ["犁地" "立地"])
("lidl" ["里带" "历代"])
("lidm" ["力点"])
("lids" ["立冬"])
("lidu" ["粒度" "力度"])
("lidy" ["立定"])
("lie'" "理李里鲤礼哩俚悝澧逦娌锂蠡醴鳢")
("lifa" ["理发" "礼法" "历法" "立法"])
("lifh" ["立方"])
("lifu" ["礼服"])
("ligf" ["里根"])
("ligo" ["立国"])
("ligs" ["立功"])
("lihe" ["离合"])
("lihl" ["里海" "厉害" "利害"])
("lihp" ["离婚"])
("lihv" ["理会"])
("lihw" ["犁铧" "理化" "礼花"])
("liig" ["里程" "历程"])
("liih" ["立场" "力场"])
("liip" ["立春"])
("lijc" ["礼教" "立交"])
("lijd" ["漓江"])
("liji" ["里脊" "礼记" "利己" "痢疾" "立即" "力疾"])
("lijm" ["离间" "里间" "利剑"])
("lijn" ["厘金" "历尽"])
("liju" ["力矩"])
("lijw" ["离家" "里加"])
("lijx" ["离解" "理解" "礼节" "历届"])
("lijy" ["立井" "粒径"])
("like" ["理科" "立刻"])
("likl" ["离开"])
("lila" ["里拉"])
("lilc" ["理疗"])
("lild" ["力量"])
("lili" ["历历"])
("lill" ["历来"])
("lilo" ["利落"])
("lilp" ["理论" "立论"])
("lils" ["里弄"])
("lilv" ["利率"])
("lima" ["利马"])
("limi" ["厘米"])
("limk" ["礼貌"])
("limm" ["里面"])
("limn" ["利民"])
("limu" ["立木"])
("limy" ["黎明"])
("linm" ["历年"])
("lins" ["隶农"])
("liou" ["力偶"])
("lipg" ["李鹏"])
("lipn" ["礼品"])
("liq'" "哩")
("liqi" ["离奇" "利器" "力气"])
("liqq" ["立秋" "力求"])
("liqr" ["利权"])
("liqu" ["离去"])
("liqy" ["沥青"])
("lir'" "莉荔吏栗丽厉励砾历利傈例俐痢立粒沥隶力鬲俪郦坜苈莅藓呖唳猁溧枥栎轹戾砺詈疠疬蛎笠篥粝跞雳")
("lirf" ["里人" "历任" "利刃"])
("lirh" ["礼让"])
("lirp" ["利润"])
("liru" ["例如"])
("lisi" ["里斯" "立嗣"])
("lisj" ["离散"])
("liso" ["利索" "利嗦"])
("lit'" "璃哩")
("litb" ["里头"])
("lith" ["礼堂"])
("liti" ["例题" "立体"])
("litm" ["犁田"])
("lits" ["里通"])
("litu" ["力图"])
("liug" ["厘升" "厉声"])
("liui" ["理事" "历时" "历史" "立时" "立式"])
("liuu" ["梨树" "历书" "历数" "隶书" "隶属"])
("liuv" ["利税"])
("livb" ["立轴"])
("livd" ["粒状"])
("livg" ["例证" "立正" "力争"])
("livi" ["离职" "理智" "荔枝" "吏治" "立志"])
("livj" ["力战"])
("livu" ["立柱" "力主"])
("liw'" ["厘" "梨" "犁" "黎" "篱" "狸" "离" "漓" "丽" "璃" "蓠" "藜" "喱" "嫠" "骊" "缡" "罹" "鹂" "蜊" "蠡" "鲡" "黧" "李闯王"])
("liwj" ["李纨"])
("liwl" ["例外"])
("liwu" ["里屋" "礼物"])
("lix'" ["两重性"])
("lixd" ["理想"])
("lixi" ["离析" "利息" "力系"])
("lixm" ["离弦" "里弦" "立宪" "澧县"])
("lixn" ["离心" "立新"])
("lixq" ["离休"])
("lixr" ["粒选"])
("lixt" ["理学" "力学"])
("lixw" ["立夏"])
("lixy" ["理性" "厉行" "例行" "力行"])
("liyb" ["理由" "利诱"])
("liyh" ["溧阳"])
("liyi" ["礼仪" "利益" "立意" "力役"])
("liyj" ["立言"])
("liyr" ["梨园" "李渊"])
("liys" ["利用"])
("liyt" ["历月"])
("liyu" ["鲤鱼" "利于" "立于"])
("liyy" ["理应"])
("lizi" ["离子" "李子" "栗子" "例子" "粒子"])
("lizu" ["黎族" "立足"])
("lj'" ["立即"])
("ljbf" ["蓝本"])
("ljbg" ["屡教不改"])
("ljbu" ["蓝布"])
("ljbx" ["屡见不鲜"])
("ljd'" ["临界点"])
("ljdc" ["滥调"])
("ljde" ["懒得"])
("ljdm" ["蓝靛"])
("ljdo" ["懒惰"])
("lje'" "揽览懒缆漤榄罱")
("ljf'" ["龙卷风"])
("ljfa" ["滥伐"])
("ljfh" ["两极分化"])
("ljg'" ["冷加工" "两脚规" "龙济光"])
("ljgj" ["栏杆"])
("ljhe" ["拦河"])
("ljhj" ["懒汉"])
("ljhw" ["兰花"])
("lji'" ["龙井茶"])
("ljie" ["缆车"])
("ljj'" ["亮晶晶"])
("ljjx" ["拦截"])
("ljkk" ["兰考"])
("ljl'" ["理解力"])
("ljlu" ["拦路"])
("ljly" ["蓝领"])
("ljmj" ["烂漫"])
("ljmu" ["栏目"])
("ljni" ["烂泥"])
("ljq'" ["累加器" "量角器" "裂解气"])
("ljqk" ["了解情况"])
("ljqq" ["篮球"])
("ljr'" "烂滥")
("ljse" ["蓝色"])
("ljsi" ["兰斯"])
("ljsj" ["懒散"])
("ljsw" ["逻辑思维"])
("ljt'" ["零件图" "柳敬亭"])
("ljtm" ["蓝天"])
("ljtu" ["蓝图"])
("ljug" ["缆绳"])
("ljuj" ["阑珊" "逻辑设计"])
("ljvb" ["兰州"])
("ljvu" ["拦住"])
("ljvy" ["利己主义"])
("ljw'" "蓝婪栏拦篮阑兰澜谰岚斓镧褴")
("ljwd" ["临界温度"])
("ljwh" ["拦网"])
("ljwz" ["阑尾"])
("ljx'" ["逻辑学" "逻辑性"])
("ljxi" ["兰溪"])
("ljy'" ["临界压" "陆九渊"])
("ljyd" ["灵机一动"])
("ljyk" ["拦腰"])
("ljys" ["滥用"])
("ljzi" ["篮子" "览子"])
("ljzk" ["蓝藻"])
("ljzu" ["拦阻"])
("lk'" ["立刻"])
("lkb'" ["立枯病"])
("lkbj" ["老板" "老伴"])
("lkbk" ["劳保"])
("lkbo" ["老伯"])
("lkby" ["老兵"])
("lkbz" ["老辈"])
("lkcl" ["老财"])
("lkda" ["老大"])
("lkdi" ["老底" "老弟"])
("lkdk" ["老道" "唠叨"])
("lkds" ["劳动"])
("lkdx" ["老爹"])
("lke'" "老佬姥潦栳铑")
("lkf'" ["磷矿粉"])
("lkfh" ["牢房"])
("lkfl" ["洛克菲勒"])
("lkfu" ["老夫"])
("lkgk" ["老高"])
("lkgl" ["劳改"])
("lkgs" ["劳工" "老公"])
("lkgu" ["牢固"])
("lkhj" ["老汉"])
("lkhu" ["老虎"])
("lkhw" ["老化" "老话"])
("lkig" ["老成"])
("lkih" ["老长"])
("lkjd" ["老将"])
("lkji" ["牢记"])
("lkjq" ["老酒"])
("lkjw" ["劳驾" "老家"])
("lkkk" ["牢靠"])
("lkku" ["劳苦"])
("lklc" ["老了"])
("lkli" ["劳力" "旅客列车"])
("lklk" ["牢牢" "老老" "姥姥"])
("lklm" ["老练"])
("lkln" ["老林"])
("lkls" ["牢笼"])
("lklu" ["老路"])
("lklz" ["劳累"])
("lkml" ["老迈"])
("lkmo" ["劳模"])
("lkmy" ["老命"])
("lknd" ["老娘"])
("lknm" ["老年"])
("lkns" ["老农"])
("lkpl" ["老牌"])
("lkpo" ["老婆"])
("lkq'" "捞")
("lkqi" ["老气"])
("lkqu" ["捞取" "老区"])
("lkr'" "酪烙涝落络唠耢")
("lkrf" ["老人"])
("lkro" ["老弱"])
("lksk" ["牢骚"])
("lksr" ["酪酸"])
("lktb" ["老头"])
("lktx" ["烙铁"])
("lkub" ["老手"])
("lkue" ["老舍"])
("lkui" ["老师" "老实" "老式" "老是"])
("lkuk" ["老少"])
("lkuo" ["老说"])
("lkuu" ["老叔" "老鼠"])
("lkve" ["老者"])
("lkw'" "劳牢唠崂铹痨醪")
("lkwg" ["老翁"])
("lkwh" ["老王"])
("lkwo" ["老挝"])
("lkwu" ["劳务"])
("lkxc" ["老小"])
("lkxd" ["老乡"])
("lkxq" ["老朽"])
("lkxs" ["老兄"])
("lkyb" ["老友"])
("lkye" ["老爷"])
("lkyi" ["劳役"])
("lkyk" ["老幺"])
("lkyn" ["烙印"])
("lkyr" ["老远"])
("lkyu" ["牢狱"])
("lkyy" ["老鹰" "老营"])
("lkz'" ["两口子"])
("lkzi" ["劳资" "老子"])
("lkzk" ["老早"])
("lkzl" ["涝灾"])
("lkzo" ["劳作"])
("lkzs" ["老总"])
("ll'" ["理论"])
("llan" ["来安"])
("llbn" ["来宾"])
("lld'" ["冷冷的" "绿绿的"])
("lldb" ["力量对比"])
("llde" ["来得"])
("lldf" ["落落大方"])
("lldk" ["来到"])
("lldm" ["来电"])
("llex" ["量力而行"])
("llfh" ["来访"])
("llfj" ["来犯"])
("llfu" ["来复"])
("llgk" ["来稿"])
("llgo" ["来过"])
("llgv" ["来归"])
("llh'" ["拦路虎"])
("llhj" ["来函"])
("llhv" ["来回"])
("lli'" ["琉璃厂"])
("lljd" ["来讲"])
("lljv" ["淋漓尽致"])
("lljy" ["来京"])
("llke" ["来客"])
("llkj" ["来看"])
("lll'" ["六六六"])
("llli" ["来历"])
("llln" ["来临"])
("lllu" ["来路"])
("llmo" ["来没"])
("llnm" ["来年"])
("llpi" ["赖皮"])
("llqm" ["来龙去脉"])
("llqq" ["冷冷清清"])
("llqu" ["来去"])
("llr'" "赖濑赉睐癞籁")
("llrf" ["来人"])
("llri" ["来日"])
("lls'" ["劳伦斯"])
("llss" ["零零碎碎"])
("llte" ["莱特"])
("llti" ["来体"])
("llu'" ["林虑山"])
("llug" ["来生"])
("llui" ["来世" "来势"])
("lluo" ["来说"])
("llus" ["流离失所"])
("lluu" ["来书" "老老实实"])
("llv'" ["律历志"])
("llve" ["来者" "来着"])
("llvh" ["赖帐"])
("llvk" ["来照"])
("llvw" ["来抓"])
("llw'" "莱来崃徕涞铼")
("llwh" ["来往"])
("llww" ["里里外外" "来来往往"])
("llx'" ["伦理学"])
("llxn" ["莱辛" "来信"])
("llyb" ["来由"])
("llyh" ["莱阳"])
("llyi" ["来意"])
("llyr" ["来源"])
("llzi" ["来自"])
("lm'" ["厘米"])
("lmai" ["恋爱"])
("lmb'" ["老毛病"])
("lmbd" ["联绵不断"])
("lmbf" ["联苯"])
("lmbh" ["联邦"])
("lmbo" ["联播"])
("lmby" ["练兵"])
("lmci" ["连词"])
("lmd'" ["利玛窦" "灵敏度"])
("lmda" ["联大" "连打"])
("lmdg" ["罗马帝国"])
("lmdj" ["脸蛋" "炼丹"])
("lmdk" ["镰刀"])
("lmdl" ["连带"])
("lmdv" ["连队"])
("lme'" "敛脸蔹琏裣")
("lmf'" ["罗马法"])
("lmfa" ["连发"])
("lmfh" ["联防" "林木分化"])
("lmgh" ["炼钢"])
("lmgj" ["连杆"])
("lmgr" ["联贯" "连贯"])
("lmgs" ["联共" "练功"])
("lmhe" ["联合"])
("lmhr" ["联欢" "连环"])
("lmhs" ["脸红"])
("lmhw" ["莲花"])
("lmig" ["连乘"])
("lmih" ["连长"])
("lmii" ["廉耻"])
("lmir" ["连串"])
("lmj'" ["龙门架"])
("lmjc" ["炼焦"])
("lmji" ["联机"])
("lmjp" ["联军"])
("lmjq" ["练就"])
("lmjw" ["廉价" "脸颊"])
("lmjx" ["联接" "联结" "连接" "廉洁"])
("lmlm" ["连连"])
("lmlo" ["联络"])
("lmlp" ["链轮"])
("lmlz" ["连累"])
("lmmg" ["联盟"])
("lmmh" ["连忙"])
("lmmm" ["连绵" "脸面"])
("lmmn" ["怜悯"])
("lmmy" ["联名"])
("lmnf" ["罗蒙诺索夫"])
("lmnm" ["连年"])
("lmny" ["罗马尼亚"])
("lmp'" ["两面派"])
("lmpf" ["脸盆"])
("lmpg" ["莲蓬"])
("lmph" ["脸庞"])
("lmpi" ["连皮" "脸皮"])
("lmpl" ["连排"])
("lmpm" ["连篇"])
("lmpu" ["脸谱"])
("lmqq" ["链球"])
("lmr'" "链恋炼练潋楝殓")
("lmrf" ["连任"])
("lmri" ["连日"])
("lmru" ["炼乳"])
("lmsd" ["两面三刀"])
("lmse" ["脸色"])
("lmsl" ["联赛"])
("lmso" ["联锁" "连锁"])
("lmt'" ["立面图"])
("lmtc" ["链条"])
("lmtm" ["连天"])
("lmts" ["连通" "连同"])
("lmtx" ["炼铁"])
("lmu'" ["两码事"])
("lmug" ["连声"])
("lmui" ["链式"])
("lmuz" ["罗马数字"])
("lmvi" ["炼制"])
("lmvy" ["浪漫主义"])
("lmw'" "联莲连镰廉怜涟帘奁濂臁裢蠊鲢")
("lmwh" ["联网"])
("lmwu" ["练武"])
("lmx'" ["两面性"])
("lmxd" ["联想"])
("lmxi" ["联系" "练习"])
("lmxn" ["连心"])
("lmxu" ["连续"])
("lmxx" ["连写"])
("lmyb" ["炼油"])
("lmye" ["连夜"])
("lmyn" ["连音"])
("lmyp" ["联运"])
("lmys" ["连用"])
("lmyu" ["鲢鱼"])
("lmyy" ["联营"])
("lmz'" ["老妈子"])
("lmzi" ["莲子" "帘子" "脸子" "链子"])
("lmzl" ["连载"])
("lmzo" ["连作" "连坐"])
("lmzu" ["联组"])
("lnan" ["临安"])
("lnba" ["淋巴"])
("lnbh" ["邻邦"])
("lndi" ["林地"])
("lndk" ["临到"])
("lndl" ["林带"])
("lne'" "凛廪懔檩")
("lnff" ["林分" "临汾"])
("lnfz" ["磷肥"])
("lngd" ["磷光"])
("lngl" ["列甯格勒"])
("lngo" ["邻国"])
("lngr" ["林冠"])
("lnhl" ["林海" "临海"])
("lnid" ["临床"])
("lnih" ["林场"])
("lnjn" ["临近" "邻近"])
("lnju" ["邻居"])
("lnjx" ["临界" "邻接"])
("lnjy" ["鳞茎"])
("lnlh" ["琳琅"])
("lnli" ["林立" "邻里" "淋漓"])
("lnln" ["淋淋" "凛凛"])
("lnlx" ["凛冽"])
("lnly" ["林龄"])
("lnmo" ["临摹"])
("lnmu" ["林木"])
("lnn'" ["老奶奶"])
("lnpm" ["鳞片"])
("lnqj" ["列宁全集"])
("lnqu" ["林区"])
("lnqw" ["林卡"])
("lnqy" ["临清"])
("lnr'" "淋赁吝蔺膦躏")
("lnse" ["吝啬"])
("lnsi" ["临死"])
("lnsr" ["磷酸"])
("lntb" ["临头"])
("lntc" ["檩条"])
("lnu'" ["雷诺数" "辽宁省"])
("lnui" ["临时"])
("lnuv" ["临水"])
("lnvf" ["临阵"])
("lnvi" ["磷脂"])
("lnvs" ["林钟" "临终"])
("lnvy" ["列宁主义"])
("lnw'" "琳林磷霖临邻鳞淋秘啉嶙遴辚瞵粼麟")
("lnxd" ["林相"])
("lnxi" ["淋洗" "吝惜"])
("lnxj" ["列宁选集"])
("lnxm" ["林县"])
("lnxt" ["林学"])
("lnxw" ["林下"])
("lnxy" ["临刑" "临行"])
("lnye" ["林业"])
("lnyu" ["淋浴"])
("lnzi" ["林子"])
("lobi" ["落笔"])
("lobo" ["萝卜"])
("lode" ["落得"])
("lodi" ["落地" "落第"])
("lodj" ["罗丹"])
("lodk" ["落到"])
("lodm" ["落点"])
("lody" ["螺钉"])
("loe'" "裸倮蠃瘰")
("lofu" ["洛夫"])
("logu" ["锣鼓"])
("lohb" ["落后"])
("lohe" ["络合"])
("lohj" ["罗汉"])
("lohu" ["落户"])
("lohw" ["落花"])
("loia" ["落差"])
("loig" ["落成"])
("loiv" ["落锤"])
("lojc" ["落脚"])
("loji" ["逻辑"])
("loju" ["螺距"])
("lojy" ["罗经"])
("lokd" ["箩筐" "落矿"])
("loke" ["洛克"])
("loks" ["落空"])
("lola" ["罗拉"])
("lolj" ["洛兰"])
("loln" ["洛林"])
("lolo" ["罗罗" "落落"])
("lolu" ["裸露"])
("lolx" ["罗列"])
("lolz" ["落泪"])
("loma" ["罗马" "骡马"])
("lomk" ["螺帽"])
("lomu" ["螺母"])
("lomz" ["洛美"])
("lopj" ["罗盘"])
("loq'" "罗落捋")
("lor'" "咯烙落洛骆络荦摞泺漯珞硌雒")
("lori" ["落日"])
("losi" ["螺丝" "罗斯"])
("loso" ["罗嗦"])
("losu" ["罗素"])
("lot'" "咯罗")
("loti" ["裸体" "落体"])
("loto" ["骆驼"])
("loui" ["落实"])
("lour" ["螺栓"])
("louv" ["落水"])
("love" ["落着"])
("lovi" ["罗织"])
("low'" "萝螺罗逻锣箩骡猡椤脶镙")
("lowf" ["螺纹" "罗纹"])
("lowh" ["罗网"])
("lowu" ["落伍"])
("loxm" ["螺线" "裸线" "络线"])
("loxr" ["螺旋" "落选"])
("loxw" ["落下"])
("loye" ["落叶"])
("loyh" ["洛阳"])
("loyi" ["洛伊"])
("loyu" ["落雨"])
("lozi" ["骡子"])
("lozl" ["落在"])
("lpbj" ["轮班"])
("lpdc" ["论调"])
("lpdk" ["轮到"])
("lpdl" ["轮带"])
("lpdm" ["论点"])
("lpdp" ["伦敦"])
("lpdr" ["论断"])
("lpdu" ["轮渡"])
("lpdv" ["轮对"])
("lpfj" ["轮番"])
("lpgu" ["轮毂"])
("lphg" ["论衡"])
("lphr" ["轮换"])
("lphv" ["轮回"])
("lpih" ["伦常"])
("lpii" ["轮齿"])
("lpir" ["轮船"])
("lpis" ["轮虫"])
("lpiu" ["论处"])
("lpji" ["轮机"])
("lpju" ["论据"])
("lpjw" ["论价"])
("lpko" ["轮廓"])
("lpli" ["伦理" "论理"])
("lplq" ["轮流"])
("lplx" ["论列"])
("lpp'" ["老婆婆"])
("lppj" ["轮盘"])
("lpq'" "抡")
("lpqn" ["伦琴"])
("lpr'" "论")
("lptj" ["论坛"])
("lptl" ["轮胎"])
("lpuo" ["论说"])
("lpuu" ["论述"])
("lpvb" ["轮轴"])
("lpvg" ["论争" "论证"])
("lpvj" ["论战"])
("lpvr" ["轮转"])
("lpvu" ["论著"])
("lpw'" "抡轮伦仑沦纶论囵")
("lpwf" ["论文"])
("lpwz" ["沦为"])
("lpxm" ["沦陷"])
("lpxp" ["轮训"])
("lpyu" ["论语"])
("lpz'" ["老婆子"])
("lpzi" ["轮子"])
("lpzo" ["轮作"])
("lpzv" ["论罪"])
("lqb'" ["老前辈"])
("lqbh" ["刘邦"])
("lqbi" ["流弊"])
("lqbu" ["六部"])
("lqby" ["溜冰"])
("lqbz" ["刘备" "乱七八糟"])
("lqci" ["六次"])
("lqcp" ["留存"])
("lqdc" ["溜掉"])
("lqdj" ["榴弹"])
("lqdk" ["六道"])
("lqdm" ["留点"])
("lqds" ["流动"])
("lqdu" ["流毒" "六度"])
("lqe'" "柳绺锍")
("lqfa" ["六法"])
("lqfh" ["流放"])
("lqge" ["六个"])
("lqgf" ["六根"])
("lqgj" ["流感"])
("lqgz" ["留给"])
("lqhd" ["硫磺"])
("lqhw" ["硫化"])
("lqi'" ["梁启超"])
("lqig" ["流程"])
("lqih" ["流畅"])
("lqij" ["流产"])
("lqik" ["六朝"])
("lqir" ["留传" "流传"])
("lqj'" ["链球菌"])
("lqjc" ["六角"])
("lqji" ["留级"])
("lqjn" ["流尽"])
("lqjp" ["六军"])
("lqjw" ["六家"])
("lqjy" ["溜井" "六经"])
("lqkb" ["流寇"])
("lqks" ["留空"])
("lqld" ["流量"])
("lqlh" ["流浪"])
("lqli" ["琉璃" "流离" "流利"])
("lqlm" ["留连" "留恋"])
("lqlo" ["流落"])
("lqlu" ["流露"])
("lqmh" ["流氓"])
("lqmn" ["流民"])
("lqnm" ["留念"])
("lqpl" ["流派"])
("lqq'" ["溜" "熘" "冷却器"])
("lqqn" ["柳琴"])
("lqqy" ["留情"])
("lqr'" "溜馏六碌陆遛镏鹨")
("lqrf" ["留任" "流人"])
("lqsj" ["流散"])
("lqsr" ["硫酸"])
("lqsu" ["流速"])
("lqtc" ["柳条" "六条"])
("lqti" ["流体"])
("lqts" ["流通"])
("lqu'" ["罗钦顺"])
("lqua" ["流沙"])
("lqub" ["留守"])
("lquf" ["留神"])
("lqui" ["流失" "六师" "六十"])
("lquj" ["柳杉"])
("lquu" ["柳树"])
("lquv" ["流水"])
("lqux" ["伦琴射线"])
("lqvb" ["柳州"])
("lqvf" ["六镇"])
("lqvi" ["留职" "留置" "柳枝"])
("lqvr" ["流转"])
("lqvu" ["留住"])
("lqw'" "琉榴硫馏留刘瘤流浏遛骝旒镏鎏")
("lqwh" ["流亡" "流网"])
("lqxm" ["流线"])
("lqxn" ["留心"])
("lqxt" ["留学" "流血"])
("lqxw" ["留下"])
("lqxy" ["流星" "流行"])
("lqyh" ["浏阳"])
("lqyi" ["留意" "六艺"])
("lqyj" ["留言" "流言"])
("lqys" ["留用"])
("lqyt" ["六月"])
("lqyu" ["流域"])
("lqyy" ["留影"])
("lqzb" ["溜走"])
("lqzi" ["溜子"])
("lr'" ["例如"])
("lrds" ["乱动"])
("lre'" "卵")
("lrfi" ["来日方长"])
("lrgk" ["乱搞"])
("lrhd" ["卵黄"])
("lrik" ["卵巢"])
("lrj'" ["老人家"])
("lrky" ["卵块"])
("lrl'" ["利润率"])
("lrlh" ["来人来函"])
("lrli" ["利润留成"])
("lrll" ["乱来"])
("lrlx" ["卵裂"])
("lrpk" ["卵泡" "乱跑"])
("lrq'" ["量热器" "罗瑞卿"])
("lrr'" "乱")
("lrt'" ["陆荣廷"])
("lrug" ["孪生" "卵生"])
("lrui" ["卵石" "乱世"])
("lruo" ["乱说"])
("lrvb" ["滦州"])
("lrvf" ["乱真"])
("lrvv" ["了如指掌"])
("lrw'" "峦挛孪滦脔娈栾鸾銮")
("lrxy" ["卵形"])
("lrzb" ["乱走"])
("lrzi" ["卵子" "乱子"])
("ls'" ["类似"])
("lsa'" ["硫酸铵"])
("lsb'" ["硫酸钡" "卢森堡"])
("lsd'" ["螺丝钉"])
("lsdr" ["理所当然" "垄断"])
("lsds" ["隆冬"])
("lse'" ["笼" "垄" "拢" "陇" "垅" "拉萨尔"])
("lsfg" ["龙凤"])
("lsfy" ["连锁反应"])
("lsg'" ["磷酸钙" "硫酸钙"])
("lsgs" ["龙宫"])
("lsgu" ["龙骨"])
("lshu" ["龙虎"])
("lsj'" ["硫酸钾" "氯酸钾" "滤色镜"])
("lsjd" ["龙江"])
("lsju" ["龙驹"])
("lsjy" ["龙井"])
("lsk'" ["腊斯克" "卢萨卡"])
("lskb" ["龙口"])
("lsl'" ["硫酸铝"])
("lslo" ["笼络"])
("lsls" ["隆隆"])
("lsm'" ["硫酸镁" "螺丝帽"])
("lsmf" ["龙门"])
("lsn'" ["磷酸钠" "硫酸钠"])
("lsnj" ["力所能及"])
("lsnm" ["龙年"])
("lspk" ["龙袍"])
("lsq'" "隆")
("lsqi" ["隆起"])
("lsr'" "弄")
("lst'" ["硫酸铜"])
("lstb" ["龙头"])
("lstf" ["罗斯托夫"])
("lstk" ["龙套"])
("lsts" ["笼统"])
("lsu'" ["拉萨市"])
("lsuj" ["龙山"])
("lsvk" ["笼罩"])
("lsvs" ["龙种" "隆重"])
("lsvw" ["绿色植物"])
("lsw'" "龙聋咙笼窿隆茏泷珑栊胧砻癃")
("lswh" ["龙王"])
("lsx'" ["硫酸锌"])
("lsxi" ["龙溪"])
("lsy'" ["磷酸盐" "硫酸盐"])
("lsya" ["聋哑"])
("lsyj" ["龙岩" "龙眼"])
("lsyt" ["硫酸亚铁"])
("lszi" ["聋子" "笼子"])
("lt'" ["例题"])
("ltb'" ["论坛报"])
("ltdl" ["两条道路" "略带"])
("ltdo" ["掠夺"])
("lte'" ["掠" "老头儿"])
("ltfy" ["流通费用"])
("ltgo" ["掠过"])
("ltjh" ["立体几何"])
("ltjw" ["略加"])
("ltk'" ["硫铁矿" "露天矿" "铝土矿"])
("ltkc" ["露天开采"])
("ltl'" ["炼铁炉"])
("ltlt" ["略略"])
("ltly" ["流通领域"])
("ltp'" ["老太婆"])
("ltq'" ["连通器"])
("ltqu" ["掠取" "略去"])
("ltr'" "掠略锊")
("ltt'" ["老太太" "立体图"])
("lttl" ["两条腿走路"])
("lttu" ["略图"])
("ltu'" ["立体声" "路透社"])
("ltud" ["流通手段"])
("ltvi" ["略知"])
("ltwz" ["略微"])
("lty'" ["老太爷" "老天爷"])
("ltyh" ["略阳"])
("ltz'" ["老头子"])
("lu'" ["历史"])
("luan" ["六安"])
("lub'" ["梁山伯"])
("lubc" ["路标"])
("lubi" ["卢比"])
("lubj" ["鲁班"])
("lubl" ["露白"])
("lubm" ["路边"])
("lubu" ["卢布"])
("lubz" ["路北"])
("ludb" ["临时代办"])
("lude" ["路德"])
("ludg" ["路灯"])
("ludi" ["陆地"])
("ludm" ["露点"])
("ludr" ["路段"])
("ludy" ["炉顶"])
("lue'" "芦掳卤虏鲁橹镥")
("luf'" ["老师傅"])
("lufg" ["陆丰"])
("lufy" ["链式反应"])
("lufz" ["路费"])
("lug'" ["临时工" "领事馆" "落水狗"])
("lugf" ["芦根"])
("lugh" ["鹿港"])
("lugo" ["路过"])
("lugr" ["炉管"])
("lugu" ["颅骨" "露骨" "陆贾"])
("luh'" ["理事会" "露水河"])
("luho" ["炉火"])
("luhv" ["炉灰"])
("luhw" ["芦花" "卤化"])
("luif" ["炉衬"])
("luig" ["路程"])
("luil" ["历史潮流"])
("luit" ["老生常谈"])
("luiu" ["露出"])
("luj'" ["历史剧" "留声机" "洛杉矶"])
("lujd" ["庐江"])
("lujg" ["零售价格"])
("luji" ["路基"])
("lujp" ["陆军"])
("luju" ["路局"])
("lujy" ["路径"])
("lukb" ["路口"])
("lukd" ["路矿"])
("lulc" ["炉料"])
("luln" ["绿林"])
("lult" ["掳掠"])
("lulu" ["碌碌" "陆路" "陆陆" "辘轳"])
("luly" ["烈士陵园"])
("lum'" ["李世民"])
("lumf" ["炉门"])
("lumh" ["鲁莽"])
("lumm" ["露面" "路面"])
("luq'" ["撸" "噜" "刘少奇"])
("luqm" ["路签"])
("luqu" ["录取"])
("lur'" "六麓碌露路赂鹿潞禄录陆戮绿蓼渌漉逯璐辂辘鹭簏")
("lurf" ["路人"])
("lurs" ["鹿茸"])
("luru" ["录入"])
("lusu" ["卤素"])
("lut'" "轳氇")
("lutb" ["露头"])
("luth" ["炉膛"])
("lutm" ["露天"])
("lutu" ["路途"])
("luug" ["芦笙"])
("luuh" ["路上"])
("luuj" ["庐山"])
("luuu" ["路数"])
("luuv" ["卤水" "露水"])
("luv'" ["李时珍"])
("luva" ["炉渣"])
("luvb" ["庐州" "泸州"])
("luvi" ["录制"])
("luvj" ["陆战"])
("luvu" ["露珠"])
("luw'" ["芦" "卢" "颅" "庐" "炉" "垆" "泸" "栌" "轳" "胪" "鸬" "舻" "鲈" "林爽文"])
("luwf" ["炉温"])
("luwh" ["龙山文化"])
("luwz" ["芦苇"])
("lux'" ["历史性" "流水线"])
("luxi" ["芦席"])
("luxm" ["路线"])
("luxp" ["鲁迅"])
("luxu" ["陆续"])
("luyb" ["陆游"])
("luyi" ["路易"])
("luym" ["老少爷们"])
("luyn" ["录音"])
("luys" ["录用"])
("luyu" ["鲈鱼"])
("luyy" ["历史意义" "露营" "良师益友"])
("luzi" ["炉子" "路子"])
("luzk" ["炉灶"])
("luzu" ["卤族"])
("luzw" ["粮食作物"])
("luzy" ["流水作业"])
("lv'" ["两者"])
("lvbd" ["雷州半岛"])
("lvbf" ["氯苯"])
("lvbj" ["来者不拒"])
("lvbo" ["铝箔" "滤波"])
("lvby" ["来之不易"])
("lvci" ["屡次"])
("lvda" ["旅大"])
("lvdb" ["绿豆"])
("lvdg" ["绿灯"])
("lvdi" ["绿地"])
("lvdl" ["履带"])
("lvdm" ["旅店"])
("lve'" "吕铝侣旅履屡缕偻捋膂稆褛")
("lvfh" ["氯仿"])
("lvfj" ["绿矾"])
("lvfz" ["旅费" "绿肥"])
("lvgo" ["滤过"])
("lvgr" ["旅馆"])
("lvhu" ["铝壶"])
("lvhw" ["氯化" "绿化"])
("lvia" ["绿茶"])
("lvig" ["旅程"])
("lvii" ["滤池"])
("lvj'" ["联轴节"])
("lvju" ["旅居"])
("lvke" ["旅客"])
("lvli" ["履历" "律例"])
("lvlp" ["氯纶"])
("lvlv" ["缕缕" "律吕"])
("lvly" ["律令"])
("lvq'" ["老中青"])
("lvqi" ["氯气" "滤器"])
("lvqv" ["理直气壮"])
("lvqy" ["滤清"])
("lvr'" "虑氯律率滤绿")
("lvse" ["绿色"])
("lvsr" ["氯酸"])
("lvtu" ["旅途"])
("lvu'" ["兰州市"])
("lvue" ["旅社"])
("lvui" ["律师" "律诗"])
("lvuk" ["铝勺"])
("lvup" ["旅顺"])
("lvuv" ["绿水"])
("lvuy" ["力争上游"])
("lvvb" ["绿洲"])
("lvvh" ["旅长"])
("lvvi" ["铝制" "滤纸"])
("lvvu" ["绿竹"])
("lvw'" "驴闾榈")
("lvx'" ["陆征祥"])
("lvxy" ["旅行" "履行"])
("lvy'" ["雷阵雨"])
("lvyb" ["旅游"])
("lvye" ["滤液" "绿叶"])
("lvyn" ["绿荫"])
("lvyt" ["履约"])
("lvyy" ["绿营"])
("lvzk" ["绿藻"])
("lw'" ["另外"])
("lwbj" ["临危不惧"])
("lwd'" ["梁武帝"])
("lwe'" "俩")
("lwrf" ["俩人"])
("lwx'" ["拉瓦锡"])
("lx'" ["联系"])
("lxap" ["另行安排"])
("lxb'" ["卵细胞"])
("lxbm" ["裂变"])
("lxd'" ["旅行袋"])
("lxdg" ["劣等"])
("lxdv" ["列队" "路线斗争"])
("lxe'" "裂咧")
("lxfg" ["裂缝"])
("lxfu" ["列夫"])
("lxg'" ["联系国" "龙须沟" "螺线管"])
("lxgb" ["猎狗"])
("lxgo" ["列国"])
("lxgp" ["连续光谱"])
("lxgu" ["例行公事"])
("lxhf" ["裂痕"])
("lxho" ["烈火" "猎获"])
("lxhu" ["连续函数" "劣弧"])
("lxhw" ["裂化"])
("lxhy" ["联席会议"])
("lxie" ["列车"])
("lxiu" ["列出"])
("lxj'" ["离心机" "李香君" "录像机" "螺旋桨"])
("lxji" ["劣迹"])
("lxju" ["列举"])
("lxjx" ["裂解"])
("lxjy" ["厉行节约"])
("lxkb" ["裂口"])
("lxkl" ["裂开"])
("lxl'" ["离心力"])
("lxnv" ["烈女"])
("lxny" ["列宁"])
("lxp'" ["立宪派"])
("lxpm" ["裂片"])
("lxq'" ["咧" "练习曲" "林祥谦"])
("lxqd" ["列强" "猎枪"])
("lxqr" ["猎犬"])
("lxqu" ["猎取"])
("lxqv" ["联系群众"])
("lxr'" ["列" "裂" "烈" "劣" "猎" "冽" "埒" "捩" "洌" "趔" "躐" "鬣" "联系人"])
("lxrf" ["猎人"])
("lxri" ["烈日"])
("lxru" ["理性认识" "列入"])
("lxt'" ["咧" "类星体" "罗星塔"])
("lxtl" ["兰新铁路"])
("lxtv" ["另行通知"])
("lxu'" ["老先生" "留学生"])
("lxub" ["猎手"])
("lxuf" ["劣绅"])
("lxui" ["连续生产" "烈士" "劣势"])
("lxuj" ["联系实际"])
("lxuu" ["烈属"])
("lxvi" ["劣质"])
("lxvr" ["列传"])
("lxvv" ["理想主义者"])
("lxvy" ["理想主义"])
("lxwf" ["裂纹"])
("lxwz" ["列为"])
("lxx'" ["流线型" "螺旋线"])
("lxxi" ["列席" "裂隙"])
("lxxu" ["流血牺牲"])
("lxxy" ["烈性"])
("lxy'" ["流行于"])
("lxyd" ["立宪运动"])
("lxzd" ["联想字典"])
("lxzi" ["列子"])
("ly'" ["利用"])
("lya'" ["窿缘桉"])
("lyb'" ["老一辈" "林业部"])
("lybj" ["络绎不绝"])
("lybk" ["灵宝"])
("lyd'" ["利雅得"])
("lydh" ["铃铛"])
("lydi" ["领地" "令弟"])
("lydk" ["领导" "领道"])
("lydl" ["领带"])
("lydm" ["零点"])
("lydu" ["零度"])
("lydv" ["领队"])
("lydz" ["劳役地租"])
("lye'" "岭领令")
("lyfm" ["另一方面"])
("lyfy" ["流言蜚语"])
("lyg'" ["连云港"])
("lygj" ["灵感"])
("lyh'" ["莱茵河" "黎元洪"])
("lyhh" ["领航"])
("lyhl" ["领海"])
("lyho" ["灵活"])
("lyhp" ["灵魂"])
("lyhv" ["领会"])
("lyie" ["灵车"])
("lyif" ["凌晨"])
("lyii" ["凌迟"])
("lyj'" ["录音机"])
("lyjc" ["菱角" "领教"])
("lyjd" ["领奖" "另将"])
("lyjh" ["劳逸结合"])
("lyji" ["龄级"])
("lyjm" ["零件"])
("lyjq" ["灵柩"])
("lykb" ["领口"])
("lyks" ["凌空" "领空"])
("lyl'" ["利用率"])
("lyli" ["伶俐"])
("lylo" ["零落"])
("lylr" ["零乱" "凌乱"])
("lyls" ["玲珑"])
("lylt" ["领略"])
("lymj" ["流域面积"])
("lymn" ["灵敏"])
("lymu" ["陵墓"])
("lynj" ["岭南"])
("lypd" ["联言判断"])
("lyq'" "拎")
("lyqc" ["灵巧"])
("lyqi" ["龄期"])
("lyqn" ["陵寝"])
("lyqu" ["灵渠" "领取"])
("lyr'" "另令呤")
("lyrf" ["令人"])
("lyrl" ["里约热内卢"])
("lyru" ["凌辱"])
("lys'" ["路易斯" "落叶松"])
("lysj" ["零散"])
("lysv" ["零碎"])
("lyt'" ["老一套"])
("lytb" ["领头"])
("lyts" ["灵通"])
("lytu" ["领土"])
("lyty" ["聆听"])
("lyu'" ["录音室"])
("lyub" ["零售" "领受"])
("lyug" ["铃声"])
("lyui" ["零时" "领事"])
("lyuj" ["灵山"])
("lyuv" ["领水"])
("lyv'" ["另一种"])
("lyvi" ["灵芝"])
("lyvu" ["领主"])
("lyw'" "棱玲菱零龄铃伶羚凌灵陵令酃苓囹泠绫柃棂瓴聆蛉翎鲮")
("lywh" ["里应外合"])
("lywl" ["另外"])
("lywu" ["灵武" "领悟"])
("lyx'" ["氯乙烯"])
("lyxm" ["领先" "领衔"])
("lyxq" ["领袖"])
("lyxu" ["利用系数"])
("lyxy" ["菱形" "零星" "另行"])
("lyy'" ["懒洋洋" "老爷爷" "雷雨云" "疗养院" "旅游业" "绿油油"])
("lyyb" ["领有" "另有"])
("lyyd" ["留有余地"])
("lyyh" ["羚羊"])
("lyyi" ["另一"])
("lyyj" ["灵验"])
("lyyp" ["凌云"])
("lyyr" ["陵园"])
("lyys" ["零用"])
("lyyu" ["领域" "鲮鱼"])
("lyz'" ["老爷子"])
("lyzi" ["领子"])
("lz'" ["例子"])
("lzbi" ["类比"])
("lzbk" ["雷暴"])
("lzbx" ["类别"])
("lzci" ["累次" "类次"])
("lzd'" ["立足点"])
("lzda" ["雷达"])
("lzde" ["累得"])
("lzdm" ["雷电"])
("lzds" ["雷动"])
("lze'" "蕾磊累儡垒诔耒")
("lzfg" ["雷锋"])
("lzfj" ["累犯"])
("lzgr" ["雷管"])
("lzgu" ["肋骨"])
("lzhf" ["泪痕"])
("lzhw" ["泪花"])
("lzi'" ["李自成"])
("lzjh" ["离子交换"])
("lzji" ["雷击" "累积" "累计"])
("lzjm" ["累减"])
("lzjn" ["勒紧" "累进"])
("lzjw" ["累加"])
("lzjy" ["类经"])
("lzk'" ["腊子口"])
("lzli" ["雷利"])
("lzlo" ["磊落"])
("lzlq" ["泪流"])
("lzlx" ["量子力学"])
("lzly" ["蕾铃"])
("lzlz" ["累累"])
("lzm'" ["刘宗敏"])
("lzmy" ["雷鸣"])
("lzno" ["雷诺"])
("lzq'" "勒擂")
("lzqq" ["垒球"])
("lzr'" "累擂肋类泪酹")
("lzsi" ["累死" "类似"])
("lzt'" "嘞")
("lztl" ["擂台"])
("lzts" ["雷同"])
("lztv" ["类推"])
("lzty" ["雷霆"])
("lzue" ["镭射"])
("lzug" ["雷声"])
("lzuv" ["泪水"])
("lzvu" ["泪珠"])
("lzvv" ["累赘"])
("lzvw" ["裸子植物"])
("lzw'" "雷镭累擂羸嫘缧檑")
("lzx'" ["帘子线"])
("lzxy" ["类型"])
("lzy'" ["柳宗元"])
("lzyj" ["泪眼"])
("lzyt" ["累月"])
("lzyu" ["雷雨"])
("lzz'" ["老祖宗"])
("m" "没")
("maan" ["马鞍"])
("mabi" ["麻痹"])
("mabm" ["马鞭"])
("mabu" ["麻布"])
("mack" ["马槽"])
("mada" ["马达"])
("madg" ["马灯"])
("madk" ["马刀"])
("madl" ["麻袋"])
("madv" ["马队"])
("mady" ["马丁"])
("mae'" "玛码蚂马吗犸")
("maer" ["马儿" "马尔"])
("mafh" ["麻纺"])
("mafj" ["麻烦"])
("mafu" ["马夫"])
("mafz" ["吗啡"])
("magw" ["马褂"])
("mahe" ["马赫"])
("mahu" ["马虎"])
("maie" ["马车"])
("maig" ["麻城"])
("maih" ["马场"])
("majc" ["马脚"])
("majw" ["马家"])
("make" ["马可" "马克"])
("mala" ["马拉"])
("mald" ["马良"])
("mali" ["玛丽" "马里" "马力"])
("malj" ["马兰"])
("mals" ["马龙"])
("malu" ["马路"])
("malx" ["马列"])
("mama" ["妈妈" "嬷嬷"])
("mamu" ["麻木"])
("mank" ["玛瑙"])
("maq'" "妈麻蚂摩抹嬷")
("maqp" ["马群"])
("maqt" ["麻雀"])
("mar'" "蚂骂唛杩")
("marf" ["骂人"])
("masi" ["马斯"])
("masl" ["马赛"])
("mat'" "嘛吗么")
("matb" ["码头" "马头" "唛头"])
("mati" ["马蹄"])
("matl" ["马太"])
("maua" ["麻纱"])
("maug" ["麻绳"])
("mauh" ["马上"])
("mava" ["蚂蚱"])
("mavf" ["麻疹"])
("maw'" "麻吗蟆")
("mawf" ["马文"])
("maxi" ["马戏"])
("maxm" ["麻线"])
("mayb" ["麻油"])
("mayi" ["蚂蚁"])
("mayk" ["麻药"])
("mazi" ["麻子" "马子"])
("mazs" ["马鬃"])
("mazv" ["麻醉"])
("mbbu" ["某部"])
("mbd'" ["买不到"])
("mbdi" ["某地"])
("mbdy" ["麻痹大意"])
("mbe'" "某")
("mbfj" ["谋反"])
("mbge" ["某个"])
("mbgx" ["漠不关心"])
("mbhl" ["谋害"])
("mbhw" ["谋划"])
("mbjj" ["买办阶级"])
("mbjm" ["某件"])
("mbjw" ["某甲"])
("mbjx" ["漫不经心"])
("mbl'" ["免不了"])
("mblt" ["谋略"])
("mblu" ["民不聊生"])
("mbmb" ["某某"])
("mbq'" "哞")
("mbqq" ["谋求"])
("mbqu" ["谋取" "牟取"])
("mbrf" ["某人"])
("mbu'" ["莫不是"])
("mbua" ["谋杀"])
("mbuf" ["明辨是非"])
("mbug" ["谋生"])
("mbui" ["某事"])
("mbvj" ["目不转睛"])
("mbvs" ["某种"])
("mbvw" ["木本植物"])
("mbw'" "谋牟侔缪眸蛑鍪")
("mbxd" ["某项"])
("mbxx" ["某些"])
("mbzh" ["满不在乎"])
("mbzu" ["默不作声"])
("mc'" ["每次"])
("mcbc" ["秒表"])
("mce'" ["藐" "秒" "渺" "邈" "缈" "杪" "淼" "眇" "闵采尔"])
("mcfz" ["苗肥"])
("mcgl" ["木材干馏"])
("mchv" ["描绘" "庙会"])
("mchw" ["描画"])
("mcid" ["苗床"])
("mcji" ["妙计"])
("mcl'" ["摩擦力"])
("mcly" ["妙龄"])
("mcmh" ["渺茫"])
("mcmu" ["苗木"])
("mcpu" ["苗圃"])
("mcq'" "喵")
("mcqi" ["苗期"])
("mcr'" "庙妙缪")
("mctb" ["苗头"])
("mctc" ["苗条"])
("mcth" ["庙堂"])
("mcub" ["妙手"])
("mcui" ["藐视"])
("mcuu" ["描述"])
("mcuw" ["名存实亡"])
("mcve" ["瞄着"])
("mcvf" ["秒针"])
("mcvp" ["瞄准"])
("mcvs" ["苗种"])
("mcw'" "苗描瞄鹋")
("mcxc" ["渺小"])
("mcxu" ["摩擦系数"])
("mcxx" ["描写"])
("mcys" ["妙用"])
("mcyu" ["庙宇" "妙玉"])
("mczi" ["苗子"])
("mczl" ["摩擦阻力"])
("mczu" ["苗族"])
("md'" ["目的"])
("mdd'" ["目的地"])
("mddl" ["脉动电流"])
("mdj'" ["牡丹江"])
("mdjj" ["马达加斯加"])
("mdkd" ["目瞪口呆"])
("mdl'" ["马德里" "矛盾论" "门电路"])
("mdm'" ["面对面"])
("mdsj" ["孟德斯鸠"])
("mdu'" ["没的说"])
("mdvy" ["盲动主义"])
("mdw'" ["马德望"])
("mebx" ["秘而不宣"])
("mess" ["马尔萨斯"])
("met'" ["么" "麽" "马耳他"])
("mfbj" ["门板"])
("mfdb" ["门斗"])
("mfdk" ["门道"])
("mfer" ["门儿"])
("mffa" ["门阀"])
("mffg" ["门缝"])
("mffh" ["门房"])
("mfhu" ["门户"])
("mfi'" ["棉纺厂"])
("mfii" ["门齿"])
("mfjy" ["门径"])
("mfkb" ["门口"])
("mfkd" ["门框"])
("mfkj" ["门槛"])
("mflb" ["门楼"])
("mflm" ["门帘"])
("mflo" ["门罗"])
("mflu" ["门路"])
("mflz" ["门类"])
("mfmm" ["门面"])
("mfnz" ["门内"])
("mfpc" ["门票"])
("mfpl" ["门牌"])
("mfq'" "闷")
("mfqi" ["闷气"])
("mfqu" ["名副其实"])
("mfr'" "闷焖懑")
("mfre" ["闷热"])
("mfrf" ["门人"])
("mfsw" ["眉飞色舞"])
("mft'" "们")
("mftu" ["门徒"])
("mfug" ["门生"])
("mfui" ["门市"])
("mfvf" ["门诊"])
("mfw'" "门扪钔")
("mfwl" ["门外"])
("mfxm" ["门限"])
("mfxw" ["门下"])
("mfz'" ["没法子"])
("mg'" ["每个"])
("mgbh" ["盟邦"])
("mgbi" ["蒙蔽"])
("mgdf" ["美观大方"])
("mgds" ["萌动"])
("mge'" "蒙锰猛勐懵蜢蠓艋")
("mgfa" ["萌发"])
("mggh" ["锰钢"])
("mggo" ["盟国"])
("mggs" ["猛攻"])
("mggu" ["蒙古"])
("mgh'" ["湄公河"])
("mgho" ["猛火"])
("mghp" ["蒙混"])
("mghr" ["梦幻"])
("mghu" ["猛虎"])
("mghw" ["梦话"])
("mgig" ["蒙城"])
("mgis" ["猛冲"])
("mgjd" ["猛将"])
("mgjm" ["梦见"])
("mgjp" ["盟军"])
("mgjy" ["梦境"])
("mgke" ["孟轲"])
("mgls" ["朦胧"])
("mglx" ["猛烈"])
("mgmg" ["蒙蒙"])
("mgml" ["孟买"])
("mgpi" ["蒙皮"])
("mgpm" ["蒙骗"])
("mgpu" ["猛扑"])
("mgq'" "蒙")
("mgr'" ["梦" "孟" "每个人" "蒙古人"])
("mgrb" ["民国日报"])
("mgrj" ["猛然"])
("mgte" ["蒙特"])
("mgtx" ["锰铁"])
("mgty" ["马关条约"])
("mgub" ["蒙受" "猛兽"])
("mgug" ["萌生"])
("mguj" ["蒙山"])
("mguu" ["檬树"])
("mgvu" ["盟主"])
("mgw'" "氓萌蒙檬盟甍瞢朦礞虻艨")
("mgx'" ["没关系" "敏感性"])
("mgxd" ["梦乡" "梦想"])
("mgy'" ["莫过于"])
("mgya" ["萌芽"])
("mgyb" ["盟友"])
("mgyt" ["盟约"])
("mgz'" ["卖国贼" "蒙古族" "命根子"])
("mgzg" ["猛增"])
("mgzi" ["猛子" "孟子"])
("mgzu" ["蒙族"])
("mhbq" ["模糊不清"])
("mhcs" ["盲从"])
("mhda" ["盲打"])
("mhds" ["盲动"])
("mhe'" "莽漭蟒")
("mhgg" ["蒙混过关"])
("mhgo" ["芒果"])
("mhh'" ["明晃晃"])
("mhih" ["盲肠"])
("mhj'" ["慢化剂" "镁合金"])
("mhl'" ["闷葫芦"])
("mhlr" ["忙乱"])
("mhlu" ["忙碌"])
("mhmd" ["穆罕默德"])
("mhmh" ["茫茫" "莽莽"])
("mhmu" ["盲目"])
("mhq'" ["灭火器"])
("mhrf" ["盲人"])
("mhrj" ["茫然"])
("mhvd" ["莽撞"])
("mhvs" ["芒种"])
("mhw'" "芒茫盲氓忙邙硭")
("mhwf" ["盲文"])
("mhxc" ["芒硝"])
("mhxx" ["满怀信心"])
("mhyu" ["忙于"])
("mi'" ["名称"])
("mibi" ["密闭"])
("mibu" ["弥补" "密布"])
("midi" ["谜底"])
("midm" ["密电"])
("midu" ["密度"])
("mie'" "眯靡米芈弭脒敉")
("mier" ["米尔"])
("miff" ["米粉"])
("mifg" ["眯缝" "蜜蜂" "密封"])
("mifh" ["秘方"])
("mifj" ["米饭"])
("mify" ["满城风雨"])
("migs" ["迷宫"])
("mihd" ["米黄"])
("miho" ["迷惑"])
("mihp" ["迷魂"])
("mihu" ["迷糊"])
("mihv" ["谜会"])
("miji" ["密集"])
("mijm" ["密件"])
("mijt" ["秘诀"])
("mijx" ["密接"])
("mikh" ["米糠"])
("mild" ["脉冲雷达"])
("mile" ["弥勒" "米勒"])
("mili" ["迷离" "米粒"])
("milj" ["糜烂" "米兰"])
("milm" ["迷恋"])
("milu" ["迷路"])
("mily" ["密令"])
("milz" ["醚类"])
("mima" ["密码"])
("mimb" ["密谋"])
("mimg" ["迷梦"])
("mimi" ["秘密"])
("mimj" ["迷漫" "弥漫"])
("minc" ["泌尿"])
("mipc" ["米票"])
("miq'" "眯咪")
("miqx" ["密切"])
("mir'" "秘觅泌蜜密幂谧嘧汨宓糸")
("mirf" ["迷人"])
("mise" ["米色"])
("mitj" ["密谈" "密探"])
("mitu" ["迷途"])
("miui" ["迷失" "秘史" "觅食" "密实"])
("miuu" ["秘书"])
("mivb" ["米粥"])
("mivi" ["米脂" "密植"])
("mivu" ["迷住"])
("miw'" "醚靡糜迷谜弥蘼猕祢縻麋")
("miwh" ["迷惘"])
("mix'" ["没出息"])
("mixn" ["迷信"])
("miyb" ["密友"])
("miyp" ["密云"])
("miyr" ["蜜源"])
("miyt" ["蜜月"])
("miyu" ["谜语"])
("mj'" ["面积"])
("mjbu" ["漫步"])
("mjdu" ["摩加迪沙"])
("mje'" "满螨")
("mjf'" ["面积分"])
("mjg'" ["没见过" "木结构"])
("mjgj" ["蛮干"])
("mjgu" ["曼谷" "曼梏"])
("mjh'" ["满江红"])
("mjhg" ["蛮横"])
("mjhw" ["漫画"])
("mjhy" ["满怀"])
("mjie" ["慢车"])
("mjig" ["满城"])
("mjih" ["漫长"])
("mjkb" ["满口"])
("mjlf" ["门捷列夫"])
("mjlg" ["孟加拉国"])
("mjli" ["鳗鲡"])
("mjma" ["漫骂" "谩骂"])
("mjmf" ["满门"])
("mjmj" ["满满" "慢慢" "漫漫"])
("mjmm" ["满面"])
("mjmu" ["满目"])
("mjq'" "颟")
("mjqd" ["满腔"])
("mjr'" "蔓曼慢漫谩墁幔缦熳镘")
("mjsu" ["慢速"])
("mjtb" ["馒头"])
("mjtj" ["漫谈"])
("mjtm" ["满天" "漫天"])
("mjuf" ["满身"])
("mjv'" ["马建忠"])
("mjvb" ["满洲"])
("mjw'" "埋瞒馒蛮蔓谩鳗鞔")
("mjwx" ["民间文学"])
("mjxn" ["满心"])
("mjxy" ["慢性"])
("mjy'" ["煤焦油"])
("mjyi" ["满意"])
("mjyj" ["满眼" "蔓延" "曼延"])
("mjyu" ["民间艺术" "鳗鱼"])
("mjzb" ["慢走"])
("mjzl" ["满载"])
("mjzu" ["蛮族" "满足" "满族"])
("mkbi" ["毛笔"])
("mkby" ["毛病"])
("mkci" ["毛刺"])
("mkck" ["茅草"])
("mkdp" ["矛盾"])
("mkdy" ["铆钉" "冒顶"])
("mke'" "铆卯峁泖昴")
("mkfa" ["毛发"])
("mkfh" ["毛纺"])
("mkgu" ["锚固"])
("mkhk" ["冒号"])
("mkho" ["冒火"])
("mkhv" ["帽徽"])
("mkia" ["毛茶"])
("mkis" ["毛虫" "冒充"])
("mkjn" ["毛巾" "冒进"])
("mkjx" ["铆接"])
("mkkb" ["冒口"])
("mklc" ["毛料"])
("mkli" ["毛利"])
("mklv" ["毛驴"])
("mkmi" ["茂密"])
("mkmk" ["毛毛"])
("mkmy" ["冒名"])
("mkmz" ["毛霉" "冒昧"])
("mkpi" ["毛坯" "毛皮"])
("mkpk" ["冒泡"])
("mkpl" ["冒牌"])
("mkq'" "猫")
("mkr'" "茂冒帽貌贸袤瑁耄懋瞀")
("mkrj" ["贸然"])
("mks'" ["马克斯" "马克思"])
("mksi" ["貌似"])
("mksw" ["麦克斯韦"])
("mksy" ["马克思主义"])
("mkt'" ["马口铁"])
("mktb" ["矛头"])
("mktc" ["毛条"])
("mktj" ["毛毯"])
("mktl" ["茅台"])
("mkug" ["茂盛"])
("mkui" ["毛诗" "冒失"])
("mkuj" ["茅山"])
("mkvd" ["毛装"])
("mkve" ["冒着"])
("mkvj" ["毛毡"])
("mkvu" ["毛竹"])
("mkw'" "猫茅锚毛矛茆牦旄蝥蟊髦")
("mkwu" ["茅屋"])
("mkxi" ["毛细"])
("mkxm" ["毛线" "冒险"])
("mkxr" ["毛选"])
("mkyi" ["毛衣" "贸易"])
("mkyj" ["冒烟"])
("mkyu" ["冒雨"])
("mkyx" ["眉开眼笑"])
("mkzi" ["毛子" "帽子"])
("ml'" ["命令"])
("mlb'" ["马拉博"])
("mlbj" ["买办"])
("mlbo" ["脉搏"])
("mlbu" ["迈步"])
("mlch" ["埋藏"])
("mlds" ["脉动"])
("mle'" "买荬")
("mlfu" ["埋伏" "麦麸"])
("mlg'" ["摩洛哥"])
("mlgo" ["卖国"])
("mlgz" ["卖给"])
("mlhw" ["卖画"])
("mli'" ["棉铃虫"])
("mlia" ["麦茬"])
("mlie" ["买车" "卖车"])
("mlis" ["脉冲"])
("mliu" ["卖出"])
("mljg" ["美利坚合众国"])
("mljn" ["买进" "迈进"])
("mljw" ["买价" "麦加" "卖价"])
("mlli" ["麦粒" "卖力"])
("mlll" ["马拉硫磷"])
("mllo" ["脉络"])
("mlmc" ["麦苗"])
("mlml" ["买卖"])
("mlmo" ["埋没"])
("mlmy" ["卖命"])
("mlns" ["卖弄"])
("mlq'" ["卖力气"])
("mlqm" ["卖钱"])
("mlr'" "麦卖迈脉劢")
("mlsv" ["麦穗"])
("mltb" ["埋头"])
("mlts" ["买通"])
("mlty" ["毛里塔尼亚"])
("mlu'" ["马铃薯"])
("mlub" ["麦收"])
("mluf" ["卖身"])
("mlui" ["脉石"])
("mlvh" ["买帐"])
("mlvu" ["买主" "卖主"])
("mlvy" ["马列主义"])
("mlw'" "埋霾")
("mlwf" ["卖文"])
("mlxw" ["买下"])
("mlxy" ["马来西亚"])
("mly'" ["马来亚"])
("mlya" ["麦芽"])
("mlyi" ["卖艺"])
("mlyn" ["卖淫"])
("mlyr" ["埋怨"])
("mlzb" ["买走"])
("mlzh" ["埋藏" "埋葬"])
("mlzi" ["麦子"])
("mm'" ["每秒"])
("mmao" ["棉袄"])
("mmbk" ["面包"])
("mmbu" ["棉布" "面部"])
("mmbz" ["棉被"])
("mmd'" ["密密的"])
("mmde" ["免得"])
("mmdm" ["缅甸"])
("mmdv" ["面对"])
("mme'" "冕免勉娩缅沔渑湎腼眄黾")
("mmff" ["面粉"])
("mmfh" ["棉纺"])
("mmfz" ["免费"])
("mmgf" ["绵亘"])
("mmgr" ["免冠"])
("mmh'" ["木麻黄"])
("mmhh" ["马马虎虎" "模模糊糊"])
("mmhw" ["棉花"])
("mmhy" ["缅怀"])
("mmif" ["满面春风"])
("mmih" ["绵长"])
("mmiu" ["免除"])
("mmjc" ["面交"])
("mmjd" ["面面俱到"])
("mmji" ["面积"])
("mmjn" ["面筋"])
("mmjr" ["棉卷"])
("mmju" ["面具"])
("mmks" ["面孔"])
("mmku" ["棉裤"])
("mmli" ["勉励"])
("mmln" ["面临"])
("mmly" ["棉铃"])
("mmmk" ["面貌"])
("mmmm" ["密密麻麻" "绵绵"])
("mmmu" ["面目"])
("mmpc" ["免票" "面票"])
("mmqd" ["勉强" "面墙"])
("mmqm" ["面前" "莫名其妙"])
("mmqq" ["勉勉强强"])
("mmqu" ["免去"])
("mmr'" ["面" "买卖人"])
("mmrf" ["面人"])
("mmrs" ["面容"])
("mmse" ["面色"])
("mmtc" ["棉条" "面条"])
("mmtj" ["面谈"])
("mmtm" ["棉田"])
("mmtr" ["面团"])
("mmts" ["眠酮"])
("mmu'" ["棉毛衫"])
("mmua" ["棉纱"])
("mmub" ["面授"])
("mmui" ["面食"])
("mmuv" ["免税"])
("mmvd" ["明目张胆"])
("mmvi" ["免职"])
("mmw'" "呒棉眠绵")
("mmww" ["默默无闻"])
("mmx'" ["盲目性"])
("mmxd" ["面相" "面向"])
("mmxm" ["棉线"])
("mmxu" ["棉絮"])
("mmya" ["棉蚜"])
("mmyh" ["绵羊" "绵阳"])
("mmyi" ["棉衣" "免役" "免疫" "面议"])
("mmyj" ["绵延"])
("mmyk" ["眠药"])
("mmyq" ["梦寐以求"])
("mmzi" ["棉籽" "面子"])
("mn'" ["每年"])
("mnbj" ["民办"])
("mnbk" ["民报"])
("mnbm" ["民变"])
("mnby" ["民兵"])
("mne'" "抿皿敏悯闽闵泯愍黾鳘")
("mnfa" ["民法"])
("mnff" ["民愤"])
("mnfh" ["民房"])
("mnfu" ["民夫"])
("mnfz" ["闵妃"])
("mnge" ["民歌" "民革"])
("mngj" ["敏感"])
("mngo" ["民国"])
("mngs" ["民工"])
("mnh'" ["慕尼黑"])
("mnhb" ["闽侯"])
("mnhe" ["民和"])
("mnhh" ["民航"])
("mnjd" ["闽江" "岷江"])
("mnjj" ["模拟计算机"])
("mnjm" ["民间"])
("mnjx" ["敏捷"])
("mnjy" ["民警"])
("mnl'" ["马尼拉"])
("mnli" ["民力"])
("mnq'" ["模拟器"])
("mnqi" ["民气"])
("mnqr" ["民权"])
("mnqy" ["民情"])
("mnrv" ["敏锐"])
("mntm" ["民田"])
("mntr" ["民团"])
("mnug" ["民生"])
("mnui" ["民事"])
("mnvg" ["民政"])
("mnvi" ["民智"])
("mnvs" ["民众"])
("mnvu" ["民主"])
("mnw'" "民苠岷缗玟珉")
("mnxc" ["民校"])
("mnxn" ["民心"])
("mnxr" ["民选"])
("mnyi" ["民意"])
("mnyk" ["民谣"])
("mnys" ["民用"])
("mnzu" ["民族"])
("mnzv" ["抿嘴"])
("moai" ["默哀"])
("mobf" ["摹本"])
("mobi" ["墨笔"])
("mobl" ["膜拜"])
("mobu" ["莫不"])
("moca" ["磨擦" "摩擦"])
("moda" ["莫大"])
("modg" ["摩登"])
("modi" ["摸底" "墨翟"])
("modk" ["摸到" "磨刀"])
("modl" ["末代"])
("modu" ["默读"])
("moe'" "抹")
("moer" ["摩尔" "莫尔"])
("mofh" ["摹仿" "模仿"])
("mofj" ["模范"])
("mofz" ["莫非"])
("mogd" ["磨光"])
("mogu" ["蘑菇"])
("mogv" ["魔鬼"])
("mohe" ["磨合"])
("mohk" ["磨耗"])
("mohu" ["模糊"])
("mohv" ["抹灰"])
("mohz" ["摸黑" "抹黑"])
("moid" ["磨床"])
("moji" ["墨迹"])
("mojw" ["墨家"])
("mojy" ["墨经"])
("mokd" ["磨矿"])
("moky" ["模块"])
("molc" ["磨料" "末了"])
("moli" ["魔力"])
("molm" ["磨炼" "磨练"])
("molo" ["没落"])
("molv" ["墨绿"])
("momo" ["默默" "茉茉"])
("momx" ["磨灭" "沫灭"])
("moni" ["摹拟" "模拟" "莫逆"])
("monj" ["磨难"])
("monl" ["莫奈"])
("monm" ["末年"])
("moq'" "摸")
("moqi" ["末期" "默启" "默契"])
("mor'" "貉嘿脉冒没磨抹末莫墨默沫漠寞陌万茉蓦殁镆秣瘼耱貊貘")
("morf" ["默认"])
("mori" ["末日"])
("morj" ["默然" "漠然" "寞然"])
("moru" ["没入" "莫如" "莫入"])
("moso" ["摸索"])
("mosp" ["磨损"])
("mote" ["模特"])
("motm" ["摩天"])
("moto" ["摩托"])
("moua" ["抹杀" "抹煞"])
("moub" ["没收"])
("moug" ["陌生"])
("moui" ["模式" "磨石" "末世" "漠视"])
("mouu" ["模数" "魔术"])
("mouv" ["墨水"])
("movi" ["墨汁"])
("movp" ["摸准"])
("mow'" "摸摹蘑模膜磨摩魔无谟馍嫫麽")
("mowh" ["魔王"])
("mowz" ["末尾"])
("moxc" ["磨削"])
("moxm" ["墨线"])
("moxu" ["莫须" "默许"])
("moxx" ["默写"])
("moxy" ["模型"])
("moya" ["模压"])
("moye" ["末叶"])
("moyh" ["模样"])
("moyj" ["膜炎"])
("moyu" ["墨鱼"])
("mozi" ["墨子"])
("mpt'" ["马普托"])
("mpvh" ["锚喷支护"])
("mq'" ["目前"])
("mqcj" ["民穷财尽"])
("mqhu" ["妙趣横生"])
("mqlp" ["谬论"])
("mqr'" "谬缪")
("mqvy" ["民权主义"])
("mqwu" ["谬误"])
("mr'" ["每人"])
("msbk" ["莫桑比克"])
("msk'" ["莫斯科"])
("msl'" ["穆斯林"])
("msln" ["墨索里尼"])
("mt'" ["每天"])
("mte'" ["米吐尔" "模特儿"])
("mtgy" ["煤炭工业"])
("mtgz" ["埋头工作"])
("mth'" ["木炭画"])
("mti'" ["摩托车"])
("mtj'" ["茅台酒"])
("mtkg" ["埋头苦干"])
("mtsl" ["慢条斯理"])
("mtt'" ["慢吞吞"])
("mtx'" ["马蹄形"])
("mtz'" ["明太祖"])
("muai" ["母爱"])
("mub'" ["门市部"])
("mubc" ["目标"])
("mubf" ["母本" "木本"])
("mubj" ["木板" "木版"])
("mubu" ["幕布"])
("mubz" ["墓碑"])
("muck" ["牧草"])
("mucl" ["木材"])
("mudi" ["墓地" "目的"])
("mudj" ["牡丹"])
("mudr" ["模锻"])
("mudu" ["目睹"])
("mue'" ["姥" "拇" "牡" "亩" "姆" "母" "没事儿"])
("muer" ["木耳" "穆尔"])
("mufa" ["木筏"])
("mufg" ["母蜂"])
("mufu" ["幕府"])
("mugd" ["目光"])
("mugj" ["名胜古迹"])
("mugp" ["木棍"])
("mugs" ["木工" "牧工"])
("muhb" ["母后" "幕后"])
("muhi" ["妙手回春"])
("muih" ["牧场"])
("muij" ["亩产"])
("muil" ["木柴"])
("muir" ["木船"])
("mujd" ["木匠"])
("muji" ["母鸡" "募集" "目击"])
("mujr" ["募捐"])
("muju" ["模具"])
("mujy" ["目镜"])
("muke" ["木刻"])
("mul'" ["母树林"])
("mulc" ["木料"])
("muli" ["目力"])
("mulj" ["木兰"])
("muln" ["木林" "睦邻"])
("muls" ["木笼"])
("mulu" ["目录"])
("mum'" ["没什么"])
("muma" ["木马"])
("mumk" ["每时每刻"])
("mumn" ["牧民"])
("mumu" ["苜苜"])
("mumy" ["慕名"])
("munm" ["暮年"])
("muou" ["木偶"])
("mupl" ["木排"])
("muqi" ["木器"])
("muqm" ["目前"])
("muqn" ["母亲"])
("muqu" ["牧区"])
("mur'" ["牟" "墓" "暮" "幕" "募" "慕" "木" "目" "睦" "牧" "穆" "仫" "坶" "苜" "沐" "钼" "陌生人"])
("murf" ["木人" "牧人"])
("murs" ["慕容"])
("muse" ["暮色"])
("muss" ["目送"])
("mut'" ["马氏体"])
("mutb" ["木头"])
("muti" ["母体"])
("mutj" ["木炭"])
("muts" ["牧童"])
("muui" ["木石" "牧师"])
("muuu" ["母树" "木薯"])
("muv'" ["秘书长"])
("muvi" ["拇指" "姆指" "木制"])
("muvu" ["母株" "母猪" "没事找事"])
("muvy" ["民生主义"])
("muw'" "模毪")
("muwk" ["孟什维克"])
("muwu" ["木屋"])
("muxc" ["母校"])
("muxi" ["母系" "木樨"])
("muxm" ["母线"])
("muxu" ["牧畜"])
("muxw" ["目下"])
("muy'" ["马士英"])
("muya" ["模压"])
("muye" ["母液" "牧业"])
("muyh" ["模样" "母羊" "牧羊"])
("muyn" ["母音"])
("muyu" ["沐育" "沐浴"])
("muzh" ["墓葬"])
("muzi" ["母子"])
("mv'" ["民主"])
("mvb'" ["木质部" "民政部"])
("mvbz" ["美中不足"])
("mvdp" ["民主党派"])
("mvdt" ["莫折大提"])
("mvg'" ["满洲国" "民主国"])
("mvgf" ["明知故犯"])
("mvgg" ["民主改革"])
("mvgm" ["民主革命"])
("mvjv" ["民主集中制"])
("mvm'" ["墓志铭"])
("mvmg" ["民脂民膏"])
("mvp'" ["毛织品" "棉织品"])
("mvs'" ["木质素"])
("mvvv" ["民主政治" "民主专政"])
("mvwr" ["目中无人"])
("mvwx" ["明治维新"])
("mvx'" ["毛主席"])
("mws'" ["马尾松"])
("mwx'" ["冥王星"])
("mx'" ["某些"])
("mxa'" ["马西埃"])
("mxb'" ["慢性病"])
("mxbt" ["梦溪笔谈"])
("mxg'" ["毛细管" "墨西哥"])
("mxgi" ["墨西哥城"])
("mxgw" ["墨西哥湾"])
("mxho" ["灭火"])
("mxji" ["灭迹"])
("mxjp" ["灭菌"])
("mxjt" ["灭绝"])
("mxkb" ["灭口"])
("mxq'" "乜咩")
("mxr'" "蔑灭蠛篾")
("mxui" ["蔑视"])
("mxv'" ["明细帐"])
("mxvy" ["冒险主义"])
("mxw'" ["棉纤维"])
("mxwh" ["灭亡"])
("mxy'" ["莫须有"])
("my'" ["没有"])
("myan" ["明暗"])
("mybl" ["明白"])
("myce" ["名册"])
("myci" ["名词" "名次"])
("mycl" ["名菜"])
("mycy" ["民意测验"])
("myde" ["明德"])
("mydg" ["明灯"])
("mydj" ["名单"])
("mydk" ["明道"])
("mydl" ["明代"])
("mye'" "酩")
("myee" ["名额"])
("myer" ["明儿"])
("myff" ["名分"])
("myfh" ["鸣放"])
("myfj" ["明矾"])
("myg'" ["没有过"])
("mygb" ["明沟"])
("mygv" ["名贵"])
("mygz" ["名义工资"])
("myhk" ["名号"])
("myhw" ["名画"])
("myig" ["名称"])
("myij" ["名产"])
("myiu" ["名厨"])
("myjc" ["明胶" "名教"])
("myjd" ["名将"])
("myji" ["铭记"])
("myjv" ["民用建筑"])
("myjw" ["名家"])
("myjy" ["明镜" "明净"])
("myke" ["铭刻"])
("myky" ["明快"])
("myl'" ["萌芽林"])
("mylc" ["明了"])
("myld" ["明亮"])
("mylh" ["明朗"])
("myli" ["名理" "名利"])
("mylq" ["名流"])
("mylv" ["明律"])
("myly" ["明令" "命令"])
("myma" ["明码"])
("myml" ["命脉"])
("mymu" ["名目"])
("mymy" ["明明" "命名"])
("mymz" ["明媚"])
("mynm" ["明年"])
("mypl" ["铭牌" "名牌"])
("mypm" ["名片"])
("myqd" ["明枪"])
("myqi" ["名气"])
("myqt" ["明确"])
("myr'" "命")
("myrf" ["明人" "名人"])
("myri" ["明日"])
("myt'" ["麦芽糖"])
("myth" ["名堂"])
("myti" ["命题"])
("mytm" ["明天"])
("myug" ["名声" "名胜"])
("myui" ["明时" "名实" "名士" "贸易市场"])
("myuj" ["名山"])
("myuo" ["明说"])
("myuu" ["名数"])
("myvg" ["明政" "明证"])
("myvi" ["明知" "明智"])
("myvk" ["明朝"])
("myvs" ["鸣钟" "命中"])
("myvu" ["明珠" "名主" "名著"])
("myw'" "盟明螟鸣铭名冥茗溟暝瞑")
("mywf" ["明文" "铭文"])
("mywh" ["名望"])
("myxd" ["贸易协定"])
("myxi" ["明晰"])
("myxm" ["明显"])
("myxt" ["名学"])
("myxw" ["名下"])
("myxy" ["明星"])
("myyi" ["名医" "名义"])
("myyj" ["名言"])
("myyp" ["命运"])
("myyu" ["名誉"])
("myzi" ["名子" "名字"])
("myzk" ["明早"])
("mzba" ["没把"])
("mzcg" ["煤层"])
("mzci" ["每次"])
("mzco" ["没错"])
("mzcp" ["梅村"])
("mzd'" ["毛泽东"])
("mzde" ["美德"])
("mzdh" ["每当"])
("mzdp" ["每吨"])
("mzdu" ["梅毒"])
("mzdx" ["毛泽东思想"])
("mze'" "每美镁浼")
("mzeg" ["满载而归"])
("mzfa" ["没法"])
("mzff" ["每份"])
("mzfg" ["每逢"])
("mzfu" ["妹夫"])
("mzge" ["每个"])
("mzgj" ["没敢" "美感"])
("mzgm" ["民族革命"])
("mzgo" ["美国"])
("mzgr" ["美观"])
("mzgv" ["玫瑰"])
("mzh'" ["民族化"])
("mzhk" ["煤耗" "美好"])
("mzho" ["煤火"])
("mzhu" ["每户"])
("mzhv" ["每回"])
("mzhw" ["梅花" "美化"])
("mzj'" ["麻醉剂"])
("mzjd" ["民族解放运动"])
("mzjf" ["民族解放"])
("mzjn" ["美金"])
("mzjp" ["霉菌"])
("mzjq" ["美酒"])
("mzju" ["枚举"])
("mzjw" ["每家"])
("mzjx" ["媒介"])
("mzjy" ["美景"])
("mzkd" ["煤矿"])
("mzke" ["每克"])
("mzlc" ["没了"])
("mzli" ["美丽" "魅力"])
("mzlj" ["霉烂"])
("mzln" ["梅林"])
("mzlu" ["煤炉"])
("mzly" ["民族利益"])
("mzlz" ["酶类"])
("mzmc" ["每秒" "美妙"])
("mzmd" ["民族矛盾"])
("mzmg" ["美梦"])
("mzmj" ["美满"])
("mzmk" ["眉毛"])
("mzmu" ["眉目"])
("mzmy" ["美名"])
("mzmz" ["每每" "妹妹"])
("mznm" ["每年"])
("mznv" ["美女"])
("mzpd" ["民族平等"])
("mzpl" ["每排"])
("mzpo" ["媒婆"])
("mzqi" ["煤气" "每期"])
("mzqq" ["煤球"])
("mzqx" ["美妾"])
("mzr'" "昧寐妹媚谜袂魅")
("mzrf" ["媒人" "每人" "美人"])
("mzri" ["每日"])
("mzrs" ["美容"])
("mzsu" ["霉素"])
("mztb" ["眉头"])
("mztj" ["煤炭" "美谈" "民族团结"])
("mztm" ["煤田" "每天"])
("mzua" ["镁砂"])
("mzuk" ["眉梢"])
("mzuu" ["美术"])
("mzva" ["煤渣"])
("mzvb" ["每周" "美洲"])
("mzvi" ["媒质"])
("mzvp" ["没准"])
("mzvr" ["镁砖"])
("mzvy" ["民族主义"])
("mzw'" "没玫枚梅酶霉煤眉媒糜莓嵋猸湄楣镅鹛")
("mzwh" ["民族文化"])
("mzwl" ["媚外"])
("mzwt" ["民族问题"])
("mzwz" ["美味"])
("mzxi" ["煤系"])
("mzxt" ["美学"])
("mzxy" ["民族学院"])
("mzyb" ["煤油" "没有"])
("mzyi" ["每一"])
("mzyj" ["煤烟" "眉眼"])
("mzyk" ["煤窑"])
("mzyp" ["民族压迫"])
("mzyr" ["美元"])
("mzys" ["没用"])
("mzyt" ["每月"])
("mzyu" ["梅雨" "美育"])
("mzyx" ["民族英雄"])
("mzzb" ["民族资本"])
("mzzi" ["梅子" "妹子"])
("mzzj" ["民族资产阶级"])
("mzzv" ["民族自治"])
("n" "你")
("nabj" ["那般"])
("nabm" ["那边"])
("nacl" ["那才"])
("nacv" ["纳粹"])
("nada" ["拿大"])
("nadk" ["拿到"])
("nae'" "哪那")
("naer" ["哪儿" "那儿"])
("nage" ["哪个" "那个"])
("nags" ["纳贡"])
("nagz" ["拿给"])
("nahj" ["呐喊"])
("nahv" ["那会"])
("naiu" ["拿出"])
("najq" ["那就"])
("nald" ["纳凉"])
("nali" ["哪里" "那里"])
("nall" ["拿来"])
("nalu" ["哪路"])
("namc" ["纳苗"])
("name" ["那么"])
("namf" ["纳闷"])
("nang" ["哪能"])
("napa" ["哪怕"])
("naq'" "那南")
("naqi" ["拿起"])
("naqu" ["拿去"])
("nar'" "呐钠那娜纳呢捺肭衲")
("naru" ["纳入"])
("nat'" "哪呐")
("naub" ["拿手"])
("naui" ["那时" "那是"])
("nauv" ["纳税"])
("nave" ["拿着"])
("navs" ["那种"])
("navu" ["拿住"])
("naw'" "拿镎")
("nawz" ["哪位" "那位"])
("naxx" ["哪些" "那些"])
("nayb" ["哪有"])
("naye" ["那也"])
("nayh" ["那样"])
("nayj" ["钠盐"])
("nazb" ["拿走"])
("nazj" ["那咱"])
("nb'" ["内部"])
("nbe'" ["尼泊尔"])
("nbi'" ["南北朝"])
("nblx" ["内部联系"])
("nbmd" ["内部矛盾"])
("nbnv" ["女扮男装"])
("nbq'" ["南半球"])
("nbr'" "耨")
("nbyh" ["南北议和"])
("ncbu" ["尿布"])
("nce'" "鸟茑嬲袅")
("ncer" ["鸟儿"])
("ncgu" ["农村公社"])
("ncik" ["鸟巢"])
("ncj'" ["内错角"])
("ncls" ["鸟笼"])
("nclz" ["鸟类"])
("ncpf" ["尿盆"])
("ncpm" ["尿片"])
("ncqd" ["鸟枪"])
("ncr'" "溺尿脲")
("ncsu" ["尿素"])
("ncub" ["鸟兽"])
("nd'" ["你的"])
("nder" ["娘儿"])
("ndjq" ["酿酒"])
("ndjw" ["娘家"])
("ndl'" ["逆定理"])
("ndmi" ["酿蜜"])
("ndnd" ["娘娘"])
("ndr'" "酿")
("ndu'" ["难道说"])
("ndw'" "娘酿")
("ndx'" ["能动性"])
("ndz'" ["内电阻"])
("ndzi" ["娘子"])
("ndzk" ["酿造"])
("nehi" ["努尔哈赤"])
("nem'" ["娘儿们"])
("ner'" "呐呢讷")
("net'" "呐呢")
("new'" "哪")
("nfb'" ["内分泌"])
("nfbx" ["内分泌腺"])
("nfip" ["农副产品"])
("nflq" ["年富力强"])
("nflv" ["嫩绿"])
("nfr'" "嫩恁")
("nfwy" ["女服务员"])
("nfya" ["嫩芽"])
("ng'" ["能够"])
("ngba" ["能把"])
("ngd'" ["凝固点"])
("ngdl" ["能带"])
("ngds" ["能动"])
("ngdv" ["能对"])
("nge'" "唔嗯")
("ngfb" ["能否"])
("nggb" ["能够"])
("nggj" ["能干"])
("ngjd" ["能将"])
("ngji" ["能级"])
("ngjm" ["能见"])
("ngl'" ["尼古拉"])
("ngld" ["能量"])
("ngli" ["能力"])
("ngm'" ["闹革命"])
("ngnl" ["能耐"])
("ngnv" ["男耕女织"])
("ngqj" ["能工巧匠"])
("ngqx" ["内公切线"])
("ngr'" "嗯")
("ngrf" ["能人"])
("ngub" ["能手"])
("ngui" ["能使" "能事"])
("nguu" ["牛鬼蛇神"])
("ngve" ["能者"])
("ngvi" ["能知"])
("ngw'" "能唔嗯")
("ngwz" ["能为"])
("ngy'" ["女高音"])
("ngyb" ["能有"])
("ngyi" ["能以"])
("ngyr" ["能源"])
("ngys" ["能用"])
("ngzo" ["能做"])
("nhcl" ["耐火材料"])
("nhd'" ["耐火度"])
("nhe'" ["攮" "馕" "曩" "那会儿"])
("nhj'" ["内环境" "黏合剂"])
("nhko" ["囊括"])
("nhl'" ["尼赫鲁"])
("nhnt" ["耐火黏土"])
("nhpz" ["囊胚"])
("nhq'" "囊囔")
("nhv'" ["耐火砖"])
("nhw'" "囊馕")
("nhx'" ["耐寒性"])
("nhz'" ["女孩子"])
("ni'" ["年产"])
("niai" ["溺爱"])
("niba" ["泥巴"])
("nibx" ["你别"])
("nibz" ["你被"])
("nicl" ["尼采"])
("nide" ["你的"])
("nidy" ["拟定" "拟订"])
("nie'" "你拟旎祢")
("nifg" ["逆风"])
("nifh" ["你方"])
("nigd" ["逆光"])
("nigk" ["拟稿"])
("nigs" ["泥工"])
("nigu" ["尼姑"])
("nihe" ["拟合"])
("nihk" ["你好"])
("nihs" ["霓虹"])
("niia" ["逆差"])
("nijd" ["泥浆"])
("nijy" ["逆境"])
("nike" ["尼克"])
("nikg" ["泥坑"])
("nil'" ["年产量"])
("nilc" ["腻了"])
("nill" ["你来"])
("nilq" ["逆流"])
("nils" ["尼龙"])
("nimf" ["你们"])
("nimy" ["匿名" "逆命"])
("nink" ["泥淖"])
("niny" ["泥泞"])
("nip'" ["农产品"])
("niq'" "妮")
("niqq" ["泥鳅"])
("niqu" ["你去"])
("nir'" "泥匿腻逆溺尿伲昵慝睨")
("nirf" ["拟人"])
("nirs" ["呢绒"])
("nisi" ["尼斯" "溺死"])
("nisu" ["泥塑"])
("nitj" ["泥潭" "泥炭"])
("nitu" ["泥土"])
("niu'" ["南昌市"])
("niui" ["你是"])
("niuv" ["泥水" "逆水" "溺水"])
("nivi" ["拟制"])
("nivr" ["逆转"])
("niw'" "呢霓倪泥尼坭猊怩铌鲵")
("niwz" ["腻味"])
("nix'" ["南朝鲜"])
("niya" ["尼亚"])
("niyi" ["拟议"])
("niyj" ["泥岩"])
("niyk" ["你要"])
("nizi" ["腻子"])
("nizl" ["你在"])
("nizo" ["拟作"])
("nj'" ["年级"])
("njbj" ["难办"])
("njbk" ["难保"])
("njbm" ["南边"])
("njbu" ["南部"])
("njbz" ["南北"])
("njde" ["难得"])
("njdk" ["难道"])
("njdm" ["难点"])
("njdu" ["难度"])
("njdv" ["男队"])
("nje'" "腩蝻赧")
("njer" ["男儿"])
("njfg" ["南风"])
("njfh" ["南方" "男方"])
("njfl" ["农家肥料"])
("njfy" ["凝集反应"])
("njfz" ["南非"])
("njgo" ["南国" "难过"])
("njgr" ["南关" "难关"])
("njgs" ["南宫"])
("njgw" ["南瓜"])
("njgy" ["难怪"])
("njhe" ["南和"])
("njhj" ["南汉"])
("njhl" ["南海" "男孩"])
("njhv" ["南汇"])
("njhw" ["南华"])
("njig" ["南城"])
("njih" ["南昌"])
("njij" ["难产"])
("njik" ["南朝"])
("njis" ["南充"])
("njiu" ["难处"])
("njji" ["南极"])
("njjp" ["南军" "南郡"])
("njjy" ["南京"])
("njkb" ["南口"])
("njkj" ["难堪" "难看"])
("njkl" ["南开"])
("njlg" ["尼加拉瓜"])
("njlq" ["南流"])
("njlv" ["南吕"])
("njly" ["南岭"])
("njmf" ["南门"])
("njmj" ["南蛮"])
("njmm" ["南面" "难免"])
("njmn" ["难民"])
("njmu" ["楠木"])
("njmy" ["南明"])
("njmz" ["南美"])
("njnf" ["难解难分"])
("njnj" ["喃喃"])
("njnv" ["男女"])
("njny" ["南宁"])
("njou" ["南欧"])
("njpi" ["南皮"])
("njpv" ["农家品种"])
("njpy" ["南平"])
("njq'" "囝囡")
("njr'" "难")
("njrf" ["南人" "男人"])
("njss" ["南宋"])
("njth" ["南唐"])
("njti" ["难题"])
("njts" ["南通"])
("njty" ["难听"])
("nju'" ["南京市" "凝结水"])
("njub" ["难受"])
("njue" ["南社"])
("njug" ["男生"])
("njui" ["南史" "南市" "难事"])
("njuj" ["南山"])
("njuo" ["难说"])
("njv'" ["南极洲"])
("njvi" ["南至"])
("njvk" ["南诏" "难找"])
("njvs" ["南中"])
("njw'" "南男难喃楠")
("njwf" ["难闻"])
("njwh" ["南王" "难忘"])
("njwz" ["难违" "难为"])
("njx'" ["耐久性"])
("njxt" ["难学"])
("njxy" ["男性"])
("njy'" ["内接圆"])
("njya" ["南亚"])
("njyh" ["南洋" "南阳"])
("njyi" ["难以"])
("njyt" ["南越"])
("njyu" ["难于"])
("njzi" ["男子"])
("nkdl" ["脑袋"])
("nkdu" ["挠度"])
("nke'" "脑恼垴瑙")
("nker" ["脑儿"])
("nkfj" ["闹翻"])
("nkgv" ["闹鬼"])
("nkhl" ["脑海"])
("nkho" ["恼火"])
("nkjn" ["脑筋"])
("nkke" ["脑壳"])
("nkli" ["脑力"])
("nklu" ["脑颅"])
("nkmo" ["脑膜"])
("nknu" ["恼怒"])
("nkq'" "孬")
("nkqu" ["挠曲"])
("nkr'" "闹淖")
("nks'" ["尼克松"])
("nksv" ["脑髓"])
("nkui" ["脑室" "闹事" "闹市"])
("nkvi" ["脑汁"])
("nkvs" ["闹钟"])
("nkw'" "挠努呶猱硇铙蛲")
("nkwy" ["扭亏为盈"])
("nkyh" ["挠痒"])
("nkyj" ["脑炎"])
("nkzi" ["脑子"])
("nkzy" ["扭亏增盈"])
("nl'" ["年龄"])
("nlb'" ["内罗毕"])
("nldg" ["氖灯"])
("nldy" ["南罗得西亚"])
("nle'" "哪氖乃奶艿")
("nlff" ["奶粉"])
("nlfj" ["耐烦"])
("nlh'" ["尼罗河"])
("nlhe" ["奈何"])
("nlhj" ["耐寒"])
("nlho" ["耐火"])
("nlir" ["耐穿"])
("nljm" ["耐碱"])
("nljq" ["耐久"])
("nll'" ["年利率"])
("nlld" ["脑力劳动" "奴隶劳动"])
("nlli" ["耐力"])
("nllk" ["奶酪" "耐劳"])
("nlma" ["奶妈"])
("nlmo" ["耐磨"])
("nlmy" ["农林牧副渔"])
("nlnl" ["奶奶"])
("nlnq" ["奶牛"])
("nlpy" ["奶瓶"])
("nlqi" ["氖气"])
("nlqy" ["奴隶起义"])
("nlr'" "耐奈鼐佴萘柰")
("nlre" ["耐热"])
("nlsr" ["耐酸"])
("nltb" ["奶头"])
("nlth" ["奶糖"])
("nltr" ["年老体弱"])
("nltv" ["年龄特征"])
("nluh" ["奴隶社会"])
("nlui" ["乃是"])
("nlv'" ["奴隶制" "奴隶主"])
("nlvd" ["奴隶制度"])
("nlvi" ["乃至"])
("nlxn" ["耐心"])
("nlxy" ["耐性"])
("nlyb" ["奶油"])
("nlys" ["耐用"])
("nlzv" ["奶嘴"])
("nm'" ["你们"])
("nmb'" ["你们被" "女民兵"])
("nmbc" ["年表"])
("nmby" ["纳米比亚"])
("nmc'" ["内摩擦"])
("nmdi" ["年底"])
("nmdl" ["年代"])
("nmdo" ["拈度" "捻度"])
("nmdu" ["拈度" "年度" "黏度"])
("nme'" "碾撵捻辇")
("nmff" ["年份"])
("nmfu" ["黏附"])
("nmg'" ["内蒙古"])
("nmgd" ["年光"])
("nmgf" ["年根"])
("nmgm" ["农民革命"])
("nmgo" ["年过"])
("nmgr" ["年关"])
("nmhk" ["年号"])
("nmhv" ["年会"])
("nmhw" ["年华" "年画"])
("nmig" ["年成"])
("nmij" ["年产"])
("nmiu" ["年初"])
("nmji" ["年级" "年纪"])
("nmjj" ["农民阶级"])
("nmjm" ["年间" "年鉴"])
("nmjn" ["年金"])
("nmjp" ["捻军"])
("nmjx" ["黏结"])
("nmjy" ["年景" "念经"])
("nmkj" ["年刊"])
("nmli" ["年历" "年利"])
("nmlk" ["年老"])
("nmll" ["年来"])
("nmlp" ["年轮"])
("nmly" ["年龄"])
("nmmi" ["碾米"])
("nmml" ["年迈"])
("nmmo" ["黏膜"])
("nmnm" ["年年" "念念"])
("nmpu" ["年谱"])
("nmq'" "蔫拈")
("nmqm" ["年前"])
("nmqy" ["年青" "年轻" "农民起义"])
("nmr'" "念酿廿埝")
("nmso" ["年所"])
("nmsv" ["年岁"])
("nmtb" ["念头"])
("nmtu" ["黏土"])
("nmui" ["年时" "年事" "念诗" "农贸市场"])
("nmuk" ["年少"])
("nmuu" ["念书"])
("nmv'" ["南美洲"])
("nmvh" ["年长"])
("nmvo" ["黏着"])
("nmvs" ["年终"])
("nmvv" ["农民战争"])
("nmw'" "年粘黏鲇鲶")
("nmx'" ["那么些"])
("nmxh" ["农民协会"])
("nmxm" ["年限"])
("nmxn" ["耐磨性能"])
("nmxw" ["年下"])
("nmxy" ["黏性"])
("nmy'" ["那么样"])
("nmye" ["黏液"])
("nmyt" ["年月"])
("nmyu" ["鲶鱼"])
("nmzb" ["撵走"])
("nnbu" ["您不"])
("nnbw" ["念念不忘"])
("nnde" ["您的"])
("nne'" "唔嗯")
("nnhk" ["您好"])
("nnjd" ["您将"])
("nnke" ["您可"])
("nnkg" ["难能可贵"])
("nnmf" ["您们"])
("nnng" ["您能"])
("nnnn" ["男男女女"])
("nnpd" ["男女平等"])
("nnqc" ["您瞧"])
("nnr'" "嗯")
("nnrh" ["您让"])
("nnu'" ["南宁市"])
("nnui" ["您是"])
("nnuo" ["您说"])
("nnv'" ["农奴制" "农奴主"])
("nnw'" "唔嗯您恁")
("nnxd" ["您想"])
("nods" ["挪动"])
("nofu" ["懦夫"])
("nola" ["娜拉"])
("nomi" ["糯米"])
("nor'" "懦糯诺搦喏锘")
("noro" ["懦弱"])
("nosi" ["诺思"])
("now'" "娜挪傩")
("nowz" ["挪威"])
("noyj" ["诺言"])
("noys" ["挪用"])
("nozb" ["挪走"])
("npc'" ["牛皮菜"])
("npj'" ["泥盆纪"])
("npy'" ["男朋友" "女朋友"])
("nqda" ["扭打"])
("nqdb" ["牛痘"])
("nqdl" ["纽带"])
("nqdp" ["牛顿"])
("nqds" ["扭动"])
("nqdu" ["牛犊"])
("nqe'" "扭钮纽狃忸")
("nqff" ["牛粪"])
("nqh'" ["年轻化"])
("nqie" ["牛车"])
("nqjc" ["牛角"])
("nqju" ["扭矩" "扭榘"])
("nqjx" ["扭结"])
("nqkb" ["钮扣" "纽扣"])
("nqli" ["扭力"])
("nqma" ["牛马"])
("nqmk" ["牛毛"])
("nqnl" ["牛奶"])
("nqpg" ["牛棚"])
("nqpi" ["牛皮"])
("nqq'" ["妞" "凝汽器"])
("nqqu" ["扭曲"])
("nqr'" ["拗" "年轻人"])
("nqrb" ["牛肉"])
("nqru" ["牛乳"])
("nqu'" ["南齐书"])
("nque" ["牛舍"])
("nquh" ["扭伤"])
("nqvr" ["扭转"])
("nqw'" "牛")
("nqy'" ["内切圆"])
("nqyb" ["牛油"])
("nqyt" ["纽约"])
("nr'" ["内容"])
("nre'" ["暖" "尼日尔"])
("nrfh" ["暖房"])
("nrg'" ["耐热钢"])
("nrhe" ["暖和"])
("nrhj" ["耐热合金"])
("nrhu" ["内容和形式"])
("nrj'" ["内燃机" "女人家"])
("nrji" ["内燃机车"])
("nrlq" ["暖流"])
("nrly" ["尼日利亚"])
("nrqi" ["暖气"])
("nrvs" ["暖种"])
("nrxw" ["耐人寻味"])
("nsby" ["脓病"])
("nsco" ["弄错"])
("nscp" ["农村"])
("nsdj" ["浓淡"])
("nsdu" ["浓度"])
("nse'" ["纳赛尔"])
("nsfu" ["农夫" "农妇"])
("nshb" ["浓厚"])
("nsho" ["农活"])
("nshu" ["农户"])
("nshv" ["农会"])
("nshy" ["弄坏"])
("nsi'" ["倪嗣冲"])
("nsia" ["浓茶"])
("nsid" ["脓疮"])
("nsih" ["农场"])
("nsij" ["农产"])
("nsiu" ["农畜"])
("nsji" ["农机"])
("nsju" ["农具"])
("nsjw" ["农家"])
("nslf" ["南斯拉夫"])
("nsli" ["农历"])
("nsln" ["农林"])
("nslv" ["浓绿"])
("nslx" ["浓烈"])
("nsmh" ["农忙"])
("nsmi" ["浓密"])
("nsmk" ["农贸"])
("nsmn" ["农民"])
("nsmz" ["浓眉"])
("nsns" ["浓浓"])
("nsnu" ["农奴"])
("nsqu" ["农区" "农渠"])
("nsqy" ["弄清"])
("nsr'" "弄")
("nsso" ["浓缩"])
("nstm" ["农田"])
("nsts" ["弄通"])
("nsui" ["农时" "农事"])
("nsvs" ["脓肿" "浓重" "农中"])
("nsw'" "脓浓农侬哝")
("nswh" ["你死我活"])
("nswu" ["浓雾"])
("nsxm" ["农闲"])
("nsxt" ["农学"])
("nsye" ["农业"])
("nsyi" ["农艺"])
("nsyj" ["浓烟" "浓艳" "农谚"])
("nsyk" ["农药"])
("nsyu" ["浓郁"])
("ntdl" ["虐待"])
("nte'" ["年头儿"])
("ntji" ["疟疾"])
("ntju" ["农田基本建设"])
("ntr'" "虐疟")
("ntul" ["农田水利"])
("ntv'" ["女同志"])
("nu'" ["那时"])
("nubi" ["奴婢"])
("nucl" ["奴才"])
("nue'" "努弩胬")
("nufh" ["怒放"])
("nuh'" ["那时候"])
("nuhb" ["怒吼"])
("nuhd" ["能说会道"])
("nuho" ["怒火"])
("nuii" ["怒斥"])
("nuik" ["怒潮"])
("nuj'" ["脑神经"])
("nuli" ["奴隶" "努力"])
("numu" ["怒目"])
("nunx" ["能上能下"])
("nupu" ["奴仆"])
("nuqi" ["怒气"])
("nur'" "怒")
("nurs" ["怒容"])
("nutk" ["怒涛"])
("nuw'" "奴孥驽")
("nuyi" ["奴役"])
("nv'" ["那种"])
("nvbv" ["南征北战"])
("nvdv" ["女队"])
("nve'" "女钕")
("nver" ["女儿"])
("nvfh" ["女方"])
("nvgs" ["女工"])
("nvhd" ["女皇"])
("nvhl" ["女孩"])
("nvlh" ["女郎"])
("nvlj" ["女篮"])
("nvpl" ["女排"])
("nvpu" ["女仆"])
("nvr'" ["恧" "衄" "女主人"])
("nvrf" ["女人"])
("nvuf" ["女神"])
("nvug" ["女生"])
("nvui" ["女士"])
("nvvf" ["女真" "女贞"])
("nvwg" ["你追我赶"])
("nvwh" ["女王"])
("nvxu" ["女婿"])
("nvxy" ["女性"])
("nvys" ["女佣"])
("nvzi" ["女子"])
("nwb'" ["内务部"])
("nwf'" ["内务府"])
("nwjk" ["内外交困" "内外跤困"])
("nwkt" ["努瓦克肖特"])
("nwnw" ["能文能武"])
("nwq'" ["难为情"])
("nx'" ["那些"])
("nxa'" ["内酰胺"])
("nxge" ["镍铬"])
("nxhe" ["啮合"])
("nxn'" ["南匈奴"])
("nxq'" "捏")
("nxqi" ["捏起"])
("nxr'" "聂孽啮镊镍涅乜陧蘖嗫颞臬蹑")
("nxuj" ["内心世界"])
("nxvh" ["孽障"])
("nxvu" ["捏住"])
("nxzi" ["镊子"])
("nxzj" ["弄虚作假"])
("nxzk" ["捏造"])
("ny'" ["那样"])
("nybm" ["农业部门"])
("nybo" ["宁波"])
("nydk" ["农业贷款"])
("nydx" ["农业大学"])
("nye'" "拧")
("nyg'" ["扭秧歌" "农业国"])
("nygh" ["宁冈"])
("nygr" ["农业工人"])
("nygu" ["凝固"])
("nyjh" ["农业机械化"])
("nyji" ["凝集"])
("nyjn" ["拧紧"])
("nyjq" ["农业机器"])
("nyju" ["凝聚" "农业技术"])
("nyjx" ["凝结" "农业机械"])
("nyjy" ["宁静"])
("nyke" ["宁可"])
("nykf" ["宁肯"])
("nykl" ["拧开"])
("nyl'" ["内应力"])
("nymg" ["柠檬"])
("nyny" ["柠柠"])
("nyqt" ["宁缺"])
("nyr'" "宁拧泞佞")
("nys'" ["逆运算"])
("nysi" ["凝思"])
("nyu'" ["农业社" "农业税" "农艺师"])
("nyuf" ["凝神"])
("nyui" ["凝视"])
("nyuu" ["农业生产合作社"])
("nyvi" ["凝滞"])
("nyvx" ["农业中学"])
("nyw'" "柠狞凝宁拧苎咛甯聍")
("nywh" ["凝望"])
("nyxc" ["狞笑"])
("nyxw" ["宁夏"])
("nyy'" ["暖洋洋"])
("nyyr" ["宁愿"])
("nzbk" ["内包"])
("nzbu" ["内部"])
("nzcp" ["内存"])
("nzdi" ["内地"])
("nze'" "哪馁")
("nzfu" ["内服"])
("nzge" ["那个" "内阁"])
("nzh'" ["男子汉"])
("nzhe" ["内河"])
("nzhh" ["内行"])
("nzhj" ["内含" "内涵"])
("nzhk" ["内耗"])
("nzhl" ["内海"])
("nzhv" ["那会"])
("nzih" ["内场"])
("nzj'" ["娘子军"])
("nzjc" ["内角"])
("nzjm" ["内奸"])
("nzjx" ["内接"])
("nzjy" ["内经" "内径"])
("nzke" ["内科"])
("nzli" ["内力"])
("nzlk" ["内涝"])
("nzlr" ["内乱"])
("nzlu" ["内戮"])
("nzma" ["内码"])
("nzmg" ["内蒙"])
("nzmu" ["内幕"])
("nzng" ["内能"])
("nzpi" ["内皮"])
("nzpy" ["内平"])
("nzqy" ["内情"])
("nzr'" "那内")
("nzre" ["内热"])
("nzrf" ["内人"])
("nzrj" ["内燃"])
("nzrs" ["内容"])
("nztl" ["内胎"])
("nzuh" ["内伤"])
("nzui" ["内史" "内室"])
("nzvg" ["内政"])
("nzvi" ["内制" "内痔"])
("nzvj" ["内战"])
("nzvr" ["内转"])
("nzvs" ["内中"])
("nzvu" ["内主"])
("nzw'" ["农作物"])
("nzwl" ["内外"])
("nzwu" ["内务"])
("nzxc" ["内销"])
("nzxd" ["内项"])
("nzxm" ["内线"])
("nzxn" ["内心"])
("nzxt" ["内学"])
("nzyi" ["内衣"])
("nzyj" ["内焰"])
("nzyn" ["内因"])
("nzyy" ["内应"])
("nzzh" ["内脏"])
("nzzi" ["内子"])
("nzzl" ["内在"])
("nzzu" ["内阻"])
("o" "欧")
("ojld" ["欧几里得"])
("omdl" ["欧姆定律"])
("ooq'" "喔噢")
("oor'" "哦")
("oow'" "哦")
("orx'" ["偶然性"])
("ouda" ["殴打"])
("oue'" "藕呕偶耦")
("ouer" ["偶尔"])
("ouff" ["藕粉"])
("oufz" ["沤肥"])
("ouge" ["讴歌"])
("ouhe" ["藕合" "偶合" "耦合"])
("ouhw" ["欧化"])
("oumu" ["欧姆"])
("oumz" ["欧美"])
("ouq'" "欧鸥殴沤区讴瓯")
("our'" "呕沤怄")
("ourj" ["偶然"])
("outu" ["呕吐"])
("ouui" ["欧式"])
("ouuu" ["偶数"])
("ouvb" ["欧洲"])
("ouwf" ["欧文"])
("ouxd" ["偶像"])
("ouya" ["欧亚"])
("ouyh" ["欧阳"])
("ovgt" ["欧洲共同体"])
("p" "片")
("paer" ["帕尔"])
("pais" ["爬虫"])
("paku" ["怕苦"])
("pali" ["爬犁"])
("palz" ["怕累"])
("paq'" "扒啪趴派葩")
("par'" "帕怕")
("parf" ["怕人"])
("pasi" ["怕死"])
("pat'" "琶")
("patg" ["怕疼"])
("paug" ["爬升"])
("pauh" ["爬上"])
("pauj" ["爬山"])
("paw'" "扒耙爬杷钯筢")
("paxy" ["爬行"])
("pb'" ["普遍"])
("pbbk" ["疲惫不堪"])
("pbcj" ["普遍裁军"])
("pbdu" ["剖肚"])
("pbe'" "掊")
("pbf'" ["漂白粉"])
("pbfu" ["剖腹"])
("pbgl" ["普遍规律"])
("pbi'" ["平板车"])
("pbjd" ["迫不及待"])
("pbmm" ["剖面"])
("pbmy" ["剖明"])
("pbq'" "剖")
("pbu'" ["判别式"])
("pbui" ["剖视"])
("pbvl" ["普遍真理"])
("pbw'" "裒掊")
("pbx'" ["普遍性"])
("pbxi" ["剖析"])
("pby'" ["平板仪"])
("pcbl" ["漂白"])
("pcbo" ["漂泊"])
("pcdh" ["飘荡"])
("pcdl" ["飘带"])
("pce'" "漂莩缥殍瞟")
("pcfu" ["飘浮" "漂浮"])
("pcis" ["瓢虫"])
("pcju" ["票据"])
("pcjw" ["票价"])
("pcld" ["漂亮"])
("pclo" ["飘落"])
("pclq" ["飘流" "漂流"])
("pcly" ["飘零"])
("pcmc" ["飘渺"])
("pcq'" "飘漂剽缥螵")
("pcqi" ["飘起"])
("pcqx" ["剽窃"])
("pcr'" "漂票嘌骠")
("pcrj" ["飘然"])
("pcsa" ["飘洒"])
("pcsj" ["飘散"])
("pcw'" "瓢朴嫖")
("pcyh" ["飘扬"])
("pcyi" ["漂移"])
("pczi" ["票子"])
("pdh'" ["彭德怀"])
("pdhl" ["平等互利"])
("pdi'" ["璞鼎查"])
("pdid" ["皮带传动"])
("pdj'" ["蒲殿俊"])
("pdl'" ["皮带轮"])
("pdp'" ["配电盘"])
("pdu'" ["平顶山"])
("pei'" ["普洱茶"])
("pf'" ["批发"])
("pfdi" ["盆地"])
("pfdu" ["喷镀"])
("pfg'" ["平方根"])
("pfgl" ["平方公里"])
("pfgr" ["喷管"])
("pfhw" ["喷花"])
("pfjm" ["喷溅"])
("pfjy" ["盆景"])
("pfm'" ["平方米"])
("pfq'" ["喷" "喷粉器"])
("pfqd" ["喷枪" "盆腔"])
("pfqi" ["喷漆" "喷气"])
("pfqr" ["喷泉"])
("pfqs" ["平分秋色"])
("pfr'" "喷")
("pfsa" ["喷洒"])
("pftb" ["喷头"])
("pfti" ["喷嚏"])
("pfue" ["喷射"])
("pfw'" "盆湓")
("pfwu" ["喷雾"])
("pfxd" ["喷香"])
("pfzi" ["盆子"])
("pfzv" ["喷嘴"])
("pgbi" ["碰壁"])
("pgbo" ["蓬勃"])
("pgda" ["膨大"])
("pgdk" ["碰到"])
("pge'" "捧")
("pgig" ["彭城"])
("pgih" ["捧场"])
("pgji" ["抨击"])
("pgjm" ["碰见"])
("pglr" ["蓬乱"])
("pgpg" ["蓬蓬"])
("pgpl" ["澎湃"])
("pgq'" "砰抨烹澎嘭怦")
("pgqc" ["碰巧"])
("pgr'" "碰")
("pgrf" ["烹饪"])
("pgsr" ["硼酸"])
("pgss" ["蓬松"])
("pgtb" ["碰头"])
("pgtc" ["烹调"])
("pgua" ["硼砂"])
("pgvd" ["碰撞"])
("pgvf" ["彭真"])
("pgvh" ["膨胀"])
("pgw'" "澎彭蓬棚硼篷膨朋鹏堋蟛")
("pgyb" ["朋友"])
("pgzi" ["棚子" "篷子"])
("phbj" ["品花宝鉴"])
("phbl" ["旁白"])
("phbm" ["旁边"])
("phbo" ["磅礴"])
("phda" ["庞大"])
("phe'" "耪")
("phgr" ["旁观"])
("phiu" ["平衡常数"])
("phld" ["澎湖列岛"])
("phlu" ["旁路"])
("phm'" ["平衡木"])
("phq'" "膀乓滂")
("phr'" "胖")
("phrf" ["旁人"])
("phts" ["旁通"])
("phty" ["旁听"])
("phub" ["胖瘦"])
("phvg" ["旁证" "胖症"])
("phw'" "膀磅庞旁彷逄螃")
("phxn" ["旁心"])
("phxx" ["螃蟹"])
("phza" ["庞杂"])
("phzi" ["胖子"])
("piao" ["皮袄"])
("pibk" ["皮包"])
("pibm" ["皮鞭"])
("pibo" ["批驳"])
("pibu" ["坯布"])
("pibz" ["疲惫"])
("picg" ["皮层"])
("pidb" ["批斗"])
("pidl" ["皮带"])
("pie'" "否劈匹痞仳圮擗吡庀癖疋")
("pifa" ["批发" "疲乏"])
("pifg" ["披风"])
("pifu" ["批复" "皮肤" "匹夫"])
("pige" ["皮革"])
("pigl" ["批改"])
("pigp" ["皮辊"])
("pigu" ["屁股"])
("pigw" ["披挂"])
("piho" ["批货"])
("piil" ["劈柴"])
("pijm" ["批件"])
("pijq" ["啤酒"])
("pijr" ["疲倦"])
("pijy" ["僻静"])
("pikl" ["劈开"])
("pilc" ["坯料"])
("pild" ["批量"])
("pili" ["霹雳"])
("pilk" ["疲劳"])
("pilm" ["毗连"])
("piln" ["毗邻"])
("pilu" ["披露"])
("pimk" ["皮毛"])
("pimm" ["皮棉" "皮面"])
("pimx" ["破除迷信"])
("pimz" ["媲美"])
("pipa" ["琵琶"])
("pipi" ["皮皮" "枇枇"])
("pipj" ["批判"])
("pipy" ["批评"])
("pipz" ["匹配"])
("piq'" "辟坏坯砒霹批披劈丕邳噼纰铍")
("piqi" ["脾气"])
("piqq" ["皮球"])
("pir'" "辟僻屁譬淠媲甓睥")
("pirb" ["皮肉"])
("piru" ["譬如"])
("pis'" ["派出所"])
("piud" ["砒霜"])
("piui" ["批示"])
("pive" ["披着"])
("pivi" ["皮质"])
("pivp" ["批准"])
("pivr" ["批转"])
("piw'" "琵毗啤脾疲皮陂陴郫埤鼙芘枇罴铍裨蚍蜱貔")
("piwn" ["排除万难"])
("piwz" ["脾胃"])
("pixd" ["皮箱"])
("pixm" ["郫县"])
("pixw" ["皮下"])
("pixx" ["皮鞋"])
("piyj" ["皮炎"])
("piys" ["屁用"])
("piyt" ["批阅"])
("piyu" ["譬喻"])
("pizh" ["脾脏"])
("pizi" ["皮子"])
("pj'" ["平均"])
("pjan" ["判案"])
("pjbm" ["叛变"])
("pjbo" ["盘剥"])
("pjbx" ["判别"])
("pjcp" ["盘存"])
("pjdg" ["攀登"])
("pjdh" ["叛党"])
("pjdm" ["盘点"])
("pjdq" ["平均地权"])
("pjdr" ["判断"])
("pjdy" ["判定"])
("pjfh" ["潘芳"])
("pjfz" ["叛匪"])
("pjgg" ["盘庚"])
("pjgo" ["叛国"])
("pjgr" ["判官"])
("pjgz" ["平均工资"])
("pjho" ["盘货"])
("pjiu" ["判处"])
("pjjp" ["叛军"])
("pjjt" ["判决"])
("pjju" ["盘踞"])
("pjli" ["判例"])
("pjlr" ["叛乱" "平均利润"])
("pjml" ["叛卖"])
("pjmy" ["判明"])
("pjni" ["叛逆"])
("pjq'" "扳番攀潘")
("pjqn" ["攀亲"])
("pjqw" ["平均气温"])
("pjr'" "盼畔判叛拚泮袢襻")
("pjrk" ["盘绕"])
("pjro" ["判若"])
("pjsd" ["平均速度"])
("pjsr" ["盘算"])
("pjtj" ["攀谈"])
("pjtu" ["叛徒"])
("pju'" ["判决书" "平均数"])
("pjuj" ["盘山"])
("pjv'" ["平均值"])
("pjvj" ["披荆斩棘"])
("pjvy" ["平均主义"])
("pjw'" "般盘磐胖爿蟠蹒")
("pjwf" ["盘问"])
("pjwh" ["盼望"])
("pjxr" ["盘旋"])
("pjyr" ["攀援" "攀缘"])
("pjzi" ["盘子"])
("pjzv" ["判罪"])
("pkbm" ["跑遍"])
("pkbu" ["跑步"])
("pkby" ["炮兵"])
("pkcl" ["泡菜"])
("pkdj" ["炮弹"])
("pkdk" ["跑道"])
("pkdm" ["破口大骂"])
("pke'" "跑")
("pkgd" ["抛光"])
("pkh'" ["贫困化"])
("pkho" ["炮火"])
("pkhs" ["炮轰"])
("pkhv" ["炮灰"])
("pkie" ["跑车"])
("pkji" ["炮击"])
("pkjm" ["炮舰"])
("pkkb" ["炮口"])
("pkkl" ["跑开"])
("pklc" ["跑了"])
("pklz" ["跑垒"])
("pkma" ["跑马"])
("pkmk" ["抛锚"])
("pkmo" ["泡沫"])
("pkq'" "抛炮泡脬")
("pkqi" ["抛弃"])
("pkqq" ["抛球"])
("pkr'" "炮泡疱")
("pkta" ["炮塔"])
("pktl" ["炮台"])
("pkts" ["泡桐"])
("pktv" ["跑腿"])
("pkub" ["抛售" "炮手"])
("pkug" ["炮声"])
("pkvi" ["抛掷" "炮制"])
("pkvr" ["抛砖"])
("pkw'" "咆刨炮袍跑匏狍庖")
("pkwu" ["抛物"])
("pkwz" ["炮位"])
("pkxc" ["咆哮"])
("pkyj" ["炮眼"])
("pkzi" ["袍子" "狍子"])
("pl'" ["评论"])
("plbj" ["排版"])
("plbx" ["派别"])
("pld'" ["蒲鲁东"])
("plda" ["拍打"])
("pldv" ["排队"])
("ple'" "排迫")
("plfh" ["牌坊"])
("plgr" ["排灌"])
("plgu" ["排骨"])
("plhf" ["普列汉诺夫"])
("plhk" ["拍号" "牌号"])
("plhy" ["徘徊"])
("plih" ["排场"])
("plii" ["排斥"])
("pliu" ["排除" "派出"])
("plj'" ["评论家"])
("plji" ["排挤"])
("pljw" ["排架" "牌价"])
("pljx" ["排解" "疲劳极限"])
("plk'" ["普朗克"])
("pllb" ["牌楼" "牌搂"])
("pllk" ["排涝"])
("pllm" ["排练"])
("pllr" ["排卵"])
("pllx" ["排列"])
("plly" ["普罗列塔利亚"])
("plm'" ["婆罗门"])
("plml" ["拍卖"])
("plpn" ["拍频"])
("plq'" "拍")
("plqd" ["疲劳强度"])
("plqi" ["排齐" "排气"])
("plqm" ["派遣"])
("plqq" ["排球"])
("plr'" "湃派蒎哌")
("pltb" ["派头"])
("pltn" ["普罗提诺"])
("plu'" ["泼冷水"])
("plub" ["拍手"])
("plue" ["拍摄"])
("plug" ["派生"])
("plui" ["批量生产"])
("pluv" ["排水"])
("plvh" ["排长"])
("plvk" ["拍照"])
("plw'" "排牌徘俳")
("plwh" ["派往"])
("plwl" ["排外"])
("plwz" ["牌位"])
("plxi" ["排戏" "派系"])
("plxu" ["排序"])
("plxx" ["排泄"])
("plxy" ["派性" "频率响应"])
("ply'" ["评论员"])
("plyj" ["排演"])
("plyn" ["排印"])
("plzi" ["拍子" "牌子"])
("plzl" ["排在"])
("pm'" ["品名"])
("pmai" ["偏爱"])
("pmdi" ["片地"])
("pmdr" ["片段" "片断"])
("pme'" "谝")
("pmfu" ["篇幅"])
("pmgh" ["跑马观花"])
("pmia" ["偏差"])
("pmj'" ["平面角" "平面镜"])
("pmjc" ["偏角"])
("pmjh" ["平面几何"])
("pmjm" ["偏见"])
("pmju" ["骗局"])
("pmk'" ["贫民窟"])
("pmke" ["片刻"])
("pmli" ["偏离"])
("pmlq" ["偏流"])
("pmmm" ["片面"])
("pmph" ["偏旁"])
("pmpi" ["偏僻"])
("pmpm" ["偏偏" "翩翩"])
("pmpo" ["偏颇"])
("pmq'" "扁篇偏片犏翩")
("pmqu" ["骗取"])
("pmr'" "片骗")
("pmrf" ["骗人"])
("pmsl" ["泡沫塑料"])
("pmt'" ["平面图" "剖面图"])
("pmtj" ["偏袒"])
("pmui" ["片时"])
("pmuu" ["骗术"])
("pmvf" ["偏振"])
("pmvh" ["篇章"])
("pmvr" ["偏转"])
("pmvs" ["偏重"])
("pmw'" "便骈缏胼蹁")
("pmx'" ["片面性"])
("pmxd" ["偏向"])
("pmxi" ["偏析" "偏西"])
("pmxn" ["偏心"])
("pmya" ["偏压"])
("pmyi" ["便宜"])
("pmyr" ["偏远"])
("pmyu" ["偏于"])
("pmzi" ["片子" "骗子"])
("pnbo" ["拼搏"])
("pncb" ["拼凑"])
("pnde" ["品德"])
("pndk" ["频道"])
("pndl" ["频带"])
("pndr" ["频段"])
("pndu" ["频度"])
("pne'" "品榀")
("pnfa" ["贫乏"])
("pnfj" ["频繁"])
("pnfu" ["贫富"])
("pnge" ["品格"])
("pnhj" ["贫寒"])
("pnhw" ["贫化"])
("pnih" ["品尝"])
("pnir" ["频传"])
("pnji" ["贫瘠" "品级"])
("pnjm" ["贫贱"])
("pnkd" ["贫矿"])
("pnkp" ["贫困"])
("pnku" ["贫苦"])
("pnlv" ["频率"])
("pnlz" ["品类"])
("pnmn" ["贫民"])
("pnmy" ["拼命" "品名"])
("pnns" ["贫农"])
("pnpn" ["频频"])
("pnpu" ["频谱"])
("pnpy" ["品评"])
("pnq'" "拼拚姘")
("pnqs" ["贫穷"])
("pnqy" ["聘请"])
("pnr'" "聘牝")
("pnrf" ["聘任"])
("pnro" ["贫弱"])
("pnuu" ["聘书"])
("pnvi" ["品质"])
("pnvs" ["品种"])
("pnw'" "频贫苹嫔颦")
("pnwz" ["品位"])
("pnxi" ["品系"])
("pnxr" ["聘选"])
("pnxx" ["拼写"])
("pnxy" ["拼形" "品行" "品性"])
("pnyb" ["贫油"])
("pnyn" ["拼音"])
("pnys" ["聘用"])
("poan" ["破案"])
("podi" ["坡地"])
("podk" ["坡道"])
("podu" ["坡度"])
("poe'" "叵钷笸")
("pofz" ["破费"])
("poge" ["破格"])
("pohl" ["迫害"])
("poho" ["破获"])
("pohy" ["破坏"])
("poij" ["破产"])
("poiu" ["破除"])
("pojn" ["迫近"])
("pojq" ["破旧"])
("pojw" ["婆家"])
("pokb" ["破口"])
("pola" ["泼辣"])
("poli" ["破例" "魄力"])
("polj" ["破烂"])
("polo" ["破落"])
("polx" ["破裂"])
("pomx" ["破灭"])
("pond" ["婆娘"])
("popo" ["婆婆"])
("poq'" "泊坡泼颇朴陂泺攴钋")
("poqx" ["迫切"])
("por'" "破魄迫粕朴珀")
("posp" ["破损"])
("posv" ["破碎"])
("potu" ["破土"])
("poui" ["迫使"])
("pouv" ["泼水"])
("povj" ["破绽"])
("pow'" "繁婆鄱皤")
("poxc" ["破晓"])
("poxi" ["婆媳"])
("poyh" ["鄱阳"])
("poyi" ["婆姨" "破译"])
("poyu" ["迫于"])
("pozl" ["迫在"])
("ppbb" ["蓬蓬勃勃"])
("ppd'" ["胖胖的" "蓬皮杜" "批判地"])
("ppj'" ["批评家" "平平加"])
("ppq'" ["乒乓球"])
("ppr'" ["飘飘然"])
("pptt" ["普普通通"])
("pqfj" ["喷气发动机"])
("pqt'" ["铍青铜"])
("pqu'" ["喷气式"])
("prwr" ["旁若无人"])
("pst'" ["喷丝头"])
("pt'" ["普通"])
("ptf'" ["普通法"])
("pth'" ["破天荒" "普通话"])
("ptj'" ["葡萄酒"])
("ptlm" ["抛头露面"])
("ptqj" ["葡萄球菌"])
("ptt'" ["葡萄糖"])
("ptxm" ["普通小麦"])
("pty'" ["葡萄牙" "葡萄园"])
("pub'" ["喷射泵"])
("pubc" ["谱表"])
("pubi" ["扑鼻"])
("pubm" ["普遍"])
("pubu" ["瀑布"])
("pucs" ["仆从"])
("puda" ["扑打"])
("pudh" ["排山倒海"])
("pudm" ["铺垫"])
("pue'" "堡埔朴圃普浦谱溥氆镨蹼")
("puer" ["普尔"])
("pufu" ["匍匐"])
("pug'" ["排水沟" "排水管"])
("pugl" ["铺盖"])
("pugv" ["铺轨"])
("puhk" ["谱号"])
("puia" ["普查"])
("puik" ["拍手称快"])
("pujd" ["浦江"])
("puji" ["普及"])
("pujq" ["扑救"])
("pukb" ["浦口"])
("puke" ["扑克"])
("pul'" ["排水量"])
("puli" ["圃里"])
("pulu" ["铺路"])
("pumx" ["扑灭"])
("pupy" ["铺平"])
("puq'" "扑铺仆噗")
("pur'" "堡暴铺曝瀑")
("purf" ["仆人"])
("pusa" ["菩萨"])
("pusu" ["朴素"])
("put'" ["剖视图"])
("pute" ["普特"])
("puth" ["葡糖"])
("putk" ["葡萄"])
("puts" ["扑通" "普通"])
("puui" ["朴实"])
("puul" ["曝晒"])
("puvk" ["普照"])
("puw'" "脯仆莆葡菩蒲匍濮璞镤")
("puxr" ["普选"])
("puxt" ["排水系统"])
("puxx" ["谱写"])
("puy'" ["陪审员"])
("puyi" ["仆役"])
("puzi" ["铺子" "谱子"])
("pvg'" ["偏振光"])
("pvlf" ["铺张浪费"])
("pvp'" ["偏振片"])
("pvsl" ["配制饲料"])
("pvtd" ["平整土地"])
("pvxq" ["偏转线圈"])
("pvxu" ["膨胀系数"])
("pvyu" ["品质因数"])
("pwq'" ["喷雾器"])
("pwx'" ["抛物线"])
("pxbd" ["品行不端"])
("pxdw" ["爬行动物"])
("pxdy" ["披星戴月"])
("pxe'" "撇丿苤")
("pxj'" ["普希金"])
("pxjm" ["瞥见"])
("pxkl" ["撇开"])
("pxl'" ["偏心轮"])
("pxlt" ["平行六面体"])
("pxq'" "撇瞥氕")
("pxsx" ["平行四边形"])
("pxvn" ["贫下中农"])
("pxw'" ["排泄物"])
("pxx'" ["平行线"])
("pxzv" ["撇嘴"])
("pxzy" ["平行作业"])
("py'" ["拼音"])
("pyan" ["平安"])
("pyba" ["坪坝"])
("pybi" ["评比" "屏蔽"])
("pybj" ["平板"])
("pyce" ["评测"])
("pydc" ["平调"])
("pydg" ["平等"])
("pydi" ["平地"])
("pydj" ["平淡" "凭单"])
("pyds" ["平动" "平峒"])
("pydu" ["平度"])
("pydy" ["平顶" "平定" "评定"])
("pyff" ["平分" "评分"])
("pyfg" ["屏风"])
("pyfh" ["平方" "平房"])
("pyfj" ["平凡" "平反"])
("pygo" ["苹果"])
("pygs" ["评工"])
("pygu" ["平谷"])
("pyhe" ["平和"])
("pyhg" ["平衡"])
("pyhh" ["平巷"])
("pyhr" ["平缓"])
("pyhw" ["平滑" "平话" "评话"])
("pyie" ["平车"])
("pyih" ["平常"])
("pyir" ["平川"])
("pyj'" ["培养基"])
("pyjc" ["平角"])
("pyjd" ["评奖"])
("pyji" ["屏极"])
("pyjp" ["平均"])
("pyjr" ["平易近人"])
("pyju" ["凭据" "评剧"])
("pyjw" ["平价" "评价"])
("pyjx" ["凭借" "评介"])
("pyjy" ["平静"])
("pyks" ["凭空"])
("pyld" ["平凉"])
("pyli" ["评理"])
("pylj" ["凭栏"])
("pylp" ["评论"])
("pylu" ["平炉"])
("pymb" ["培养目标"])
("pymm" ["平面"])
("pymn" ["平民"])
("pymu" ["屏幕"])
("pypc" ["凭票"])
("pyph" ["乒乓"])
("pypj" ["评判"])
("pypy" ["平平"])
("pyq'" ["乒" "俜" "娉" "喷油器"])
("pyrh" ["平壤"])
("pyri" ["平日"])
("pyrs" ["平绒"])
("pysu" ["平素"])
("pytb" ["平头"])
("pytc" ["平粜"])
("pytj" ["乒坛" "平坦"])
("pytl" ["平台"])
("pyug" ["平生"])
("pyui" ["平时" "平视"])
("pyup" ["平顺"])
("pyvd" ["平装" "瓶装"])
("pyvg" ["平整" "平正" "凭证"])
("pyvh" ["屏障"])
("pyw'" "冯坪苹萍平凭瓶评屏枰鲆")
("pywf" ["平纹" "平稳"])
("pywz" ["拼音文字" "评为"])
("pyxd" ["萍乡"])
("pyxi" ["平西" "平息"])
("pyxr" ["评选"])
("pyxy" ["平行"])
("pyye" ["平野"])
("pyyh" ["平阳"])
("pyyi" ["平一" "平移" "评议"])
("pyyr" ["平原"])
("pyys" ["平庸"])
("pyyu" ["评语"])
("pyze" ["平仄"])
("pyzi" ["瓶子"])
("pyzm" ["拼音字母"])
("pzbf" ["赔本"])
("pzbh" ["陪绑"])
("pzbj" ["陪伴"])
("pzbz" ["配备"])
("pzcg" ["胚层"])
("pzdi" ["配第"])
("pzdl" ["佩戴"])
("pzdm" ["配电"])
("pzdv" ["配对"])
("pzfh" ["配方"])
("pzfu" ["佩服"])
("pzgf" ["胚根" "培根"])
("pzhe" ["配合"])
("pzif" ["陪衬"])
("pzih" ["赔偿"])
("pzjc" ["配角"])
("pzjm" ["配件"])
("pzke" ["陪客"])
("pzkr" ["赔款"])
("pzlc" ["赔了" "配料"])
("pzli" ["赔礼"])
("pzmj" ["迫在眉睫"])
("pzou" ["配偶"])
("pzq'" "呸胚醅")
("pzqi" ["配器"])
("pzqm" ["赔钱"])
("pzr'" "配佩沛辔帔旆霈")
("pzru" ["胚乳"])
("pzse" ["配色"])
("pztk" ["配套"])
("pztl" ["胚胎"])
("pzts" ["陪同"])
("pztu" ["培土"])
("pzuf" ["陪审"])
("pzvb" ["胚轴"])
("pzve" ["陪着"])
("pzvi" ["培植" "配置" "配制"])
("pzvs" ["配种"])
("pzvu" ["胚珠"])
("pzw'" "培裴赔陪锫")
("pzxp" ["培训"])
("pzya" ["胚芽"])
("pzyb" ["配有"])
("pzyh" ["培养"])
("pzyk" ["配药"])
("pzyu" ["培育"])
("pzzi" ["配子"])
("pzzv" ["赔罪"])
("q" "七")
("qb'" ["全部"])
("qbj'" ["球半径"])
("qbq'" ["瞧不起"])
("qbs'" ["情报所"])
("qbu'" ["瞧不上"])
("qbw'" ["千百万"])
("qbwh" ["千变万化"])
("qbx'" ["漆包线"])
("qbz'" ["穷棒子"])
("qbzj" ["情不自禁"])
("qc'" ["其次"])
("qcbi" ["峭壁"])
("qcbk" ["侨胞"])
("qcda" ["敲打"])
("qcdp" ["桥墩"])
("qce'" "悄巧雀愀")
("qcgj" ["巧干"])
("qche" ["巧合"])
("qchv" ["侨汇"])
("qcii" ["鞘翅"])
("qcji" ["敲击"])
("qcjm" ["瞧见"])
("qcjr" ["侨眷"])
("qcju" ["侨居"])
("qckl" ["撬开"])
("qcld" ["桥梁"])
("qcmc" ["巧妙"])
("qcmf" ["窍门"])
("qcml" ["荞麦"])
("qcmm" ["桥面"])
("qcmn" ["侨民"])
("qcmu" ["乔木"])
("qcpi" ["俏皮"])
("qcq'" "橇锹敲悄雀劁缲硗跷")
("qcqc" ["悄悄" "瞧瞧"])
("qcqj" ["去粗取精"])
("qcql" ["群策群力"])
("qcqm" ["乔迁"])
("qcr'" "壳鞘撬翘峭俏窍诮谯")
("qcrj" ["悄然"])
("qcsl" ["青粗饲料"])
("qctb" ["桥头"])
("qctl" ["桥台"])
("qcva" ["敲诈"])
("qcvi" ["乔治"])
("qcw'" "蕉桥瞧乔侨翘谯荞峤憔樵鞒")
("qcwu" ["侨务"])
("qcxy" ["桥形"])
("qd'" ["清单"])
("qdb'" ["球蛋白"])
("qdbi" ["枪毙" "墙壁"])
("qdbk" ["强暴"])
("qdcw" ["缺点错误"])
("qdda" ["强大"])
("qddc" ["腔调" "强调"])
("qddj" ["枪弹"])
("qddk" ["强盗"])
("qddm" ["强电"])
("qddo" ["抢夺"])
("qddu" ["强度" "强渡"])
("qde'" "强抢镪襁羟")
("qdf'" ["卿大夫"])
("qdfg" ["强风"])
("qdgb" ["抢购"])
("qdgf" ["墙根"])
("qdgj" ["枪杆"])
("qdgo" ["强国"])
("qdgu" ["强固"])
("qdhi" ["恰到好处"])
("qdhj" ["强悍"])
("qdhw" ["强化"])
("qdi'" ["气垫船"])
("qdj'" ["起动机"])
("qdjc" ["墙脚" "墙角"])
("qdji" ["墙基" "羟基"])
("qdjm" ["强奸" "强碱" "强健"])
("qdjq" ["抢救"])
("qdjt" ["枪决"])
("qdjw" ["强加"])
("qdjx" ["强度极限" "抢劫"])
("qdkb" ["枪口"])
("qdl'" ["气动力"])
("qdli" ["强力"])
("qdlt" ["抢掠"])
("qdlx" ["强烈"])
("qdpk" ["枪炮"])
("qdpl" ["强拍"])
("qdpo" ["强迫"])
("qdq'" "将枪呛腔羌抢戕戗锖锵镪蜣跄")
("qdqq" ["强求"])
("qdqr" ["强权"])
("qdr'" "呛戗炝跄")
("qdro" ["强弱"])
("qdsr" ["强酸"])
("qdtb" ["墙头"])
("qdto" ["枪托"])
("qdua" ["枪杀"])
("qdub" ["抢收"])
("qdug" ["枪声" "强盛"])
("qduh" ["抢墒"])
("qdui" ["强使"])
("qdvd" ["强壮"])
("qdve" ["强者"])
("qdvi" ["枪支" "强制"])
("qdvj" ["起动转矩" "强占" "抢占"])
("qdvs" ["抢种"])
("qdw'" "墙蔷强嫱樯")
("qdwz" ["蔷薇"])
("qdxm" ["抢先" "抢险"])
("qdxq" ["抢修"])
("qdxx" ["枪械"])
("qdxy" ["强行"])
("qdyy" ["强硬"])
("qdzo" ["强作"])
("qdzu" ["羌族"])
("qedv" ["取而代之"])
("qeu'" ["雀儿山"])
("qeyj" ["轻而易举"])
("qfb'" ["千分表"])
("qfbj" ["千方百计"])
("qfq'" ["潜伏期"])
("qfs'" ["氢氟酸"])
("qfu'" ["全反射"])
("qfv'" ["缺乏症"])
("qfy'" ["切分音"])
("qg'" ["全国"])
("qgd'" ["穷光蛋"])
("qggd" ["全国各地"])
("qgjl" ["全国纪录" "清规戒律"])
("qgjx" ["勤工俭学"])
("qgvx" ["勤工助学"])
("qgx'" ["全国性"])
("qgxd" ["旗鼓相当"])
("qgy'" ["轻工业"])
("qgyb" ["轻工业部"])
("qgz'" ["枪杆子"])
("qhbj" ["青黄不接"])
("qhd'" ["秦皇岛"])
("qhdx" ["清华大学"])
("qhf'" ["氰化法"])
("qhh'" ["气呼呼"])
("qhj'" ["氰化钾"])
("qhl'" ["亲和力"])
("qhlb" ["权衡利弊"])
("qhnx" ["骑虎难下"])
("qhq'" ["汽化器"])
("qhu'" ["青海省"])
("qhw'" ["氢化物"])
("qhzb" ["青红皂白"])
("qi'" ["清除"])
("qibd" ["取长补短"])
("qibi" ["起笔" "启闭"])
("qibk" ["起爆" "汽包"])
("qibl" ["千锤百炼"])
("qibu" ["七步" "起步"])
("qiby" ["奇兵" "骑兵"])
("qibz" ["齐备"])
("qici" ["其次"])
("qicj" ["凄惨"])
("qick" ["起草"])
("qicl" ["器材"])
("qidc" ["起吊"])
("qidi" ["汽笛" "钦差大臣"])
("qidj" ["契丹"])
("qidk" ["祈祷"])
("qidl" ["期待"])
("qidm" ["起点" "气垫"])
("qids" ["起动" "启动" "气动"])
("qie'" "稽起岂乞企启芑屺绮杞綮")
("qiee" ["企鹅"])
("qier" ["其二"])
("qifa" ["启发" "气阀"])
("qiff" ["气氛" "气愤"])
("qifg" ["奇峰" "启封"])
("qifu" ["欺负" "起伏" "起复"])
("qifz" ["起飞" "岂非"])
("qige" ["七个"])
("qigh" ["气缸" "汽缸"])
("qigj" ["旗杆" "岂敢"])
("qigk" ["起稿"])
("qigl" ["乞丐" "气概"])
("qigo" ["汽锅"])
("qigr" ["奇观" "企管" "器官"])
("qigs" ["七公" "气功"])
("qigy" ["奇怪"])
("qihb" ["气候"])
("qihk" ["旗号"])
("qiho" ["起火"])
("qihw" ["气化" "汽化"])
("qihz" ["漆黑"])
("qii'" ["气冲冲"])
("qiia" ["沏茶"])
("qiid" ["起床"])
("qiie" ["骑车" "汽车"])
("qiig" ["起程" "启程"])
("qiih" ["齐唱"])
("qiii" ["七尺"])
("qiir" ["气喘" "汽船"])
("qiiu" ["起初"])
("qiiv" ["汽锤"])
("qiji" ["奇迹" "契机" "气机"])
("qijm" ["期间" "其间" "起见" "器件"])
("qijn" ["起劲" "迄今"])
("qijt" ["七绝"])
("qiju" ["起居" "器具"])
("qijw" ["起家"])
("qijx" ["气节"])
("qijy" ["奇景"])
("qika" ["契卡"])
("qikb" ["气口"])
("qikj" ["期刊"])
("qikl" ["起开"])
("qiks" ["气孔"])
("qild" ["凄凉" "器量" "气量"])
("qilg" ["气冷"])
("qili" ["起立" "气力"])
("qill" ["起来"])
("qilo" ["起落"])
("qilp" ["汽轮"])
("qilq" ["气流"])
("qilu" ["歧路"])
("qilv" ["七律"])
("qily" ["欺凌"])
("qima" ["骑马" "起码"])
("qimc" ["奇妙"])
("qimf" ["祁门" "气门"])
("qimg" ["启蒙"])
("qimi" ["气密"])
("qimj" ["期满"])
("qimk" ["起毛"])
("qimn" ["器皿"])
("qimy" ["齐明" "齐名"])
("qing" ["岂能"])
("qinh" ["气囊"])
("qink" ["气恼"])
("qinm" ["七年"])
("qinz" ["气馁"])
("qiou" ["奇偶"])
("qipc" ["期票"])
("qipj" ["棋盘"])
("qipk" ["旗袍" "起跑" "起泡" "气泡"])
("qipl" ["气派"])
("qipm" ["欺骗"])
("qipo" ["气魄"])
("qiq'" ["缉" "期" "欺" "栖" "戚" "妻" "七" "凄" "漆" "柒" "沏" "萋" "嘁" "桤" "槭" "欹" "蹊" "青春期"])
("qiqd" ["砌墙"])
("qiqi" ["七七" "漆器"])
("qiqq" ["祈求" "乞求" "企求" "气球"])
("qiqr" ["齐全" "弃权"])
("qiqu" ["崎岖"])
("qir'" "妻齐契砌器气迄弃汽泣讫亟葺汔憩碛")
("qirf" ["旗人"])
("qiri" ["期日"])
("qirj" ["凄然"])
("qise" ["起色" "气色"])
("qisu" ["起诉"])
("qita" ["其他" "其它"])
("qitb" ["起头"])
("qitc" ["起跳"])
("qite" ["奇特"])
("qiti" ["气体"])
("qitj" ["奇谈"])
("qitk" ["齐套" "乞讨"])
("qitl" ["气态"])
("qitm" ["气田"])
("qits" ["气筒"])
("qitu" ["歧途" "企图"])
("qity" ["汽艇"])
("qiub" ["棋手" "旗手"])
("qiuf" ["起身"])
("qiug" ["七声" "齐声"])
("qiui" ["七十" "其实" "其事" "奇事" "歧视" "骑士" "起始" "起事" "起誓" "启示" "器使" "气势"])
("qiuj" ["琦善"])
("qiuu" ["奇数"])
("qiuv" ["汽水"])
("qiva" ["欺诈"])
("qive" ["起着"])
("qivg" ["齐整"])
("qivi" ["旗帜" "岂止" "气质" "弃置"])
("qivs" ["其中" "起重" "器重"])
("qiw'" "其棋奇歧畦崎脐齐旗祈祁骑亓俟圻芪荠萁蕲岐淇骐琪琦耆祺颀蛴蜞綦鳍麒")
("qiwb" ["千差万别"])
("qiwf" ["奇闻" "气温"])
("qiwh" ["期望" "起网" "企望"])
("qiwu" ["欺侮" "器物"])
("qiwz" ["气味"])
("qix'" ["铅垂线"])
("qixd" ["气象"])
("qixi" ["栖息" "气息"])
("qixm" ["期限" "起先"])
("qixn" ["齐心"])
("qixu" ["气虚"])
("qixx" ["器械"])
("qixy" ["七星" "气性"])
("qiya" ["欺压" "气压"])
("qiyb" ["汽油"])
("qiye" ["企业"])
("qiyi" ["七一" "其一" "奇异" "起义"])
("qiyj" ["气焰"])
("qiyn" ["七音" "起因"])
("qiyp" ["起运"])
("qiyr" ["起源"])
("qiys" ["起用" "启用" "器用"])
("qiyt" ["七月" "契约" "器乐"])
("qiyu" ["其余" "奇遇" "气宇"])
("qizi" ["妻子" "棋子" "旗子" "起子"])
("qj'" ["期间"])
("qjd'" ["千斤顶"])
("qjg'" ["戚继光"])
("qju'" ["轻金属"])
("qjwh" ["千家万户"])
("qjwm" ["千军万马"])
("qjwv" ["迄今为止"])
("qjy'" ["强加于" "取决于"])
("qjyf" ["千钧一发"])
("qjyr" ["强加于人"])
("qk'" ["情况"])
("qkdu" ["旗开得胜"])
("qkl'" ["气孔率" "巧克力"])
("qkq'" ["秦可卿"])
("ql'" ["权利"])
("qlfj" ["汽轮发电机"])
("qlj'" ["起落架" "汽轮机"])
("qlm'" ["千里马"])
("qlmm" ["巧立名目"])
("qlnl" ["权利能力"])
("qlu'" ["祁连山"])
("qlus" ["气力输送"])
("qlv'" ["千粒重" "侵略者"])
("qlvv" ["侵略战争"])
("qly'" ["千里眼"])
("qlyd" ["球类运动"])
("qlyf" ["全力以赴"])
("qm'" ["全面"])
("qmbi" ["铅笔" "钱币" "前臂"])
("qmbj" ["铅版"])
("qmbk" ["钱包"])
("qmbm" ["前边"])
("qmbo" ["浅薄"])
("qmbz" ["前辈"])
("qmci" ["前次"])
("qmcl" ["钱财"])
("qmdi" ["前敌"])
("qmds" ["牵动"])
("qmdu" ["迁都"])
("qmdx" ["轻描淡写"])
("qmdy" ["签订"])
("qme'" "遣浅谴缱肷")
("qmee" ["前额"])
("qmfa" ["签发"])
("qmff" ["铅粉"])
("qmfg" ["前锋"])
("qmfh" ["前方"])
("qmfj" ["遣返"])
("qmfu" ["千伏" "前夫" "潜伏"])
("qmgg" ["浅耕"])
("qmgs" ["钳工"])
("qmgu" ["千古"])
("qmgw" ["牵挂"])
("qmhb" ["前后"])
("qmhe" ["千赫"])
("qmhj" ["前汉"])
("qmhl" ["浅海"])
("qmhu" ["千户"])
("qmia" ["扦插"])
("qmie" ["牵扯" "前车"])
("qmig" ["前程" "虔诚"])
("qmih" ["前场"])
("qmj'" ["清棉机"])
("qmjc" ["前脚"])
("qmjh" ["球面几何"])
("qmjm" ["前件"])
("qmjn" ["千斤" "千金" "前进"])
("qmjq" ["迁就"])
("qmju" ["迁居"])
("qmjw" ["欠佳"])
("qmjy" ["前景"])
("qmka" ["千卡"])
("qmkd" ["铅矿"])
("qmke" ["千克"])
("qmkp" ["乾坤"])
("qmkr" ["欠款"])
("qmld" ["钱粮"])
("qmli" ["千里" "前例" "潜力"])
("qmll" ["前来"])
("qmlm" ["牵连"])
("qmlp" ["前轮"])
("qmls" ["乾隆"])
("qmlx" ["前列"])
("qmmf" ["前门"])
("qmmi" ["千米"])
("qmmm" ["前面"])
("qmmo" ["阡陌"])
("qmmu" ["千亩"])
("qmmy" ["签名"])
("qmnm" ["前年"])
("qmpl" ["前排"])
("qmq'" "牵扦钎铅千迁签仟谦佥阡芊岍悭骞搴褰愆")
("qmqc" ["前桥"])
("qmqd" ["牵强"])
("qmqi" ["前期"])
("qmqm" ["浅浅"])
("qmqn" ["前秦"])
("qmqq" ["铅球" "千秋"])
("qmqt" ["欠缺"])
("qmqu" ["前驱" "前去"])
("qmqy" ["前清"])
("qmr'" "堑嵌欠歉纤倩芡茜慊椠")
("qmre" ["潜热"])
("qmrf" ["前人" "前任"])
("qmrh" ["谦让"])
("qmri" ["前日"])
("qmru" ["迁入" "潜入" "嵌入"])
("qms'" ["青霉素"])
("qmse" ["浅色"])
("qmsj" ["遣散"])
("qmso" ["前所"])
("qmss" ["遣送"])
("qmsu" ["茜素"])
("qmsv" ["千岁" "全民所有制"])
("qmsx" ["球面三角形"])
("qmtb" ["前头"])
("qmti" ["前提"])
("qmtk" ["潜逃"])
("qmtl" ["前台"])
("qmtm" ["前天"])
("qmto" ["欠妥"])
("qmtp" ["全民投票"])
("qmtu" ["前途"])
("qmty" ["前庭" "潜艇"])
("qmub" ["歉收"])
("qmue" ["牵涉"])
("qmuf" ["牵伸" "前身" "欠身"])
("qmug" ["千升"])
("qmui" ["前世"])
("qmuj" ["铅山"])
("qmuk" ["前哨"])
("qmuu" ["签署"])
("qmuv" ["潜水"])
("qmvb" ["千周"])
("qmvd" ["钱庄"])
("qmve" ["前者"])
("qmvg" ["签证"])
("qmvi" ["牵制" "钳制" "前肢"])
("qmvl" ["欠债"])
("qmvt" ["球墨铸铁"])
("qmvu" ["签注"])
("qmvw" ["前爪"])
("qmw'" "乾黔钱钳前潜荨掮犍钤虔箝鬈")
("qmwa" ["千瓦"])
("qmwh" ["前往"])
("qmwj" ["千万" "亲密无间"])
("qmwz" ["前卫"])
("qmx'" ["全面性"])
("qmxd" ["前项"])
("qmxi" ["迁西" "迁徙" "前夕"])
("qmxm" ["前线" "浅显"])
("qmxp" ["谦逊"])
("qmxu" ["谦虚"])
("qmxw" ["欠下"])
("qmxx" ["前些"])
("qmyd" ["启蒙运动"])
("qmye" ["前夜"])
("qmyi" ["迁移" "歉意"])
("qmyj" ["前言" "前沿"])
("qmyn" ["牵引"])
("qmyr" ["千元" "前院"])
("qmys" ["潜泳"])
("qmzb" ["前奏"])
("qmze" ["谴责"])
("qmzi" ["钎子" "铅字" "千字" "签字" "钳子"])
("qmzl" ["潜在"])
("qmzo" ["前作"])
("qn'" ["去年"])
("qnai" ["亲爱"])
("qnbi" ["亲笔"])
("qncl" ["芹菜"])
("qndl" ["秦代"])
("qndo" ["侵夺"])
("qne'" "寝")
("qnff" ["勤奋"])
("qnfj" ["侵犯"])
("qnh'" ["牵牛花"])
("qnhl" ["侵害"])
("qnih" ["亲尝"])
("qnjm" ["琴键" "勤俭"])
("qnjn" ["亲近"])
("qnkb" ["亲口"])
("qnkf" ["勤恳"])
("qnky" ["勤快"])
("qnlk" ["勤劳"])
("qnlt" ["侵略"])
("qnlv" ["秦律"])
("qnly" ["秦岭"])
("qnma" ["琴马"])
("qnmi" ["亲密"])
("qnna" ["擒拿"])
("qnnd" ["亲娘"])
("qnni" ["亲昵"])
("qnpz" ["钦佩"])
("qnq'" "钦侵亲衾")
("qnqi" ["亲戚"])
("qnqn" ["亲亲"])
("qnqr" ["侵权"])
("qnqx" ["亲切"])
("qnqy" ["亲情"])
("qnr'" ["沁" "揿" "吣" "青年人"])
("qnre" ["亲热"])
("qnrf" ["亲人"])
("qnrk" ["侵扰"])
("qnru" ["侵入"])
("qntp" ["侵吞"])
("qnub" ["亲手" "禽兽"])
("qnue" ["禽舍"])
("qnuf" ["亲身"])
("qnug" ["亲生"])
("qnui" ["侵蚀" "亲事" "寝室"])
("qnuu" ["亲属"])
("qnvb" ["钦州"])
("qnvg" ["亲征" "亲政"])
("qnvj" ["侵占"])
("qnw'" "秦琴勤芹擒禽芩嗪噙廑溱檎锓矜覃螓")
("qnwh" ["亲王" "勤王"])
("qnwu" ["勤务"])
("qnxi" ["侵袭"])
("qnxm" ["琴弦"])
("qnxn" ["亲信"])
("qnxt" ["勤学"])
("qnyb" ["亲友"])
("qnyj" ["亲眼"])
("qnyt" ["侵越"])
("qnzi" ["亲自"])
("qnzu" ["亲族"])
("qpb'" ["气泡病"])
("qpdk" ["群岛"])
("qpfg" ["群峰"])
("qphj" ["前仆后继"])
("qphp" ["群婚"])
("qpju" ["群居"])
("qplo" ["群落"])
("qpq'" ["逡" "起跑器"])
("qpqi" ["群起"])
("qpqy" ["群情"])
("qpti" ["群体"])
("qpu'" ["枪炮声"])
("qpvs" ["群众"])
("qpw'" "裙群麇")
("qpxc" ["群小"])
("qpyl" ["千篇一律"])
("qpzi" ["裙子"])
("qq'" ["弃权"])
("qqbo" ["秋播"])
("qqdb" ["全权代表"])
("qqds" ["秋冬"])
("qqdv" ["球队"])
("qqe'" "糗")
("qqff" ["秋分"])
("qqfg" ["秋风"])
("qqfj" ["囚犯"])
("qqgf" ["求根"])
("qqgg" ["秋耕"])
("qqgo" ["球果"])
("qqhb" ["秋后"])
("qqhd" ["巧取豪夺"])
("qqhe" ["齐齐哈尔" "求和"])
("qqhh" ["前前后后"])
("qqhp" ["求婚"])
("qqig" ["求成"])
("qqih" ["球场"])
("qqii" ["清清楚楚"])
("qqiu" ["求出"])
("qqjc" ["求教"])
("qqji" ["秋季"])
("qqjn" ["囚禁"])
("qqjp" ["球菌"])
("qqjq" ["求救"])
("qqkk" ["勤勤恳恳"])
("qqly" ["丘陵"])
("qqmf" ["球门"])
("qqmm" ["球面"])
("qqpl" ["球拍"])
("qqq'" "龟秋丘邱湫楸蚯鳅")
("qqqm" ["秋千"])
("qqqr" ["求全"])
("qqqy" ["求情"])
("qqrf" ["求人"])
("qqs'" ["氢氰酸"])
("qqse" ["秋色"])
("qqsl" ["球赛"])
("qqti" ["球体"])
("qqtl" ["球台"])
("qqtm" ["秋天" "秋田"])
("qqub" ["秋收"])
("qqug" ["求生"])
("qqui" ["求实" "求是"])
("qquv" ["秋水"])
("qqvd" ["球状"])
("qqvg" ["求证"])
("qqvh" ["酋长"])
("qqvi" ["求知" "求职"])
("qqw'" "仇球求囚酋泅俅巯犰逑遒赇虬蝤裘鼽")
("qqwh" ["球网"])
("qqww" ["千千万万"])
("qqxf" ["恰恰相反"])
("qqxn" ["球心"])
("qqxp" ["秋汛"])
("qqxt" ["求学"])
("qqxx" ["球鞋"])
("qqxy" ["球形"])
("qqyr" ["求援"])
("qqyu" ["秋雨"])
("qqzb" ["求全责备"])
("qrbu" ["全部"])
("qrcp" ["全村"])
("qrdb" ["全都"])
("qrdg" ["全等"])
("qrdh" ["全党"])
("qrdi" ["圈地"])
("qrdk" ["劝导"])
("qrdm" ["圈点"])
("qre'" "犬绻畎")
("qrfu" ["全副"])
("qrgk" ["劝告"])
("qrgo" ["全国"])
("qrgu" ["颧骨"])
("qrgv" ["权贵"])
("qrhg" ["权衡" "全衡"])
("qrhv" ["全会"])
("qrif" ["权臣"])
("qrig" ["全城" "全成" "全程"])
("qrih" ["全场" "全厂"])
("qrjc" ["全角"])
("qrji" ["全集" "拳击"])
("qrjn" ["劝进"])
("qrjp" ["全军"])
("qrju" ["全局"])
("qrjw" ["全家"])
("qrjy" ["全景"])
("qrkl" ["全开"])
("qrld" ["圈梁"])
("qrli" ["权利" "权力" "全力"])
("qrma" ["全码"])
("qrmk" ["全貌"])
("qrmm" ["全面"])
("qrmn" ["全民"])
("qrng" ["权能" "全能"])
("qrnm" ["全年"])
("qrpj" ["全盘"])
("qrq'" "圈悛")
("qrqf" ["恰如其分"])
("qrqq" ["全球"])
("qrqr" ["全权"])
("qrr'" "券劝")
("qrrf" ["全人"])
("qrrj" ["全然"])
("qrsu" ["全速"])
("qrt'" ["侵入体"])
("qrtb" ["拳头"])
("qrti" ["全体"])
("qrtk" ["圈套" "全套"])
("qrtm" ["全天"])
("qruf" ["全身"])
("qrug" ["全省" "全盛" "全胜"])
("qrui" ["权时" "权势" "全是" "全市"])
("qruo" ["劝说"])
("qruu" ["权术" "权数" "全书" "全数"])
("qruv" ["泉水"])
("qrv'" ["全日制"])
("qrvb" ["泉州"])
("qrvt" ["欺人之谈"])
("qrvu" ["全住"])
("qrw'" "颧权醛泉全痊拳诠荃辁铨蜷筌鬈")
("qrwf" ["全文"])
("qrwu" ["全无"])
("qrwz" ["权威" "劝慰"])
("qrxi" ["全息"])
("qrxm" ["权限" "全县" "全线"])
("qrxn" ["全新"])
("qrxy" ["全行" "全醒"])
("qryi" ["权益"])
("qryj" ["泉眼"])
("qryk" ["权要"])
("qryn" ["全音"])
("qryr" ["泉源"])
("qryu" ["痊愈"])
("qrzi" ["圈子"])
("qrzu" ["劝阻"])
("qsdv" ["穷队"])
("qshw" ["琼华"])
("qsjd" ["琼浆"])
("qsjn" ["穷尽"])
("qskp" ["穷困"])
("qsku" ["穷苦"])
("qsl'" ["青饲料"])
("qsrf" ["穷人"])
("qsu'" ["起诉书"])
("qsvi" ["琼脂"])
("qsvv" ["穷追"])
("qsw'" "琼穷邛茕穹蛩筇跫銎")
("qswl" ["千丝万缕"])
("qswy" ["前所未有"])
("qsyk" ["琼瑶"])
("qt'" ["其它"])
("qtba" ["却把"])
("qtbj" ["齐头并进" "雀斑"])
("qtbk" ["确保"])
("qtbu" ["却不" "却步"])
("qtbz" ["却被"])
("qtde" ["缺德"])
("qtdh" ["确当"])
("qtdm" ["缺点"])
("qtdy" ["确定"])
("qtfa" ["缺乏"])
("qtgl" ["奇谈怪论"])
("qtgz" ["却给"])
("qtj'" ["钱塘江"])
("qtkb" ["缺口"])
("qtli" ["确立"])
("qtmc" ["缺苗"])
("qtng" ["却能"])
("qtq'" ["缺" "炔" "阙" "青铜器"])
("qtqc" ["鹊桥"])
("qtqn" ["缺勤"])
("qtqx" ["确切"])
("qtr'" "却鹊榷确雀阕阙悫")
("qtrf" ["确认"])
("qtrl" ["气体燃料"])
("qtug" ["缺省"])
("qtui" ["确实" "确是"])
("qtuk" ["缺少"])
("qtuo" ["却说"])
("qtuu" ["确属"])
("qtw'" "瘸")
("qtwx" ["千头万绪"])
("qtxi" ["缺席"])
("qtxm" ["缺陷"])
("qtxn" ["确信"])
("qtyb" ["却有" "却又" "确有"])
("qtyk" ["却要"])
("qtzi" ["瘸子"])
("qtzl" ["却在"])
("qtzo" ["确凿"])
("qu'" ["其实"])
("qubj" ["七手八脚"])
("qubk" ["取保"])
("qubx" ["区别"])
("quby" ["曲柄"])
("qucl" ["取材"])
("qucs" ["屈从"])
("qudc" ["曲调" "去掉"])
("qude" ["取得"])
("qudi" ["曲笛" "取缔"])
("qudk" ["渠道" "取道"])
("qudl" ["取代"])
("qudm" ["欺世盗名"])
("quds" ["驱动"])
("que'" "曲取娶龋苣")
("quf'" ["请师傅"])
("qufa" ["取法"])
("quff" ["区分"])
("qufu" ["曲阜" "屈服"])
("qug'" ["清史稿"])
("qugj" ["躯干" "驱赶"])
("qugv" ["全神贯注"])
("qugz" ["去给"])
("quho" ["取火"])
("quhw" ["区划"])
("quie" ["驱车"])
("quii" ["龋齿"])
("quiu" ["驱除" "取出" "去处"])
("quj'" ["全世界"])
("qujm" ["区间"])
("qujp" ["曲菌"])
("qujq" ["去就"])
("qujt" ["取决"])
("qujx" ["曲解"])
("qujy" ["穷奢极欲" "取经" "取景"])
("qukr" ["取款"])
("qukx" ["切实可行"])
("qulu" ["去路"])
("qulv" ["曲率"])
("quly" ["切身利益"])
("qumm" ["曲面"])
("qumz" ["曲霉"])
("qun'" ["青少年"])
("quna" ["去拿"])
("qunm" ["去年"])
("qunr" ["取暖"])
("qupl" ["曲牌"])
("qupu" ["曲谱"])
("quq'" ["趋" "区" "蛆" "曲" "躯" "屈" "驱" "诎" "岖" "觑" "祛" "蛐" "麴" "黢" "清水墙"])
("quqc" ["取巧"])
("quqj" ["桥式起重机"])
("quqn" ["娶亲"])
("ququ" ["区区" "去去"])
("quqy" ["秋收起义"])
("qur'" "趣去阒觑")
("quru" ["屈辱"])
("qusi" ["去思"])
("qusj" ["驱散"])
("qusv" ["去岁"])
("qut'" ["戌" "潜水艇" "屈氏体"])
("quti" ["躯体"])
("quu'" ["怯生生"])
("quue" ["取舍"])
("quuf" ["屈伸"])
("quug" ["取胜" "去声"])
("quui" ["趋势" "曲式" "驱使" "去世"])
("quuv" ["曲水" "渠水"])
("quvb" ["曲轴"])
("quve" ["曲折"])
("quvg" ["区政"])
("quvh" ["区长"])
("quvi" ["曲直" "去职"])
("quvu" ["驱逐"])
("quw'" "渠劬蕖蘧衢璩氍朐磲鸲癯蠼瞿")
("quwz" ["区委" "区位" "趣味"])
("quxc" ["取消" "取笑"])
("quxd" ["趋向" "去向"])
("quxi" ["屈膝"])
("quxm" ["曲线"])
("quxs" ["去雄"])
("quxw" ["取下"])
("quxx" ["气势汹汹"])
("quy'" ["潜水员"])
("quyb" ["区有"])
("quyh" ["曲阳" "取样"])
("quyi" ["曲艺"])
("quyq" ["全生育期"])
("quyr" ["屈原"])
("quyu" ["趋于" "区域"])
("quzi" ["曲子"])
("quzy" ["侵蚀作用"])
("qv'" ["其中"])
("qvbd" ["求之不得"])
("qvbj" ["取之不尽"])
("qvd'" ["铅中毒" "乔治敦"])
("qvg'" ["酋长国"])
("qvgd" ["群众观点"])
("qvhj" ["轻重缓急"])
("qvi'" ["起重船"])
("qvij" ["驱逐出境"])
("qvj'" ["起重机" "青贮窖" "驱逐舰"])
("qvls" ["敲诈勒索"])
("qvlx" ["群众路线"])
("qvs'" ["清真寺"])
("qvsl" ["青贮饲料"])
("qvwq" ["千真万确"])
("qvx'" ["群众性"])
("qvxm" ["旗帜鲜明"])
("qvxu" ["群治学社"])
("qvy'" ["求助于"])
("qvyd" ["群众运动"])
("qvzv" ["群众组织"])
("qw'" ["气温"])
("qwb'" ["勤务兵"])
("qwcv" ["去伪存真"])
("qwdh" ["恰当"])
("qwe'" "卡")
("qwhk" ["恰好"])
("qwpj" ["卡盘"])
("qwq'" "掐伽葜袷")
("qwqc" ["恰巧"])
("qwqw" ["恰恰"])
("qwr'" "恰洽髂")
("qwru" ["恰如"])
("qwtj" ["洽谈"])
("qwuh" ["洽商"])
("qwy'" ["勤务员"])
("qxbu" ["且不"])
("qxco" ["切磋"])
("qxd'" ["倾斜度" "清晰度"])
("qxdm" ["切点"])
("qxdr" ["切断"])
("qxe'" "且")
("qxge" ["切割"])
("qxgo" ["窃国"])
("qxgv" ["奇形怪状"])
("qxhe" ["切合"])
("qxhj" ["气象火箭"])
("qxhr" ["切换"])
("qxig" ["切成"])
("qxii" ["切齿"])
("qxiu" ["切除"])
("qxj'" ["切削角" "倾斜角"])
("qxje" ["穷凶极恶"])
("qxji" ["切记" "切忌"])
("qxju" ["谦虚谨慎" "窃据"])
("qxkb" ["切口"])
("qxkl" ["切开"])
("qxky" ["切块"])
("qxl'" ["切削力"])
("qxmj" ["且慢"])
("qxmm" ["切面"])
("qxno" ["怯懦"])
("qxp'" ["劝学篇"])
("qxpm" ["切片"])
("qxq'" "切")
("qxqu" ["窃取"])
("qxqx" ["切切"])
("qxqy" ["全心全意"])
("qxr'" "砌切怯窃郄惬慊妾挈锲箧趄")
("qxrk" ["求贤若渴"])
("qxsd" ["切削速度"])
("qxt'" ["气象台" "曲线图"])
("qxty" ["窃听"])
("qxuf" ["切身"])
("qxui" ["切实"])
("qxuo" ["且说"])
("qxw'" "茄伽")
("qxwk" ["千辛万苦"])
("qxwu" ["切勿"])
("qxwx" ["气象卫星"])
("qxx'" ["气象学" "倾向性"])
("qxxl" ["齐心协力"])
("qxxm" ["切线"])
("qxxn" ["切削性能"])
("qxxt" ["切削"])
("qxxx" ["切屑"])
("qxy'" ["七星岩"])
("qxyd" ["曲线运动"])
("qxyi" ["惬意"])
("qxyl" ["切削用量"])
("qxys" ["气象要素"])
("qxzi" ["茄子"])
("qy'" ["其余"])
("qyai" ["情爱"])
("qyan" ["请安"])
("qybk" ["情报"])
("qybl" ["清白"])
("qybm" ["轻便"])
("qybo" ["轻薄"])
("qyce" ["倾侧"])
("qyci" ["青瓷"])
("qyck" ["青草" "情操"])
("qycl" ["岂有此理" "青菜"])
("qycv" ["青翠" "清脆"])
("qycw" ["企业财务"])
("qydb" ["青豆"])
("qydc" ["情调"])
("qydj" ["氢弹" "清单" "清淡"])
("qydk" ["青岛" "倾倒" "清道"])
("qydl" ["清代"])
("qydm" ["清点" "庆典"])
("qyds" ["倾动"])
("qye'" "顷请苘謦")
("qyfg" ["轻风" "清风"])
("qyfh" ["轻放"])
("qyfu" ["轻浮" "倾覆" "倾复"])
("qyge" ["情歌"])
("qygj" ["情感"])
("qygk" ["清高"])
("qygl" ["企业管理"])
("qygr" ["清官"])
("qygs" ["青工" "庆功"])
("qyh'" ["企业化" "全运会"])
("qyhe" ["清和" "清河" "庆贺"])
("qyhg" ["氢氧化钙" "前因后果"])
("qyhj" ["氢氧化钾"])
("qyhl" ["青海" "氢氧化铝"])
("qyhn" ["氢氧化钠"])
("qyhv" ["青灰"])
("qyhw" ["青花" "氢化" "氢氧化物" "清华" "氰化"])
("qyhy" ["情怀"])
("qyia" ["清查"])
("qyie" ["清澈"])
("qyif" ["清晨"])
("qyih" ["清偿"])
("qyik" ["清朝"])
("qyip" ["青春"])
("qyiu" ["清除" "清楚"])
("qyj'" ["企业家" "汽油机"])
("qyjc" ["轻脚" "倾角" "请教"])
("qyjd" ["清江"])
("qyjj" ["企业基金"])
("qyjm" ["氢键"])
("qyjn" ["请进"])
("qyjw" ["请假"])
("qyjx" ["清洁" "情节"])
("qyjy" ["清静" "清净" "情景" "情境"])
("qykd" ["情况"])
("qyke" ["青稞" "顷刻" "请客"])
("qykj" ["请看"])
("qyks" ["晴空"])
("qyky" ["轻快" "情有可原"])
("qyl'" ["牵引力" "强有力"])
("qyld" ["清凉" "清亮"])
("qylh" ["晴朗"])
("qyli" ["清理" "情理"])
("qylk" ["请老"])
("qyll" ["请来"])
("qylq" ["清流"])
("qyls" ["青龙"])
("qylv" ["青绿" "清律"])
("qymc" ["青苗"])
("qymh" ["潜移默化"])
("qymm" ["情面"])
("qymx" ["轻蔑"])
("qymy" ["清明"])
("qymz" ["青梅"])
("qyni" ["请你"])
("qynm" ["青年"])
("qynn" ["请您"])
("qyq'" "青轻氢倾卿清圊蜻鲭")
("qyqc" ["轻巧"])
("qyqi" ["轻骑" "氢气"])
("qyqq" ["请求"])
("qyqr" ["清泉"])
("qyqu" ["情趣"])
("qyqy" ["轻轻"])
("qyr'" "亲庆磬罄箐綮")
("qyrb" ["轻柔"])
("qyrf" ["清人" "情人"])
("qys'" ["清一色"])
("qysk" ["清扫"])
("qysr" ["清算" "氰酸"])
("qyss" ["青松" "轻松"])
("qyth" ["清汤" "清塘"])
("qytj" ["清谈"])
("qytm" ["青天" "晴天"])
("qyts" ["青铜"])
("qytu" ["倾吐"])
("qyty" ["倾听" "请听"])
("qyu'" ["潜意识" "请愿书"])
("qyub" ["轻手" "清瘦"])
("qyud" ["清爽"])
("qyug" ["轻声"])
("qyuh" ["轻伤"])
("qyui" ["轻视" "清时" "情事" "情势" "请示"])
("qyuj" ["青山"])
("qyuu" ["情书"])
("qyuv" ["清水"])
("qyuy" ["轻率"])
("qyvb" ["青州"])
("qyvd" ["情状"])
("qyvf" ["清真"])
("qyvg" ["清蒸"])
("qyvs" ["轻重"])
("qyvu" ["青贮" "倾注" "庆祝"])
("qyw'" "擎晴氰情檠黥")
("qywa" ["青蛙"])
("qywf" ["晴雯" "请问"])
("qywu" ["请勿"])
("qywz" ["轻微"])
("qyx'" ["区域性"])
("qyxc" ["倾销"])
("qyxd" ["倾向" "清香"])
("qyxi" ["清晰" "清洗"])
("qyxn" ["轻信" "倾心" "清新" "清心"])
("qyxq" ["清秀"])
("qyxu" ["情绪"])
("qyxx" ["倾斜" "倾泻"])
("qyxy" ["轻型" "清醒" "情形" "庆幸"])
("qyyb" ["清油"])
("qyyi" ["轻易" "情意" "情谊"])
("qyyn" ["清音"])
("qyyr" ["情愿" "请愿" "庆元"])
("qyyu" ["青鱼" "情欲"])
("qyyy" ["轻盈"])
("qyzb" ["请走"])
("qyzi" ["青紫"])
("qyzk" ["清早"])
("qyzl" ["请在"])
("qyzo" ["请坐"])
("qyzv" ["轻罪" "区域自治"])
("qz'" ["签字"])
("qzql" ["去杂去劣"])
("qzth" ["起早贪黑"])
("r" "人")
("rb'" ["日报"])
("rbco" ["揉搓"])
("rbdk" ["柔道"])
("rbdy" ["肉丁"])
("rbh'" ["日本海"])
("rbhe" ["柔和"])
("rblz" ["肉类"])
("rbma" ["肉麻"])
("rbmo" ["肉末"])
("rbnf" ["柔嫩"])
("rbnm" ["揉捻"])
("rbpi" ["肉皮"])
("rbpm" ["肉片"])
("rbr'" ["肉" "日本人"])
("rbrf" ["柔韧"])
("rbrr" ["柔软"])
("rbs'" ["乳白色"])
("rbti" ["肉体"])
("rbui" ["肉食"])
("rbup" ["柔顺"])
("rbv'" ["忍不住"])
("rbvi" ["鞣质"])
("rbw'" "揉柔糅蹂鞣")
("rbxr" ["人剥削人"])
("rbxy" ["肉刑"])
("rbyj" ["肉眼"])
("rc'" ["人次"])
("rcdd" ["如此等等"])
("rcey" ["如此而已"])
("rcjj" ["人才济济"])
("rdh'" ["人代会"])
("rdi'" ["热电厂" "阮大铖"])
("rdl'" ["热导率"])
("rdo'" ["热电偶"])
("rdvw" ["热带植物"])
("rdvy" ["人道主义"])
("rdx'" ["热定型"])
("rdyl" ["热带雨林"])
("re'" ["然而"])
("reai" ["热爱"])
("reby" ["热病"])
("redl" ["热带"])
("redm" ["热电"])
("redu" ["热度"])
("ree'" "惹若喏")
("refg" ["热风"])
("rehe" ["热和"])
("reho" ["惹祸" "热火"])
("reif" ["热忱"])
("reig" ["热诚"])
("reik" ["热潮"])
("reji" ["热机"])
("rejm" ["热键"])
("reld" ["热量"])
("reli" ["热力"])
("relq" ["热流"])
("relx" ["热烈"])
("relz" ["热泪"])
("reng" ["热能"])
("renk" ["热闹"])
("reqi" ["热气"])
("reqx" ["热切"])
("reqy" ["热情"])
("rer'" "热")
("retm" ["热天"])
("reuv" ["热水"])
("reva" ["热轧"])
("revh" ["热障"])
("revi" ["热值"])
("revs" ["热中"])
("revv" ["日俄战争"])
("rewh" ["热望"])
("rexn" ["热心"])
("rext" ["热血"])
("reya" ["热压"])
("reyr" ["热源"])
("rfai" ["仁爱"])
("rfci" ["仁慈" "人次"])
("rfcl" ["人材" "人才"])
("rfco" ["认错"])
("rfcs" ["人丛"])
("rfda" ["人大"])
("rfde" ["认得"])
("rfdi" ["仁弟"])
("rfdk" ["人道"])
("rfdl" ["韧带"])
("rfdy" ["人定" "认定"])
("rfe'" "忍荏稔")
("rfer" ["人儿"])
("rffu" ["人父"])
("rfgb" ["认购"])
("rfge" ["人格"])
("rfgs" ["人工"])
("rfhe" ["人和" "任何"])
("rfig" ["人称"])
("rfiu" ["认出"])
("rfjc" ["任教"])
("rfji" ["人迹" "人极"])
("rfjm" ["人间"])
("rfjp" ["人均"])
("rfju" ["刃具"])
("rfjw" ["人家"])
("rfkb" ["人口"])
("rfke" ["认可"])
("rfl'" ["热风炉"])
("rfli" ["人力"])
("rflp" ["人伦"])
("rflq" ["人流"])
("rfly" ["认领"])
("rflz" ["人类"])
("rfma" ["人马"])
("rfmf" ["人们"])
("rfmm" ["任免"])
("rfmn" ["人民"])
("rfmu" ["人母"])
("rfmy" ["人命" "任命"])
("rfn'" ["人粪尿"])
("rfnl" ["忍耐"])
("rfpn" ["人品"])
("rfpy" ["任凭"])
("rfqi" ["人妻" "任期"])
("rfqp" ["人群"])
("rfqr" ["人权"])
("rfqy" ["人情" "认清"])
("rfr'" "韧任认刃妊纫仞葚饪轫衽")
("rfrf" ["人人" "任人"])
("rfrh" ["忍让"])
("rfri" ["人日"])
("rftb" ["人头"])
("rfti" ["人体"])
("rfts" ["忍痛" "认同"])
("rfu'" ["热辐射"])
("rfub" ["人手" "忍受"])
("rfuf" ["人参" "人身" "妊娠"])
("rfug" ["人声" "人生"])
("rfui" ["人时" "人士" "人世" "人事" "人氏" "认识"])
("rfuu" ["人数" "认输"])
("rfvf" ["认真"])
("rfvg" ["仁政" "人证" "认证"])
("rfvi" ["人质" "人治" "任职"])
("rfvs" ["人中" "人种"])
("rfvu" ["人主" "忍住"])
("rfw'" "壬仁人任")
("rfwf" ["人文"])
("rfwu" ["人物" "任务"])
("rfwz" ["人为" "认为"])
("rfxd" ["人像"])
("rfxn" ["人心" "忍心"])
("rfxr" ["人选" "任选"])
("rfxs" ["仁兄"])
("rfxw" ["任侠"])
("rfxy" ["人性" "韧性" "任性"])
("rfyi" ["仁义" "任意"])
("rfyj" ["人烟" "人言"])
("rfyr" ["人员"])
("rfys" ["任用"])
("rfyu" ["人浮于事" "人欲"])
("rfyy" ["人影"])
("rfzi" ["认字"])
("rfzk" ["人造"])
("rfzo" ["认作"])
("rfzv" ["认罪"])
("rg'" ["如果"])
("rgb'" ["软骨病"])
("rgbu" ["仍不"])
("rgd'" ["日光灯"])
("rgdc" ["扔掉"])
("rgdl" ["热功当量"])
("rgh'" ["人格化"])
("rghi" ["人工合成"])
("rgjq" ["仍旧"])
("rgke" ["仍可"])
("rgl'" ["人工林"])
("rgng" ["仍能"])
("rgq'" "扔")
("rgrj" ["仍然"])
("rgui" ["仍是"])
("rguj" ["人工授精"])
("rgw'" "仍")
("rgwz" ["仍未"])
("rgx'" ["热固性"])
("rgxu" ["仍须"])
("rgxw" ["扔下"])
("rgyb" ["仍由" "仍有"])
("rgyl" ["软骨鱼类"])
("rh'" ["然后"])
("rhbu" ["让步"])
("rhe'" "壤攘嚷禳")
("rhfy" ["热核反应"])
("rhgz" ["让给"])
("rhit" ["热火朝天"])
("rhj'" ["乳化剂"])
("rhkl" ["让开"])
("rhlu" ["让路"])
("rhq'" "嚷")
("rhr'" "让")
("rhrh" ["嚷嚷"])
("rhrt" ["如火如荼"])
("rhtu" ["壤土"])
("rhty" ["如虎添翼"])
("rhv'" ["润滑脂"])
("rhve" ["让着"])
("rhw'" "瓤禳穰")
("rhwz" ["让位"])
("rhy'" ["润滑油"])
("rhyu" ["让与"])
("ribc" ["日表"])
("ribf" ["日本"])
("ribk" ["日报"])
("ric'" ["热成层"])
("rid'" ["热传导"])
("rigd" ["日光"])
("rigs" ["日工"])
("rihb" ["日后"])
("rihw" ["日华"])
("riig" ["日程"])
("riih" ["日常"])
("riij" ["日产"])
("riiu" ["日出"])
("riji" ["日记"])
("rijm" ["日间" "日渐"])
("rijq" ["日久"])
("rikj" ["日刊"])
("ril'" ["热处理" "日产量"])
("rili" ["日历" "日立"])
("rill" ["日来"])
("rilo" ["日落"])
("rinj" ["日南"])
("rinz" ["日内"])
("riqi" ["日期"])
("riqm" ["日前"])
("riqu" ["日趋"])
("rir'" "日")
("ritb" ["日头"])
("ritj" ["日坛"])
("riui" ["日食" "日蚀"])
("rivk" ["日照"])
("rivs" ["日中"])
("riwf" ["日文"])
("rixn" ["日新"])
("rixw" ["日下"])
("riye" ["日夜"])
("riyi" ["日益"])
("riyr" ["日元"])
("riys" ["日用"])
("riyt" ["日月"])
("riyu" ["日语"])
("rizi" ["日子"])
("rjb'" ["软件包"])
("rjby" ["染病"])
("rjdm" ["燃点"])
("rje'" "冉染苒")
("rjer" ["然而"])
("rjg'" ["热加工"])
("rjgh" ["染缸"])
("rjh'" ["热交换"])
("rjhb" ["然后"])
("rjlc" ["燃料" "染料"])
("rjqc" ["人尽其才"])
("rjqi" ["燃起"])
("rjse" ["染色"])
("rjsk" ["如饥似渴"])
("rjsx" ["锐角三角形"])
("rjti" ["日久天长"])
("rjuk" ["燃烧"])
("rjvg" ["染整"])
("rjw'" "然燃蚺髯")
("rjze" ["然则"])
("rk'" ["人口"])
("rkdk" ["绕道"])
("rkds" ["扰动"])
("rke'" "扰绕娆")
("rkgo" ["绕过"])
("rkgu" ["人口过剩"])
("rkkl" ["绕开"])
("rkl'" ["人口论"])
("rklr" ["扰乱"])
("rkmy" ["饶命"])
("rkpy" ["饶平"])
("rkr'" "绕")
("rkuu" ["饶恕"])
("rkvb" ["饶州"])
("rkw'" "饶荛娆桡")
("rkxy" ["绕行"])
("rkzj" ["人口增加"])
("rkzu" ["绕组"])
("rl'" ["热烈"])
("rlgi" ["热力过程"])
("rlgy" ["燃料工业"])
("rli'" ["人力车"])
("rll'" ["热辣辣"])
("rlp'" ["容量瓶"])
("rlry" ["任劳任怨"])
("rlwu" ["儒林外史"])
("rlx'" ["热力学"])
("rlxh" ["热力循环"])
("rly'" ["燃料油"])
("rlyk" ["热泪盈眶"])
("rm'" ["人民"])
("rmb'" ["人民报" "人民币"])
("rmd'" ["人民党"])
("rmdh" ["人民代表大会"])
("rmdt" ["人民大会堂"])
("rmdz" ["热敏电阻"])
("rmft" ["人民法庭"])
("rmfx" ["如梦方醒"])
("rmfy" ["人民法院"])
("rmgu" ["人民公社"])
("rmiu" ["人民出版社"])
("rmjd" ["人民军队"])
("rmji" ["人民警察"])
("rmrb" ["人民日报"])
("rms'" ["软木塞"])
("rmtt" ["人民团体"])
("rmvf" ["人民政府"])
("rmvj" ["燃眉之急"])
("rmvv" ["人民战争"])
("rmvx" ["人民阵线"])
("rmwv" ["人民武装"])
("rmx'" ["人民性"])
("rmyv" ["人民意志"])
("rnw'" ["日内瓦"])
("rnwy" ["日内瓦协议"])
("rny'" ["热那亚"])
("rodm" ["弱点" "弱电"])
("rofu" ["若夫"])
("rofz" ["若非"])
("rogj" ["若干"])
("rogo" ["弱国"])
("rohe" ["若何"])
("rois" ["若虫"])
("rojm" ["弱碱"])
("ror'" "若弱偌箬")
("rosr" ["弱酸"])
("roui" ["若是"])
("rove" ["弱者"])
("rowu" ["若无"])
("rowz" ["若为"])
("roxc" ["弱小"])
("rpb'" ["韧皮部"])
("rph'" ["热平衡"])
("rphw" ["润滑"])
("rpih" ["润肠"])
("rpnm" ["闰年"])
("rpr'" "闰润")
("rpri" ["闰日"])
("rpse" ["润色"])
("rpui" ["润湿"])
("rpv'" ["热膨胀"])
("rpyt" ["闰月"])
("rq'" ["日期"])
("rqli" ["燃气轮机车"])
("rqlj" ["燃气轮机"])
("rqtt" ["热气腾腾"])
("rqu'" ["日全食"])
("rqw'" ["人情味"])
("rr'" ["仍然"])
("rre'" "软阮朊")
("rree" ["软腭"])
("rrgk" ["软膏"])
("rrgr" ["软管"])
("rrgs" ["软功"])
("rrgu" ["软骨"])
("rrhw" ["软化"])
("rrjm" ["软件"])
("rrl'" ["热容量"])
("rrmu" ["软木"])
("rrpj" ["软盘"])
("rrro" ["软弱"])
("rruv" ["软水"])
("rrvu" ["仁人志士"])
("rrwx" ["任人为贤"])
("rrx'" ["软弱性"])
("rryy" ["日日夜夜" "软硬"])
("rsbu" ["绒布"])
("rsco" ["容错"])
("rsdm" ["熔点"])
("rsds" ["溶洞"])
("rse'" "冗")
("rshe" ["融合" "溶合"])
("rshj" ["熔焊"])
("rsho" ["荣获"])
("rshv" ["融汇"])
("rshw" ["融化" "熔化" "溶化"])
("rsii" ["熔池"])
("rsjc" ["溶胶"])
("rsji" ["熔剂" "溶剂" "容积"])
("rsjx" ["融解" "熔解" "溶解"])
("rskh" ["容抗"])
("rsld" ["染色牢度" "容量"])
("rslm" ["熔炼"])
("rslu" ["荣禄" "熔炉"])
("rsma" ["戎马"])
("rsmk" ["茸毛" "容貌" "绒毛"])
("rsna" ["容纳"])
("rsqi" ["容器"])
("rsqw" ["融洽"])
("rsrf" ["容忍"])
("rsrs" ["熔融" "蝾蝾"])
("rst'" ["染色体"])
("rsu'" ["燃素说"])
("rsuu" ["蓉树"])
("rsv'" ["染色质"])
("rsvi" ["溶质"])
("rsvs" ["容重"])
("rsw'" "戎茸蓉荣融熔溶容绒嵘狨榕肜蝾")
("rswz" ["容为"])
("rsx'" ["热塑性"])
("rsxm" ["荣县" "绒线"])
("rsxu" ["容许"])
("rsxx" ["溶血"])
("rsxy" ["荣幸" "容幸"])
("rsye" ["溶液"])
("rsyi" ["容易" "绒衣"])
("rsyj" ["熔岩"])
("rsyk" ["荣耀"])
("rsyu" ["荣誉" "溶于" "冗余"])
("rtdw" ["软体动物"])
("ru'" ["认识"])
("rubl" ["乳白"])
("rubx" ["人寿保险"])
("ruch" ["入仓"])
("ruci" ["如此" "如次"])
("rudh" ["入党"])
("ruds" ["蠕动" "如东" "入冬"])
("rue'" "辱乳汝")
("ruer" ["乳儿" "入耳"])
("ruff" ["乳粉"])
("rufh" ["乳房"])
("rug'" ["人生观"])
("rugj" ["如干"])
("rugk" ["如皋"])
("rugo" ["如果"])
("rugu" ["如故" "入骨"])
("ruhe" ["如何"])
("ruho" ["入伙"])
("ruhv" ["入会"])
("ruhw" ["乳化" "入画"])
("ruih" ["如常" "入场"])
("ruik" ["入超"])
("ruj'" ["入射角"])
("rujc" ["乳胶"])
("ruji" ["乳剂"])
("rujn" ["如今"])
("rujw" ["儒家"])
("rujy" ["入境"])
("rukb" ["入口"])
("ruku" ["入库"])
("rul'" ["认识论"])
("ruld" ["日晒牢度"])
("rulk" ["乳酪"])
("rull" ["如来"])
("ruln" ["儒林"])
("ruma" ["辱骂"])
("rumf" ["入门"])
("rumg" ["入梦"])
("rumi" ["入迷"])
("rumo" ["儒墨"])
("rumu" ["乳母"])
("runj" ["汝南"])
("runq" ["乳牛"])
("rup'" ["热水瓶"])
("ruqi" ["如期" "如其"])
("ruqn" ["入侵"])
("rur'" "入褥蓐洳溽缛")
("ruro" ["如若"])
("rusr" ["乳酸"])
("rusu" ["如上所述"])
("rutb" ["乳头"])
("ruth" ["乳糖"])
("rutk" ["褥套"])
("ruto" ["入托"])
("rutr" ["入团"])
("ruts" ["如同"])
("rutu" ["如图" "入土"])
("ruu'" ["燃烧室"])
("ruub" ["入手"])
("ruue" ["入射" "入社"])
("ruuf" ["惹事生非"])
("ruug" ["儒生"])
("ruuh" ["如上"])
("ruui" ["如实" "如是" "入时" "入室"])
("ruuj" ["如山"])
("ruuu" ["儒术" "如数"])
("ruuv" ["入睡"])
("ruve" ["儒者"])
("ruvi" ["乳汁" "入直"])
("ruvx" ["人生哲学"])
("ruw'" "茹蠕儒孺如薷嚅濡铷襦颥")
("ruwu" ["入五" "入伍"])
("ruwz" ["入微" "入味"])
("rux'" ["肉食性"])
("ruxm" ["乳腺"])
("ruxs" ["如兄"])
("ruxt" ["儒学" "入学"])
("ruxw" ["如下"])
("ruyb" ["如有"])
("ruye" ["入夜"])
("ruyf" ["人身依附"])
("ruyi" ["如意"])
("ruyp" ["如云"])
("ruyr" ["如愿" "入院"])
("ruyt" ["如月"])
("ruyu" ["如雨" "如与" "入狱"])
("ruzi" ["孺子" "褥子"])
("ruzo" ["入座"])
("ruzy" ["人身自由"])
("rv'" ["认真"])
("rvdm" ["瑞典"])
("rve'" "蕊")
("rvh'" ["日知会"])
("rvig" ["瑞澄"])
("rviq" ["人之长情"])
("rvjc" ["锐角"])
("rvjn" ["瑞金"])
("rvli" ["瑞利" "锐利"])
("rvp'" ["乳制品"])
("rvqi" ["锐气"])
("rvr'" "瑞锐芮枘睿蚋")
("rvs'" ["软脂酸"])
("rvui" ["瑞士"])
("rvw'" "蕤")
("rvy'" ["乳浊液"])
("rw'" ["认为"])
("rwd'" ["人为地"])
("rwkr" ["忍无可忍"])
("rwqu" ["若无其事"])
("rwxg" ["人物性格"])
("rwy'" ["让位于"])
("rx'" ["如下"])
("rxd'" ["人行道"])
("rxl'" ["热效率" "人性论"])
("rxsx" ["人心所向"])
("rxy'" ["热效应"])
("rxyy" ["日新月异"])
("ry'" ["人员"])
("ryd'" ["热运动"])
("rydd" ["仁义道德"])
("ryjh" ["溶液聚合" "乳液聚合"])
("ryjj" ["日益加剧"])
("ryju" ["软硬兼施"])
("rykw" ["人言可畏"])
("ryp'" ["日用品"])
("ryss" ["若有所思"])
("ryzv" ["日益增长"])
("rzb'" ["人造板"])
("rzdx" ["人造地球卫星"])
("rzj'" ["人字架"])
("rzm'" ["人造棉"])
("rzs'" ["人造丝"])
("rzt'" ["热载体"])
("rzwx" ["人造卫星"])
("rzxj" ["人造橡胶"])
("rzxw" ["人造纤维"])
("s" "三")
("sabo" ["撒播"])
("sae'" "撒洒")
("saer" ["萨尔"])
("sahd" ["撒谎"])
("sajc" ["撒娇"])
("sakl" ["撒开"])
("sala" ["萨拉"])
("sali" ["萨利"])
("samu" ["萨姆"])
("sana" ["萨那"])
("saq'" "撒仨挲")
("sar'" "萨卅脎飒")
("satv" ["撒腿"])
("saub" ["撒手"])
("saui" ["撒施"])
("sauv" ["洒水"])
("sbbu" ["搜捕"])
("sbe'" "擞叟薮嗾瞍")
("sbgw" ["搜刮"])
("sbia" ["搜查"])
("sbji" ["搜集"])
("sbko" ["搜括"])
("sblm" ["算不了什么"])
("sblo" ["搜罗"])
("sbnu" ["斯宾诺莎"])
("sbp'" ["三百篇"])
("sbq'" ["搜" "艘" "嗖" "馊" "溲" "飕" "锼" "螋" "三部曲"])
("sbqq" ["搜求"])
("sbr'" "擞嗽")
("sbs'" ["斯宾塞"])
("sbso" ["搜索"])
("sbt'" ["四倍体"])
("sbx'" ["四边形"])
("sbxp" ["搜寻"])
("sbxu" ["素不相识"])
("scs'" ["桑蚕丝"])
("scsd" ["三从四德"])
("sd'" ["速度"])
("sdgm" ["斯德哥尔摩"])
("sdjz" ["四大家族"])
("sdl'" ["斯大林"])
("sdp'" ["苏东坡"])
("sdu'" ["三段式" "所得税"])
("sdum" ["算得什么"])
("secl" ["色彩"])
("sedc" ["色调"])
("sedh" ["色当"])
("sedu" ["色度"])
("segd" ["色光"])
("seia" ["色差"])
("selc" ["色料"])
("semh" ["色盲"])
("sepu" ["色普"])
("seqy" ["色情"])
("ser'" "塞瑟色涩啬铯穑")
("sesj" ["色散"])
("seso" ["瑟缩"])
("sesu" ["色素"])
("sewd" ["萨尔瓦多"])
("sewy" ["塞尔维亚"])
("sexd" ["色相"])
("seze" ["色泽"])
("sezl" ["索尔兹伯里"])
("sfb'" ["司法部"])
("sfdl" ["司法独立"])
("sfln" ["森林"])
("sfq'" ["森" "司法权"])
("sfvd" ["司法制度"])
("sfwc" ["三番五次"])
("sfwl" ["四分五裂"])
("sfy'" ["索非亚"])
("sfyf" ["四分音符"])
("sfyj" ["森严"])
("sfyy" ["算法语言"])
("sgl'" ["苏格兰"])
("sglq" ["僧格林沁"])
("sglv" ["僧侣"])
("sgni" ["僧尼"])
("sgq'" "僧")
("sgrf" ["僧人"])
("sgv'" ["三国志"])
("sgwi" ["三纲五常"])
("sgxh" ["四个现代化"])
("sgyy" ["三国演义"])
("shcj" ["桑蚕"])
("shdj" ["丧胆"])
("she'" "嗓搡磉颡")
("shfu" ["丧服"])
("shj'" ["松花江"])
("shmf" ["嗓门"])
("shmy" ["丧命"])
("shpi" ["损害赔偿"])
("shq'" "桑丧")
("shqi" ["丧气"])
("shr'" "丧")
("sht'" ["死胡同"])
("shtm" ["桑田"])
("shui" ["丧失" "丧事"])
("shuu" ["桑树"])
("shvs" ["丧钟"])
("shx'" ["三和弦"])
("shye" ["桑叶"])
("shyn" ["嗓音"])
("shyr" ["桑园"])
("shz'" ["宋徽宗"])
("shzi" ["嗓子"])
("sibj" ["死板"])
("sibm" ["四边"])
("sibu" ["死不" "四部"])
("sic'" ["四川菜"])
("sich" ["私藏"])
("sici" ["四次"])
("sicp" ["思忖"])
("sida" ["四大"])
("side" ["死得"])
("sidh" ["死党"])
("sidi" ["死敌" "死地"])
("sidm" ["死点"])
("sidr" ["四端"])
("sie'" "死")
("sien" ["思恩"])
("sif'" ["孙传芳"])
("sifa" ["私法" "司法"])
("sifh" ["私房" "四方"])
("sifu" ["伺服"])
("sigd" ["丝光"])
("sige" ["四个"])
("sigl" ["思盖"])
("sigo" ["四国"])
("sigs" ["思弓"])
("sigu" ["四顾"])
("sigw" ["丝瓜"])
("sihb" ["死后" "嗣后"])
("sihh" ["四行"])
("sihk" ["丝毫"])
("sihl" ["四海"])
("siho" ["私货" "死活"])
("sihu" ["似乎"])
("sihv" ["撕毁"])
("sihw" ["四化"])
("siib" ["丝绸"])
("siie" ["撕扯"])
("siij" ["私产"])
("siik" ["思潮"])
("siir" ["四川"])
("siiu" ["四处"])
("sij'" ["三叉戟"])
("sijc" ["丝胶" "死角" "四角"])
("siji" ["司机" "四季" "伺机"])
("siju" ["司局"])
("sijw" ["私家"])
("sikb" ["司寇"])
("sikk" ["思考"])
("sil'" ["三春柳" "伞齿轮" "酸处理"])
("silc" ["饲料"])
("sild" ["思量"])
("sili" ["私立" "死力"])
("silm" ["思恋"])
("siln" ["四邻"])
("sils" ["斯隆"])
("silu" ["思路" "死路"])
("silv" ["思虑"])
("silx" ["撕裂"])
("sily" ["司令"])
("silz" ["四类"])
("sima" ["司马"])
("simc" ["寺庙"])
("simi" ["丝米"])
("simm" ["丝棉" "四面"])
("simy" ["死命"])
("simz" ["四美"])
("sinj" ["死难"])
("sinm" ["思念"])
("sipd" ["四川盆地"])
("siph" ["四旁"])
("sipo" ["撕破"])
("sipy" ["四平"])
("siq'" "斯撕嘶思私司丝厮厶咝澌缌锶鸶蛳")
("siqi" ["四起"])
("siqq" ["死囚"])
("siqu" ["死去"])
("sir'" ["食" "肆" "寺" "嗣" "四" "伺" "似" "饲" "巳" "俟" "兕" "汜" "泗" "姒" "驷" "祀" "耜" "笥" "四川人"])
("sirf" ["私人"])
("sirs" ["丝绒"])
("sisi" ["死死"])
("sisj" ["四散"])
("siso" ["思索"])
("sisu" ["丝素"])
("sit'" ["厕" "孙传庭"])
("sitj" ["斯坦"])
("sito" ["斯托"])
("sits" ["斯通" "私通" "四通"])
("situ" ["司徒"])
("siu'" ["四川省"])
("siub" ["死守"])
("siug" ["私生" "四声"])
("siuh" ["私商" "死伤"])
("siui" ["私事" "死尸" "四十" "四时"])
("siuu" ["私塾" "丝束" "四书"])
("siv'" ["三长制"])
("sivb" ["四周"])
("sivd" ["丝状"])
("sivf" ["四镇"])
("sivh" ["司长"])
("sivi" ["丝织" "四肢" "四至"])
("sivj" ["死战"])
("sivl" ["丝绸之路"])
("sivs" ["四种"])
("siwf" ["斯文"])
("siwh" ["丝网" "死亡"])
("siwl" ["四外"])
("siwu" ["司务"])
("siwz" ["思维" "四围"])
("sixd" ["思想" "四乡" "四象"])
("sixm" ["丝弦" "丝线"])
("sixn" ["私心" "私信" "死心"])
("sixt" ["私学"])
("sixu" ["思绪"])
("sixw" ["私下"])
("sixy" ["死刑"])
("siya" ["嘶哑"])
("siyb" ["私有"])
("siyh" ["饲养"])
("siyi" ["肆意"])
("siyr" ["寺院"])
("siyt" ["四月"])
("siyy" ["私营"])
("size" ["四则"])
("sizi" ["私自"])
("sizv" ["死罪"])
("sjb'" ["三角板"])
("sjbe" ["桑给巴尔"])
("sjbk" ["三宝"])
("sjbo" ["散播"])
("sjbu" ["散布" "散步"])
("sjby" ["伞兵"])
("sjci" ["三次"])
("sjcj" ["三餐"])
("sjcl" ["三才"])
("sjda" ["三大"])
("sjdl" ["三代"])
("sjdy" ["三定"])
("sje'" "伞散馓糁霰")
("sjfa" ["三法" "散发"])
("sjfh" ["三方"])
("sjfi" ["三角方程"])
("sjfu" ["三复"])
("sjfy" ["缩聚反应"])
("sjfz" ["三废"])
("sjg'" ["三极管" "四极管"])
("sjgd" ["散光"])
("sjge" ["三个"])
("sjgg" ["三更"])
("sjgo" ["三国"])
("sjgr" ["三关"])
("sjgs" ["三公"])
("sjh'" ["三结合"])
("sjhe" ["三合"])
("sjhh" ["三行"])
("sjhk" ["三好"])
("sjhl" ["三害"])
("sjhr" ["三环"])
("sjhu" ["三户" "三角函数"])
("sjhv" ["散会"])
("sjih" ["散场"])
("sjii" ["三尺"])
("sjj'" ["三脚架"])
("sjjc" ["三角"])
("sjji" ["三季"])
("sjjp" ["三军"])
("sjjq" ["三九"])
("sjju" ["散居"])
("sjjx" ["三节"])
("sjkl" ["散开"])
("sjld" ["三两"])
("sjlg" ["三棱"])
("sjli" ["三礼"])
("sjlk" ["三老"])
("sjlo" ["散落"])
("sjlr" ["散乱"])
("sjmf" ["三门"])
("sjmj" ["散漫"])
("sjml" ["三麦"])
("sjnm" ["三年"])
("sjpd" ["三角皮带"])
("sjpn" ["三品"])
("sjq'" ["三" "叁" "毵" "塞进去"])
("sjqi" ["三七"])
("sjqq" ["三秋"])
("sjr'" ["散" "宋教仁"])
("sjri" ["三日"])
("sjth" ["三堂"])
("sjtl" ["三台"])
("sjts" ["三通" "三同" "三统"])
("sjue" ["散射"])
("sjug" ["三生"])
("sjui" ["三师" "三十" "三时" "三世" "散失"])
("sjuv" ["三水"])
("sjv'" ["三角洲"])
("sjvd" ["散装"])
("sjvg" ["三正"])
("sjvh" ["三张"])
("sjwf" ["散文"])
("sjwu" ["三吴"])
("sjx'" ["三角形" "三角学"])
("sjxd" ["三相"])
("sjxm" ["三弦"])
("sjxn" ["散心"])
("sjxw" ["三峡"])
("sjxy" ["三星"])
("sjy'" ["松节油"])
("sjyb" ["随机应变"])
("sjyh" ["三洋"])
("sjyr" ["三元" "三原"])
("sjyt" ["三月"])
("sjzl" ["三载"])
("skdh" ["扫荡"])
("skdi" ["扫地"])
("skds" ["骚动"])
("ske'" "扫嫂")
("skgo" ["扫过"])
("skiu" ["扫除"])
("sklr" ["骚乱"])
("sklz" ["扫雷"])
("skmc" ["扫描"])
("skmh" ["扫盲"])
("skpy" ["扫平"])
("skq'" "搔骚缫缲臊鳋")
("skr'" "扫梢埽臊瘙")
("skrk" ["骚扰"])
("sksi" ["缫丝"])
("sksk" ["嫂嫂"])
("skue" ["扫射"])
("skui" ["扫视"])
("skvb" ["扫帚"])
("skwz" ["扫尾"])
("skxr" ["扫选"])
("skxy" ["扫兴"])
("skyh" ["搔痒"])
("skzi" ["嫂子"])
("sl'" ["苏联"])
("slfk" ["斯洛伐克"])
("slgo" ["赛过"])
("slgx" ["森林更新"])
("slgy" ["森林工业"])
("slht" ["四氯化碳"])
("sli'" ["三轮车"])
("slie" ["赛车"])
("slig" ["赛程"])
("slj'" ["三棱镜"])
("slji" ["赛季"])
("sljl" ["森林经理"])
("sljn" ["塞进"])
("slla" ["塞拉利昂"])
("sllk" ["斯里兰卡"])
("slm'" ["所罗门"])
("slma" ["赛马"])
("slmj" ["塞满"])
("slpk" ["赛跑"])
("slq'" "腮鳃塞思噻")
("slr'" "塞赛")
("sls'" ["赛力散"])
("slsy" ["三老四严"])
("slt'" ["酸辣汤"])
("sltr" ["森林土壤"])
("slu'" ["苏黎世"])
("sluh" ["塞上"])
("slwl" ["塞外"])
("slwu" ["三令五申"])
("slxm" ["腮腺"])
("sly'" ["司令员"])
("slz'" ["撒拉族"])
("slzi" ["塞子"])
("slzw" ["饲料作物"])
("slzy" ["森林资源"])
("smbf" ["四面八方"])
("smhq" ["三面红旗"])
("smi'" ["松毛虫"])
("smig" ["四面楚歌"])
("sml'" ["宿命论" "索马里"])
("smt'" ["四面体"])
("smvy" ["三民主义"])
("smx'" ["三门峡"])
("snje" ["塞内加尔"])
("sobu" ["所部"])
("sode" ["所得"])
("sodk" ["索道"])
("sodr" ["缩短"])
("soe'" "琐索锁所唢")
("sogu" ["锁骨"])
("sohe" ["缩合"])
("soii" ["缩尺"])
("soji" ["羧基"])
("sojm" ["缩减" "所见"])
("soju" ["缩聚"])
("soks" ["缩孔"])
("solm" ["锁链"])
("sona" ["唢呐"])
("sopz" ["索赔"])
("soq'" "莎蓑梭唆缩嗦嗍娑桫挲睃羧")
("soqu" ["索取"])
("sosr" ["羧酸"])
("sosv" ["琐碎"])
("soug" ["所生"])
("soui" ["唆使" "琐事" "所示"])
("souo" ["所说"])
("souu" ["所属"])
("souv" ["缩水"])
("sovh" ["所长"])
("sovi" ["所至"])
("sovj" ["所占"])
("sowf" ["所闻"])
("sowz" ["所谓"])
("soxc" ["缩小"])
("soxu" ["所需"])
("soxx" ["缩写"])
("soxy" ["索性"])
("soyb" ["所由" "所有"])
("soyi" ["所以"])
("soyn" ["缩印" "索引"])
("soyu" ["梭鱼"])
("soyy" ["缩影"])
("sozi" ["梭子"])
("sozl" ["所在"])
("sozo" ["所作"])
("spbn" ["孙膑"])
("spe'" "损笋榫隼")
("sphk" ["损耗"])
("sphl" ["损害"])
("sphy" ["损坏"])
("spls" ["塞浦路斯"])
("spnv" ["孙女"])
("spq'" "孙荪狲飧")
("spqr" ["孙权"])
("spuh" ["损伤"])
("spui" ["损失"])
("spvu" ["孙竹"])
("spwf" ["孙文"])
("spwu" ["孙吴" "孙武"])
("spyi" ["损益"])
("spzi" ["孙子"])
("sqfl" ["三权分立"])
("sqt'" ["三青团"])
("sr'" ["虽然"])
("srb'" ["四人帮"])
("srbl" ["酸败"])
("srde" ["算得"])
("srdu" ["酸度"])
("srfa" ["算法"])
("srgf" ["酸根"])
("srgj" ["酸酐"])
("srhw" ["酸化"])
("sri'" ["速溶茶"])
("sriu" ["算出"])
("srji" ["算机" "算计"])
("srla" ["酸辣"])
("srlc" ["算了"])
("srlj" ["损人利己"])
("srmc" ["蒜苗"])
("srmy" ["算命"])
("srni" ["蒜泥"])
("srpj" ["算盘"])
("srq'" ["酸" "狻" "散热器"])
("srr'" "蒜算")
("srts" ["酸痛"])
("srui" ["算式" "算是"])
("sruu" ["算术" "算数"])
("srvh" ["算帐"])
("srxi" ["酸洗"])
("srxt" ["算学"])
("srxy" ["酸性"])
("ssbb" ["随随便便"])
("ssbl" ["松柏"])
("ssbx" ["送别"])
("ssdl" ["宋代"])
("ssds" ["松动"])
("ssdu" ["诵读"])
("sse'" "耸怂悚竦")
("ssf'" ["诉讼法"])
("ssfa" ["讼法"])
("ssfg" ["送风"])
("ssge" ["颂歌"])
("ssgz" ["送给"])
("ssho" ["送货"])
("sshr" ["送还"])
("ssii" ["松弛"])
("ssik" ["宋朝"])
("ssiu" ["送出"])
("ssjc" ["送交"])
("ssjd" ["松江"])
("ssjn" ["松紧" "松劲"])
("ssjy" ["送经"])
("sske" ["松科" "送客"])
("sskl" ["松开"])
("ssky" ["松快"])
("ssli" ["耸立" "送礼"])
("ssll" ["三三两两" "送来"])
("ssln" ["松林"])
("ssmu" ["松木"])
("ssq'" "松凇菘崧嵩忪淞")
("ssqy" ["宋庆"])
("ssr'" "颂送宋讼诵")
("ssrr" ["松软"])
("ssru" ["送入" "宋儒"])
("sssi" ["送死"])
("sssj" ["松散"])
("ssti" ["宋体"])
("sstk" ["松涛"])
("sstu" ["松土"])
("ssub" ["松手"])
("ssui" ["宋史"])
("ssuj" ["松山"])
("ssuu" ["松鼠" "松树" "宋书"])
("ssxd" ["松香"])
("ssxm" ["嵩县"])
("ssxn" ["送信"])
("ssxt" ["宋学"])
("ssxw" ["松下"])
("ssxx" ["松懈"])
("ssxy" ["送行"])
("ssyh" ["颂扬"])
("ssys" ["怂恿"])
("sszh" ["送葬"])
("stbd" ["四通八达"])
("ste'" ["斯特恩"])
("stf'" ["三通阀" "斯坦福"])
("stgs" ["四通公司"])
("stjt" ["四通集团"])
("stl'" ["斯特朗"])
("stz'" ["宋太祖"])
("su'" ["所示"])
("subi" ["速比"])
("sucl" ["素材" "素菜"])
("sucv" ["酥脆"])
("suda" ["苏打"])
("sudj" ["苏丹"])
("sudu" ["速度"])
("sue'" ["塞舌尔"])
("suee" ["苏俄"])
("suef" ["似是而非"])
("sufh" ["苏方" "随声附和"])
("sufj" ["肃反"])
("suhw" ["俗话"])
("suig" ["速成"])
("sujc" ["塑胶"])
("suji" ["速记"])
("sujp" ["苏军" "苏峻"])
("sujy" ["肃静"])
("suku" ["诉苦"])
("sulc" ["塑料"])
("sull" ["素来"])
("sulm" ["苏联"])
("sulv" ["速率"])
("sumc" ["素描"])
("sumi" ["粟米"])
("sumu" ["苏木" "肃穆"])
("sumy" ["俗名"])
("sunh" ["嗉囊"])
("suq'" "苏酥稣")
("suqu" ["苏区"])
("suqy" ["肃清"])
("sur'" "素速粟僳塑溯宿诉肃缩夙谡蔌嗉愫涑簌觫")
("surj" ["肃然"])
("susd" ["随时随地"])
("suss" ["诉讼"])
("sut'" ["索氏体"])
("suth" ["酥糖"])
("sutk" ["俗套"])
("sutx" ["苏铁"])
("suue" ["宿舍"])
("suuo" ["诉说"])
("suuu" ["素数"])
("suvb" ["苏州"])
("suvd" ["诉状"])
("suvi" ["素质"])
("suvu" ["宿主"])
("suw'" "俗")
("suwr" ["四舍五入"])
("suwz" ["宿卫"])
("suxc" ["速效"])
("suxd" ["塑像" "塑象"])
("suxx" ["速写"])
("suxy" ["苏醒" "塑性"])
("suy'" ["酸式盐"])
("suyb" ["酥油"])
("suyh" ["素养"])
("suyr" ["宿愿"])
("suyu" ["俗语"])
("suyy" ["宿营"])
("suzk" ["塑造"])
("suzu" ["僳族"])
("sv'" ["随着"])
("svb'" ["萨镇冰"])
("svbi" ["随笔"])
("svbm" ["随便"])
("svcs" ["随从"])
("svdi" ["随地"])
("svdk" ["隧道"])
("sve'" "髓")
("svfg" ["随风"])
("svfz" ["穗肥"])
("svhb" ["随后"])
("svi'" ["丝织厂"])
("svik" ["隋朝"])
("sviu" ["随处" "岁出"])
("svji" ["随机" "随即"])
("svkb" ["随口"])
("svky" ["碎块"])
("svlc" ["碎了"])
("svlx" ["碎裂"])
("svp'" ["丝织品"])
("svpm" ["碎片"])
("svq'" "尿虽荽濉眭睢")
("svr'" "碎岁穗遂隧祟谇邃燧")
("svrj" ["虽然"])
("svru" ["岁入"])
("svth" ["隋唐"])
("svts" ["随同"])
("svu'" ["孙中山"])
("svub" ["随手"])
("svuf" ["随身"])
("svui" ["随时" "碎石" "燧石"])
("svuo" ["虽说"])
("svuu" ["隋书" "岁数"])
("svv'" ["三长制" "四洲志"])
("svve" ["随着"])
("svvi" ["随之"])
("svw'" "隋随绥遂")
("svxy" ["随行"])
("svyb" ["虽有"])
("svyi" ["随意"])
("svyr" ["随员" "绥远"])
("svyt" ["岁月"])
("svze" ["虽则"])
("svzi" ["穗子"])
("sw'" ["所谓"])
("swa'" ["苏维埃"])
("swd'" ["宋文帝"])
("swjd" ["肆无忌惮"])
("swk'" ["孙悟空"])
("swl'" ["死亡率"])
("swyd" ["四五运动"])
("sx'" ["思想"])
("sxbx" ["塑性变形"])
("sxcl" ["塑性材料"])
("sxff" ["思想方法"])
("sxfx" ["似信非信"])
("sxgq" ["思想感情"])
("sxj'" ["思想家"])
("sxnr" ["思想内容"])
("sxpm" ["所向披靡"])
("sxsy" ["随心所欲"])
("sxtx" ["思想体系"])
("sxu'" ["三项式" "思想上"])
("sxvb" ["思想准备"])
("sxvx" ["思想战线"])
("sxwd" ["所向无敌"])
("sxwy" ["三侠五义"])
("sxx'" ["思想性" "速效性"])
("sy'" ["所以"])
("syb'" ["四月八"])
("sybv" ["饲养标准"])
("syd'" ["隋炀帝"])
("syl'" ["三元里"])
("syly" ["三言两语"])
("syq'" ["三叶期" "所有权"])
("syr'" ["所以然"])
("syu'" ["苏伊士"])
("syuh" ["苏伊士运河"])
("syv'" ["私有制" "所有制"])
("szdu" ["三座大山"])
("szgb" ["松赞干布"])
("szsw" ["所作所为"])
("szys" ["四则运算"])
("t" "他")
("tabj" ["踏板"])
("tabu" ["踏步"])
("tabz" ["他被" "它被" "她被"])
("tade" ["他的" "它的" "她的"])
("tady" ["塔顶"])
("tae'" "塔獭鳎")
("tafh" ["塌方"])
("tago" ["他国"])
("tajm" ["塔尖"])
("takj" ["踏勘"])
("talw" ["他俩" "她俩"])
("tam'" ["天安门"])
("tamf" ["他们" "它们" "她们"])
("tans" ["他侬"])
("taq'" "塌他它她踏溻遢铊趿")
("tar'" "挞蹋踏拓嗒闼漯榻沓")
("tarf" ["他人"])
("tari" ["他日"])
("taso" ["他所" "她所"])
("tata" ["踏踏"])
("taua" ["他杀"])
("taui" ["他是" "它是" "她是" "踏实"])
("tauo" ["他说" "她说"])
("tawz" ["他为" "它为" "她为"])
("taxd" ["他乡" "他想" "她想"])
("taxm" ["塌陷"])
("tayb" ["他有" "它有" "她有"])
("tayi" ["它以"])
("tazl" ["他在" "它在" "她在"])
("tb'" ["特别"])
("tbbc" ["投标"])
("tbbf" ["投奔"])
("tbbj" ["头版"])
("tbbk" ["投保"])
("tbbu" ["头部"])
("tbcp" ["头寸"])
("tbd'" ["谈不到"])
("tbdg" ["头等"])
("tbdi" ["投敌" "投递"])
("tbdj" ["同步电动机" "投弹"])
("tbdu" ["偷渡"])
("tbdy" ["头顶" "透顶"])
("tbe'" "钭")
("tbf'" ["特别法"])
("tbfa" ["头发"])
("tbfg" ["透风"])
("tbfh" ["投放"])
("tbg'" ["拓跋贵"])
("tbgd" ["透光"])
("tbgk" ["投稿"])
("tbgo" ["透过"])
("tbgu" ["头骨"])
("tbhk" ["头号"])
("tbhr" ["偷换"])
("tbi'" ["腾不出"])
("tbia" ["头茬"])
("tbie" ["透彻"])
("tbig" ["投诚"])
("tbij" ["投产"])
("tbjc" ["头角"])
("tbji" ["投机"])
("tbjn" ["头巾"])
("tbjy" ["头颈" "透镜"])
("tbkj" ["偷看"])
("tbkk" ["投考" "投靠"])
("tbld" ["透亮"])
("tbli" ["头里"])
("tblj" ["挑拨离间" "偷懒" "投篮"])
("tblu" ["头颅" "透露"])
("tbmu" ["头目"])
("tbmy" ["透明"])
("tbnk" ["头脑"])
("tbnm" ["头年"])
("tbpc" ["投票"])
("tbpi" ["头皮"])
("tbpy" ["透平"])
("tbq'" "偷")
("tbqi" ["透气"])
("tbr'" "透")
("tbru" ["投入"])
("tbso" ["投梭"])
("tbt'" ["拓跋焘"])
("tbtb" ["偷偷"])
("tbtc" ["头条"])
("tbtg" ["头疼"])
("tbtk" ["头套"])
("tbtm" ["头天"])
("tbts" ["头痛"])
("tbty" ["偷听"])
("tbu'" ["特别是" "拓跋氏" "台北市"])
("tbue" ["投射" "透射"])
("tbuf" ["投身"])
("tbuh" ["头上"])
("tbui" ["透视"])
("tbuv" ["偷税" "透水"])
("tbvi" ["投掷" "透支"])
("tbw'" "投头骰")
("tbwj" ["土崩瓦解"])
("tbxd" ["投降" "头像"])
("tbxi" ["偷袭"])
("tbxm" ["头衔"])
("tbxn" ["透信"])
("tbxu" ["头绪"])
("tbyh" ["头羊"])
("tbyk" ["投药"])
("tbyp" ["头晕"])
("tbyy" ["投影"])
("tbzi" ["投资" "头子"])
("tcan" ["条案"])
("tcbj" ["跳板"])
("tcbo" ["挑拨" "条播"])
("tcds" ["挑动" "跳动"])
("tce'" "挑窕")
("tcfu" ["调幅" "条幅"])
("tcgg" ["调羹"])
("tcgh" ["条钢"])
("tcgj" ["条干"])
("tcgk" ["跳高"])
("tche" ["调和"])
("tci'" ["唐才常"])
("tcif" ["条陈"])
("tciu" ["调处"])
("tcji" ["调剂"])
("tcjm" ["条件"])
("tcjx" ["调节" "调解"])
("tckr" ["条款"])
("tcks" ["调控"])
("tcl'" ["天才论"])
("tclc" ["调料"])
("tcli" ["条理" "条例"])
("tcma" ["跳马"])
("tcmu" ["条目"])
("tcpi" ["调皮"])
("tcpn" ["调频"])
("tcpz" ["调配"])
("tcq'" "挑佻祧")
("tcqi" ["挑起" "跳起"])
("tcr'" "眺跳粜")
("tcse" ["调色"])
("tcsj" ["跳伞"])
("tcso" ["调唆"])
("tcti" ["挑剔"])
("tctl" ["跳台"])
("tcty" ["调停"])
("tcug" ["跳绳"])
("tcui" ["调试"])
("tcuv" ["跳水"])
("tcvg" ["调整"])
("tcvi" ["调制" "条支"])
("tcvj" ["挑战"])
("tcw'" "调条迢苕蜩笤龆鲦髫")
("tcwf" ["条文" "条纹"])
("tcwh" ["眺望"])
("tcwu" ["跳舞"])
("tcwz" ["调味"])
("tcx'" ["铁磁性"])
("tcxd" ["跳箱"])
("tcxi" ["调戏"])
("tcxn" ["挑衅"])
("tcxr" ["挑选"])
("tcxx" ["调谐"])
("tcxy" ["条形"])
("tcyp" ["调匀"])
("tcyr" ["跳远"])
("tcyt" ["条约" "跳跃"])
("tczi" ["挑子" "条子"])
("tczk" ["跳蚤"])
("td'" ["它的"])
("tdb'" ["铁道兵" "铁道部"])
("tdbx" ["凸多边形"])
("tdgd" ["土地改革运动"])
("tdgg" ["土地改革"])
("tdgh" ["土地国有化"])
("tdgm" ["土地革命"])
("tdh'" ["天地会"])
("tdu'" ["土地税"])
("tdv'" ["土地证"])
("tdwy" ["贪得无厌"])
("tdx'" ["天底下"])
("tdxl" ["同等学历"])
("tebx" ["特别"])
("teci" ["特此"])
("teda" ["特大"])
("tedg" ["特等"])
("tedi" ["特地"])
("tedm" ["特点"])
("tedy" ["特定"])
("tegs" ["特工"])
("tehz" ["特黑"])
("teih" ["特长"])
("teij" ["特产"])
("teji" ["特级" "特技"])
("teli" ["特里" "特例"])
("tepl" ["特派"])
("teq'" ["土耳其"])
("teqr" ["特权"])
("tequ" ["特区"])
("ter'" "特忒忑慝铽")
("tes'" ["托儿所"])
("tese" ["特色"])
("test" ["托尔斯泰"])
("teue" ["特赦" "特设"])
("teui" ["特使"])
("teuu" ["特殊"])
("tevg" ["特征"])
("tevi" ["特制" "特质"])
("tevs" ["特种"])
("tewu" ["特务"])
("tewz" ["特为"])
("texc" ["特效"])
("texu" ["特许"])
("texx" ["特写"])
("texy" ["特性"])
("teyb" ["特有"])
("teyi" ["特意" "特异"])
("teyk" ["特邀"])
("teyt" ["特约"])
("tfj'" ["通风机"])
("tfmj" ["突飞猛进"])
("tfui" ["土法生产"])
("tfw'" ["铁饭碗"])
("tg'" ["通过"])
("tgai" ["疼爱"])
("tge'" ["泰戈尔"])
("tgf'" ["透光伐"])
("tggk" ["同甘共苦"])
("tgjl" ["偷工减料"])
("tgjt" ["提高警惕"])
("tgks" ["腾空"])
("tgkw" ["天工开物"])
("tgqy" ["誊清"])
("tgtg" ["腾腾"])
("tgti" ["同工同酬"])
("tgts" ["疼痛"])
("tgtx" ["统购统销"])
("tgw'" "藤腾疼誊滕")
("tgxx" ["誊写"])
("tgyi" ["藤椅"])
("tgyt" ["腾越"])
("thb'" ["天花板"])
("thbv" ["蜕化变质"])
("thci" ["搪瓷"])
("thcu" ["醣醋"])
("thd'" ["提货单"])
("thdk" ["躺倒"])
("thdl" ["唐代"])
("the'" "倘躺淌傥帑")
("thfa" ["烫发"])
("thg'" ["弹簧钢" "碳化硅"])
("thgo" ["汤锅" "糖果" "醣果"])
("thgr" ["堂倌"])
("thhd" ["堂皇"])
("thhj" ["淌汗"])
("thhv" ["堂会"])
("thhw" ["醣化"])
("thi'" ["弹簧秤"])
("thid" ["镗床"])
("thih" ["醣厂"])
("thik" ["唐朝"])
("thj'" ["铁合金"])
("thjd" ["糖浆" "醣浆"])
("thjy" ["糖精" "醣精"])
("thke" ["堂客"])
("thks" ["镗孔"])
("thl'" ["汤化龙"])
("thlc" ["躺了"])
("thlu" ["土豪劣绅"])
("thlv" ["唐律" "天花乱坠"])
("thlz" ["醣类"])
("thmi" ["醣蜜"])
("thng" ["倘能"])
("thni" ["塘泥"])
("thpv" ["通货膨胀"])
("thq'" "汤趟铴镗耥羰")
("thqi" ["醣槭"])
("thr'" "趟烫")
("thrf" ["唐人"])
("thrj" ["倘然"])
("thro" ["倘若"])
("thry" ["谈何容易"])
("thse" ["搪塞"])
("thth" ["堂堂"])
("thtr" ["汤团"])
("thtu" ["唐突"])
("thuh" ["堂上" "烫伤"])
("thui" ["唐诗" "倘使"])
("thuj" ["唐山"])
("thuv" ["糖水" "醣水"])
("thvf" ["唐甄"])
("thvs" ["唐中"])
("thw'" ["塘" "搪" "堂" "棠" "膛" "唐" "糖" "饧" "溏" "瑭" "樘" "镗" "螗" "螳" "醣" "碳化物"])
("thwu" ["堂屋"])
("thxw" ["躺下"])
("thyi" ["躺椅" "醣衣"])
("thyk" ["汤药"])
("thyr" ["汤圆"])
("thzi" ["堂子"])
("thzl" ["躺在"])
("thzy" ["同化作用"])
("ti'" ["退出"])
("tian" ["提案"])
("tiba" ["提拔"])
("tibi" ["体壁"])
("tibk" ["提包"])
("tici" ["题词"])
("tick" ["体操"])
("ticl" ["题材" "体裁"])
("tidc" ["提调"])
("tidj" ["提单"])
("tidk" ["提到"])
("tidl" ["替代"])
("tidu" ["梯度" "提督"])
("tie'" "体")
("tifa" ["提法" "体罚"])
("tifv" ["提纯复壮"])
("tige" ["体格"])
("tigh" ["提纲"])
("tigk" ["提高"])
("tigs" ["提供"])
("tiho" ["提货"])
("tihr" ["替换"])
("tihv" ["体会"])
("tihw" ["提花"])
("tii'" ["停车场"])
("tiia" ["体察"])
("tiig" ["提成"])
("tiih" ["提倡"])
("tiip" ["提纯"])
("tiiu" ["剔出" "剔除" "提出"])
("tiix" ["推陈出新"])
("tijc" ["提交"])
("tijg" ["统筹兼顾"])
("tiji" ["梯级" "体积"])
("tijm" ["体检"])
("tijw" ["提价"])
("tiku" ["啼哭"])
("tild" ["体谅"])
("tili" ["体例" "体力"])
("tilm" ["提炼"])
("timm" ["体面"])
("timu" ["题目"])
("timy" ["提名" "题名"])
("tipo" ["体魄"])
("tiq'" "梯剔踢锑体")
("tiqd" ["体腔"])
("tiqi" ["提起"])
("tiqm" ["提前"])
("tiqn" ["提琴"])
("tiqq" ["踢球"])
("tiqu" ["提取"])
("tir'" "替嚏惕涕剃屉倜悌逖绨裼")
("tirf" ["替人"])
("titb" ["剃头"])
("titl" ["体态"])
("titm" ["梯田"])
("titx" ["体贴"])
("tiuf" ["提审"])
("tiug" ["提升"])
("tiui" ["提示"])
("tivi" ["提制" "体制" "体质"])
("tivs" ["体重"])
("tiw'" "提题蹄啼荑绨缇鹈醍")
("tiwf" ["提问" "体温"])
("tixi" ["体系"])
("tixm" ["体现"])
("tixu" ["剃须"])
("tixx" ["提携"])
("tixy" ["梯形" "提醒" "体型" "体形"])
("tiye" ["体液"])
("tiyi" ["提议" "体已"])
("tiyj" ["体验"])
("tiyk" ["提要"])
("tiyu" ["体育"])
("tizi" ["梯子" "题字" "蹄子"])
("tizk" ["提早"])
("tj'" ["条件"])
("tjb'" ["炭疽病" "统计表"])
("tjbi" ["炭笔"])
("tjbl" ["坦白"])
("tjce" ["探测"])
("tjcj" ["条件刺激"])
("tjdb" ["投机倒把"])
("tjdh" ["坦荡"])
("tjdk" ["谈到"])
("tjdy" ["天经地义"])
("tje'" "坦毯袒忐钽")
("tjf'" ["图解法"])
("tjfh" ["探访"])
("tjfj" ["摊贩"])
("tjfu" ["条件反射"])
("tjgl" ["田间管理"])
("tjhd" ["弹簧"])
("tjhe" ["弹劾"])
("tjhj" ["讨价还价"])
("tjho" ["炭火"])
("tjhr" ["瘫痪"])
("tjhu" ["袒护"])
("tjhv" ["弹回"])
("tjhw" ["谈话" "炭化" "昙花"])
("tji'" ["铁甲车"])
("tjig" ["谈成"])
("tjih" ["谈唱"])
("tjiu" ["弹出"])
("tjj'" ["添加剂"])
("tjjq" ["探究"])
("tjk'" ["塔吉克"])
("tjkd" ["探矿"])
("tjke" ["坦克"])
("tjkl" ["摊开"])
("tjli" ["弹力"])
("tjlj" ["贪婪"])
("tjlp" ["谈论"])
("tjmu" ["檀木"])
("tjmy" ["探明"])
("tjp'" ["停经片"])
("tjpj" ["谈判"])
("tjpl" ["摊牌" "摊派"])
("tjq'" ["坍" "摊" "贪" "瘫" "滩" "调节器" "太极拳" "推进器"])
("tjqi" ["叹气"])
("tjqn" ["弹琴" "探亲"])
("tjqq" ["探求"])
("tjr'" "碳探叹炭")
("tjrj" ["坦然"])
("tjso" ["探索"])
("tjsr" ["碳酸"])
("tjsu" ["炭素"])
("tjt'" ["统计图"])
("tjta" ["坍塌"])
("tjtb" ["探头"])
("tjtc" ["弹跳"])
("tjtj" ["谈谈"])
("tjtk" ["探讨"])
("tjtm" ["谈天"])
("tjto" ["谈妥"])
("tjtu" ["贪图" "谈吐"])
("tjty" ["探听"])
("tju'" ["天津市"])
("tjuh" ["探伤"])
("tjui" ["探视"])
("tjuw" ["炭刷"])
("tjuy" ["坦率"])
("tjvb" ["潭州"])
("tjw'" "弹坛檀痰潭谭谈郯澹昙锬镡覃")
("tjwf" ["探问"])
("tjwh" ["探望"])
("tjwj" ["贪玩"])
("tjwu" ["贪污"])
("tjx'" ["统计学"])
("tjxd" ["檀香"])
("tjxi" ["叹息"])
("tjxm" ["探险"])
("tjxn" ["谈心"])
("tjxp" ["探询"])
("tjxy" ["弹性"])
("tjy'" ["唐继尧"])
("tjya" ["弹压"])
("tjyd" ["田径运动"])
("tjyk" ["炭窑"])
("tjyr" ["潭渊" "碳源"])
("tjyu" ["贪欲" "痰盂"])
("tjzb" ["弹奏"])
("tjzh" ["贪赃"])
("tjzi" ["摊子" "坛子" "毯子"])
("tkbi" ["逃避"])
("tkby" ["逃兵"])
("tkci" ["陶瓷"])
("tkck" ["掏槽"])
("tkcr" ["逃窜"])
("tke'" "讨")
("tkfa" ["讨伐"])
("tkff" ["掏粪"])
("tkfj" ["讨饭"])
("tkgb" ["套购"])
("tkgs" ["陶工"])
("tkhd" ["逃荒"])
("tkhk" ["讨好"])
("tkhs" ["桃红"])
("tkhw" ["桃花"])
("tkis" ["绦虫"])
("tkiu" ["掏出"])
("tkjd" ["桃江"])
("tkjm" ["套间"])
("tkli" ["桃李"])
("tklp" ["讨论"])
("tklu" ["套路"])
("tkmy" ["逃命"])
("tknj" ["逃难"])
("tkpk" ["逃跑"])
("tkq'" "掏涛滔绦叨韬焘饕")
("tkqi" ["淘气" "陶器"])
("tkr'" "套")
("tkrf" ["桃仁"])
("tkse" ["桃色" "套色"])
("tktk" ["滔滔" "套套"])
("tktl" ["淘汰"])
("tktm" ["滔天"])
("tkto" ["逃脱"])
("tkts" ["套筒"])
("tktu" ["陶土"])
("tkuh" ["套上"])
("tkuu" ["桃树"])
("tkvs" ["套种"])
("tkw'" "萄桃逃淘陶鼗啕洮")
("tkwh" ["逃亡"])
("tkye" ["陶冶"])
("tkyi" ["逃逸"])
("tkyj" ["讨厌"])
("tkyn" ["套印"])
("tkyr" ["桃源"])
("tkys" ["套用"])
("tkzb" ["逃走"])
("tkzi" ["桃子" "套子"])
("tkzo" ["套作"])
("tkzv" ["陶醉"])
("tl'" ["讨论"])
("tlan" ["台安"])
("tlbk" ["台胞" "太保"])
("tlbl" ["太白"])
("tlbu" ["台布"])
("tlbz" ["台北"])
("tlch" ["太仓"])
("tlci" ["台词"])
("tlcj" ["托洛茨基"])
("tld'" ["坍落度"])
("tlda" ["太大"])
("tldg" ["台灯"])
("tldi" ["台地" "太低"])
("tldo" ["太多"])
("tldr" ["太短"])
("tldu" ["态度"])
("tle'" "呔")
("tler" ["胎儿"])
("tlf'" ["吐鲁番"])
("tlfg" ["台风"])
("tlfu" ["太傅"])
("tlgk" ["抬高" "太高"])
("tlgo" ["泰国"])
("tlgs" ["太公"])
("tlgu" ["太古"])
("tlh'" ["讨论会" "填料函"])
("tlhb" ["太后"])
("tlhe" ["泰和" "太和"])
("tlhk" ["太好"])
("tlhu" ["太湖"])
("tlhy" ["太坏"])
("tlhz" ["通力合作"])
("tlie" ["台车"])
("tlih" ["太长"])
("tlj'" ["天理教" "拖拉机" "脱粒机"])
("tlji" ["太极"])
("tljm" ["太监"])
("tljn" ["太近"])
("tljp" ["太君"])
("tlju" ["拖拉机手"])
("tljv" ["拖拉机站"])
("tljw" ["太甲"])
("tljx" ["台阶"])
("tlkh" ["太康"])
("tlks" ["太空"])
("tlky" ["太快"])
("tll'" ["同龄林"])
("tlld" ["体力劳动"])
("tlle" ["泰勒"])
("tllg" ["太冷"])
("tlly" ["泰陵"])
("tlmg" ["太猛"])
("tlmj" ["太慢"])
("tlnj" ["太难"])
("tlpj" ["胎盘"])
("tlpy" ["太平"])
("tlq'" "胎苔台")
("tlqd" ["太强"])
("tlqi" ["抬起"])
("tlqm" ["台前"])
("tlqq" ["台球"])
("tlr'" "泰酞太态汰肽钛")
("tlre" ["太热"])
("tlro" ["太弱"])
("tls'" ["弹力丝" "托拉斯"])
("tltb" ["抬头"])
("tltl" ["太太"])
("tlub" ["太守"])
("tluf" ["太甚"])
("tlug" ["胎生"])
("tluh" ["台上"])
("tlui" ["太师"])
("tluj" ["泰山" "停留时间"])
("tluk" ["太少"])
("tlv'" ["凸轮轴"])
("tlvj" ["台站"])
("tlvs" ["台中"])
("tlw'" "苔抬台邰薹骀炱跆鲐")
("tlwh" ["台网"])
("tlwj" ["台湾"])
("tlwz" ["太尉"])
("tlx'" ["同类项"])
("tlxc" ["太小"])
("tlxi" ["泰西"])
("tlxt" ["太学"])
("tlxu" ["太虚"])
("tlye" ["太爷"])
("tlyh" ["太阳"])
("tlyj" ["抬眼"])
("tlyr" ["苔原" "太原" "太远"])
("tlzi" ["台子" "太子"])
("tlzk" ["太早"])
("tlzu" ["太祖"])
("tm'" ["它们"])
("tmb'" ["他们被" "它们被"])
("tmbc" ["填表"])
("tmbg" ["同盟罢工"])
("tmbj" ["天半"])
("tmbk" ["天保" "天宝" "填报"])
("tmbm" ["天边"])
("tmbo" ["天波"])
("tmbu" ["填补"])
("tmby" ["天兵"])
("tmci" ["天赐"])
("tmcl" ["天才" "甜菜"])
("tmd'" ["他妈的" "它们的" "透明度"])
("tmdi" ["天敌" "天地" "田地"])
("tmdk" ["天道"])
("tmdm" ["天电"])
("tme'" "舔腆忝殄")
("tmee" ["天鹅"])
("tmfh" ["天放"])
("tmfu" ["天赋" "田赋"])
("tmg'" ["同盟国"])
("tmgb" ["天沟" "天狗"])
("tmgd" ["天光"])
("tmgg" ["田埂"])
("tmgj" ["天干"])
("tmgo" ["天国"])
("tmgs" ["天工"])
("tmgw" ["甜瓜"])
("tmh'" ["同盟会"])
("tmhb" ["天后"])
("tmhd" ["天皇"])
("tmhe" ["天和"])
("tmhv" ["天会"])
("tmhw" ["天花"])
("tmib" ["田畴"])
("tmid" ["天窗"])
("tmie" ["天车"])
("tmig" ["天成"])
("tmih" ["天长"])
("tmil" ["探明储量"])
("tmis" ["填充"])
("tmj'" ["同盟军"])
("tmji" ["天际"])
("tmjm" ["田间"])
("tmjn" ["天津"])
("tmjw" ["添加"])
("tmjy" ["天京" "天井" "田径" "恬静"])
("tmkl" ["天开"])
("tmks" ["天空" "填空"])
("tmlc" ["填料"])
("tmld" ["天凉" "天亮"])
("tmli" ["天理" "田里"])
("tmlj" ["天蓝"])
("tmlp" ["天论"])
("tmmf" ["天门"])
("tmmi" ["甜蜜"])
("tmmj" ["填满"])
("tmmu" ["天幕" "田亩"])
("tmmy" ["天明" "天命"])
("tmmz" ["甜美"])
("tmna" ["天哪"])
("tmpg" ["天棚"])
("tmpy" ["天平" "填平"])
("tmq'" "天添")
("tmqc" ["天桥"])
("tmqi" ["天契" "天气" "田七"])
("tmqq" ["天球"])
("tmqr" ["天全"])
("tmr'" "掭")
("tmrf" ["天人"])
("tmri" ["天日"])
("tmrj" ["天然"])
("tmrw" ["头面人物"])
("tms'" ["土霉素" "托马斯"])
("tmse" ["天色"])
("tmsl" ["田赛"])
("tmtb" ["天头" "甜头"])
("tmth" ["天堂"])
("tmti" ["天体"])
("tmtj" ["天坛"])
("tmtm" ["天天"])
("tmty" ["同盟条约"])
("tmu'" ["天目山" "同名数"])
("tmub" ["天授"])
("tmue" ["添设"])
("tmuf" ["天神"])
("tmug" ["天生"])
("tmuh" ["天上"])
("tmui" ["天时" "天使"])
("tmuj" ["天山"])
("tmuo" ["天说"])
("tmup" ["天顺"])
("tmuu" ["天书" "天数" "田鼠"])
("tmuv" ["天水"])
("tmvd" ["田庄"])
("tmvf" ["天真"])
("tmvg" ["天正"])
("tmvi" ["添置"])
("tmvu" ["天主" "天柱" "天竺" "田主"])
("tmw'" "佃填田甜恬阗畋钿")
("tmwf" ["天文"])
("tmwh" ["天王"])
("tmwj" ["天完"])
("tmwz" ["甜味"])
("tmxd" ["天象"])
("tmxm" ["天险" "天线"])
("tmxs" ["天雄"])
("tmxw" ["天下"])
("tmxx" ["填写"])
("tmxy" ["天性"])
("tmya" ["天涯" "填鸭"])
("tmyb" ["天佑"])
("tmye" ["田野"])
("tmyi" ["天一" "天意"])
("tmyr" ["田园"])
("tmze" ["天择"])
("tmzh" ["天葬"])
("tmzi" ["天资" "天子"])
("tmzl" ["天灾"])
("tmzs" ["天纵"])
("tn'" ["同年"])
("tnb'" ["醣尿病"])
("tndu" ["拖泥带水"])
("tns'" ["突尼斯"])
("toba" ["拓跋"])
("tobz" ["驼背"])
("todc" ["脱掉"])
("todh" ["妥当"])
("todk" ["拖到"])
("todl" ["拖带"])
("toe'" "椭妥庹")
("toer" ["托儿"])
("togr" ["托管"])
("toie" ["拖车"])
("toij" ["脱产"])
("toir" ["拖船"])
("toiu" ["脱出"])
("tojc" ["脱胶"])
("tojw" ["托架"])
("tojx" ["脱节"])
("tokb" ["脱口"])
("toks" ["脱空"])
("tola" ["拖拉"])
("toli" ["脱离" "脱粒"])
("tolo" ["陀螺"])
("tolq" ["脱硫"])
("tolz" ["拖累"])
("toma" ["托马" "唾骂"])
("tomk" ["脱毛"])
("tomo" ["唾沫"])
("tomu" ["脱模"])
("tonc" ["鸵鸟"])
("toni" ["拖泥"])
("topj" ["托盘"])
("topk" ["脱泡"])
("topu" ["拓扑" "拓朴"])
("toq'" "拖托脱乇")
("toqi" ["唾弃"])
("toqm" ["拖欠"])
("toqq" ["椭球"])
("toqy" ["脱氢"])
("tor'" "魄拓唾柝箨")
("tors" ["驼绒"])
("tose" ["脱色"])
("tosu" ["脱俗"])
("totj" ["脱碳"])
("totk" ["脱逃"])
("totl" ["脱胎"])
("toub" ["脱手"])
("touf" ["脱身"])
("touj" ["妥善"])
("touv" ["脱水"])
("tovi" ["脱脂"])
("tow'" "舵鸵陀驮驼佗坨沱柁橐砣铊酡跎鼍")
("towh" ["拖网"])
("towz" ["托维"])
("toxc" ["脱销"])
("toxm" ["脱险"])
("toxx" ["拖鞋" "妥协"])
("toye" ["唾液"])
("toyh" ["脱氧"])
("toyi" ["脱衣"])
("toyj" ["拖延" "脱盐"])
("toyp" ["托运"])
("toyr" ["椭圆"])
("tpbu" ["臀部"])
("tpby" ["吞并"])
("tpd'" ["太平道"])
("tpe'" "氽")
("tpgj" ["太平广记"])
("tpj'" ["太平军" "通配键"])
("tpji" ["囤积"])
("tpk'" ["突破口"])
("tpli" ["屯里"])
("tpm'" ["太平门"])
("tpmo" ["吞没"])
("tpnj" ["同旁内角"])
("tpq'" "吞暾")
("tpqi" ["臀鳍"])
("tpr'" "褪")
("tptg" ["太平天国"])
("tptm" ["屯田"])
("tptu" ["吞吐"])
("tpui" ["吞食" "吞噬"])
("tpuu" ["豚鼠"])
("tpw'" "囤屯臀饨豚")
("tpy'" ["太平洋" "贪便宜"])
("tpzi" ["屯子"])
("tqdl" ["通情达理"])
("tqhw" ["碳氢化合物"])
("tqq'" ["推铅球"])
("tqxu" ["天气形势"])
("tqxx" ["天气现象"])
("tqyb" ["天气预报"])
("tr'" ["突然"])
("tre'" "疃")
("trel" ["天然饵料"])
("trf'" ["谭人凤"])
("trfl" ["土壤肥力"])
("trgx" ["天然更新"])
("tria" ["团茶"])
("trj'" ["天然碱"])
("trjg" ["土壤结构"])
("trji" ["湍急"])
("trjt" ["土壤胶体"])
("trju" ["团聚"])
("trjx" ["团结"])
("trl'" ["天然林"])
("trlm" ["团练"])
("trlq" ["湍流"])
("trq'" ["湍" "天然漆" "天然气"])
("trqi" ["团旗"])
("trqj" ["天然气井"])
("trql" ["突如其来"])
("trr'" "彖")
("trry" ["土壤溶液"])
("trs'" ["天然丝"])
("trti" ["团体"])
("trtr" ["团团"])
("tru'" ["土壤水"])
("trud" ["土壤湿度"])
("truv" ["天然树脂"])
("trvh" ["团长"])
("trw'" "团抟")
("trwd" ["土壤温度"])
("trww" ["土壤微生物"])
("trwz" ["团委"])
("trxj" ["天然橡胶" "突然袭击"])
("trxw" ["天然纤维"])
("tryr" ["团员" "团圆"])
("tryv" ["土壤有机质"])
("trzj" ["天然杂交"])
("tsan" ["同案"])
("tsb'" ["钛酸钡"])
("tsbj" ["同伴" "铜板"])
("tsbk" ["通宝" "通报" "同胞"])
("tsbu" ["同步"])
("tsby" ["通病"])
("tsbz" ["同辈"])
("tsda" ["通达" "痛打"])
("tsdg" ["同等"])
("tsdk" ["通道" "同道"])
("tsdl" ["统带"])
("tsdm" ["通典" "通电"])
("tsdw" ["通俗读物"])
("tse'" ["侗" "桶" "捅" "筒" "统" "唐赛儿"])
("tsff" ["通分"])
("tsfg" ["通风"])
("tsg'" ["碳素钢" "碳酸钙"])
("tsgb" ["统购"])
("tsgj" ["同感"])
("tsgk" ["通告"])
("tsgo" ["通国" "通过"])
("tsgr" ["铜管" "筒管" "潼关"])
("tsgs" ["童工"])
("tsgv" ["同归"])
("tshf" ["痛恨"])
("tshh" ["通航" "同行"])
("tsho" ["通货" "同伙"])
("tshp" ["通婚"])
("tshs" ["通红"])
("tshw" ["通化" "通话" "同化" "童话"])
("tsib" ["统筹"])
("tsid" ["同窗"])
("tsie" ["通车"])
("tsig" ["通称" "统称"])
("tsih" ["通常" "通畅" "铜厂"])
("tsii" ["痛斥"])
("tsij" ["同产"])
("tsir" ["捅穿"])
("tsiu" ["痛楚"])
("tsj'" ["碳酸钾"])
("tsji" ["通缉" "统计"])
("tsju" ["同居"])
("tskd" ["铜矿"])
("tske" ["同科"])
("tskk" ["通考" "统考"])
("tsks" ["瞳孔"])
("tsku" ["痛哭" "痛苦"])
("tsky" ["痛快"])
("tsl'" ["特斯拉"])
("tslc" ["同僚"])
("tsld" ["通量"])
("tsli" ["通例"])
("tslu" ["通路"])
("tsly" ["通令" "统领"])
("tslz" ["同类"])
("tsm'" ["碳酸镁"])
("tsma" ["痛骂"])
("tsmb" ["同谋"])
("tsmg" ["同盟"])
("tsmy" ["通明" "同名"])
("tsn'" ["碳酸钠"])
("tsnm" ["同年" "童年"])
("tsny" ["坦桑尼亚"])
("tspj" ["通盘"])
("tspl" ["铜牌"])
("tspo" ["捅破"])
("tsq'" ["恫" "通" "嗵" "调速器"])
("tsqa" ["碳酸氢铵"])
("tsqi" ["通气" "同期" "同气" "铜器"])
("tsqm" ["铜钱"])
("tsqn" ["碳酸氢钠"])
("tsqx" ["痛切"])
("tsqy" ["同情"])
("tsr'" "通同痛恸")
("tsrf" ["通人" "同仁" "同人"])
("tsrs" ["通融"])
("tssi" ["铜丝"])
("tssu" ["通俗"])
("tssv" ["同岁"])
("tst'" ["谭嗣同"])
("tstm" ["通天"])
("tsts" ["通通" "通同" "统统"])
("tsu'" ["塔斯社"])
("tsug" ["童声"])
("tsuh" ["通商" "同上"])
("tsui" ["通史" "通式" "同时" "同事" "同是"])
("tsup" ["通顺"])
("tsuu" ["通书"])
("tsuy" ["统率" "统帅"])
("tsvb" ["通州"])
("tsvg" ["同正"])
("tsvh" ["通胀"])
("tsvi" ["通知" "通志" "同知" "同志" "同治" "统制" "统治"])
("tsvj" ["统战"])
("tsw'" ["侗" "桐" "酮" "瞳" "同" "铜" "彤" "童" "佟" "仝" "垌" "茼" "峒" "潼" "砼" "铁丝网"])
("tswh" ["通往"])
("tsxc" ["通宵" "通晓" "统销"])
("tsxd" ["同乡" "铜像"])
("tsxm" ["通县"])
("tsxn" ["通信" "同心" "童心" "痛心"])
("tsxp" ["通讯"])
("tsxr" ["统选"])
("tsxt" ["同学"])
("tsxw" ["统辖"])
("tsxy" ["通行" "同行" "同性" "同姓"])
("tsy'" ["碳酸盐"])
("tsya" ["通押"])
("tsyb" ["通邮" "桐油"])
("tsyd" ["跳伞运动"])
("tsyh" ["同样"])
("tsyi" ["通译" "同一" "同意" "统一"])
("tsyk" ["童谣"])
("tsyr" ["同源"])
("tsys" ["通用"])
("tsyt" ["同素异形体"])
("tsze" ["通则"])
("tszi" ["童子" "筒子"])
("tszs" ["同宗"])
("ttbj" ["滔滔不绝"])
("ttc'" ["团体操"])
("tti'" ["土特产"])
("ttj'" ["跳汰机" "推土机"])
("ttk'" ["屯田客"])
("ttkk" ["痛痛快快"])
("ttl'" ["吞吐量"])
("ttmm" ["偷偷摸摸"])
("tts'" ["团体赛"])
("tttt" ["吞吞吐吐"])
("ttud" ["头头是道"])
("ttuu" ["踏踏实实"])
("ttz'" ["唐太宗"])
("tu'" ["同时"])
("tuan" ["图案"])
("tubc" ["图表"])
("tubm" ["突变"])
("tubu" ["徒步" "土布"])
("tucg" ["土层"])
("tudb" ["土豆"])
("tudi" ["徒弟" "土地"])
("tudk" ["屠刀"])
("tudr" ["土断"])
("tudy" ["秃顶"])
("tue'" "土吐钍")
("tuei" ["挺身而出"])
("tuer" ["图二"])
("tuf'" ["土石方"])
("tufa" ["土法"])
("tuff" ["土粪"])
("tufh" ["土方"])
("tufj" ["吐蕃"])
("tufu" ["屠夫"])
("tufz" ["土匪"])
("tug'" ["图书馆"])
("tugl" ["涂改" "土改"])
("tugs" ["徒工" "土工"])
("tuh'" ["特殊化"])
("tuhd" ["土黄"])
("tuhk" ["土豪"])
("tuhw" ["碳水化合物" "图画" "土话"])
("tuig" ["途程"])
("tuij" ["土产"])
("tuil" ["妥善处理"])
("tuiu" ["凸出" "突出" "突触"])
("tuji" ["突击"])
("tujn" ["突进"])
("tujt" ["突厥"])
("tujw" ["土家"])
("tujx" ["图解"])
("tujy" ["图景" "途径"])
("tula" ["图拉"])
("tulc" ["涂料"])
("tuli" ["图例"])
("tulk" ["徒劳"])
("tulp" ["凸轮"])
("tulu" ["吐露"])
("tumb" ["图谋"])
("tumf" ["土门"])
("tumk" ["兔毛"])
("tumo" ["涂抹"])
("tumu" ["土木"])
("tupi" ["土坯"])
("tupm" ["图片"])
("tupo" ["突破"])
("tuq'" ["凸" "秃" "突" "汤寿潜"])
("tuqi" ["凸起" "突起" "土气" "吐气"])
("tuqj" ["塔式起重机"])
("tuqu" ["突去"])
("tur'" "吐兔堍菟")
("turf" ["土人"])
("turh" ["土壤"])
("turj" ["突然" "徒然"])
("tusi" ["吐丝"])
("tusj" ["图三"])
("tut'" ["透视图"])
("tutb" ["凸透"])
("tutg" ["图腾"])
("tutu" ["突突"])
("tuua" ["屠杀"])
("tuub" ["徒手"])
("tuui" ["图式"])
("tuuo" ["图说"])
("tuuu" ["图书"])
("tuvh" ["图章" "徒长"])
("tuvi" ["图纸" "土质"])
("tuvs" ["途中"])
("tuvu" ["土著"])
("tuw'" "图徒途涂屠荼菟酴")
("tuwf" ["土温"])
("tuwu" ["突兀"])
("tuwz" ["突围" "图为"])
("tux'" ["特殊性" "透水性"])
("tuxd" ["图像" "图象"])
("tuxi" ["突袭"])
("tuxu" ["吐絮"])
("tuxy" ["图形" "徒刑" "土性"])
("tuy'" ["唐绍仪"])
("tuyh" ["图样"])
("tuyi" ["图一"])
("tuyr" ["凸缘"])
("tuzi" ["兔子"])
("tuzl" ["屠宰"])
("tuzu" ["土族"])
("tv'" ["通知"])
("tvb'" ["团支部"])
("tvbm" ["蜕变"])
("tvbq" ["停滞不前"])
("tvbu" ["腿部" "退步"])
("tvby" ["退兵"])
("tvce" ["推测"])
("tvci" ["推辞" "退磁"])
("tvd'" ["探照灯"])
("tvdk" ["推倒" "推导"])
("tvdl" ["同轴电缆" "推戴"])
("tvdr" ["推断"])
("tvds" ["推动"])
("tve'" "腿")
("tvfj" ["推翻"])
("tvfz" ["颓废"])
("tvgd" ["推广"])
("tvge" ["退格"])
("tvgj" ["推杆"])
("tvho" ["退火" "退货"])
("tvhr" ["退还"])
("tvhv" ["退回"])
("tvhw" ["蜕化" "退化"])
("tvii" ["推迟" "推斥"])
("tvik" ["退潮"])
("tvis" ["推崇"])
("tviu" ["推出" "退出"])
("tvj'" ["天主教"])
("tvjc" ["腿脚"])
("tvjd" ["退浆"])
("tvjj" ["统治阶级"])
("tvjm" ["推荐"])
("tvjn" ["推进"])
("tvjq" ["推究"])
("tvju" ["推举"])
("tvkl" ["推开"])
("tvl'" ["通胀率"])
("tvli" ["推理" "退离"])
("tvlp" ["推论"])
("tvm'" ["同志们"])
("tvmo" ["推磨"])
("tvpc" ["退票"])
("tvpi" ["蜕皮"])
("tvpz" ["退赔"])
("tvq'" ["推" "忒" "调整器"])
("tvqc" ["推敲"])
("tvqq" ["推求"])
("tvqt" ["退却"])
("tvr'" "蜕褪退煺")
("tvrh" ["退让"])
("tvrv" ["听之任之"])
("tvse" ["褪色"])
("tvsh" ["颓丧"])
("tvso" ["退缩"])
("tvsr" ["推算"])
("tvto" ["推托" "推脱"])
("tvtu" ["推土"])
("tvu'" ["通知书"])
("tvub" ["退守"])
("tvui" ["推事"])
("tvv'" ["统治者" "徒长枝"])
("tvvi" ["退职"])
("tvvs" ["推重"])
("tvw'" "颓")
("tvwh" ["退网"])
("tvwj" ["推挽"])
("tvwu" ["退伍"])
("tvwz" ["退位"])
("tvxc" ["推销"])
("tvxd" ["推想"])
("tvxi" ["退席"])
("tvxq" ["退休"])
("tvxr" ["推选"])
("tvxt" ["退学"])
("tvxu" ["体胀系数"])
("tvxx" ["推卸"])
("tvxy" ["推行"])
("tvyi" ["推移"])
("tvzi" ["腿子"])
("tw'" ["它为"])
("twdq" ["贪污盗窃"])
("twdw" ["天文单位"])
("twhh" ["天网恢恢"])
("twj'" ["同位角"])
("twjr" ["退伍军人"])
("tws'" ["同位素"])
("twt'" ["天文台"])
("twu'" ["台湾省"])
("twub" ["泰晤士报"])
("twuh" ["贪污受贿"])
("twx'" ["天王星" "天文学"])
("txb'" ["体细胞" "头胸部"])
("txbj" ["铁板"])
("txbu" ["贴补"])
("txby" ["铁饼"])
("txda" ["铁打"])
("txdd" ["提心吊胆"])
("txdk" ["铁道"])
("txe'" "铁帖")
("txfj" ["铁饭"])
("txgo" ["铁锅"])
("txgr" ["铁管"])
("txgs" ["铁工"])
("txgv" ["铁轨"])
("txih" ["铁厂"])
("txjd" ["铁匠"])
("txjn" ["贴近"])
("txjw" ["铁甲"])
("txkd" ["铁矿"])
("txld" ["铁良"])
("txlm" ["铁链"])
("txlu" ["铁路"])
("txmf" ["铁门"])
("txnq" ["铁牛"])
("txpi" ["铁皮"])
("txq'" "贴帖萜")
("txqc" ["铁锹"])
("txqx" ["贴切"])
("txqy" ["铁青"])
("txr'" "帖餮")
("txrf" ["铁人"])
("txsi" ["铁丝"])
("txt'" ["弹性体"])
("txta" ["铁塔"])
("txtd" ["同心同德"])
("txtp" ["天下太平"])
("txts" ["铁桶"])
("txu'" ["檀香山" "通讯社"])
("txuf" ["贴身"])
("txuu" ["铁树"])
("txuv" ["铁水"])
("txv'" ["通行证"])
("txvf" ["铁砧" "推心置腹"])
("txvg" ["铁证"])
("txvi" ["铁制"])
("txvy" ["投降主义"])
("txwx" ["通信卫星"])
("txxl" ["通信线路" "同心协力"])
("txxm" ["贴现" "铁锨"])
("txxn" ["贴心" "铁心"])
("txxq" ["铁锈"])
("txxx" ["铁屑"])
("txy'" ["通信员" "通讯员"])
("txyj" ["铁盐"])
("txz'" ["唐玄宗"])
("ty'" ["统一"])
("tyba" ["挺拔"])
("tybj" ["停办" "土洋并举"])
("tybo" ["停泊"])
("tycs" ["听从"])
("tyd'" ["统一党"])
("tydh" ["停当"])
("tydi" ["太阳电池"])
("tydk" ["听到"])
("tydl" ["体育锻炼"])
("tydm" ["停电"])
("tydp" ["停顿"])
("tyds" ["通用电气公司"])
("tye'" ["挺" "艇" "梃" "町" "铤" "梯也尔"])
("tyfa" ["停发"])
("tyfh" ["停放"])
("tyfu" ["太阳辐射"])
("tyg'" ["体育馆"])
("tygh" ["同业公会"])
("tygs" ["停工"])
("tyhb" ["听候"])
("tyhd" ["太阳活动"])
("tyho" ["停火"])
("tyht" ["脱氧核糖"])
("tyhw" ["听话"])
("tyi'" ["体育场"])
("tyie" ["停车"])
("tyij" ["停产"])
("tyil" ["听差"])
("tyjc" ["添油加醋"])
("tyjd" ["听讲" "汀江"])
("tyjh" ["统一计划" "土洋结合"])
("tyji" ["停机"])
("tyjm" ["听见"])
("tyjn" ["挺进"])
("tyjt" ["听觉"])
("tyjw" ["腾云驾雾"])
("tyke" ["听课"])
("tykj" ["停刊"])
("tykk" ["停靠"])
("tyl'" ["天演论"])
("tyli" ["挺立"])
("tylq" ["停留"])
("tym'" ["投影面"])
("tymh" ["挺忙"])
("tymy" ["听命"])
("tyn'" ["太阳能"])
("typy" ["听凭"])
("tyq'" "厅听烃汀")
("tyqi" ["挺起"])
("tyqu" ["听取"])
("tyr'" ["梃" "太阳日"])
("tyrf" ["听任"])
("tyt'" ["铁氧体" "统一体"])
("tyth" ["厅堂"])
("tyts" ["听筒"])
("tyty" ["听听"])
("tyu'" ["太阳升" "太原市"])
("tyuf" ["挺身"])
("tyui" ["停食"])
("tyuo" ["听说"])
("tyvb" ["汀州"])
("tyve" ["听着"])
("tyvf" ["听诊"])
("tyvh" ["庭长"])
("tyvi" ["停职" "停止" "停滞"])
("tyvj" ["停战"])
("tyvs" ["听众"])
("tyvu" ["停住"])
("tyvx" ["统一战线"])
("tyw'" "廷停亭庭莛葶婷蜓霆")
("tywf" ["天衣无缝"])
("tywz" ["廷尉"])
("tyx'" ["太阳系" "太阳穴" "同一性" "童养媳" "统一性" "唾液腺" "通用性"])
("tyxd" ["听想"])
("tyxi" ["听戏" "停息"])
("tyxm" ["停显"])
("tyxn" ["听信" "停薪"])
("tyxq" ["挺秀"])
("tyxw" ["停下"])
("tyxx" ["停歇"])
("tyy'" ["太医院"])
("tyyd" ["体育运动"])
("tyye" ["停业"])
("tyyr" ["庭园" "庭院"])
("tyzi" ["亭子"])
("tzd'" ["天祚帝"])
("tzi'" ["屠宰场"])
("tzq'" "忒")
("tzrh" ["天灾人祸"])
("u" "是")
("uaba" ["沙巴"])
("uabk" ["沙包"])
("uabu" ["砂布" "纱布" "煞不"])
("uadl" ["沙袋"])
("uady" ["纱锭"])
("uae'" "傻")
("uaee" ["沙俄"])
("uaer" ["沙尔"])
("uafa" ["沙发"])
("uago" ["沙锅"])
("uagw" ["傻瓜"])
("uahd" ["沙荒" "沙皇"])
("uahe" ["沙河"])
("uahl" ["杀害"])
("uaie" ["莎车" "刹车"])
("uaih" ["沙场" "纱厂"])
("uais" ["杀虫"])
("uajd" ["砂姜" "砂浆"])
("uajn" ["纱巾"])
("uajp" ["杀菌"])
("uakg" ["沙坑"])
("uala" ["沙拉"])
("uali" ["沙粒"])
("ualo" ["纱罗"])
("ualp" ["砂轮"])
("ualu" ["杀陆"])
("uamf" ["沙门"])
("uamo" ["沙漠"])
("uaq'" "莎砂杀刹沙纱煞杉挲铩痧裟鲨")
("uaqq" ["沙丘"])
("uaqy" ["杀青"])
("uar'" "沙啥煞厦唼嗄歃霎")
("uarf" ["杀人"])
("uasi" ["杀死"])
("uatb" ["杀头"])
("uath" ["砂糖"])
("uatj" ["沙滩"])
("uatm" ["沙田"])
("uatu" ["砂土" "沙土"])
("uaua" ["沙沙"])
("uauh" ["杀伤"])
("uaui" ["沙石" "沙市"])
("uavb" ["沙洲"])
("uavi" ["砂纸"])
("uavu" ["杀猪"])
("uawg" ["莎翁"])
("uaxm" ["纱线"])
("uaxy" ["砂型"])
("uaya" ["沙哑"])
("uayj" ["砂岩" "砂眼"])
("uayu" ["鲨鱼"])
("uazi" ["沙子" "傻子" "啥子"])
("ubbc" ["手表"])
("ubbi" ["手笔" "手臂"])
("ubbj" ["手板"])
("ubbm" ["收编" "手边"])
("ubby" ["手柄" "受病"])
("ubbz" ["手背" "守备"])
("ubce" ["手册"])
("ubch" ["收藏"])
("ubci" ["首次"])
("ubco" ["受挫"])
("ubd'" ["少不得" "舍不得" "说不定"])
("ubdk" ["收到" "受到"])
("ubdr" ["手段"])
("ubds" ["手动"])
("ubdu" ["首都"])
("ube'" "手首守艏")
("ubf'" ["商标法"])
("ubfa" ["收发" "手法" "守法" "受罚"])
("ubff" ["授粉" "受粉"])
("ubfh" ["收方"])
("ubfu" ["收复" "首府"])
("ubfz" ["收费"])
("ubg'" ["示波管"])
("ubgb" ["收购"])
("ubge" ["收割"])
("ubgj" ["手感"])
("ubgk" ["手稿"])
("ubgo" ["受过"])
("ubgs" ["收工" "手工"])
("ubh'" ["申不害" "叔本华"])
("ubhb" ["守候"])
("ubhj" ["受寒"])
("ubhl" ["受害"])
("ubho" ["收获" "售货"])
("ubhu" ["守护"])
("ubhv" ["收回" "受贿"])
("ubid" ["首创"])
("ubie" ["守车"])
("ubif" ["收尘"])
("ubig" ["收成"])
("ubih" ["收场" "首倡" "瘦长"])
("ubik" ["受潮"])
("ubjc" ["收缴" "手脚"])
("ubjd" ["授奖" "受奖"])
("ubji" ["收集"])
("ubjn" ["收紧" "手巾" "手紧" "受尽"])
("ubjp" ["守军"])
("ubjq" ["守旧"])
("ubjr" ["手卷" "手绢"])
("ubju" ["收据"])
("ubjw" ["售价"])
("ubjx" ["首届" "守节"])
("ubjy" ["授精" "受惊" "受精"])
("ubkb" ["收口"])
("ubke" ["授课"])
("ubkj" ["收看"])
("ubkk" ["手铐"])
("ubkr" ["收款"])
("ubku" ["受苦"])
("ubl'" ["少不了" "受不了" "水玻璃"])
("ubli" ["首例" "受理"])
("ubll" ["势不两立"])
("ublm" ["收敛"])
("ublo" ["收罗"])
("ublp" ["手轮"])
("ubls" ["收拢"])
("ublu" ["收录"])
("ublv" ["收率"])
("ublx" ["狩猎"])
("ubly" ["首领"])
("ublz" ["受累" "兽类"])
("ubmf" ["守门"])
("ubml" ["收买" "售卖"])
("ubmy" ["寿命" "受命"])
("ubnj" ["受难"])
("ubnk" ["首脑"])
("ubpa" ["手帕"])
("ubpc" ["售票"])
("ubpm" ["受骗"])
("ubq'" ["收" "示波器" "说不清"])
("ubqd" ["手枪"])
("ubqi" ["受气"])
("ubqq" ["手球"])
("ubqr" ["授权"])
("ubqu" ["收取"])
("ubqy" ["手轻"])
("ubr'" "寿授售受瘦兽狩绶")
("ubrb" ["瘦肉"])
("ubre" ["受热"])
("ubro" ["瘦弱"])
("ubrs" ["生不如死" "收容"])
("ubru" ["收入"])
("ubso" ["收缩"])
("ubtb" ["手头"])
("ubtc" ["收条"])
("ubti" ["手提"])
("ubtj" ["收摊"])
("ubtk" ["手套"])
("ubtl" ["受胎"])
("ubto" ["受托"])
("ubty" ["收听"])
("ubu'" ["时不时" "说不上"])
("ubuf" ["受审"])
("ubuh" ["受伤"])
("ubui" ["收拾" "手势" "首饰"])
("ubuu" ["手书" "手术" "数不胜数"])
("ubuv" ["收税"])
("ubv'" ["殊不知"])
("ubva" ["手札"])
("ubvb" ["寿州"])
("ubvf" ["收针"])
("ubvh" ["手掌" "手杖" "首长"])
("ubvi" ["收支" "手指" "受制"])
("ubvo" ["手镯"])
("ubvs" ["手中"])
("ubw'" "熟")
("ubwj" ["手腕"])
("ubwz" ["首尾" "首位" "守卫"])
("ubxc" ["收效" "瘦小"])
("ubxd" ["首相"])
("ubxi" ["首席"])
("ubxm" ["首先"])
("ubxn" ["手心"])
("ubxp" ["受训"])
("ubxu" ["手续"])
("ubxw" ["手下"])
("ubxx" ["手写"])
("ubxy" ["兽性"])
("uby'" ["伤病员"])
("ubyh" ["收养" "寿阳"])
("ubyi" ["收蚁" "收益" "手艺" "首义" "授意" "受益" "兽医"])
("ubyj" ["身不由己"])
("ubyk" ["首要"])
("ubyn" ["收音" "手印"])
("ubyp" ["受孕"])
("ubyr" ["受援"])
("ubyt" ["生搬硬套"])
("ubyu" ["授予"])
("ubze" ["守则"])
("ubzi" ["瘦子"])
("ubzl" ["受灾"])
("ubzu" ["手足"])
("ubzv" ["受罪"])
("uc'" ["上次"])
("uch'" ["水彩画"])
("ucjv" ["上层建筑" "生存竞争"])
("ud'" ["收到"])
("udbd" ["山东半岛"])
("udbk" ["双胞"])
("udbm" ["双边"])
("udcg" ["双层"])
("udda" ["双打"])
("udds" ["霜冻"])
("ude'" "爽")
("udf'" ["士大夫" "水电费"])
("udfg" ["双丰"])
("udfh" ["双方"])
("udgh" ["双杠"])
("udgr" ["双关" "双管"])
("udhc" ["傻大黑粗"])
("udhp" ["生动活泼"])
("udis" ["双重"])
("udj'" ["湿度计"])
("udjd" ["霜降"])
("udjm" ["双键"])
("udjx" ["声东击西"])
("udkb" ["爽口"])
("udky" ["爽快"])
("udl'" ["手倒立"])
("udlh" ["爽朗"])
("udlq" ["双流"])
("udly" ["十冬腊月"])
("udmm" ["双面"])
("udpn" ["双拼"])
("udq'" "霜双泷孀")
("udqi" ["霜期"])
("udql" ["手到擒来"])
("udqn" ["双亲"])
("uds'" ["湿地松"])
("udt'" ["手电筒"])
("udth" ["双糖"])
("udu'" ["山东省"])
("udub" ["双手"])
("udud" ["双双"])
("udug" ["双声" "双生"])
("uduu" ["双数"])
("udv'" ["水电站"])
("udws" ["史蒂文斯"])
("udxi" ["双喜"])
("udxj" ["顺丁橡胶"])
("udyg" ["圣地亚哥"])
("udz'" ["书呆子"])
("uebj" ["视而不见"])
("uebl" ["疏而不漏"])
("uebz" ["设备"])
("uedc" ["舍掉"])
("uede" ["舍得"])
("uedi" ["舍弟"])
("uedj" ["蛇胆"])
("uedm" ["摄电"])
("uedy" ["设定"])
("uee'" "舍")
("uef'" ["十二分"])
("uefa" ["设法"])
("uefh" ["设防"])
("uegf" ["舌根"])
("uegu" ["舌骨"])
("uehv" ["社会"])
("ueig" ["射程"])
("ueii" ["奢侈"])
("uejc" ["社交"])
("ueji" ["射击" "涉及" "社稷" "设计"])
("uejm" ["射箭"])
("uelc" ["射了"])
("ueli" ["设立"])
("uelp" ["社论"])
("uelq" ["射流"])
("uemf" ["射门"])
("uemm" ["赦免"])
("uepi" ["蛇皮"])
("ueq'" "奢赊猞畲")
("ueqi" ["舍弃"])
("ueqm" ["赊欠"])
("uequ" ["摄取"])
("uer'" "舍赦摄射慑涉社设厍滠歙麝")
("ueri" ["社日"])
("ueru" ["舍入"])
("uess" ["涉讼"])
("uetb" ["舌头"])
("uetl" ["舌苔"])
("uetr" ["社团"])
("ueub" ["射手"])
("ueuf" ["舍身"])
("ueui" ["摄食" "摄氏" "设施" "设使"])
("uevh" ["社长"])
("uevi" ["摄制" "设置" "十二指肠"])
("uew'" "蛇舌折佘")
("uewh" ["奢望"])
("uewl" ["涉外"])
("uexd" ["射向" "设想"])
("uexm" ["射线"])
("uey'" ["十二月"])
("ueyb" ["设有"])
("ueyh" ["射阳"])
("ueyj" ["设宴"])
("ueyr" ["社员"])
("ueyt" ["麝月"])
("ueyy" ["摄影" "射影"])
("uezl" ["设在"])
("uf'" ["是否"])
("ufao" ["深奥"])
("ufbk" ["申报"])
("ufbm" ["申辩" "身边"])
("ufbu" ["深部"])
("ufcg" ["深层"])
("ufcl" ["身材" "神采"])
("ufdk" ["神道" "慎到"])
("ufdr" ["身段"])
("ufdu" ["深度"])
("ufe'" "沈审婶谂哂渖矧")
("ufer" ["甚而"])
("ufff" ["身分" "身份"])
("uffj" ["深翻"])
("uffm" ["赏罚分明"])
("uffu" ["神甫"])
("ufgg" ["深耕"])
("ufgk" ["身高"])
("ufgu" ["深谷"])
("ufgy" ["神怪"])
("ufhb" ["身后" "深厚"])
("ufhe" ["审核"])
("ufhj" ["神汉"])
("ufhl" ["深海"])
("ufho" ["甚或"])
("ufhs" ["深红"])
("ufhu" ["神户"])
("ufhw" ["深化" "神化" "神话"])
("ufia" ["审查" "审察"])
("ufif" ["深沉"])
("ufih" ["伸长" "身长" "深长"])
("ufii" ["申斥"])
("ufiu" ["伸出" "深处" "渗出"])
("ufj'" ["扇风机"])
("ufjp" ["神君"])
("ufjw" ["身家" "身价"])
("ufjy" ["神经"])
("ufke" ["深刻"])
("ufkl" ["伸开"])
("ufko" ["沈括"])
("ufks" ["深恐"])
("ufl'" ["说服力" "水浮莲"])
("uflb" ["渗漏"])
("ufld" ["身量"])
("ufli" ["审理"])
("uflq" ["渗流"])
("uflv" ["深绿"])
("ufly" ["申令" "神灵"])
("ufme" ["甚么" "什么"])
("ufmi" ["神秘"])
("ufmy" ["申明" "神明"])
("ufmz" ["审美"])
("ufnv" ["神女"])
("ufpi" ["审批"])
("ufpj" ["审判"])
("ufq'" ["参" "砷" "申" "呻" "伸" "身" "深" "娠" "绅" "诜" "莘" "糁" "手风琴"])
("ufqi" ["神奇" "神气"])
("ufqm" ["深浅"])
("ufqq" ["深秋"])
("ufqr" ["神权"])
("ufqu" ["身躯"])
("ufqx" ["深切"])
("ufqy" ["申请" "深情" "神情"])
("ufr'" "甚肾慎渗葚椹胂蜃")
("ufru" ["深入" "渗入"])
("ufse" ["神色"])
("ufsi" ["深思"])
("ufso" ["伸缩"])
("ufsu" ["申诉"])
("ufsv" ["深邃"])
("uftb" ["渗透"])
("ufti" ["身体"])
("uftj" ["渗碳" "手扶拖拉机"])
("uftk" ["申讨"])
("uftl" ["神态"])
("ufts" ["神童"])
("ufu'" ["收发室"])
("ufub" ["伸手" "身手" "身受" "深受"])
("ufuf" ["深深" "审慎"])
("ufug" ["神圣"])
("ufuh" ["身上"])
("ufui" ["身世" "绅士" "审视"])
("ufuj" ["深山"])
("ufuu" ["申述"])
("ufuv" ["深水" "渗水"])
("ufvb" ["神州"])
("ufvf" ["深圳"])
("ufvh" ["伸张"])
("ufvi" ["伸直" "神志" "甚至"])
("ufvj" ["伸展"])
("ufvs" ["深重" "慎重"])
("ufw'" "神甚什")
("ufwf" ["审问"])
("ufwh" ["神往"])
("ufxd" ["神像"])
("ufxm" ["神仙"])
("ufxn" ["身心" "深信"])
("ufxp" ["审讯"])
("ufxt" ["神学"])
("ufxx" ["师范学校"])
("ufye" ["深夜"])
("ufyh" ["沈阳"])
("ufyi" ["深意" "神异" "审议"])
("ufyj" ["肾炎"])
("ufyn" ["呻吟"])
("ufyr" ["伸冤" "深渊" "深远"])
("ufyt" ["沈约" "审阅"])
("ufyy" ["身影"])
("ufzh" ["肾脏"])
("ufzi" ["身子" "婶子"])
("ufzk" ["深造"])
("ug'" ["是个"])
("uga'" ["施公案" "食管癌"])
("ugbl" ["胜败"])
("ugbm" ["生变"])
("ugbo" ["声波"])
("ugbu" ["声部"])
("ugby" ["生病"])
("ugci" ["剩磁"])
("ugcl" ["生财" "生菜"])
("ugcp" ["生存"])
("ugd'" ["上轨道"])
("ugda" ["盛大"])
("ugdc" ["声调"])
("ugde" ["省得"])
("ugdi" ["声地" "胜地" "圣地"])
("ugdj" ["圣诞"])
("ugdk" ["升到"])
("ugdl" ["声带"])
("ugdm" ["盛典"])
("ugds" ["生动"])
("uge'" "省眚")
("uger" ["生儿"])
("ugfa" ["生发"])
("ugff" ["生分" "省份"])
("ugfu" ["胜负"])
("uggf" ["生根"])
("uggk" ["升高"])
("uggr" ["升官"])
("uggs" ["升汞"])
("ughk" ["升号"])
("ugho" ["生活" "生火"])
("ughv" ["省会" "盛会"])
("ughw" ["生化" "升华"])
("ugig" ["声称" "生成" "省城"])
("ugii" ["生吃"])
("ugij" ["生产" "盛产"])
("ugiu" ["牲畜"])
("ugj'" ["收割机"])
("ugjd" ["生姜" "升降"])
("ugji" ["生机" "生计" "升级"])
("ugjq" ["生就"])
("ugjx" ["圣洁"])
("ugjy" ["盛京" "圣经"])
("ugkb" ["牲口"])
("ugkd" ["盛况"])
("ugkl" ["盛开"])
("uglh" ["声浪"])
("ugli" ["生理" "升力" "胜利"])
("ugll" ["生来"])
("uglt" ["省略"])
("uglu" ["生路"])
("ugly" ["生灵"])
("ugmn" ["生民"])
("ugmu" ["声母" "生母" "圣母"])
("ugmy" ["声明" "声名" "生命" "盛名" "圣明"])
("ugn'" ["属概念"])
("ugna" ["声纳"])
("ugpa" ["生怕"])
("ugpi" ["生坯"])
("ugpn" ["声频"])
("ugpy" ["生平" "升平"])
("ugq'" "声生甥牲升胜笙")
("ugqi" ["声气" "生漆" "生气"])
("ugqm" ["生前"])
("ugqu" ["声区" "省去"])
("ugqy" ["盛情"])
("ugr'" "乘盛剩胜圣嵊晟")
("ugrf" ["生人" "胜任" "圣人"])
("ugri" ["生日"])
("ugs'" ["少管所"])
("ugse" ["声色" "生色"])
("ugsi" ["生丝" "生死" "胜似"])
("ugso" ["绳索"])
("ugsu" ["声速"])
("ugtg" ["升腾"])
("ugtk" ["声讨"])
("ugtl" ["生态"])
("ugtm" ["升天"])
("ugtu" ["生土"])
("ugtx" ["生铁"])
("uguh" ["升上" "圣上"])
("ugui" ["声势" "生事" "省市" "盛世"])
("uguu" ["生疏"])
("uguv" ["生水" "升水"])
("ugvg" ["省政"])
("ugvh" ["声张" "生长" "省长" "胜仗"])
("ugvi" ["生殖" "圣旨"])
("ugvs" ["省中"])
("ugvu" ["生猪"])
("ugw'" "绳渑")
("ugwf" ["升温"])
("ugwh" ["声望"])
("ugwu" ["生物"])
("ugwz" ["声威" "省委"])
("ugx'" ["石膏像"])
("ugxc" ["生效"])
("ugxd" ["声响"])
("ugxi" ["声息" "生息"])
("ugxm" ["升限" "圣贤"])
("ugxq" ["生锈"])
("ugxt" ["声学" "升学"])
("ugxw" ["省下" "盛夏" "剩下"])
("ugxy" ["生性" "盛行"])
("ugy'" ["稍高于" "手工业"])
("ugya" ["生涯" "升压"])
("ugyb" ["生油"])
("ugyi" ["生疑" "生意"])
("ugyj" ["声言"])
("ugyn" ["声音"])
("ugyp" ["声韵"])
("ugyr" ["生员" "声援"])
("ugyt" ["声乐"])
("ugyu" ["声誉" "生于" "生育" "盛誉" "剩余" "胜于"])
("ugyv" ["手工业者"])
("ugyy" ["生硬"])
("ugzi" ["生字" "绳子"])
("ugzj" ["盛赞"])
("uh'" ["社会"])
("uhan" ["上岸"])
("uhb'" ["水灰比"])
("uhba" ["伤疤"])
("uhbc" ["商标"])
("uhbg" ["社会变革"])
("uhbi" ["上臂"])
("uhbj" ["上班"])
("uhbk" ["上报"])
("uhbm" ["上边" "上变"])
("uhbr" ["水火不相容"])
("uhbu" ["商埠" "上部"])
("uhbx" ["社会保险"])
("uhby" ["伤兵"])
("uhcg" ["上层"])
("uhci" ["赏赐" "上次"])
("uhcj" ["伤残"])
("uhck" ["上操"])
("uhcu" ["上簇"])
("uhcz" ["社会存在"])
("uhda" ["上达"])
("uhdc" ["上吊"])
("uhdg" ["上灯" "上等"])
("uhdh" ["上当" "上党"])
("uhdi" ["上第" "上帝"])
("uhdl" ["上代" "守恒定律"])
("uhdm" ["商店"])
("uhds" ["上冻"])
("uhdy" ["商定" "社会帝国主义"])
("uhe'" "赏晌上垧")
("uhf'" ["生活费"])
("uhfa" ["商法" "赏罚"])
("uhfg" ["伤风" "上风" "社会分工"])
("uhfh" ["上房" "上访"])
("uhfj" ["商贩"])
("uhfu" ["生活方式"])
("uhg'" ["山海关"])
("uhgd" ["上光" "社会公德"])
("uhgj" ["伤感"])
("uhgk" ["上告"])
("uhgo" ["上国"])
("uhgr" ["上关" "上官"])
("uhgs" ["上工" "上供"])
("uhgu" ["商贾" "上古"])
("uhgx" ["社会关系"])
("uhhd" ["社会活动"])
("uhhe" ["上颌"])
("uhhf" ["伤痕"])
("uhhh" ["上杭"])
("uhhj" ["伤寒"])
("uhhk" ["商号" "上好"])
("uhhl" ["伤害" "上海"])
("uhho" ["上火"])
("uhhv" ["商会"])
("uhid" ["上床"])
("uhig" ["上乘"])
("uhih" ["商场" "上场"])
("uhik" ["商朝"])
("uhir" ["商船"])
("uhj'" ["山海经"])
("uhjc" ["上交" "上缴"])
("uhjd" ["上将" "上浆"])
("uhji" ["上集" "上级" "上计" "社会基础"])
("uhjn" ["上金" "上紧" "上进"])
("uhjp" ["商君"])
("uhjx" ["商界" "上街" "上届"])
("uhkb" ["伤口" "上口"])
("uhke" ["上课"])
("uhkj" ["生活空间"])
("uhks" ["上空"])
("uhkx" ["社会科学"])
("uhky" ["社会科学院"])
("uhla" ["上蜡"])
("uhlb" ["上楼"])
("uhld" ["商量"])
("uhll" ["上来"])
("uhlm" ["上联"])
("uhln" ["上林"])
("uhlo" ["商洛"])
("uhlq" ["上流"])
("uhlu" ["商路" "上路"])
("uhlx" ["上列"])
("uhlz" ["水旱轮作"])
("uhma" ["上马"])
("uhmf" ["上门"])
("uhmi" ["商谜"])
("uhmm" ["上面"])
("uhmy" ["上明"])
("uhnm" ["上年"])
("uhns" ["上农"])
("uhpi" ["上皮"])
("uhpj" ["上盘"])
("uhpn" ["商品" "上品"])
("uhpu" ["上铺"])
("uhq'" ["墒" "伤" "商" "汤" "殇" "熵" "觞" "生活区"])
("uhqm" ["上前"])
("uhqq" ["商丘"])
("uhqt" ["商榷"])
("uhqu" ["上去"])
("uhqx" ["尚且"])
("uhqy" ["墒情" "上清"])
("uhr'" ["上" "尚" "绱" "石灰乳" "收货人"])
("uhrf" ["商人" "上人" "上任"])
("uhri" ["上日"])
("uhse" ["上色"])
("uhsi" ["上思" "上司"])
("uhsr" ["上算"])
("uhsu" ["上溯" "上诉"])
("uht'" "裳")
("uhtb" ["上头"])
("uhti" ["上体"])
("uhtj" ["商谈"])
("uhtk" ["商讨"])
("uhtl" ["上台"])
("uhtm" ["上天"])
("uhtr" ["商团"])
("uhts" ["伤痛"])
("uhu'" ["生活上" "生活史" "石灰石" "石灰水" "上海市"])
("uhub" ["上手" "上首"])
("uhuf" ["上身"])
("uhug" ["上声" "上升"])
("uhuh" ["上上" "社会生活"])
("uhui" ["伤势" "赏识" "上石" "上世" "上市"])
("uhuj" ["上山" "社会实践" "生活实践"])
("uhup" ["生活水平"])
("uhuu" ["商数" "上书" "上述" "尚书"])
("uhuv" ["上水"])
("uhv'" ["石灰质" "食货志"])
("uhvb" ["商州"])
("uhvd" ["上装" "社会制度"])
("uhvf" ["上真" "上阵"])
("uhvh" ["上章" "上涨"])
("uhvi" ["上肢"])
("uhvj" ["社会主义经济" "社会主义市场经济"])
("uhvm" ["社会主义革命"])
("uhvu" ["社会主义建设"])
("uhvy" ["社会主义"])
("uhvz" ["社会主义改造"])
("uhw'" ["水合物"])
("uhwf" ["上文"])
("uhwh" ["伤亡"])
("uhwj" ["上万"])
("uhwu" ["商务" "晌午" "上午" "尚无"])
("uhwz" ["上尉" "尚未"])
("uhx'" ["社会学" "深呼吸"])
("uhxc" ["上校"])
("uhxd" ["上相"])
("uhxm" ["上弦" "上限"])
("uhxn" ["伤心" "上心"])
("uhxp" ["上旬"])
("uhxt" ["上学" "社会形态"])
("uhxw" ["上下"])
("uhxy" ["上行"])
("uhy'" ["石灰岩" "石灰窑" "售货员"])
("uhyb" ["上油" "上游"])
("uhye" ["商业" "上夜"])
("uhyh" ["商鞅"])
("uhyi" ["商议" "上衣"])
("uhyj" ["上演"])
("uhyk" ["上药"])
("uhyr" ["伤员" "上原"])
("uhyt" ["商约" "社会意识形态"])
("uhyu" ["上谕" "社会意识"])
("uhyy" ["上映"])
("uhz'" ["石河子"])
("uhzb" ["社会资本"])
("uhzl" ["生活资料"])
("ui'" ["生产"])
("uian" ["是按"])
("uibi" ["势必"])
("uibj" ["尸斑" "石板" "试办"])
("uibk" ["时报"])
("uibl" ["失败"])
("uibm" ["事变"])
("uibq" ["输出变压器"])
("uibx" ["识别"])
("uiby" ["士兵"])
("uibz" ["十倍" "石碑"])
("uic'" ["生产操"])
("uice" ["史册"])
("uici" ["诗词" "誓词"])
("uico" ["失措"])
("uics" ["侍从"])
("uidc" ["失掉"])
("uidd" ["生产大队"])
("uide" ["使得" "是的"])
("uidh" ["深仇大恨" "失当" "适当"])
("uidi" ["师弟" "失地" "实地"])
("uidk" ["食道" "世道"])
("uidl" ["时代" "世代"])
("uidm" ["时点" "市电" "试点"])
("uido" ["拾掇"])
("uidr" ["事端"])
("uidu" ["湿度" "适度"])
("uidv" ["生产斗争" "是对"])
("uie'" "史矢使屎驶始豕")
("uiee" ["十恶"])
("uier" ["十二" "时而" "事儿"])
("uifb" ["是否"])
("uiff" ["十分" "时分" "市分" "输出方法"])
("uifh" ["施放" "时方" "释放"])
("uifj" ["师范" "示范"])
("uifu" ["生产方式" "师傅" "师父"])
("uifz" ["施肥" "是非" "试飞"])
("uigd" ["时光"])
("uige" ["诗歌" "十个" "是个"])
("uigf" ["实根"])
("uigj" ["生产工具" "实干" "双重国籍"])
("uigk" ["石膏"])
("uigo" ["使过"])
("uigr" ["食管" "史官" "史馆" "使馆" "士官" "试管"])
("uigs" ["施工"])
("uigu" ["生产过剩" "尸骨" "事故"])
("uigx" ["生产关系"])
("uihb" ["时候" "事后" "侍候"])
("uihe" ["适合"])
("uihh" ["试航"])
("uihk" ["嗜好"])
("uiho" ["失火" "食货"])
("uihr" ["使唤"])
("uihu" ["生产合作社" "石虎"])
("uihv" ["石灰" "时会" "实惠"])
("uihw" ["诗话" "实话"])
("uiia" ["时差" "视察"])
("uiib" ["世仇"])
("uiie" ["试车"])
("uiif" ["时辰" "使臣" "世臣"])
("uiig" ["十成"])
("uiih" ["失常" "时常" "市场" "视唱"])
("uiii" ["市尺"])
("uiir" ["失传"])
("uiis" ["石崇"])
("uiiu" ["使出"])
("uij'" ["杀虫剂"])
("uijc" ["市郊" "视角"])
("uijd" ["尸僵" "石匠" "是将"])
("uijg" ["市场价格"])
("uiji" ["诗集" "时机" "实际" "识记" "史籍" "史记" "世纪" "事机" "事迹" "市集" "试剂"])
("uijj" ["生产基金" "市场经济"])
("uijm" ["时间" "时见" "实践" "世间" "事件" "试件"])
("uijn" ["什锦" "使劲" "市斤"])
("uijp" ["使君"])
("uijq" ["十九"])
("uijr" ["式卷" "试卷"])
("uijt" ["视觉"])
("uiju" ["诗句" "时局"])
("uijw" ["施加" "世家" "市价"])
("uijx" ["时节" "使节" "世界" "视界"])
("uijy" ["省吃俭用" "失敬" "诗经" "石经"])
("uikb" ["适口"])
("uikd" ["实况"])
("uike" ["石刻" "时刻" "食客"])
("uikj" ["试看"])
("uiky" ["石块" "市侩"])
("uil'" ["生产力" "生产量" "生产率" "水处理"])
("uila" ["石蜡"])
("uilc" ["石料" "史料"])
("uild" ["食粮" "食量" "矢量" "适量"])
("uile" ["石勒"])
("uilh" ["施琅" "侍郎"])
("uili" ["生产流程" "失利" "实例" "实力" "示例" "事理" "事例" "势力" "市里" "市立" "视力"])
("uiln" ["士林"])
("uilo" ["失落"])
("uilp" ["史论"])
("uilq" ["石榴"])
("uilt" ["史略"])
("uily" ["失灵" "适龄"])
("uilz" ["石雷"])
("uima" ["是吗"])
("uimf" ["石门"])
("uimi" ["失密"])
("uimk" ["时髦"])
("uimm" ["失眠" "石棉" "市面"])
("uimn" ["士民" "市民"])
("uimo" ["石墨" "始末"])
("uimu" ["师母" "市亩"])
("uimy" ["失明" "使命"])
("uind" ["师娘"])
("uing" ["势能"])
("uinl" ["生产能力"])
("uinv" ["使女" "士女" "侍女"])
("uinz" ["市内" "室内"])
("uip'" ["奢侈品" "水产品"])
("uipm" ["诗篇"])
("uipn" ["食品" "视频"])
("uipo" ["识破"])
("uipu" ["食谱"])
("uiq'" "师失狮施湿诗尸虱嘘蓍酾鲺")
("uiqc" ["石桥"])
("uiqi" ["湿气" "石器" "时期" "时气" "使气" "士气"])
("uiqm" ["史前" "事前"])
("uiqr" ["实权" "事权"])
("uiqt" ["失却"])
("uiqu" ["失去" "市区"])
("uiqy" ["实情" "事情"])
("uir'" "是式示士世柿事拭誓逝势嗜噬适仕侍释饰氏市恃室视试似峙谥莳弑轼贳铈螫舐筮")
("uire" ["湿热"])
("uirf" ["诗人" "石人" "时人" "使人" "士人" "世人"])
("uiri" ["十日" "时日"])
("uiro" ["示弱"])
("uirp" ["湿润"])
("uirs" ["市容"])
("uiru" ["驶入"])
("uirv" ["石蕊"])
("uise" ["失色"])
("uisi" ["十四" "誓死"])
("uisj" ["失散" "十三"])
("uisu" ["失速" "时速" "世俗"])
("uit'" "匙殖")
("uitb" ["湿透" "石头" "势头"])
("uitc" ["失调"])
("uith" ["食堂" "食糖"])
("uiti" ["尸体" "实体" "事体" "试题"])
("uitj" ["石炭" "试探" "市场调节"])
("uitl" ["石台" "事态" "势态"])
("uitr" ["师团"])
("uitu" ["师徒" "使徒" "仕途" "视图" "试图"])
("uity" ["视听"])
("uiub" ["失手" "失守" "尸首"])
("uiue" ["施舍"])
("uiuf" ["尸身" "士绅"])
("uiug" ["师生" "失声" "市升"])
("uiuh" ["时尚" "世上" "市上"])
("uiui" ["失事" "失势" "诗史" "石室" "时时" "时食" "时事" "时势" "实施" "实时" "实实" "实事" "史诗" "史实" "世事" "事实" "事事" "誓师" "逝世" "适时"])
("uiuj" ["石山"])
("uiuo" ["师说"])
("uiuu" ["诗书" "实数" "史书"])
("uiuv" ["失水" "时水" "是谁"])
("uivd" ["时装"])
("uive" ["使者" "侍者"])
("uivf" ["失真" "湿疹" "时针" "市镇"])
("uivg" ["施政" "时政" "市政"])
("uivh" ["师长" "市长"])
("uivi" ["失职" "失值" "时值" "食指" "实质" "试纸" "试制"])
("uivj" ["施展" "实战"])
("uivs" ["失重" "时中" "时钟" "始终" "示众" "适中" "侍中" "试种"])
("uivu" ["石柱"])
("uiw'" ["十" "石" "拾" "时" "什" "食" "蚀" "实" "识" "埘" "莳" "炻" "鲥" "渗出物" "生成物"])
("uiwf" ["释文" "试问"])
("uiwh" ["失望"])
("uiwj" ["十万"])
("uiwl" ["室外"])
("uiwo" ["使我"])
("uiwu" ["失误" "十五" "时务" "食物" "实物" "事物" "事务"])
("uiwz" ["示威" "侍卫" "市委"])
("uix'" ["生产线"])
("uixc" ["失效" "时效" "实效" "试销"])
("uixd" ["实相" "使相" "事项" "试想"])
("uixi" ["实习" "世袭" "世系"])
("uixm" ["失陷" "时限" "实现" "实线" "事先" "视线"])
("uixn" ["失信" "实心"])
("uixq" ["失修"])
("uixs" ["师兄" "世兄"])
("uixt" ["失学" "诗学" "实学" "史学"])
("uixw" ["时下"])
("uixx" ["失血" "市场信息"])
("uixy" ["施行" "时兴" "时行" "食性" "实行" "试行"])
("uiyb" ["石油" "食油" "事由"])
("uiye" ["师爷" "失业" "实业" "事业" "视野"])
("uiyh" ["式样" "试样"])
("uiyi" ["诗意" "十一" "拾遗" "实益" "使役" "示意" "事宜" "适宜"])
("uiyj" ["食盐" "实验" "誓言" "试验"])
("uiyn" ["石印"])
("uiyp" ["时运"])
("uiyr" ["拾元"])
("uiys" ["施用" "食用" "实用" "使用" "适用" "试用"])
("uiyt" ["失约" "十月"])
("uiyu" ["食欲" "嗜欲" "适于"])
("uiyy" ["石英" "适应"])
("uizb" ["生产资本"])
("uize" ["实则"])
("uizi" ["师资" "狮子" "虱子" "十字" "石子" "识字" "式子" "柿子"])
("uizk" ["输出阻抗"])
("uizl" ["生产资料" "实在"])
("uizo" ["诗作"])
("uizs" ["失踪"])
("uizu" ["失足" "十足" "始祖" "士卒" "士族" "氏族"])
("uj'" ["时间"])
("ujb'" ["深井泵" "神经病" "世界报"])
("ujbf" ["善本"])
("ujbg" ["山崩"])
("ujbj" ["舢板"])
("ujbk" ["山包"])
("ujbm" ["拾金不昧"])
("ujbu" ["烧结焙烧"])
("ujbv" ["身经百战"])
("ujbz" ["陕北"])
("ujd'" ["双季稻" "双精度" "水浇地"])
("ujdi" ["山地"])
("ujdm" ["闪点" "闪电"])
("ujds" ["山东" "山洞" "煽动" "闪动"])
("ujdv" ["世界大战"])
("ujdy" ["山顶"])
("uje'" "掺掸闪陕")
("ujfg" ["山峰" "山风"])
("ujfh" ["山房"])
("ujg'" ["世界观" "输精管"])
("ujgb" ["山沟"])
("ujgd" ["闪光"])
("ujge" ["山歌"])
("ujgf" ["山根"])
("ujgl" ["删改"])
("ujgm" ["神经过敏"])
("ujgo" ["闪过"])
("ujgu" ["山谷"])
("ujgz" ["实际工资"])
("ujhb" ["善后" "世界货币"])
("ujhe" ["山河"])
("ujho" ["山货" "煽惑"])
("ujhs" ["山洪"])
("ujhu" ["珊瑚" "珊湖"])
("uji'" ["书记处"])
("ujia" ["山茶" "山查"])
("ujib" ["实际成本"])
("ujig" ["山城"])
("ujih" ["擅长"])
("ujil" ["数据处理"])
("ujir" ["山川"])
("ujiu" ["删除" "时间常数"])
("ujj'" ["杀菌剂" "神经节" "升降机"])
("ujjc" ["山脚"])
("ujjd" ["设计阶段"])
("ujji" ["闪击" "栅极"])
("ujjq" ["时间继电器"])
("ujjr" ["舍己救人"])
("ujk'" ["数据库"])
("ujkb" ["山口"])
("ujkl" ["闪开"])
("ujl'" ["实践论" "受精卵"])
("ujld" ["山梁" "善良" "势均力敌"])
("ujli" ["山里"])
("ujln" ["山林"])
("ujlr" ["山峦" "上缴利润"])
("ujlu" ["山麓" "山路"])
("ujlx" ["神经类型"])
("ujly" ["山岭"])
("ujm'" ["世纪末"])
("ujmf" ["山门"])
("ujml" ["山脉"])
("ujnj" ["山南"])
("ujpk" ["山炮"])
("ujpo" ["山坡"])
("ujq'" ["珊" "苫" "杉" "山" "删" "煽" "衫" "扇" "栅" "埏" "芟" "潸" "姗" "膻" "钐" "舢" "跚" "髟" "省军区"])
("ujqd" ["山墙" "杀鸡取蛋"])
("ujqk" ["实际情况"])
("ujqm" ["山前"])
("ujqr" ["山泉"])
("ujqt" ["实际气体"])
("ujqu" ["山区" "删去"])
("ujr'" ["单" "掸" "苫" "擅" "赡" "膳" "善" "汕" "扇" "缮" "剡" "讪" "鄯" "嬗" "骟" "禅" "钐" "疝" "蟮" "鳝" "收件人"])
("ujrf" ["山人"])
("ujs'" ["设计所"])
("ujt'" ["噬菌体"])
("ujtb" ["山头" "汕头"])
("uju'" ["实际上" "试金石"])
("ujui" ["膳食" "世界市场"])
("ujuj" ["闪闪"])
("ujuo" ["闪烁"])
("ujur" ["神经衰弱"])
("ujuv" ["山水"])
("ujv'" ["神经质" "十进制" "石家庄"])
("ujvd" ["山庄"])
("ujvf" ["山珍"])
("ujvj" ["善战"])
("ujvl" ["山寨"])
("ujvm" ["实践证明"])
("ujvu" ["神经中枢"])
("ujwa" ["山洼"])
("ujwh" ["世界文化"])
("ujwr" ["舍己为人"])
("ujwv" ["十进位制"])
("ujx'" ["时间性"])
("ujxb" ["神经细胞"])
("ujxd" ["山乡"])
("ujxi" ["山西" "山系" "陕西"])
("ujxn" ["善心"])
("ujxt" ["神经系统"])
("ujxw" ["神经纤维"])
("ujxy" ["扇形"])
("ujy'" ["神经原" "设计院"])
("ujya" ["山崖"])
("ujyh" ["山杨" "山羊" "山阳" "赡养"])
("ujyi" ["善意"])
("ujyk" ["山腰" "山药" "闪耀"])
("ujyl" ["施加压力"])
("ujyn" ["山阴"])
("ujyt" ["山岳"])
("ujyu" ["山芋" "善于" "盛极一时"])
("ujzi" ["擅自" "扇子"])
("ujzy" ["杀菌作用"])
("ukbh" ["哨棒"])
("ukby" ["烧饼" "哨兵"])
("ukbz" ["烧杯"])
("ukdl" ["捎带"])
("uke'" "少")
("ukev" ["适可而止"])
("ukfu" ["少妇"])
("ukgo" ["烧锅"])
("ukgr" ["韶关"])
("ukhb" ["稍后"])
("ukho" ["烧火"])
("ukhv" ["烧毁"])
("ukig" ["烧成"])
("ukjd" ["少将"])
("ukjm" ["烧碱" "少见"])
("ukjq" ["烧酒" "绍酒"])
("ukjx" ["烧结"])
("ukld" ["少量"])
("ukmk" ["烧毛"])
("uknm" ["少年"])
("uknv" ["少女"])
("ukpy" ["烧瓶"])
("ukq'" ["鞘" "梢" "捎" "稍" "烧" "蛸" "筲" "艄" "湿空气"])
("ukqy" ["少顷"])
("ukr'" "捎稍少哨邵绍召劭潲")
("ukso" ["哨所"])
("uktb" ["梢头"])
("ukuh" ["烧伤"])
("ukui" ["少时"])
("ukuj" ["韶山"])
("ukuk" ["稍稍"])
("ukuu" ["少数"])
("ukvd" ["少壮"])
("ukw'" "芍勺韶苕杓")
("ukwu" ["邵武"])
("ukwz" ["稍微" "稍为" "少尉"])
("ukxc" ["少校"])
("ukxd" ["烧香"])
("ukxn" ["捎信"])
("ukxu" ["稍许" "少许"])
("ukxy" ["绍兴"])
("ukye" ["少爷"])
("ukyh" ["邵阳"])
("ukyk" ["芍药"])
("ukyn" ["哨音"])
("ukyu" ["少于"])
("ukyy" ["水库养鱼"])
("ukzi" ["勺子" "哨子"])
("ul'" ["胜利"])
("ulb'" ["数来宝" "水轮泵"])
("ulbj" ["筛板"])
("uld'" ["手榴弹"])
("ule'" "色")
("ulfa" ["晒垡"])
("ulfd" ["水力发电"])
("ulff" ["筛分" "十六分音符"])
("ulfj" ["水轮发电机"])
("ulg'" ["输卵管"])
("ulgi" ["水利工程"])
("ulgj" ["晒干" "受力钢筋"])
("ulgu" ["胜利果实"])
("ulh'" ["山里红" "水利化" "数理化"])
("ulhh" ["生龙活虎"])
("ulhk" ["筛号"])
("ulj'" ["生力军" "数量级" "水轮机" "收录机"])
("uljv" ["十六进制"])
("ull'" ["湿漉漉"])
("ulm'" ["耍流氓"])
("ulp'" ["实力派"])
("ulq'" "筛酾")
("ulr'" "晒")
("ultu" ["晒图"])
("ulu'" ["鼠笼式"])
("ulv'" ["胜利者" "食利者"])
("ulvs" ["晒种"])
("ulwh" ["晒网"])
("ulx'" ["生理学"])
("ulxr" ["筛选"])
("ulyj" ["晒烟"])
("ulyu" ["生理盐水"])
("ulzi" ["筛子"])
("um'" ["说明"])
("umb'" ["石棉布" "霜霉病"])
("umd'" ["疏密度"])
("umhd" ["审美活动"])
("umj'" ["梳棉机"])
("umjl" ["手忙脚乱"])
("uml'" ["神灭论" "生命力"])
("umq'" ["省煤器" "水煤气"])
("ums'" ["史密斯"])
("umt'" ["施密特"])
("umu'" ["枢密使" "水磨石" "说明书"])
("umvy" ["神秘主义"])
("umx'" ["生命线"])
("umxx" ["生命现象"])
("umy'" ["什么样" "枢密院"])
("umyl" ["深谋远虑"])
("umz'" ["数目字"])
("ung'" ["少年宫" "输尿管"])
("uni'" ["水泥厂"])
("unj'" ["伤脑筋"])
("unn'" ["少奶奶"])
("unxd" ["少年先锋队"])
("uobu" ["说部"])
("uode" ["说的"])
("uodk" ["说道"])
("uody" ["说定"])
("uofa" ["说法"])
("uofu" ["说服"])
("uogo" ["说过" "蒴果"])
("uohd" ["说谎"])
("uohe" ["说和"])
("uohk" ["说好"])
("uohw" ["说话"])
("uoig" ["说成"])
("uoih" ["说唱"])
("uoir" ["说穿"])
("uojc" ["说教"])
("uoli" ["说理"])
("uoll" ["说来"])
("uomy" ["说明"])
("uopo" ["说破"])
("uoq'" "说")
("uoqi" ["说起"])
("uoqy" ["说情"])
("uor'" "数硕朔烁蒴搠妁槊铄")
("uoui" ["硕士"])
("uouo" ["说说"])
("uouu" ["说书"])
("uoxc" ["说笑"])
("up'" ["水平"])
("upbm" ["顺便"])
("upci" ["顺次"])
("upcs" ["顺从"])
("upde" ["顺德"])
("upe'" "吮")
("upfg" ["顺风"])
("upg'" ["审判官"])
("upgy" ["食品工业"])
("upi'" ["售票处"])
("upia" ["顺差"])
("upih" ["顺畅"])
("upij" ["顺产"])
("upjj" ["商品经济"])
("upjm" ["瞬间"])
("upkb" ["顺口"])
("upl'" ["商品粮"])
("uplf" ["商品流通费"])
("upli" ["顺利"])
("uplt" ["商品流通"])
("uplu" ["顺路"])
("uplv" ["商品流转"])
("upm'" ["水平面"])
("upq'" ["审判权"])
("upr'" "瞬顺舜")
("uptm" ["顺天"])
("upub" ["顺手"])
("upui" ["商品生产" "商品输出" "顺势"])
("upuv" ["顺水"])
("upv'" ["审判长"])
("upve" ["顺着"])
("upvi" ["顺治"])
("upx'" ["水平线"])
("upxi" ["吮吸" "瞬息"])
("upxn" ["顺心"])
("upxu" ["顺序"])
("upy'" ["审判员" "水平仪"])
("upyj" ["顺延" "顺眼"])
("upyy" ["顺应"])
("upzb" ["商品资本"])
("upzj" ["商品资金"])
("uq'" ["时期"])
("uqbb" ["生气勃勃"])
("uqg'" ["水青冈"])
("uqhy" ["诗情画意"])
("uql'" ["水曲柳"])
("uqlr" ["盛气凌人"])
("uqtt" ["杀气腾腾"])
("uqu'" ["神枪手" "抒情诗"])
("uquj" ["山穷水尽"])
("uqum" ["十全十美"])
("uqwd" ["湿球温度"])
("uqx'" ["双曲线"])
("uqyv" ["首屈一指"])
("urf'" ["杀人犯"])
("urff" ["输入方法"])
("urji" ["栓剂"])
("urpv" ["势如破竹"])
("urq'" "栓拴闩")
("urqi" ["深入浅出"])
("urr'" "涮")
("urrx" ["深入人心"])
("urse" ["栓塞"])
("uruv" ["石蕊试纸"])
("urvu" ["拴住"])
("ury'" ["水溶液"])
("urzb" ["商人资本"])
("urzk" ["输入阻抗"])
("uscw" ["生死存亡"])
("usd'" ["十三点"])
("usl'" ["十三陵"])
("usrg" ["视死如归"])
("usul" ["深思熟虑"])
("utab" ["沙特阿拉伯"])
("utbi" ["水土保持"])
("utd'" ["耍态度"])
("utf'" ["实体法"])
("uti'" ["手推车"])
("utj'" ["石炭纪" "石头记" "佘太君"])
("utl'" ["受胎率"])
("utlu" ["水土流失"])
("utlx" ["身体力行"])
("utm'" ["少他妈"])
("utph" ["生态平衡"])
("utx'" ["渗透性" "生态学"])
("uty'" ["渗透压"])
("uu'" ["事实"])
("uubf" ["书本"])
("uubk" ["书包" "书报"])
("uuby" ["莎士比亚"])
("uuci" ["数词"])
("uucl" ["蔬菜"])
("uucs" ["树丛"])
("uudh" ["誓师大会"])
("uudi" ["属地"])
("uudk" ["疏导"])
("uudm" ["输电" "书店"])
("uudu" ["熟读"])
("uudw" ["水生动物"])
("uue'" "薯暑曙署蜀黍鼠属数")
("uuee" ["数额"])
("uufa" ["抒发" "疏伐" "书法"])
("uufh" ["书房"])
("uufu" ["叔父" "舒服" "束缚"])
("uugd" ["曙光"])
("uugj" ["树干"])
("uugo" ["属国"])
("uugr" ["树冠"])
("uuh'" ["山水画" "生石灰"])
("uuhb" ["书后"])
("uuhd" ["声势浩大"])
("uuhj" ["蜀汉"])
("uuhr" ["水深火热"])
("uuhu" ["疏忽"])
("uuhw" ["书画" "熟化"])
("uuih" ["舒畅"])
("uuiu" ["输出"])
("uujc" ["树胶"])
("uuji" ["书籍" "书记"])
("uujm" ["书简"])
("uujp" ["疏浚"])
("uujq" ["数九"])
("uujr" ["书卷"])
("uuju" ["书局" "数据"])
("uujw" ["书架" "暑假"])
("uujy" ["书经" "竖井"])
("uuk'" ["试试看"])
("uukb" ["漱口"])
("uuke" ["术科"])
("uukj" ["书刊"])
("uukk" ["时时刻刻"])
("uuks" ["数控"])
("uul'" ["实生林"])
("uulb" ["疏漏"])
("uulc" ["熟料"])
("uuld" ["数量"])
("uuli" ["梳理" "树立" "竖立" "姗姗来迟"])
("uulm" ["熟练"])
("uuln" ["树林"])
("uulo" ["数落"])
("uulp" ["述论" "数论"])
("uulx" ["数列"])
("uulz" ["鼠类"])
("uuma" ["数码"])
("uumc" ["树苗"])
("uumi" ["疏密"])
("uuml" ["赎买"])
("uumm" ["书面"])
("uumn" ["庶民"])
("uumu" ["书目" "树木" "数目"])
("uumy" ["书名" "署名"])
("uumz" ["少数民族"])
("uunq" ["枢纽"])
("uupi" ["树皮"])
("uupy" ["述评"])
("uuq'" "蔬枢梳殊抒输叔舒淑疏书倏菽摅姝纾毹殳疋")
("uuqi" ["暑期" "竖起"])
("uuqn" ["竖琴"])
("uuqu" ["实事求是" "戍区"])
("uuqy" ["抒情"])
("uur'" ["术" "述" "树" "束" "戍" "竖" "墅" "庶" "数" "漱" "恕" "俞" "丨" "沭" "澍" "腧" "少数人"])
("uurf" ["熟人" "庶人"])
("uuru" ["输入"])
("uusi" ["殊死"])
("uusj" ["疏散"])
("uusk" ["叔嫂"])
("uuss" ["输送" "疏松"])
("uutb" ["梳头"])
("uutj" ["舒坦"])
("uuts" ["疏通"])
("uutv" ["顺水推舟"])
("uutx" ["熟铁"])
("uuu'" ["尚书省" "事实上"])
("uuug" ["书生"])
("uuui" ["舒适" "属实"])
("uuuk" ["树梢"])
("uuuo" ["述说"])
("uuuu" ["叔叔" "术数"])
("uuuv" ["疏水" "熟睡" "善始善终"])
("uuv'" ["瞬时值"])
("uuvb" ["枢轴" "数轴"])
("uuvd" ["梳妆"])
("uuvh" ["舒张"])
("uuvi" ["叔侄" "熟知" "树枝" "树脂" "数值"])
("uuvj" ["舒展"])
("uuvl" ["书斋"])
("uuvs" ["树种"])
("uuvw" ["水生植物"])
("uuw'" "赎孰熟塾秫")
("uuwc" ["束手无策"])
("uuwu" ["庶务"])
("uuwz" ["数位"])
("uux'" ["肾上腺"])
("uuxi" ["熟悉" "熟习"])
("uuxn" ["书信"])
("uuxs" ["肾上腺素"])
("uuxt" ["书学" "数学"])
("uuxx" ["上山下乡" "输血" "书写"])
("uuxy" ["属性"])
("uuye" ["输液" "树液"])
("uuyh" ["输氧"])
("uuyr" ["疏远" "书院" "树园"])
("uuyu" ["属于" "术语"])
("uuzi" ["梳子" "数字"])
("uuzv" ["恕罪"])
("uuzz" ["实实在在"])
("uv'" ["生长"])
("uvba" ["水坝"])
("uvbc" ["水表"])
("uvbg" ["水泵"])
("uvbj" ["十之八九"])
("uvbu" ["水部"])
("uvby" ["始终不渝" "水兵"])
("uvck" ["水草"])
("uvcl" ["水彩" "水准测量"])
("uvd'" ["生长点" "手制动"])
("uvdb" ["谁都"])
("uvdi" ["水滴" "水底"])
("uvdj" ["税单"])
("uvdk" ["水稻" "水道"])
("uvdl" ["睡袋"])
("uvdm" ["水电"])
("uve'" "水")
("uvee" ["税额"])
("uvff" ["水分"])
("uvfg" ["水封"])
("uvfz" ["水肥"])
("uvg'" ["双职工"])
("uvgb" ["水沟" "水垢"])
("uvge" ["谁个"])
("uvgj" ["谁敢"])
("uvgo" ["水果" "睡过"])
("uvgr" ["水管"])
("uvgs" ["水工"])
("uvhe" ["水合"])
("uvho" ["水火"])
("uvhr" ["水患"])
("uvhu" ["水壶"])
("uvhw" ["水花" "水化"])
("uvhy" ["生殖洄游"])
("uvie" ["水车"])
("uvii" ["水池" "水尺"])
("uvij" ["水产"])
("uvjc" ["睡觉"])
("uvjm" ["水碱"])
("uvjn" ["税金"])
("uvjp" ["水军"])
("uvjr" ["时至今日"])
("uvjx" ["水解"])
("uvjy" ["水晶" "水经" "水井"])
("uvkb" ["水口"])
("uvkg" ["水坑"])
("uvkr" ["税款"])
("uvku" ["水库"])
("uvl'" ["生长率" "睡着了"])
("uvld" ["水量"])
("uvlg" ["水冷"])
("uvli" ["水利" "水力"])
("uvlo" ["水落"])
("uvlq" ["水流"])
("uvlu" ["水路"])
("uvlv" ["税率"])
("uvlz" ["水雷"])
("uvmg" ["睡梦"])
("uvmi" ["水密"])
("uvmm" ["水面" "睡眠"])
("uvmo" ["水磨"])
("uvmu" ["水母"])
("uvn'" ["上中农"])
("uvng" ["谁能" "水能"])
("uvni" ["水泥"])
("uvnq" ["水牛"])
("uvpk" ["水泡"])
("uvpy" ["水平"])
("uvq'" ["生长期" "生殖器" "水蒸气" "水准器"])
("uvqi" ["水气" "水汽"])
("uvqu" ["水渠"])
("uvqy" ["水情"])
("uvr'" "睡税说")
("uvry" ["始终如一"])
("uvs'" ["生长素"])
("uvse" ["水色"])
("uvst" ["深圳四通"])
("uvt'" ["手指头"])
("uvta" ["水塔"])
("uvtb" ["水头"])
("uvth" ["水塘"])
("uvti" ["水体"])
("uvtm" ["水田"])
("uvts" ["水桶"])
("uvtu" ["水土"])
("uvu'" ["双折射"])
("uvub" ["水手" "税收"])
("uvuh" ["水上"])
("uvui" ["谁是" "水师"])
("uvuj" ["水杉"])
("uvuu" ["睡熟"])
("uvva" ["水闸"])
("uvvi" ["谁知" "水质" "税制"])
("uvvj" ["水战"])
("uvvp" ["水准"])
("uvvs" ["水中" "水肿"])
("uvw'" ["谁" "摄政王"])
("uvwf" ["水文"])
("uvwu" ["税务"])
("uvwz" ["水位"])
("uvx'" ["生殖腺" "市中心"])
("uvxb" ["生殖细胞"])
("uvxd" ["水箱" "水乡"])
("uvxi" ["水洗" "水系" "水螅"])
("uvxm" ["水仙" "水线"])
("uvxr" ["水选"])
("uvxw" ["水下"])
("uvxy" ["水星" "水性"])
("uvy'" ["甚至于" "水准仪"])
("uvya" ["水压"])
("uvye" ["谁也"])
("uvyh" ["水扬"])
("uvyj" ["水烟" "水淹"])
("uvyp" ["水运"])
("uvyt" ["水月"])
("uvyu" ["水域" "水浴"])
("uvze" ["税则"])
("uvzl" ["水灾"])
("uvzu" ["水族"])
("uw'" ["事务"])
("uwct" ["手无寸铁"])
("uwdz" ["实物地租"])
("uwe'" "耍")
("uwet" ["上沃尔特"])
("uwfv" ["生物防治"])
("uwhx" ["生物化学"])
("uwj'" ["生物界" "税务局"])
("uwll" ["耍赖"])
("uwm'" ["视网膜"])
("uwq'" "刷唰")
("uwql" ["史无前例"])
("uwr'" "刷")
("uws'" ["税务司"])
("uwvd" ["食物中毒"])
("uwvy" ["沙文主义"])
("uwx'" ["生物学"])
("uwxi" ["刷洗"])
("uwxj" ["生物学家"])
("uwxn" ["刷新"])
("uwy'" ["上万元"])
("uwya" ["刷牙"])
("uwyg" ["商务印书馆"])
("uwzd" ["手舞足蹈"])
("uwzi" ["刷子"])
("ux'" ["实现"])
("uxbt" ["水泄不通"])
("uxd'" ["少先队"])
("uxfx" ["数学分析"])
("uxh'" ["盛宣怀"])
("uxi'" ["食心虫"])
("uxjk" ["身心健康"])
("uxk'" ["闪锌矿"])
("uxmx" ["数学模型"])
("uxq'" ["实心球"])
("uxu'" ["山西省" "陕西省"])
("uxwb" ["顺息万变"])
("uxy'" ["史湘云"])
("uy'" ["使用"])
("uyb'" ["商业部" "输油泵"])
("uybl" ["衰败"])
("uybm" ["衰变"])
("uybu" ["率部"])
("uyd'" ["山药蛋"])
("uydk" ["摔倒"])
("uydw" ["事业单位"])
("uye'" "甩")
("uyg'" ["输油管"])
("uygm" ["十月革命"])
("uyhx" ["石油化学"])
("uyip" ["剩余产品"])
("uyix" ["实用程序"])
("uyj'" ["实业家" "实业界" "收音机" "述异记" "水压机"])
("uyjc" ["摔跤"])
("uyjl" ["剩余价值率"])
("uyjm" ["衰减"])
("uyju" ["煞有介事"])
("uyjv" ["剩余价值" "使用价值"])
("uyjx" ["衰竭"])
("uykl" ["甩开"])
("uyld" ["剩余劳动"])
("uylk" ["衰老"])
("uylo" ["衰落"])
("uylr" ["商业利润"])
("uyly" ["率领"])
("uyq'" ["摔" "衰" "石油气" "使用权"])
("uyr'" "率帅蟀")
("uyro" ["衰弱"])
("uyt'" ["示意图" "试验田"])
("uytv" ["衰退"])
("uyu'" ["沈阳市" "双氧水"])
("uyuv" ["石油输出国组织"])
("uyux" ["时隐时现"])
("uyuy" ["水压试验"])
("uyvy" ["实用主义"])
("uyw'" ["商业网" "十一万"])
("uywh" ["衰亡"])
("uywz" ["衰微"])
("uyx'" ["适应性" "实用性"])
("uyxm" ["帅先"])
("uyy'" ["上议院" "十一月"])
("uyyh" ["商业银行"])
("uyyu" ["摄影艺术"])
("uyyw" ["事与愿违"])
("uyzb" ["商业资本"])
("uz'" ["数字"])
("uzb'" ["识字班"])
("uzgl" ["视在功率"])
("uzj'" ["十字架"])
("uzlk" ["十字路口"])
("uzt'" ["十字头"])
("uztx" ["数字通信"])
("uzw'" "谁")
("uzyw" ["双子叶植物"])
("v" "着")
("vaba" ["眨巴"])
("vabj" ["闸板" "咋办"])
("vabz" ["闸北"])
("vack" ["铡草"])
("vacl" ["榨菜"])
("vade" ["乍得"])
("vadj" ["炸弹"])
("vadk" ["铡刀"])
("vae'" "眨砟")
("vafa" ["闸阀"])
("vagd" ["轧光"])
("vagf" ["扎根"])
("vagh" ["轧钢"])
("vagj" ["轧干"])
("vagp" ["轧辊"])
("vahv" ["炸毁"])
("vaji" ["札记" "轧机"])
("vajm" ["轧件"])
("valj" ["栅栏"])
("vamf" ["闸门"])
("vapm" ["诈骗"])
("vaq'" "查扎喳渣咋揸吒哳楂齄")
("vaqu" ["榨取"])
("var'" "蜡栅榨咋乍炸诈柞吒咤痄蚱")
("varu" ["扎入"])
("vaui" ["扎实"])
("vavi" ["轧制"])
("vaw'" ["扎" "札" "轧" "铡" "闸" "炸" "喋" "障碍物"])
("vawa" ["闸瓦"])
("vayb" ["渣油" "榨油"])
("vayj" ["眨眼"])
("vayk" ["炸药"])
("vazi" ["渣滓" "渣子"])
("vb'" ["准备"])
("vbbk" ["周报"])
("vbbm" ["周边" "骤变"])
("vbbo" ["周波" "周勃"])
("vbdk" ["周到" "周道"])
("vbe'" "肘帚")
("vbfz" ["宙飞"])
("vbgr" ["宙观"])
("vbgs" ["周公"])
("vbh'" ["准备好"])
("vbhd" ["准备活动"])
("vbhf" ["皱痕"])
("vbif" ["轴衬"])
("vbig" ["轴承"])
("vbih" ["周长" "粥厂"])
("vbjc" ["周角"])
("vbji" ["洲际"])
("vbjr" ["治病救人"])
("vbju" ["轴距"])
("vbjw" ["周家"])
("vbkj" ["周刊"])
("vbks" ["轴孔"])
("vbl'" ["张伯伦" "正比例"])
("vblv" ["周率"])
("vbma" ["咒骂"])
("vbmi" ["周密"])
("vbmo" ["周末"])
("vbmz" ["皱眉"])
("vbnm" ["周年"])
("vbq'" ["舟" "周" "州" "洲" "诌" "粥" "啁" "掷标枪"])
("vbqi" ["周期"])
("vbqr" ["周全"])
("vbr'" "轴咒皱宙昼骤荮纣绉胄籀繇酎")
("vbrj" ["骤然"])
("vbsv" ["周岁"])
("vbtk" ["轴套"])
("vbtm" ["周天"])
("vbtx" ["指标体系"])
("vbua" ["绉纱"])
("vbuf" ["周身"])
("vbuj" ["舟山"])
("vbuu" ["周书"])
("vbv'" ["征兵制"])
("vbve" ["周折" "皱褶"])
("vbvh" ["州长"])
("vbvi" ["周知" "周至"])
("vbvr" ["周转"])
("vbw'" "轴妯碡")
("vbwa" ["轴瓦"])
("vbwf" ["周文" "皱纹"])
("vbwz" ["周围"])
("vbxd" ["周相" "轴箱"])
("vbxm" ["轴线"])
("vbxn" ["轴心"])
("vbxr" ["周旋"])
("vbyb" ["周游"])
("vbye" ["昼夜"])
("vbyi" ["周易"])
("vbyu" ["周瑜"])
("vbzi" ["肘子"])
("vc'" ["至此"])
("vcmz" ["针刺麻醉"])
("vcux" ["真才实学"])
("vcy'" ["中草药"])
("vd'" ["直到"])
("vdb'" ["詹大悲" "脂蛋白" "中短波"])
("vdbj" ["装扮"])
("vdbx" ["正多边形"])
("vdbz" ["装备"])
("vdda" ["壮大"])
("vddj" ["壮胆"])
("vddk" ["撞倒"])
("vddm" ["装点"])
("vddy" ["装订" "壮丁"])
("vde'" "奘")
("vdf'" ["制动阀"])
("vdg'" ["制动缸"])
("vdgl" ["转动惯量"])
("vdgr" ["壮观"])
("vdh'" ["招待会" "正电荷" "重氮化"])
("vdhd" ["装璜"])
("vdhu" ["庄户"])
("vdi'" ["轴对称"])
("vdie" ["撞车"])
("vdj'" ["战斗机"])
("vdji" ["撞击"])
("vdjm" ["壮健"])
("vdjn" ["壮锦"])
("vdjt" ["斩钉截铁"])
("vdjw" ["庄稼" "装甲"])
("vdjy" ["中等教育"])
("vdkd" ["状况"])
("vdl'" ["战斗力"])
("vdlc" ["装料"])
("vdli" ["庄里" "壮丽"])
("vdlx" ["壮烈"])
("vdmc" ["壮苗"])
("vdmj" ["装满"])
("vdmt" ["正多面体"])
("vdmz" ["壮美"])
("vdnm" ["壮年"])
("vdpz" ["装配"])
("vdq'" ["桩" "庄" "装" "妆" "振荡器" "制动器" "主动权"])
("vdr'" "幢撞壮状僮戆")
("vdru" ["装入"])
("vds'" ["招待所"])
("vdsx" ["指导思想"])
("vdtl" ["状态"])
("vdtm" ["庄田"])
("vdu'" ["振动筛"])
("vdua" ["装傻"])
("vdub" ["终端设备"])
("vdui" ["装饰" "壮士"])
("vduu" ["装束"])
("vdv'" ["争夺战" "主动轴"])
("vdvb" ["庄周"])
("vdvi" ["装置" "壮志"])
("vdvs" ["庄重"])
("vdx'" ["主动性"])
("vdxd" ["装箱"])
("vdxq" ["装修"])
("vdxx" ["装卸"])
("vdy'" ["战斗员" "指导员"])
("vdyb" ["装有"])
("vdyh" ["装样"])
("vdyj" ["庄严"])
("vdyp" ["装运"])
("vdyr" ["庄员" "庄园" "状元"])
("vdyu" ["状语"])
("vdyx" ["战斗英雄"])
("vdz'" ["正电子"])
("vdzi" ["庄子" "状子"])
("vdzl" ["装载"])
("vdzu" ["壮族"])
("vebi" ["遮蔽"])
("vebj" ["折半" "这般"])
("vebm" ["这边"])
("vebu" ["这步"])
("vech" ["遮藏"])
("veci" ["这次"])
("ved'" ["朱尔典"])
("vedh" ["遮挡"])
("vedm" ["这点"])
("vedr" ["遮断"])
("veds" ["浙东"])
("vedx" ["折叠"])
("vee'" "者锗褶赭")
("veer" ["这儿"])
("veff" ["这份"])
("vefu" ["折服" "蛰伏" "周而复始"])
("vegd" ["遮光" "折光"])
("vege" ["这个"])
("vegl" ["遮盖"])
("vehe" ["折合"])
("vehl" ["这还"])
("vehv" ["折回"])
("veih" ["这场"])
("vejc" ["折角" "这叫"])
("vejd" ["浙江"])
("vejq" ["折旧" "这就"])
("vejw" ["折价"])
("vekb" ["折扣"])
("vel'" ["周恩来"])
("veli" ["哲理" "这里"])
("velz" ["这类"])
("veme" ["这么"])
("vemo" ["折磨"])
("veq'" "遮折蜇")
("ver'" "蔗这浙柘鹧")
("vesr" ["折算"])
("vet'" "着")
("vetc" ["这条"])
("vetg" ["折腾"])
("veth" ["蔗糖" "蔗醣"])
("veue" ["折射"])
("veui" ["这时" "这是"])
("vevb" ["褶皱"])
("vevi" ["这支"])
("vevs" ["折中" "折衷" "这种"])
("vevu" ["遮住"])
("vew'" "折哲蛰辙谪摺辄磔蜇")
("vewz" ["这位"])
("vexd" ["这厢" "这项"])
("vexi" ["浙西"])
("vexm" ["折线"])
("vexq" ["遮羞"])
("vext" ["哲学"])
("vexx" ["这些"])
("veyh" ["这样"])
("veyi" ["这一"])
("veyj" ["遮掩"])
("veyn" ["遮荫"])
("vezo" ["这座"])
("vf'" ["政府"])
("vfbj" ["砧板"])
("vfbk" ["珍宝"])
("vfbo" ["震波"])
("vfbu" ["真不" "针布"])
("vfbx" ["甄别"])
("vfby" ["疹病"])
("vfch" ["珍藏"])
("vfci" ["针刺"])
("vfck" ["贞操"])
("vfde" ["真得" "真的" "振德"])
("vfdh" ["震荡" "振荡"])
("vfdi" ["真谛" "阵地"])
("vfdm" ["争分夺秒"])
("vfdr" ["诊断"])
("vfds" ["震动" "振动"])
("vfdv" ["针对"])
("vfdy" ["镇定"])
("vfe'" "枕疹诊缜轸畛稹")
("vffa" ["针法"])
("vfff" ["振奋"])
("vffg" ["阵风"])
("vffj" ["镇反"])
("vffu" ["振幅"])
("vfge" ["真个"])
("vfgr" ["贞观"])
("vfgu" ["枕骨"])
("vfgv" ["珍贵"])
("vfhj" ["震撼"])
("vfhl" ["镇海"])
("vfhw" ["真话"])
("vfia" ["侦查" "侦察"])
("vfig" ["真诚"])
("vfjd" ["镇江"])
("vfji" ["真迹" "侦缉" "赈济"])
("vfjm" ["针尖"])
("vfjp" ["真菌"])
("vfjq" ["针灸"])
("vfjw" ["真假"])
("vfjx" ["贞节"])
("vfjy" ["震惊" "镇静"])
("vfke" ["真可"])
("vfks" ["真空"])
("vfl'" ["蒸发量"])
("vflc" ["诊疗"])
("vfli" ["真理"])
("vflx" ["震裂"])
("vfm'" ["蒸发皿"])
("vfmu" ["砧木" "枕木"])
("vfpn" ["珍品"])
("vfq'" ["珍" "斟" "真" "甄" "砧" "臻" "贞" "针" "侦" "蓁" "浈" "溱" "桢" "椹" "榛" "胗" "祯" "箴" "蒸发器"])
("vfqi" ["珍奇"])
("vfqt" ["真确"])
("vfqx" ["真切"])
("vfqy" ["真情"])
("vfr'" "震振镇阵圳赈朕鸩")
("vfrf" ["真人"])
("vfrs" ["阵容"])
("vfru" ["真如"])
("vfs'" ["脂肪酸"])
("vfso" ["诊所"])
("vft'" ["正方体"])
("vftb" ["针头" "枕头"])
("vftj" ["侦探"])
("vfts" ["镇痛" "阵痛"])
("vfub" ["镇守"])
("vfui" ["珍视" "真实" "真是" "阵势"])
("vfvf" ["真真"])
("vfvg" ["真正"])
("vfvh" ["镇长"])
("vfvi" ["真知" "真挚" "针织" "诊治"])
("vfvo" ["斟酌"])
("vfvs" ["珍重" "震中"])
("vfvu" ["珍珠" "真主"])
("vfvv" ["中法战争"])
("vfwh" ["阵亡"])
("vfx'" ["正方形"])
("vfxd" ["真相" "真想" "真象" "针锋相对" "震相"])
("vfxi" ["珍惜"])
("vfxm" ["针线" "阵线"])
("vfxn" ["真心"])
("vfxy" ["振兴"])
("vfya" ["镇压"])
("vfyb" ["真有"])
("vfyr" ["震源"])
("vfyu" ["阵雨"])
("vfyy" ["阵营"])
("vfzi" ["枕资" "镇子"])
("vfzo" ["振作"])
("vg'" ["中国"])
("vgba" ["争霸"])
("vgbi" ["正比"])
("vgbm" ["争辩" "整编" "政变"])
("vgby" ["征兵"])
("vgc'" ["战国策" "中关村"])
("vgce" ["政策"])
("vgci" ["证词"])
("vgda" ["正大"])
("vgdb" ["争斗"])
("vgdc" ["征调"])
("vgde" ["正德"])
("vgdh" ["整党" "正当" "政党"])
("vgdi" ["整地" "政敌"])
("vgdl" ["正待"])
("vgdm" ["正点" "正电"])
("vgdo" ["争夺"])
("vgdp" ["整顿"])
("vgdr" ["争端"])
("vgdv" ["整队"])
("vgdy" ["征订" "正定"])
("vge'" ["整" "拯" "准噶尔"])
("vgfa" ["蒸发" "征发" "征伐" "正法" "政法"])
("vgfg" ["整风"])
("vgfh" ["正方"])
("vgfj" ["正反"])
("vgfu" ["征服" "正负" "政府"])
("vggb" ["征购"])
("vggd" ["争光" "正光" "中国共产党" "中国国民党"])
("vgge" ["整个" "正割"])
("vggh" ["政纲"])
("vggl" ["整改"])
("vggo" ["郑国"])
("vggr" ["中国工人"])
("vggs" ["政工"])
("vggv" ["正规" "正轨" "政规"])
("vgh'" ["中国画"])
("vghb" ["症候"])
("vghe" ["政和" "郑和"])
("vghk" ["正好" "正号"])
("vgho" ["正火"])
("vgih" ["正常"])
("vgii" ["争持"])
("vgik" ["争吵"])
("vgiu" ["整除"])
("vgj'" ["轧钢机" "正规军"])
("vgjc" ["正交"])
("vgji" ["征集" "正极"])
("vgjm" ["政见" "证件"])
("vgjq" ["拯救"])
("vgju" ["政局" "证据"])
("vgjx" ["整洁" "政界" "症结"])
("vgjy" ["正经" "郑经"])
("vgke" ["政客"])
("vgkl" ["睁开"])
("vgky" ["中国科学院"])
("vgl'" ["轴功率" "诸葛亮"])
("vgli" ["整理"])
("vglp" ["争论"])
("vglq" ["蒸馏" "整流"])
("vgls" ["蒸笼"])
("vglu" ["正路"])
("vgly" ["政令"])
("vgm'" ["抓革命"])
("vgmf" ["正门"])
("vgmm" ["正面"])
("vgmy" ["争鸣" "正名" "证明"])
("vgn'" ["种概念"])
("vgni" ["蒸呢"])
("vgnj" ["正南"])
("vgnx" ["主观能动性"])
("vgny" ["狰狞"])
("vgpl" ["正派"])
("vgpm" ["正片"])
("vgpn" ["帧频"])
("vgq'" "丁蒸挣睁征狰争怔正症峥徵钲铮筝鲭")
("vgqc" ["正巧"])
("vgqi" ["蒸气" "蒸汽" "争气" "整齐" "正气"])
("vgqm" ["挣钱"])
("vgqq" ["征求"])
("vgqr" ["政权" "证券"])
("vgqt" ["正确"])
("vgqu" ["争取" "政区"])
("vgqx" ["正切"])
("vgr'" "挣怔正政帧症郑证诤铮")
("vgrf" ["证人"])
("vgrm" ["中国人民"])
("vgru" ["正如"])
("vgse" ["正色"])
("vgt'" ["直观图" "珠光体"])
("vgtg" ["蒸腾"])
("vgti" ["整体" "政体"])
("vgtk" ["整套"])
("vgtm" ["整天"])
("vgto" ["挣脱"])
("vgts" ["正统"])
("vgtu" ["征途"])
("vgty" ["正厅"])
("vgub" ["征收"])
("vgud" ["战国时代"])
("vgui" ["整式" "正时" "正始" "正式" "正事" "正是" "正视" "政事" "证实"])
("vguu" ["整数" "正数" "证书"])
("vguv" ["征税"])
("vgva" ["挣扎"])
("vgvb" ["郑州"])
("vgvd" ["症状"])
("vgvg" ["怔怔" "整整" "抓纲治国"])
("vgvi" ["争执" "整枝" "整治" "正直" "正治" "政治"])
("vgvj" ["征战"])
("vgvk" ["征兆"])
("vgvs" ["正中" "郑重"])
("vgvy" ["中共中央" "主观主义"])
("vgwf" ["正文"])
("vgwu" ["正午" "政务" "证物" "至高无上"])
("vgwx" ["中国文学"])
("vgwz" ["政委"])
("vgxd" ["征象" "正像"])
("vgxm" ["争先" "正弦"])
("vgxp" ["征询"])
("vgxq" ["整修"])
("vgxx" ["政协"])
("vgxy" ["整形"])
("vgy'" ["郑观应" "重工业"])
("vgyh" ["中国银行"])
("vgyi" ["争议" "正义"])
("vgyj" ["睁眼" "争艳" "正盐"])
("vgyk" ["正要"])
("vgys" ["征用"])
("vgyt" ["正月"])
("vgzi" ["正字"])
("vgzl" ["正在"])
("vh'" ["只会"])
("vhai" ["障碍"])
("vhb'" ["指挥部"])
("vhbf" ["帐本"])
("vhbu" ["帐簿"])
("vhbz" ["长辈"])
("vhce" ["帐册"])
("vhd'" ["着火点"])
("vhda" ["长大" "张大"])
("vhde" ["彰德"])
("vhdj" ["帐单"])
("vhdo" ["掌舵"])
("vhe'" ["长" "掌" "涨" "仉" "这会儿"])
("vhfa" ["章法"])
("vhfh" ["帐房"])
("vhfu" ["丈夫"])
("vhgr" ["长官" "掌管"])
("vhgu" ["掌故"])
("vhgv" ["掌柜"])
("vhhe" ["章和" "漳河"])
("vhhg" ["张衡"])
("vhhj" ["章邯"])
("vhhk" ["帐号" "账号"])
("vhhu" ["帐户"])
("vhig" ["章程"])
("vhik" ["涨潮"])
("vhjc" ["张角"])
("vhjn" ["长进"])
("vhju" ["章句"])
("vhjw" ["涨价"])
("vhjx" ["章节"])
("vhkb" ["张口"])
("vhkg" ["转换开关"])
("vhkl" ["张开"])
("vhkr" ["帐款"])
("vhl'" ["质和量"])
("vhld" ["丈量"])
("vhli" ["张力"])
("vhlk" ["长老"])
("vhlo" ["张罗" "涨落"])
("vhmu" ["张目" "帐目"])
("vhmz" ["中华民族"])
("vhnk" ["樟脑"])
("vhpg" ["帐棚" "帐篷" "账篷"])
("vhq'" "樟章彰漳张鄣獐嫜璋蟑")
("vhqi" ["瘴气"])
("vhqm" ["张骞"])
("vhqr" ["掌权"])
("vhr'" "涨杖丈帐账仗胀瘴障幛嶂")
("vhrf" ["丈人"])
("vhsp" ["长孙"])
("vht'" ["章回体"])
("vhtx" ["张贴"])
("vhug" ["掌声"])
("vhuh" ["长上"])
("vhui" ["长势"])
("vhuj" ["中华书局"])
("vhuu" ["樟树"])
("vhuv" ["涨水"])
("vhvb" ["漳州"])
("vhve" ["长者" "长着"])
("vhwh" ["张网" "张望"])
("vhwo" ["掌握"])
("vhxd" ["长相"])
("vhxn" ["掌心"])
("vhxp" ["张勋"])
("vhxu" ["章回小说"])
("vhy'" ["指挥员"])
("vhyi" ["仗义"])
("vhzi" ["长子" "帐子"])
("vhzv" ["张嘴"])
("vi'" ["指出"])
("viai" ["致癌"])
("vian" ["治安"])
("vibc" ["指标" "制表"])
("vibf" ["直奔"])
("vibi" ["执笔" "纸币"])
("vibj" ["值班" "置办" "制版"])
("vibk" ["植保"])
("vibm" ["质变"])
("vibo" ["直播"])
("vibu" ["支部" "织布" "止步"])
("viby" ["致病" "治病"])
("vibz" ["植被" "制备"])
("vicg" ["只曾"])
("vici" ["值此" "只此" "至此" "致词"])
("vicl" ["制裁"])
("vida" ["直达" "至大"])
("vide" ["似的" "值得" "只得"])
("vidh" ["只当"])
("vidi" ["质的" "质地"])
("vidk" ["知道" "直捣" "直到" "直道" "指导" "至道"])
("vidl" ["纸带"])
("vidm" ["支点" "指点" "致电" "质点"])
("vido" ["至多"])
("vids" ["制动"])
("vidu" ["制度"])
("vidv" ["支队"])
("vidy" ["指定" "制定" "制订"])
("vie'" "址指止趾只旨纸芷徵咫枳轵祉黹酯")
("vier" ["侄儿"])
("vifa" ["知法" "执法" "指法"])
("viff" ["脂粉"])
("vifh" ["知方" "脂肪"])
("vifu" ["支付" "知府" "致富" "制服"])
("vig'" ["郑成功"])
("vige" ["制革"])
("vigj" ["枝干" "支杆" "之感" "质感"])
("vigo" ["治国"])
("vigr" ["职官" "直观" "只管"])
("vigs" ["支工" "织工" "职工"])
("vigu" ["只顾"])
("vihb" ["之后"])
("vihj" ["致函" "轴承合金"])
("vihk" ["只好"])
("vihr" ["置换"])
("vihu" ["支护"])
("vihv" ["指挥" "只会" "智慧"])
("vihw" ["酯化"])
("viid" ["痔疮"])
("viig" ["支撑" "织成" "职称" "制成" "质成"])
("viih" ["直肠"])
("viii" ["支持" "直尺" "指斥" "至迟"])
("viiu" ["支出" "之处" "指出"])
("vij'" ["侦察机"])
("vijc" ["直角" "指教"])
("vijd" ["纸浆"])
("viji" ["知己" "之极" "织机" "制剂"])
("vijm" ["之间" "制件"])
("vijn" ["至今"])
("vijt" ["知觉" "直觉"])
("vijw" ["支架" "指甲" "治家"])
("vijx" ["枝节" "肢解" "直接"])
("vijy" ["直径" "止境" "致敬"])
("vike" ["只可"])
("vikj" ["只看"])
("viks" ["指控"])
("vil'" ["转差率"])
("vilc" ["质料" "治疗"])
("vild" ["质量"])
("vilg" ["致冷" "制冷"])
("vili" ["支离" "直隶" "致力" "智利" "智力" "治理"])
("vilq" ["支流" "直流" "滞留"])
("vily" ["指令"])
("vilz" ["之类"])
("vima" ["芝麻"])
("vimb" ["智谋"])
("vimc" ["植苗"])
("vimi" ["致密"])
("vimm" ["纸面" "制面"])
("vimn" ["殖民"])
("vimy" ["知名" "指明" "指名" "致命"])
("ving" ["职能" "只能" "智能"])
("vinh" ["智囊"])
("vinj" ["指南"])
("vins" ["支农" "志农"])
("vinv" ["侄女"])
("vinz" ["之内"])
("vip'" ["制成品"])
("vipa" ["只怕"])
("vipc" ["支票"])
("vipl" ["指派"])
("vipm" ["纸片"])
("vipn" ["制品"])
("vipu" ["质朴"])
("vipy" ["治平"])
("vipz" ["支配"])
("viq'" "知只之芝枝支吱蜘肢脂汁织氏掷卮栀胝祗")
("viqi" ["志气" "稚气"])
("viqm" ["之前" "值钱" "制钱"])
("viqn" ["执勤" "值勤"])
("viqq" ["只求"])
("viqr" ["职权"])
("viqu" ["支渠" "志趣" "智取"])
("viqy" ["知青" "知情"])
("vir'" ["识" "知" "志" "挚" "掷" "至" "致" "置" "帜" "峙" "制" "智" "秩" "稚" "质" "炙" "痔" "滞" "治" "窒" "陟" "郅" "帙" "忮" "彘" "骘" "栉" "桎" "轾" "贽" "膣" "雉" "鸷" "痣" "蛭" "踬" "豸" "觯" "主持人"])
("virf" ["至人"])
("viri" ["值日" "指日" "至日"])
("vish" ["治丧"])
("visi" ["致死"])
("viso" ["治所"])
("vitb" ["枝头" "指头" "趾头" "纸头"])
("vitc" ["枝条"])
("vith" ["制糖" "制醣"])
("viti" ["肢体" "质体"])
("vits" ["止痛"])
("vitu" ["制图"])
("viub" ["职守"])
("viud" ["直爽"])
("viuf" ["只身" "置身"])
("viuh" ["之上" "至上"])
("viui" ["支使" "知识" "知事" "之时" "直视" "执事" "指使" "指示" "指事" "只是" "志士" "致使"])
("viuj" ["治山"])
("viuk" ["至少"])
("viuu" ["支书" "支数" "直属" "植树" "指数" "质数"])
("viuv" ["治水"])
("viuy" ["直率"])
("vivb" ["织轴"])
("vive" ["指着" "智者"])
("vivf" ["指针"])
("vivg" ["执政" "指正" "至正"])
("vivh" ["执掌" "纸张"])
("vivi" ["蜘蜘" "直至" "置之" "制止" "桎桎"])
("vivk" ["执照"])
("vivl" ["指摘"])
("vivs" ["之中"])
("vivu" ["支柱" "支住" "蜘蛛" "植株" "止住" "踯躅"])
("viw'" "职直植殖执值侄指埴摭絷跖踯")
("viwf" ["指纹" "质问"])
("viwh" ["指望"])
("viwl" ["之外"])
("viwu" ["之无" "织物" "职务" "植物" "指物"])
("viwz" ["职位"])
("vix'" ["中垂线"])
("vixc" ["只消" "滞销"])
("vixd" ["指向" "纸箱" "志向"])
("vixi" ["窒息"])
("vixm" ["支线" "知县" "直线" "只限"])
("vixn" ["知心" "置信"])
("vixt" ["止血" "治学"])
("vixu" ["只需" "只许" "秩序"])
("vixw" ["之下" "直辖"])
("vixx" ["止血" "致谢"])
("vixy" ["执行"])
("viyb" ["只有" "挚友"])
("viye" ["枝叶" "汁液" "职业"])
("viyi" ["之一" "旨意" "致以" "致意" "置疑" "质疑"])
("viyj" ["纸烟"])
("viyk" ["只要" "质要"])
("viyn" ["知音" "指引"])
("viyr" ["职员" "支援" "志愿" "至元"])
("viys" ["致用"])
("viyt" ["制约"])
("viyu" ["至于" "智育" "治愈"])
("vize" ["职责" "指责"])
("vizi" ["枝子" "侄子" "质子"])
("vizk" ["织造" "制造"])
("vizl" ["只在"])
("vizo" ["支左" "支座" "制作"])
("vizu" ["知足"])
("vizv" ["治罪"])
("vj'" ["直接"])
("vjbk" ["战报"])
("vjbl" ["战败"])
("vjbz" ["战备"])
("vjdb" ["战斗"])
("vjdi" ["占地" "战地"])
("vjdr" ["斩断"])
("vjdv" ["站队"])
("vjdy" ["站定"])
("vje'" "盏斩辗崭展搌")
("vjfj" ["战犯"])
("vjfu" ["战俘"])
("vjfz" ["战费"])
("vjg'" ["镇静钢" "芝加哥"])
("vjgd" ["沾光"])
("vjge" ["战歌"])
("vjgh" ["站岗"])
("vjgo" ["战国" "战果"])
("vjgs" ["战功"])
("vjgu" ["战鼓"])
("vjhb" ["战后"])
("vjhk" ["战壕"])
("vjho" ["战火" "战祸"])
("vji'" ["装甲车"])
("vjie" ["战车"])
("vjig" ["占城"])
("vjih" ["战场"])
("vjii" ["展翅"])
("vjiu" ["展出"])
("vjjd" ["湛江"])
("vjjj" ["折旧基金"])
("vjjm" ["战舰"])
("vjju" ["占据" "战局"])
("vjjy" ["直接经验"])
("vjk'" ["张家口"])
("vjkl" ["展开" "绽开"])
("vjl'" ["枝角类" "中距离"])
("vjlc" ["占了"])
("vjld" ["直截了当"])
("vjli" ["战栗"])
("vjlj" ["展览"])
("vjlm" ["粘连"])
("vjlr" ["战乱"])
("vjlt" ["战略"])
("vjlx" ["绽裂"])
("vjly" ["占领"])
("vjma" ["战马"])
("vjmk" ["毡帽"])
("vjpn" ["展品"])
("vjq'" "瞻毡詹粘沾占谵旃")
("vjqi" ["展期"])
("vjqm" ["战前"])
("vjqu" ["战区"])
("vjr'" ["颤" "蘸" "栈" "占" "战" "站" "湛" "绽" "中间人" "庄稼人"])
("vjrj" ["沾染"])
("vjrl" ["直接染料"])
("vjsi" ["战死"])
("vjsv" ["珠江三角洲"])
("vjsx" ["直角三角形"])
("vjt'" ["中间体"])
("vjtl" ["站台"])
("vjtx" ["粘贴"])
("vjty" ["展厅"])
("vju'" ["这件事" "浙江省" "重金属" "重晶石"])
("vjub" ["斩首"])
("vjug" ["战胜"])
("vjui" ["展示" "战时" "战士" "战事"])
("vjuu" ["战书" "战术" "这就是说"])
("vjv'" ["中继站"])
("vjve" ["站着"])
("vjvg" ["战争"])
("vjvh" ["站长"])
("vjvm" ["直接证明"])
("vjvr" ["辗转"])
("vjvu" ["粘住" "站住"])
("vjw'" ["中纪委"])
("vjwf" ["站稳"])
("vjwh" ["展望"])
("vjxj" ["直接选举"])
("vjxm" ["展现" "占先" "占线" "战线"])
("vjxn" ["崭新"])
("vjyb" ["占有" "战友"])
("vjyh" ["瞻仰"])
("vjyi" ["战役"])
("vjys" ["占用"])
("vjzb" ["直角坐标"])
("vjzl" ["站在"])
("vk'" ["召开"])
("vkan" ["召安"])
("vkb'" ["真空泵"])
("vkbc" ["招标"])
("vkbj" ["照搬" "照办"])
("vkdk" ["找到"])
("vkdl" ["招待"])
("vkdu" ["照度"])
("vke'" "找沼爪")
("vkfa" ["照发"])
("vkfu" ["招抚"])
("vkg'" ["真空管"])
("vkge" ["找个"])
("vkgr" ["照管"])
("vkgu" ["照顾"])
("vkhe" ["兆赫"])
("vkho" ["着火"])
("vkhp" ["招魂"])
("vkhr" ["召唤"])
("vkhu" ["招呼"])
("vkhv" ["照会" "召回"])
("vkih" ["照常"])
("vkik" ["照抄"])
("vkiu" ["找出"])
("vkji" ["招集" "召集" "着急"])
("vkjm" ["召见"])
("vkjq" ["照旧"])
("vkjw" ["招架" "赵家"])
("vkkk" ["招考"])
("vkkl" ["召开"])
("vklc" ["照料"])
("vkld" ["照亮"])
("vkli" ["照例" "着哩"])
("vkll" ["招徕"])
("vkly" ["诏令"])
("vkmu" ["招募" "招慕" "召募"])
("vkmy" ["照明"])
("vkpl" ["招牌"])
("vkpm" ["照片"])
("vkpn" ["招聘"])
("vkpy" ["找平"])
("vkq'" "朝嘲招昭着啁钊")
("vkqi" ["朝气" "沼气"])
("vkqy" ["肇庆"])
("vkr'" "赵照罩兆肇召诏棹笊")
("vkrf" ["找人"])
("vktb" ["兆头"])
("vku'" ["郑克爽"])
("vkub" ["招收" "招手"])
("vkue" ["照射"])
("vkug" ["招生" "赵声"])
("vkui" ["找事" "肇事"])
("vkuu" ["诏书"])
("vkvd" ["赵庄"])
("vkve" ["照着"])
("vkvi" ["招致"])
("vkvj" ["招展"])
("vkvp" ["照准"])
("vkw'" "着")
("vkwa" ["兆瓦"])
("vkxd" ["招降" "照相"])
("vkxi" ["朝夕"])
("vkxp" ["找寻"])
("vkxt" ["昭雪"])
("vkxw" ["朝霞"])
("vkxx" ["专科学校"])
("vky'" ["赵匡胤"])
("vkya" ["爪牙"])
("vkyh" ["朝阳" "照样"])
("vkyi" ["罩衣"])
("vkyk" ["照耀"])
("vkyy" ["照应"])
("vkze" ["沼泽"])
("vkzi" ["罩子"])
("vkzl" ["照在"])
("vl'" ["这里"])
("vlb'" ["真理报" "质量比" "轴流泵" "中联部"])
("vld'" ["直流电" "重量单"])
("vldj" ["直流电动机" "直流电机"])
("vle'" "窄")
("vlf'" ["专利法"])
("vlfj" ["直流发电机"])
("vlg'" ["展览馆" "整流管" "中立国"])
("vlgl" ["质量管理"])
("vlh'" ["展览会" "纸老虎"])
("vli'" ["重力场"])
("vlik" ["摘抄"])
("vliu" ["摘除"])
("vlj'" ["政论家" "志留纪" "制冷机" "主力军"])
("vljd" ["重力加速度"])
("vljy" ["质量检验"])
("vlkf" ["智力开发"])
("vll'" ["中龄林"])
("vllu" ["摘录"])
("vlps" ["支离破碎"])
("vlq'" ["侧" "摘" "斋" "镇流器" "整流器" "专利权"])
("vlqr" ["债权" "债券"])
("vlr'" "祭债寨砦瘵")
("vlrh" ["翟让"])
("vlu'" ["蒸馏水" "质量数"])
("vlun" ["重力势能"])
("vlv'" ["占领者"])
("vlvb" ["质量指标"])
("vlvu" ["债主"])
("vlw'" "翟择宅")
("vlwl" ["寨外"])
("vlwu" ["债务"])
("vlxc" ["窄小"])
("vlxn" ["摘心"])
("vly'" ["朱丽叶"])
("vlyi" ["摘译"])
("vlyk" ["摘要"])
("vlyn" ["摘引"])
("vlyr" ["宅院"])
("vlyt" ["斋月"])
("vlz'" ["整流子" "正离子"])
("vlzi" ["寨子"])
("vm'" ["证明"])
("vmd'" ["殖民地"])
("vmh'" ["专门化"])
("vmi'" ["贮木场"])
("vmjg" ["专门机构"])
("vmru" ["知名人士"])
("vmrw" ["正面人物"])
("vmt'" ["皱眉头"])
("vmu'" ["证明书"])
("vmv'" ["这么着" "中美洲"])
("vmvy" ["殖民主义"])
("vmx'" ["这么想" "这么些"])
("vmy'" ["遮目鱼" "芝麻油" "这么样"])
("vmzy" ["装模作样"])
("vn'" ["只能"])
("vnh'" ["智能化"])
("vnu'" ["终南山"])
("vnv'" ["指南针"])
("vnx'" ["织女星"])
("vnzb" ["职能资本"])
("vojm" ["卓见"])
("vojt" ["卓绝"])
("vold" ["酌量"])
("voli" ["着力"])
("volo" ["着落"])
("volu" ["著录" "着陆"])
("volx" ["拙劣"])
("vomm" ["桌面"])
("vomo" ["捉摸" "琢磨"])
("vona" ["捉拿"])
("vons" ["捉弄"])
("voq'" "捉拙卓桌倬涿焯")
("voqy" ["酌情"])
("vore" ["灼热"])
("vose" ["着色"])
("voub" ["着手"])
("vouh" ["灼伤"])
("voui" ["卓识" "啄食"])
("vovd" ["茁壮"])
("vovs" ["着重"])
("vovu" ["捉住" "拙著" "卓著"])
("vow'" "缴著琢茁酌啄着灼浊诼擢浞濯禚斫镯")
("voxd" ["着想"])
("voyi" ["桌椅"])
("voyj" ["着眼"])
("voyn" ["浊音"])
("voyt" ["卓越"])
("vozi" ["桌子" "镯子"])
("vpbz" ["准备"])
("vpe'" "准")
("vpq'" "屯谆肫窀")
("vpql" ["众叛亲离"])
("vpqt" ["准确"])
("vpug" ["准绳"])
("vpui" ["准时"])
("vpvp" ["谆谆"])
("vpxm" ["准线"])
("vpxu" ["准许"])
("vpy'" ["占便宜"])
("vpyu" ["准予"])
("vpze" ["准则"])
("vq'" ["争取"])
("vqb'" ["周期表"])
("vqd'" ["准确度"])
("vqdl" ["争权夺利"])
("vqg'" ["支气管" "主权国"])
("vqhu" ["周期函数"])
("vqil" ["酌情处理"])
("vqj'" ["蒸汽机" "中秋节"])
("vqjg" ["政权机关"])
("vqji" ["蒸汽机车"])
("vql'" ["站起来" "周期律"])
("vqn'" ["中青年"])
("vqpb" ["朝气蓬勃"])
("vqr'" ["债权人"])
("vqww" ["准确无误"])
("vqx'" ["正确性" "周期性" "准确性"])
("vr'" ["主任"])
("vran" ["专案"])
("vrbm" ["转变"])
("vrbo" ["转播"])
("vrcl" ["诸如此类"])
("vrda" ["转达"])
("vrdc" ["转调"])
("vrdk" ["转到"])
("vrdm" ["专电"])
("vrdr" ["专断"])
("vrds" ["转动"])
("vre'" "转")
("vrer" ["转而"])
("vrfa" ["转发"])
("vrg'" ["主人公"])
("vrgk" ["转告" "撰稿"])
("vrhg" ["专横"])
("vrhr" ["转换"])
("vrhw" ["转化"])
("vria" ["砖茶"])
("vrie" ["专车"])
("vrig" ["专程"])
("vrih" ["专长"])
("vrjc" ["转交" "转角"])
("vrji" ["传记" "专机" "专集" "转机"])
("vrjw" ["专家" "转嫁"])
("vrke" ["专科"])
("vrkr" ["专款"])
("vrli" ["专利"])
("vrlj" ["专栏"])
("vrlm" ["转脸"])
("vrlu" ["转炉" "转录"])
("vrmf" ["专门"])
("vrml" ["专卖"])
("vrnm" ["转念"])
("vrpj" ["转盘"])
("vrq'" "专砖颛")
("vrqm" ["赚钱"])
("vrqr" ["专权"])
("vrqu" ["专区"])
("vrr'" "传转撰赚篆啭馔沌")
("vrrf" ["专人" "专任"])
("vrrh" ["转让"])
("vrru" ["转入"])
("vrss" ["转送"])
("vrsu" ["转速"])
("vrtb" ["砖头"])
("vrti" ["专题"])
("vrtl" ["转台"])
("vruf" ["转身"])
("vrui" ["专使"])
("vrup" ["转瞬"])
("vrvb" ["转轴"])
("vrve" ["转折"])
("vrvg" ["专政" "转正"])
("vrvh" ["转帐"])
("vrvi" ["专职" "专指" "专制"])
("vrvj" ["转战"])
("vrvu" ["专著" "专注" "转注"])
("vrw'" ["主人翁"])
("vrwf" ["撰文"])
("vrwj" ["转弯"])
("vrwl" ["助人为乐"])
("vrwy" ["主任委员"])
("vrwz" ["专为" "转为"])
("vrxd" ["专项" "转向"])
("vrxn" ["专心"])
("vrxt" ["转学"])
("vrxx" ["撰写"])
("vrye" ["专业" "转业"])
("vryi" ["专一" "转移"])
("vryj" ["转眼"])
("vryn" ["转音"])
("vryp" ["转运"])
("vryr" ["专员"])
("vrys" ["专用"])
("vrze" ["专责"])
("vrzi" ["转子" "篆字"])
("vrzl" ["转载"])
("vsbc" ["中表" "钟表"])
("vsbi" ["重臂"])
("vsbk" ["中保" "中饱"])
("vsbl" ["钟摆"])
("vsbo" ["中波"])
("vsbu" ["中部"])
("vsbx" ["种别"])
("vsby" ["重兵" "重病"])
("vscg" ["中层"])
("vscl" ["仲裁"])
("vsda" ["重大"])
("vsde" ["中德"])
("vsdg" ["中等"])
("vsdi" ["中的" "种地" "重地"])
("vsdj" ["中弹" "种蛋" "重担"])
("vsdk" ["中稻" "中道"])
("vsdm" ["中点" "钟点" "终点" "重点"])
("vsdo" ["众多"])
("vsdr" ["中段" "中断" "终端"])
("vsds" ["中东"])
("vsdu" ["中毒"])
("vsdv" ["中队"])
("vse'" "种肿冢踵")
("vsfg" ["中锋" "中风"])
("vsfj" ["中饭"])
("vsfu" ["重负"])
("vsfz" ["中非" "种肥"])
("vsgg" ["中耕"])
("vsgk" ["忠告"])
("vsgo" ["中国"])
("vsgr" ["钟关"])
("vsgs" ["中共"])
("vsgu" ["中古" "中固" "钟鼓"])
("vsgv" ["终归"])
("vshb" ["忠厚"])
("vshd" ["中黄"])
("vshe" ["中和"])
("vshh" ["中行"])
("vsho" ["重活"])
("vshw" ["中华" "种花"])
("vsia" ["钟差" "种差"])
("vsif" ["忠臣"])
("vsig" ["中程" "忠诚"])
("vsih" ["中常"])
("vsik" ["中朝"])
("vsiu" ["种畜"])
("vsjc" ["中校"])
("vsjd" ["中将" "重奖"])
("vsji" ["中级" "中计" "中继" "终极"])
("vsjm" ["中坚" "中间"])
("vsjp" ["中军"])
("vsjq" ["终究" "终久"])
("vsju" ["中局" "终局"])
("vsjx" ["正三角形" "中介" "终结"])
("vsjy" ["中经" "中景"])
("vskf" ["中肯"])
("vskj" ["中看"])
("vsl'" ["致死量"])
("vslb" ["钟楼"])
("vslc" ["终了"])
("vsld" ["重量"])
("vsli" ["中立" "重力"])
("vslj" ["中栏"])
("vslo" ["中落"])
("vslp" ["中论"])
("vslq" ["中流" "肿瘤"])
("vslu" ["中路"])
("vslv" ["仲吕"])
("vslx" ["忠烈"])
("vslz" ["种类"])
("vsma" ["种麻" "种马"])
("vsmz" ["中美"])
("vsni" ["仲尼"])
("vsnj" ["中南"])
("vsnm" ["中年" "终年"])
("vsns" ["中农"])
("vsou" ["中欧"])
("vspk" ["重炮"])
("vspl" ["中派"])
("vspn" ["中频"])
("vspy" ["中平"])
("vsq'" "中盅忠钟衷终忪锺螽舯")
("vsqi" ["中期" "中气"])
("vsqp" ["种群"])
("vsqq" ["中秋"])
("vsqy" ["中情" "衷情"])
("vsr'" "中种重仲众")
("vsrf" ["中人" "重人" "重任" "众人"])
("vsri" ["中日" "终日"])
("vssu" ["中苏"])
("vstb" ["钟头"])
("vstm" ["中天" "种田"])
("vsts" ["中统"])
("vstu" ["中途" "中土"])
("vstx" ["中铁"])
("vsty" ["中听"])
("vsuf" ["终身" "终审"])
("vsug" ["钟声" "终生" "众生"])
("vsuh" ["中伤" "中上" "种上" "重伤"])
("vsui" ["中使" "中式" "忠实" "重视"])
("vsuj" ["中山" "钟山"])
("vsuu" ["中枢" "中暑" "众数"])
("vsuv" ["重水"])
("vsvb" ["中州"])
("vsvd" ["中装"])
("vsvf" ["忠贞" "重镇"])
("vsvh" ["肿胀"])
("vsvi" ["中支" "中知" "中指" "中止" "终止" "种植"])
("vsvr" ["中专" "中转"])
("vsvs" ["种种" "重重"])
("vsvu" ["种猪"])
("vsvv" ["众所周知"])
("vswf" ["中文"])
("vswl" ["中外"])
("vswu" ["中午" "重物"])
("vswz" ["中委" "中尉" "中卫"])
("vsxc" ["中小" "中校" "忠孝"])
("vsxd" ["钟相"])
("vsxi" ["中西"])
("vsxm" ["中线"])
("vsxn" ["中心" "忠心" "忠信" "衷心" "重心"])
("vsxp" ["中旬"])
("vsxr" ["中选"])
("vsxt" ["中学"])
("vsxy" ["中兴" "中型" "中性" "重型"])
("vsy'" ["之所以"])
("vsya" ["中亚"])
("vsyb" ["中游" "重油"])
("vsye" ["中叶"])
("vsyh" ["中央"])
("vsyi" ["中医" "中意" "忠义"])
("vsyk" ["中药" "重要"])
("vsyn" ["重音"])
("vsyr" ["中原"])
("vsys" ["中庸" "中用" "重用"])
("vsyt" ["中越"])
("vsyu" ["忠于" "终于" "种玉"])
("vsyy" ["中营"])
("vszi" ["中子" "种子"])
("vszl" ["重载"])
("vszu" ["种族"])
("vt'" ["状态"])
("vtb'" ["掷铁饼"])
("vtcu" ["状态参数"])
("vtdd" ["战天斗地"])
("vtdh" ["志同道合"])
("vtg'" ["中碳钢"])
("vttl" ["专题讨论"])
("vtxu" ["侦探小说"])
("vty'" ["正投影"])
("vtzy" ["蒸腾作用"])
("vu'" ["知识"])
("vubh" ["珠蚌"])
("vubi" ["主笔" "铸币"])
("vubj" ["竹板" "主办"])
("vubk" ["珠宝"])
("vubm" ["主编"])
("vubu" ["逐步"])
("vubz" ["贮备"])
("vuce" ["注册"])
("vuch" ["贮藏"])
("vuci" ["逐次" "主次" "助词" "祝词"])
("vucp" ["贮存"])
("vucs" ["主从"])
("vud'" ["指示灯" "中生代"])
("vudi" ["驻地"])
("vudk" ["主导"])
("vuds" ["主动"])
("vudy" ["铸锭" "注定"])
("vue'" "属煮拄瞩嘱主渚褚麈")
("vuer" ["珠儿" "主儿"])
("vufa" ["主伐"])
("vufg" ["主峰"])
("vufh" ["住房" "驻防"])
("vufj" ["直升飞机" "主犯"])
("vufu" ["嘱咐" "主妇" "祝福"])
("vufz" ["知识分子" "煮沸"])
("vugd" ["烛光"])
("vuge" ["诸葛" "逐个"])
("vugf" ["主根"])
("vugh" ["铸钢"])
("vugj" ["猪肝" "竹竿" "主干"])
("vugr" ["猪倌" "竹管" "主观" "主管"])
("vugs" ["诸公" "主攻" "助工" "助攻" "铸工"])
("vugu" ["主顾"])
("vuh'" ["这时候" "知识化"])
("vuhb" ["诸侯"])
("vuhe" ["祝贺"])
("vuhl" ["珠海"])
("vuhs" ["朱红"])
("vuhu" ["指数函数" "住户" "株式会社"])
("vuhw" ["驻华"])
("vuig" ["诸城" "著称" "铸成"])
("vuih" ["猪场"])
("vuii" ["主持"])
("vuij" ["助产"])
("vuis" ["蛀虫"])
("vuiu" ["逐出" "住处"])
("vuj'" ["针梳机" "直升机" "指示剂" "中世纪"])
("vujc" ["主角" "主教" "助教" "注脚"])
("vujd" ["珠江" "主将" "主讲"])
("vuji" ["逐级" "主机"])
("vujm" ["逐渐" "竹简" "煮茧" "主见" "铸件"])
("vujp" ["诸君" "驻军"])
("vujq" ["祝酒"])
("vujr" ["猪圈"])
("vuju" ["株距"])
("vujw" ["住家"])
("vujx" ["竹节" "注解"])
("vujy" ["住京"])
("vukb" ["住口"])
("vuke" ["逐客" "主客"])
("vul'" ["赵树理" "折射率" "中书令"])
("vulb" ["竹楼"])
("vuli" ["主力" "助理" "伫立"])
("vulm" ["株连" "煮练"])
("vuln" ["竹林"])
("vulq" ["主流" "驻留"])
("vulu" ["著录" "筑路"])
("vuma" ["苎麻"])
("vumf" ["朱门"])
("vumu" ["注目"])
("vumy" ["朱明" "主名" "著名"])
("vuni" ["祝你"])
("vunm" ["逐年"])
("vunn" ["祝您"])
("vup'" ["装饰品"])
("vupi" ["猪皮"])
("vupk" ["助跑"])
("vuq'" ["珠" "株" "蛛" "朱" "猪" "诸" "诛" "侏" "邾" "茱" "洙" "潴" "槠" "橥" "铢" "指示器"])
("vuqi" ["竹器"])
("vuqm" ["竹签"])
("vuqn" ["知识青年"])
("vuqr" ["主权"])
("vur'" "著柱助蛀贮铸筑住注祝驻伫苎杼炷疰箸翥")
("vurb" ["猪肉"])
("vurf" ["主人" "主任"])
("vuri" ["逐日"])
("vurj" ["助燃"])
("vuru" ["诸如" "注入"])
("vurv" ["朱瑞"])
("vuso" ["住所"])
("vusp" ["竹笋"])
("vusr" ["珠算"])
("vuss" ["主送"])
("vusu" ["住宿" "注塑"])
("vut'" ["政事堂" "主视图"])
("vutb" ["猪头" "柱头"])
("vutc" ["逐条"])
("vuti" ["猪蹄" "主题" "主体"])
("vuto" ["嘱托"])
("vuts" ["竹筒"])
("vutx" ["铸铁"])
("vuua" ["朱砂"])
("vuub" ["助手" "住手" "祝寿" "驻守"])
("vuue" ["注射"])
("vuug" ["诸生"])
("vuui" ["主食" "主事" "柱石" "注释" "注视"])
("vuuj" ["中枢神经"])
("vuuu" ["煮熟" "著述"])
("vuuv" ["注水"])
("vuuy" ["主帅"])
("vuva" ["驻扎"])
("vuvb" ["主轴"])
("vuve" ["拄着" "著者"])
("vuvh" ["主张" "助长"])
("vuvi" ["主枝" "主值" "主旨" "主治" "住址"])
("vuvj" ["助战"])
("vuvl" ["住宅"])
("vuvs" ["注重"])
("vuw'" "术逐竹烛筑瘃竺舳躅")
("vuwf" ["朱温"])
("vuwh" ["蛛网"])
("vuwz" ["诸位"])
("vux'" ["真实性"])
("vuxc" ["注消"])
("vuxd" ["逐项" "助饷"])
("vuxi" ["朱熹" "竹席" "主席"])
("vuxm" ["朱先"])
("vuxr" ["株选"])
("vuxt" ["助学"])
("vuxw" ["诸夏"])
("vuxy" ["主刑" "铸型"])
("vuy'" ["装饰音"])
("vuyb" ["猪油" "著有" "注油"])
("vuye" ["竹叶"])
("vuyi" ["逐一" "主意" "主义" "注意"])
("vuyk" ["主要"])
("vuyn" ["主音" "注音"])
("vuyr" ["住院" "祝愿"])
("vuyt" ["逐月"])
("vuyu" ["主语"])
("vuyy" ["主营"])
("vuzi" ["珠子" "朱子" "诸子" "逐字" "竹子" "主子" "柱子"])
("vuzk" ["铸造"])
("vuzl" ["主宰"])
("vuzo" ["著作"])
("vuzs" ["猪鬃"])
("vv'" ["这种"])
("vvb'" ["真值表" "政治部"])
("vvbl" ["置之不理"])
("vvbn" ["政治避难"])
("vvbu" ["追捕"])
("vvd'" ["执政党" "转折点"])
("vvdc" ["追掉"])
("vvdk" ["追悼"])
("vvdu" ["锥度"])
("vvdw" ["置之度外"])
("vvf'" ["政治犯"])
("vvfz" ["追肥"])
("vvgj" ["追赶"])
("vvgu" ["椎骨"])
("vvhe" ["缀合"])
("vvhr" ["追还"])
("vvhv" ["追回" "坠毁"])
("vvia" ["追查"])
("vvj'" ["政治家" "柱状晶" "政治局"])
("vvji" ["追击"])
("vvjq" ["追究"])
("vvjw" ["追加"])
("vvjx" ["政治经济学"])
("vvk'" ["政治课"])
("vvlo" ["坠落"])
("vvmm" ["锥面"])
("vvmv" ["政治民主"])
("vvp'" ["针织品"])
("vvq'" "椎锥追骓隹")
("vvql" ["政治权利"])
("vvqq" ["整整齐齐" "追求"])
("vvqu" ["郑重其事"])
("vvr'" "赘坠缀惴缒")
("vvru" ["蒸蒸日上"])
("vvsu" ["追溯" "追诉"])
("vvsv" ["追随"])
("vvti" ["锥体"])
("vvu'" ["郑州市"])
("vvuh" ["追上"])
("vvuu" ["扎扎实实" "追述" "赘述"])
("vvvd" ["专制制度"])
("vvvi" ["着重指出"])
("vvvt" ["战争状态"])
("vvvu" ["追逐"])
("vvwf" ["追问"])
("vvww" ["支支吾吾"])
("vvwy" ["政治委员"])
("vvxp" ["追寻"])
("vvxu" ["政治协商"])
("vvxw" ["坠下"])
("vvxy" ["锥形"])
("vvy'" ["指战员" "种植业" "种植园"])
("vvyi" ["追忆"])
("vvyp" ["战争与和平"])
("vvzh" ["追赃"])
("vvzi" ["锥子"])
("vvzs" ["追踪"])
("vw'" ["职务"])
("vwbh" ["植物保护"])
("vwbu" ["战无不胜"])
("vwd'" ["中纬度"])
("vwdb" ["抓斗"])
("vwdm" ["抓点"])
("vwe'" "爪")
("vwhj" ["中文环境"])
("vwhk" ["抓好"])
("vwhz" ["中外合资"])
("vwiu" ["抓出"])
("vwjn" ["抓紧"])
("vwq'" "挝抓")
("vwqi" ["抓起"])
("vwql" ["植物群落"])
("vwqx" ["植物区系"])
("vwr'" ["债务人"])
("vwt'" ["植物体"])
("vwu'" ["政闻社" "中位数"])
("vwug" ["抓生"])
("vwui" ["中文输出"])
("vwur" ["中文输入"])
("vwvu" ["抓住"])
("vww'" ["周武王"])
("vwx'" ["植物学"])
("vwxu" ["振武学社"])
("vwy'" ["政务院" "植物油"])
("vwz'" ["中微子"])
("vwzb" ["抓走"])
("vwzi" ["爪子"])
("vwzv" ["织物组织"])
("vx'" ["这些"])
("vxb'" ["展弦比" "正弦波" "中宣部"])
("vxdi" ["中心对称"])
("vxdl" ["正弦定理"])
("vxg'" ["正弦规"])
("vxgg" ["忠心耿耿"])
("vxh'" ["展销会"])
("vxhy" ["制宪会议"])
("vxj'" ["照相机" "哲学家" "中心角" "转向架"])
("vxjr" ["秩序井然"])
("vxkh" ["争先恐后"])
("vxl'" ["主旋律"])
("vxlq" ["转向离合器"])
("vxml" ["执行命令"])
("vxnr" ["中心内容"])
("vxq'" ["转向器" "装卸桥"])
("vxqx" ["正弦曲线"])
("vxrl" ["中性染料"])
("vxrw" ["中心任务"])
("vxsx" ["中心思想"])
("vxt'" ["中心体" "主席团"])
("vxu'" ["直辖市" "中学生"])
("vxuy" ["真心实意" "振兴实业"])
("vxv'" ["张献忠"])
("vxvv" ["专心致志"])
("vxx'" ["郑孝胥" "中小学"])
("vxy'" ["真想要"])
("vxyd" ["直线运动"])
("vy'" ["只有"])
("vyd'" ["着眼点"])
("vydk" ["专业对口"])
("vydt" ["中央电视台"])
("vye'" ["转" "扎伊尔"])
("vygs" ["专业公司"])
("vyh'" ["专业化" "专业户"])
("vyix" ["卓有成效"])
("vyj'" ["志愿军" "中央军" "抓岩机" "装岩机"])
("vyjj" ["专用基金"])
("vyjq" ["中央集权"])
("vyjw" ["中央军委"])
("vyjy" ["专业教育"])
("vyk'" ["专业课"])
("vyl'" ["针叶林" "主应力"])
("vymd" ["主要矛盾"])
("vyq'" ["拽" "占有权" "制音器"])
("vyqj" ["中央情报局"])
("vyr'" "曳拽嘬")
("vyry" ["专业人员" "主要人员"])
("vyu'" ["针叶树" "质因数"])
("vyuv" ["主要树种"])
("vyv'" ["朱元璋"])
("vyvf" ["中央政府"])
("vyvp" ["招摇撞骗"])
("vyvu" ["专业知识"])
("vyvv" ["正义战争"])
("vywh" ["中央委员会"])
("vywt" ["主要问题"])
("vyx'" ["重要性" "专用线"])
("vyy'" ["众议院"])
("vyyh" ["专业银行"])
("vyyy" ["主要原因"])
("vyzm" ["注音字母"])
("vz'" ["职责"])
("vzbj" ["诸子百家"])
("vzd'" ["沼泽地" "种子地"])
("vzg'" ["驻在国"])
("vzl'" ["张作霖"])
("vzqu" ["种族歧视"])
("vzr'" "这")
("vzt'" ["种子田"])
("vzvy" ["种族主义"])
("vzx'" ["中子星"])
("vzy'" ["种子园"])
("w" "我")
("wabu" ["挖补"])
("wadi" ["洼地"])
("wae'" "瓦佤")
("waer" ["瓦尔"])
("wafh" ["瓦房"])
("wagj" ["娲杆"])
("wagr" ["瓦罐"])
("wags" ["瓦工"])
("waiu" ["挖出"])
("wajt" ["挖掘"])
("wajx" ["瓦解"])
("waku" ["挖苦"])
("wala" ["哇啦"])
("wali" ["瓦砾"])
("walo" ["瓦罗"])
("walp" ["娲轮"])
("wapf" ["瓦盆"])
("waq'" "凹挖哇蛙洼娲")
("waqm" ["挖潜"])
("war'" "瓦袜腽")
("wasi" ["瓦斯"])
("wat'" "哇")
("wate" ["瓦特"])
("wau'" ["王安石"])
("waw'" "娃")
("wawa" ["娃娃"])
("waxm" ["洼陷"])
("ways" ["蛙泳"])
("wazi" ["娃子" "袜子"])
("wb'" ["务必"])
("wbcz" ["五笔词组"])
("wbn'" ["王炳南"])
("wbub" ["外部设备"])
("wbwj" ["无边无际"])
("wbx'" ["五边形"])
("wbxt" ["武备学堂"])
("wbzd" ["微不足道"])
("wbzx" ["五笔字型" "五笔字形"])
("wc'" ["为此"])
("wcbf" ["五彩缤纷"])
("wcbv" ["误餐补助"])
("wce'" ["王聪儿"])
("wckj" ["外层空间"])
("wd'" ["我的"])
("wdi'" ["温度场"])
("wdj'" ["温度计" "稳定剂"])
("wdl'" ["外电路"])
("wdlx" ["伟大领袖" "伟大领袖毛主席"])
("wdly" ["维多利亚"])
("wdm'" ["魏德迈"])
("wdml" ["危地马拉"])
("wdtd" ["温度梯度"])
("wdug" ["五代十国"])
("wdx'" ["稳定性"])
("wdxt" ["无定形碳"])
("wdyv" ["无动于衷"])
("wdz'" ["微电子"])
("webz" ["无恶不作"])
("weuw" ["望而生畏"])
("wex'" ["威尔逊"])
("wf'" ["无法"])
("wfb'" ["往复泵"])
("wfbc" ["温标"])
("wfbf" ["文本"])
("wfbi" ["文笔"])
("wfbj" ["纹板"])
("wfbk" ["温饱"])
("wfbu" ["稳步"])
("wfcp" ["温存"])
("wfda" ["问答"])
("wfdh" ["稳当"])
("wfdl" ["微分电路" "温带"])
("wfdu" ["温度"])
("wfdy" ["稳定"])
("wfe'" "吻稳紊刎")
("wfed" ["闻风而动"])
("wffa" ["文法"])
("wffg" ["文风" "闻风"])
("wffi" ["微分方程"])
("wfge" ["文革"])
("wfgg" ["无缝钢管"])
("wfgk" ["文稿" "文告"])
("wfgr" ["文官"])
("wfgu" ["稳固"])
("wfhb" ["问候"])
("wfhe" ["温和" "吻合"])
("wfhk" ["文豪" "问好" "问号"])
("wfho" ["文火"])
("wfhw" ["文化" "问话"])
("wfia" ["温差"])
("wfid" ["温床"])
("wfih" ["文昌"])
("wfis" ["蚊虫"])
("wfjc" ["文教"])
("wfji" ["文集" "问及"])
("wfjm" ["文件" "闻见" "稳健"])
("wfju" ["文具" "文句"])
("wfjy" ["文静" "问荆"])
("wfke" ["文科"])
("wfld" ["温良"])
("wfli" ["文理" "纹理"])
("wflj" ["违法乱纪"])
("wfll" ["文莱"])
("wflm" ["文联"])
("wflq" ["稳流" "紊流"])
("wflr" ["紊乱"])
("wflu" ["纹路"])
("wfmh" ["文盲"])
("wfmy" ["文明" "闻名"])
("wfnr" ["温暖"])
("wfpy" ["文凭"])
("wfq'" "瘟温")
("wfqr" ["温泉"])
("wfqy" ["温情"])
("wfr'" "纹问汶璺")
("wfrb" ["温柔"])
("wfrf" ["文人"])
("wfro" ["文弱"])
("wfti" ["文体" "问题"])
("wfto" ["稳妥"])
("wfui" ["温室" "问世"])
("wfuu" ["文殊" "文书"])
("wfuv" ["温水"])
("wfv'" ["王夫之"])
("wfvb" ["温州"])
("wfvh" ["文章"])
("wfvl" ["文摘"])
("wfvs" ["温中" "稳重"])
("wfvu" ["稳住"])
("wfw'" "蚊文闻纹阌璺雯")
("wfwh" ["文王"])
("wfwu" ["文武" "文物"])
("wfxi" ["温习"])
("wfxm" ["文献"])
("wfxp" ["闻讯" "问讯"])
("wfxq" ["歪风邪气"])
("wfxr" ["文选"])
("wfxt" ["文学"])
("wfxw" ["违法行为"])
("wfya" ["文雅" "稳压"])
("wfyd" ["五反运动"])
("wfyh" ["纹样"])
("wfyi" ["瘟疫" "文艺" "文义"])
("wfyj" ["文言"])
("wfyu" ["文娱"])
("wfzd" ["为非作歹"])
("wfze" ["文则"])
("wfzi" ["蚊子" "文字"])
("wg'" ["我国"])
("wgd'" ["乌干达"])
("wgdi" ["无轨电车"])
("wge'" "蓊")
("wggl" ["无功功率"])
("wgiq" ["万古长青"])
("wgj'" ["瓦岗军" "无国籍"])
("wgl'" ["五公里"])
("wglz" ["微观粒子"])
("wgn'" ["亡国奴"])
("wgq'" "嗡翁")
("wgqx" ["外公切线"])
("wgr'" "瓮蕹")
("wguj" ["微观世界"])
("wgus" ["五光十色"])
("wgvx" ["温故知新"])
("wgw'" ["王国维"])
("wgwg" ["嗡嗡"])
("wgy'" ["外国语"])
("wh'" ["文化"])
("whb'" ["文汇报" "文化部"])
("whba" ["王八"])
("whbf" ["忘本"])
("whbm" ["五花八门"])
("whdc" ["忘掉"])
("whdi" ["网底"])
("whdk" ["王导" "王道"])
("whdm" ["网点" "文化大革命"])
("whdp" ["王敦"])
("whe'" "枉网往罔惘辋魍")
("whfa" ["王法" "枉法"])
("whfj" ["往返"])
("whfu" ["王府" "往复"])
("whg'" ["文化宫" "文化馆"])
("whgo" ["王国" "亡国"])
("whgr" ["王官" "王冠"])
("whgs" ["王公" "王宫"])
("whhb" ["王侯" "王后" "往后"])
("whhy" ["忘怀"])
("whid" ["文化程度"])
("whig" ["王成"])
("whih" ["往常"])
("whik" ["王朝"])
("whis" ["王充"])
("whji" ["王畿" "旺季" "忘记"])
("whjm" ["望见"])
("whjx" ["王杰"])
("whkd" ["王匡"])
("whkl" ["王恺"])
("whks" ["网孔"])
("whlc" ["忘了"])
("whld" ["物化劳动"])
("whll" ["往来"])
("whlo" ["网罗" "网络"])
("whmg" ["王猛"])
("whmh" ["王莽"])
("whmo" ["网膜"])
("whmy" ["王明" "亡命"])
("whnm" ["往年"])
("whq'" ["汪" "尢" "未婚妻" "雾化器"])
("whqm" ["往前"])
("whqq" ["网球"])
("whqr" ["王权"])
("whqt" ["忘却"])
("whqy" ["忘情"])
("whr'" "王往旺望忘妄")
("whrf" ["王人"])
("whri" ["往日"])
("whrj" ["惘然"])
("whsy" ["忘乎所以"])
("whtk" ["王韬"])
("whtl" ["王台"])
("whtu" ["妄图"])
("whu'" ["威虎山" "武汉市"])
("whug" ["旺盛"])
("whuh" ["网上" "往上"])
("whui" ["王室" "往事"])
("whup" ["文化水平"])
("whuv" ["王水"])
("whvd" ["王庄" "网状"])
("whve" ["望着"])
("whvi" ["王制"])
("whvu" ["玩忽职守"])
("whw'" "芒王亡忘")
("whwh" ["汪汪" "往往" "望望"])
("whwn" ["问寒问暖"])
("whwo" ["忘我"])
("whwz" ["王维" "王位"])
("whx'" ["危害性"])
("whxd" ["网箱" "妄想"])
("whxi" ["往昔"])
("whxw" ["往下"])
("whxy" ["忘形"])
("whyb" ["往右"])
("whye" ["王爷"])
("whyh" ["汪洋"])
("whyj" ["网眼"])
("whyl" ["文化娱乐"])
("whyr" ["望远"])
("whzi" ["王子"])
("whzo" ["往左"])
("wi'" ["完成"])
("wigi" ["稳产高产"])
("wijj" ["无产阶级" "无产阶级革命家"])
("wijm" ["无产阶级革命"])
("wijv" ["无产阶级专政"])
("wilj" ["微处理机"])
("win'" ["未成年"])
("wiqy" ["武昌起义"])
("wiuy" ["望穿双眼"])
("wj'" ["危机"])
("wjb'" ["外交部"])
("wjbi" ["完毕"])
("wjbk" ["晚报"])
("wjbz" ["完备" "晚辈"])
("wjdb" ["外交代表" "豌豆"])
("wjdj" ["完蛋"])
("wjdk" ["晚稻"])
("wjdl" ["万代"])
("wjdm" ["晚点"])
("wjdp" ["万吨"])
("wjdu" ["弯度"])
("wje'" "娩碗挽晚皖惋宛婉莞菀绾琬脘畹")
("wjee" ["万恶"])
("wjer" ["玩儿"])
("wjf'" ["微积分"])
("wjff" ["万分"])
("wjfh" ["万方"])
("wjfj" ["晚饭"])
("wjfl" ["无机肥料"])
("wjfu" ["万福"])
("wjg'" ["外交官"])
("wjgs" ["完工"])
("wjgu" ["顽固" "万古"])
("wjhk" ["完好"])
("wjho" ["玩火"])
("wjhp" ["晚婚"])
("wjhu" ["玩忽" "万户"])
("wjhv" ["挽回" "晚会"])
("wjig" ["完成"])
("wjj'" ["挖掘机"])
("wjji" ["烷基"])
("wjjm" ["晚间"])
("wjjn" ["晚近"])
("wjjq" ["挽救"])
("wjju" ["弯矩" "玩具"])
("wjjx" ["完结"])
("wjkg" ["无家可归"])
("wjkh" ["顽抗"])
("wjl'" ["无纪律"])
("wjlc" ["完了"])
("wjli" ["万里" "万历" "腕力"])
("wjlq" ["挽留"])
("wjlu" ["弯路"])
("wjmj" ["完满"])
("wjmp" ["无记名投票"])
("wjmz" ["完美"])
("wjng" ["万能"])
("wjnj" ["万难"])
("wjnm" ["晚年" "万年"])
("wjns" ["玩弄"])
("wjpi" ["顽皮"])
("wjq'" "豌弯湾剜蜿")
("wjqd" ["顽强"])
("wjqi" ["晚期"])
("wjqm" ["万千"])
("wjqq" ["晚秋"])
("wjqr" ["完全" "万全"])
("wjqu" ["弯曲"])
("wjr'" "蔓万腕")
("wjrf" ["完人" "万人"])
("wjro" ["宛若"])
("wjru" ["宛如"])
("wjsm" ["五讲四美"])
("wjsv" ["万岁"])
("wjtb" ["弯头"])
("wjtq" ["外交特权"])
("wjty" ["烷烃"])
("wjub" ["挽手"])
("wjud" ["晚霜"])
("wjuh" ["玩赏" "晚上"])
("wjui" ["玩世" "顽石" "完事" "万世" "万事"])
("wjuj" ["外交使节" "完善"])
("wjuu" ["晚熟"])
("wjuw" ["玩耍"])
("wjvd" ["万状"])
("wjvg" ["完整"])
("wjvh" ["万丈"])
("wjvs" ["万众"])
("wjvu" ["物价指数"])
("wjw'" ["玩" "顽" "丸" "烷" "完" "芄" "纨" "汪精卫"])
("wjwj" ["万万"])
("wjwu" ["玩物" "万物" "无拘无束"])
("wjwz" ["玩味"])
("wjx'" ["五角星"])
("wjxc" ["玩笑"])
("wjxd" ["万象"])
("wjxi" ["惋惜"])
("wjxm" ["万县"])
("wjxw" ["晚霞"])
("wjy'" ["外接圆" "无机盐"])
("wjyb" ["万有"])
("wjyi" ["玩艺" "玩意" "万一"])
("wjyj" ["晚宴" "婉言" "蜿蜒"])
("wjyk" ["丸药"])
("wjyr" ["万元"])
("wjys" ["万用"])
("wjyu" ["无济于事"])
("wjz'" ["吴敬梓"])
("wjzi" ["丸子"])
("wkfg" ["无可奉告"])
("wkfy" ["无可非议"])
("wkl'" ["乌克兰"])
("wknh" ["无可奈何"])
("wkvb" ["无可争辩"])
("wkxs" ["挖空心思"])
("wl'" ["为了"])
("wlbc" ["外表"])
("wlbh" ["物理变化"])
("wlbm" ["外边"])
("wlbn" ["外宾"])
("wlbu" ["外部"])
("wlcp" ["外存"])
("wldc" ["外调"])
("wldi" ["外敌" "外地"])
("wldm" ["外电"])
("wle'" "崴")
("wlfg" ["歪风"])
("wlfi" ["无理方程"])
("wlgo" ["外国"])
("wlgr" ["外观"])
("wlgs" ["外公"])
("wlhh" ["外行"])
("wlhk" ["外号"])
("wlhl" ["外海"])
("wlho" ["外货"])
("wlhr" ["外患"])
("wlhv" ["外汇"])
("wlhx" ["物理化学"])
("wli'" ["乌龙茶"])
("wlih" ["外场"])
("wlii" ["万里长城"])
("wliv" ["万里长征"])
("wljc" ["外交" "外角"])
("wljm" ["外间"])
("wljw" ["外加"])
("wljx" ["外接" "外界"])
("wlke" ["外科" "外壳"])
("wlli" ["外力"])
("wlll" ["外来"])
("wllq" ["外流"])
("wlmk" ["外貌" "外贸"])
("wlmm" ["外面"])
("wlmq" ["乌鲁木齐"])
("wlpj" ["涡轮喷气发动机"])
("wlpo" ["外婆"])
("wlq'" "歪")
("wlqc" ["外侨"])
("wlqi" ["外戚" "外企"])
("wlqn" ["外勤" "无理取闹"])
("wlqu" ["歪曲"])
("wlr'" "外")
("wlrf" ["外人"])
("wlrh" ["无论如何"])
("wlsp" ["外孙"])
("wltb" ["外头"])
("wltk" ["外逃" "外套"])
("wlue" ["外设"])
("wlug" ["外生" "外甥" "外省"])
("wluh" ["外商"])
("wlui" ["外史" "外事"])
("wlut" ["唯利是图"])
("wluv" ["外水"])
("wlv'" ["吴禄贞"])
("wlvh" ["外长"])
("wlvi" ["外痔"])
("wlvj" ["涡轮轴发动机"])
("wlvl" ["外债"])
("wlvr" ["外转"])
("wlwf" ["外文"])
("wlwu" ["外屋" "外侮" "外务"])
("wlwz" ["外围"])
("wlx'" ["物理学"])
("wlxc" ["外销"])
("wlxd" ["外乡" "外项"])
("wlxj" ["物理学家"])
("wlxm" ["外弦" "外线"])
("wlxn" ["外心"])
("wlxt" ["外学"])
("wlxv" ["物理性质"])
("wlxx" ["歪斜"])
("wlxy" ["外形"])
("wlyh" ["外洋"])
("wlyi" ["外衣"])
("wlyj" ["外延" "外焰"])
("wlyn" ["外因"])
("wlyr" ["外援"])
("wlys" ["外用" "微量元素"])
("wlyu" ["外语"])
("wlzi" ["外资" "外子"])
("wlzl" ["外在"])
("wlzu" ["外族"])
("wlzy" ["外力作用"])
("wm'" ["我们"])
("wmb'" ["我们被" "屋面板"])
("wmbt" ["万马奔腾"])
("wmjl" ["物美价廉"])
("wml'" ["误码率"])
("wmv'" ["无名指"])
("wmwx" ["微妙微肖"])
("wmyx" ["无名英雄"])
("wmz'" ["王麻子"])
("wn'" ["未能"])
("wni'" ["挖泥船"])
("wnjh" ["五年计划"])
("wnrl" ["委内瑞拉"])
("wns'" ["威尼斯"])
("wnwl" ["无能为力"])
("woai" ["我爱"])
("wobz" ["我辈" "我被"])
("woch" ["窝藏"])
("wode" ["我的"])
("wodh" ["我党"])
("wodk" ["卧倒"])
("wodp" ["沃顿"])
("woe'" "我")
("wofh" ["我方" "卧房"])
("wogo" ["我国"])
("wogs" ["窝工"])
("wohe" ["我和"])
("woho" ["窝火"])
("wohv" ["我会"])
("wojd" ["我将"])
("wojn" ["握紧"])
("wojp" ["我军"])
("wokb" ["倭寇"])
("wokj" ["我看"])
("woll" ["我来"])
("wolp" ["涡轮"])
("wolq" ["涡流"])
("womf" ["我们"])
("wonq" ["蜗牛"])
("wopg" ["窝棚"])
("wopu" ["卧铺"])
("woq'" "挝蜗涡窝倭莴喔")
("wor'" "哦斡卧握沃幄渥肟硪龌")
("woso" ["我所"])
("wotb" ["窝头"])
("woub" ["握手"])
("woui" ["我是" "卧式" "卧室"])
("wouo" ["我说"])
("wovu" ["握住"])
("wow'" "哦")
("wowo" ["莴莴"])
("woxd" ["我想"])
("woxr" ["斡旋"])
("wozl" ["我在"])
("wq'" ["完全"])
("wqby" ["为期不远"])
("wqtx" ["无期徒刑"])
("wqwj" ["无穷无尽"])
("wqxf" ["五权宪法"])
("wrf'" ["王若飞"])
("wrif" ["蔚然成风"])
("wrjj" ["无人驾驶飞机"])
("wrqt" ["误入歧途"])
("wrub" ["为人师表"])
("wsbd" ["纹丝不动"])
("wsbh" ["位似变换"])
("wslj" ["乌苏里江"])
("wsr'" ["王思任"])
("wsvx" ["位似中心"])
("wsw'" ["无所谓"])
("wsyd" ["五四运动"])
("wsyw" ["为所欲为"])
("wszw" ["无所作为"])
("wt'" ["问题"])
("wtb'" ["乌托邦"])
("wtf'" ["伍廷芳"])
("wth'" ["翁同和" "渥太华"])
("wtj'" ["挖土机" "无条件"])
("wtm'" ["外套膜"])
("wttd" ["五体投地"])
("wtu'" ["五台山"])
("wty'" ["吴庭艳"])
("wu'" ["卫生"])
("wub'" ["卫生部"])
("wuba" ["五霸"])
("wubi" ["无比" "五笔" "舞弊" "务必"])
("wubj" ["舞伴"])
("wubk" ["五保"])
("wubl" ["五百"])
("wubm" ["无边"])
("wubu" ["无补" "无不"])
("wubv" ["卫生标准"])
("wubz" ["吾辈" "武备"])
("wucj" ["午餐"])
("wucl" ["五彩"])
("wucs" ["无从"])
("wud'" ["汪士铎"])
("wuda" ["乌达" "武打"])
("wudb" ["武斗"])
("wude" ["武德"])
("wudi" ["无敌" "雾滴"])
("wudj" ["万事大吉"])
("wudk" ["舞蹈"])
("wudl" ["五代"])
("wudm" ["污点" "误点"])
("wudr" ["无端" "武断"])
("wuds" ["舞动" "勿动"])
("wudu" ["无毒" "无度" "五毒"])
("wudy" ["屋顶"])
("wue'" "武五捂午舞伍侮仵庑怃忤迕妩牾鹉")
("wuer" ["乌尔"])
("wufa" ["无法"])
("wufh" ["卫生防护" "无妨" "五方"])
("wufj" ["午饭"])
("wufy" ["卫生防疫"])
("wufz" ["无非"])
("wugb" ["污垢"])
("wugd" ["吴广"])
("wuge" ["五个"])
("wugg" ["五更"])
("wugh" ["钨钢"])
("wugk" ["诬告"])
("wugr" ["无关" "武关" "武官" "五官"])
("wugs" ["武功" "误工"])
("wugu" ["无辜" "无故" "五谷" "五梏"])
("wugv" ["乌龟"])
("wugy" ["无怪"])
("wuhb" ["屋后" "午后"])
("wuhj" ["吴晗" "武汉"])
("wuhl" ["无害"])
("wuhr" ["乌桓"])
("wuhu" ["呜呼" "芜湖"])
("wuhv" ["污秽" "舞会" "误会"])
("wuhw" ["物化"])
("wuhz" ["乌黑"])
("wui'" ["王世充"])
("wuia" ["误差"])
("wuig" ["无成"])
("wuih" ["无常" "无偿" "武昌" "五常" "舞场"])
("wuii" ["无耻" "舞池"])
("wuij" ["无产" "物产"])
("wujb" ["万事俱备"])
("wujd" ["乌江"])
("wuji" ["屋脊" "无机" "无稽" "无极" "无几" "无际"])
("wujm" ["无间" "舞剑" "物件"])
("wujn" ["武进" "五金"])
("wujt" ["五绝"])
("wuju" ["舞剧"])
("wujw" ["屋架" "物价"])
("wujx" ["误解"])
("wujy" ["物镜"])
("wuke" ["无可"])
("wukv" ["无愧"])
("wula" ["乌拉"])
("wulc" ["无聊"])
("wuld" ["无量" "五两"])
("wuli" ["污吏" "屋里" "无理" "无力" "武力" "物理" "物力"])
("wull" ["诬赖" "无赖"])
("wuln" ["武林"])
("wulp" ["无论" "物论"])
("wuls" ["乌龙" "五龙"])
("wulu" ["五路"])
("wulv" ["五律"])
("wuly" ["武陵" "五岭"])
("wum'" ["为什么"])
("wuma" ["误码"])
("wumf" ["午门"])
("wumm" ["屋面"])
("wumx" ["污蔑" "诬蔑"])
("wumy" ["无明" "无名"])
("wumz" ["吴梅" "妩媚"])
("wunb" ["五十年不变"])
("wung" ["无能"])
("wuni" ["污泥"])
("wunl" ["无奈"])
("wuns" ["务农"])
("wunv" ["舞女"])
("wupc" ["舞票"])
("wupn" ["物品"])
("wupo" ["巫婆"])
("wuq'" ["恶" "巫" "呜" "钨" "乌" "污" "诬" "屋" "兀" "邬" "圬" "於" "无霜期"])
("wuqi" ["吴起" "武器" "雾气"])
("wuqm" ["屋前" "无前" "五千" "午前"])
("wuqq" ["务求"])
("wuqr" ["无权"])
("wuqs" ["无穷"])
("wuqt" ["无缺"])
("wuqu" ["舞曲"])
("wuqy" ["无情"])
("wur'" "恶乌坞戊雾晤物勿务悟误兀阢芴寤婺骛杌焐鹜痦鋈")
("wurf" ["无人" "吾人" "武人" "误认"])
("wuri" ["无日"])
("wurj" ["污染"])
("wuru" ["污辱" "无如" "侮辱"])
("wus'" ["维生素" "卫生所"])
("wuse" ["无色" "五色" "物色"])
("wusi" ["钨丝" "无私" "五四"])
("wuss" ["吴淞" "武松"])
("wusu" ["乌苏"])
("wuta" ["无他"])
("wutb" ["务头"])
("wuti" ["物体"])
("wutl" ["五台" "舞台" "物态"])
("wuts" ["梧桐"])
("wuty" ["舞厅"])
("wuua" ["钨砂"])
("wuud" ["无双"])
("wuug" ["无声" "五声"])
("wuuh" ["无上"])
("wuui" ["无视" "武士" "五十" "午时" "伍拾" "物事" "务使" "误事"])
("wuuj" ["巫山"])
("wuuu" ["巫术" "无数" "武术"])
("wuuv" ["污水" "无水" "午睡"])
("wuv'" ["王士珍" "无上装"])
("wuvb" ["梧州" "五洲"])
("wuvd" ["武装"])
("wuve" ["捂着"])
("wuvg" ["物证"])
("wuvi" ["无知" "五指" "物质"])
("wuvo" ["污浊"])
("wuvs" ["无终" "吴中" "五中" "五种" "物种"])
("wuvu" ["五铢" "物主"])
("wuw'" "无芜梧吾吴亡毋捂唔浯蜈鼯")
("wuwh" ["无望"])
("wuwj" ["万寿无疆" "伍万"])
("wuwk" ["无时无刻"])
("wuwl" ["屋外"])
("wuwo" ["无我"])
("wuwu" ["呜呜" "无物" "无误"])
("wuwx" ["微生物学"])
("wuwz" ["无为" "无味" "无畏" "无谓" "武卫" "五味"])
("wuxc" ["无效"])
("wuxd" ["五香" "五项" "物象"])
("wuxm" ["诬陷" "无限" "无线" "吴县"])
("wuxn" ["无心"])
("wuxq" ["午休"])
("wuxu" ["无需" "无须" "戊戌" "务须"])
("wuxw" ["巫峡" "无暇"])
("wuxy" ["无形" "无行" "无性" "吴兴" "五星" "五刑" "五行" "悟性"])
("wuya" ["乌鸦"])
("wuye" ["午夜"])
("wuyi" ["无疑" "无意" "无益" "无异" "武艺" "五一"])
("wuyj" ["屋檐"])
("wuyn" ["五音"])
("wuyp" ["乌云"])
("wuyr" ["伍元"])
("wuys" ["无用" "毋庸" "误用"])
("wuyt" ["吴越" "五月"])
("wuyu" ["屋宇" "无余"])
("wuyy" ["五营"])
("wuzh" ["五脏"])
("wuzi" ["屋子" "舞姿" "物资" "误字"])
("wuzu" ["无阻"])
("wuzv" ["无罪"])
("wv'" ["位置"])
("wvb'" ["物质波"])
("wvbd" ["武装部队"])
("wvcf" ["物质财富"])
("wvdv" ["武装斗争"])
("wvft" ["无政府状态"])
("wvj'" ["王昭君" "无止境"])
("wvjg" ["网状结构"])
("wvjl" ["物质奖励"])
("wvll" ["武装力量" "物质力量"])
("wvql" ["武装侵略"])
("wvu'" ["未知数" "五指山"])
("wvuy" ["无中生有"])
("wvwq" ["完整无缺"])
("wvx'" ["魏忠贤"])
("wvyx" ["万众一心"])
("wwbv" ["无微不至"])
("wwd'" ["魏文帝"])
("wwez" ["维吾尔族"])
("wwl'" ["唯物论"])
("wwqq" ["弯弯曲曲" "完完全全"])
("wwr'" ["弯弯绕"])
("wwsv" ["玩物丧志"])
("wwug" ["唯物史观"])
("wwvv" ["唯物主义者"])
("wwvy" ["唯物主义"])
("wwyu" ["万无一失"])
("wwz'" ["五味子"])
("wx'" ["微型"])
("wxb'" ["王小波"])
("wxbf" ["戊戌变法"])
("wxd'" ["无现贷" "无限大" "无线电"])
("wxdb" ["无线电报" "无线电波" "无线电广播"])
("wxdh" ["无线电话"])
("wxdj" ["无线电接收机"])
("wxdt" ["无线电台"])
("wxdu" ["卫星电视"])
("wxdw" ["无线电定位"])
("wxdx" ["无线电电子学" "无线电通信"])
("wxf'" ["王熙凤"])
("wxhq" ["五星红旗"])
("wxid" ["卧薪尝胆"])
("wxj'" ["万向节" "微型机" "文学家"])
("wxl'" ["唯心论"])
("wxsj" ["维辛斯基"])
("wxtx" ["卫星通信"])
("wxu'" ["文学史"])
("wxug" ["唯心史观"])
("wxv'" ["无限制" "无休止"])
("wxvb" ["戊戌政变"])
("wxvy" ["唯心主义"])
("wxwk" ["问心无愧"])
("wxx'" ["危险性"])
("wxyz" ["五项原则"])
("wxzj" ["无性杂交"])
("wy'" ["无疑"])
("wydb" ["万用电表"])
("wydh" ["汪洋大海"])
("wydl" ["位移电流"])
("wyfx" ["文艺复兴"])
("wyh'" ["委员会"])
("wyj'" ["望远镜"])
("wyl'" ["外因论"])
("wyls" ["五颜六色"])
("wym'" ["王阳明" "无烟煤"])
("wyn'" ["王亚南" "维也纳"])
("wyu'" ["无意识" "五言诗"])
("wyv'" ["委员长"])
("wywg" ["无缘无故"])
("wywz" ["无影无踪"])
("wyyl" ["万有引力"])
("wyz'" ["无原则"])
("wz'" ["物资"])
("wzai" ["胃癌"])
("wzan" ["微安"])
("wzba" ["为把" "尾巴"])
("wzbi" ["威逼" "未必"])
("wzbm" ["未便"])
("wzbo" ["微薄" "微波"])
("wzbu" ["尾部"])
("wzby" ["胃病" "卫兵"])
("wzbz" ["违背"])
("wzcg" ["未曾"])
("wzci" ["为此" "位次"])
("wzda" ["伟大"])
("wzdc" ["萎雕"])
("wzdg" ["桅灯"])
("wzdk" ["味道" "卫道"])
("wzdl" ["微带"])
("wzdu" ["唯独" "惟独" "纬度"])
("wzdv" ["卫队"])
("wzdy" ["未定"])
("wze'" "唯苇萎委伟伪尾纬诿隗猥洧娓玮韪炜痿艉鲔")
("wzee" ["巍峨"])
("wzer" ["威尔"])
("wzfa" ["违法"])
("wzff" ["微分"])
("wzfg" ["威风" "微风"])
("wzfh" ["潍坊"])
("wzfj" ["违反" "违犯"])
("wzfu" ["微伏" "为辅"])
("wzgj" ["桅杆"])
("wzgo" ["魏国" "卫国"])
("wzgr" ["微观" "围观"])
("wzgs" ["围攻"])
("wzhe" ["为何"])
("wzhl" ["威海" "危害"])
("wzhp" ["未婚"])
("wzhu" ["维护" "卫护"])
("wzhv" ["委会"])
("wzig" ["围城"])
("wzih" ["未尝" "胃肠"])
("wzii" ["维持"])
("wzjc" ["围剿"])
("wzji" ["微机" "危机" "危及" "危急" "维系" "伟绩"])
("wzjm" ["围歼" "为间"])
("wzjn" ["围巾" "未尽"])
("wzjp" ["伪军"])
("wzjt" ["未决" "味觉"])
("wzju" ["畏惧"])
("wzjy" ["未经" "未竟" "味精" "胃镜"])
("wzkb" ["胃口"])
("wzkd" ["尾矿"])
("wzke" ["未可"])
("wzkf" ["围垦"])
("wzkh" ["违抗"])
("wzkp" ["围困"])
("wzks" ["唯恐" "惟恐"])
("wzl'" ["误字率"])
("wzlc" ["为了"])
("wzld" ["微量"])
("wzli" ["威力" "微粒" "违例" "为力"])
("wzlj" ["蔚蓝"])
("wzlk" ["慰劳"])
("wzll" ["未来"])
("wzlm" ["威廉"])
("wzlp" ["维纶"])
("wzmc" ["微秒" "微妙"])
("wzmi" ["微米" "纬密"])
("wzmm" ["未免"])
("wzmu" ["帷幕"])
("wzmy" ["为名"])
("wzna" ["维那"])
("wzng" ["未能" "位能"])
("wznj" ["危难" "为难" "畏难"])
("wznm" ["萎蔫"])
("wznn" ["为您"])
("wzpl" ["委派"])
("wzq'" "威巍微危萎委偎隈葳薇崴逶煨")
("wzqd" ["围墙"])
("wzqh" ["万紫千红"])
("wzqi" ["围棋" "围起" "为期" "尾气" "尾鳍"])
("wzqp" ["围裙"])
("wzqr" ["威权"])
("wzqu" ["委屈"])
("wzqv" ["无足轻重"])
("wzr'" "为未蔚味畏胃喂魏位渭谓尉慰卫遗猬軎")
("wzrf" ["为人" "委任" "伟人"])
("wzrj" ["巍然" "未然"])
("wzrk" ["围绕"])
("wzro" ["微弱"])
("wzso" ["萎缩" "畏缩" "卫所"])
("wzsr" ["胃酸"])
("wzsv" ["尾随" "未遂"])
("wzt'" ["武则天"])
("wztc" ["微调"])
("wzto" ["委托"])
("wzua" ["纬纱"])
("wzub" ["为首"])
("wzue" ["威慑"])
("wzug" ["微生" "为生" "尾声" "卫生"])
("wzui" ["威势" "为使" "委实" "未始" "卫士"])
("wzuj" ["伪善"])
("wzuu" ["为数" "尾数" "魏书" "卫戍"])
("wzuv" ["渭水"])
("wzvd" ["伪装"])
("wzve" ["围着" "为着"])
("wzvf" ["微震"])
("wzvg" ["伪证"])
("wzvh" ["违章"])
("wzvi" ["为之" "为止" "未知" "位置"])
("wzvs" ["为重"])
("wzvu" ["为主"])
("wzw'" "韦违桅围唯惟为潍维圩囗帏帷嵬闱沩涠")
("wzwf" ["慰问"])
("wzwh" ["威望" "危亡" "围网"])
("wzwj" ["委婉"])
("wzwo" ["为我"])
("wzwu" ["威武" "唯物"])
("wzwz" ["巍巍" "微微"])
("wzxc" ["微小" "微笑"])
("wzxd" ["位相"])
("wzxi" ["微细"])
("wzxm" ["危险" "违宪" "纬线"])
("wzxn" ["威信" "唯心" "维新"])
("wzxq" ["维修"])
("wzxw" ["威吓"])
("wzxx" ["威胁"])
("wzxy" ["微型" "卫星"])
("wzyb" ["惟有"])
("wzye" ["胃液"])
("wzyh" ["喂养"])
("wzyi" ["唯一" "尾翼" "位移"])
("wzyj" ["威严" "微言" "围岩" "胃炎"])
("wzyk" ["喂药"])
("wzyr" ["委员" "魏源"])
("wzyt" ["违约"])
("wzyu" ["位于" "谓语"])
("wzzi" ["位子"])
("wzzk" ["伪造"])
("x" "小")
("xaj'" ["新安江"])
("xal'" ["兴安岭"])
("xald" ["心安理得"])
("xau'" ["巡按使" "西安市"])
("xb'" ["性别"])
("xbb'" ["细胞壁"])
("xbc'" ["小白菜"])
("xbd'" ["信不得"])
("xbf'" ["西北风"])
("xbfl" ["细胞分裂"])
("xbh'" ["细胞核"])
("xbi'" ["薛宝钗"])
("xbly" ["西伯利亚"])
("xbm'" ["细胞膜"])
("xbn'" ["萧伯纳"])
("xbq'" ["细胞器"])
("xbs'" ["选拔赛"])
("xbt'" ["细胞体" "想不通" "心不跳" "行不通"])
("xbu'" ["小白鼠"])
("xbv'" ["细胞质"])
("xbvx" ["相比之下"])
("xbwq" ["小步舞曲"])
("xbx'" ["细胞学"])
("xby'" ["西班牙" "细胞液" "下半夜"])
("xbz'" ["小辫子"])
("xbzy" ["心不在焉"])
("xc'" ["下次"])
("xcbh" ["肖邦"])
("xcbj" ["小班" "小半"])
("xcbk" ["小报"])
("xcbl" ["小白"])
("xcbm" ["小便"])
("xcbu" ["小步"])
("xcdc" ["小调"])
("xcde" ["晓得"])
("xcdg" ["小凳"])
("xcdi" ["小弟" "孝弟"])
("xcdk" ["小刀" "小道"])
("xcds" ["小东"])
("xcdu" ["消毒"])
("xcdv" ["小队"])
("xcdy" ["销钉"])
("xce'" "晓小筱")
("xcer" ["小儿"])
("xcfa" ["效法"])
("xcfg" ["校风"])
("xcfh" ["消防" "效仿"])
("xcfj" ["小贩"])
("xcfu" ["小腹"])
("xcfz" ["消费"])
("xcgb" ["小狗"])
("xcgj" ["孝感"])
("xcgo" ["效果"])
("xcgs" ["小工" "小功"])
("xcgu" ["小姑"])
("xcgv" ["小鬼"])
("xchd" ["小黄"])
("xche" ["小河"])
("xchk" ["消耗" "小号"])
("xchl" ["小孩"])
("xcho" ["小伙"])
("xchs" ["萧红"])
("xchu" ["小湖" "小户"])
("xchv" ["销毁"])
("xchw" ["硝化" "消化" "笑话"])
("xcib" ["小丑"])
("xcie" ["小车"])
("xcif" ["消沉"])
("xcig" ["小城"])
("xcih" ["小肠"])
("xcii" ["小吃"])
("xcip" ["小春"])
("xcir" ["哮喘" "小船"])
("xciu" ["消除"])
("xcjc" ["小脚"])
("xcjd" ["小将"])
("xcji" ["硝基" "消极"])
("xcjm" ["小建"])
("xcjn" ["消禁" "小金"])
("xcjx" ["小节" "小结" "小解" "小姐"])
("xcjy" ["小井" "孝经" "孝敬"])
("xcke" ["小可"])
("xckh" ["小康"])
("xckj" ["小看"])
("xcld" ["小量"])
("xcli" ["效力"])
("xclk" ["效劳"])
("xclm" ["孝廉" "笑脸"])
("xcln" ["笑林"])
("xclu" ["销路"])
("xclv" ["效率"])
("xcmi" ["小米"])
("xcmk" ["小猫" "小毛" "笑貌"])
("xcml" ["小麦"])
("xcmo" ["消磨"])
("xcmx" ["消灭"])
("xcmy" ["小名"])
("xcng" ["效能"])
("xcnk" ["小脑"])
("xcns" ["小农"])
("xcpn" ["小品"])
("xcq'" "萧硝霄削哮嚣销消宵肖哓潇逍骁绡枭枵蛸箫魈")
("xcqc" ["小巧"])
("xcqi" ["小气"])
("xcqm" ["消遣"])
("xcqu" ["小曲"])
("xcr'" "孝校肖啸笑效")
("xcrf" ["小人"])
("xcro" ["消弱"])
("xcrs" ["笑容"])
("xcsa" ["萧洒"])
("xcsj" ["消散"])
("xcsr" ["硝酸"])
("xcsv" ["小穗"])
("xctb" ["小偷"])
("xctc" ["萧条"])
("xcti" ["小体"])
("xctv" ["消退" "小腿"])
("xcty" ["小艇"])
("xcub" ["销售" "消瘦"])
("xcue" ["校舍"])
("xcug" ["小声" "小生"])
("xcui" ["硝石" "消失" "消逝" "小时"])
("xcuo" ["小说"])
("xcup" ["孝顺"])
("xcuu" ["小书" "小数"])
("xcuv" ["小水"])
("xcvh" ["嚣张" "消长" "小张" "校长"])
("xcvi" ["小指"])
("xcvj" ["小站"])
("xcvs" ["消肿" "效忠"])
("xcw'" "淆崤")
("xcwh" ["消亡"])
("xcwl" ["校外"])
("xcwu" ["小五"])
("xcx'" ["修辞学"])
("xcxc" ["萧萧" "小小"])
("xcxd" ["小项" "肖像"])
("xcxi" ["消息" "小溪" "小戏"])
("xcxm" ["消闲"])
("xcxn" ["小心"])
("xcxs" ["小熊"])
("xcxt" ["小学"])
("xcxx" ["小写"])
("xcxy" ["小型"])
("xcya" ["小雅"])
("xcyb" ["校友"])
("xcye" ["小叶"])
("xcyh" ["小样"])
("xcyi" ["效益"])
("xcyj" ["硝烟"])
("xcyk" ["逍遥"])
("xcyr" ["校园"])
("xcys" ["效用"])
("xcyu" ["小于" "小雨" "笑语"])
("xcyy" ["效应"])
("xcz'" ["小册子"])
("xczh" ["销赃"])
("xczi" ["销子" "小子" "小字" "孝子"])
("xczu" ["小组"])
("xd'" ["许多"])
("xdai" ["相爱"])
("xdan" ["香案"])
("xdbh" ["相帮"])
("xdbi" ["相比"])
("xdbm" ["相变"])
("xdbz" ["向北" "向背"])
("xdcl" ["香菜"])
("xdcp" ["乡村"])
("xdd'" ["想得到" "小弟弟" "兄弟党"])
("xddg" ["相等"])
("xddh" ["相当" "乡党"])
("xddi" ["相抵" "箱底"])
("xddk" ["想到" "向导"])
("xdds" ["响动" "向东"])
("xddv" ["相对"])
("xde'" "想响享饷鲞飨")
("xdey" ["相对而言"])
("xdfa" ["想法"])
("xdfg" ["相逢"])
("xdfh" ["相仿" "厢房"])
("xdfj" ["相反" "襄樊"])
("xdfu" ["降服" "相符" "享福"])
("xdge" ["相隔"])
("xdgh" ["香港"])
("xdgj" ["相干"])
("xdgo" ["相国"])
("xdgr" ["相关" "象管"])
("xdgs" ["相公"])
("xdgu" ["香菇"])
("xdgy" ["现代工业"])
("xdh'" ["现代化"])
("xdhb" ["向后"])
("xdhe" ["相合"])
("xdhk" ["相好"])
("xdho" ["向火"])
("xdhu" ["相互"])
("xdhv" ["相会"])
("xdhw" ["香花"])
("xdi'" ["蓄电池"])
("xdia" ["相差"])
("xdie" ["响彻"])
("xdif" ["相称"])
("xdig" ["相成" "相乘" "项城"])
("xdii" ["相持"])
("xdir" ["相传"])
("xdiu" ["相除" "相处" "想出"])
("xdj'" ["洗涤剂" "辛迪加"])
("xdjc" ["相交" "香蕉" "橡胶"])
("xdjd" ["湘江"])
("xdji" ["相机" "相继"])
("xdjm" ["相间" "相减" "乡间" "想见"])
("xdjn" ["相近" "详尽"])
("xdjp" ["香军"])
("xdju" ["相聚" "相距"])
("xdjw" ["相加"])
("xdjx" ["相接" "详解"])
("xdjy" ["香精"])
("xdkb" ["巷口"])
("xdl'" ["相电流" "相对论" "新德里"])
("xdlc" ["香料"])
("xdld" ["响亮" "向量"])
("xdle" ["享乐"])
("xdli" ["乡里"])
("xdll" ["想来" "向来"])
("xdlm" ["相连" "项链"])
("xdln" ["相临"])
("xdlu" ["香炉"])
("xdlv" ["相率"])
("xdmk" ["相貌" "香茅"])
("xdmm" ["相面"])
("xdmu" ["项目"])
("xdnm" ["想念"])
("xdny" ["现代农业"])
("xdpi" ["橡皮"])
("xdpm" ["相片" "像片"])
("xdq'" "相厢镶香箱襄湘乡芗葙骧缃")
("xdqi" ["香气" "想起" "象棋"])
("xdqm" ["镶嵌" "向前"])
("xdqn" ["相亲" "乡亲"])
("xdqu" ["想去"])
("xdqx" ["相切"])
("xdqy" ["详情"])
("xdr'" ["相" "项" "巷" "橡" "像" "向" "象" "蟓" "现代人" "想当然"])
("xdrf" ["乡人" "象人"])
("xdri" ["向日"])
("xdrs" ["相容"])
("xdsd" ["相对速度"])
("xdsi" ["相似"])
("xdtb" ["想头"])
("xdtj" ["湘潭" "详谈"])
("xdtm" ["香甜"])
("xdts" ["相通" "相同"])
("xdtu" ["乡土" "详图"])
("xdu'" ["下毒手" "现代诗" "相对数"])
("xdub" ["享受"])
("xdud" ["相对湿度"])
("xduf" ["乡绅"])
("xdug" ["相声" "响声" "象生"])
("xduh" ["向上"])
("xdui" ["相识"])
("xduj" ["香山" "象山"])
("xduu" ["橡树"])
("xduv" ["香水"])
("xdv'" ["小队长"])
("xdve" ["向着"])
("xdvf" ["乡镇"])
("xdvg" ["象征"])
("xdvh" ["乡长"])
("xdvs" ["相中"])
("xdvu" ["相助"])
("xdw'" "降翔祥详庠")
("xdwh" ["相望" "想望" "向往"])
("xdwi" ["相对误差"])
("xdwk" ["先睹为快"])
("xdwz" ["相位" "香味"])
("xdx'" ["现代戏" "相对性"])
("xdxd" ["相象" "想像" "想象"])
("xdxi" ["详悉" "详细" "向西"])
("xdxm" ["象限"])
("xdxn" ["相信"])
("xdxt" ["向学"])
("xdxv" ["相对性状"])
("xdxw" ["乡下" "向下"])
("xdxx" ["向斜"])
("xdxy" ["相形" "向性" "象形"])
("xdya" ["镶牙" "象牙"])
("xdyb" ["香油" "享有" "向右"])
("xdyd" ["相对运动"])
("xdyh" ["襄阳" "向阳" "象样"])
("xdyi" ["相依" "相宜"])
("xdyj" ["相沿" "香烟"])
("xdyk" ["想要"])
("xdyn" ["乡音"])
("xdyp" ["湘云"])
("xdys" ["乡勇" "享用" "向用"])
("xdyt" ["相约"])
("xdyu" ["相与" "相遇" "项羽"])
("xdyy" ["相应" "响应"])
("xdzi" ["箱子"])
("xdzj" ["信贷资金"])
("xdzk" ["香皂"])
("xdzo" ["向左"])
("xe'" ["限额"])
("xebt" ["希尔伯特"])
("xeux" ["形而上学"])
("xeyj" ["显而易见"])
("xf'" ["相反"])
("xfd'" ["先锋队" "小分队"])
("xfdg" ["宪法大纲"])
("xfe'" ["媳妇儿"])
("xfgj" ["西方国家"])
("xfi'" ["薛福成"])
("xfj'" ["吸附剂"])
("xfl'" ["消费量"])
("xfp'" ["消费品"])
("xft'" ["希法亭"])
("xfu'" ["吸附水"])
("xfuf" ["想方设法"])
("xfv'" ["刑法志"])
("xfvr" ["先发制人"])
("xfxi" ["相辅相成"])
("xfy'" ["悬浮液"])
("xfzl" ["消费资料" "兴风作浪"])
("xg'" ["修改"])
("xgcl" ["兴高采烈"])
("xgf'" ["习惯法"])
("xgi'" ["吸管虫"])
("xgil" ["宣告成立"])
("xgj'" ["膝关节"])
("xgl'" ["小高炉"])
("xgn'" ["小姑娘"])
("xgx'" ["习惯性"])
("xh'" ["消化"])
("xhbl" ["消化不良"])
("xhc'" ["杏花村"])
("xhd'" ["信号弹" "信号灯"])
("xhdb" ["血红蛋白"])
("xhgm" ["辛亥革命"])
("xhj'" ["溴化钾"])
("xhl'" ["续航力"])
("xhq'" ["信号枪" "循环气"])
("xhr'" ["消耗热"])
("xhsb" ["腥黑穗病"])
("xhu'" ["西红柿" "新华社"])
("xhud" ["新华书店"])
("xhw'" ["溴化物"])
("xhxt" ["消化系统" "信号系统" "循环系统"])
("xhxu" ["循环小数"])
("xhy'" ["小黄鱼" "溴化银"])
("xhyl" ["心慌意乱" "巡回医疗"])
("xhz'" ["小伙子"])
("xhzy" ["相互作用"])
("xi'" ["形成"])
("xiai" ["喜爱"])
("xian" ["西安" "西岸"])
("xib'" ["线虫病" "宣传部"])
("xibj" ["戏班"])
("xibk" ["喜报" "细胞"])
("xibm" ["西边"])
("xibo" ["锡箔" "稀薄"])
("xibu" ["西部" "细布" "细部"])
("xibx" ["惜别"])
("xibz" ["西北"])
("xic'" ["形成层"])
("xici" ["系词"])
("xicj" ["西餐"])
("xid'" ["宣传队"])
("xide" ["西德"])
("xidg" ["熄灯"])
("xidi" ["席地" "洗涤"])
("xidj" ["西单"])
("xidk" ["铣刀"])
("xidx" ["新陈代谢"])
("xie'" "喜铣洗葸蓰徙屣玺禧")
("xier" ["希尔"])
("xifa" ["西法" "戏法"])
("xifg" ["西风"])
("xifh" ["西方"])
("xifj" ["稀饭"])
("xifu" ["西服" "吸附" "媳妇"])
("xifz" ["西非"])
("xigb" ["西沟"])
("xigh" ["矽钢"])
("xigl" ["膝盖"])
("xigr" ["吸管" "习惯"])
("xigw" ["西瓜"])
("xihj" ["稀罕" "希罕"])
("xihk" ["喜好"])
("xihl" ["西海"])
("xiho" ["熄火"])
("xihr" ["喜欢"])
("xihu" ["西湖"])
("xii'" ["兴冲冲"])
("xiid" ["铣床"])
("xiif" ["洗尘"])
("xiig" ["西城"])
("xiih" ["细长"])
("xiiu" ["析出"])
("xiiv" ["西垂"])
("xij'" ["熊成基"])
("xijc" ["西郊"])
("xijd" ["西江"])
("xiji" ["袭击"])
("xijm" ["习见"])
("xijn" ["西晋"])
("xijp" ["细菌"])
("xijq" ["喜酒"])
("xijr" ["席卷"])
("xiju" ["喜剧" "戏剧"])
("xijx" ["洗劫" "细节"])
("xijy" ["西京" "西经"])
("xikd" ["锡矿"])
("xikg" ["行程开关"])
("xil'" ["新潮流"])
("xila" ["希腊"])
("xile" ["席勒"])
("xili" ["西里" "西历" "吸力" "犀利" "洗礼"])
("xilm" ["洗脸"])
("xiln" ["锡林"])
("xilo" ["奚落"])
("xilq" ["溪流"])
("xilx" ["系列"])
("ximf" ["西门"])
("ximg" ["西蒙"])
("ximi" ["细密"])
("ximk" ["细毛"])
("ximm" ["西面"])
("ximn" ["细民"])
("ximo" ["吸墨"])
("ximu" ["析木"])
("ximx" ["熄灭"])
("ximz" ["洗煤"])
("xinf" ["细嫩"])
("xini" ["细腻"])
("xinj" ["西南"])
("xinq" ["犀牛"])
("xins" ["戏弄"])
("xiny" ["西宁"])
("xiou" ["西欧"])
("xip'" ["新产品" "畜产品"])
("xipi" ["西皮"])
("xipj" ["吸盘"])
("xiq'" ["腊" "栖" "昔" "熙" "析" "西" "硒" "矽" "晰" "嘻" "吸" "锡" "牺" "稀" "息" "希" "悉" "膝" "夕" "惜" "熄" "烯" "溪" "汐" "犀" "僖" "兮" "郗" "茜" "菥" "奚" "唏" "浠" "淅" "嬉" "樨" "曦" "欷" "歙" "熹" "皙" "穸" "蜥" "螅" "蟋" "舾" "羲" "粞" "翕" "醯" "蹊" "鼷" "西城区"])
("xiqi" ["吸气" "稀奇" "习气" "喜气"])
("xiqt" ["喜鹊"])
("xiqu" ["吸取" "戏曲"])
("xiqy" ["喜庆"])
("xir'" "系隙戏细饩阋禊舄")
("xire" ["吸热"])
("xirf" ["袭人" "喜人"])
("xiri" ["昔日"])
("xirj" ["洗染"])
("xiro" ["细弱"])
("xirr" ["细软"])
("xirs" ["西戎"])
("xisr" ["矽酸"])
("xisu" ["习俗"])
("xisv" ["细碎"])
("xit'" ["小朝廷"])
("xiti" ["习题"])
("xitl" ["戏台"])
("xitm" ["西天"])
("xits" ["系统"])
("xitu" ["希图"])
("xity" ["烯烃"])
("xiua" ["细纱"])
("xiub" ["吸收" "洗手"])
("xiug" ["牺牲"])
("xiui" ["西施" "西式" "吸湿" "吸食" "稀释" "喜事"])
("xiuj" ["西山"])
("xiuk" ["稀少"])
("xiup" ["吸吮"])
("xiuu" ["稀疏" "系数"])
("xiuv" ["吸水" "溪水" "浠水"])
("xiuw" ["洗刷"])
("xivb" ["西周"])
("xivd" ["西装"])
("xivi" ["细致"])
("xiw'" "檄袭席习媳隰觋")
("xiwf" ["西文" "檄文"])
("xiwh" ["希望"])
("xiww" ["喜出望外"])
("xiwz" ["西魏" "席位" "细微"])
("xixc" ["细小"])
("xixi" ["嘻嘻" "细细" "嬉戏"])
("xixm" ["细线"])
("xixn" ["悉心" "细心"])
("xixp" ["喜讯"])
("xixr" ["洗选"])
("xixt" ["西学"])
("xixw" ["西夏"])
("xixy" ["习性"])
("xiy'" ["宣传员"])
("xiya" ["西亚"])
("xiyb" ["稀有"])
("xiyh" ["昔阳" "西洋" "夕阳"])
("xiyi" ["西医" "洗衣"])
("xiyj" ["吸烟"])
("xiyk" ["西药"])
("xiyn" ["吸引"])
("xiyr" ["戏院"])
("xiys" ["袭用" "习用"])
("xiyt" ["喜悦"])
("xiyu" ["西域" "细雨"])
("xize" ["细则"])
("xizh" ["西藏"])
("xizi" ["席子" "喜子" "戏子"])
("xizk" ["洗澡"])
("xizo" ["习作"])
("xj'" ["现金"])
("xjb'" ["硝基苯"])
("xjd'" ["现阶段"])
("xjf'" ["选举法"])
("xjgl" ["现金管理"])
("xji'" ["小轿车"])
("xjj'" ["雄赳赳"])
("xjjt" ["先进集体"])
("xjl'" ["下脚料" "下结论"])
("xjp'" ["新加坡"])
("xjq'" ["选举权"])
("xjrt" ["心惊肉跳"])
("xjs'" ["性激素"])
("xjt'" ["小集团" "小家庭"])
("xju'" ["橡胶树" "新技术"])
("xjv'" ["选举制"])
("xjvd" ["选举制度"])
("xjvm" ["先见之明"])
("xjw'" ["溴甲烷"])
("xjxc" ["献计献策"])
("xjy'" ["香精油" "新纪元" "心肌炎"])
("xjzg" ["选举资格"])
("xk'" ["现款"])
("xkj'" ["小口径"])
("xkv'" ["许可证"])
("xkw'" ["熊克武"])
("xl'" ["线路"])
("xlb'" ["训练班"])
("xlf'" ["洗理费"])
("xlh'" ["系列化" "心里话" "雪里红"])
("xlhl" ["稀里哗啦"])
("xlht" ["稀里糊涂"])
("xlib" ["兴利除弊"])
("xlp'" ["小老婆"])
("xlq'" ["现蕾期"])
("xlqb" ["星罗棋布"])
("xlr'" ["希腊人"])
("xlt'" ["线粒体"])
("xlx'" ["心理学" "心连心"])
("xlxf" ["狭路相逢"])
("xlxy" ["西里西亚"])
("xly'" ["夏令营" "叙利亚"])
("xm'" ["姓名"])
("xmai" ["腺癌"])
("xmby" ["馅饼" "宪兵"])
("xmbz" ["先辈" "鲜卑"])
("xmc'" ["新名词"])
("xmce" ["献策"])
("xmci" ["献词"])
("xmcl" ["咸菜" "线材" "苋菜"])
("xmcp" ["现存"])
("xmdc" ["掀掉"])
("xmde" ["显得"])
("xmdj" ["咸淡"])
("xmdk" ["先导"])
("xmdl" ["现代"])
("xmdr" ["先端" "线段"])
("xmds" ["掀动"])
("xmdu" ["限度"])
("xmdy" ["限定"])
("xme'" "铣洗鲜显险冼藓猃燹蚬筅跣")
("xmee" ["险恶" "限额"])
("xmfa" ["宪法"])
("xmfg" ["先锋" "咸丰"])
("xmgo" ["仙果" "鲜果"])
("xmgr" ["县官"])
("xmgs" ["先公" "闲工"])
("xmgu" ["仙姑"])
("xmgv" ["显贵"])
("xmgz" ["献给"])
("xmhb" ["先后"])
("xmhe" ["显赫"])
("xmhl" ["咸海" "陷害"])
("xmho" ["现货"])
("xmhs" ["鲜红"])
("xmhv" ["贤慧"])
("xmhw" ["仙花" "鲜花" "闲话" "献花"])
("xmi'" ["纤毛虫"])
("xmid" ["舷窗"])
("xmig" ["现成" "县城"])
("xmih" ["现场"])
("xmis" ["线虫"])
("xmiu" ["显出"])
("xmjc" ["现浇"])
("xmjd" ["先将" "现将"])
("xmji" ["献计"])
("xmjm" ["先见" "显见" "线间"])
("xmjn" ["先进" "现金" "现今"])
("xmjp" ["险峻"])
("xmjt" ["先决"])
("xmjx" ["衔接" "限界"])
("xmjy" ["仙境" "险境" "现经" "陷阱"])
("xmkl" ["掀开"])
("xmkr" ["现款"])
("xmld" ["鲜亮" "限量"])
("xmli" ["先例" "献礼"])
("xmlo" ["陷落"])
("xmlu" ["喜马拉雅山" "显露" "线路"])
("xmlx" ["先烈"])
("xmly" ["先令" "县令" "限令"])
("xmm'" ["笑眯眯"])
("xmmk" ["纤毛"])
("xmmu" ["羡慕"])
("xmmy" ["鲜明" "显明"])
("xmmz" ["鲜美" "献媚"])
("xmnf" ["鲜嫩"])
("xmng" ["贤能"])
("xmnv" ["仙女"])
("xmny" ["咸宁"])
("xmq'" "掀锨先仙鲜纤莶暹氙祆籼酰跹")
("xmqi" ["掀起" "先期" "嫌弃" "限期"])
("xmqm" ["先前" "先遣" "现钱"])
("xmqn" ["先秦" "弦琴"])
("xmqr" ["线圈"])
("xmqu" ["先驱" "县区"])
("xmqy" ["险情"])
("xmr'" "见现献县腺馅羡宪陷限线苋岘霰")
("xmrf" ["先人" "仙人" "贤人" "闲人" "现任"])
("xmrj" ["显然"])
("xmru" ["陷入"])
("xmsj" ["闲散"])
("xmso" ["线索"])
("xmtb" ["先头" "线头"])
("xmtc" ["线条"])
("xmti" ["舷梯"])
("xmtj" ["闲谈" "险滩"])
("xmtm" ["先天"])
("xmtx" ["衔铁"])
("xmub" ["先手"])
("xmuf" ["献身"])
("xmug" ["先声" "先生" "线绳"])
("xmuh" ["先上"])
("xmui" ["先是" "闲事" "显示" "现时" "现实" "现世"])
("xmuv" ["咸水"])
("xmv'" ["新民主"])
("xmvd" ["现状"])
("xmvg" ["宪政"])
("xmvh" ["县长" "宪章"])
("xmvi" ["先知" "闲置" "县志" "限止" "限制"])
("xmvu" ["显著"])
("xmw'" "咸贤衔舷闲涎弦嫌娴鹇痫")
("xmwz" ["纤维" "显微" "现为" "县委" "限位"])
("xmxd" ["显像" "现象"])
("xmxi" ["纤细"])
("xmxm" ["显现"])
("xmxt" ["鲜血" "显学"])
("xmxx" ["险些"])
("xmxy" ["先行" "显性" "现形" "现行" "限性" "线型" "线形" "线性"])
("xmy'" ["细毛羊" "畜牧业"])
("xmyb" ["现有"])
("xmyh" ["咸阳"])
("xmyi" ["嫌疑" "现已" "现役"])
("xmyj" ["先验" "鲜艳" "显眼"])
("xmyk" ["先要" "显要" "险要"])
("xmyt" ["弦乐"])
("xmyu" ["限于"])
("xmyy" ["显影"])
("xmyz" ["心满意足"])
("xmza" ["闲杂"])
("xmzl" ["现在"])
("xmzu" ["险阻"])
("xn'" ["性能"])
("xnai" ["心爱"])
("xnal" ["喜怒哀乐"])
("xnan" ["新安"])
("xnbj" ["锌版" "新版"])
("xnbk" ["心包"])
("xnbn" ["新宾"])
("xnby" ["新兵"])
("xnci" ["新词"])
("xncl" ["心裁"])
("xncp" ["新村"])
("xncs" ["信从"])
("xnde" ["新的" "心得"])
("xndi" ["新地" "心底" "心地"])
("xndk" ["新道"])
("xndl" ["信贷"])
("xnds" ["新东" "心动"])
("xndu" ["新都"])
("xner" ["心耳"])
("xnfa" ["新发"])
("xnfg" ["新丰" "信封" "信奉"])
("xnfh" ["新房" "心房"])
("xnfu" ["新妇" "心服" "心腹" "信服"])
("xnfv" ["西南非洲"])
("xngd" ["新光"])
("xngj" ["心肝"])
("xngv" ["新贵"])
("xnhd" ["心慌"])
("xnhk" ["信号"])
("xnhl" ["辛亥"])
("xnhp" ["新婚"])
("xnhv" ["新会"])
("xnhw" ["新华" "新化"])
("xnhy" ["心怀"])
("xnib" ["辛丑"])
("xnig" ["新城"])
("xnih" ["心肠"])
("xnik" ["心潮"])
("xnip" ["新春"])
("xnj'" ["许乃济"])
("xnjc" ["新教"])
("xnjd" ["新疆"])
("xnji" ["心机" "心肌" "心急"])
("xnjj" ["小农经济"])
("xnjm" ["新建" "信件"])
("xnjn" ["薪金" "新津" "新进" "新近"])
("xnjp" ["新军"])
("xnjq" ["新旧"])
("xnju" ["新居"])
("xnjy" ["新经" "心境"])
("xnkb" ["心口"])
("xnkj" ["心坎"])
("xnkl" ["新开"])
("xnku" ["辛苦"])
("xnla" ["辛辣"])
("xnlh" ["新郎"])
("xnli" ["心理" "心里" "心力"])
("xnlk" ["辛劳" "新老"])
("xnll" ["信赖"])
("xnlo" ["新罗"])
("xnly" ["心灵"])
("xnm'" ["心内膜"])
("xnmu" ["心目"])
("xnnd" ["新娘"])
("xnnm" ["新年" "信念"])
("xnpm" ["芯片"])
("xnq'" "薪芯锌欣辛新忻心馨昕歆鑫")
("xnqi" ["新奇"])
("xnqn" ["辛勤"])
("xnqx" ["心切"])
("xnqy" ["新青" "心情"])
("xnr'" "芯信衅囟")
("xnrf" ["新人" "信任"])
("xnrj" ["欣然"])
("xnsi" ["心思" "寻思"])
("xnsr" ["辛酸" "心酸" "心算"])
("xntb" ["心头"])
("xntc" ["心跳" "信条"])
("xntg" ["心疼"])
("xntm" ["新天"])
("xnto" ["信托"])
("xntu" ["心土" "信徒"])
("xnu'" ["西宁市"])
("xnua" ["新沙"])
("xnub" ["新手"])
("xnuf" ["心神"])
("xnug" ["新生" "心声"])
("xnuh" ["欣赏"])
("xnui" ["新诗" "新式" "新市" "心事" "心室"])
("xnuu" ["新书" "心术"])
("xnuv" ["薪水"])
("xnvb" ["心轴"])
("xnvd" ["新装"])
("xnvg" ["新政"])
("xnvi" ["信纸"])
("xnvs" ["心中"])
("xnw'" "寻镡")
("xnwf" ["新闻"])
("xnwz" ["欣慰"])
("xnxd" ["新乡" "心想" "信箱"])
("xnxi" ["欣喜" "信息"])
("xnxm" ["新鲜"])
("xnxn" ["信心"])
("xnxs" ["心胸"])
("xnxt" ["新学" "心学" "心血"])
("xnxu" ["心虚" "心绪"])
("xnxy" ["新星" "新兴" "新型" "心性"])
("xnyb" ["辛酉"])
("xnyh" ["信阳" "信仰"])
("xnyi" ["新异" "心意" "信义"])
("xnyr" ["心愿"])
("xnys" ["信用"])
("xnyt" ["新月"])
("xnyu" ["信誉"])
("xnyy" ["新颖"])
("xnzh" ["心脏"])
("xnzi" ["芯子"])
("xpbu" ["巡捕"])
("xpdk" ["训导"])
("xpfh" ["寻访"])
("xpfu" ["驯服" "巡抚"])
("xpgo" ["殉国"])
("xpgu" ["训诂"])
("xph'" ["相平衡"])
("xphh" ["巡航"])
("xphr" ["循环"])
("xphv" ["巡回"])
("xphw" ["驯化" "训话"])
("xpi'" ["修配厂"])
("xpia" ["巡查"])
("xpih" ["寻常"])
("xpii" ["训斥"])
("xpjm" ["巡检"])
("xpjx" ["殉节"])
("xpjy" ["巡警"])
("xpkd" ["荀况"])
("xpkj" ["旬刊"])
("xpl'" ["下坡路"])
("xplm" ["训练"])
("xplo" ["巡逻"])
("xply" ["训令"])
("xpma" ["驯马"])
("xpmg" ["迅猛"])
("xpmi" ["寻觅"])
("xpnj" ["殉难"])
("xpq'" "荤勋熏埙薰獯曛窨醺")
("xpqh" ["心平气和"])
("xpqi" ["汛期"])
("xpqq" ["寻求"])
("xpr'" "浚熏殉汛训讯逊迅巽蕈徇")
("xpri" ["旬日"])
("xpse" ["逊色"])
("xpsi" ["徇私"])
("xpsu" ["迅速"])
("xptk" ["熏陶"])
("xpui" ["寻视" "巡视"])
("xpuk" ["巡哨"])
("xpup" ["驯顺"])
("xpv'" ["线膨胀"])
("xpvg" ["熏蒸" "训政"])
("xpvh" ["勋章"])
("xpvi" ["寻址" "殉职"])
("xpvk" ["寻找"])
("xpw'" "循旬询寻驯巡郇荀峋恂洵浔鲟")
("xpwf" ["询问" "讯问"])
("xpxu" ["循序"])
("xpxy" ["巡行"])
("xpy'" ["小朋友"])
("xpyb" ["巡游"])
("xpye" ["巡夜"])
("xpyh" ["驯养"])
("xpyi" ["寻一"])
("xpzh" ["殉葬"])
("xpzi" ["荀子"])
("xq'" ["星期"])
("xqbu" ["修补"])
("xqby" ["锈病"])
("xqci" ["修辞"])
("xqcl" ["秀才"])
("xqde" ["休得"])
("xqdy" ["修订"])
("xqe'" "宿朽")
("xqfu" ["修复"])
("xqgl" ["修改"])
("xqh'" ["小气候"])
("xqhk" ["修好"])
("xqhv" ["休会"])
("xqhw" ["绣花"])
("xqie" ["修车"])
("xqig" ["修成"])
("xqii" ["羞耻"])
("xqir" ["修船"])
("xqj'" ["弦切角" "向前进"])
("xqjm" ["修剪" "修建"])
("xqjt" ["嗅觉"])
("xqjw" ["休假"])
("xqk'" ["向前看"])
("xqkb" ["袖口"])
("xqkv" ["羞愧"])
("xqli" ["修理" "秀丽"])
("xqlu" ["修路"])
("xqmm" ["休眠"])
("xqmo" ["休谟"])
("xqmu" ["朽木"])
("xqpz" ["修配"])
("xqq'" "休修羞咻馐庥鸺貅髹")
("xqqi" ["秀气"])
("xqqq" ["绣球"])
("xqqx" ["羞怯"])
("xqr'" ["臭" "宿" "嗅" "锈" "秀" "袖" "绣" "岫" "溴" "星期日"])
("xqru" ["羞辱"])
("xqse" ["羞涩"])
("xqsr" ["溴酸"])
("xqti" ["修蹄"])
("xqu'" ["小秋收"])
("xqub" ["袖手"])
("xquf" ["修身"])
("xqui" ["修饰"])
("xquj" ["修缮"])
("xquv" ["修水" "溴水"])
("xqvf" ["袖珍"])
("xqvg" ["休整" "修整" "修正"])
("xqvi" ["休止"])
("xqvu" ["修筑"])
("xqxd" ["休想"])
("xqxi" ["休息"])
("xqxm" ["休闲"])
("xqxq" ["修修"])
("xqxt" ["休学"])
("xqxy" ["修行"])
("xqye" ["休业"])
("xqyh" ["休养" "修养"])
("xqyk" ["休要"])
("xqyy" ["喜气洋洋"])
("xqzi" ["袖子"])
("xqzk" ["修造"])
("xr'" ["显然"])
("xran" ["悬案"])
("xrba" ["选拔"])
("xrbf" ["选本"])
("xrbi" ["悬臂"])
("xrbu" ["宣布"])
("xrcl" ["选材"])
("xrde" ["宣德"])
("xrdu" ["宣读" "选读"])
("xrdy" ["选定"])
("xre'" "选癣")
("xrff" ["想入非非"])
("xrfg" ["旋风"])
("xrfu" ["悬浮"])
("xrgb" ["选购"])
("xrgk" ["宣告"])
("xrgs" ["旋宫"])
("xrgw" ["悬挂"])
("xrhj" ["先人后己"])
("xrhw" ["喧哗"])
("xrid" ["旋床"])
("xrig" ["宣称"])
("xrir" ["宣传"])
("xriu" ["选出"])
("xriv" ["悬垂"])
("xrjd" ["宣讲"])
("xrji" ["玄机" "选辑" "选集"])
("xrju" ["选举"])
("xrjx" ["癣疥"])
("xrk'" ["向日葵"])
("xrkd" ["选矿"])
("xrks" ["悬空"])
("xrli" ["绚丽"])
("xrlj" ["绚烂"])
("xrlu" ["选录"])
("xrlv" ["旋律"])
("xrmc" ["玄妙"])
("xrmn" ["选民"])
("xrmz" ["选煤"])
("xrnc" ["玄鸟"])
("xrnk" ["喧闹"])
("xrnm" ["悬念"])
("xrnq" ["旋钮"])
("xrpc" ["选票"])
("xrpj" ["宣判"])
("xrpl" ["选派"])
("xrpn" ["选聘"])
("xrpz" ["选配"])
("xrq'" ["轩" "喧" "宣" "儇" "谖" "萱" "揎" "暄" "煊" "蓄热器"])
("xrqu" ["选区" "选取"])
("xrr'" "券旋眩绚泫渲楦炫碹铉镟")
("xrrf" ["选任"])
("xrrh" ["喧嚷"])
("xrrj" ["渲染"])
("xrss" ["选送"])
("xrts" ["宣统"])
("xrub" ["选手"])
("xrui" ["宣示" "宣誓"])
("xruu" ["悬殊"])
("xrve" ["悬着"])
("xrvi" ["宣纸"])
("xrvj" ["宣战"])
("xrvr" ["旋转"])
("xrvs" ["选中" "选种"])
("xrw'" "悬旋玄漩璇痃")
("xrwo" ["旋涡" "漩涡"])
("xrwu" ["宣武"])
("xrxc" ["喧嚣"])
("xrxq" ["选修"])
("xrxt" ["玄学"])
("xrxu" ["新人新事"])
("xrya" ["悬崖"])
("xryh" ["宣扬"])
("xryj" ["宣言"])
("xryk" ["炫耀"])
("xryp" ["眩晕"])
("xrys" ["选用"])
("xryu" ["选育"])
("xrze" ["选择"])
("xs'" ["迅速"])
("xsa'" ["硝酸铵"])
("xsbk" ["凶暴"])
("xsbm" ["雄辩"])
("xsbu" ["胸部"])
("xscj" ["凶残"])
("xsd'" ["线速度" "小苏打"])
("xsdi" ["兄弟"])
("xsee" ["凶恶"])
("xsfg" ["雄蜂"])
("xsfj" ["凶犯"])
("xsg'" ["硝酸钙"])
("xsgu" ["胸骨"])
("xshb" ["雄厚"])
("xshf" ["凶狠"])
("xshl" ["西撒哈拉"])
("xshw" ["雄花"])
("xshy" ["胸怀"])
("xsj'" ["硝酸钾" "新四军"])
("xsji" ["雄鸡"])
("xsjm" ["雄健"])
("xsjn" ["胸襟"])
("xskb" ["胸口"])
("xsmg" ["凶猛"])
("xsmk" ["熊猫"])
("xsmz" ["兄妹"])
("xsn'" ["硝酸钠"])
("xsnu" ["匈奴"])
("xsp'" ["小算盘"])
("xspu" ["胸脯"])
("xsq'" "兄凶胸匈汹芎")
("xsqd" ["胸腔"])
("xsqi" ["凶器" "胸鳍"])
("xsrb" ["熊肉"])
("xsrv" ["雄蕊"])
("xsth" ["胸膛"])
("xsua" ["凶杀"])
("xsub" ["凶手"])
("xsui" ["雄师"])
("xsvd" ["雄壮"])
("xsvh" ["兄长" "熊掌"])
("xsw'" "雄熊")
("xswz" ["胸围" "雄伟"])
("xsx'" ["相似形"])
("xsxd" ["胸像"])
("xsxm" ["胸腺"])
("xsxn" ["雄心"])
("xsxs" ["汹汹" "熊熊"])
("xsxy" ["雄性"])
("xsy'" ["硝酸盐"])
("xsys" ["汹涌"])
("xsyy" ["雄鹰"])
("xt'" ["系统"])
("xtan" ["血案"])
("xtbg" ["雪崩"])
("xtbk" ["学报"])
("xtbl" ["相提并论" "雪白"])
("xtbo" ["学博" "穴播"])
("xtbu" ["学部"])
("xtdi" ["雪地"])
("xtdk" ["学到" "穴道"])
("xtdz" ["协同动作"])
("xte'" "雪鳕")
("xtff" ["学分"])
("xtfg" ["学风"])
("xtfu" ["学府"])
("xtfy" ["系统发育"])
("xtfz" ["学费"])
("xtg'" ["学徒工"])
("xtgi" ["系统工程"])
("xtgr" ["血管"])
("xtgs" ["学工"])
("xth'" ["萧太後"])
("xthj" ["血汗"])
("xthk" ["学好"])
("xthl" ["学海" "血海"])
("xths" ["血红"])
("xthv" ["学会"])
("xthw" ["雪花"])
("xthy" ["学坏"])
("xtjd" ["血浆"])
("xtji" ["学籍" "血迹"])
("xtjm" ["削减"])
("xtjp" ["学军"])
("xtjq" ["学究"])
("xtju" ["穴居"])
("xtjw" ["学家" "雪茄"])
("xtjx" ["学界"])
("xtke" ["学科"])
("xtl'" ["希特勒"])
("xtld" ["雪亮"])
("xtli" ["学理" "学历"])
("xtlu" ["血路"])
("xtly" ["学龄"])
("xtlz" ["血泪"])
("xtml" ["血脉"])
("xtmy" ["信托贸易" "学名"])
("xtnm" ["学年"])
("xtpl" ["学派"])
("xtpm" ["雪片"])
("xtq'" ["削" "靴" "薛" "小提琴"])
("xtqc" ["雪橇"])
("xtqi" ["学期"])
("xtqn" ["雪芹" "血亲"])
("xtqq" ["血球"])
("xtqy" ["血清"])
("xtr'" "血谑")
("xtrb" ["血肉"])
("xtro" ["削弱"])
("xtse" ["血色"])
("xtsi" ["血丝"])
("xtth" ["学堂"])
("xtts" ["血统"])
("xttu" ["学徒"])
("xtug" ["学生"])
("xtui" ["学时" "学识" "学士"])
("xtuj" ["雪山"])
("xtuo" ["学说"])
("xtur" ["血栓"])
("xtuu" ["学术" "血书"])
("xtuv" ["血水"])
("xtve" ["学者"])
("xtvg" ["学政"])
("xtvi" ["学制"])
("xtvj" ["血战"])
("xtvl" ["血债"])
("xtw'" "学穴噱泶踅")
("xtwf" ["学文" "学问"])
("xtwz" ["学位" "穴位"])
("xtx'" ["形态学"])
("xtxc" ["学校"])
("xtxi" ["学习" "学系" "血洗"])
("xtxy" ["血腥" "血型" "血性"])
("xtya" ["血压"])
("xtye" ["学业" "血液"])
("xtyi" ["学艺"])
("xtyr" ["学员" "学院" "雪原" "血缘"])
("xtzi" ["靴子" "学子"])
("xu'" ["形势"])
("xubk" ["虚报"])
("xubm" ["续编"])
("xubn" ["西双版纳"])
("xuci" ["虚词"])
("xud'" ["下水道" "小数点"])
("xudm" ["蓄电"])
("xudo" ["许多"])
("xudv" ["兴师动众"])
("xue'" ["许" "诩" "浒" "栩" "糈" "醑" "销售额" "新生儿"])
("xuf'" ["刑事犯"])
("xufa" ["须发"])
("xufu" ["徐福"])
("xufz" ["刑事犯罪"])
("xugb" ["虚构"])
("xugf" ["须根"])
("xugp" ["吸收光谱"])
("xuh'" ["消石灰" "小时候" "徐寿辉" "学生会"])
("xuhk" ["序号"])
("xuhr" ["虚幻"])
("xui'" ["小生产" "徐世昌"])
("xuih" ["许昌"])
("xuij" ["畜产"])
("xuiv" ["小生产者"])
("xuj'" ["吸收剂" "小说家" "学术界"])
("xuji" ["蓄积"])
("xujq" ["许久" "酗酒"])
("xujw" ["虚假"])
("xuke" ["许可"])
("xul'" ["销售量" "新胜利"])
("xulj" ["形式逻辑"])
("xull" ["新生力量"])
("xulp" ["序论" "绪论"])
("xulx" ["序列"])
("xum'" ["小市民"])
("xumu" ["序幕" "畜牧"])
("xumy" ["虚名"])
("xuni" ["虚拟"])
("xuno" ["许诺"])
("xuny" ["絮凝"])
("xup'" ["牺牲品" "小商品"])
("xupg" ["袖手旁观"])
("xuq'" "墟戌需虚嘘须吁圩顼砉盱胥")
("xuqd" ["西沙群岛" "新石器时代"])
("xuqq" ["需求"])
("xuqu" ["序曲"])
("xur'" "蓄酗叙旭序畜恤絮婿绪续勖洫溆煦")
("xuri" ["旭日"])
("xuro" ["虚弱"])
("xurs" ["虚荣"])
("xut'" ["蓿" "吸收塔"])
("xuu'" ["形式上" "叙事诗"])
("xuui" ["虚实" "叙事"])
("xuuo" ["叙说"])
("xuuu" ["虚数" "叙述" "序数"])
("xuuv" ["蓄水"])
("xuuw" ["新生事物"])
("xuv'" ["序时帐"])
("xuvb" ["徐州"])
("xuvh" ["虚张"])
("xuvi" ["须知"])
("xuvy" ["现实主义" "形式主义"])
("xuw'" "徐")
("xuwf" ["序文"])
("xuwh" ["虚妄"])
("xuwu" ["虚无"])
("xuwz" ["虚伪"])
("xux'" ["吸湿性" "现实性"])
("xuxd" ["虚象"])
("xuxm" ["虚线" "续弦"])
("xuxn" ["虚心"])
("xuxu" ["徐徐" "絮絮"])
("xuy'" ["相适应"])
("xuyb" ["小说月报"])
("xuyd" ["学生运动"])
("xuyi" ["蓄意"])
("xuyj" ["序言" "绪言"])
("xuyk" ["需要" "须要"])
("xuzr" ["刑事责任"])
("xv'" ["限制"])
("xvbb" ["兴致勃勃"])
("xvd'" ["谐振动"])
("xvf'" ["行政法" "休止符"])
("xvg'" ["新中国"])
("xvgl" ["行政管理"])
("xvh'" ["瞎指挥" "兴中会"])
("xvif" ["行政处分"])
("xvm'" ["徐志摩"])
("xvn'" ["下中农"])
("xvq'" ["泄殖腔" "行政区" "行政权"])
("xvqj" ["旋转起重机"])
("xvqy" ["行政区域"])
("xvst" ["雪中送炭"])
("xvu'" ["县知事"])
("xvv'" ["旋转轴"])
("xvvy" ["修正主义"])
("xvwu" ["心中无数"])
("xvx'" ["限制性"])
("xvxu" ["线胀系数"])
("xvy'" ["悬浊液"])
("xvyu" ["心中有数"])
("xvyx" ["行之有效"])
("xw'" ["新闻"])
("xwai" ["狭隘"])
("xwb'" ["纤维板"])
("xwba" ["下巴"])
("xwbi" ["下笔"])
("xwbj" ["下班"])
("xwbl" ["下摆"])
("xwbm" ["下边"])
("xwbo" ["匣钵"])
("xwbu" ["下部"])
("xwcg" ["下层"])
("xwci" ["下次"])
("xwda" ["下达"])
("xwde" ["吓得"])
("xwdg" ["下等"])
("xwdi" ["下地" "下第"])
("xwdj" ["下蛋"])
("xwdk" ["吓倒"])
("xwdy" ["下定"])
("xwee" ["下颚"])
("xwfa" ["下发" "下法"])
("xwfh" ["下方" "下放"])
("xwfj" ["下凡"])
("xwgb" ["新闻公报"])
("xwgd" ["霞光"])
("xwgr" ["下关" "下官"])
("xwgs" ["下工"])
("xwgu" ["峡谷"])
("xwh'" ["新文化"])
("xwhe" ["下河" "下颌"])
("xwhl" ["下海"])
("xwhu" ["吓唬"])
("xwhv" ["下回"])
("xwhw" ["下滑"])
("xwhy" ["吓坏"])
("xwi'" ["夏完淳" "相位差"])
("xwid" ["纤维长度"])
("xwie" ["瞎扯" "下车"])
("xwif" ["下沉"])
("xwih" ["狭长" "下场" "下厂"])
("xwiu" ["下处"])
("xwiv" ["下垂"])
("xwj'" ["显微镜"])
("xwjc" ["下脚"])
("xwjd" ["峡江" "下降"])
("xwji" ["下级" "夏季"])
("xwjm" ["下贱"])
("xwjq" ["下酒"])
("xwjr" ["下卷"])
("xwjv" ["新闻记者"])
("xwkb" ["峡口"])
("xwke" ["侠客" "下课"])
("xwld" ["夏粮"])
("xwli" ["下痢" "夏历"])
("xwlj" ["喜闻乐见"])
("xwll" ["下来"])
("xwlm" ["下联"])
("xwlo" ["下落"])
("xwlq" ["下流"])
("xwlx" ["下列"])
("xwly" ["下令"])
("xwma" ["下马"])
("xwmf" ["厦门"])
("xwmh" ["瞎忙"])
("xwmi" ["虾米"])
("xwmm" ["下面"])
("xwmu" ["下木"])
("xwnk" ["瞎闹"])
("xwnl" ["行为能力"])
("xwpj" ["下盘"])
("xwpn" ["下品"])
("xwq'" ["瞎" "虾" "呷" "宣武区"])
("xwqi" ["下棋"])
("xwqu" ["辖区" "下去"])
("xwqy" ["下情"])
("xwr'" "唬下厦夏吓罅")
("xwrf" ["虾仁" "下人"])
("xws'" ["纤维素"])
("xwsi" ["吓死"])
("xwtb" ["下头"])
("xwtl" ["下台"])
("xwtm" ["夏天"])
("xwts" ["下同"])
("xwtu" ["下土"])
("xwub" ["下手" "夏收"])
("xwue" ["下设"])
("xwuf" ["下身"])
("xwug" ["下生"])
("xwuj" ["下山" "县委书记"])
("xwuo" ["瞎说"])
("xwuu" ["下属"])
("xwuv" ["下水"])
("xwv'" ["写文章" "辛烷值" "新闻纸"])
("xwvi" ["下肢" "下直" "夏至"])
("xwvl" ["狭窄"])
("xwvs" ["下种" "夏种"])
("xwvw" ["瞎抓"])
("xwvy" ["行为主义" "虚无主义"])
("xww'" "匣霞辖暇峡侠狭狎遐瑕柙硖瘕黠")
("xwwf" ["下文"])
("xwwu" ["下午"])
("xwx'" ["新文学"])
("xwxc" ["狭小"])
("xwxd" ["下相" "下乡"])
("xwxm" ["下弦" "下限"])
("xwxp" ["下旬"])
("xwxy" ["下行"])
("xwyb" ["下游"])
("xwyi" ["侠义" "狭义"])
("xwyu" ["下雨" "下狱"])
("xwz'" ["新文字" "新闻组"])
("xwzb" ["下走"])
("xwzi" ["瞎子" "虾子" "匣子" "下子"])
("xwzo" ["下作"])
("xx'" ["学习"])
("xxal" ["小兴安岭"])
("xxan" ["血案"])
("xxb'" ["学习班" "血小板"])
("xxbh" ["线性变换"])
("xxbm" ["斜边"])
("xxbo" ["谐波"])
("xxby" ["雄性不育"])
("xxcs" ["胁从"])
("xxd'" ["小小的"])
("xxdi" ["鞋底"])
("xxdk" ["写到"])
("xxdl" ["携带"])
("xxdu" ["斜度" "亵渎"])
("xxdy" ["协定"])
("xxe'" "写血")
("xxee" ["邪恶"])
("xxf'" ["现行犯"])
("xxfa" ["写法"])
("xxfz" ["线性方程组"])
("xxg'" ["吸血鬼" "显象管"])
("xxgk" ["写稿"])
("xxgr" ["血管"])
("xxgs" ["歇工"])
("xxh'" ["形象化" "血循环" "冼星海"])
("xxhd" ["蟹黄"])
("xxhe" ["协和" "谐和"])
("xxhh" ["嘻嘻哈哈"])
("xxhj" ["血汗"])
("xxho" ["卸货"])
("xxhv" ["协会"])
("xxi'" ["血吸虫"])
("xxie" ["卸车"])
("xxii" ["挟持"])
("xxil" ["信息处理"])
("xxiu" ["写出"])
("xxjc" ["斜角"])
("xxjj" ["循序渐进" "循序见进"])
("xxjq" ["写就"])
("xxjt" ["谢绝"])
("xxju" ["小心谨慎" "虚心谨慎"])
("xxjw" ["谢家"])
("xxjy" ["斜井"])
("xxkk" ["辛辛苦苦"])
("xxl'" ["想象力" "向心力" "新西兰" "信息论" "熊希龄" "信息量"])
("xxlb" ["泄漏"])
("xxlc" ["写了"])
("xxli" ["协理" "协力"])
("xxlu" ["邪路" "泄露"])
("xxlv" ["斜率"])
("xxmi" ["泄密"])
("xxmk" ["鞋帽"])
("xxmm" ["斜面"])
("xxpo" ["斜坡" "胁迫"])
("xxq'" ["楔" "些" "歇" "蝎" "徐锡麒"])
("xxqc" ["斜桥"])
("xxqi" ["邪气" "泄气"])
("xxr'" ["解" "契" "写" "械" "卸" "蟹" "懈" "泄" "泻" "谢" "屑" "亵" "燮" "薤" "獬" "廨" "渫" "瀣" "邂" "绁" "榭" "榍" "躞" "乡下人"])
("xxrr" ["熙熙攘攘"])
("xxru" ["写入" "栩栩如生"])
("xxss" ["形形色色"])
("xxsw" ["形象思维"])
("xxtc" ["协调"])
("xxts" ["协同" "协统"])
("xxu'" ["小学生"])
("xxub" ["携手"])
("xxue" ["斜射"])
("xxug" ["写生"])
("xxuh" ["协商"])
("xxui" ["斜视" "写实"])
("xxuo" ["邪说"])
("xxuw" ["鞋刷"])
("xxva" ["斜轧"])
("xxvf" ["谐振" "写真"])
("xxvh" ["星星之火"])
("xxvk" ["写照"])
("xxvu" ["协助"])
("xxvv" ["雄心壮志"])
("xxw'" "鞋协挟携邪斜胁谐叶偕勰撷缬颉")
("xxwa" ["鞋袜"])
("xxwf" ["斜纹"])
("xxx'" ["现象学" "小行星" "笑嘻嘻"])
("xxxc" ["些小"])
("xxxi" ["歇息"])
("xxxm" ["斜线"])
("xxxn" ["写信"])
("xxxr" ["谢玄" "欣欣向荣"])
("xxxx" ["谢谢"])
("xxyb" ["鞋油"])
("xxyh" ["斜阳"])
("xxyi" ["协议" "写意" "谢意"])
("xxyj" ["线性元件" "斜眼"])
("xxyn" ["谐音"])
("xxyy" ["小心翼翼"])
("xxzi" ["楔子" "鞋子" "写字"])
("xxzo" ["协作" "写作"])
("xy'" ["需要"])
("xyan" ["兴安"])
("xyb'" ["下一步"])
("xybj" ["兴办"])
("xybm" ["形变"])
("xybu" ["刑部" "行部"])
("xybx" ["性别"])
("xyby" ["性病"])
("xydb" ["星斗"])
("xydd" ["西印度群岛"])
("xydk" ["行道"])
("xyds" ["行东" "行动"])
("xye'" ["省" "醒" "擤" "心眼儿"])
("xyer" ["幸而"])
("xyf'" ["洗衣粉"])
("xyfa" ["刑罚" "刑法"])
("xyff" ["兴奋"])
("xyfu" ["幸福"])
("xyg'" ["协约国"])
("xygd" ["星光"])
("xyge" ["性格"])
("xygh" ["型钢"])
("xygj" ["性感"])
("xygo" ["兴国"])
("xygs" ["行宫"])
("xyha" ["象牙海岸"])
("xyhk" ["型号" "幸好"])
("xyho" ["星火"])
("xyhv" ["行贿"])
("xyhw" ["兴化"])
("xyie" ["行车"])
("xyig" ["形成" "行程"])
("xyir" ["行船"])
("xyiv" ["胸有成竹"])
("xyj'" ["洗衣机" "显影剂" "巡洋舰"])
("xyjc" ["性交"])
("xyjd" ["行将"])
("xyji" ["性急"])
("xyjm" ["兴建" "行检"])
("xyjn" ["行进"])
("xyjp" ["行军"])
("xyju" ["稀有金属" "刑具"])
("xyjy" ["行径"])
("xyks" ["星空"])
("xykv" ["幸亏"])
("xyl'" ["吸引力" "先验论" "匈牙利"])
("xylc" ["醒了"])
("xyli" ["行李" "行礼"])
("xyll" ["醒来"])
("xyls" ["兴隆"])
("xylv" ["刑律"])
("xyma" ["形码"])
("xymm" ["幸免"])
("xymu" ["醒目"])
("xymy" ["刑名" "性命" "姓名"])
("xyng" ["性能"])
("xypd" ["选言判断"])
("xyq'" ["星" "腥" "猩" "惺" "兴" "弦乐器" "效应器"])
("xyqi" ["星期" "兴起" "刑期" "性气"])
("xyqq" ["星球"])
("xyqu" ["兴趣"])
("xyqy" ["性情"])
("xyr'" "兴幸杏性姓荇悻")
("xyrf" ["行人" "杏仁"])
("xyrs" ["形容"])
("xys'" ["稀盐酸" "小意思"])
("xysi" ["形似"])
("xyti" ["星体" "形体"])
("xytl" ["形态" "邢台"])
("xyu'" ["下意识"])
("xyua" ["型砂"])
("xyug" ["兴盛" "形声" "行省"])
("xyui" ["省事" "刑事" "形式" "形势" "行时" "行使" "行驶" "行事" "姓氏"])
("xyuu" ["刑书" "形数" "行书"])
("xyv'" ["小业主" "信用证" "选言肢"])
("xyvd" ["形状" "行装" "行状"])
("xyve" ["行者"])
("xyvg" ["行政"])
("xyvi" ["兴致" "形制" "性质"])
("xyvs" ["省中"])
("xyw'" "刑型形邢行陉荥饧硎")
("xywf" ["省文" "行文"])
("xywh" ["兴亡" "兴旺"])
("xywi" ["习以为常"])
("xywu" ["醒悟"])
("xywz" ["兴味" "行为"])
("xyx'" ["新颖性"])
("xyxc" ["行销"])
("xyxd" ["形相" "形象" "性相"])
("xyxi" ["星系"])
("xyxm" ["性腺"])
("xyxp" ["刑讯"])
("xyxq" ["兴修"])
("xyxs" ["行凶"])
("xyxu" ["兴许"])
("xyxy" ["星星" "猩猩" "行星" "行刑" "行行" "性行"])
("xyye" ["星夜"])
("xyyh" ["荥阳"])
("xyyi" ["行医"])
("xyyp" ["星云" "幸运"])
("xyyu" ["性欲"])
("xyyy" ["形影"])
("xyzb" ["行走"])
("xyzi" ["性子"])
("xyzl" ["行在"])
("xyzo" ["星座"])
("xyzs" ["行踪"])
("xz'" ["现在"])
("xzb'" ["信噪比"])
("xzjg" ["行走机构"])
("xzq'" ["协奏曲"])
("xzt'" ["写字台"])
("xzx'" ["选择性"])
("y" "一")
("yaan" ["雅安"])
("yaba" ["哑巴"])
("yabi" ["崖壁"])
("yadh" ["亚当"])
("yadi" ["压低"])
("yadj" ["鸭蛋"])
("yadk" ["压倒"])
("yadm" ["压电" "雅典"])
("yads" ["亚东"])
("yady" ["亚丁"])
("yae'" "匹瞧雅痖疋")
("yaff" ["牙粉"])
("yafu" ["压服"])
("yafz" ["亚非"])
("yagd" ["轧光"])
("yagh" ["亚纲"])
("yagk" ["牙膏"])
("yagl" ["压盖"])
("yagr" ["牙关" "雅观"])
("yaid" ["牙床"])
("yaii" ["牙齿"])
("yais" ["蚜虫"])
("yaji" ["压挤" "雅集" "轧机"])
("yajm" ["轧件"])
("yajn" ["押金"])
("yajp" ["亚军"])
("yaju" ["哑剧"])
("yajw" ["压价"])
("yake" ["牙科"])
("yali" ["压力"])
("yaly" ["哑铃"])
("yama" ["亚麻"])
("yamf" ["衙门"])
("yami" ["哑谜"])
("yapm" ["鸦片"])
("yapo" ["压迫"])
("yaq'" "压押鸦鸭呀丫雅哑垭桠")
("yaqd" ["压强"])
("yaqi" ["压气"])
("yar'" "压亚讶轧揠迓娅氩砑")
("yare" ["亚热"])
("yarf" ["雅人"])
("yars" ["鸭绒"])
("yasi" ["亚斯"])
("yaso" ["压缩"])
("yass" ["押送"])
("yasv" ["压碎"])
("yat'" "呀")
("yatb" ["压头" "丫头"])
("yatc" ["压条"])
("yatx" ["亚铁"])
("yauw" ["牙刷"])
("yava" ["压榨"])
("yavb" ["亚洲"])
("yavi" ["压制" "雅致" "轧制"])
("yavu" ["压铸" "压住"])
("yaw'" "芽牙蚜崖衙涯伢岈琊睚")
("yaya" ["呀呀"])
("yayi" ["压抑"])
("yayj" ["压延"])
("yayp" ["压韵" "押运" "押韵"])
("yayu" ["哑语"])
("yazi" ["鸭子" "伢子"])
("yazo" ["雅座"])
("yb'" ["一般"])
("ybai" ["有碍" "友爱"])
("yban" ["幽暗"])
("ybb'" ["眼巴巴" "叶斑病"])
("ybba" ["又把"])
("ybbc" ["游标"])
("ybbg" ["油泵"])
("ybbh" ["友邦"])
("ybbm" ["右边"])
("ybbu" ["油布"])
("ybby" ["油饼"])
("ybbz" ["又被"])
("ybcg" ["油层"])
("ybch" ["油藏"])
("ybci" ["由此"])
("ybck" ["油槽"])
("ybcl" ["油菜"])
("ybco" ["有错"])
("ybd'" ["要不得" "郁闭度"])
("ybdb" ["又都"])
("ybde" ["有的"])
("ybdg" ["优等" "油灯"])
("ybdh" ["游荡"])
("ybdi" ["邮递" "有底" "右的"])
("ybdj" ["异步电动机"])
("ybdk" ["有道" "诱导"])
("ybdl" ["优待" "有待"])
("ybdm" ["优点" "邮电" "有点"])
("ybds" ["游动"])
("ybdu" ["一般的说"])
("ybdv" ["又对"])
("ybdw" ["一般等价物"])
("ybe'" "有友酉卣莠牖铕黝")
("yber" ["右耳" "诱饵" "幼儿"])
("ybf'" ["一部分"])
("ybfa" ["诱发"])
("ybff" ["忧愤"])
("ybfh" ["油坊" "有方" "右方"])
("ybfu" ["优抚"])
("ybgb" ["邮购"])
("ybgd" ["油光" "有光"])
("ybge" ["有个"])
("ybgf" ["幼根"])
("ybgo" ["油锅" "有过"])
("ybgr" ["油管" "油罐" "有关"])
("ybgs" ["有功"])
("ybgv" ["有鬼"])
("ybgx" ["一笔勾销"])
("ybgz" ["又给"])
("ybh'" ["一般化"])
("ybhb" ["优厚"])
("ybhe" ["又喝"])
("ybhk" ["友好"])
("ybhl" ["有害"])
("ybho" ["诱惑"])
("ybhr" ["忧患"])
("ybhv" ["优惠" "油灰" "又会"])
("ybhw" ["优化" "油滑" "油画"])
("ybhz" ["黝黑"])
("ybia" ["油茶"])
("ybib" ["忧愁"])
("ybig" ["有成"])
("ybih" ["悠长" "有偿"])
("ybii" ["又吃"])
("ybio" ["邮戳"])
("ybir" ["油船"])
("ybis" ["幼虫"])
("ybiu" ["邮出"])
("ybjc" ["又叫"])
("ybjd" ["诱降"])
("ybji" ["邮寄" "游击" "游记" "有机" "又及"])
("ybjm" ["邮件" "有间"])
("ybjn" ["有劲"])
("ybjp" ["友军" "右军"])
("ybjq" ["悠久" "有旧"])
("ybju" ["邮局" "油锯"])
("ybjw" ["有家"])
("ybjy" ["幽静" "油井"])
("ybkd" ["铀矿" "油矿"])
("ybke" ["游客" "有客" "又可"])
("ybki" ["游标卡尺"])
("ybku" ["油库"])
("ybl'" ["用不了"])
("yblc" ["油料" "有了"])
("ybld" ["优良"])
("yble" ["游乐"])
("ybli" ["游离" "游历" "有理" "有礼" "有利" "有力"])
("yblj" ["游览"])
("yblk" ["有劳"])
("ybll" ["由来" "有赖" "又来"])
("ybln" ["幼林"])
("yblp" ["油轮"])
("yblv" ["忧虑" "油绿"])
("yblx" ["优劣" "预备立宪"])
("ybly" ["幽灵" "有零"])
("yblz" ["油类"])
("ybmc" ["幼苗"])
("ybmf" ["油门"])
("ybmm" ["右面"])
("ybmn" ["游民"])
("ybmo" ["幽默" "油墨"])
("ybmu" ["游牧"])
("ybmy" ["幽明" "有名"])
("ybmz" ["优美"])
("ybng" ["又能"])
("ybni" ["油泥" "油腻"])
("ybnm" ["有年" "幼年"])
("ybpc" ["邮票"])
("ybpl" ["右派"])
("ybpm" ["诱骗"])
("ybq'" "幽优悠忧攸呦")
("ybqi" ["尤其" "油漆" "油气"])
("ybqm" ["有钱"])
("ybqr" ["有权"])
("ybqu" ["有趣"])
("ybqy" ["有情" "有请" "友情" "右倾"])
("ybr'" ["有" "右" "佑" "釉" "诱" "又" "幼" "侑" "囿" "宥" "柚" "蚴" "鼬" "要不然" "一班人"])
("ybrf" ["游人" "有人" "友人"])
("ybrj" ["悠然"])
("ybru" ["犹如" "有如" "又如"])
("ybse" ["有色"])
("ybsi" ["有司"])
("ybso" ["有所"])
("ybsr" ["油酸"])
("ybss" ["油松"])
("ybtb" ["由头"])
("ybtc" ["油条"])
("ybtd" ["一败涂地"])
("ybti" ["幼体"])
("ybtk" ["釉陶"])
("ybtl" ["犹太"])
("ybtm" ["油田"])
("ybts" ["油桐" "油桶"])
("ybty" ["游艇"])
("ybu'" ["要不是" "一把手" "有本事"])
("ybua" ["诱杀"])
("ybub" ["右手"])
("ybuf" ["幽深" "有身"])
("ybug" ["优胜" "友生"])
("ybuh" ["忧伤"])
("ybui" ["优势" "有失" "有时" "有识" "有事" "又是"])
("ybul" ["一般说来"])
("ybuu" ["有数"])
("ybuv" ["油水" "游说" "又睡"])
("ybv'" ["一把抓" "用不着"])
("ybvb" ["幽州"])
("ybve" ["有着"])
("ybvg" ["邮政"])
("ybvi" ["优质" "邮址" "油脂" "油纸" "幼稚"])
("ybvj" ["一本正经" "油毡"])
("ybvs" ["由中" "由衷" "有种"])
("ybw'" "尤由邮铀犹油游莜莸尢柚猷疣蚰蝣蝤繇鱿")
("ybwf" ["又闻"])
("ybwj" ["游玩" "又玩"])
("ybwu" ["油污" "有误"])
("ybwz" ["有为" "有谓"])
("ybxc" ["有效" "幼小"])
("ybxd" ["邮箱" "油箱" "又象"])
("ybxi" ["游戏" "有喜"])
("ybxj" ["乙丙橡胶"])
("ybxm" ["优先" "悠闲" "有限" "有线"])
("ybxn" ["有心"])
("ybxq" ["优秀"])
("ybxr" ["优选"])
("ybxx" ["有些" "友协"])
("ybxy" ["油性" "游行" "有形" "有性"])
("ybya" ["油压" "幼芽"])
("ybyb" ["幽幽" "悠悠" "又有"])
("ybyh" ["悠扬"])
("ybyi" ["优异" "犹疑" "游艺" "有意" "有益" "友谊" "右翼" "又一"])
("ybyk" ["又要"])
("ybyn" ["油印"])
("ybyr" ["悠远" "游园" "有源"])
("ybys" ["游泳" "有用"])
("ybyt" ["优越"])
("ybyu" ["优于" "忧郁" "由于" "由余" "犹豫" "有余" "鱿鱼"])
("ybz'" ["一辈子" "印把子"])
("ybzh" ["油藏"])
("ybzi" ["游资" "游子"])
("ybzl" ["又在"])
("ybzs" ["油棕"])
("yc'" ["因此"])
("ycfi" ["一次方程"])
("yckj" ["由此可见"])
("ycl'" ["用材林" "原材料"])
("yclt" ["依此类推"])
("yctu" ["与此同时"])
("yd'" ["有的"])
("ydar" ["印第安人"])
("ydb'" ["邮电部"])
("ydbd" ["一动不动"])
("ydd'" ["远地点"])
("yddh" ["移动电话"])
("yddm" ["以点带面"])
("yde'" ["一点儿"])
("ydf'" ["一顿饭"])
("ydfu" ["有的放矢"])
("ydh'" ["永定河" "约旦河" "运动会"])
("ydi'" ["原电池" "运动场"])
("ydj'" ["永动机" "原动机"])
("ydjj" ["运动健将"])
("ydjs" ["运动竞赛"])
("ydl'" ["意大利" "原动力"])
("ydny" ["印度尼西亚"])
("ydp'" ["一大批"])
("ydq'" ["验电器" "一刀切"])
("ydu'" ["议定书" "有的是"])
("ydv'" ["用得着"])
("ydvn" ["印度支那"])
("ydvy" ["因地制宜"])
("ydx'" ["夜大学"])
("ydy'" ["一对一" "印度洋" "运动员"])
("ydyd" ["一点一滴"])
("ye'" ["因而"])
("yeba" ["也罢"])
("yebi" ["也比"])
("yebj" ["夜班" "夜半"])
("yebu" ["也不"])
("yeby" ["叶柄"])
("yebz" ["也被"])
("yecg" ["也曾"])
("yecj" ["野餐"])
("yecl" ["野菜"])
("yedb" ["也都"])
("yede" ["也得"])
("yedi" ["野地"])
("yee'" "野冶也")
("yeer" ["爷儿" "叶耳"])
("yegd" ["夜光"])
("yegz" ["也给"])
("yehh" ["夜航"])
("yehk" ["也好"])
("yehl" ["也还"])
("yeho" ["野火"])
("yehv" ["也会"])
("yehw" ["野花" "液化"])
("yei'" ["乙二醇"])
("yeia" ["夜叉"])
("yejc" ["也叫"])
("yeji" ["野鸡" "业绩"])
("yejm" ["夜间" "谒见"])
("yejn" ["冶金"])
("yejq" ["也就"])
("yejy" ["业经" "夜景" "液晶"])
("yeke" ["也可"])
("yeks" ["夜空"])
("yeli" ["夜里" "液力"])
("yell" ["也来" "夜来"])
("yelm" ["冶炼"])
("yelp" ["叶轮"])
("yema" ["野马" "页码"])
("yemf" ["爷们" "也门"])
("yemj" ["野蛮"])
("yeml" ["叶脉"])
("yemm" ["叶面"])
("yemu" ["夜幕"])
("yemz" ["也没"])
("yeng" ["也能"])
("yepk" ["液泡"])
("yepm" ["叶片"])
("yeq'" "椰噎耶掖")
("yeqc" ["叶鞘"])
("yer'" "哗咽页掖业叶曳腋夜液拽靥谒邺晔烨")
("yerb" ["叶肉"])
("yerf" ["野人"])
("yese" ["夜色"])
("yesp" ["爷孙"])
("yesr" ["叶酸"])
("yesu" ["耶稣"])
("yet'" ["雅尔塔"])
("yeti" ["液体"])
("yetl" ["液态"])
("yetu" ["野兔"])
("yety" ["叶挺"])
("yeub" ["野兽"])
("yeuf" ["夜深"])
("yeug" ["野生"])
("yeui" ["也使" "也是" "夜市"])
("yeuu" ["页数"])
("yevj" ["野战"])
("yevu" ["业主"])
("yew'" "邪耶爷揶铘")
("yewj" ["夜晚"])
("yewl" ["野外"])
("yewo" ["腋窝"])
("yewu" ["业务"])
("yewz" ["也为"])
("yexc" ["夜校"])
("yexd" ["也象"])
("yexi" ["夜袭"])
("yexm" ["也先" "掖县"])
("yexn" ["野心"])
("yexu" ["也许"])
("yexw" ["腋下"])
("yey'" ["幼儿园"])
("yeya" ["野鸭" "叶芽" "腋芽" "液压"])
("yeyb" ["也有"])
("yeye" ["爷爷" "叶腋"])
("yeyi" ["也已" "业已"])
("yeyj" ["页岩"])
("yeyk" ["也要"])
("yeyu" ["业余"])
("yeyy" ["野营" "也应"])
("yezi" ["椰子" "叶子"])
("yezl" ["也在"])
("yf'" ["乙方"])
("yfbd" ["原封不动"])
("yffu" ["一帆风顺"])
("yfhy" ["亚非会议"])
("yfk'" ["预付款"])
("yfm'" ["一方面"])
("yfsv" ["约法三章"])
("yfui" ["洋法生产"])
("yfwe" ["一分为二"])
("yfwv" ["预防为主"])
("yfy'" ["依附于"])
("yfyv" ["一夫一妻制"])
("yfyw" ["阳奉阴违"])
("yfz'" ["一分子"])
("yfzb" ["预付资本"])
("yg'" ["一个"])
("ygbp" ["雅各宾派"])
("ygej" ["一干二净"])
("ygel" ["一概而论"])
("ygf'" ["荧光粉"])
("yggl" ["有功功率"])
("yggy" ["云贵高原"])
("ygh'" ["异构化"])
("ygii" ["衣冠楚楚"])
("ygje" ["一个劲儿"])
("ygl'" ["英格兰"])
("yglv" ["一国两制"])
("ygp'" ["荧光屏"])
("ygt'" ["异构体" "硬骨头"])
("ygyj" ["有根有据"])
("ygyl" ["硬骨鱼类"])
("ygyq" ["严格要求"])
("ygyu" ["愚公移山"])
("ygz'" ["洋鬼子"])
("yh'" ["以后"])
("yhb'" ["氧化钡"])
("yhbf" ["样本"])
("yhbj" ["样板"])
("yhbu" ["洋布"])
("yhby" ["养兵" "养病"])
("yhcs" ["洋葱"])
("yhd'" ["氧化氮" "溢洪道"])
("yhdi" ["养地"])
("yhdm" ["阳电"])
("yhdv" ["议会斗争"])
("yhe'" ["氧" "仰" "痒" "养" "一忽儿" "一会儿"])
("yhff" ["养分"])
("yhfg" ["养蜂"])
("yhfh" ["洋房"])
("yhfu" ["养父"])
("yhg'" ["氧化钙" "氧化铬" "氧化汞"])
("yhgd" ["杨广" "阳光" "仰光"])
("yhge" ["秧歌"])
("yhgk" ["羊羔"])
("yhh'" ["耶和华"])
("yhhe" ["洋河"])
("yhhh" ["洋行"])
("yhho" ["洋货" "养活"])
("yhhu" ["养护"])
("yhhv" ["洋灰"])
("yhhw" ["扬花" "氧化"])
("yhhy" ["洋槐"])
("yhi'" ["杨虎城"])
("yhie" ["洋车"])
("yhig" ["扬程" "羊城" "养成"])
("yhj'" ["氧化剂"])
("yhjc" ["羊角" "仰角"])
("yhji" ["阳极" "样机"])
("yhjm" ["杨坚"])
("yhjw" ["养家"])
("yhl'" ["氧化铝" "渔获量"])
("yhlc" ["养料"])
("yhli" ["阳历"])
("yhlk" ["养老"])
("yhlq" ["杨柳" "洋流"])
("yhlu" ["养路"])
("yhly" ["秧龄"])
("yhm'" ["氧化酶" "氧化镁"])
("yhmc" ["秧苗"])
("yhmk" ["羊毛"])
("yhmm" ["洋面" "仰面"])
("yhmu" ["仰慕"])
("yhmz" ["杨梅"])
("yhp'" ["易耗品"])
("yhpi" ["羊皮"])
("yhpn" ["样品"])
("yhq'" ["殃" "央" "鸯" "秧" "泱" "鞅" "氧化铅" "义和拳" "银行券" "优惠券"])
("yhqi" ["扬弃" "氧气" "养气"])
("yhqm" ["洋钱"])
("yhqn" ["养亲"])
("yhqp" ["羊群"])
("yhqq" ["央求"])
("yhr'" "样漾怏烊恙鞅")
("yhrb" ["羊肉"])
("yhrf" ["洋人"])
("yhrs" ["羊绒"])
("yht'" ["氧化铁" "氧化铜" "义和团"])
("yhti" ["有何特长"])
("yhtl" ["阳台" "粤汉铁路"])
("yhtm" ["秧田"])
("yhu'" ["原函数"])
("yhug" ["扬声" "养生"])
("yhuh" ["养伤"])
("yhui" ["杨氏" "样式"])
("yhuo" ["阳朔"])
("yhuu" ["杨树"])
("yhuv" ["羊水"])
("yhv'" ["议会制"])
("yhvb" ["扬州"])
("yhvd" ["洋装"])
("yhvh" ["银行帐号"])
("yhvi" ["养殖"])
("yhvu" ["杨朱"])
("yhw'" ["杨" "扬" "佯" "疡" "羊" "洋" "阳" "徉" "炀" "烊" "蛘" "氧化物" "用户网"])
("yhwf" ["杨文"])
("yhwh" ["仰望"])
("yhwo" ["仰卧"])
("yhwu" ["洋务"])
("yhwz" ["扬威"])
("yhx'" ["氧化锌" "银河系" "约翰逊"])
("yhxy" ["阳性" "银行信用"])
("yhy'" ["颐和园"])
("yhyb" ["洋油"])
("yhyh" ["洋洋" "痒痒" "样样"])
("yhyi" ["洋溢"])
("yhyj" ["扬言"])
("yhyk" ["杨幺"])
("yhys" ["仰泳"])
("yhyt" ["氧化亚铜"])
("yhyu" ["洋芋" "养育"])
("yhyv" ["又红又专"])
("yhzb" ["银行资本"])
("yhzi" ["杨子" "扬子" "养子" "样子"])
("yhzs" ["炎黄子孙"])
("yhzy" ["异化作用"])
("yi'" ["用处"])
("yian" ["议案"])
("yib'" ["邮传部"])
("yiba" ["已把"])
("yibb" ["一成不变"])
("yibc" ["仪表"])
("yibd" ["扬长避短"])
("yibf" ["乙苯" "译本"])
("yibi" ["一壁"])
("yibj" ["一般" "一半"])
("yibk" ["易爆"])
("yibm" ["一边" "以便"])
("yibn" ["宜宾"])
("yibo" ["衣钵"])
("yibu" ["已不" "异步"])
("yibx" ["永垂不朽"])
("yiby" ["一并" "疫病"])
("yibz" ["椅背" "已被" "以北"])
("yici" ["一次" "依此" "依次" "以次"])
("yicj" ["蚁蚕"])
("yicl" ["异彩"])
("yicp" ["依存"])
("yics" ["已从"])
("yid'" ["洋插队"])
("yide" ["一得"])
("yidg" ["一等"])
("yidi" ["异地"])
("yidj" ["一旦"])
("yidk" ["一道"])
("yidl" ["一带" "一代"])
("yidm" ["一点" "疑点" "译电"])
("yidr" ["一端" "一段" "臆断" "异端"])
("yids" ["一动" "伊东" "移动" "以东" "易懂"])
("yidu" ["一度" "益都"])
("yidv" ["一堆"])
("yidy" ["一定" "议定"])
("yie'" "已以乙椅蚁倚矣尾苡迤旖钇舣酏")
("yier" ["一二" "已而"])
("yifa" ["一发" "依法" "益发"])
("yiff" ["一份" "衣分" "义愤"])
("yifh" ["乙方"])
("yifj" ["一番"])
("yifu" ["一夫" "依附" "衣服"])
("yifz" ["亦非"])
("yig'" ["逸出功"])
("yige" ["一个"])
("yigi" ["遗传工程"])
("yigj" ["一干"])
("yigl" ["一概"])
("yigo" ["异国"])
("yigr" ["一贯" "衣冠"])
("yigs" ["一共"])
("yigu" ["已故"])
("yigv" ["衣柜"])
("yihb" ["以后"])
("yihd" ["一晃"])
("yihe" ["议和"])
("yihf" ["遗恨"])
("yihh" ["一行" "移行"])
("yihj" ["遗憾"])
("yihk" ["一毫"])
("yihl" ["遗骸"])
("yiho" ["疑惑" "抑或"])
("yihp" ["已婚"])
("yihr" ["亦还"])
("yihs" ["伊红"])
("yihv" ["议会"])
("yihw" ["异化"])
("yiig" ["议程"])
("yiih" ["宜昌" "异常"])
("yiij" ["遗产"])
("yiip" ["宜春" "乙醇"])
("yiir" ["遗传"])
("yiis" ["益虫"])
("yiiu" ["役畜" "益处" "溢出"])
("yijc" ["一角" "遗教" "移交"])
("yiji" ["一己" "遗迹" "已极" "以及" "亦即" "异己"])
("yijj" ["有产阶级"])
("yijm" ["一间" "意见"])
("yijn" ["铱金" "衣襟" "以近"])
("yijq" ["一九" "依旧"])
("yijt" ["议决"])
("yiju" ["一举" "依据" "移居" "疑惧" "已具"])
("yijw" ["一架" "议价"])
("yijx" ["一介"])
("yijy" ["一经" "已经" "易经" "意境"])
("yik'" ["一场空"])
("yikb" ["一口"])
("yike" ["一刻" "医科"])
("yikk" ["依靠" "倚靠"])
("yikl" ["移开"])
("yiku" ["忆苦"])
("yiky" ["一块"])
("yil'" ["引潮力" "预处理"])
("yilb" ["遗漏"])
("yilc" ["医疗" "衣料" "意料"])
("yilh" ["伊朗"])
("yili" ["一例" "一力" "屹立" "毅力" "义理"])
("yilj" ["一览"])
("yilk" ["遗老"])
("yill" ["一来" "依赖" "倚赖" "以来"])
("yilm" ["一连" "依恋"])
("yilp" ["议论"])
("yilq" ["一溜" "遗留" "溢流"])
("yilu" ["一路"])
("yilv" ["一律" "疑虑" "义律"])
("yilz" ["异类"])
("yima" ["姨妈" "译码"])
("yimc" ["移苗" "疫苗"])
("yimg" ["沂蒙"])
("yimi" ["乙醚"])
("yimm" ["一面" "以免"])
("yimn" ["一民" "遗民" "移民"])
("yimo" ["一抹"])
("yimv" ["一筹莫展"])
("yinc" ["益鸟"])
("yinj" ["疑难" "以南"])
("yinm" ["一年"])
("yinz" ["以内"])
("yip'" ["原肠胚"])
("yipj" ["一盘"])
("yipm" ["一偏" "一片"])
("yipx" ["一瞥"])
("yiq'" "一壹医揖铱依伊衣椅咿噫猗漪欹黟")
("yiqi" ["一齐" "一起" "一气" "遗弃" "仪器" "意气" "义旗" "义气"])
("yiqm" ["一千" "以前"])
("yiqq" ["以求"])
("yiqr" ["乙醛"])
("yiqt" ["乙炔"])
("yiqu" ["一曲" "疫区"])
("yiqx" ["一切"])
("yiqy" ["一青" "移情"])
("yir'" "艺亦抑义易屹谊亿役裔意忆益溢诣议译臆逸肄疫艾邑毅异翼翌绎刈劓仡佚佾埸懿薏弈奕挹弋呓嗌噫峄怿悒驿缢殪轶熠镒镱瘗癔翊蜴羿翳")
("yirf" ["一任" "宜人" "艺人"])
("yiri" ["一日" "异日" "翌日"])
("yirj" ["依然" "已然" "易燃" "毅然"])
("yirs" ["遗容"])
("yiru" ["一如"])
("yise" ["一色"])
("yisi" ["一丝" "意思" "缢死"])
("yisr" ["乙酸"])
("yisv" ["易碎"])
("yitb" ["一头"])
("yith" ["饴糖"])
("yiti" ["一体" "遗体" "议题" "异体"])
("yitl" ["以太"])
("yitm" ["一天" "倚天"])
("yitr" ["一团" "疑团"])
("yits" ["一同" "一统" "异同"])
("yitu" ["意图"])
("yitx" ["一帖"])
("yiu'" ["银川市"])
("yiub" ["一手"])
("yiuf" ["一身"])
("yiug" ["一生" "医生"])
("yiuh" ["衣裳" "以上"])
("yiui" ["一时" "一世" "一事" "医师" "衣食" "遗失" "仪式" "逸事" "意识" "义士" "议事"])
("yiuj" ["一山" "衣衫"])
("yiup" ["一瞬"])
("yiuu" ["医术" "遗书" "艺术"])
("yiv'" ["有产者"])
("yivb" ["一周" "益州"])
("yive" ["依着" "译者"])
("yivf" ["一阵"])
("yivh" ["一张" "依仗" "倚仗" "议长"])
("yivi" ["一直" "一致" "医治" "遗址" "遗志" "移植" "已知" "以至" "以致" "抑止" "抑制" "意旨" "意志"])
("yivj" ["翼展" "驿站"])
("yivk" ["一朝" "依照"])
("yivo" ["衣着"])
("yivp" ["一准"])
("yivr" ["有偿转让"])
("yivs" ["一种"])
("yivu" ["遗嘱" "遗著"])
("yiw'" "蛇颐夷遗移仪胰疑沂宜姨彝诒圯荑咦嶷饴怡迤贻眙痍")
("yiwf" ["疑问" "译文" "异文"])
("yiwh" ["遗忘" "已往" "以往"])
("yiwj" ["一万" "乙烷" "亿万"])
("yiwl" ["以外" "意外"])
("yiwu" ["一无" "医务" "衣物" "遗物" "义务" "异物" "贻误"])
("yiwv" ["遗传物质"])
("yiwz" ["一味" "依偎" "移位" "以为" "易位" "意味" "异味"])
("yix'" ["遗传性" "遗传学" "运筹学"])
("yixd" ["一向" "遗像" "移项" "臆想" "意想" "意向" "意象" "异乡"])
("yixi" ["依稀" "乙烯" "以西" "议席"])
("yixm" ["一线" "胰腺" "乙酰"])
("yixn" ["一心" "疑心"])
("yixt" ["医学"])
("yixw" ["一下" "以下"])
("yixx" ["一些" "遗传信息"])
("yixy" ["一行" "宜兴" "异型" "异性"])
("yiyb" ["一又" "已由" "已有"])
("yiye" ["一叶" "肄业"])
("yiyh" ["一样" "宜阳" "异样"])
("yiyi" ["艾艾" "依依" "疑义" "意义" "异议"])
("yiyj" ["一眼" "义演"])
("yiyk" ["医药"])
("yiyn" ["倚音" "译音"])
("yiyr" ["议员" "医院" "遗愿" "以远" "意愿" "议院"])
("yiys" ["易用" "义勇"])
("yiyt" ["一月"])
("yiyu" ["一隅" "易于" "易与"])
("yiyy" ["一应"])
("yizi" ["椅子" "以资"])
("yizj" ["育成杂交"])
("yizk" ["一早" "臆造"])
("yizl" ["一再" "移栽" "已在"])
("yizs" ["一总"])
("yizu" ["夷族" "彝族" "异族"])
("yj'" ["以及"])
("yjan" ["延安" "沿岸"])
("yjba" ["盐巴"])
("yjbi" ["掩蔽"])
("yjbj" ["严办"])
("yjbl" ["有机玻璃"])
("yjbm" ["演变"])
("yjbv" ["一蹶不振"])
("yjcg" ["岩层"])
("yjci" ["严词" "言辞" "言词"])
("yjck" ["烟草"])
("yjcs" ["烟囱"])
("yjd'" ["雅加达" "盐碱地"])
("yjdb" ["烟斗"])
("yjdi" ["眼底"])
("yjdl" ["烟袋"])
("yjdm" ["唁电"])
("yjds" ["严冬" "岩洞"])
("yje'" "奄掩眼衍演厣剡俨偃兖郾琰罨魇鼹鼽")
("yjfa" ["盐法"])
("yjfh" ["严防" "验方"])
("yjfj" ["厌烦"])
("yjfl" ["有机肥料"])
("yjfu" ["严复"])
("yjgd" ["眼光" "验光"])
("yjge" ["阉割" "严格" "沿革"])
("yjgl" ["掩盖"])
("yjgo" ["烟锅"])
("yjgy" ["冶金工业"])
("yjh'" ["盐碱化" "一句话" "有计划" "月季花"])
("yjhb" ["咽喉"])
("yjhe" ["延河" "言和" "沿河"])
("yjhi" ["有机合成"])
("yjhj" ["严寒"])
("yjhl" ["沿海"])
("yjho" ["烟火" "焰火"])
("yjhr" ["延缓"])
("yjhs" ["眼红"])
("yjhu" ["盐湖" "掩护"])
("yjhv" ["烟灰" "宴会"])
("yjhw" ["烟花" "眼花" "演化" "有机化合物"])
("yjhx" ["有机化学"])
("yji'" ["养鸡场"])
("yjif" ["烟尘"])
("yjig" ["盐城" "严惩"])
("yjih" ["盐场" "延长" "演唱"])
("yjii" ["盐池" "延迟"])
("yjis" ["眼虫"])
("yjiu" ["演出"])
("yjjc" ["眼角"])
("yjjd" ["岩浆" "沿江" "演讲"])
("yjjm" ["烟碱" "盐碱" "眼见" "眼睑"])
("yjjn" ["严禁" "演进"])
("yjjp" ["严峻"])
("yjjq" ["研究"])
("yjjr" ["厌倦"])
("yjju" ["演剧"])
("yjjx" ["眼界"])
("yjjy" ["眼睛" "眼镜" "燕京"])
("yjkd" ["眼眶"])
("yjke" ["眼科"])
("yjkj" ["眼看"])
("yjku" ["严酷"])
("yjlc" ["颜料"])
("yjld" ["一举两得"])
("yjli" ["严厉" "眼里" "眼力" "艳丽"])
("yjlp" ["言论"])
("yjlu" ["盐卤" "沿路"])
("yjlx" ["英吉利海峡"])
("yjly" ["严令"])
("yjlz" ["盐类" "眼泪"])
("yjm'" ["眼睫毛"])
("yjmi" ["严密"])
("yjml" ["掩埋" "燕麦"])
("yjmo" ["淹没" "研磨"])
("yjmu" ["烟幕"])
("yjmy" ["严明"])
("yjmz" ["烟煤"])
("yjn'" ["阳极泥"])
("yjng" ["焉能"])
("yjnm" ["延年"])
("yjpi" ["眼皮"])
("yjq'" "焉咽阉烟淹燕殷鄢菸崦恹阏湮嫣胭腌")
("yjqi" ["延期"])
("yjqm" ["眼前"])
("yjqq" ["眼球"])
("yjqr" ["眼圈"])
("yjqy" ["宴请"])
("yjr'" "咽研沿艳堰燕厌砚雁唁彦焰宴谚验赝谳滟晏焱酽餍")
("yjre" ["炎热"])
("yjrj" ["俨然" "嫣然"])
("yjrs" ["岩溶"])
("yjs'" ["研究所"])
("yjse" ["颜色" "眼色"])
("yjsi" ["淹死"])
("yjsr" ["盐酸" "演算" "验算"])
("yjsu" ["严肃"])
("yjt'" ["盐碱土" "有机体"])
("yjtb" ["咽头" "烟头"])
("yjti" ["掩体"])
("yjtj" ["言谈"])
("yjtk" ["研讨"])
("yjtl" ["烟台"])
("yjts" ["烟筒"])
("yjtu" ["烟土" "盐土" "沿途"])
("yju'" ["研究生" "研究室" "药剂师"])
("yjub" ["严守" "验收"])
("yjue" ["衍射"])
("yjuf" ["延伸" "眼神"])
("yjuh" ["盐商"])
("yjui" ["岩石" "掩饰" "眼时" "演示" "验尸"])
("yjuj" ["盐山" "燕山"])
("yjuo" ["演说"])
("yjuv" ["盐水" "盐税"])
("yjv'" ["游击战" "有机质"])
("yjvb" ["兖州"])
("yjve" ["言者" "沿着"])
("yjvg" ["严整" "严正" "炎症" "验证" "永久中立国"])
("yjvi" ["研制" "胭脂" "一技之长"])
("yjvj" ["延展"])
("yjvq" ["有价证券"])
("yjvs" ["严重"])
("yjw'" "铅盐严研蜒岩延言颜阎炎沿阽芫闫妍檐筵")
("yjwh" ["阎王"])
("yjwo" ["眼窝" "燕窝"])
("yjwu" ["烟雾" "延误" "厌恶"])
("yjx'" ["永久性"])
("yjxi" ["盐析" "沿袭" "演习" "演戏" "宴席"])
("yjxm" ["沿线"])
("yjxn" ["岩心" "焰心"])
("yjxr" ["养精畜锐"])
("yjxt" ["验血"])
("yjxu" ["延续"])
("yjxw" ["眼下"])
("yjxy" ["严刑" "言行"])
("yjy'" ["研究员"])
("yjye" ["烟叶" "盐业"])
("yjyi" ["演义"])
("yjyj" ["岩盐" "燕燕" "又急又惊"])
("yjyr" ["演员"])
("yjys" ["沿用"])
("yjyu" ["言语" "谚语" "拥军优属"])
("yjyy" ["掩映"])
("yjzb" ["演奏"])
("yjzi" ["燕子"])
("yk'" ["依靠"])
("ykba" ["摇把" "要把"])
("ykbi" ["摇臂" "要比"])
("ykbk" ["腰包"])
("ykbl" ["摇摆" "遥摆"])
("ykbu" ["腰部" "要不"])
("ykce" ["遥测"])
("ykcl" ["药材"])
("ykcs" ["要从"])
("ykde" ["要得"])
("ykdh" ["摇荡"])
("ykdi" ["要地"])
("ykdk" ["妖道" "要到" "要道"])
("ykdl" ["腰带"])
("ykdm" ["要点"])
("ykds" ["摇动" "窑洞"])
("ykdv" ["要对"])
("yke'" "咬舀崾杳窈")
("ykff" ["药粉"])
("ykfg" ["妖风"])
("ykfh" ["药方" "药房"])
("ykfj" ["要犯" "要饭"])
("ykfz" ["药费"])
("ykgj" ["摇杆" "遥感"])
("ykgk" ["药膏"])
("ykgs" ["邀功" "要公"])
("ykgu" ["腰鼓"])
("ykgy" ["妖怪"])
("ykgz" ["要给"])
("ykhd" ["摇晃"])
("ykhe" ["要和" "吆喝"])
("ykhk" ["要好"])
("ykhl" ["药害" "要害"])
("ykhw" ["腰花"])
("ykie" ["摇车"])
("ykih" ["药厂"])
("ykir" ["谣传"])
("ykis" ["要冲"])
("ykjd" ["要将"])
("ykji" ["邀集" "药剂"])
("ykjm" ["要件"])
("ykjn" ["要紧"])
("ykjq" ["药酒" "要就"])
("ykjy" ["妖精"])
("ykkk" ["要靠"])
("ykks" ["遥控"])
("ykld" ["药量"])
("yklj" ["摇篮"])
("yklt" ["要略"])
("ykly" ["要领"])
("ykme" ["要么"])
("ykmo" ["妖魔" "约摸"])
("ykmu" ["要目"])
("ykmy" ["要命"])
("ykpm" ["药片"])
("ykpn" ["药品"])
("ykpu" ["药铺"])
("ykq'" ["邀" "腰" "妖" "要" "约" "夭" "吆" "幺" "一口气"])
("ykqd" ["要强"])
("ykqq" ["要求"])
("ykqy" ["邀请"])
("ykr'" "疟药要耀钥曜鹞")
("ykrf" ["要人"])
("ykrh" ["要让"])
("yks'" ["雅克萨"])
("yksl" ["要塞"])
("yksr" ["腰酸"])
("ykst" ["忆苦思甜"])
("yksu" ["要素"])
("yktb" ["摇头"])
("ykts" ["要同"])
("yktu" ["异口同声"])
("ykub" ["摇手"])
("ykui" ["要使" "要事" "要是" "钥匙"])
("ykup" ["尧舜"])
("ykuv" ["药水"])
("ykve" ["夭折"])
("ykvi" ["要职"])
("ykvj" ["腰斩"])
("ykvu" ["咬住"])
("ykw'" "侥陶瑶摇尧遥窑谣姚爻徭珧轺肴铫繇鳐")
("ykwf" ["要闻"])
("ykwj" ["药丸"])
("ykwu" ["药物"])
("ykwz" ["腰围" "要为"])
("ykxd" ["要想" "要向"])
("ykxx" ["要挟"])
("ykxy" ["药性"])
("ykya" ["咬牙"])
("ykyb" ["要由" "要有"])
("ykyd" ["一口咬定"])
("ykye" ["摇曳"])
("ykyi" ["要以" "要义" "徭役"])
("ykyj" ["谣言" "耀眼"])
("ykyk" ["摇摇" "遥遥"])
("ykyr" ["遥远"])
("ykys" ["要用"])
("ykyt" ["邀约"])
("ykyu" ["要与"])
("ykzi" ["腰子"])
("ykzl" ["要在"])
("ykzo" ["要做"])
("ykzu" ["瑶族"])
("yl'" ["以来"])
("ylb'" ["压力表" "英联邦" "一览表"])
("ylbx" ["医疗保险"])
("yldv" ["优良单株"])
("ylf'" ["医疗费"])
("ylfi" ["有理方程"])
("ylfr" ["以理服人"])
("ylid" ["液力传动"])
("ylj'" ["压力机" "压力降" "鸭绿江"])
("yljj" ["因陋就简"])
("ylk'" ["伊拉克"])
("ylkt" ["有利可图"])
("yll'" ["幼龄林" "月利率"])
("ylp'" ["玉兰片"])
("ylq'" ["雨量器"])
("yls'" ["亚硫酸" "叶绿素"])
("ylsl" ["耶路撒冷"])
("ylsy" ["亚硫酸盐"])
("ylt'" ["叶绿体" "鱼雷艇"])
("ylu'" ["阅览室"])
("ylud" ["亚历山大"])
("ylx'" ["鱼类学"])
("yly'" ["元老院" "越来越" "有利于"])
("ylyj" ["由来已久"])
("ylyy" ["一劳永逸"])
("ylz'" ["阴离子"])
("ylzj" ["雅鲁藏布江"])
("ylzw" ["油料作物"])
("ym'" ["以免"])
("yme'" ["伊妹儿"])
("ymgd" ["有目共睹"])
("ymgj" ["阴谋诡计"])
("ymh'" ["饮马河"])
("ymig" ["圆满成功"])
("ymj'" ["阴谋家" "圆面积"])
("ymlr" ["一目了然"])
("ymm'" ["玉米面" "玉米螟"])
("ymq'" ["译码器" "羽毛球"])
("ymsh" ["亚马孙河"])
("ymtq" ["扬眉吐气"])
("ymvx" ["鱼米之乡"])
("ymwu" ["有名无实"])
("ymwv" ["愚昧无知"])
("ymxi" ["一脉相承"])
("ymy'" ["有没有"])
("ymyy" ["一模一样"])
("yn'" ["一年"])
("ynan" ["阴暗"])
("ynbc" ["音标"])
("ynbi" ["荫蔽" "银币" "隐蔽"])
("ynbk" ["引爆"])
("ynbl" ["银白"])
("ynbo" ["音波"])
("ynch" ["隐藏"])
("ynci" ["因此" "因次"])
("yndc" ["音调"])
("ynde" ["引得"])
("yndh" ["淫荡"])
("yndk" ["阴道" "引导"])
("yndm" ["阴电"])
("yndt" ["一年到头"])
("yndu" ["引渡" "印度"])
("yne'" "殷饮尹引隐吲瘾蚓")
("yner" ["因而" "银耳"])
("ynfa" ["引发" "印发"])
("ynff" ["音分"])
("ynfu" ["音符" "隐伏"])
("yngf" ["银根"])
("yngj" ["阴干"])
("yngk" ["音高"])
("yngo" ["因果"])
("yngu" ["因故"])
("ynhe" ["音和" "银河"])
("ynhf" ["饮恨" "印痕"])
("ynhh" ["银行"])
("ynhj" ["隐含"])
("ynhk" ["引号"])
("ynhr" ["隐患"])
("ynhv" ["银灰" "淫秽"])
("ynhw" ["银桦" "印花"])
("ynia" ["音叉"])
("ynif" ["阴沉"])
("ynig" ["音程"])
("ynir" ["银川"])
("yniu" ["引出"])
("ynji" ["阴极"])
("ynjn" ["引进"])
("ynjq" ["饮酒"])
("ynju" ["隐居"])
("ynjx" ["音阶" "音节"])
("ynjy" ["阴茎"])
("ynkd" ["银矿"])
("ynlc" ["饮料"])
("ynld" ["音量" "阴凉" "银两"])
("ynli" ["阴历" "银粒" "引理" "引力"])
("ynlq" ["引流"])
("ynlr" ["淫乱"])
("ynlu" ["引路"])
("ynlv" ["音律"])
("ynma" ["音码"])
("ynmb" ["阴谋"])
("ynmj" ["隐瞒"])
("ynmu" ["银幕"])
("ynmy" ["音名"])
("ynnh" ["阴囊"])
("ynni" ["隐匿" "印尼"])
("ynpg" ["荫棚"])
("ynpl" ["银牌"])
("ynpn" ["音频"])
("ynq'" "烟茵荫因殷音阴姻堙喑洇湮氤铟")
("ynqc" ["引桥"])
("ynqi" ["银器" "引起"])
("ynqm" ["银钱"])
("ynqn" ["殷勤" "姻亲"])
("ynqu" ["音区"])
("ynqx" ["殷切"])
("ynr'" ["荫" "饮" "印" "胤" "茚" "窨" "越南人"])
("ynrf" ["引人"])
("ynrj" ["印染"])
("ynru" ["引入"])
("ynse" ["音色"])
("ynsf" ["阴森"])
("ynsj" ["一年四季"])
("ynsu" ["因素" "音速"])
("yntm" ["阴天"])
("yntr" ["银团"])
("ynu'" ["云南省"])
("ynuf" ["引申"])
("ynui" ["因式" "饮食" "隐士"])
("ynuj" ["阴山"])
("ynuu" ["因数" "引述"])
("ynuv" ["饮水" "引水"])
("ynuw" ["印刷"])
("ynvg" ["引证" "印证"])
("ynvh" ["印章"])
("ynvi" ["音质" "印制"])
("ynvp" ["音准"])
("ynvs" ["引种"])
("ynvx" ["洋奴哲学"])
("ynw'" "吟银淫寅鄞圻垠狺夤霪龈")
("ynwf" ["引文"])
("ynwz" ["因为" "音位" "淫威"])
("ynxd" ["音响" "印象"])
("ynxi" ["因袭"])
("ynxm" ["阴险" "引线"])
("ynxn" ["音信" "印信"])
("ynxp" ["因循" "音讯"])
("ynxu" ["殷墟"])
("ynxy" ["音型" "阴性" "银杏" "隐型" "隐性" "印行"])
("ynyb" ["因由" "引诱"])
("ynyh" ["阴阳"])
("ynyj" ["引言"])
("ynyn" ["隐隐"])
("ynyp" ["音韵" "阴云"])
("ynyr" ["因缘" "姻缘"])
("ynys" ["引用"])
("ynyt" ["音乐" "隐约"])
("ynyu" ["音域" "阴雨" "阴郁"])
("ynyy" ["阴影"])
("ynzi" ["因子" "银子" "引子" "印子"])
("yoq'" "哟育唷")
("yot'" "哟")
("ypbu" ["韵部"])
("ypcg" ["云层"])
("ypch" ["蕴藏"])
("ypcl" ["云彩"])
("ypdb" ["熨斗"])
("ypdi" ["运抵"])
("ypdj" ["运单"])
("ypdk" ["运道" "晕倒"])
("ypds" ["运动"])
("ypdy" ["云顶"])
("ype'" "陨允狁殒")
("ypfu" ["孕妇"])
("ypfz" ["运费"])
("ypgv" ["云贵"])
("yphe" ["运河"])
("yphj" ["蕴涵"])
("yphv" ["运会"])
("ypib" ["运筹"])
("ypie" ["晕车"])
("ypif" ["匀称"])
("ypir" ["晕船"])
("ypjc" ["韵脚"])
("ypji" ["云集"])
("ypls" ["云龙"])
("yplv" ["韵律"])
("ypmu" ["云母" "韵母"])
("ypmy" ["鸦片贸易"])
("ypnd" ["酝酿"])
("ypnj" ["云南"])
("ypno" ["允诺"])
("ypq'" "晕氲")
("ypqi" ["运气" "孕期"])
("ypqq" ["运球"])
("ypqt" ["云雀"])
("ypr'" "均员运蕴酝晕韵孕郓恽愠韫熨")
("yprj" ["匀染"])
("ypsr" ["运算"])
("ypss" ["运送"])
("ypsv" ["孕穗"])
("ypti" ["云梯"])
("yptm" ["云天"])
("yptu" ["云图"])
("ypui" ["云室" "陨石"])
("ypuj" ["云杉" "云山"])
("ypuu" ["运输"])
("ypv'" ["压迫者"])
("ypvg" ["匀整"])
("ypvr" ["运转"])
("ypvv" ["鸦片战争"])
("ypw'" "员耘云郧匀芸纭昀筠")
("ypwh" ["运往"])
("ypwu" ["云雾"])
("ypxc" ["运销"])
("ypxu" ["允许"])
("ypxw" ["云霞"])
("ypxy" ["运行"])
("ypyj" ["云烟"])
("ypyp" ["云云"])
("ypys" ["运用"])
("ypyu" ["云雨" "孕育"])
("ypyy" ["运营"])
("ypzl" ["运载"])
("yq'" ["仪器"])
("yqbf" ["一去不复返"])
("yqbt" ["一窍不通"])
("yqby" ["有求必应"])
("yqd'" ["优缺点"])
("yqei" ["一清二楚"])
("yqff" ["意气风发"])
("yqms" ["以权谋私"])
("yqp'" ["氧气瓶"])
("yqr'" ["有钱人" "有情人"])
("yqs'" ["邀请赛"])
("yqtx" ["有期徒刑"])
("yqwl" ["有气无力"])
("yqz'" ["一清早"])
("yr'" ["又如"])
("yran" ["冤案" "原案"])
("yrbf" ["元本" "原本"])
("yrbj" ["原版"])
("yrbk" ["元宝"])
("yrbo" ["渊博"])
("yrd'" ["亚热带"])
("yrda" ["远大"])
("yrdi" ["原地" "园地"])
("yrdj" ["元旦"])
("yrdk" ["远道"])
("yrdm" ["原点" "圆点"])
("yrds" ["远东"])
("yrdy" ["原定" "园丁"])
("yre'" "远")
("yrej" ["迎刃而解"])
("yrey" ["因人而异"])
("yrff" ["怨愤"])
("yrfh" ["远方" "远房"])
("yrfz" ["远非"])
("yrge" ["远隔"])
("yrgh" ["圆钢"])
("yrgk" ["原稿" "原告"])
("yrgl" ["原该"])
("yrgs" ["员工"])
("yrgu" ["原故" "缘故" "远古"])
("yrgv" ["圆规"])
("yrhb" ["猿猴"])
("yrhf" ["怨恨"])
("yrhh" ["远航"])
("yrhp" ["冤魂"])
("yrhu" ["圆弧"])
("yrhw" ["圆滑"])
("yrib" ["冤仇"])
("yrig" ["远程"])
("yrik" ["元朝"])
("yris" ["原虫"])
("yriu" ["元初" "远处"])
("yrjc" ["远郊"])
("yrji" ["原基" "原籍"])
("yrjm" ["元件" "远见"])
("yrjn" ["远近"])
("yrjp" ["援军"])
("yrjq" ["援救"])
("yrjw" ["一如既往" "冤家" "元嘉" "原价"])
("yrjy" ["圆经" "远景"])
("yrjz" ["与日俱增"])
("yrkd" ["原矿"])
("yrlc" ["原料"])
("yrld" ["原粮" "原谅"])
("yrli" ["原理"])
("yrlk" ["元老"])
("yrll" ["原来"])
("yrln" ["园林"])
("yrlo" ["院落"])
("yrlq" ["源流"])
("yrmf" ["辕门"])
("yrmj" ["圆满"])
("yrmm" ["原棉"])
("yrmu" ["原木"])
("yrmz" ["原煤"])
("yrnm" ["元年"])
("yrnz" ["院内"])
("yrpj" ["圆盘"])
("yrq'" "鸳渊冤眢鸢箢")
("yrqi" ["元气" "怨气"])
("yrqn" ["园寝"])
("yrqq" ["圆球"])
("yrqr" ["圆圈" "源泉"])
("yrqu" ["冤屈" "元曲"])
("yrr'" "苑愿怨院垸掾媛瑗")
("yrrp" ["圆润"])
("yrru" ["引人入胜"])
("yrse" ["原色"])
("yrsu" ["元素"])
("yrtb" ["源头"])
("yrti" ["原体"])
("yrtl" ["圆台"])
("yrtm" ["园田"])
("yrts" ["圆筒"])
("yrub" ["元首"])
("yruf" ["渊深" "原审"])
("yrug" ["原生"])
("yrui" ["元史" "原诗" "原始" "原是" "院士"])
("yruj" ["元山"])
("yruk" ["袁绍"])
("yruy" ["元帅"])
("yrvb" ["圆周"])
("yrvd" ["原状"])
("yrvg" ["远征"])
("yrvh" ["院长"])
("yrvm" ["引人注目"])
("yrvo" ["圆桌"])
("yrvs" ["原种"])
("yrvu" ["原主" "原著" "援助" "圆珠" "圆柱"])
("yrvv" ["圆锥"])
("yrw'" ["元" "垣" "袁" "原" "援" "辕" "园" "员" "圆" "猿" "源" "缘" "塬" "芫" "圜" "沅" "媛" "橼" "爰" "螈" "鼋" "易燃物"])
("yrwf" ["原文"])
("yrwh" ["冤枉" "远望" "愿望"])
("yrwl" ["院外"])
("yrwu" ["原物" "与人为善"])
("yrwz" ["愿为"])
("yrxc" ["远销" "院校"])
("yrxm" ["原先"])
("yrxn" ["圆心"])
("yrxy" ["原型" "原形" "原性" "圆形"])
("yryb" ["原由" "原油" "原有" "缘由"])
("yrye" ["原野"])
("yryh" ["鸳鸯" "远洋"])
("yryi" ["原意" "园艺" "愿意"])
("yryj" ["原盐" "怨言"])
("yryn" ["元音" "原因" "原音" "援引"])
("yryr" ["渊源" "源源" "远远"])
("yrys" ["援用"])
("yryt" ["元月"])
("yryu" ["冤狱"])
("yrze" ["原则"])
("yrzi" ["元子" "原子" "园子" "院子"])
("yrzl" ["远在"])
("yrzo" ["原作"])
("ys'" ["意思"])
("ysan" ["永安"])
("ysb'" ["压缩比"])
("ysbg" ["一丝不苟"])
("ysbk" ["拥抱"])
("ysbu" ["永不"])
("ysbx" ["永别"])
("ysby" ["野叟曝言" "拥兵" "用兵"])
("ysci" ["永磁"])
("ysdk" ["用到"])
("ysdl" ["拥戴"])
("ysdo" ["用度"])
("ysdy" ["永定"])
("yse'" "踊蛹咏泳涌永恿勇俑甬")
("ysf'" ["约瑟夫"])
("ysfa" ["用法"])
("ysfh" ["元素符号"])
("ysfl" ["有丝分裂"])
("ysfz" ["用费"])
("ysgd" ["用光"])
("ysgj" ["勇敢"])
("ysgo" ["用过"])
("ysgs" ["佣工" "用功"])
("ysh'" ["庸俗化"])
("yshe" ["永和"])
("yshg" ["永恒"])
("yshu" ["拥护" "用户"])
("ysi'" ["杨嗣昌"])
("ysih" ["永昌" "用场"])
("ysiu" ["用处"])
("ysj'" ["压缩机"])
("ysji" ["拥挤" "用计"])
("ysjl" ["庸俗进化论"])
("ysjn" ["涌进" "用尽" "用劲"])
("ysjq" ["永久" "用旧"])
("ysju" ["用具" "有色金属"])
("ysjw" ["永嘉"])
("yskq" ["压缩空气"])
("ysl'" ["以色列"])
("yslb" ["伊斯兰堡"])
("yslc" ["用了"])
("ysld" ["用量"])
("ysle" ["永乐"])
("ysli" ["用力"])
("yslj" ["伊斯兰教"])
("ysll" ["用来"])
("yslu" ["庸碌"])
("ysmg" ["勇猛"])
("ysmy" ["用命"])
("ysnm" ["永年"])
("ysny" ["永宁"])
("yspn" ["用品"])
("yspy" ["野叟曝言" "永平"])
("ysq'" ["拥" "佣" "臃" "痈" "庸" "雍" "壅" "墉" "慵" "邕" "镛" "鳙" "饔" "运算器" "孕穗期"])
("ysqi" ["勇气"])
("ysqm" ["用钱"])
("ysqy" ["永清"])
("ysr'" "佣用")
("ysrf" ["佣人" "庸人" "用人"])
("ysru" ["涌入"])
("ysrv" ["有色人种"])
("yssu" ["庸俗"])
("ystj" ["咏叹"])
("ystu" ["用途"])
("ysug" ["永生" "永胜"])
("ysui" ["永世" "勇士" "用事"])
("ysvd" ["匀速转动"])
("ysvg" ["雍正"])
("ysvs" ["臃肿"])
("ysw'" "喁")
("yswu" ["用武"])
("ysxm" ["涌现"])
("ysxn" ["永新" "用心"])
("ysxy" ["永兴"])
("ysyb" ["拥有"])
("ysyd" ["匀速运动"])
("ysyi" ["用以" "用意"])
("ysyp" ["用韵"])
("ysyr" ["永远"])
("ysyt" ["踊跃"])
("ysyu" ["勇于" "用于" "用语"])
("yszl" ["用在"])
("yszv" ["用嘴"])
("yt'" ["用途"])
("ytbk" ["月报"])
("ytbu" ["越不"])
("ytbw" ["有条不紊"])
("ytby" ["阅兵"])
("ytda" ["越大"])
("ytdi" ["月底"])
("ytdj" ["约旦"])
("ytdo" ["越多"])
("ytdr" ["乐段"])
("ytds" ["越冬"])
("ytdu" ["阅读"])
("ytdv" ["乐队"])
("ytdw" ["一天到晚"])
("ytdy" ["约定"])
("yter" ["悦耳"])
("ytfa" ["约法" "越发"])
("ytff" ["约分" "月分" "月份"])
("ytfu" ["乐府" "岳父"])
("ytfz" ["岳飞"])
("ytgd" ["月光"])
("ytgk" ["越高"])
("ytgo" ["越过"])
("ytgs" ["月工"])
("ytgv" ["越轨"])
("yth'" ["一体化" "园田化" "研讨会"])
("ythj" ["约翰"])
("ythk" ["越好"])
("ythn" ["摇头晃脑"])
("ythv" ["约会"])
("ytiu" ["月初" "月出"])
("ytji" ["约计"])
("ytjn" ["跃进"])
("ytju" ["乐句" "越剧" "粤剧"])
("ytjx" ["越界"])
("ytjy" ["月经"])
("ytke" ["约克"])
("ytkj" ["月刊"])
("ytkq" ["液态空气"])
("ytky" ["越快"])
("ytl'" ["一条龙"])
("ytld" ["月亮"])
("ytli" ["月利" "阅历"])
("ytlj" ["阅览"])
("ytll" ["越来"])
("ytlt" ["约略"])
("ytly" ["月龄"])
("ytmj" ["越慢"])
("ytmo" ["约摸" "约莫" "月末"])
("ytmu" ["岳母" "悦目"])
("ytnj" ["越南"])
("ytpc" ["月票"])
("ytpu" ["乐谱"])
("ytq'" "曰约")
("ytqi" ["乐器" "跃起"])
("ytqm" ["跃迁"])
("ytqn" ["月琴"])
("ytqq" ["月球"])
("ytqr" ["越权"])
("ytqu" ["乐曲"])
("ytr'" ["乐" "说" "越" "跃" "钥" "岳" "粤" "月" "悦" "阅" "龠" "瀹" "栎" "樾" "刖" "钺" "犹太人"])
("ytrl" ["液体燃料"])
("ytse" ["月色"])
("ytt'" ["姨太太"])
("yttj" ["迎头痛击" "月坛"])
("yttl" ["月台"])
("yttr" ["乐团"])
("ytts" ["约同"])
("ytui" ["越是" "月食" "月蚀"])
("ytuk" ["越少"])
("ytuu" ["约束" "约数"])
("ytvb" ["岳州"])
("ytvh" ["乐章"])
("ytvj" ["约占"])
("ytvs" ["月中" "月终"])
("ytw'" ["英特网" "语体文"])
("ytwz" ["约为" "越位"])
("ytxn" ["月薪"])
("ytya" ["月牙"])
("ytyb" ["约有" "越有"])
("ytye" ["越野" "月夜"])
("ytyk" ["越要"])
("ytyl" ["有条有理"])
("ytyn" ["乐音"])
("ytyu" ["越狱"])
("yu'" ["于是"])
("yuba" ["渔霸"])
("yubf" ["愚笨"])
("yubi" ["郁闭"])
("yubk" ["预报"])
("yubu" ["余步"])
("yubx" ["一声不响"])
("yubz" ["预备"])
("yuce" ["预测"])
("yuci" ["于此" "遇刺"])
("yud'" ["意识到"])
("yudc" ["语调" "玉雕"])
("yude" ["欲得"])
("yudf" ["御史大夫"])
("yudh" ["余党"])
("yudi" ["愚弟" "余地"])
("yudk" ["鱼道" "遇到"])
("yudm" ["雨点"])
("yudu" ["余毒" "鱼肚"])
("yudw" ["原生动物"])
("yudy" ["预定" "预订"])
("yudz" ["右手定则"])
("yue'" "予雨与屿禹宇语羽伛俣圄圉庾瘐窳龉")
("yuee" ["余额"])
("yufa" ["语法"])
("yuff" ["鱼粉" "预分"])
("yufh" ["预防"])
("yufj" ["因式分解"])
("yufu" ["渔夫" "预付"])
("yufz" ["于飞" "育肥"])
("yugb" ["预购"])
("yuge" ["余割" "渔歌"])
("yugh" ["渔港" "浴缸"])
("yugj" ["预感"])
("yugk" ["预告"])
("yugo" ["与国"])
("yugs" ["与共"])
("yugu" ["原始公社"])
("yuh'" ["于是乎"])
("yuhb" ["雨后"])
("yuhd" ["玉皇"])
("yuhe" ["愈合"])
("yuhh" ["宇航"])
("yuhj" ["御寒"])
("yuhk" ["愈好"])
("yuhl" ["遇害"])
("yuhr" ["玉环"])
("yuhv" ["迂回" "与会" "语汇"])
("yuhw" ["鱼花" "羽化"])
("yuhx" ["游手好闲"])
("yuia" ["鱼叉"])
("yuib" ["运输成本"])
("yuih" ["渔场" "浴场"])
("yuii" ["鱼池" "鱼翅" "浴池"])
("yuip" ["愚蠢"])
("yuir" ["渔船"])
("yuiu" ["育雏"])
("yuj'" ["艺术家" "印刷机" "运输机"])
("yujc" ["余角"])
("yuji" ["雨季" "预计" "瘀积"])
("yujl" ["原始积累" "原始记录"])
("yujm" ["遇见" "预见"])
("yujn" ["于今"])
("yuju" ["渔具" "语句" "豫剧"])
("yujw" ["余家" "愈加"])
("yuk'" ["袁世凯"])
("yuky" ["愉快"])
("yul'" ["运输量"])
("yulc" ["预料"])
("yuld" ["因势利导" "余粮" "雨量"])
("yule" ["娱乐"])
("yulf" ["饮食疗法"])
("yuli" ["余利" "渔利" "狱吏"])
("yulj" ["玉兰"])
("yulk" ["渔捞"])
("yull" ["有生力量" "愈来"])
("yuln" ["鱼鳞" "玉林" "育林"])
("yulp" ["舆论" "渔轮"])
("yulr" ["鱼卵"])
("yulu" ["雨露" "语录"])
("yulv" ["余氯"])
("yulx" ["渔猎"])
("yuly" ["育龄"])
("yulz" ["鱼雷" "鱼类"])
("yum'" ["艺术美"])
("yumb" ["预谋"])
("yumc" ["鱼苗" "育苗"])
("yumf" ["玉门" "郁闷"])
("yumi" ["玉米"])
("yumk" ["羽毛"])
("yumn" ["愚民" "渔民"])
("yumz" ["愚昧"])
("yuni" ["淤泥" "瘀泥"])
("yunj" ["遇难"])
("yunl" ["运输能力"])
("yunm" ["余年" "欲念"])
("yuns" ["愚弄"])
("yunv" ["玉女" "育女"])
("yup'" ["艺术品"])
("yupm" ["鱼片"])
("yupv" ["原始凭证"])
("yuq'" "迂淤吁纡於瘀")
("yuqi" ["于七" "逾期" "渔期" "与其" "语气" "玉器" "预期"])
("yuqp" ["鱼群"])
("yuqt" ["余缺"])
("yuqu" ["渔区"])
("yuqx" ["余切"])
("yuqy" ["吁请"])
("yur'" "蔚尉雨与语玉域芋郁吁遇喻峪御愈欲狱育誉浴寓裕预豫驭粥毓谕菀蓣饫阈鬻妪昱煜熨燠聿钰鹆鹬蜮")
("yurb" ["鱼肉"])
("yure" ["预热"])
("yurf" ["愚人"])
("yurs" ["羽绒"])
("yuse" ["语塞"])
("yusi" ["于思"])
("yusj" ["雨伞"])
("yusl" ["预赛"])
("yuso" ["寓所"])
("yusr" ["预算"])
("yut'" ["印刷体"])
("yutb" ["芋头"])
("yuth" ["鱼塘"])
("yutm" ["于田" "雨天"])
("yutr" ["一视同仁"])
("yuu'" ["玉蜀黍"])
("yuuf" ["预审"])
("yuug" ["鱼生"])
("yuuh" ["遇上" "原始社会"])
("yuui" ["于是" "玉石" "遇事" "浴室" "预示"])
("yuuu" ["榆树" "余数" "玉树"])
("yuuv" ["鱼水" "雨水"])
("yuv'" ["原生质"])
("yuvb" ["宇宙" "豫州"])
("yuvf" ["余震"])
("yuvi" ["预知" "预制" "谕旨"])
("yuvk" ["预兆"])
("yuvs" ["鱼种" "狱中" "育种"])
("yuvu" ["预祝"])
("yuvx" ["衣、食、住、行" "衣食住行"])
("yuw'" ["于" "盂" "榆" "虞" "愚" "舆" "余" "俞" "逾" "鱼" "愉" "渝" "渔" "隅" "予" "娱" "与" "禺" "谀" "萸" "揄" "嵛" "狳" "馀" "妤" "瑜" "觎" "腴" "欤" "窬" "蝓" "竽" "臾" "舁" "雩" "衍生物"])
("yuwf" ["语文"])
("yuwh" ["鱼网" "渔网" "欲望"])
("yuwi" ["一事无成"])
("yuwk" ["有恃无恐"])
("yuwl" ["域外"])
("yuwz" ["鱼尾" "喻为"])
("yux'" ["艺术性" "优生学" "运输线"])
("yuxd" ["预想"])
("yuxi" ["语系" "玉溪"])
("yuxm" ["余弦" "遇险" "预先"])
("yuxp" ["渔汛"])
("yuxt" ["意识形态" "雨雪" "浴血" "运输系统"])
("yuxw" ["余下"])
("yuxx" ["淤血" "瘀血"])
("yuy'" ["饮食业" "原生晕"])
("yuyb" ["摇身一变" "鱼油"])
("yuye" ["渔业"])
("yuyh" ["育秧"])
("yuyi" ["予以" "雨衣" "语义" "寓义"])
("yuyj" ["语言" "寓言" "预言"])
("yuyk" ["一时一刻" "余姚"])
("yuyn" ["余音" "语音"])
("yuys" ["有声有色" "御用"])
("yuyt" ["逾越" "预约"])
("yuyu" ["于于" "与与" "郁郁" "寓于"])
("yuz'" ["元世祖"])
("yuzd" ["怨声载道"])
("yuzi" ["纡子"])
("yuzz" ["以身作则"])
("yv'" ["一致"])
("yvam" ["拥政爱民"])
("yvb'" ["硬纸板"])
("yvbm" ["邮政编码"])
("yvbt" ["与众不同"])
("yvfi" ["宇宙飞船"])
("yvg'" ["优质钢" "宇宙观"])
("yvhj" ["硬质合金"])
("yvi'" ["养猪场"])
("yvj'" ["抑制剂" "圆周角"])
("yvkj" ["宇宙空间"])
("yvl'" ["圆周率"])
("yvm'" ["圆柱面"])
("yvq'" ["有志气"])
("yvqx" ["圆锥曲线"])
("yvt'" ["圆柱体"])
("yvtp" ["硬着头皮"])
("yvu'" ["已知数"])
("yvug" ["严重事故"])
("yvws" ["乙种维生素"])
("yvx'" ["严重性" "延展性" "宇宙线"])
("yvy'" ["一眨眼" "以至于" "有助于"])
("yvyd" ["圆周运动"])
("yvyl" ["言之有理"])
("yvyr" ["有朝一日"])
("yvz'" ["眼珠子"])
("yvzy" ["抑制作用"])
("yw'" ["以为"])
("ywd'" ["雅温得"])
("ywdj" ["一网打尽"])
("ywhj" ["宇文化及"])
("ywld" ["义务劳动"])
("ywlx" ["业务联系"])
("ywp'" ["洋务派"])
("ywsv" ["一无所知"])
("ywt'" ["宇文泰"])
("ywu'" ["医务室"])
("ywv'" ["艺文志" "意味着"])
("ywvq" ["勇往直前"])
("ywvy" ["洋为中用"])
("yww'" ["洋娃娃"])
("ywx'" ["药物学"])
("ywyd" ["洋务运动"])
("ywyu" ["一五一十"])
("yx'" ["一些"])
("yxbb" ["野心勃勃"])
("yxc'" ["一小撮"])
("yxdl" ["余弦定理"])
("yxf'" ["优选法"])
("yxfv" ["优先发展" "浴血奋战"])
("yxg'" ["优先股"])
("yxgb" ["有线广播"])
("yxgl" ["有效功率"])
("yxgs" ["有限公司"])
("yxh'" ["一席话" "有现货"])
("yxii" ["忧心忡忡"])
("yxj'" ["野心家" "圆心角"])
("yxl'" ["压下量" "一系列" "有效氯"])
("yxmj" ["有效面积"])
("yxp'" ["印象派"])
("yxq'" ["杨秀清" "有效期" "原线圈"])
("yxqy" ["一厢情愿"])
("yxr'" ["有心人"])
("yxs'" ["亚硝酸"])
("yxtk" ["异想天开"])
("yxu'" ["阎锡山"])
("yxuj" ["因循守旧"])
("yxuv" ["有性生殖"])
("yxuz" ["有效数字"])
("yxv'" ["有效值"])
("yxx'" ["有效性"])
("yxy'" ["亚细亚" "医学院"])
("yxyv" ["言行一致"])
("yxyy" ["一心一意"])
("yxz'" ["一下子"])
("yy'" ["由于"])
("yyan" ["应按"])
("yyba" ["应把"])
("yybb" ["原原本本"])
("yybh" ["英镑"])
("yybi" ["硬币"])
("yybj" ["犹豫不决"])
("yybm" ["应变"])
("yybn" ["迎宾"])
("yycl" ["英才"])
("yycp" ["英寸"])
("yyd'" ["永远的" "圆圆的" "远远的"])
("yydc" ["影调"])
("yyde" ["英德" "应得" "赢得"])
("yydh" ["应当"])
("yydi" ["营地"])
("yydu" ["硬度"])
("yydv" ["应对"])
("yydy" ["洋洋得意"])
("yye'" ["影" "颖" "郢" "瘿" "颍" "营业额"])
("yyer" ["婴儿"])
("yyfb" ["应否"])
("yyfg" ["迎风"])
("yyfh" ["营房"])
("yyfu" ["应付"])
("yyfv" ["营养繁殖"])
("yyg'" ["有用功"])
("yygd" ["荧光"])
("yygl" ["应该"])
("yygo" ["英国"])
("yygx" ["一意孤行"])
("yyh'" ["一元化"])
("yyhe" ["应和" "迎和" "迎合"])
("yyhj" ["英汉"])
("yyhl" ["婴孩"])
("yyho" ["萤火"])
("yyhw" ["樱花" "硬化"])
("yyhy" ["以牙还牙"])
("yyi'" ["养鱼池" "游泳池"])
("yyib" ["应酬"])
("yyig" ["应承"])
("yyii" ["英尺"])
("yyip" ["迎春"])
("yyir" ["颍川"])
("yyj'" ["压延机" "液压机" "义勇军"])
("yyjc" ["迎角"])
("yyjd" ["应将"])
("yyji" ["应急" "迎击" "影集"])
("yyjm" ["营建" "硬件"])
("yyjp" ["英俊"])
("yyjq" ["营救"])
("yyjr" ["夜以继日"])
("yyju" ["应用技术"])
("yyjx" ["迎接"])
("yyjy" ["应有尽有"])
("yykb" ["营口"])
("yyke" ["硬壳"])
("yykk" ["应考"])
("yykv" ["盈亏"])
("yykx" ["应用科学"])
("yyl'" ["一元论" "预应力"])
("yyld" ["英两"])
("yyli" ["英里" "应力" "营利" "赢利" "盈利" "源远流长"])
("yyll" ["迎来"])
("yylz" ["营垒"])
("yymm" ["迎面" "硬面"])
("yymu" ["英亩" "硬木" "映幕"])
("yymy" ["英明" "英名"])
("yypj" ["硬盘"])
("yypm" ["影片"])
("yypn" ["应聘"])
("yypy" ["影评"])
("yyq'" "英樱婴鹰应缨莺撄嘤膺瑛璎鹦罂")
("yyqg" ["营养器官"])
("yyqi" ["咬牙切齿"])
("yyqr" ["鹰犬"])
("yyr'" "应硬映媵")
("yyri" ["英日"])
("yys'" ["有意思"])
("yysi" ["营私"])
("yyss" ["迎送"])
("yyt'" ["一言堂" "有一套" "原叶体"])
("yytb" ["迎头"])
("yytk" ["樱桃"])
("yyu'" ["有意识"])
("yyub" ["应收"])
("yyue" ["影射" "映射"])
("yyug" ["应声" "营生"])
("yyui" ["英石" "应时" "应试" "萤石" "硬是"])
("yyuo" ["硬说"])
("yyuu" ["英数"])
("yyuv" ["营养生长" "硬水"])
("yyv'" ["亦有之"])
("yyvb" ["颍州"])
("yyvg" ["应征"])
("yyvh" ["营长"])
("yyvi" ["英制" "应制" "硬脂"])
("yyvj" ["应战" "迎战"])
("yyvk" ["营养状况" "映照"])
("yyw'" "莹萤营荧蝇迎赢盈嬴茔荥萦蓥滢潆瀛楹")
("yywf" ["英文"])
("yywj" ["引以为戒"])
("yywu" ["英武"])
("yywz" ["应为"])
("yyx'" ["羊应乡" "医药学" "优越性" "语言学"])
("yyxd" ["影响" "影像" "影象" "映象"])
("yyxi" ["影戏"])
("yyxj" ["语言学家"])
("yyxn" ["迎新"])
("yyxs" ["英雄"])
("yyxy" ["硬性"])
("yyy'" ["液压油" "营养盐" "运用于" "营业员"])
("yyyb" ["应由" "应有"])
("yyye" ["营业"])
("yyyh" ["营养"])
("yyyi" ["应以"])
("yyyj" ["应验"])
("yyyk" ["应邀"])
("yyyn" ["影印"])
("yyyp" ["应允" "应运"])
("yyyr" ["影院"])
("yyys" ["应用" "营养元素"])
("yyyu" ["英语" "盈余" "远洋运输"])
("yyyv" ["摇摇欲坠"])
("yyyx" ["奄奄一息"])
("yyyy" ["隐隐约约" "盈盈"])
("yyzi" ["英姿" "影子"])
("yyzk" ["营造"])
("yyzr" ["运用自如"])
("yz'" ["原则"])
("yzd'" ["原子弹"])
("yzgp" ["原子光谱"])
("yzh'" ["原子核"])
("yzhj" ["运载火箭"])
("yzj'" ["原子价"])
("yzjg" ["原子结构"])
("yzl'" ["叶宗留" "原子量"])
("yzn'" ["原子能"])
("yznd" ["原子能发电"])
("yzu'" ["原子说"])
("yzx'" ["原则性"])
("yzxu" ["原子序数"])
("yzy'" ["叶子烟"])
("z" "在")
("zack" ["杂草"])
("zae'" "咋")
("zafz" ["杂肥" "杂费"])
("zagj" ["杂感"])
("zaho" ["杂货"])
("zahv" ["砸毁"])
("zajc" ["杂交"])
("zaji" ["杂技" "杂记"])
("zaju" ["杂居" "杂剧"])
("zald" ["杂粮"])
("zalj" ["砸烂"])
("zalr" ["杂乱"])
("zapn" ["杂品"])
("zaq'" "匝扎拶咂")
("zase" ["杂色"])
("zasv" ["砸碎"])
("zaui" ["杂事"])
("zauo" ["杂说"])
("zauu" ["匝数"])
("zavi" ["杂志" "杂质"])
("zavs" ["杂种"])
("zaw'" "砸杂咱")
("zawf" ["杂文"])
("zawu" ["杂物"])
("zayn" ["杂音"])
("zazv" ["咂嘴"])
("zb'" ["资本"])
("zbbm" ["走边"])
("zbbu" ["走步"])
("zbdk" ["走到" "走道"])
("zbds" ["走动"])
("zbdv" ["资本的周转"])
("zbe'" "走")
("zbfh" ["走访"])
("zbg'" ["总罢工"])
("zbgb" ["走狗"])
("zbgo" ["走过"])
("zbhb" ["走后"])
("zbj'" ["资本家"])
("zbjl" ["资本积累"])
("zbjv" ["资本集中"])
("zbkl" ["走开"])
("zbl'" ["资本论" "自变量"])
("zblh" ["走廊"])
("zbll" ["走来"])
("zblu" ["走路"])
("zbma" ["走马"])
("zbq'" "邹诹陬鄹驺鲰")
("zbqu" ["走去"])
("zbr'" "奏揍")
("zbrs" ["邹容"])
("zbsi" ["走私"])
("zbsj" ["走散"])
("zbtx" ["载波通信"])
("zbuh" ["走上"])
("zbui" ["资本输出" "走失" "走时"])
("zbuu" ["奏疏"])
("zbvd" ["资本主义制度"])
("zbve" ["奏折"])
("zbvh" ["资本主义社会" "奏章"])
("zbvj" ["资本主义国家"])
("zbvv" ["资本周转"])
("zbvy" ["资本主义"])
("zbx'" ["再保险" "坐标系"])
("zbxc" ["奏效"])
("zbxd" ["走向"])
("zbxh" ["资本循环"])
("zbyh" ["走样"])
("zbyi" ["奏议"])
("zbyp" ["走运"])
("zbzu" ["走卒"])
("zc'" ["自从"])
("zcmb" ["总参谋部"])
("zcmv" ["总参谋长"])
("zdb'" ["子弟兵"])
("zdc'" ["阻挡层"])
("zdej" ["罪大恶极"])
("zdh'" ["自动化"])
("zdjc" ["自动检测"])
("zdjs" ["自动检索"])
("zdjy" ["自动驾驶仪"])
("zdkv" ["自动控制"])
("zdm'" ["纵断面"])
("zdqw" ["最低气温"])
("zdul" ["总的说来"])
("zdux" ["自动生产线"])
("zdx'" ["自动线"])
("zdxd" ["最大限度"])
("zdy'" ["总动员"])
("zdzv" ["自动增益控制"])
("zebu" ["则不"])
("zebz" ["责备"])
("zefa" ["择伐"])
("zegy" ["责怪"])
("zehl" ["则还"])
("zeig" ["责成"])
("zejd" ["则将"])
("zeke" ["则可"])
("zely" ["责令"])
("zema" ["责骂"])
("zemz" ["则没"])
("zeng" ["则能"])
("zenj" ["责难"])
("zer'" "侧仄昃")
("zerf" ["责任"])
("zeui" ["则是"])
("zevo" ["择捉"])
("zew'" "责择则泽咋赜啧帻迮笮箦舴")
("zewf" ["责问"])
("zexj" ["罪恶行径"])
("zeyb" ["择优"])
("zeyk" ["则要"])
("zeyv" ["总而言之"])
("zeze" ["啧啧"])
("zf'" ["做法"])
("zfe'" "怎")
("zfhv" ["怎会"])
("zflh" ["总分类帐户"])
("zfls" ["总分类核算"])
("zfme" ["怎么"])
("zfng" ["怎能"])
("zfr'" "谮")
("zfug" ["怎生"])
("zfv'" ["总方针"])
("zfvd" ["宗法制度"])
("zfyh" ["怎样"])
("zfyk" ["自负盈亏"])
("zg'" ["总共"])
("zgbo" ["增拨"])
("zgbu" ["增补"])
("zgby" ["增兵"])
("zgda" ["增大"])
("zgdo" ["增多"])
("zgdy" ["增订"])
("zge'" ["自个儿"])
("zgf'" ["曾国藩" "最高峰"])
("zgfy" ["自告奋勇"])
("zggd" ["增光"])
("zggk" ["增高"])
("zggz" ["赠给"])
("zgh'" ["总工会"])
("zghf" ["憎恨"])
("zgij" ["增产"])
("zgj'" ["最高级"])
("zgjm" ["增减"])
("zgjn" ["增进"])
("zgjw" ["增加"])
("zgld" ["增量"])
("zgn'" ["自耕农"])
("zgpn" ["赠品"])
("zgq'" "增憎曾缯罾")
("zgqd" ["增强"])
("zgqw" ["最高气温"])
("zgr'" "赠综缯甑锃")
("zgsp" ["曾孙"])
("zgss" ["赠送"])
("zgtm" ["增添"])
("zgue" ["增设"])
("zgug" ["增生"])
("zguj" ["增删"])
("zgvh" ["增长"])
("zgvi" ["增殖" "增值"])
("zgvu" ["最高指示"])
("zgwu" ["憎恶"])
("zgxr" ["增选"])
("zgya" ["增压"])
("zgyi" ["增益"])
("zgyl" ["自古以来"])
("zgyr" ["增援"])
("zgyu" ["赠与"])
("zgzd" ["自高自大"])
("zgzu" ["曾祖"])
("zgzz" ["自给自足"])
("zh'" ["综合"])
("zhe'" "驵")
("zhfv" ["综合防治"])
("zhjc" ["纵横交错" "纵横跤错"])
("zhkr" ["赃款"])
("zhli" ["藏历" "葬礼"])
("zhly" ["综合利用"])
("zhm'" ["走后门"])
("zhph" ["综合平衡"])
("zhq'" "赃锗臧")
("zhqb" ["总后勤部"])
("zhqi" ["脏器"])
("zhr'" "藏脏葬奘")
("zhss" ["葬送"])
("zhvl" ["综合治理"])
("zhwf" ["藏文"])
("zhwu" ["赃物"])
("zhyi" ["藏医"])
("zhzu" ["藏族"])
("zi'" ["做出"])
("ziai" ["自爱"])
("zibf" ["资本" "组成部分"])
("zibl" ["自白"])
("zici" ["字词"])
("zicl" ["紫菜"])
("zics" ["自从"])
("zida" ["自大"])
("zide" ["自得"])
("zidi" ["子弟"])
("zidj" ["子弹"])
("zidl" ["子代"])
("zidm" ["字典"])
("zids" ["自动"])
("zie'" "紫仔籽滓子茈姊梓秭耔笫訾")
("zier" ["子儿" "字儿"])
("zifa" ["自发"])
("zifb" ["资产负债表"])
("zifg" ["自封"])
("zifh" ["子房"])
("zifu" ["自负" "字符"])
("zifz" ["自费"])
("zigb" ["自购"])
("zige" ["资格"])
("zigs" ["子宫"])
("zigu" ["自古"])
("zigz" ["自给"])
("zihk" ["自豪" "字号"])
("zihs" ["紫红"])
("zihw" ["字画"])
("zii'" ["造船厂"])
("ziig" ["自称"])
("ziij" ["资产" "子产"])
("ziji" ["仔鸡" "自己" "字迹"])
("zijj" ["资产阶级"])
("zijn" ["资金" "紫金" "自尽"])
("zijq" ["自救"])
("zijt" ["自觉" "自决"])
("ziju" ["自居" "字据" "字距" "字句"])
("zijv" ["资产阶级民主"])
("zijw" ["自家"])
("zijx" ["字节"])
("zijy" ["增产节约" "自经"])
("zikb" ["子口"])
("ziku" ["字库"])
("zil'" ["总产量"])
("zilc" ["资料"])
("zili" ["资历" "资力" "子粒" "自理" "自立" "自力"])
("zill" ["子来" "自来"])
("zilq" ["自流"])
("zimj" ["自满"])
("zimm" ["籽棉" "子棉" "字面"])
("zimo" ["字模"])
("zimu" ["字模" "字母"])
("zimy" ["自命"])
("zimz" ["姊妹"])
("zinh" ["子囊"])
("zinv" ["子女"])
("zip'" ["在产品"])
("ziq'" "吱兹咨资姿滋淄孜仔谘呲嵫孳缁辎赀锱粢趑觜訾龇鲻髭")
("zir'" "自渍字恣眦")
("zirj" ["自然" "自燃"])
("zirk" ["滋扰"])
("ziro" ["自若"])
("zirp" ["滋润"])
("ziru" ["自如"])
("zise" ["紫色"])
("zisi" ["子思" "自私"])
("zisp" ["子孙"])
("zisu" ["自诉"])
("ziti" ["字体"])
("zitl" ["姿态"])
("zits" ["紫铜"])
("zitx" ["字贴"])
("ziua" ["自杀"])
("ziub" ["自首"])
("ziuf" ["自身"])
("ziug" ["滋生"])
("ziui" ["姿势" "滋事" "子时" "子实" "自是" "自恃"])
("ziuu" ["自述" "字数"])
("ziv'" ["总产值"])
("zivg" ["资政"])
("zivh" ["滋长"])
("zivi" ["自制" "自治"])
("zivr" ["自传" "自转"])
("zivs" ["自重" "辎重"])
("zivu" ["资助" "自主"])
("ziw'" ["自称为"])
("ziwf" ["咨文" "自问" "谘文"])
("ziwo" ["自我"])
("ziwu" ["子午"])
("ziwz" ["滋味" "自为" "自慰" "自卫"])
("zixd" ["自相"])
("zixi" ["仔细"])
("zixn" ["自新" "自信"])
("zixp" ["咨询" "谘询"])
("zixq" ["自修"])
("zixr" ["自选"])
("zixt" ["自学"])
("zixu" ["自叙" "自序"])
("zixw" ["子夏"])
("zixy" ["自行" "字型" "字形"])
("ziyb" ["兹有" "自由"])
("ziye" ["子叶" "子夜"])
("ziyh" ["滋养" "紫阳" "字样"])
("ziyi" ["字义" "谘议" "恣意"])
("ziyj" ["字眼"])
("ziyn" ["字音"])
("ziyr" ["资源" "自愿"])
("ziys" ["自用"])
("zizi" ["孜孜"])
("zizk" ["自造"])
("zizl" ["自在"])
("zizp" ["自尊"])
("zj'" ["总计"])
("zjba" ["糌粑"])
("zjd'" ["租借地"])
("zjdk" ["攒到"])
("zjdy" ["暂定"])
("zje'" "攒拶昝趱")
("zjge" ["赞歌"])
("zjgg" ["宗教改革"])
("zjhr" ["暂缓"])
("zjig" ["赞成"])
("zjj'" ["再结晶"])
("zjjw" ["咱家"])
("zjjy" ["总结经验"])
("zjli" ["赞礼"])
("zjlw" ["咱俩"])
("zjly" ["资金来源"])
("zjmf" ["咱们"])
("zjmz" ["赞美"])
("zjpb" ["资金平衡表"])
("zjq'" "簪糌")
("zjqb" ["杂交亲本"])
("zjqm" ["攒钱"])
("zjqt" ["暂缺"])
("zjqx" ["暂且"])
("zjr'" ["暂" "赞" "瓒" "錾" "自己人"])
("zjss" ["赞颂"])
("zjt'" ["咱" "杂技团"])
("zjtj" ["赞叹"])
("zjts" ["赞同"])
("zjty" ["暂停"])
("zju'" ["紫金山"])
("zjuh" ["赞赏"])
("zjui" ["暂时"])
("zjv'" ["杂交种"])
("zjvu" ["赞助"])
("zjvy" ["资金占用"])
("zjw'" "咱")
("zjx'" ["自交系" "总教习"])
("zjxu" ["赞许"])
("zjxy" ["暂行"])
("zjy'" ["再教育"])
("zjyh" ["赞扬"])
("zjys" ["暂用"])
("zjyu" ["赞誉"])
("zjyv" ["杂交育种"])
("zjyy" ["资金运用"])
("zjzi" ["錾子"])
("zjzl" ["再接再厉"])
("zjzy" ["自觉自愿"])
("zkan" ["早安"])
("zkcj" ["早餐"])
("zkck" ["早操"])
("zkdk" ["遭到" "早稻"])
("zkdm" ["早点"])
("zkds" ["躁动"])
("zke'" "藻枣早澡蚤缲")
("zkfj" ["早饭" "造反"])
("zkfu" ["造福"])
("zkgk" ["糟糕"])
("zkho" ["灶火"])
("zkhs" ["枣红"])
("zkhu" ["罪魁祸首"])
("zkhw" ["造化" "皂化"])
("zkif" ["早晨"])
("zkig" ["造成"])
("zkij" ["早产"])
("zkip" ["早春"])
("zkir" ["造船"])
("zkji" ["早己"])
("zkjq" ["早就" "造就"])
("zkju" ["造句"])
("zkjw" ["造价"])
("zkjy" ["凿井"])
("zkks" ["凿孔"])
("zklc" ["糟了"])
("zkln" ["造林"])
("zklz" ["藻类"])
("zknm" ["早年"])
("zkpm" ["皂片"])
("zkpo" ["糟粕"])
("zkpp" ["阻抗匹配"])
("zkq'" "遭糟")
("zkqi" ["早期" "早起"])
("zkqq" ["早秋"])
("zkr'" "躁噪造皂灶燥唣")
("zkre" ["燥热"])
("zkri" ["早日"])
("zkta" ["糟蹋"])
("zkth" ["澡堂"])
("zktl" ["灶台"])
("zktm" ["造田"])
("zkub" ["遭受"])
("zkud" ["早霜"])
("zkug" ["噪声"])
("zkuh" ["早上"])
("zkuu" ["枣树" "早熟"])
("zkuy" ["早衰"])
("zkva" ["造渣"])
("zkvd" ["枣庄"])
("zkvi" ["造纸"])
("zkw'" "凿")
("zkwj" ["早晚"])
("zkwu" ["造物"])
("zkxi" ["皂洗"])
("zkxm" ["早先"])
("zkxy" ["造型" "造形"])
("zkyh" ["遭殃"])
("zkyi" ["早已" "造诣"])
("zkyj" ["凿岩"])
("zkyk" ["造谣"])
("zkyn" ["噪音"])
("zkyt" ["早曰"])
("zkyu" ["遭遇"])
("zkzi" ["造字"])
("zkzl" ["早在"])
("zkzo" ["造作"])
("zl'" ["资料"])
("zlan" ["在案"])
("zlba" ["再把" "坐立不安"])
("zlbh" ["在帮"])
("zlbj" ["再版"])
("zlbl" ["再拜"])
("zlbm" ["在编"])
("zlbo" ["载波"])
("zlbu" ["再不"])
("zlci" ["再次" "在此"])
("zld'" ["自留地"])
("zldu" ["再度"])
("zle'" "宰载仔崽")
("zlfg" ["载沣"])
("zlge" ["宰割"])
("zlgg" ["自流灌溉"])
("zlgo" ["再过"])
("zlgu" ["自力更生"])
("zlhd" ["灾荒"])
("zlhe" ["载荷"])
("zlhh" ["在行"])
("zlhl" ["灾害"])
("zlho" ["灾祸" "载货"])
("zlhu" ["在乎"])
("zlhv" ["再会"])
("zlhw" ["栽花"])
("zlih" ["在场"])
("zlik" ["在朝"])
("zlj'" ["自流井"])
("zljc" ["在教"])
("zljd" ["再将"])
("zlji" ["载记" "在即"])
("zljm" ["再见"])
("zljw" ["在家"])
("zljy" ["在京"])
("zlke" ["载客"])
("zll'" ["紫罗兰"])
("zlli" ["在理"])
("zlmn" ["灾民"])
("zlnj" ["灾难"])
("zlnz" ["在内"])
("zlpn" ["载频"])
("zlpz" ["栽培"])
("zlq'" "栽哉灾甾")
("zlqi" ["再起"])
("zlqu" ["灾区"])
("zlqy" ["灾情"])
("zlr'" "在再载")
("zlrf" ["载人" "再认"])
("zlru" ["再入"])
("zlsj" ["再三"])
("zlti" ["载体"])
("zltk" ["在逃"])
("zlu'" ["自来水" "总领事"])
("zlua" ["宰杀"])
("zluf" ["再审"])
("zlug" ["再生"])
("zlui" ["在世"])
("zluo" ["再说"])
("zluu" ["栽树"])
("zlve" ["再者" "在这"])
("zlvi" ["栽植" "在职"])
("zlvs" ["栽种" "载重"])
("zlwf" ["再问"])
("zlwh" ["在望"])
("zlwo" ["在握"])
("zlwv" ["杂乱无章"])
("zlwz" ["在位"])
("zlx'" ["总路线"])
("zlxd" ["宰相"])
("zlxm" ["再现" "在先"])
("zlxn" ["在心"])
("zlxp" ["再寻"])
("zlxw" ["在下"])
("zlya" ["在押"])
("zlyb" ["再由" "再有"])
("zlye" ["再也" "在野"])
("zlyg" ["再来一个"])
("zlyi" ["在意"])
("zlyp" ["载运"])
("zlyu" ["在于"])
("zlz'" ["载流子"])
("zlze" ["再则"])
("zlzi" ["崽子"])
("zlzk" ["再造"])
("zlzl" ["在在"])
("zlzo" ["在座"])
("zm'" ["怎么"])
("zmm'" ["做买卖"])
("zmq'" ["奏鸣曲"])
("zmuy" ["贼眉鼠眼"])
("zmv'" ["怎么着"])
("zmy'" ["怎么样"])
("znk'" ["子囊壳"])
("zoan" ["作案"])
("zobc" ["坐标" "座标"])
("zobj" ["作伴"])
("zobk" ["作保"])
("zobm" ["左边"])
("zocj" ["柞蚕"])
("zode" ["左的"])
("zodk" ["做到"])
("zodl" ["坐待"])
("zodm" ["座垫"])
("zodv" ["作对"])
("zody" ["坐定"])
("zoe'" "撮左佐")
("zoee" ["作恶"])
("zoer" ["昨儿" "左耳"])
("zofa" ["做法" "作法"])
("zofg" ["作风"])
("zofh" ["作坊"])
("zofj" ["做饭"])
("zofz" ["作废"])
("zogr" ["做官"])
("zogs" ["做工" "做功"])
("zogu" ["作古"])
("zogy" ["作怪"])
("zohk" ["做好"])
("zoig" ["做成" "作成"])
("zoiu" ["做出" "作出"])
("zojn" ["左近"])
("zojw" ["作家" "作价"])
("zoke" ["作客"])
("zolc" ["做了"])
("zole" ["作乐"])
("zolk" ["坐牢"])
("zolo" ["佐罗" "坐落" "座落"])
("zolr" ["作乱"])
("zomg" ["做梦"])
("zomm" ["左面"])
("zonj" ["作难"])
("zopl" ["左派"])
("zopn" ["作品"])
("zopz" ["作陪"])
("zoq'" "作嘬")
("zoqi" ["坐骑"])
("zoqu" ["作曲"])
("zoqy" ["左倾"])
("zor'" "凿柞做作坐座阼唑怍胙祚酢")
("zorf" ["做人"])
("zori" ["昨日"])
("zosi" ["柞丝"])
("zotj" ["座谈"])
("zotm" ["昨天"])
("zotu" ["作图"])
("zoub" ["左手"])
("zouh" ["坐上"])
("zoui" ["做诗" "做事" "坐视"])
("zove" ["作者" "坐着"])
("zovf" ["坐镇"])
("zovg" ["佐证" "作证"])
("zovj" ["作战"])
("zovp" ["作准"])
("zovr" ["左转"])
("zovu" ["做主" "作主"])
("zow'" "琢昨作笮")
("zowf" ["作文"])
("zowj" ["昨晚" "做完"])
("zowu" ["作物"])
("zowz" ["作为" "作伪" "坐位" "座位"])
("zoxw" ["坐下"])
("zoyb" ["左右"])
("zoye" ["昨夜" "作业"])
("zoyi" ["左移" "左翼"])
("zoys" ["作用"])
("zozl" ["坐在"])
("zozo" ["做作"])
("zpbz" ["尊卑"])
("zpcs" ["遵从"])
("zpe'" "撙")
("zpgv" ["尊贵"])
("zphw" ["遵化"])
("zpig" ["尊称"])
("zpis" ["尊崇"])
("zpjy" ["尊敬"])
("zpm'" ["纵剖面"])
("zpmy" ["遵命"])
("zpq'" "尊遵樽鳟")
("zpub" ["遵守"])
("zpui" ["尊师"])
("zpvh" ["尊长"])
("zpvk" ["遵照"])
("zpvs" ["尊重"])
("zpvy" ["宗派主义"])
("zpxp" ["遵循"])
("zpxy" ["遵行"])
("zpyi" ["遵义"])
("zpyj" ["尊严"])
("zqj'" ["作曲家"])
("zqqr" ["自欺欺人"])
("zqsl" ["增强塑料"])
("zr'" ["自然"])
("zrc'" ["自然村"])
("zre'" "纂缵")
("zrer" ["自然而然"])
("zrfp" ["自然法学派"])
("zrg'" ["责任感" "自然观"])
("zrgj" ["钻杆"])
("zrid" ["钻床"])
("zrj'" ["载热剂" "自然界"])
("zrji" ["钻机"])
("zrjj" ["自然经济"])
("zrjn" ["钻进"])
("zrjy" ["钻井"])
("zrk'" ["总人口"])
("zrkx" ["自然科学"])
("zrl'" ["自然力"])
("zrm'" ["自然美"])
("zrng" ["责任内阁"])
("zrq'" "钻躜")
("zrr'" ["赚" "钻" "攥" "自然人"])
("zrtb" ["钻头"])
("zrtf" ["自然通风"])
("zrtj" ["钻探"])
("zru'" ["自然数"])
("zrug" ["责任事故"])
("zrui" ["钻石"])
("zrv'" ["责任制"])
("zrvy" ["自然主义"])
("zrx'" ["责任心"])
("zrxq" ["纂修"])
("zrxz" ["自然选择"])
("zryj" ["钻研"])
("zryy" ["钻营"])
("zrzh" ["自然灾害"])
("zsbc" ["总表"])
("zsbi" ["总比"])
("zsbj" ["总办"])
("zsbm" ["总编"])
("zsbo" ["纵波"])
("zsbu" ["总部"])
("zsby" ["总兵"])
("zscj" ["总参"])
("zscl" ["总裁"])
("zsde" ["总得" "总的"])
("zsdp" ["总吨"])
("zsdu" ["总督"])
("zsdv" ["纵队"])
("zse'" "总偬")
("zsee" ["总额"])
("zsfa" ["宗法"])
("zsgr" ["综观" "总管" "纵观" "纵贯"])
("zsgs" ["总工" "总攻" "总共"])
("zsgv" ["总归"])
("zsh'" ["紫穗槐"])
("zshb" ["总后"])
("zshe" ["综合" "总和" "总合"])
("zshg" ["纵横"])
("zsho" ["纵火"])
("zshv" ["总汇"])
("zsig" ["总成"])
("zsih" ["总长"])
("zsj'" ["增塑剂"])
("zsjc" ["宗教"])
("zsji" ["踪迹" "总计"])
("zsjm" ["总监"])
("zsju" ["总局"])
("zsjx" ["总结"])
("zsko" ["总括"])
("zsl'" ["总司令"])
("zsld" ["总量"])
("zsli" ["总理"])
("zslj" ["总揽"])
("zslv" ["棕榈"])
("zsmc" ["宗庙"])
("zsmk" ["鬃毛"])
("zsmu" ["总目"])
("zsng" ["总能"])
("zspl" ["宗派"])
("zspu" ["总谱"])
("zsq'" "鬃棕踪宗综枞腙")
("zsqy" ["纵情"])
("zsr'" "纵粽")
("zsrh" ["棕壤"])
("zsrj" ["纵然"])
("zsrs" ["纵容"])
("zsse" ["棕色"])
("zssr" ["总算"])
("zsti" ["总体"])
("zsts" ["总统"])
("zstu" ["总图"])
("zsuf" ["纵身" "纵深"])
("zsuh" ["综上" "总商"])
("zsui" ["宗室" "总是" "纵使"])
("zsuu" ["综述" "总数"])
("zsvg" ["总政"])
("zsvh" ["总长" "总帐"])
("zsvi" ["宗旨" "总之" "总值"])
("zsvu" ["宗主"])
("zswu" ["总务"])
("zsxd" ["综向" "纵向"])
("zsxm" ["总线"])
("zsyk" ["总要"])
("zsyr" ["总院"])
("zsyy" ["踪影"])
("zsze" ["总则"])
("zszi" ["宗子" "粽子"])
("zszl" ["自私自利"])
("zszu" ["宗族"])
("zt'" ["昨天"])
("zth'" ["坐谈会" "座谈会"])
("ztv'" ["总统制"])
("ztwl" ["走投无路"])
("zu'" ["总是"])
("zuai" ["阻碍"])
("zuan" ["组胺"])
("zubz" ["祖辈"])
("zudh" ["阻挡"])
("zudm" ["租佃" "足点"])
("zue'" "祖诅阻组俎")
("zuee" ["足额"])
("zuex" ["自上而下"])
("zuff" ["祖坟"])
("zufu" ["祖父"])
("zugb" ["足够"])
("zuge" ["阻隔" "组歌" "组阁"])
("zugo" ["祖国"])
("zuhe" ["组合"])
("zuhw" ["组画"])
("zui'" ["再生产"])
("zuie" ["租车"])
("zuig" ["组成"])
("zuir" ["租船" "祖传"])
("zuj'" ["总书记"])
("zuji" ["足迹" "阻击"])
("zujm" ["足见" "组件"])
("zujn" ["租金"])
("zujx" ["租界" "租借"])
("zukh" ["阻抗"])
("zuli" ["阻力"])
("zulj" ["阻拦"])
("zuln" ["租赁"])
("zulz" ["族类"])
("zumi" ["租米"])
("zumu" ["祖母"])
("zuni" ["阻尼"])
("zunk" ["阻挠"])
("zuq'" "租菹")
("zuql" ["自食其力"])
("zuqq" ["足球"])
("zuqr" ["族权"])
("zuqu" ["组曲"])
("zurf" ["族人"])
("zuse" ["阻塞"])
("zusu" ["综上所述"])
("zusv" ["卒岁"])
("zuti" ["祖逖"])
("zuui" ["祖师"])
("zuuv" ["租税"])
("zuvb" ["诅咒"])
("zuvd" ["再生制动" "组装"])
("zuvh" ["组长"])
("zuvi" ["阻值" "阻止" "阻滞" "组织"])
("zuvv" ["自始至终"])
("zuw'" "足卒族镞")
("zux'" ["杂食性"])
("zuxm" ["祖先"])
("zuxw" ["足下"])
("zuy'" ["再生缘"])
("zuye" ["卒业"])
("zuyi" ["足以"])
("zuys" ["租用"])
("zuyt" ["租约"])
("zuzi" ["租子" "卒子"])
("zuzs" ["祖宗"])
("zuzu" ["足足"])
("zv'" ["总之"])
("zva'" ["组织胺"])
("zvb'" ["组织部"])
("zvba" ["嘴巴"])
("zvda" ["最大"])
("zvdi" ["最低"])
("zvdo" ["最多"])
("zve'" "咀嘴觜")
("zvee" ["罪恶"])
("zvfj" ["罪犯"])
("zvg'" ["宗主国"])
("zvgb" ["在职干部"])
("zvgk" ["最高"])
("zvgo" ["罪过"])
("zvgv" ["醉鬼"])
("zvh'" ["总指挥"])
("zvhb" ["最后"])
("zvhd" ["杂种后代"])
("zvhf" ["最恨"])
("zvhk" ["最好"])
("zvhy" ["最坏"])
("zvi'" ["造纸厂"])
("zvia" ["最差"])
("zvid" ["最终传动"])
("zvii" ["最迟"])
("zvip" ["嘴唇"])
("zviu" ["最初"])
("zvjc" ["嘴角"])
("zvjn" ["最近"])
("zvjq" ["最旧"])
("zvjw" ["最佳"])
("zvkv" ["罪魁"])
("zvky" ["最快"])
("zvl'" ["增长率"])
("zvld" ["组织领导"])
("zvlm" ["嘴脸"])
("zvlx" ["组织路线"])
("zvmj" ["最慢"])
("zvmy" ["罪名"])
("zvnj" ["最难"])
("zvp'" ["在制品"])
("zvq'" ["堆" "自治区"])
("zvqi" ["载重汽车"])
("zvr'" "最罪醉蕞")
("zvrf" ["罪人"])
("zvsd" ["增长速度"])
("zvu'" ["组织上"])
("zvuh" ["组织生活"])
("zvuk" ["最少"])
("zvv'" ["自治州"])
("zvvb" ["总政治部"])
("zvvd" ["罪状"])
("zvvg" ["罪证"])
("zvvs" ["最终"])
("zvwj" ["最晚"])
("zvwz" ["最为"])
("zvx'" ["自治县" "组织性" "组织学"])
("zvxc" ["最小"])
("zvxm" ["最先"])
("zvxn" ["醉心" "最新"])
("zvxu" ["组织形式"])
("zvxy" ["罪行"])
("zvy'" ["资政院" "组织液"])
("zvyb" ["最优" "最有"])
("zvyr" ["最远"])
("zvyu" ["杂种优势"])
("zvze" ["罪责"])
("zvzk" ["最早"])
("zvzv" ["最最"])
("zw'" ["作为"])
("zwpd" ["责无旁贷"])
("zwpp" ["自我批评"])
("zwv'" ["造物主" "做文章"])
("zwx'" ["紫外线" "子午线"])
("zwxu" ["自我牺牲"])
("zwy'" ["灶王爷"])
("zx'" ["自行"])
("zxbb" ["最新版本"])
("zxeu" ["自下而上"])
("zxi'" ["自行车" "钻心虫"])
("zxj'" ["造型机"])
("zxmd" ["自相矛盾"])
("zxqu" ["自行其是"])
("zxx'" ["自信心" "总星系"])
("zxyu" ["造型艺术"])
("zy'" ["作用"])
("zybh" ["再也不会"])
("zyd'" ["自由锻" "租庸调"])
("zydz" ["自由电子"])
("zyhy" ["遵义会议"])
("zyj'" ["凿岩机" "增氧机" "增音机" "自由基" "谘议局"])
("zyjv" ["自由竞争"])
("zyl'" ["作用力"])
("zylt" ["自由落体"])
("zym'" ["自由面" "自由民" "座右铭"])
("zymy" ["再也没有"])
("zys'" ["总预算"])
("zytc" ["自由体操"])
("zyu'" ["左右手"])
("zyui" ["自由市场"])
("zyvy" ["自由主义"])
("zywg" ["自由王国"])
("zyxv" ["自由心证"])
("zyy'" ["紫云英" "自由泳"])
("zyzh" ["自由组合"])
("zyzy" ["自言自语"])
("zyzz" ["自由自在"])
("zzb'" ["纵坐标"])
("zzbb" ["祖祖辈辈"])
("zzir" ["贼船"])
("zzld" ["贼亮"])
("zzp'" ["走资派"])
("zzw'" "贼")
("zzx'" ["自尊心"])
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:

;;; ZIRANMA.el ends here
