;;; ARRAY30.tit  -*- lexical-binding:t -*-
;; Quail package `chinese-array30
;;   Generated by the command `titdic-convert'
;;	Original TIT dictionary file: ARRAY30.tit

;; # -*- coding: cn-big5 -*-
;; ##############################################################
;; # 行列３０鍵輸入法, CXTERM 專用輸入法資料表格.
;; # 給 CXTERM 使用前, 請您先用 tit2cit 將此檔轉換成 .cit 格式。
;; # .cit version 2
;; ##############################################################
;; ENCODE: BIG5
;; AUTOSELECT:    NO
;; PROMPT: 中文【行列３０】\040
;; #
;; COMMENT Copyright (c) 1997 by  William Yeh <is80001@cis.nctu.edu.tw>
;; COMMENT
;; COMMENT Permission to copy and distribute both modified and unmodified
;; COMMENT versions is granted without royalty provided this notice is preserved.
;; COMMENT
;; COMMENT Constructed by William Yeh (葉秉哲  is80001@cis.nctu.edu.tw)
;; COMMENT Finished on Mar 12, 1994.
;; COMMENT
;; COMMENT In Taipei (ETen) Big5 coding (e.g., used with taipei15, taipei20)
;; COMMENT 這個檔案也包括【行列３０】的特殊符號輸入。
;; COMMENT 暫不提供「容錯副檔」功能, 如果您需要的話, 請自行添加在本檔後面。
;; COMMENT
;; COMMENT                        行列３０鍵位排列圖
;; COMMENT
;; COMMENT          行1   行2   行3   行4   行5   行6   行7   行8   行9   行0
;; COMMENT           ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓
;; COMMENT         ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
;; COMMENT 選字鍵→│１││２││３││４││５││６││７││８││９││０│
;; COMMENT         └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
;; COMMENT     0    ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
;; COMMENT  列 1 2→│Ｑ││Ｗ││Ｅ││Ｒ││Ｔ││Ｙ││Ｕ││Ｉ││Ｏ││Ｐ│
;; COMMENT     3 4  └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
;; COMMENT           ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
;; COMMENT    列 - →│Ａ││Ｓ││Ｄ││Ｆ││Ｇ││Ｈ││Ｊ││Ｋ││Ｌ││；│
;; COMMENT       5   └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
;; COMMENT            ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
;; COMMENT    列 6 7→│Ｚ││Ｘ││Ｃ││Ｖ││Ｂ││Ｎ││Ｍ││，││．││／│
;; COMMENT       8 9  └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
;; COMMENT                       ┌───────────────────┐
;; COMMENT      組字鍵 →        │                Space Bar             │
;; COMMENT                       └───────────────────┘
;; COMMENT
;; # define keys
;; VALIDINPUTKEY:  \040./;,1234567890abcdefghijklmnopqrstuvwxyz
;; SELECTKEY:      1
;; SELECTKEY:      2
;; SELECTKEY:      3
;; SELECTKEY:      4
;; SELECTKEY:      5
;; SELECTKEY:      6
;; SELECTKEY:      7
;; SELECTKEY:      8
;; SELECTKEY:      9
;; SELECTKEY:      0
;; BACKSPACE:      \010\177
;; DELETEALL:      \015\025
;; MOVERIGHT:      >
;; MOVELEFT:       <
;; REPEATKEY:      \020\022
;; # KEYPROMPT(\040): 　
;; KEYPROMPT(.): 9v
;; KEYPROMPT(/): 0v
;; KEYPROMPT(;): 0-
;; KEYPROMPT(,): 8v
;; KEYPROMPT(a): 1-
;; KEYPROMPT(b): 5v
;; KEYPROMPT(c): 3v
;; KEYPROMPT(d): 3-
;; KEYPROMPT(e): 3^
;; KEYPROMPT(f): 4-
;; KEYPROMPT(g): 5-
;; KEYPROMPT(h): 6-
;; KEYPROMPT(i): 8^
;; KEYPROMPT(j): 7-
;; KEYPROMPT(k): 8-
;; KEYPROMPT(l): 9-
;; KEYPROMPT(m): 7v
;; KEYPROMPT(n): 6v
;; KEYPROMPT(o): 9^
;; KEYPROMPT(p): 0^
;; KEYPROMPT(q): 1^
;; KEYPROMPT(r): 4^
;; KEYPROMPT(s): 2-
;; KEYPROMPT(t): 5^
;; KEYPROMPT(u): 7^
;; KEYPROMPT(v): 4v
;; KEYPROMPT(w): 2^
;; KEYPROMPT(x): 2v
;; KEYPROMPT(y): 6^
;; KEYPROMPT(z): 1v
;; #
;; # the following line must not be removed
;; BEGINDICTIONARY

;;; End of the header of original TIT dictionary.

;;; Code:

(require 'quail)

(quail-define-package "chinese-array30" "Chinese-BIG5" "３０"
 '(   (122 . "1v")
   (121 . "6^")
   (120 . "2v")
   (119 . "2^")
   (118 . "4v")
   (117 . "7^")
   (116 . "5^")
   (115 . "2-")
   (114 . "4^")
   (113 . "1^")
   (112 . "0^")
   (111 . "9^")
   (110 . "6v")
   (109 . "7v")
   (108 . "9-")
   (107 . "8-")
   (106 . "7-")
   (105 . "8^")
   (104 . "6-")
   (103 . "5-")
   (102 . "4-")
   (101 . "3^")
   (100 . "3-")
   (99 . "3v")
   (98 . "5v")
   (97 . "1-")
   (44 . "8v")
   (59 . "0-")
   (47 . "0v")
   (46 . "9v")
)"中文【行列３０】

 Copyright (c) 1997 by  William Yeh <is80001@cis.nctu.edu.tw>

 Permission to copy and distribute both modified and unmodified
 versions is granted without royalty provided this notice is preserved.

 Constructed by William Yeh (葉秉哲  is80001@cis.nctu.edu.tw)
 Finished on Mar 12, 1994.

 In Taipei (ETen) Big5 coding (e.g., used with taipei15, taipei20)
 這個檔案也包括【行列３０】的特殊符號輸入。
 暫不提供「容錯副檔」功能, 如果您需要的話, 請自行添加在本檔後面。

                        行列３０鍵位排列圖

          行1   行2   行3   行4   行5   行6   行7   行8   行9   行0
           ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓    ↓
         ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
 選字鍵→│１││２││３││４││５││６││７││８││９││０│
         └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
     0    ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
  列 1 2→│Ｑ││Ｗ││Ｅ││Ｒ││Ｔ││Ｙ││Ｕ││Ｉ││Ｏ││Ｐ│
     3 4  └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
           ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
    列 - →│Ａ││Ｓ││Ｄ││Ｆ││Ｇ││Ｈ││Ｊ││Ｋ││Ｌ││；│
       5   └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
            ┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐┌─┐
    列 6 7→│Ｚ││Ｘ││Ｃ││Ｖ││Ｂ││Ｎ││Ｍ││，││．││／│
       8 9  └─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘└─┘
                       ┌───────────────────┐
      組字鍵 →        │                Space Bar             │
                       └───────────────────┘

"
 '(("\C-?" . quail-delete-last-char)
   
   (">" . quail-next-translation)
   ("<" . quail-prev-translation))
 nil nil nil nil)

(quail-define-rules
("w1" "，、。．‧；：？！︰…‥﹐﹑﹒·﹔﹕﹖﹗｜–︱—︳╴︴﹏")
("w2" "（）︵︶︶｝︷︸〔〕︹︺【】︻︼《》︽︾〈〉︿﹀「」﹁﹂『』﹃﹄﹙﹚﹛﹜﹝﹞‘’“”〝〞‵′")
("w3" "＃＆＊※§〃○●△▲◎☆★◇◆□■▽▼㊣℅¯￣＿ˍ﹉﹊﹍﹎﹋﹌﹟﹠﹡")
("w4" "＋－×÷±√＜＞＝≦≧≠∞≒≡﹢﹣﹤﹥﹦～∩∪⊥∠∟⊿㏒㏑∫∮∵∴")
("w5" "♀♂⊕⊙↑↓←→↖↗↙↘∥∣／＼∕﹨")
("w6" "＄￥〒￠￡％＠℃℉﹩﹪﹫㏕㎜㎝㎞㏎㎡㎎㎏㏄°兙兛兞兝兡兣嗧瓩糎")
("w7" "▁▂▃▄▅▆▇█▏▎▍▌▋▊▉┼┴┬┤├▔─│▕┌┐└┘╭╮╰╯═╞╪╡◢◣◥◤╱╲╳╔╦╗╠╬╣╚╩╝╒╤╕╘╧╛╓╥╖╟╫╢╙╨╜║▓")
("w8" "ⅠⅡⅢⅣⅤⅥⅦⅧⅨⅩ〡〢〣〤〥〦〧〨〩卄")
("w9" "ΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩαβγδεζηθικλμνξοπρστυφχψω")
("w0" "ㄅㄆㄇㄈㄉㄊㄋㄌㄍㄎㄏㄐㄑㄒㄓㄔㄕㄖㄗㄘㄙㄧㄨㄩㄚㄛㄜㄝㄞㄟㄠㄡㄢㄣㄤㄥㄦ˙　ˊˇˋ")
(".1" "。")
(",1" "，")
(";2" "：")
(";3" "；")
("/3" "？")
("/4" "『")
("/5" "』")
("/6" "．")
("/7" "–")
("/8" "＊")
("/9" "／")
("/0" "…")
("d3" "！")
("d4" "「")
("d5" "」")
("d6" "、")
("d7" "“")
("d8" "”")
("d9" "（")
("d0" "）")
("t " "的")
("a " "一")
("s " "乙")
("ad " "丁")
("q " "七")
("lg " "乃")
("ls " "九")
("gd " "了")
("aa " "二")
("k " "人")
("ssss" "儿")
("k " "入八")
("ssss" "几")
("j " "刀")
("ga " "刁")
("b " "力")
("ls " "匕")
("f " "十")
("c " "卜")
("b " "又")
("aaa " "三")
("ac " "下")
("zk " "丈")
("ea " "上")
("kd " "丫")
("lsh " "丸")
("sh " "凡")
("jk " "久")
("lx " "么")
("gds " "也")
("os " "乞")
("af " "于")
("ys " "亡")
("as " "兀")
("jh " "刃")
("lh " "勺")
("lf " "千")
("bh " "叉")
("; " "口")
("r " "土士")
("m " "夕")
("z " "大")
("w " "女")
("gf " "子孑")
("gdk " "孓")
("fh " "寸")
("c " "小")
("zs " "尢")
("bbbb" "尸")
("d " "山")
("ed " "川")
("q " "工")
("ts " "己已巳")
("jd " "巾")
("af " "干")
("ffff" "廾")
("ax " "弋")
("tg " "弓")
("fl " "才")
("gr " "丑")
("aeg " "丐")
("z " "不")
(";d " "中")
("ffff" "丰")
("jy " "丹")
("n " "之")
("tl " "尹")
("bgd " "予")
("aax " "云")
("fd " "井")
("aw " "互")
("at " "五")
("ys " "亢")
("kaa " "仁")
("kf " "什")
("kad " "仃")
("kc " "仆")
("kls " "仇")
("klg " "仍")
("ig " "今")
("ke " "介")
("zk " "仄")
("aas " "元")
("xs " "允")
("jk " "內")
("yk " "六")
("ig " "兮")
("kx " "公")
("js " "冗")
(".d " "凶")
("kj " "分")
("qj " "切")
(".e " "刈")
("laa " "勻")
("lx " "勾")
("l. " "勿")
("kq " "化")
("qk " "匹")
("of " "午")
("lf " "升")
("fd " "卅")
("yc " "卞")
("zgs " "厄")
("zb " "友")
("lb " "及")
("zb " "反")
("ar " "壬")
("az " "天")
("z " "夫")
("zh " "太")
("lz " "夭")
("gfs " "孔")
("cl " "少")
("zsh " "尤")
("bk " "尺")
("ads " "屯")
("tds " "巴")
("xg " "幻")
("r " "廿")
("tgd " "弔引")
("n " "心")
("ax " "戈")
("g " "戶")
("o " "手")
("os " "扎")
("fb " "支")
("y. " "文")
("hf " "斗")
("o " "斤")
("h " "方")
("p " "日曰")
("u " "月")
("v " "木")
("jk " "欠")
("e " "止")
("am " "歹")
("sf " "毋")
("qq " "比")
("lq " "毛")
("oas " "氏")
("c " "水")
(", " "火")
(".dk " "爪")
("k. " "父")
(".. " "爻")
("d " "片")
("qdl " "牙")
("of " "牛")
("zh " "犬")
("ar " "王")
("ajk " "丙")
("rs " "世")
("za " "丕")
("ua " "且")
("oa " "丘")
("yr " "主")
("oe " "乍")
("ln " "乏")
("li " "乎")
("xk " "以")
("kfh " "付")
("kgf " "仔")
("kr " "仕")
("kgds" "他")
("kzk " "仗")
("kax " "代")
("ib " "令")
("kd " "仙")
("kjh " "仞")
("zs " "充")
(";s " "兄")
("jr " "冉")
("jf " "冊")
(".h " "冬")
("da " "凹")
("dd " "出")
("da " "凸")
("afe " "刊")
("b; " "加")
("qb " "功")
("lts " "包")
("l.h " "匆")
("eq " "北")
("qjd " "匝")
("klf " "仟")
("i " "半")
("ff " "卉")
("eac " "卡")
("e; " "占")
("odj " "卯")
(".ags" "卮")
("rx " "去")
("qd " "可")
("f; " "古")
("z; " "右")
("j; " "召")
(";ad " "叮")
(";j " "叩叨")
(";ga " "叼")
("gq " "司")
("q; " "叵")
(";sd " "叫")
(";b " "另")
(";k " "只")
(";. " "史")
(";q " "叱")
("x; " "台")
("l; " "句")
(";k " "叭")
(";b " "叻")
("/ " "四")
("pk " "囚")
("mc " "外")
("jz " "央")
("oz " "失")
("wb " "奴")
("wlg " "奶")
("lggf" "孕")
("nq " "它")
("bq " "尼")
("qt " "巨")
("qag " "巧")
("zq " "左")
("yjd " "市")
("zjd " "布")
("ai " "平")
("xb " "幼")
("xf " "弁")
("tgx " "弘")
("tge " "弗")
("nl " "必")
("zx " "戊")
("oad " "打")
("olg " "扔")
("ok " "扒")
("oc " "扑")
("oh " "斥")
("pa " "旦")
("vh " "朮")
("va " "本")
("av " "未")
("va " "末")
("vs " "札")
("ae " "正")
("sz " "母")
("tsas" "民")
("oasa" "氐")
("hb " "永")
("cf " "汁")
("cad " "汀")
("cgs " "氾")
(".gs " "犯")
("yx " "玄")
("arh " "玉")
(".xk " "瓜")
("qh " "瓦")
("ra " "甘")
("or " "生")
("jf " "用")
("jq " "甩")
("p " "田")
("pf " "由")
("pd " "甲申")
("gc " "疋")
("lp " "白")
("tb " "皮")
("u " "皿")
("j " "目")
("bgdl" "矛")
("oz " "矢")
("g " "石")
("aac " "示")
("lv " "禾")
("nk " "穴")
("y " "立")
("gca " "丞")
("arx " "丟")
("oal " "乒")
("oah " "乓")
("e;s " "乩")
("ama " "亙")
("yk. " "交")
("yc " "亦")
("yxk " "亥")
("kh " "仿")
("kys " "伉")
("k, " "伙")
("ktl " "伊")
("kz " "伕")
("kat " "伍")
("kax " "伐")
("kv " "休")
("kzh " "伏")
("k;d " "仲")
("kof " "件")
("kar " "任")
("koj " "仰")
("kqq " "仳")
("kkj " "份")
("ke " "企")
("klb " "伋")
("cas " "光")
(".ds " "兇")
("s, " "兆")
("os " "先")
("ir " "全")
("rk " "共")
("ajr " "再")
("kc " "冰")
("ame " "列")
("afe " "刑")
("axe " "划")
("l.e " "刎")
("ue " "刖")
("clb " "劣")
("l.d " "匈")
("qar " "匡")
("qo " "匠")
("oj " "印")
("jzgs" "危")
("r; " "吉")
("q. " "吏")
("jq " "同")
(";jd " "吊")
(";r " "吐")
(";af " "吁")
(";fh " "吋")
(".; " "各")
("lj; " "向")
("m; " "名")
("i; " "合")
(";os " "吃")
(".q " "后")
(";x " "吆")
(";lq " "吒")
("pz " "因")
("p; " "回")
("pgf " "囝")
("red " "圳")
("rgds" "地")
("zdr " "在")
("rr " "圭")
("raag" "圬")
("rts " "圯")
("raf " "圩")
("sam " "夙")
("mm " "多")
("ztg " "夷")
("zaag" "夸")
("ysw " "妄")
("waf " "奸")
("wts " "妃")
("wgf " "好")
("wgds" "她")
("w; " "如")
("wlh " "妁")
("ngf " "字")
("zdgf" "存")
("naf " "宇")
("nfh " "守")
("nlq " "宅")
("nw " "安")
("rfh " "寺")
("cz " "尖")
("dos " "屹")
("adad" "州")
("jdsh" "帆")
("if " "并")
("oq " "年")
("aqx " "式")
("tggs" "弛")
("nys " "忙")
("nfh " "忖")
("afx " "戎")
("zax " "戌")
("zhx " "戍")
("zgx " "成")
("o; " "扣")
("oq " "扛")
("olq " "托")
("sd. " "收")
("pf " "早")
("qp " "旨")
("lp " "旬")
("lsp " "旭")
("pf " "曲")
("px " "曳")
("zu " "有")
("vag " "朽")
("vc " "朴")
("ov " "朱")
("sv " "朵")
("aajk" "次")
("eq " "此")
("amq " "死")
("olg " "氖")
("cw " "汝")
("caf " "汗汙")
("cq " "江")
("cgds" "池")
("cm " "汐")
("cd " "汕")
("caag" "污")
("csf " "汛")
("clsh" "汍")
("csh " "汎")
("z, " "灰")
("xof " "牟")
("ofq " "牝")
("alp " "百")
("l " "竹")
(", " "米")
("xxxx" "糸")
("ofd " "缶")
("if " "羊")
("bb " "羽")
("rlq " "老")
("rlag" "考")
("alje" "而")
("fk " "耒")
("ae " "耳")
("tf " "聿")
("jkk " "肉")
("ub " "肋")
("us " "肌")
("qdtd" "臣")
("lj " "自")
("axr " "至")
("o " "臼")
("af; " "舌")
("mq " "舛")
("lm " "舟")
("tx " "艮")
("jtds" "色")
("f. " "艾")
("/ " "虫")
("lu " "血")
(".aad" "行")
("ylx " "衣")
("a/ " "西")
("tlf " "阡")
(";;d " "串")
("y;gd" "亨")
("ky " "位")
("kyr " "住")
("knad" "佇")
("knq " "佗")
("kaaw" "佞")
("ki " "伴")
("ktge" "佛")
("kqd " "何")
("kf; " "估")
("kzq " "佐")
("kz; " "佑")
("kb; " "伽")
("kgq " "伺")
("kpd " "伸")
("kp " "佃")
("ke; " "佔")
("kxk " "似")
("kpa " "但")
("kjf " "佣")
("koe " "作")
("kjc " "你")
("klp " "伯")
("koaa" "低")
("kib " "伶")
("iv " "余")
("kl; " "佝")
("kzjd" "佈")
("koz " "佚")
("k;s " "兌")
("f;s " "克")
("j;s " "免")
("oak " "兵")
("kx; " "冶")
("kib " "冷")
(";le " "別")
("ie " "判")
("lve " "利")
("jfe " "刪")
("ltse" "刨")
("rxb " "劫")
("uab " "助")
("wbb " "努")
("l;b " "劬")
("qpd " "匣")
("bj " "即")
("ohdh" "卵")
("y.; " "吝")
(";ys " "吭")
("az; " "吞")
("at; " "吾")
("z; " "否")
(";bk " "呎")
(";tds" "吧")
(";v " "呆")
(";zgs" "呃")
(";gz " "吳")
(";lr " "呈")
(";l; " "呂")
("tl; " "君")
(";kj " "吩")
("o; " "告")
(";jk " "吹")
(";l. " "吻")
(";lb " "吸")
(";xs " "吮")
(";cl " "吵")
(";jk " "吶")
(";zh " "吠")
(";gfs" "吼")
(";qdl" "呀")
(";fb " "吱")
("ig; " "含")
(";ig " "吟")
(";o " "听")
("lp.h" "囪")
("pv " "困")
("pads" "囤")
("pl. " "囫")
("rh " "坊")
("rys " "坑")
("re " "址")
("rjy " "坍")
("rlaa" "均")
("rjk " "坎")
("rlb " "圾")
("kkr " "坐")
("rz " "坏")
("ro " "圻")
("xr " "壯")
("zkk " "夾")
("xw " "妝")
("wg " "妒")
("wh " "妨")
("wgr " "妞")
("wqq " "妣")
("wcl " "妙")
("wlz " "妖")
("waf " "妍")
("wbgd" "妤")
("wfb " "妓")
("war " "妊")
(".w " "妥")
("rlgf" "孝")
("gf. " "孜")
(".gf " "孚")
("fjgf" "孛")
("naas" "完")
("nv " "宋")
("nzx " "宏")
("zske" "尬")
("bg; " "局")
("bqq " "屁")
("bc " "尿")
("blq " "尾")
("dfb " "岐")
("dig " "岑")
("kjd " "岔")
("dlb " "岌")
("qkk " "巫")
(".zjd" "希")
("nbgd" "序")
("nqq " "庇")
("nv " "床")
("lrb " "廷")
("arf " "弄")
("ktgl" "弟")
("jy. " "彤")
("af. " "形")
(".h " "彷")
(".sb " "役")
("ysn " "忘")
("tsn " "忌")
("rn " "志")
("jhn " "忍")
("njs " "忱")
("ntk " "快")
("ngr " "忸")
("nkx " "忪")
("afx " "戒")
("lox " "我")
("ocl " "抄")
("oys " "抗")
("ohf " "抖")
("ofb " "技")
("oz " "扶")
("otk " "抉")
("ogr " "扭")
("otds" "把")
("ozgs" "扼")
("oax " "找")
("oqq " "批")
("ozb " "扳")
("obgd" "抒")
("oe " "扯")
("oo " "折")
("okj " "扮")
("osb " "投")
("o.dk" "抓")
("ooj " "抑")
("oy. " "抆")
("ts. " "改")
("q. " "攻")
("kd. " "攸")
("paf " "旱")
("ap. " "更")
("v; " "束")
("vgf " "李")
("v; " "杏")
("vfl " "材")
("vfh " "村")
("vr " "杜")
("vzk " "杖")
("vts " "杞")
("v. " "杉")
("vaf " "杆")
("vq " "杠")
("vlh " "杓")
("ysv " "杗")
("ec " "步")
("osz " "每")
("f,h " "求")
("qc " "汞")
("ccl " "沙")
("cn " "沁")
("cjs " "沈沉")
("caas" "沅")
("cajd" "沛")
("car " "汪")
("ctk " "決")
("cv " "沐")
("czh " "汰")
("cads" "沌")
("cp " "汨")
("c;d " "沖")
("clb " "沒")
("co " "汽")
("clz " "沃")
("clb " "汲")
("ckj " "汾")
("cyc " "汴")
("cys " "沆")
("cy. " "汶")
("caw " "沍")
("cadg" "沔")
("cqq " "沘")
("co " "沂")
(",r " "灶")
(",lh " "灼")
("w, " "災")
("jk, " "灸")
("nof " "牢")
("ofr " "牡")
("ofgs" "牠")
("., " "狄")
(".ar " "狂")
("arjk" "玖")
("bjf " "甬")
("qh " "甫")
("pb " "男")
("lp " "甸")
("lpq " "皂")
("jad " "盯")
("xoz " "矣")
("lvx " "私")
("lvlg" "秀")
("lvs " "禿")
("nkls" "究")
("lx " "系")
("jkaf" "罕")
("cu " "肖")
("ysu " "肓")
("uaf " "肝")
("ufh " "肘")
("uq " "肛")
("ur " "肚")
("zu " "育")
("htx " "良")
("fys " "芒")
("faf " "芋")
("flh " "芍")
("js " "見")
("j " "角")
("y " "言")
("kk; " "谷")
("qi " "豆")
("a. " "豕")
("m " "貝")
("rc " "赤走")
(";c " "足")
(". " "身")
("q " "車")
("yf " "辛")
("zaax" "辰")
("afn " "迂")
("gdsn" "迆")
("sfn " "迅")
("osn " "迄")
("wn " "巡")
(";tds" "邑")
("aft " "邢")
("qdlt" "邪")
("ft " "邦")
("gft " "那")
("ap " "酉")
("l, " "釆")
("pr " "里")
("th " "防")
("taas" "阮")
("tfd " "阱")
("tzb " "阪")
("tys " "阬")
("ica " "並")
("lfeq" "乖")
(".gfs" "乳")
("qtd " "事")
("eqaa" "些")
("aea " "亞")
("y;gf" "享")
("y;c " "京")
("kif " "佯")
("kylx" "依")
("krfh" "侍")
("krr " "佳")
("kq. " "使")
("krlq" "佬")
("krk " "供")
("kame" "例")
("vkk " "來")
("k;o " "侃")
("kalp" "佰")
("kif " "併")
("kmm " "侈")
("ksad" "佩")
("ks, " "佻")
("ijf " "侖")
("kku " "佾")
("kov " "侏")
("kzu " "侑")
("kir " "佺")
("j;sh" "兔")
("os " "兒")
("das " "兕")
("ajdk" "兩")
("uak " "具")
("rak " "其")
("jrk " "典")
("kame" "冽")
("gcd " "函")
("yxke" "刻")
("izj " "券")
("bjde" "刷")
("vje " "刺")
("axre" "到")
("lf;e" "刮")
("oaje" "制")
("sve " "剁")
("yxkb" "劾")
("qarb" "劻")
("ykkf" "卒")
("fbbb" "協")
("epf " "卓")
("lplf" "卑")
("rrc " "卦")
("izgs" "卷")
("oaej" "卸")
("luj " "卹")
("aeb " "取")
("eacb" "叔")
(".jb " "受")
(";av " "味")
(";qd " "呵")
(";b; " "咖")
(";za " "呸")
(";f; " "咕")
(";ua " "咀")
(";pd " "呻呷")
(";dd " "咄")
(";;s " "咒")
(";lts" "咆")
(";li " "呼")
(";kfh" "咐")
(";.xk" "呱")
(";wb " "呶")
("lv; " "和")
(";.h " "咚")
(";bq " "呢")
("jr; " "周")
(";oe " "咋")
("i;j " "命")
(".k; " "咎")
("pf; " "固")
("ry " "垃")
("rqd " "坷")
("rai " "坪")
("rra " "坩")
("rtb " "坡")
("rpa " "坦")
("rpd " "坤")
("roh " "坼")
("ykmk" "夜")
("zf " "奉")
("zqd " "奇")
("zaac" "奈")
("zps " "奄")
("zff " "奔")
("yw " "妾")
("atdw" "妻")
("lvw " "委")
("wav " "妹")
("wbq " "妮")
("wf; " "姑")
("wsz " "姆")
("wua " "姐")
("wjf " "姍")
("wx; " "始")
("wor " "姓")
("wlgl" "姊")
("wpf " "妯")
("wjc " "妳")
("wxk " "姒")
("wi " "姅")
("gfu " "孟")
("gf.k" "孤")
("lvgf" "季")
("naac" "宗")
("nac " "定")
("ne " "官")
("nua " "宜")
("npf " "宙")
("nmgs" "宛")
("cj; " "尚")
("bdd " "屈")
("bf; " "居")
("brd " "屆")
("dtss" "岷")
("jid " "岡")
("dzaf" "岸")
("dg " "岩")
("dpf " "岫")
("kaxd" "岱")
("oad " "岳")
("nkjd" "帘")
("tjjd" "帚")
("jde;" "帖")
("jdlp" "帕")
("lpjd" "帛")
("wbjd" "帑")
("rif " "幸")
("ntk " "庚")
("ne; " "店")
("nkfh" "府")
("noaa" "底")
("nlts" "庖")
("leb " "延")
("tgyx" "弦")
("tg.k" "弧")
("wbtg" "弩")
(".yr " "往")
(".ae " "征")
(".tge" "彿")
(".tb " "彼")
("azc " "忝")
(";dn " "忠")
("l.n " "忽")
("ign " "念")
("kjn " "忿")
("njz " "怏")
("nae " "怔")
("nrx " "怯")
("nvh " "怵")
("nzjd" "怖")
("nbr " "怪")
("nlp " "怕")
("nx; " "怡")
("nor " "性")
("nbq " "怩")
("ntge" "怫")
("npa " "怛")
("qax " "或")
("xax " "戕")
("gh " "房")
("gzh " "戾")
("go " "所")
("gfgk" "承")
("oy " "拉")
("oi " "拌")
("oyr " "拄")
("otss" "抿")
("otge" "拂")
("ova " "抹")
("oqt " "拒")
("oj; " "招")
("otb " "披")
("og " "拓")
("oz.h" "拔")
("ozsb" "拋")
("oe; " "拈")
("oai " "抨")
("opf " "抽")
("opd " "押")
("o;j " "拐")
("odd " "拙")
("osz " "拇")
("olp " "拍")
("ooaa" "抵")
("oxf " "拚")
("olts" "抱")
("ol; " "拘")
("oogs" "拖")
("oxb " "拗")
("ooh " "拆")
("ox; " "抬")
("oib " "拎")
("h. " "放")
("k.o " "斧")
("hkh " "於")
("par " "旺")
("rp " "昔")
("pl. " "易")
("pp " "昌")
("pqq " "昆")
("poj " "昂")
("pu " "明")
("plaa" "昀")
("oasp" "昏")
("po " "昕")
("paz " "昊")
("plf " "昇")
("ujb " "服")
("uu " "朋")
("vys " "杭")
("vh " "枋")
("vjs " "枕")
("vp " "東")
("pv " "果")
("vp " "杳")
("vtds" "杷")
("vqq " "枇")
("vfb " "枝")
("vv " "林")
("vz " "杯")
("v, " "杰")
("vzb " "板")
("var " "枉")
("vkx " "松")
("vo " "析")
("vof " "杵")
("v. " "枚")
("vhf " "枓")
("vbgd" "杼")
("vcl " "杪")
("pv " "杲")
("ojk " "欣")
("aaex" "武")
("efb " "歧")
("amlb" "歿")
("ysts" "氓")
("okj " "氛")
("cy " "泣")
("cyr " "注")
("chb " "泳")
("cnq " "沱")
("cnl " "泌")
("cbq " "泥")
("cqd " "河")
("cf; " "沽")
("ce; " "沾")
("cj; " "沼")
("ctb " "波")
("cva " "沫")
("crx " "法")
("ctgx" "泓")
("ctge" "沸")
("crs " "泄")
("cpf " "油")
("c;s " "況")
("cua " "沮")
("c/ " "泗")
("cpk " "泅")
("cjz " "泱")
("ck; " "沿")
("cx; " "治")
("clts" "泡")
("cln " "泛")
("clp " "泊")
("cav " "沬")
("ctss" "泯")
("coaa" "泜")
("codj" "泖")
("cib " "泠")
(",ys " "炕")
(",, " "炎")
(",cl " "炒")
(",jk " "炊")
("m, " "炙")
(".dks" "爬")
(".td " "爭")
("k.ts" "爸")
("dzb " "版")
("of. " "牧")
("ofl." "物")
("xzh " "狀")
(".pd " "狎")
(".ua " "狙")
(".l; " "狗")
("..xk" "狐")
("aras" "玩")
("arar" "玨")
("ary." "玟")
("ar. " "玫")
("aru " "玥")
("ped " "甽")
("hd " "疝")
("hos " "疙")
("hjk " "疚")
("lplh" "的")
("afu " "盂")
("ysj " "盲")
("fua " "直")
("oz; " "知")
("gm " "矽")
("yhr " "社")
("yhts" "祀")
("yht " "祁")
("lvt " "秉")
("lvd " "秈")
("nkq " "空")
("nktg" "穹")
("laa " "竺")
("xsd " "糾")
("jiys" "罔")
("irs " "羌")
("dfaf" "羋")
("rlp " "者")
("uajd" "肺")
("utds" "肥")
("ufb " "肢")
("uzx " "肱")
("usb " "股")
("uads" "肫")
("gu " "肩")
(".zu " "肴")
("uh " "肪")
("eu " "肯")
("qdtk" "臥")
("ok " "臾")
("if; " "舍")
("fh " "芳")
("fn " "芝")
("fz " "芙")
("ftds" "芭")
("fqdl" "芽")
("fsb " "芟")
("fo " "芹")
("fkq " "花")
("fkj " "芬")
("fke " "芥")
("fn " "芯")
("faax" "芸")
("fz " "芣")
("ffb " "芰")
("fajd" "芾")
("fe " "芷")
("es " "虎")
("sa/ " "虱")
("ykj " "初")
("rlx " "表")
("qs " "軋")
("ojn " "迎")
("zbn " "返")
("on " "近")
("j;t " "邵")
("oast" "邸")
("oat " "邱")
("eqt " "邶")
(".v " "采")
("i " "金")
("qx " "長")
("e " "門")
("lef " "阜")
("tnq " "陀")
("tqd " "阿")
("tua " "阻")
("tkfh" "附")
("ttb " "陂")
("ky " "隹")
("z " "雨")
("ru " "青")
("ee " "非")
("ag;a" "亟")
("y;jd" "亭")
("y;js" "亮")
("ky " "信")
("ktjb" "侵")
("ktoz" "侯")
("kap." "便")
("kzkk" "俠")
("kbjf" "俑")
("kcu " "俏")
("k;v " "保")
("k;c " "促")
("k;l;" "侶")
("k.gf" "俘")
("kxoz" "俟")
("kxk." "俊")
("kkk;" "俗")
("kosz" "侮")
("klve" "俐")
("klox" "俄")
("klx " "係")
("kpr " "俚")
("kkua" "俎")
("iue " "俞")
("kbg;" "侷")
("yk;s" "兗")
("pj " "冒")
("pfu " "冑")
("jaah" "冠")
(".vhe" "剎")
("ktge" "剃")
("cue " "削")
("iue " "前")
("v;e " "剌")
("f;se" "剋")
("me " "則")
("bjfb" "勇")
("j;sb" "勉")
("fjgb" "勃")
("awqb" "勁")
("lqh " "匍")
("fjif" "南")
("kk;j" "卻")
("zpgf" "厚")
("izb " "叛")
(";yk." "咬")
("y;lx" "哀")
("aaj;" "咨")
(";f. " "哎")
("r;x " "哉")
("zqx " "咸")
(";ztg" "咦")
(";yxk" "咳")
(";rr " "哇")
(";a/ " "哂")
(";pz " "咽")
(";, " "咪")
(";;; " "品")
(";rk " "哄")
(";i; " "哈")
(";.; " "咯")
("bk;k" "咫")
(";lj " "咱")
(";kv " "咻")
(";if " "咩")
(";ame" "咧")
(";ktl" "咿")
("pzu " "囿")
("of " "垂")
("afer" "型")
("rtx " "垠")
("rapa" "垣")
("r.q " "垢")
("rzgx" "城")
("rzag" "垮")
("ryxk" "垓")
("ycz " "奕")
("fjz " "契")
("zaz " "奏")
("zrr " "奎")
("jjkz" "奐")
("irw " "姜")
("wif " "姘")
("aajw" "姿")
("wyk." "姣")
("wztg" "姨")
("wrr " "娃")
("wrlq" "姥")
("waxr" "姪")
("ws, " "姚")
("www " "姦")
("zawx" "威")
("wpz " "姻")
("gfyk" "孩")
("napa" "宣")
("nqdd" "宦")
("naxr" "室")
("n.; " "客")
("nzu " "宥")
("rrfh" "封")
("b, " "屎")
("bif " "屏")
("bamq" "屍")
("baxr" "屋")
("drfh" "峙")
("djq " "峒")
("rkts" "巷")
("ykjd" "帝")
("lejd" "帥")
("ycjd" "帟")
("dxxd" "幽")
("nif " "庠")
("nrb " "度")
("tfb " "建")
("ycf " "弈")
("tgae" "弭")
("n. " "彥")
(".tx " "很")
(".rfh" "待")
(".p; " "徊")
(".tf " "律")
(".lp " "徇")
(".x. " "後")
(".if " "徉")
("wbn " "怒")
("pn " "思")
("x;n " "怠")
("jtn " "急")
("oen " "怎")
("mgsn" "怨")
("ncas" "恍")
("ni; " "恰")
("ntx " "恨")
("nz, " "恢")
("nama" "恆")
("nrfh" "恃")
("naf;" "恬")
("njq " "恫")
("n.; " "恪")
("nlu " "恤")
("gjf " "扁")
("oaf " "拜")
("onks" "挖")
("onw " "按")
("oif " "拼")
("oaqx" "拭")
("orfh" "持")
("or; " "拮")
("opx " "拽")
("oqp " "指")
("ork " "拱")
("orlg" "拷")
("ogca" "拯")
("olf;" "括")
("oi; " "拾")
("oir " "拴")
("os, " "挑")
("orr " "挂")
("ae. " "政")
("f;. " "故")
("go " "斫")
("hogs" "施")
("bqs " "既")
("zp " "春")
("pj; " "昭")
("pjz " "映")
("pav " "昧")
("pac " "是")
("por " "星")
("poe " "昨")
("py " "昱")
("pib " "昤")
("plks" "曷")
("vyjd" "柿")
("clsv" "染")
("vyr " "柱")
("bgdv" "柔")
("rav " "某")
("v/ " "柬")
("b;v " "架")
("vf; " "枯")
("vjf " "柵")
("vqjk" "柩")
("vqd " "柯")
("vajk" "柄")
("vra " "柑")
("v;j " "枴")
("vpf " "柚")
("vpa " "查")
("vl; " "枸")
("vlp " "柏")
("voe " "柞")
("vodj" "柳")
("vai " "枰")
("vpd " "柙")
("voaa" "柢")
("voh " "柝")
("cqv " "柒")
("zae " "歪")
("amjz" "殃")
("amx;" "殆")
("osb " "段")
("rsz " "毒")
("pqq " "毗")
("otge" "氟")
("lpc " "泉")
("cif " "洋")
("cadd" "洲")
("crk " "洪")
("czo " "流")
("ctf " "津")
("came" "洌")
("cae " "洱")
("cjq " "洞")
("cos " "洗")
("clf;" "活")
("ci; " "洽")
("c.ok" "派")
("cl.d" "洶")
("c.; " "洛")
("gc " "泵")
("capa" "洹")
("czu " "洧")
("ccas" "洸")
("cpx " "洩")
("cs, " "洮")
("clp " "洵")
("clj " "洎")
("clu " "洫")
(",yx " "炫")
("hlg," "為")
(",ajk" "炳")
(",qt " "炬")
(",j; " "炯")
("dz, " "炭")
(",oe " "炸")
(",lts" "炮")
(",j; " "炤")
(".azb" "爰")
("ofor" "牲")
("off;" "牯")
("ofoa" "牴")
(".nfh" "狩")
(".tx " "狠")
(".yk." "狡")
("are;" "玷")
("arjf" "珊")
("artb" "玻")
("arib" "玲")
("ark." "珍")
("arlp" "珀")
("arkx" "玳")
("rqk " "甚")
("zjf " "甭")
("pax " "畏")
("pke " "界")
("pzh " "畎")
("p. " "畋")
("hsb " "疫")
("htds" "疤")
("hke " "疥")
("h, " "疢")
("hzsh" "疣")
("baz " "癸")
("qqlp" "皆")
("lpar" "皇")
("lpzb" "皈")
("lgbu" "盈")
("kju " "盆")
("zu " "盃")
(";du " "盅")
("clj " "省")
("jads" "盹")
("vj " "相")
("bj " "眉")
("lzj " "看")
(".fj " "盾")
("jkj " "盼")
("jcl " "眇")
("bgdg" "矜")
("gcl " "砂")
("gaf " "研")
("gqj " "砌")
("gjk " "砍")
("yhaz" "祆")
("yhe " "祉")
("yho " "祈")
("yhos" "祇")
("l;m " "禹")
("pm " "禺")
("lvhf" "科")
("lvcl" "秒")
("lv, " "秋")
("nkql" "穿")
("nkzh" "突")
("laf " "竿竽")
(",gf " "籽")
("xfh " "紂")
("xq " "紅")
("xts " "紀")
("xjh " "紉")
("xos " "紇")
("xlh " "約")
("xaf " "紆")
("ofdq" "缸")
("irz " "美")
("bbf " "羿")
("rlqq" "耄")
("aljh" "耐")
("aljw" "耍")
("dale" "耑")
("aet " "耶")
("ui " "胖")
("gcu " "胥")
("uza " "胚")
("pu " "胃")
("pfu " "胄")
("equ " "背")
("f;u " "胡")
("upd " "胛")
("ux; " "胎")
("ults" "胞")
("dxus" "胤")
("uoaa" "胝")
("axr." "致")
("lmd " "舢")
("fnad" "苧")
("fcgs" "范")
("fbgl" "茅")
("fqt " "苣")
("fqd " "苛")
("ff; " "苦")
("fb; " "茄")
("fz; " "若")
("fzx " "茂")
("fva " "茉")
("fjr " "苒")
("fp " "苗")
("fjz " "英")
("fdd " "茁")
("fj " "苜")
("fx; " "苔")
("fmgs" "苑")
("flts" "苞")
("fib " "苓")
("fl; " "苟")
("fva " "苯")
("fodj" "茆")
("eqa " "虐")
("/q " "虹")
("/ys " "虻")
("as/ " "虺")
(".cad" "衍")
("yk. " "衫")
("a/w " "要")
("jb " "觔")
("yf " "計")
("yad " "訂")
("yc " "訃")
("em " "貞")
("jm " "負")
("rcc " "赴")
("rcsd" "赳")
("sk " "趴")
("jq " "軍")
("qls " "軌")
("vhn " "述")
("b;n " "迦")
("j;n " "迢")
("pfn " "迪")
("j;n " "迥")
("ozn " "迭")
("lpn " "迫")
("ogdn" "迤")
("x;n " "迨")
("yk.t" "郊")
("hbt " "郎")
("zut " "郁")
("i;t " "郃")
("ip " "酋")
("apad" "酊")
("op " "重")
("ea " "閂")
("ttx " "限")
("tajs" "陋")
("talp" "陌")
("t.q " "降")
("alpe" "面")
("rf " "革")
("t;q " "韋")
("eea " "韭")
("yp " "音")
("alm " "頁")
("x " "風")
("skld" "飛")
("itx " "食")
("ilj " "首")
("lvp " "香")
("lveq" "乘")
("y;jq" "亳")
("kne " "倌")
("ky; " "倍")
("kh. " "倣")
("knkh" "俯")
("kizs" "倦")
("knkq" "倥")
("kzf " "俸")
("kru " "倩")
("krif" "倖")
("kajk" "倆")
("kfua" "值")
("krp " "借")
("kzqd" "倚")
("kaxe" "倒")
("ke " "們")
("kzps" "俺")
("kqx " "倀")
("kbdd" "倔")
("kbf;" "倨")
("kuak" "俱")
("kpp " "倡")
("kpf;" "個")
("kdtz" "候")
("kcj;" "倘")
("kee " "俳")
("kd.." "修")
("klvw" "倭")
("kos " "倪")
("klpf" "俾")
("kijf" "倫")
("itl;" "倉")
("itc " "兼")
("jj;h" "冤")
("jpyk" "冥")
("ja.h" "冢")
("kvp " "凍")
("krk." "凌")
("kky " "准")
("kjr;" "凋")
("y;e " "剖")
("nmge" "剜")
("pl.e" "剔")
("jide" "剛")
("wce " "剝")
("qee " "匪")
("odbj" "卿")
("zlpc" "原")
("zrp " "厝")
("odb " "叟")
(";cu " "哨")
("ntd;" "唐")
(";y " "唁")
(";zu " "唷")
(";y;d" "哼")
("qdqd" "哥")
("oo; " "哲")
(";xk." "唆")
(";qh " "哺")
(";at;" "唔")
(";pr " "哩")
(";;zh" "哭")
(";m " "員")
(";xoz" "唉")
(";rlf" "哮")
(";gft" "哪")
(";lox" "哦")
(";bj " "唧")
("zaa;" "唇")
(";ap." "哽")
(";.zd" "唏")
("pqh " "圃")
("pat;" "圄")
("rap." "埂")
("rqh " "埔")
("rpr " "埋")
("rxoz" "埃")
("rzu " "堉")
("alj." "夏")
("zz " "套")
("xrz " "奘")
(".xz " "奚")
("cclw" "娑")
("whtx" "娘")
("wgft" "娜")
("w;u " "娟")
("w;gz" "娛")
("wblq" "娓")
("wqdd" "姬")
("wzax" "娠")
("wktl" "娣")
("wj;s" "娩")
("wlox" "娥")
("wpr " "娌")
("wpfg" "娉")
("gflx" "孫")
("blqf" "屘")
("nyf " "宰")
("nr; " "害")
("na. " "家")
("npw " "宴")
("n;l;" "宮")
("ncu " "宵")
("nkk;" "容")
("nzax" "宸")
(".fh " "射")
("bcu " "屑")
("brx " "展")
("b.fb" "屐")
("dcu " "峭")
("dzkk" "峽")
("dxk." "峻")
("dkk;" "峪")
("dlox" "峨")
("d.f " "峰")
("ld " "島")
("drjk" "崁")
("djs " "峴")
("irlq" "差")
("nrjd" "席")
("lead" "師")
("nq " "庫")
("nlrb" "庭")
("nkkr" "座")
("tgkk" "弱")
(".rc " "徒")
(".awq" "徑")
(".iv " "徐")
("irn " "恙")
("aajn" "恣")
("aen " "恥")
("qshn" "恐")
("w;n " "恕")
("rkc " "恭")
("pzn " "恩")
("ljn " "息")
("ncu " "悄")
("nat;" "悟")
("nv; " "悚")
("npaf" "悍")
("nosz" "悔")
("nktl" "悌")
("nk;s" "悅")
("nfjf" "悖")
("gbb " "扇")
("izo " "拳")
("fjo " "挈")
("i;o " "拿")
("ocu " "捎")
("ozkk" "挾")
("ozax" "振")
("oqh " "捕")
("oat;" "捂")
("opv " "捆")
("opr " "捏")
("o;c " "捉")
("olrb" "挺")
("o;u " "捐")
("oj;s" "挽")
("ogft" "挪")
("okkr" "挫")
("oxoz" "挨")
("opaf" "捍")
("o;le" "捌")
("yk.." "效")
(",. " "敉")
(",hf " "料")
("ykjh" "旁")
("hook" "旅")
("prfh" "時")
("axxp" "晉")
("pnw " "晏")
("pcas" "晃")
("pa/ " "晒")
("plj;" "晌")
("papa" "晅")
("ps, " "晁")
("trp " "書")
("idu " "朔")
("uiz " "朕")
("hbu " "朗")
("vyk." "校")
("vyxk" "核")
("nwv " "案")
("vqar" "框")
("vapa" "桓")
("vtx " "根")
("vrr " "桂")
("vr; " "桔")
("vbb " "栩")
("vzo " "梳")
("a/v " "栗")
("epv " "桌")
("bbbv" "桑")
("rvx " "栽")
("eqv " "柴")
("vjq " "桐")
("mqv " "桀")
("v.; " "格")
("vs, " "桃")
("vov " "株")
("vjzs" "桅")
("vir " "栓")
("vmm " "栘")
("v.ad" "桁")
("amov" "殊")
("amlp" "殉")
(".tgb" "殷")
("o, " "氣")
("oif " "氧")
("onw " "氨")
("oyxk" "氦")
("opz " "氤")
("zc " "泰")
("chtx" "浪")
("cktl" "涕")
("ccu " "消")
("cawq" "涇")
("cqh " "浦")
("ctjb" "浸")
("cosz" "海")
("coo " "浙")
("c;u " "涓")
("cpr " "浬")
("cec " "涉")
("c.gf" "浮")
("cxk." "浚")
("ckk;" "浴")
("co; " "浩")
("cbjf" "涌")
("cjhn" "涊")
("czkk" "浹")
("cpr " "涅")
("c;ts" "浥")
("cdig" "涔")
(",if " "烊")
(",rk " "烘")
(",rlg" "烤")
(",.; " "烙")
("ame," "烈")
("l, " "烏")
("k.mm" "爹")
("ofrh" "特")
(".htx" "狼")
(".zkk" "狹")
(".m " "狽")
(".pr " "狸")
(".;u " "狷")
("yxyx" "玆")
("arhr" "班")
("arzo" "琉")
("arsd" "珮")
("arov" "珠")
("arrr" "珪")
("ar.;" "珞")
("pi " "畔")
("ypjk" "畝")
("yxp " "畜")
("xzp " "畚")
("ohjp" "留")
("hoz " "疾")
("hajk" "病")
("hae " "症")
("htb " "疲")
("hra " "疳")
("hua " "疽")
("h.h " "疼")
("hk. " "疹")
("hb; " "痂")
("hpa " "疸")
("lpzf" "皋")
("tbls" "皰")
("iku " "益")
("rxu " "盍")
("jzu " "盎")
("jyx " "眩")
("fuak" "真")
("jtss" "眠")
("jln " "眨")
("ozqt" "矩")
("gai " "砰")
("ge; " "砧")
("gqjd" "砸")
("grx " "砝")
("gtb " "破")
("gpd " "砷")
("goaa" "砥")
("gln " "砭")
("gua " "砠")
("goe " "砟")
("glts" "砲")
("yhnl" "祕")
("yhz;" "祐")
("yhgq" "祠")
("ddac" "祟")
("yhua" "祖")
("yhpd" "神")
("yh;s" "祝")
("yhoa" "祗")
("yhoe" "祚")
("lvai" "秤")
("lvva" "秣")
("lvjz" "秧")
("lvua" "租")
("zlv " "秦")
("lvoz" "秩")
("lvnl" "秘")
("nkoe" "窄")
("nkxb" "窈")
("ye; " "站")
("ltds" "笆")
("llz " "笑")
(",kj " "粉")
("xh " "紡")
("xcl " "紗")
("xy. " "紋")
("y.x " "紊")
("rx " "素")
("fjx " "索")
("xads" "純")
("xgr " "紐")
("xqq " "紕")
("xlb " "級")
("xaax" "紜")
("xjk " "納")
("xoas" "紙")
("xkj " "紛")
("ofdk" "缺")
("/f; " "罟")
("ir, " "羔")
("fbbb" "翅")
("kxbb" "翁")
("rlqp" "耆")
("fkax" "耘")
("fkfd" "耕")
("fkts" "耙")
("fklq" "耗")
("aejs" "耽")
("ae, " "耿")
("ucas" "胱")
("uqp " "脂")
("uztg" "胰")
("bbbu" "脅")
("upz " "胭")
("ujq " "胴")
("ujzs" "脆")
("ul.d" "胸")
("u.; " "胳")
("u.ok" "脈")
("xuqq" "能")
("k,u " "脊")
("uif " "胼")
("uzag" "胯")
("ljzh" "臭")
("ljv " "臬")
(".o " "舀")
("af;s" "舐")
("lmys" "航")
("lmh " "舫")
("lmzb" "舨")
("lmsb" "般")
("ldld" "芻")
("fcys" "茫")
("fyso" "荒")
("fbbb" "荔")
("fafe" "荊")
("fae " "茸")
("fzdf" "荐")
("fpf " "草")
("fpz " "茵")
("fp; " "茴")
("fkar" "荏")
("fxx " "茲")
("fw; " "茹")
("fkv " "茶")
("fm; " "茗")
("flp " "荀")
("fov " "茱")
("faak" "茨")
("fir " "荃")
("ey. " "虔")
("/y. " "蚊")
("/hf " "蚪")
("/tgd" "蚓")
("bhh/" "蚤")
("da/ " "蚩")
("/f " "蚌")
("/kx " "蚣")
("/qdl" "蚜")
("yplx" "衰")
("y;dx" "衷")
("r;lx" "袁")
("yktk" "袂")
("ykar" "衽")
("ykos" "衹")
("yts " "記")
("yaf " "訐")
("yfh " "討")
("yq " "訌")
("yd " "訕")
("ysf " "訊")
("ylq " "託")
("yed " "訓")
("yos " "訖")
("yaf " "訏")
("ygds" "訑")
("dqi " "豈")
(".fl " "豺")
(".lh " "豹")
("mfl " "財")
("qm " "貢")
("rcts" "起")
(".tg " "躬")
("qaf " "軒")
("qjh " "軔")
("qas " "軏")
("zaah" "辱")
("izn " "送")
("idn " "逆")
(",n " "迷")
("txn " "退")
("a/n " "迺")
("p;n " "迴")
("s,n " "逃")
("len " "追")
(".qn " "逅")
("ifn " "迸")
("w;ts" "邕")
("tl;t" "郡")
("rct " "郝")
(";lrt" "郢")
("cap " "酒")
("apts" "配")
("aplh" "酌")
("iad " "釘")
("if " "針")
("ie " "釗")
("k.ai" "釜")
("ic " "釙")
("ek " "閃")
("tnas" "院")
("tq " "陣")
("trc " "陡")
("tqqr" "陛")
("tzkk" "陝")
("tiv " "除")
("tawq" "陘")
("tlfr" "陞")
("kyb " "隻")
("ibs " "飢")
("g, " "馬")
("mu " "骨")
("y;j;" "高")
("e " "鬥")
("qjid" "鬲")
("ox " "鬼")
("fpfs" "乾")
("k.kp" "偺")
("khl," "偽")
("ky;d" "停")
("ketb" "假")
("kqpw" "偃")
("kfz;" "偌")
("kf;." "做")
("kt;q" "偉")
("ktfb" "健")
("kpm " "偶")
("kpax" "偎")
("kqqp" "偕")
("kem " "偵")
("kme " "側")
("kiue" "偷")
("kgjf" "偏")
("kd.h" "倏")
("ky;x" "偯")
("kale" "偭")
("lpos" "兜")
("pj;s" "冕")
("slpr" "凰")
("iuej" "剪")
("qpe " "副")
("rfb " "勒")
("bgdb" "務")
("rqkb" "勘")
("opb " "動")
("lqp " "匐")
("zaas" "匏")
("pacq" "匙")
("qfz;" "匿")
("q;;;" "區")
("qgjf" "匾")
("xxx." "參")
("p/b " "曼")
("ykj;" "商")
(";olp" "啪")
(";oy " "啦")
(";a.h" "啄")
(";aea" "啞")
(";ee " "啡")
(";eu " "啃")
(";tqd" "啊")
(";pp " "唱")
(";,, " "啖")
("e; " "問")
(";lod" "啕")
(";ky " "唯")
(";lpf" "啤")
(";ign" "唸")
("ky; " "售")
(";bbb" "啜")
(";es " "唬")
(";oaj" "啣")
(";gzh" "唳")
(";jr;" "啁")
(";jo " "啗")
("pizs" "圈")
("pqax" "國")
("prif" "圉")
("rqax" "域")
("qdtr" "堅")
("aear" "堊")
("rky " "堆")
("rlef" "埠")
("rlpf" "埤")
("rakr" "基")
("cj;r" "堂")
("rrlp" "堵")
("rifh" "執")
("ry; " "培")
("mml;" "夠")
("zrlp" "奢")
("aebw" "娶")
("p;dw" "婁")
("wnms" "婉")
("wtjd" "婦")
("vvw " "婪")
("wtqd" "婀")
("wpp " "娼")
("wlpf" "婢")
("woap" "婚")
("ctbw" "婆")
("wrlx" "婊")
("y;gh" "孰")
("naab" "寇")
("napk" "寅")
("nzqd" "寄")
("neab" "寂")
("nkap" "宿")
("nnld" "密")
("baah" "尉")
("zfh " "專")
("xmfh" "將")
("brlp" "屠")
("b.rs" "屜")
("bee " "屝")
("dnac" "崇")
("dnkq" "崆")
("dzqd" "崎")
("dbdd" "崛")
("dzrr" "崖")
("d.td" "崢")
("dpqq" "崑")
("duu " "崩")
("dky " "崔")
("dijf" "崙")
("d.zu" "崤")
("dvkx" "崧")
("djid" "崗")
("wpv " "巢")
("cj;d" "常")
("rjjd" "帶")
("jdqx" "帳")
("jdky" "帷")
("ntc " "康")
("ntjf" "庸")
("nr, " "庶")
("nzps" "庵")
("nok " "庾")
("tgqx" "張")
("tgx/" "強")
("fft " "彗")
("vv. " "彬")
(".v. " "彩")
("jr;." "彫")
(".pah" "得")
(".ec " "徙")
(".kkc" "從")
(".ee " "徘")
(".oaj" "御")
(".vkk" "徠")
(".cj;" "徜")
("bjfn" "恿")
(";;dn" "患")
("l,n " "悉")
("kd.n" "悠")
("kjcn" "您")
("nnms" "惋")
("nykf" "悴")
("nne;" "惦")
("natw" "悽")
("nru " "情")
("nrif" "悻")
("nqx " "悵")
("nrp " "惜")
("nepf" "悼")
("njis" "惘")
("npl." "惕")
("njr;" "惆")
("nky " "惟")
("nlvf" "悸")
("nl.n" "惚")
("ny;f" "惇")
("zeax" "戚")
("aljx" "戛")
("g;ts" "扈")
("oy;c" "掠")
("onkq" "控")
("oizs" "捲")
("oykk" "掖")
("ojkv" "探")
("oyw " "接")
("oatc" "捷")
("ozf " "捧")
("obdd" "掘")
("orp " "措")
("ozrr" "捱")
("ozps" "掩")
("oepf" "掉")
("otjd" "掃")
("orrc" "掛")
("oe " "捫")
("oky " "推")
("oijf" "掄")
("o.jb" "授")
("o.td" "掙")
("o.v " "採")
("ol, " "掬")
("oee " "排")
("olod" "掏")
("oojk" "掀")
("oign" "捻")
("ogzh" "捩")
("oif;" "捨")
("ozac" "捺")
(",. " "敝")
("rh. " "敖")
("f,h." "救")
("rlg." "教")
("m. " "敗")
("g;. " "啟")
("osz." "敏")
("iv. " "敘")
("v;. " "敕")
("at;." "敔")
("ivhf" "斜")
("jhf " "斛")
("qo " "斬")
("hooz" "族")
("hogc" "旋")
("hoor" "旌")
("hobq" "旎")
("trpa" "晝")
("pj;s" "晚")
("pat;" "晤")
("pzax" "晨")
("posz" "晦")
("p.zd" "晞")
("qp " "曹")
("puab" "勗")
("ysmr" "望")
("cjhv" "梁")
("vktl" "梯")
("vcu " "梢")
("vyf " "梓")
("vvsh" "梵")
("vpaf" "桿")
("vbjf" "桶")
("vpv " "梱")
("vat;" "梧")
("vap." "梗")
("vafx" "械")
("vlrb" "梃")
("zrv " "棄")
("vxk." "梭")
("vft " "梆")
("vosz" "梅")
("v.as" "梔")
("kd.v" "條")
("lvev" "梨")
("lv " "梟")
("vnas" "梡")
("vf,h" "梂")
("kk;k" "欲")
(".vhb" "殺")
("y;jq" "毫")
("lqfh" "毬")
("oawq" "氫")
("cleb" "涎")
("cy;c" "涼")
("cy;f" "淳")
("cnac" "淙")
("cykk" "液")
("c,, " "淡")
("ccj;" "淌")
("chkh" "淤")
("cazc" "添")
("caxx" "淺")
("cru " "清")
("crak" "淇")
("cvv " "淋")
("czrr" "涯")
("ceab" "淑")
("cbje" "涮")
("cvkx" "淞")
("czps" "淹")
("cpf;" "涸")
("cpqq" "混")
("ce " "淵")
("cvo " "淅")
("catw" "淒")
("crlp" "渚")
("cgcd" "涵")
("cgzh" "淚")
("c.lr" "淫")
("clod" "淘")
("cijf" "淪")
("cjkv" "深")
("cky " "淮")
("c.td" "淨")
("c.zu" "淆")
("cwp " "淄")
("cy; " "涪")
("cykf" "淬")
("ca.h" "涿")
("ci " "淦")
("y;g," "烹")
("aea," "焉")
(",paf" "焊")
(",.f " "烽")
(",.zd" "烯")
("z..." "爽")
("yxjf" "牽")
("lvef" "犁")
(".ru " "猜")
(".gfu" "猛")
(".pp " "猖")
(".pv " "猓")
("..td" "猙")
("yx,f" "率")
("arhx" "琅")
("arqt" "琊")
("arfh" "球")
("arpr" "理")
("arjs" "現")
("arle" "琍")
("zaak" "瓠")
("ifqh" "瓶")
("aajh" "瓷")
("af;a" "甜")
("nor " "產")
("p.; " "略")
("prr " "畦")
("pff " "畢")
("prk " "異")
("gezo" "疏")
("hrfh" "痔")
("htx " "痕")
("heq " "疵")
("hir " "痊")
("hztg" "痍")
("lpy." "皎")
("z,u " "盔")
("i;u " "盒")
("zgxu" "盛")
("izj " "眷")
("/kkk" "眾")
("jtx " "眼")
("jqar" "眶")
("jxof" "眸")
("js, " "眺")
("gzo " "硫")
("gov " "硃")
("gafe" "硎")
("yhif" "祥")
("a/ac" "票")
("maac" "祭")
("lvmm" "移")
("nkar" "窒")
("nks," "窕")
("ly " "笠")
("lva " "笨")
("lpf " "笛")
("ltgl" "第")
("lkfh" "符")
("lor " "笙")
("lx; " "笞")
("loe " "笮")
(",y " "粒")
(",ua " "粗")
(",lp " "粕")
("xi " "絆")
("xyx " "絃")
("xzs " "統")
("vsx " "紮")
("xj; " "紹")
("xtge" "紼")
("xdd " "絀")
("xp " "細")
("xpd " "紳")
("xua " "組")
("px " "累")
("x.h " "終")
("xrs " "紲")
("xz.h" "紱")
("ofda" "缽")
("irlr" "羞")
("ifib" "羚")
("bby " "翌")
("ibbb" "翎")
("bblp" "習")
("fke " "耜")
("aeoj" "聊")
("aeib" "聆")
("uqh " "脯")
("ufjf" "脖")
("zaau" "脣")
("uk;s" "脫")
("kd.u" "脩")
("uqi " "脰")
("uzax" "脤")
("zo " "舂")
("lmnq" "舵")
("lmyx" "舷")
("lmlp" "舶")
("lmk;" "船")
("fccl" "莎")
("fnas" "莞")
("fyf " "莘")
("ffjf" "荸")
("fzkk" "莢")
("fawq" "莖")
("fzhf" "莽")
("fpz " "莫")
("f;l;" "莒")
("fxr " "莊")
("fosz" "莓")
("flve" "莉")
("flvg" "莠")
("fkqd" "荷")
("f., " "荻")
("fiv " "荼")
("fqh " "莆")
("fjs " "莧")
("e.s " "處")
("es. " "彪")
("/nq " "蛇")
("/yr " "蛀")
("/ra " "蚶")
("/f; " "蛄")
("/qd " "蚵")
("/ua " "蛆")
("gc/ " "蛋")
("/oe " "蚱")
("/oa " "蚯")
("/ib " "蛉")
(".vhd" "術")
("yk;x" "袞")
("b;yx" "袈")
("yktb" "被")
("ykpa" "袒")
("ykpf" "袖")
("ykls" "袍")
("kaxx" "袋")
(".js " "覓")
("zjs " "規")
("yh " "訪")
("yqdl" "訝")
("ytk " "訣")
("yjk " "訥")
("yof " "許")
("ysb " "設")
("ykx " "訟")
("ykq " "訛")
("yo " "訢")
("qifb" "豉")
("ua. " "豚")
("mzb " "販")
("rm " "責")
("sfm " "貫")
("kqm " "貨")
("igm " "貪")
("kjm " "貧")
("rcjb" "赧")
("rc. " "赦")
("se " "趾")
("sz " "趺")
("qzgs" "軛")
("qjk " "軟")
("yn " "這")
("cun " "逍")
("bjfn" "通")
("qin " "逗")
("qn " "連")
("v;n " "速")
("oon " "逝")
("a.n " "逐")
("awqn" "逕")
(";lrn" "逞")
("o;n " "造")
("lvln" "透")
(".fn " "逢")
(".,n " "逖")
(".arn" "逛")
("ivn " "途")
("y;t " "部")
("y;gt" "郭")
("rlpt" "都")
("ap.d" "酗")
("prbd" "野")
("ibh " "釵")
("i; " "釦")
("ilh " "釣")
("ied " "釧")
("iq " "釭")
("ish " "釩")
("efl " "閉")
("ty; " "陪")
("trk." "陵")
("tvp " "陳")
("trkr" "陸")
("titx" "陰")
("tlpf" "陴")
("tlod" "陶")
("tjo " "陷")
("taeb" "陬")
("cky " "雀")
("zt " "雪")
("zaag" "雩")
("ypf " "章")
("yps " "竟")
("adam" "頂")
("qalm" "頃")
("u, " "魚")
("l, " "鳥")
("ep.h" "鹵")
("yqq " "鹿")
("fkkm" "麥")
("nvv " "麻")
("kna." "傢")
("kykh" "傍")
("kqhh" "傅")
("krlf" "備")
("kmqv" "傑")
("kox " "傀")
("kit;" "傖")
("kkkf" "傘")
("kyk." "傚")
("paeb" "最")
("dqis" "凱")
("nr;e" "割")
("dqie" "剴")
("itle" "創")
("lvee" "剩")
(",,jb" "勞")
("uizb" "勝")
(";mb " "勛")
("fqhh" "博")
("zidk" "厥")
("ykj;" "啻")
(";n.;" "喀")
(";naa" "喧")
(";ykd" "啼")
(";zqx" "喊")
(";pls" "喝")
(";dae" "喘")
(";pax" "喂")
("r;i;" "喜")
("f;;x" "喪")
(";bar" "喔")
(";v;e" "喇")
(";rsv" "喋")
(";fjf" "喃")
(";vpa" "喳")
(";;pf" "單")
(";pu " "喟")
(";of " "唾")
(";xlh" "喲")
(";jjz" "喚")
(";iue" "喻")
("lz;;" "喬")
(";zpr" "喱")
(";lv," "啾")
(";ktz" "喉")
(";fjz" "喫")
(";w. " "喙")
("pt;q" "圍")
("rrrs" "堯")
("rrqk" "堪")
("rpa." "場")
("rpac" "堤")
("rqpw" "堰")
("rifb" "報")
("k;vr" "堡")
("rm; " "堝")
("rktz" "堠")
("vqi " "壹")
("vea " "壺")
("ipz " "奠")
("wy;d" "婷")
("wbj " "媚")
("wgcu" "婿")
("wrav" "媒")
("w.ab" "媛")
("wm; " "媧")
("ixxf" "孳")
("bgff" "孱")
("nrkh" "寒")
("nqp " "富")
("npm " "寓")
("nxav" "寐")
("ipfh" "尊")
("tq;h" "尋")
("y;ch" "就")
("drak" "嵌")
("dx " "嵐")
("dzax" "崴")
("lvzd" "嵇")
("tstk" "巽")
("jdqp" "幅")
("jdpj" "帽")
("jdem" "幀")
("jdtq" "幃")
("xxzx" "幾")
("nhbt" "廊")
("nme " "廁")
("nvj " "廂")
("nbsb" "廄")
("tgag" "弼")
("r;i." "彭")
(".op." "復")
("..fj" "循")
(".lpr" "徨")
("qaxn" "惑")
("aean" "惡")
("een " "悲")
("en " "悶")
("zn " "惠")
("nqzk" "愜")
("n/h " "愣")
("npor" "惺")
("n;;g" "愕")
("nzqu" "惰")
("nme " "惻")
("ndae" "惴")
("nbqs" "慨")
("nwl." "惱")
("nop." "愎")
("nlpr" "惶")
("niue" "愉")
("nlv," "愀")
("npls" "愒")
("fpfx" "戟")
("gee " "扉")
("oajo" "掣")
("cj;o" "掌")
("ofp " "描")
("ov/ " "揀")
("oqqp" "揩")
("obgv" "揉")
("obaz" "揆")
("ozaz" "揍")
("oafo" "插")
("odae" "揣")
("opac" "提")
("obar" "握")
("o;ae" "揖")
("opls" "揭")
("ojq " "揮")
("oof " "捶")
("o.ab" "援")
("olv," "揪")
("ojjz" "換")
("obif" "摒")
("opa." "揚")
("oequ" "揹")
("cj;." "敞")
("y;g." "敦")
("qe. " "敢")
("ru. " "散")
("aryr" "斑")
("eey." "斐")
("rako" "斯")
("icap" "普")
("pvo " "晰")
("pru " "晴")
("ppp " "晶")
("py;c" "景")
("prlp" "暑")
("oz;p" "智")
("py;c" "晾")
("p.k;" "晷")
("k/p " "曾")
("zzp " "替")
("raku" "期")
("fpfu" "朝")
("vne " "棺")
("vnac" "棕")
("cj;v" "棠")
("vjvj" "棘棗")
("vzqd" "椅")
("vvp " "棟")
("vpv " "棵")
("vvv " "森")
("vaxx" "棧")
("vepf" "棹")
("vzf " "棒")
("vatw" "棲")
("vtc " "棣")
("vrak" "棋")
("vpqq" "棍")
("vfua" "植")
("veab" "椒")
("vky " "椎")
("vlpd" "棉")
("vuu " "棚")
("vrlp" "楮")
("fkjv" "棻")
("raak" "款")
("rakk" "欺")
("ijk " "欽")
("amax" "殘")
("amfa" "殖")
("vasb" "殼")
("lq,," "毯")
("o,, " "氮")
("owc " "氯")
("oaea" "氬")
("crks" "港")
("chof" "游")
("ciue" "湔")
("cnrb" "渡")
("cnaa" "渲")
("cbjb" "湧")
("czaz" "湊")
("cqtv" "渠")
("cbar" "渥")
("cvpa" "渣")
("czqx" "減")
("crqk" "湛")
("cvj " "湘")
("cfjb" "渤")
("cf;u" "湖")
("ca/r" "湮")
("cpu " "渭")
("cm; " "渦")
("cpa." "湯")
("cpls" "渴")
("cdae" "湍")
("cjcl" "渺")
("cme " "測")
("coaf" "湃")
("ciue" "渝")
("cjq " "渾")
("cixx" "滋")
("cbqs" "溉")
("cjjz" "渙")
("cale" "湎")
("ctsp" "湣")
("cbj " "湄")
("c.ab" "湲")
("cop " "湩")
("clpr" "湟")
(",y; " "焙")
("vv, " "焚")
("ky, " "焦")
(",jo " "焰")
("or, " "無")
("mzh," "然")
("rlp," "煮")
(",pqq" "焜")
("dlpf" "牌")
("ofzd" "犄")
("bcof" "犀")
(".ip " "猶")
(".pax" "猥")
(".ktz" "猴")
(".por" "猩")
("arcx" "琺")
("arrk" "琪")
("arvv" "琳")
("arah" "琢")
("ares" "琥")
("araq" "琵")
("aras" "琶")
("arag" "琴")
("arne" "琯")
("arjv" "琛")
("arzd" "琦")
("arpq" "琨")
("orpb" "甥")
("ap.r" "甦")
("trpa" "畫")
("l,p " "番")
("hlve" "痢")
("hbjf" "痛")
("hrn " "痣")
("hawq" "痙")
("hqi " "痘")
("hz; " "痞")
("hxk." "痠")
("bqi " "登")
("btgb" "發")
("lpns" "皖")
("lpo;" "皓")
("xk.b" "皴")
("cjku" "盜")
("jpv " "睏")
("ozqi" "短")
("gcu " "硝")
("gap." "硬")
("gjs " "硯")
("lvcu" "稍")
("lvpf" "稈")
("lv;r" "程")
("lvks" "稅")
("lv.d" "稀")
("nkt;" "窘")
("nklh" "窗")
("nko;" "窖")
("ypr " "童")
("yxk." "竣")
("lrfh" "等")
("lvj " "策")
("ltf " "筆")
("lqar" "筐")
("ljq " "筒")
("li; " "答")
("llp " "筍")
("lub " "筋")
("lkax" "筏")
("lqsh" "筑")
("a/, " "粟")
("tg,g" "粥")
("xyk." "絞")
("xr; " "結")
("xafx" "絨")
("xjts" "絕")
("eqx " "紫")
("w;x " "絮")
("xx " "絲")
("x.; " "絡")
("xi; " "給")
("xlp " "絢")
("xaxr" "絰")
("x.q " "絳")
("iri;" "善")
("ifbb" "翔")
("i;bb" "翕")
("rlqr" "耋")
("ael;" "聒")
("tde " "肅")
("unms" "腕")
("unkq" "腔")
("uykk" "腋")
("unkh" "腑")
("qdtu" "腎")
("uqx " "脹")
("ujrk" "腆")
("ulpf" "脾")
("uzps" "腌")
("uee " "腓")
("uok " "腴")
("if;d" "舒")
(".jmq" "舜")
("fy; " "菩")
("fykf" "萃")
("fhkh" "菸")
("fcai" "萍")
("fctb" "菠")
("fne " "菅")
("fatw" "萋")
("fru " "菁")
("faff" "華")
("frk." "菱")
("fzps" "菴")
("frlp" "著")
("fvkk" "萊")
("fgfk" "菰")
("fpu " "萌")
("fplv" "菌")
("feab" "菽")
("fee " "菲")
("fl, " "菊")
("fok " "萸")
("flvw" "萎")
("flod" "萄")
("f.v " "菜")
("fqx " "萇")
("fujb" "菔")
("fj;h" "菟")
("ewa " "虛")
("/yk." "蛟")
("/rr " "蛙")
("/axr" "蛭")
("/p; " "蛔")
("/ov " "蛛")
("/i; " "蛤")
("/pf " "蛐")
("/lf;" "蛞")
(".rrd" "街")
("rylx" "裁")
("amex" "裂")
("ykkh" "袱")
("a/pf" "覃")
("yhjs" "視")
("yyr " "註")
("yhb " "詠")
("yai " "評")
("ygq " "詞")
("yae " "証")
("yf; " "詁")
("yj; " "詔")
("yua " "詛")
("yoe " "詐")
("yoaa" "詆")
("yoh " "訴")
("yk. " "診")
("yqd " "訶")
("ytb " "詖")
("jp. " "象")
(".j; " "貂")
("mnad" "貯")
("me; " "貼")
("aaax" "貳")
("mx; " "貽")
("ffm " "賁")
("tgem" "費")
("b;m " "賀")
(";dam" "貴")
("/m " "買")
("mln " "貶")
("ohjm" "貿")
("kaxm" "貸")
("rcqx" "越")
("rcj;" "超")
("rck." "趁")
("snq " "跎")
("sqt " "距")
("sz.h" "跋")
("sjf " "跚")
("slts" "跑")
("soz " "跌")
("stb " "跛")
("sx; " "跆")
("qqd " "軻")
("qpf " "軸")
("qoz " "軼")
("f;yf" "辜")
("tcn " "逮")
("rkrn" "逵")
("jr;n" "週")
("j;sn" "逸")
("kyn " "進")
("lvwn" "逶")
(";;at" "鄂")
("oft " "郵")
("sxht" "鄉")
("qpwt" "郾")
("apra" "酣")
("aplv" "酥")
("papr" "量")
("icl " "鈔")
("igr " "鈕")
("iaeg" "鈣")
("ijk " "鈉")
("ilaa" "鈞")
("iads" "鈍")
("iig " "鈐")
("iz " "鈇")
("izb " "鈑")
("ey. " "閔")
("ear " "閏")
("eaf " "開")
("ev " "閑")
("ep " "間")
("eu " "閒")
("ezx " "閎")
("ti. " "隊")
("tqqp" "階")
("tzqu" "隋")
("tpa." "陽")
("tpm " "隅")
("t.ar" "隆")
("tlpr" "隍")
("tof " "陲")
("tpac" "隄")
("zkky" "雁")
("qdly" "雅")
("zxky" "雄")
("kyv " "集")
("gky " "雇")
("zy. " "雯")
("zaax" "雲")
("t;qh" "韌")
("qalm" "項")
("edam" "順")
(".alm" "須")
("mitx" "飧")
("ibar" "飪")
("ibzb" "飯")
("ibas" "飩")
("ibjk" "飲")
("ibob" "飭")
("kg, " "馮")
("g,b " "馭")
("rpk " "黃")
("lvkc" "黍")
("p, " "黑")
(".bms" "亂")
("kntf" "傭")
("krm " "債")
("krh." "傲")
("kzfh" "傳")
("krr " "僅")
("kqam" "傾")
("kdky" "催")
("kop." "傷")
("klp." "傻")
("klpn" "傯")
("kbb." "僇")
("wpve" "剿")
("nore" "剷")
("a/ae" "剽")
("fpzb" "募")
("wpvb" "勦")
("rrb " "勤")
("rkrb" "勢")
("rmb " "勣")
("qcky" "匯")
(";irq" "嗟")
(";coz" "嗨")
(";bbv" "嗓")
(";fjx" "嗦")
(";g, " "嗎")
(";rlp" "嗜")
("fkk;" "嗇")
(";rxu" "嗑")
(";jfq" "嗣")
(";da/" "嗤")
(";pzn" "嗯")
(";l, " "嗚")
(";kxb" "嗡")
(";ljh" "嗅")
(";it;" "嗆")
(";lpf" "嗥")
(";rx " "嗉")
("pr;x" "園")
("p;m " "圓")
("nrkr" "塞")
("idur" "塑")
("rnt;" "塘")
("civr" "塗")
("rjah" "塚")
("rfi;" "塔")
("rfuk" "填")
("rpbb" "塌")
("r/u " "塭")
("rox " "塊")
("rl, " "塢")
("rprh" "塒")
(",,jr" "塋")
("ljlz" "奧")
("wna." "嫁")
("whoz" "嫉")
("witc" "嫌")
("wrjr" "媾")
("wg, " "媽")
("w/u " "媼")
("wljn" "媳")
("wodb" "嫂")
("wlpq" "媲")
("dy;;" "嵩")
("dirq" "嵯")
("jdps" "幌")
("fpff" "幹")
("nitc" "廉")
("nal." "廈")
(".vhx" "弒")
("wjpv" "彙")
(".ykh" "徬")
("os. " "微")
("pmn " "愚")
("ypn " "意")
("ixxn" "慈")
("zqnx" "感")
("vjn " "想")
(".jn." "愛")
("fz;n" "惹")
("lv,n" "愁")
("iuen" "愈")
("nfuk" "慎")
("nfyo" "慌")
("na/v" "慄")
("n/u " "慍")
("no, " "愾")
("nit;" "愴")
("nox " "愧")
("tsan" "愍")
(".can" "愆")
("ndqi" "愷")
("rqkx" "戡")
(";aex" "戢")
("oirq" "搓")
("onke" "搾")
("oy;;" "搞")
("ont;" "搪")
("ofi;" "搭")
("ofkv" "搽")
("olmb" "搬")
("oqhh" "搏")
("oodb" "搜")
("obh/" "搔")
("o;m " "損")
("oit;" "搶")
("omod" "搖")
("old " "搗")
("orjr" "搆")
("fl;." "敬")
("rqkf" "斟")
("yvo " "新")
("pyp " "暗")
("pjq " "暉")
("petb" "暇")
("pjq " "暈")
("p.ab" "暖")
("pnaa" "暄")
("ppa." "暘")
("ppls" "暍")
("i/p " "會")
("vhbt" "榔")
("caiv" "業")
("vvgc" "楚")
("vqqp" "楷")
("vfjf" "楠")
("vfjz" "楔")
("vaga" "極")
("vaet" "椰")
("vbqs" "概")
("vpa." "楊")
("vem " "楨")
("v;ae" "楫")
("v/h " "楞")
("vx " "楓")
("vlgu" "楹")
("viue" "榆")
("vv/ " "楝")
("vbj " "楣")
("vff;" "楛")
("plkk" "歇")
("ezax" "歲")
("orsb" "毀")
("brkb" "殿")
("oszo" "毓")
("lqtb" "毽")
("ciku" "溢")
("cidu" "溯")
("cnyf" "滓")
("cnk;" "溶")
("cykh" "滂")
("czlc" "源")
("crjr" "溝")
("cfuk" "滇")
("czax" "滅")
("cqhh" "溥")
("crxu" "溘")
("caxr" "溼")
("ctgk" "溺")
("c/u " "溫")
("cmu " "滑")
("ckyf" "準")
("cohp" "溜")
("cit;" "滄")
("c.o " "滔")
("c.xz" "溪")
("ca/v" "溧")
("cljh" "溴")
("iue," "煎")
(",a/r" "煙")
(",alm" "煩")
(",rav" "煤")
(",v/ " "煉")
("pj;," "照")
(",py " "煜")
(",pa." "煬")
("pl;," "煦")
(",lpr" "煌")
(",jjz" "煥")
("jt.," "煞")
(",etb" "煆")
(",pax" "煨")
(",.ab" "煖")
("k.at" "爺")
("drsv" "牒")
("ipzh" "猷")
(".led" "獅")
(".r;x" "猿")
(".mu " "猾")
("arht" "瑯")
("arfu" "瑚")
("areb" "瑕")
("aral" "瑟")
("arde" "瑞")
("arpj" "瑁")
("arjq" "琿")
("arw." "瑙")
("arfz" "瑛")
("arie" "瑜")
("cj;p" "當")
("pzqd" "畸")
("hhkh" "瘀")
("h,, " "痰")
("hykf" "瘁")
("hvv " "痲")
("hee " "痱")
("hlpf" "痺")
("hlvw" "痿")
("hoz;" "痴")
("hvv " "痳")
("axau" "盞")
("puu " "盟")
("jru " "睛")
("jatc" "睫")
("jrkr" "睦")
("jvkk" "睞")
("eacj" "督")
("jrlp" "睹")
("/rif" "睪")
("j.v " "睬")
("j.td" "睜")
("jlpf" "睥")
("jos " "睨")
("jky " "睢")
("ozlw" "矮")
("gykf" "碎")
("gica" "碰")
("gnms" "碗")
("gjrk" "碘")
("gwc " "碌")
("gjr;" "碉")
("guu " "硼")
("glpf" "碑")
("gky " "碓")
("gnkq" "硿")
("yhrk" "祺")
("yhwc" "祿")
("vvac" "禁")
("fpm " "萬")
("ky.m" "禽")
("lvr." "稜")
("lvky" "稚")
("lvj;" "稠")
("lvin" "稔")
("yp;v" "稟")
("lvpv" "稞")
("nkbd" "窟")
("nkpv" "窠")
("lntk" "筷")
("lbj " "節")
("lrla" "筠")
("lqkk" "筮")
("ljs " "筧")
("cjh," "粱")
(",ap." "粳")
("lplg" "粵")
("xawq" "經")
("x;u " "絹")
("xpv " "綑")
("xft " "綁")
("x.w " "綏")
("kd.x" "絛")
("/fua" "置")
("/epf" "罩")
("/ee " "罪")
("/rlp" "署")
("irlx" "義")
("irck" "羨")
("tl;f" "群")
("ae;r" "聖")
("aepg" "聘")
("ztf " "肆")
("qozf" "肄")
("utfb" "腱")
("ua/w" "腰")
("upa." "腸")
("upor" "腥")
("upn " "腮")
("ukkj" "腳")
("uop " "腫")
("uop." "腹")
("ulpc" "腺")
("uwl." "腦")
("opb " "舅")
("lmlb" "艇")
("fykd" "蒂")
("fjq " "葷")
("fc.;" "落")
("fnaa" "萱")
("fbaz" "葵")
("ft;q" "葦")
("ff;u" "葫")
("frsv" "葉")
("famf" "葬")
("fpls" "葛")
("f;;g" "萼")
("fm; " "萵")
("flqh" "葡")
("fop " "董")
("flps" "葩")
("fetb" "葭")
("fk;v" "葆")
("e;gz" "虞")
("epdb" "虜")
(";ags" "號")
("/bjf" "蛹")
("/lrb" "蜓")
("/;gz" "蜈")
("oo/ " "蜇")
("/l/ " "蜀")
("/lox" "蛾")
("/k;s" "蛻")
("/.f " "蜂")
("zaa/" "蜃")
("/js " "蜆")
("/lve" "蜊")
(".atd" "衙")
("cclx" "裟")
("ylx;" "裔")
("ykt;" "裙")
("ykqh" "補")
("f,hx" "裘")
("xryx" "裝")
("ykpr" "裡")
("lylx" "裊")
("ykk;" "裕")
("yolx" "裒")
("s,js" "覜")
("jjof" "解")
("ynlq" "詫")
("yyxk" "該")
("yif " "詳")
("yaqx" "試")
("yrfh" "詩")
("yr; " "詰")
("yzag" "誇")
("yz, " "詼")
("yqp " "詣")
("yzgx" "誠")
("ylf;" "話")
("yov " "誅")
("yjzs" "詭")
("ylp " "詢")
("yir " "詮")
("y.q " "詬")
("jzky" "詹")
("y.; " "詻")
("eqy " "訾")
("yyk." "詨")
("iza." "豢")
(".alp" "貊")
("..; " "貉")
("mafx" "賊")
("aajm" "資")
("a/m " "賈")
("mzu " "賄")
("eqm " "貲")
("karm" "賃")
("m.; " "賂")
("myxk" "賅")
("syc " "跡")
("stx " "跟")
("szag" "跨")
("s.; " "路")
("ss, " "跳")
("ssv " "跺")
("sjzs" "跪")
("syk." "跤")
("sov " "跦")
(".sv " "躲")
("qyk." "較")
("rqx " "載")
("qaqx" "軾")
("qaxr" "輊")
("b;yf" "辟")
("pfzx" "農")
("jqn " "運")
("hogn" "遊")
("iljn" "道")
("i.n " "遂")
("rifn" "達")
("qpn " "逼")
("t;qn" "違")
("etbn" "遐")
("pmn " "遇")
("plkn" "遏")
("m;n " "過")
("gjfn" "遍")
("lpan" "遑")
("iuen" "逾")
(".fjn" "遁")
("ldlt" "鄒")
("y;jt" "鄗")
("apad" "酬")
("ap.;" "酪")
("apm;" "酩")
(".vpf" "釉")
("if; " "鈷")
("ira " "鉗")
("iz.h" "鈸")
("izjd" "鈽")
("ipd " "鉀")
("ipf " "鈾")
("ik; " "鉛")
("ilts" "鉋")
("il; " "鉤")
("ilp " "鉑")
("iib " "鈴")
("iyx " "鉉")
("inl " "鉍")
("iqt " "鉅")
("itb " "鈹")
("ip " "鈿")
("iodj" "鉚")
("epd " "閘")
("tiku" "隘")
("tqjd" "隔")
("t;m " "隕")
("ysxy" "雍")
("kyd " "雋")
("ozky" "雉")
("l;ky" "雊")
("zp " "雷")
("zps " "電")
("zlts" "雹")
("zib " "零")
("yru " "靖")
("rfkq" "靴")
("rfts" "靶")
("bgdm" "預")
("aasm" "頑")
("adsm" "頓")
("aram" "頊")
("kjam" "頒")
("kxam" "頌")
("ibgq" "飼")
("ibx;" "飴")
("ibls" "飽")
("ibod" "飾")
("g,gs" "馳")
("g,z " "馱")
("g,ed" "馴")
("z.as" "髡")
("lsl," "鳩")
("yqqs" "麂")
("jg " "鼎")
("r;ib" "鼓")
("ow " "鼠")
("kk/p" "僧")
("kypr" "僮")
("krrs" "僥")
("kr;;" "僖")
("kqsp" "僭")
("kzkc" "僚")
("kcaz" "僕")
("kjp." "像")
("klz;" "僑")
("kgky" "僱")
("ktsk" "僎")
("keu " "僩")
("f;ss" "兢")
("bqis" "凳")
("trpe" "劃")
("zide" "劂")
("q;dm" "匱")
("zpuh" "厭")
(";hoz" "嗾")
(";yk;" "嘀")
(";nvv" "嘛")
("cj;p" "嘗")
(";v;k" "嗽")
(";q;;" "嘔")
(";rz " "嘆")
("r;i;" "嘉")
(";p;w" "嘍")
(";alx" "嘎")
(";rh." "嗷")
(";rm " "嘖")
(";rlt" "嘟")
(";qp " "嘈")
(";bb." "嘐")
(";pff" "嗶")
("pzfh" "團")
("p;y;" "圖")
("yqqr" "塵")
("y;gr" "塾")
("ryps" "境")
("fpzr" "墓")
("rifr" "墊")
("qor " "塹")
("prbr" "墅")
("rz.." "塽")
("rgqh" "壽")
("pvmm" "夥")
("f/jm" "夢")
("mnak" "夤")
("zkyh" "奪")
("zq;;" "奩")
("wyk;" "嫡")
("wcjd" "嫦")
("wv;." "嫩")
("wq;;" "嫗")
("wa/c" "嫖")
("wpx " "嫘")
("wae," "嫣")
("ohdf" "孵")
("nfpz" "寞")
("nnud" "寧")
("nalj" "寡")
("nbb." "寥")
("nsfm" "實")
("nrkv" "寨")
("nxtb" "寢")
("nxa;" "寤")
("nmac" "察")
("caih" "對")
("bp;w" "屢")
("dqo " "嶄")
("dq;;" "嶇")
("jdyf" "幛")
(",.jd" "幣")
("fpzd" "幕")
("jdpx" "幗")
("jdpb" "幔")
("ny;t" "廓")
("nbb." "廖")
(",.f " "弊")
(",.tg" "彆")
("ypf." "彰")
(".zu." "徹")
(".tgn" "慇")
("zlpn" "愿")
("xuqn" "態")
("nntc" "慷")
("np/b" "慢")
("nsfm" "慣")
("nopb" "慟")
("nqo " "慚")
("nxx." "慘")
("nntf" "慵")
("rkyx" "截")
("o,. " "撇")
("oyk;" "摘")
("oyxf" "摔")
("ozu." "撤")
("ofpz" "摸")
("op;w" "摟")
("obbp" "摺")
("opqx" "摑")
("odky" "摧")
("nrko" "搴")
("onr," "摭")
("oxx." "摻")
("y;jb" "敲")
("fpff" "斡")
("hork" "旗")
("hozd" "旖")
("pdp." "暢")
("bqsa" "暨")
("pjpk" "暝")
("vykh" "榜")
("vnke" "榨")
("vnk;" "榕")
("vy;;" "槁")
(",,jv" "榮")
("vqm " "槓")
("vrjr" "構")
("vzlv" "榛")
("vjky" "榷")
("vpbb" "榻")
("vkyf" "榫")
("vohp" "榴")
("vox " "槐")
("vit;" "槍")
("v.fh" "榭")
("vlen" "槌")
("fpfv" "榦")
("lmsv" "槃")
("vmod" "榣")
("itck" "歉")
("qdqk" "歌")
("o/u " "氳")
("cypf" "漳")
("cnak" "演")
("cykx" "滾")
("cy.m" "漓")
("cyk;" "滴")
("choc" "漩")
("cirb" "漾")
("cfpz" "漠")
("crm " "漬")
("cbz " "漏")
("ca/c" "漂")
("crz " "漢")
("crjk" "滿")
("crjd" "滯")
("cvkc" "漆")
("cv;k" "漱")
("cqo " "漸")
("ctgx" "漲")
("cqn " "漣")
("cqp " "漕")
("cp/b" "漫")
("cpx " "漯")
("czu." "澈")
("c.zd" "漪")
("cg;s" "滬")
("cu, " "漁")
("cxx." "滲")
("ckdv" "滌")
("ceph" "滷")
(",nk;" "熔")
("qd;," "熙")
(",gbb" "煽")
("xuq," "熊")
(",ljn" "熄")
(",,j," "熒")
("akj." "爾")
("ofy;" "犒")
(",,jf" "犖")
(".yzh" "獄")
(".ypf" "獐")
("armd" "瑤")
("arcm" "瑣")
("arg," "瑪")
("arox" "瑰")
("arn;" "瑭")
("a/rh" "甄")
("qozc" "疑")
("heqa" "瘧")
("hpa." "瘍")
("hx " "瘋")
("hiue" "瘉")
("hjjz" "瘓")
("tdau" "盡")
("qdtu" "監")
("jfp " "瞄")
("jbaz" "睽")
("ejaj" "睿")
("jof " "睡")
("gixx" "磁")
("grsv" "碟")
("arlg" "碧")
("gdz," "碳")
("galm" "碩")
("gpls" "碣")
("yhem" "禎")
("yhqp" "福")
("yhm;" "禍")
("lvop" "種")
("lv.r" "稱")
("nkcr" "窪")
("nkm;" "窩")
("ypls" "竭")
("ydae" "端")
("lne " "管")
("lrak" "箕")
("laxx" "箋")
("lleb" "筵")
("ljf " "算")
("lora" "箝")
("lclp" "箔")
("l.td" "箏")
("lrlp" "箸")
("lpf;" "箇")
("llpf" "箄")
(",ykf" "粹")
(",nac" "粽")
(",ru " "精")
("xnac" "綻")
("xne " "綰")
("xnac" "綜")
("xepf" "綽")
("xrk." "綾")
("xwc " "綠")
("qdtx" "緊")
("xbbb" "綴")
("xjis" "網")
("xjid" "綱")
("xzqd" "綺")
("xjr;" "綢")
("xlpd" "綿")
("x.v " "綵")
("xijf" "綸")
("xky " "維")
("xrlp" "緒")
("xwp " "緇")
("x.jb" "綬")
("/ye " "罰")
("bbyf" "翠")
("eebb" "翡")
("bbky" "翟")
("eae " "聞")
("aebk" "聚")
("g.tf" "肇")
("nkfk" "腐")
("uykh" "膀")
("y;ju" "膏")
("uqjd" "膈")
("uqhh" "膊")
("utxn" "腿")
("hoou" "膂")
("zszx" "臧")
("r;jr" "臺")
("ozak" "與")
("af;c" "舔")
("ormq" "舞")
("lmgu" "艋")
("fnk;" "蓉")
("fy;;" "蒿")
("fnrd" "蓆")
("fyxp" "蓄")
("fja." "蒙")
("fcky" "蒞")
("fcqh" "蒲")
("faac" "蒜")
("frxu" "蓋")
("fgc," "蒸")
("fgfx" "蓀")
("fky;" "蓓")
("fox " "蒐")
("fit;" "蒼")
("fypx" "蓑")
("fkxb" "蓊")
("/nms" "蜿")
("nnl/" "蜜")
("/ru " "蜻")
("/gfu" "蜢")
("/vo " "蜥")
("/pl." "蜴")
("/oz;" "蜘")
("ib/ " "蝕")
("/izs" "蜷")
("/jr;" "蜩")
("cj;x" "裳")
("ykrc" "褂")
("eeyx" "裴")
("ypvx" "裹")
("ykpv" "裸")
("oajx" "製")
("yklf" "裨")
("ykrp" "褚")
("ykj;" "裯")
("ybjf" "誦")
("yrn " "誌")
("yat;" "語")
("yqkk" "誣")
("yjhn" "認")
("yafx" "誡")
("ooy " "誓")
("y;gz" "誤")
("yk;s" "說")
("yo; " "誥")
("yosz" "誨")
("ylvg" "誘")
("y.ar" "誑")
("ycu " "誚")
("yqh " "誧")
("y;j." "豪")
(".pr " "貍")
(".lps" "貌")
("nacm" "賓")
("mzax" "賑")
("miac" "賒")
("rcrc" "赫")
("rccu" "趙")
("rcpf" "趕")
("sbg;" "跼")
("qqh " "輔")
("qaes" "輒")
("qawq" "輕")
("qj;s" "輓")
("yfv;" "辣")
("r;ln" "遠")
("rjrn" "遘")
("gfln" "遜")
(";dan" "遣")
("mofn" "遙")
(".esn" "遞")
("pbbn" "遢")
("/cn " "遝")
("ohjn" "遛")
(";ypt" "鄙")
("ntjt" "鄘")
("rrt " "鄞")
("aprf" "酵")
("apx." "酸")
("apo;" "酷")
("apiv" "酴")
("iyk." "鉸")
("itx " "銀")
("ijq " "銅")
("im; " "銘")
("iov " "銖")
("i.; " "鉻")
("iir " "銓")
(".iad" "銜")
("inw " "銨")
("iif " "鉼")
("ios " "銑")
("eyxk" "閡")
("err " "閨")
("e/ " "閩")
("e.; " "閣")
("ekax" "閥")
("ei; " "閤")
("tclc" "隙")
("typf" "障")
("tmac" "際")
("eqky" "雌")
(".;ky" "雒")
("zale" "需")
("rfpa" "靼")
("rfjz" "鞅")
("ypj;" "韶")
("tbam" "頗")
("ibam" "領")
("yx " "颯")
("xx; " "颱")
("iby." "餃")
("ibif" "餅")
("ibae" "餌")
("ibl;" "餉")
("g,.." "駁")
("muys" "骯")
("musb" "骰")
("z.lq" "髦")
("oxhf" "魁")
("aaxx" "魂")
(";l, " "鳴")
("axl," "鳶")
("sal," "鳳")
("nvvx" "麼")
("ljpe" "鼻")
("ykde" "齊")
("kypn" "億")
("kirx" "儀")
("kb;f" "僻")
("kapa" "僵")
("ka/m" "價")
("kpfx" "儂")
("ki/p" "儈")
("ki;k" "儉")
("kcjp" "儅")
("kypv" "凜")
("ea.e" "劇")
("b;yj" "劈")
("ohje" "劉")
("i;;e" "劍")
("i/pe" "劊")
("bbbn" "勰")
("zfpm" "厲")
(";,,b" "嘮")
(";r;;" "嘻")
(";zkc" "嘹")
(";fpu" "嘲")
(";p, " "嘿")
(";eqj" "嘴")
(";faf" "嘩")
(";ewa" "噓")
(";vqi" "噎")
(";caz" "噗")
(";ffm" "噴")
(";rao" "嘶")
(";tde" "嘯")
(";xxx" "嘰")
("rbcf" "墀")
("rewa" "墟")
("rk/p" "增")
("rffm" "墳")
("ti.r" "墜")
("tzqr" "墮")
("ry;." "墩")
("rl,p" "墦")
("zalp" "奭")
("wr;;" "嬉")
("wev " "嫻")
("w;;f" "嬋")
("wor," "嫵")
("wlz;" "嬌")
("wrrs" "嬈")
("nzkc" "寮")
("nfjh" "寬")
("nl,p" "審")
("nol," "寫")
("bk/p" "層")
("b.o." "履")
("dbqi" "嶝")
("dijk" "嶔")
("jdyr" "幢")
("jdyx" "幟")
("jdlp" "幡")
("nbtb" "廢")
("nr;h" "廚")
("nfpu" "廟")
("nrao" "廝")
("nrpk" "廣")
("ncj." "廠")
("tg;f" "彈")
("py;." "影")
(".f/n" "德")
("olr." "徵")
("ygn." "慶")
("fftn" "慧")
("epn " "慮")
("qfzn" "慝")
("fpzc" "慕")
("alu." "憂")
("zean" "慼")
("baan" "慰")
(".kkn" "慫")
("kk;n" "慾")
("nypr" "憧")
("n,mq" "憐")
("ney." "憫")
("nk/p" "憎")
("npyc" "憬")
("n;;f" "憚")
("nffm" "憤")
("nky," "憔")
("nor," "憮")
("bbkx" "戮")
("nvvo" "摩")
("rifo" "摯")
("fpzo" "摹")
("oypr" "撞")
("ocaz" "撲")
("o,,b" "撈")
("ocjl" "撐")
("otsk" "撰")
("obtb" "撥")
("orrs" "撓")
("orao" "撕")
("ozkc" "撩")
("oru." "撒")
("opab" "撮")
("ol,p" "播")
("oor," "撫")
("omz," "撚")
("olqq" "撬")
("oiph" "撙")
("oa/f" "撢")
("oijk" "撳")
("ykj." "敵")
("qhh." "敷")
("p;d." "數")
("fpzp" "暮")
("qop " "暫")
("prkc" "暴")
("pqf;" "暱")
("virb" "樣")
("vypf" "樟")
("vy;t" "槨")
("vzo " "樁")
("vq;;" "樞")
("va/c" "標")
("vqp " "槽")
("vfpz" "模")
("vp;w" "樓")
("v..z" "樊")
("xmfv" "槳")
("lpxv" "樂")
("v.kc" "樅")
("vzex" "槭")
("vcjv" "樑")
("q;;k" "歐")
("rzjk" "歎")
("amo." "殤")
("y.sb" "毅")
("q;;b" "毆")
("xmfc" "漿")
("cypr" "潼")
("cbqi" "澄")
("cbtb" "潑")
("czkc" "潦")
("cfjx" "潔")
("crrs" "澆")
("ca/f" "潭")
("cqsp" "潛")
("cvvu" "潸")
("cfpu" "潮")
("cr;." "澎")
("cbgf" "潺")
("c;dm" "潰")
("cear" "潤")
("cep " "澗")
("cl,p" "潘")
("uizc" "滕")
("ctqh" "潯")
("ctsk" "潠")
("col," "潟")
("y;g," "熟")
("rh.," "熬")
("rkr," "熱")
("baa," "熨")
("dgqh" "牖")
("av.f" "犛")
("xmfh" "獎")
(".zik" "獗")
(",,jh" "瑩")
("aryf" "璋")
("arym" "璃")
("arrr" "瑾")
("ardy" "璀")
("xxax" "畿")
("hk,u" "瘠")
("hfi;" "瘩")
("h/u " "瘟")
("hohp" "瘤")
("hodb" "瘦")
("hit;" "瘡")
("hlmb" "瘢")
("lpdi" "皚")
("ldlb" "皺")
("lmsu" "盤")
("jnr;" "瞎")
("j,n " "瞇")
("jrxu" "瞌")
("jjpk" "瞑")
("jfuk" "瞋")
("girq" "磋")
("gykh" "磅")
("gjky" "確")
("ggg " "磊")
("gbrx" "碾")
("grxu" "磕")
("gg, " "碼")
("lmsg" "磐")
("lvy;" "稿")
("lvn." "稼")
("valb" "穀")
("lvzp" "稽")
("lvp." "稷")
("lv.o" "稻")
("nki," "窯")
("nk.g" "窮")
("liue" "箭")
("lvj " "箱")
("lqgs" "範")
("lzqx" "箴")
("lw. " "篆")
("lgjf" "篇")
("llpr" "篁")
("lof " "箠")
("lktz" "篌")
(",f;u" "糊")
("xykd" "締")
("xv/ " "練")
("xt;q" "緯")
("xax." "緻")
("xzqx" "緘")
("xale" "緬")
("x;ae" "緝")
("xgjf" "編")
("xw. " "緣")
("xlpc" "線")
("xosb" "緞")
("x.ab" "緩")
("xof " "綞")
("xrf " "緙")
("xjcl" "緲")
("xpac" "緹")
("/g, " "罵")
("/xuq" "罷")
("ifps" "羯")
("gjfb" "翩")
("fkpm" "耦")
("ucjr" "膛")
("ufpz" "膜")
("uvkc" "膝")
("ubb." "膠")
("epu " "膚")
("ua/c" "膘")
("fnr," "蔗")
("f,. " "蔽")
("fbah" "蔚")
("fqn " "蓮")
("fgeo" "蔬")
("ftix" "蔭")
("fp/b" "蔓")
("f/zx" "蔑")
("fxmh" "蔣")
("fmac" "蔡")
("flqp" "蔔")
("f.fn" "蓬")
("flpn" "蔥")
("fnkp" "蓿")
("fcr." "蔆")
("/hbt" "螂")
("/f;u" "蝴")
("/rsv" "蝶")
("/qp " "蝠")
("/etb" "蝦")
("/m; " "蝸")
("sf//" "蝨")
("/gjf" "蝙")
("/lpr" "蝗")
("/lvf" "蝌")
("/iue" "蝓")
(".t;d" "衛")
(".opd" "衝")
("ykps" "褐")
("yko." "複")
("yk;x" "褒")
("ykkv" "褓")
("ykie" "褕")
("ykgf" "褊")
("ynua" "誼")
("yy;c" "諒")
("y,, " "談")
("yy;f" "諄")
("yleb" "誕")
("yru " "請")
("yrlp" "諸")
("ypv " "課")
("ylvw" "諉")
("yjo " "諂")
("yjr;" "調")
("yky " "誰")
("yijf" "論")
("y.td" "諍")
("yykf" "誶")
("yee " "誹")
("yok " "諛")
("qins" "豌")
("qdti" "豎")
("a.rp" "豬")
("my; " "賠")
("cj;m" "賞")
("maax" "賦")
("maxx" "賤")
("mqx " "賬")
("mrlp" "賭")
("qdtm" "賢")
("r/m " "賣")
("mpl." "賜")
("oom " "質")
("ntkm" "賡")
("rcrp" "赭")
("rcc;" "趟")
("rcab" "趣")
("sica" "踫")
("saxx" "踐")
("spv " "踝")
("spl." "踢")
("scp " "踏")
("s.v " "踩")
("soz;" "踟")
("sizs" "踡")
("sbf;" "踞")
(".cj;" "躺")
("casq" "輝")
("qajk" "輛")
("qbbb" "輟")
("eeq " "輩")
("zzq " "輦")
("qijf" "輪")
("qwp " "輜")
("qjis" "輞")
("qpqq" "輥")
("ykjn" "適")
("nr,n" "遮")
("rh.n" "遨")
("qpn " "遭")
("a/zn" "遷")
(",mqt" "鄰")
("ipzt" "鄭")
("bqit" "鄧")
("l,pt" "鄱")
("apyf" "醇醉")
("aprp" "醋")
("apzs" "醃")
("iyf " "鋅")
("iktl" "銻")
("icu " "銷")
("iqh " "鋪")
("irlg" "銬")
("iuab" "鋤")
("i;l;" "鋁")
("ik;s" "銳")
("ikkr" "銼")
("i.f " "鋒")
("im " "鋇")
("ipr " "鋰")
("ipaf" "銲")
("e;l;" "閭")
("ek;s" "閱")
("zcu " "霄")
("zlrb" "霆")
("zzax" "震")
("zosz" "霉")
("o;ee" "靠")
("rfnw" "鞍")
("rfrr" "鞋")
("qshf" "鞏")
("r;am" "頡")
("s,am" "頫")
("i;am" "頜")
("xlf;" "颳")
("irix" "養")
("iblx" "餓")
("ib.w" "餒")
("ibiv" "餘")
("g,nq" "駝")
("g,yr" "駐")
("g,/ " "駟")
("g,;." "駛")
("wbg," "駑")
("b;g," "駕")
("g,l;" "駒")
("g,kh" "駙")
("muf;" "骷")
("z.zh" "髮")
("z.jr" "髯")
("eyjd" "鬧")
("oxav" "魅")
("lpox" "魄")
("u,zh" "魷")
("u,p " "魯")
("jsl," "鴆")
("qdl," "鴉")
("l,tk" "鴃")
("fkkz" "麩")
("nvvq" "麾")
("lvlc" "黎")
("p,r " "墨")
("ei " "齒")
("kzae" "儒")
("ktdu" "儘")
("krgh" "儔")
("knam" "儐")
("kyke" "儕")
("eqpk" "冀")
("jfpd" "冪")
("kqoc" "凝")
("ykde" "劑")
("ljpe" "劓")
("o/,b" "勳")
(";kym" "噙")
(";ypn" "噫")
(";cjp" "噹")
("q;fa" "噩")
(";vvc" "噤")
(";adm" "噸")
(";;;v" "噪")
(";;z;" "器")
(";pfx" "噥")
(";ea." "噱")
(";.j." "噯")
(";lqk" "噬")
(";ljz" "噢")
(";fps" "噶")
("b;yr" "壁")
(".txr" "墾")
("rypa" "壇")
("ysxr" "壅")
("zkyp" "奮")
("wlyx" "嬝")
("yuwh" "嬴")
("o..f" "學")
("n/qx" "寰")
("iljh" "導")
("tgaa" "彊")
("nr/n" "憲")
("kg,n" "憑")
("af;n" "憩")
("krln" "憊")
("nypv" "懍")
("nypn" "憶")
("nzqx" "憾")
("nljz" "懊")
("njjf" "懈")
(";;px" "戰")
("oypa" "擅")
("oysy" "擁")
("ocjp" "擋")
("orin" "撻")
("ozqx" "撼")
("oea." "據")
("oepb" "擄")
("o/rf" "擇")
("ozp " "擂")
("o;;v" "操")
("oi;k" "撿")
("okym" "擒")
("ojzy" "擔")
("om;n" "撾")
("v;.e" "整")
("zlvp" "曆")
("prrs" "曉")
("pkyn" "暹")
("pfaf" "曄")
("pzax" "曇")
("pzkc" "暸")
("viph" "樽")
("vcaz" "樸")
("vfaf" "樺")
("vbqi" "橙")
("vrpk" "橫")
("vbg;" "橘")
("vr;h" "樹")
("vqe." "橄")
("vtzu" "橢")
("vjp." "橡")
("vlz;" "橋")
("vlqq" "橇")
("vky," "樵")
("vxxx" "機")
("vrrs" "橈")
("i;bk" "歙")
("zlve" "歷")
("cj;q" "氅")
("cnic" "濂")
("cbrb" "澱")
("c;;v" "澡")
("cpfx" "濃")
("c/rf" "澤")
("c/l/" "濁")
("cpfi" "澧")
("cljz" "澳")
("clp." "激")
("cjzy" "澹")
("cypa" "澶")
("cbgm" "澦")
("cjaa" "澠")
("c/qx" "澴")
(",ypx" "熾")
(",y;." "燉")
(",,mq" "燐")
(",rrs" "燒")
(",bqi" "燈")
("req," "燕")
("r;i," "熹")
(",zkc" "燎")
("cpa," "燙")
(",en " "燜")
(",mz," "燃")
("jo,," "燄")
("./l/" "獨")
("arrk" "璜")
("arxx" "璣")
("ar,q" "璘")
("arpc" "璟")
("arcz" "璞")
("a/ak" "瓢")
("q;;h" "甌")
("f/jh" "甍")
("hypf" "瘴")
("hb;k" "瘸")
("hbz " "瘺")
("epu " "盧")
("ocu " "盥")
("jcjr" "瞠")
("jrjk" "瞞")
("ja/c" "瞟")
(",.j " "瞥")
("nvvg" "磨")
("gzfh" "磚")
("rbsg" "磬")
("grm " "磧")
(".oac" "禦")
("lvrm" "積")
("qlvm" "穎")
("lvl." "穆")
("u,lv" "穌")
("lvb." "穋")
("nkzs" "窺")
("ly;;" "篙")
("lypx" "簑")
("lqsv" "築")
("lg, " "篤")
("ltgk" "篛")
("ljzx" "篡")
("lled" "篩")
("llpq" "篦")
(",ir," "糕")
(",nt;" "糖")
("xiku" "縊")
("xitc" "縑")
(",,jx" "縈")
("xqhh" "縛")
("uacx" "縣")
("xy;;" "縞")
("xfuk" "縝")
("xaxp" "縉")
("xldd" "縐")
("/nky" "罹")
("irlx" "羲")
("fpfb" "翰")
("lpzb" "翱")
("qjib" "翮")
("fkzh" "耨")
("uir;" "膳")
("uaax" "膩")
("ur;." "膨")
("axrv" "臻")
("ojqk" "興")
("lmob" "艘")
("lmi;" "艙")
("fnnn" "蕊")
("fzn " "蕙")
("fa/f" "蕈")
("fzik" "蕨")
("fcp." "蕩")
("fl,p" "蕃")
("fky," "蕉")
("ftde" "蕭")
("for," "蕪")
("fpab" "蕞")
("/ykh" "螃")
("/jpk" "螟")
("/g, " "螞")
(",,j/" "螢")
("qji/" "融")
(".uzd" "衡")
("yktn" "褪")
("yknq" "褲")
("ykzh" "褥")
("yk.s" "褫")
("ykf;" "褡")
("yvjs" "親")
("iues" "覦")
("yykd" "諦")
("yn. " "諺")
("yv/ " "諫")
("yt;q" "諱")
("yrav" "謀")
("yrsv" "諜")
("yqqp" "諧")
("yaa;" "諮")
("yfz;" "諾")
("ypls" "謁")
("ypu " "謂")
("yx " "諷")
("yiue" "諭")
("yyp " "諳")
("yrqk" "諶")
("y.ab" "諼")
("bgd." "豫")
("a.eb" "豭")
(".fp " "貓")
("v;jm" "賴")
("sykd" "蹄")
("snrb" "踱")
("sbjb" "踴")
("sbgv" "蹂")
("sdae" "踹")
("sop " "踵")
("qqp " "輻")
("q;ae" "輯")
("qiue" "輸")
("qzaz" "輳")
("yfhf" "辨")
("yfbf" "辦")
("ipfn" "遵")
(",mqn" "遴")
("tstn" "選")
("bcon" "遲")
("zkpn" "遼")
(";dan" "遺")
("cait" "鄴")
("appr" "醒")
("inac" "錠")
("irlx" "錶")
("ibf;" "鋸")
("igfu" "錳")
("irp " "錯")
("iaxx" "錢")
("ijid" "鋼")
("ipl." "錫")
("iwc " "錄")
("i.td" "錚")
("iky " "錐")
("ilpd" "錦")
("izqd" "錡")
("ipqq" "錕")
("ipf;" "錮")
("iwp " "錙")
("ejo " "閻")
("ti.n" "隧")
("tzqn" "隨")
("ti;k" "險")
("jr;y" "雕")
("zyw " "霎")
("zce;" "霑")
("zvv " "霖")
("zky " "霍")
("zos " "霓")
("zee " "霏")
("runc" "靛")
("ru.d" "靜")
("alps" "靦")
("rfcu" "鞘")
("zkkm" "頰")
("awqm" "頸")
("ecam" "頻")
("ig;m" "頷")
("qiam" "頭")
("lvsm" "頹")
("qd;m" "頤")
("embx" "餐")
("ibne" "館")
("ibax" "餞")
("ibpq" "餛")
("ibjo" "餡")
("ib.u" "餚")
("g,yk" "駭")
("g,if" "駢")
("g,.;" "駱")
("muyk" "骸")
("mu.;" "骼")
("z.r;" "髻")
("z.eq" "髭")
("erk " "鬨")
("u,ls" "鮑")
("l,nq" "鴕")
("f;l," "鴣")
("jzl," "鴦")
("pdl," "鴨")
("ibl," "鴒")
("mgs," "鴛")
("p,zh" "默")
("p,ig" "黔")
("yuq " "龍")
("jjaa" "龜")
("kal." "優")
("kcjm" "償")
("kppp" "儡")
("kyrp" "儲")
("zfpb" "勵")
(";y;." "嚎")
(";nnd" "嚀")
(";cjp" "嚐")
(";zae" "嚅")
(";rcc" "嚇")
(";fjc" "嚏")
("ry;." "壕")
("zpur" "壓")
("ejar" "壑")
("ro/," "壎")
("mmw " "嬰")
("wnam" "嬪")
("wnvx" "嬤")
("gfze" "孺")
("zsqu" "尷")
("b.pw" "屨")
("dozk" "嶼")
("dibm" "嶺")
("d.yh" "嶽")
("d,,v" "嶸")
("rrfd" "幫")
("tga." "彌")
("ox. " "徽")
("nkkn" "應")
("nfop" "懂")
(".txn" "懇")
("nzae" "懦")
("vbgn" "懋")
("eqix" "戲")
("rprx" "戴")
("fl;o" "擎")
("qdso" "擊")
("b;yo" "擘")
("oyke" "擠")
("onnd" "擰")
("onmc" "擦")
("oqoc" "擬")
("oe.;" "擱")
("obby" "擢")
("ofkb" "擭")
("i;;." "斂")
(",.aq" "斃")
("p/rp" "曙")
("p.j." "曖")
("vypa" "檀")
("vcjp" "檔")
("vlp." "檄")
("vi;k" "檢")
("vi/p" "檜")
("vlbj" "櫛")
("vfk;" "檣")
("v;;v" "橾")
("b;yv" "檗")
("vjzy" "檐")
("fl;v" "檠")
("/l/k" "歜")
("amik" "殮")
("j;qh" "毚")
("yp;q" "氈")
("cnnd" "濘")
("cnam" "濱")
("cyke" "濟")
("cy;." "濠")
("cfj." "濛")
("crgh" "濤")
("cqdu" "濫")
("cbby" "濯")
("cjhe" "澀")
("cejj" "濬")
("czae" "濡")
("cfkb" "濩")
("cpx," "濕")
("ckcz" "濮")
("cxky" "濰")
(",i.n" "燧")
(",,j;" "營")
("y,,b" "燮")
(",em," "燦")
(",;;v" "燥")
(",/l/" "燭")
(",orb" "燬")
(",i/p" "燴")
(",ljz" "燠")
("./bh" "爵")
("xfk;" "牆")
(".nnd" "獰")
(".fkb" "獲")
("are." "璩")
("ar/x" "環")
("ar.." "璦")
("are," "璨")
("h,,b" "癆")
("hzkc" "療")
("h;;d" "癌")
("cpau" "盪")
("jypr" "瞳")
("jbqi" "瞪")
("jqe." "瞰")
("j.jq" "瞬")
("jky," "瞧")
("jzkc" "瞭")
("ozl;" "矯")
("g,mq" "磷")
("grpk" "磺")
("gbqi" "磴")
("gxxx" "磯")
("gky," "礁")
("yhr;" "禧")
("yh;f" "禪")
("lvzn" "穗")
("nktr" "窿")
("lhoz" "簇")
("lp;w" "簍")
("l/zx" "篾")
("l.fn" "篷")
("lv;k" "簌")
("lkdv" "篠")
(",ntc" "糠")
("nvv," "糜")
(",prk" "糞")
(",fpz" "糢")
(",qp " "糟")
(",o;n" "糙")
(",xx." "糝")
("xnkp" "縮")
("xrm " "績")
("xbb." "繆")
("xp;w" "縷")
("xpx " "縲")
("xduu" "繃")
("x.fn" "縫")
("xlpn" "總")
("x.kc" "縱")
("xwpv" "繅")
("oszx" "繁")
("xyxf" "縴")
("xa/c" "縹")
("xtg/" "繈")
("xp/b" "縵")
("xxx." "縿")
("xnak" "縯")
("rbsd" "罄")
("qozb" "翳")
("bbpk" "翼")
("rh.e" "聱")
("rbse" "聲")
("aeln" "聰")
("aexw" "聯")
(".kke" "聳")
("uypn" "臆")
("uysy" "臃")
("nkku" "膺")
("b;yu" "臂")
("brku" "臀")
("upfx" "膿")
("ujzy" "膽")
("ui;k" "臉")
("ui/p" "膾")
("qdt;" "臨")
("ozaf" "舉")
("rztx" "艱")
("fyvo" "薪")
("fcqh" "薄")
("fzp " "蕾")
("fb;f" "薜")
("fapa" "薑")
("ffk;" "薔")
("f/rp" "薯")
("flef" "薛")
("fos." "薇")
("f/jq" "薨")
("fu,e" "薊")
("ekyg" "虧")
("/yxf" "蟀")
("/ypf" "蟑")
("/cjr" "螳")
("/fzf" "蟒")
("/fpz" "蟆")
("rc./" "螫")
("/p;w" "螻")
("/px " "螺")
("/pqx" "蟈")
("/l,n" "蟋")
("yrkx" "褻")
("ykbp" "褶")
("y;;x" "襄")
("ykpw" "褸")
("baax" "褽")
("dqis" "覬")
("y,n " "謎")
("yykh" "謗")
("yitc" "謙")
("yrjr" "講")
("yfyo" "謊")
("ymod" "謠")
("y.fh" "謝")
("uizy" "謄")
("ynlu" "謐")
("nr;;" "豁")
(".xz;" "谿")
("a.dd" "豳")
("mitc" "賺")
("nrkm" "賽")
("mrjr" "購")
("uizm" "賸")
("mqhh" "賻")
("rcld" "趨")
("sirq" "蹉")
("spbb" "蹋")
("s.o " "蹈")
("s.xz" "蹊")
("qnr;" "轄")
("qbrx" "輾")
("vaqb" "轂")
("qr;x" "轅")
("oqak" "輿")
("b;yn" "避")
("ea.n" "遽")
("/qln" "還")
("fpmn" "邁")
("jjon" "邂")
("lphn" "邀")
("aebt" "鄹")
("apn;" "醣")
("ap/u" "醞")
("apox" "醜")
("inrb" "鍍")
("iirz" "鎂")
("ifp " "錨")
("itfb" "鍵")
("iv/ " "鍊")
("ifjz" "鍥")
("im; " "鍋")
("iof " "錘")
("iop " "鍾")
("ilv," "鍬")
("iosb" "鍛")
("i.ab" "鍰")
("ipa." "鍚")
("i;;g" "鍔")
("ecl;" "闊")
("ebaz" "闋")
("ev/ " "闌")
("et;q" "闈")
("e;;;" "闆")
("t.qn" "隱")
("vaac" "隸")
(";/ky" "雖")
("zvj " "霜")
("zetb" "霞")
("rfl," "鞠")
("fpfq" "韓")
("pvam" "顆")
("xuak" "颶")
("ibpx" "餵")
("g,pg" "騁")
("g,x." "駿")
("u,if" "鮮")
("u,y." "鮫")
("u,zu" "鮪")
("u,rr" "鮭")
("cql," "鴻")
("i;l," "鴿")
("yqq," "麋")
("lvk;" "黏")
("p,e;" "點")
("p,dd" "黜")
("p,xb" "黝")
("kax," "黛")
("ljpf" "鼾")
("ykdc" "齋")
("caib" "叢")
(";u,p" "嚕")
("sxh;" "嚮")
("rnrk" "壙")
("pppr" "壘")
("wnlp" "嬸")
("t,xf" "彝")
("crjn" "懣")
("bbkx" "戳")
("onrk" "擴")
("oipt" "擲")
("oal." "擾")
("ozzq" "攆")
("o/xq" "擺")
("op;." "擻")
("or;m" "擷")
("xxao" "斷")
("pbby" "曜")
("ufj." "朦")
("vnam" "檳")
("vfj." "檬")
("vq;m" "櫃")
("vqdu" "檻")
("vnnd" "檸")
("vbby" "櫂")
("vrgh" "檮")
("vr;r" "檯")
("ozak" "歟")
("leed" "歸")
("amnm" "殯")
("cno," "瀉")
("cnlp" "瀋")
("cepn" "濾")
("cr/m" "瀆")
("cmax" "濺")
("cprc" "瀑")
("cohe" "瀏")
(",o/," "燻")
(",tdu" "燼")
("rgq," "燾")
(",zae" "燸")
(".nrk" "獷")
(".w/w" "獵")
("b;yh" "璧")
("arej" "璿")
("ysxh" "甕")
("hb;f" "癖")
("hfpm" "癘")
("hiun" "癒")
("r;ij" "瞽")
("jjky" "瞿")
("jjzy" "瞻")
("ji;k" "瞼")
("gvvc" "礎")
("yhpi" "禮")
("lvf;" "穡")
("lvex" "穢")
("lvpx" "穠")
("nkow" "竄")
("nkl." "竅")
("ltde" "簫")
("lrpk" "簧")
("lqsp" "簪")
("l;;f" "簞")
("l;dm" "簣")
("lep " "簡")
(",par" "糧")
("xypx" "織")
("xir;" "繕")
("xrrs" "繞")
("xzkc" "繚")
("xtde" "繡")
("xk/p" "繒")
("xl,p" "繙")
("ofdf" "罈")
("rrrb" "翹")
("l,pb" "翻")
("aeyx" "職")
("aeae" "聶")
("uyke" "臍")
("unam" "臏")
("fkyo" "舊")
("fzsx" "藏")
("ftnr" "薩")
("fqdu" "藍")
("f.ls" "藐")
("ffkp" "藉")
("fo/," "薰")
("fyke" "薺")
("fr;r" "薹")
("fya," "薦")
("/rrs" "蟯")
("/;;f" "蟬")
("/// " "蟲")
("/l,p" "蟠")
("a/.." "覆")
("rrjs" "覲")
("jop." "觴")
("yfpz" "謨")
("yrr " "謹")
("ybb." "謬")
("yyk;" "謫")
("fdfi" "豐")
("rh.m" "贅")
("zeac" "蹙")
("srjk" "蹣")
("sduu" "蹦")
("s.kc" "蹤")
("srm " "蹟")
("spff" "蹕")
(".q;;" "軀")
("qzfh" "轉")
("qzu." "轍")
("akjn" "邇")
("nkin" "邃")
(".lpn" "邈")
("qozp" "醫")
("xmfp" "醬")
("av.r" "釐")
("ink;" "鎔")
("iykh" "鎊")
("icm " "鎖")
("il, " "鎢")
("iljv" "鎳")
("ifuk" "鎮")
("iy;;" "鎬")
("iiku" "鎰")
("iqjd" "鎘")
("ilen" "鎚")
("iit;" "鎗")
("erxu" "闔")
("eg, " "闖")
("efuk" "闐")
("eidk" "闕")
("y.dy" "離")
("ykky" "雜")
("kykb" "雙")
("ldly" "雛")
(".xzy" "雞")
("zohp" "霤")
("rfbv" "鞣")
("rfl," "鞦")
("rfk." "鞭")
("yplr" "韹")
("n.;m" "額")
("n.am" "顏")
("pacm" "題")
(";;am" "顎")
("dalm" "顓")
("xpa." "颺")
("ibop" "餾")
("ibob" "餿")
("ibox" "餽")
("amkx" "餮")
("lvp." "馥")
("g,zd" "騎")
("mupv" "髁")
("z.nc" "鬃")
("z.vx" "鬆")
("lvwx" "魏")
("oxak" "魎")
("oxjs" "魍")
("ccl," "鯊")
("u,pr" "鯉")
("u,bj" "鯽")
("kd.," "鯈")
("u,lx" "鯀")
(";ul," "鵑")
("lox," "鵝")
("o;l," "鵠")
("p,r;" "黠")
("r;ih" "鼕")
("owpf" "鼬")
("kj;h" "儳")
(";re," "嚥")
("ry/x" "壞")
("yuqr" "壟")
("rzle" "壢")
("nyuq" "寵龐")
("nepu" "廬")
("olrn" "懲")
("ny/x" "懷")
("nv;m" "懶")
("nf/j" "懵")
("v..o" "攀")
("oyuq" "攏")
("pnrk" "曠")
("pprc" "曝")
("vnrh" "櫥")
("vr/m" "櫝")
("ve;;" "櫚")
("vu,p" "櫓")
("cyuh" "瀛")
("cfte" "瀟")
("cv;m" "瀨")
("cfpb" "瀚")
("czle" "瀝")
("cecm" "瀕")
("cepu" "瀘")
(",prc" "爆")
(",lpv" "爍")
("dr/m" "牘")
("ofrm" "犢")
(";;ph" "獸")
(".v;m" "獺")
("akjh" "璽")
("arj." "瓊")
("yf.f" "瓣")
("prgh" "疇")
("tgra" "疆")
("hljf" "癟")
("hqoc" "癡")
("jfj." "矇")
("gqoc" "礙")
("yhrh" "禱")
("lvfb" "穫")
("lv.n" "穩")
("lnic" "簾")
("lcqh" "簿")
("lrab" "簸")
("li;k" "簽")
("ljzy" "簷")
("loop" "籀")
("qdsx" "繫")
("fjd/" "繭")
("x/rf" "繹")
("xjaa" "繩")
("xi/p" "繪")
("/xky" "羅")
("xlp." "繳")
("ifya" "羶")
("ir,z" "羹")
("yuih" "羸")
("uw/w" "臘")
("fclp" "藩")
("frkx" "藝")
("fp;." "藪")
("ffkm" "藕")
("fuic" "藤")
("flpv" "藥")
("fyrp" "藷")
("/irx" "蟻")
("/jaa" "蠅")
("/plk" "蠍")
("jjo/" "蟹")
("/jzy" "蟾")
("ykcp" "襠")
("ykvc" "襟")
("yklz" "襖")
("b;yx" "襞")
("yfaf" "譁")
("yicp" "譜")
("yypx" "識")
("ybqi" "證")
("ya/f" "譚")
("ybg;" "譎")
("yxxx" "譏")
("yr;;" "譆")
("yky," "譙")
("mk/p" "贈")
("osom" "贊")
("scaz" "蹼")
("siph" "蹲")
("sfrp" "躇")
("szik" "蹶")
("sbqi" "蹬")
("srrs" "蹺")
("sy;h" "蹴")
("q,mq" "轔")
("qlz;" "轎")
(".bmf" "辭")
("ljnn" "邊")
("w/wn" "邋")
("apbb" "醱")
("apk," "醮")
("iyps" "鏡")
("iyk;" "鏑")
("inor" "鏟")
("ihoz" "鏃")
("iqn " "鏈")
("icjr" "鏜")
("ip/b" "鏝")
("yqqi" "鏖")
("ia/c" "鏢")
("ipx " "鏍")
("ixmh" "鏘")
("ip;w" "鏤")
("iqdr" "鏗")
("qoi " "鏨")
("exxw" "關")
("tyuq" "隴")
("rzky" "難")
("zc.r" "霪")
("zbgb" "霧")
("nvve" "靡")
("t;qo" "韜")
("yp;m" "韻")
(",zhm" "類")
("zlpm" "願")
("fuam" "顛")
("xodb" "颼")
("ibpb" "饅")
("ibrr" "饉")
("bgd," "騖")
("g,gf" "騙")
("z.fu" "鬍")
("u,yc" "鯨")
("u,pp" "鯧")
("u,ru" "鯖")
("u,j;" "鯛")
("y;g," "鶉")
("aae," "鵡")
("rpl," "鵲")
("zps," "鵪")
("uul," "鵬")
("yqqk" "麒")
("ajhq" "麗")
("vvyq" "麓")
("fkk," "麴")
("f;;b" "勸")
(";yuq" "嚨")
(";y;x" "嚷")
(";mmw" "嚶")
(";;z." "嚴")
(";./h" "嚼")
("ry;x" "壤")
("wzvj" "孀")
("wy;x" "孃")
("flef" "孽")
("narm" "寶")
("dj;h" "巉")
("uacn" "懸")
("nkkx" "懺")
("oy;x" "攘")
("oev/" "攔")
("oj;h" "攙")
("pirx" "曦")
("uyuq" "朧")
("vyvs" "櫬")
("cev/" "瀾")
("ctg." "瀰")
("ci;." "瀲")
(",epu" "爐")
("eqjh" "獻")
("aryq" "瓏")
("hirx" "癢")
("hol." "癥")
("gnrk" "礦")
("gzfm" "礪")
("v..g" "礬")
("glpv" "礫")
("nkrm" "竇")
("y;ss" "競")
("lrgh" "籌")
("lqdu" "籃")
("lfkp" "籍")
(",zae" "糯")
(",pzh" "糰")
("yfxf" "辮")
("xnam" "繽")
("xxxs" "繼")
("ljzx" "纂")
("mmod" "罌")
("casy" "耀")
("uepu" "臚")
("lmqu" "艦")
("fc;v" "藻")
("fyps" "藹")
("fnvg" "蘑")
("feky" "藺")
("fepu" "蘆")
("fecm" "蘋")
("fu,v" "蘇")
("fx/u" "蘊")
("/y;." "蠔")
("/zae" "蠕")
("ykqu" "襤")
("o..s" "覺")
("j/l/" "觸")
("yirx" "議")
("b;yy" "譬")
("fl;y" "警")
("y/rf" "譯")
("y;;v" "譟")
("yjzy" "譫")
("yumh" "贏")
("mjzy" "贍")
("fpmc" "躉")
("s;;v" "躁")
("s/l/" "躅")
("srin" "躂")
("appi" "醴")
("l,/f" "釋")
("iypr" "鐘")
("irrs" "鐃")
("itde" "鏽")
("e;;f" "闡")
("zru." "霰")
("a/ax" "飄")
("ibrs" "饒")
("ibxx" "饑")
("rbsp" "馨")
("nrk," "騫")
("uiz," "騰")
("g,b/" "騷")
("g,zc" "騵")
("u,pn" "鰓")
("u,l," "鰍")
("ep.x" "鹹")
("fkke" "麵")
("cj;," "黨")
("owa;" "鼯")
("eiua" "齟")
("eil;" "齣")
("eiib" "齡")
("kajq" "儷")
("k/xy" "儸")
(";aee" "囁")
(";qzh" "囀")
(";;a;" "囂")
("ilj." "夔")
("bc//" "屬")
("dlvx" "巍")
("njjy" "懼")
("naee" "懾")
("oaee" "攝")
("odk;" "攜")
("y.e/" "斕")
("py;x" "曩")
("vmmw" "櫻")
("vev/" "欄")
("vz;;" "櫺")
("amkx" "殲")
("cf;y" "灌")
(",ev/" "爛")
("ofix" "犧")
("aryx" "瓖")
("armw" "瓔")
("hv;m" "癩")
("jyuq" "矓")
("luic" "籐")
("xnpr" "纏")
("xr/m" "續")
("biff" "羼")
("fb;v" "蘗")
("fev/" "蘭")
("fu,f" "蘚")
("/zfm" "蠣")
("zp//" "蠢")
("w.//" "蠡")
("/w/w" "蠟")
("ykfx" "襪")
("yk/q" "襬")
("qdts" "覽")
("y;dn" "譴")
("yfkb" "護")
("ozay" "譽")
("mzsx" "贓")
("srgh" "躊")
("sbby" "躍")
("syke" "躋")
("qqq " "轟")
("yfyf" "辯")
("apo," "醺")
("inic" "鐮")
("izp " "鐳")
("ir;x" "鐵")
("icjp" "鐺")
("i/rf" "鐸")
("i/l/" "鐲")
("ikyd" "鐫")
("eb;f" "闢")
("zrfu" "霸")
("zb;f" "霹")
("zs.;" "露")
("sxhp" "響")
("gkym" "顧")
("py;m" "顥")
("sxhx" "饗")
("g,q;" "驅")
("g,ac" "驃")
("fpz," "驀")
("g,px" "騾")
("mupw" "髏")
("nvvx" "魔")
("oxym" "魑")
("u,rp" "鰭")
("u,/c" "鰥")
(",,j," "鶯")
("jky," "鶴")
("mof," "鷂")
("tgk," "鶸")
("yqqh" "麝")
("p,yp" "黯")
("r;if" "鼙")
("eieq" "齜")
("eitx" "齦")
("fjei" "齧")
("k;;." "儼")
("kcj," "儻")
(";frx" "囈")
("qdjx" "囊")
(";/xy" "囉")
("yxxf" "孿")
("dfum" "巔")
("yxxd" "巒")
("yxxg" "彎")
("vqin" "懿")
("orzy" "攤")
("vf;y" "權")
("f;;k" "歡")
("cajq" "灑")
("crzy" "灘")
("./xy" "玀")
("y;;k" "瓤")
("pppa" "疊")
("ht.n" "癮")
("hu,f" "癬")
("yhyx" "禳")
("lyuq" "籠")
("lv;m" "籟")
("yuqe" "聾")
("aeln" "聽")
("ufzx" "臟")
("yuqx" "襲")
("ykys" "襯")
("jjj." "觼")
("yr/m" "讀")
("mr/m" "贖")
("zklm" "贗")
("sipt" "躑")
("soom" "躓")
("qxx;" "轡")
("ajht" "酈")
("irgh" "鑄")
("iqdu" "鑑")
("qdti" "鑒")
("zyke" "霽")
("z.pr" "霾")
("rfrn" "韃")
("rfaa" "韁")
("yp;m" "顫")
(";agx" "饕")
("g,l;" "驕")
("g,rs" "驍")
("muff" "髒")
("z..m" "鬚")
(",.u," "鱉")
("u,qn" "鰱")
("u,ac" "鰾")
("u,pb" "鰻")
("nr,," "鷓")
("q;;," "鷗")
("owqw" "鼴")
("eia;" "齬")
("ei;c" "齪")
("yuqk" "龔")
(";fuv" "囌")
("d;;." "巖")
("yxxn" "戀")
("yxxo" "攣")
("ojjb" "攫")
("oo.s" "攪")
("pajq" "曬")
("vajq" "欐")
("arom" "瓚")
("nklm" "竊")
("lkkx" "籤")
("lev/" "籣")
("li;f" "籥")
("xmmw" "纓")
("xkkx" "纖")
("xj;h" "纔")
("uosm" "臢")
("fap," "蘸")
("f/xy" "蘿")
("///u" "蠱")
("yxx." "變")
("ajhn" "邐")
("/xkn" "邏")
("iyq," "鑣")
("ilpv" "鑠")
("iprc" "鑤")
("zpue" "靨")
("pxxm" "顯")
("zpux" "饜")
("fl;," "驚")
("g,/f" "驛")
("g,ik" "驗")
("muzn" "髓")
("mupi" "體")
("mu//" "髑")
("u,i;" "鱔")
("u,,q" "鱗")
("u,zk" "鱖")
("xxl," "鷥")
("yqqq" "麟")
("op,." "黴")
(";bc/" "囑")
("rzru" "壩")
("oqds" "攬")
("czru" "灞")
("hrzy" "癱")
("hfum" "癲")
("fuaa" "矗")
("ofdy" "罐")
("/rf," "羈")
("qsq/" "蠶")
("qdj/" "蠹")
(".jjd" "衢")
("yy;x" "讓")
("yj;h" "讒")
("ykkx" "讖")
("fdfs" "艷")
("ypfm" "贛")
("apyx" "釀")
("iepu" "鑪")
("zzle" "靂")
("z;;k" "靈")
("zyps" "靄")
("rfan" "韆")
("ecaf" "顰")
("g,ak" "驟")
("z.nm" "鬢")
("zpux" "魘")
("o..," "鱟")
("nkk," "鷹")
("s.;," "鷺")
("ep.k" "鹼")
("qdtu" "鹽")
("rh.a" "鼇")
("eibr" "齷")
("eilm" "齲")
("naen" "廳")
("vqds" "欖")
("cyxg" "灣")
("ly.y" "籬")
("l/xy" "籮")
("yxx/" "蠻")
("f;;s" "觀")
("saee" "躡")
("ojaj" "釁")
("iy;x" "鑲")
("ii;f" "鑰")
("epum" "顱")
("ibjh" "饞")
("munh" "髖")
("z.ww" "鬣")
("o..k" "黌")
("cyxv" "灤")
("jbc/" "矚")
("yosm" "讚")
("iaee" "鑷")
("rff," "韉")
("g,eu" "驢")
("g,ek" "驥")
("xqds" "纜")
("ycj," "讜")
("sfey" "躪")
("ap;." "釅")
("iosm" "鑽")
("yxxi" "鑾")
("i/xy" "鑼")
("u,qa" "鱷")
("u,eu" "鱸")
("p,rm" "黷")
("fdfu" "豔")
("caii" "鑿")
("mmw," "鸚")
("oja," "爨")
("g,aq" "驪")
("vof." "鬱")
("f;;," "鸛")
("yxx," "鸞")
("li;m" "籲")
("...." "乂")
("gs " "乜")
("dddd" "凵")
("qqqq" "匚")
("zzzz" "厂")
("al " "万")
("ae " "丌")
("lq " "乇")
("aad " "亍")
("pppp" "囗")
("as " "兀")
("dddd" "屮")
("...." "彳")
("adsg" "丏")
("zj " "冇")
("aga " "与")
("sf " "丮")
("aae " "亓")
("kb " "仂")
("ks " "仉")
("kk " "仈")
("js " "冘")
("lls " "勼")
("oj " "卬")
("lsx " "厹")
("rs " "圠")
("lgb " "夃")
("tk " "夬")
("ck " "尐")
("ajd " "巿")
("qs " "旡")
("sb " "殳")
("sf " "毌")
("oooo" "气")
("xxxx" "爿")
("wwww" "丱")
("fdh " "丼")
("kaaa" "仨")
("kq " "仜")
("kea " "仩")
("kos " "仡")
("kq " "仝")
("kd " "仚")
("fhe " "刌")
("qgds" "匜")
("fe " "卌")
("rad " "圢")
("br " "圣")
("mgs " "夗")
("zb " "夯")
("nad " "宁")
("nls " "宄")
("kc " "尒")
("bls " "尻")
("db " "屴")
("kd " "屳")
("jdad" "帄")
("nq " "庀")
("nk " "庂")
("nj " "忉")
("qx " "戉")
("ob " "扐")
("ol " "氕")
("gc " "氶")
("ck " "汃")
("cls " "氿")
("cb " "氻")
("zlh " "犮")
(".ls " "犰")
("arh " "玊")
("mmmm" "禸")
("us " "肊")
("tb " "阞")
("kfb " "伎")
("kzsh" "优")
("kbk " "伬")
("kof " "仵")
("kjs " "伔")
("kig " "仱")
("kkx " "伀")
("kke " "价")
("kn " "伈")
("kaax" "伝")
("kajd" "伂")
("kads" "伅")
("kqdl" "伢")
("kz " "伓")
("ktgd" "伄")
("ku " "仴")
("ko " "伒")
("kaw " "冱")
("aase" "刓")
("ose " "刉")
("jye " "刐")
("bbb " "劦")
("ql. " "匢")
("qys " "匟")
("faad" "卍")
("zqdl" "厊")
(";gf " "吇")
("pw " "囡")
("lp. " "囟")
("rts " "圮")
("ros " "圪")
("rlh " "圴")
("zed " "夼")
("tsw " "妀")
("wlq " "奼")
("wq " "妅")
("ww " "奻")
("wd " "奾")
("wlf " "奷")
("lshw" "奿")
("gfgf" "孖")
("lgc " "尕")
("zslh" "尥")
("das " "屼")
("dts " "屺")
("djh " "屻")
("dd " "屾")
("yso " "巟")
("afaf" "幵")
("nr " "庄")
("tsf " "异")
("ktgd" "弚")
(".lh " "彴")
("nz " "忕")
("nos " "忔")
("nlf " "忏")
("oaf " "扜扞")
("oas " "扤")
("ogds" "扡")
("olf " "扦")
("oos " "扢")
("ozk " "扙")
("obh " "扠")
("olh " "扚")
("olq " "扥")
("pls " "旯")
("lsp " "旮")
("vad " "朾")
("vls " "朹")
("vb " "朸")
("vsd " "朻")
("vs " "机")
("vj " "朿")
("vq " "朼")
("vk " "朳")
("oe " "氘")
("kc " "汆")
("cys " "汒")
("cts " "汜")
("cz " "汏")
("cbh " "汊")
("cos " "汔")
("clh " "汋")
("ced " "汌")
(",j " "灱")
("ofb " "牞")
(".af " "犴")
(".os " "犵")
("arad" "玎")
("ljf " "甪")
("lps " "癿")
("nks " "穵")
("j.. " "网")
("dd " "艸")
("fad " "艼")
("fj " "芀")
("fls " "艽")
("flg " "艿")
("eeee" "虍")
("ajea" "襾")
("yst " "邙")
("aft " "邗邘")
("qt " "邛")
("tst " "邔")
("tas " "阢")
("tgds" "阤")
("tsf " "阠")
("tos " "阣")
("knl " "佖")
("kai " "伻")
("kqt " "佢")
("krx " "佉")
("kva " "体")
("kqh " "佤")
("kza " "伾")
("keac" "佧")
("kjz " "佒")
("k.h " "佟")
("kx; " "佁")
("iac " "佘")
("kyx " "伭")
("krs " "伳")
("k;k " "伿")
("kkd " "佡")
("jk; " "冏")
("kz.h" "冹")
("tgee" "刜")
("uae " "刞")
("tsae" "刡")
("j;b " "劭")
("ozb " "劮")
("lai " "匉")
("ept " "卣")
("j;j " "卲")
("zoaa" "厎")
("zoe " "厏")
(";zx " "吰")
(";tk " "吷")
(";kq " "吪")
(";zh " "呔")
(";y. " "呅")
(";, " "吙")
(";gr " "吜")
(";z " "吥")
(";of " "吘吽")
(";lf " "呏")
(";laa" "呁")
(";ads" "吨")
(";ke " "吤")
("c; " "呇")
("pkq " "囮")
("pkj " "囧")
("pys " "囥")
("roas" "坁")
("rig " "坅")
("kjr " "坌")
("rads" "坉")
("rkj " "坋")
("qqr " "坒")
(".f " "夆")
("zz " "奀")
("wf " "妦")
("waax" "妘")
("wjk " "妠")
("wig " "妗")
("wke " "妎")
("wkj " "妢")
("wkx " "妐")
("wy. " "妏")
("waas" "妧")
("wo " "妡")
("nlz " "宎")
("nlq " "宒")
("zsh." "尨")
("zsar" "尪")
("daf " "岍")
("daas" "岏")
("dqdl" "岈")
("dlb " "岋")
("dl. " "岉")
("dig " "岒")
("tdsd" "岊")
("dlz " "岆")
("do " "岓")
("dke " "岕")
("awq " "巠")
("jdts" "帊")
("jdjs" "帎")
("nfb " "庋")
("nads" "庉")
("nqdl" "庌")
("nig " "庈")
("no " "庍")
("kjf " "弅")
("tgts" "弝")
(".kx " "彸")
(".lb " "彶")
("anx " "忒")
("acn " "忑")
("ean " "忐")
("nyc " "忭")
("naas" "忨")
("nfb " "忮")
("nads" "忳")
("n;d " "忡")
("nof " "忤")
("nlb " "忣")
("njk " "忺")
("noas" "忯")
("n.d " "忷")
("no " "忻")
("nz " "怀")
("nig " "忴")
("gts " "戺")
("oyc " "抃")
("ojs " "抌")
("oaax" "抎")
("oaas" "抏")
("oz " "抔")
("op " "抇")
("olb " "扱")
("ojk " "扻")
("ooas" "扺")
("ozsh" "扰")
("oxs " "抁")
("ou " "抈")
("olz " "扷")
("oads" "扽")
("oig " "扲")
("oke " "扴")
("ag. " "攷")
("paf " "旰旴")
("plh " "旳")
("pz " "旲")
("pd " "旵")
("vaf " "杅")
("vaag" "杇")
("vax " "杙")
("vz " "杕")
("vas " "杌")
("vbh " "杈")
("vgds" "杝")
("vgf " "杍")
("vos " "杚")
("vsh " "杋")
("rsf " "毐")
("od " "氙")
("oed " "氚")
("ch " "汸")
("caf " "汧")
("cfd " "汫")
("caax" "沄")
("czsh" "沋")
("cqj " "沏")
("czh " "汱")
("czx " "汯")
("cp " "汩")
("ce " "沚")
("cjk " "汭")
("cxs " "沇")
("cl. " "沕")
("cd " "沜")
("coas" "汦")
("czb " "汳")
("cfb " "汥")
("cof " "汻")
("ckq " "沎")
(",q " "灴")
(",gds" "灺")
("ofjh" "牣")
(".yc " "犿")
(".qdl" "犽")
(".gr " "狃")
(".;d " "狆")
(".xs " "狁")
(".ys " "犺")
(".lr " "狅")
("araf" "玕玗")
("arlh" "玓")
("ared" "玔")
("arq " "玒")
("pad " "町")
("pfag" "甹")
("had " "疔")
("hq " "疕")
("lpf " "皁")
("yhlg" "礽")
("aes " "耴")
("ujh " "肕")
(";u " "肙")
("uos " "肐")
("ulsh" "肒")
("u. " "肜")
("fac " "芐")
("fr " "芏")
("fax " "芅")
("ftg " "芎")
("fts " "芑")
("fgf " "芓")
("flf " "芊")
("fsh " "芃")
("flsh" "芄")
("...." "豸")
("bn " "迉")
("dn " "辿")
("yst " "邟")
("ht " "邡")
("jst " "邥")
("zt " "邞")
("aast" "邧")
("kjt " "邠")
("tqq " "阰")
("tzgs" "阨")
("te " "阯")
("txs " "阭")
(";;e " "丳")
("knlq" "侘")
("kyk." "佼")
("kyxk" "侅")
("kaak" "佽")
("kafe" "侀")
("kztg" "侇")
("kr; " "佶")
("kae " "佴")
("kzag" "侉")
("kaxr" "侄")
("ktx " "佷")
("keq " "佌")
("kjq " "侗")
("kp; " "佪")
("klp " "侚")
("kjzs" "佹")
("kos " "侁")
("klf;" "佸")
("klu " "侐")
("klm " "侜")
("kxof" "侔")
("kw; " "侞")
("knw " "侒")
("knlq" "侂")
("kale" "侕")
("k.; " "佫")
("ki; " "佮")
("j, " "冞")
("kos " "冼")
("ki; " "冾")
("aee " "刵")
("rre " "刲")
("zaae" "刳")
("hbe " "剆")
("fdjh" "刱")
("r;b " "劼")
("l, " "匊")
("lofd" "匋")
("qi; " "匼")
("zofd" "厒")
("zaxr" "厔")
(";nl " "咇")
(";rx " "呿")
(";ra " "咁")
(";oad" "咑")
(";qjd" "咂")
(";tge" "咈")
(";e; " "呫")
(";;ag" "呺")
(";pa " "呾")
(";jr " "呥")
(";/ " "呬")
(";l; " "呴")
(";xb " "呦")
(";x; " "咍")
(";ai " "呯")
(";tss" "呡")
(";va " "呠")
(";zjd" "咘")
(";sz " "呣")
(";oaa" "呧")
(";ib " "呤")
("plv " "囷")
("pib " "囹")
("rza " "坯")
("rtge" "坲")
("rbq " "坭")
("re; " "坫")
("rjz " "坱")
("rj; " "坰")
("rsz " "坶")
("rli " "垀")
("roa " "坵")
("roaa" "坻")
("rxb " "坳")
("rkr " "坴")
("ri " "坢")
("rnq " "坨")
("rib " "坽")
("rk. " "夌")
("zodj" "奅")
("wyr " "妵")
("wva " "妺")
("wra " "姏")
("wjz " "姎")
("wpa " "妲")
("wjr " "姌")
("wl; " "姁")
("wyx " "妶")
("wnl " "妼")
("wae " "姃")
("wqt " "姖")
("wj; " "妱")
("wpd " "妽")
("wlv " "姀")
("wib " "姈")
("mgsw" "妴")
("kfhw" "姇")
("gfls" "孢")
("wbgf" "孥")
("nnl " "宓")
("ng " "宕")
("bnk " "屄")
("bp " "屇")
("dnq " "岮")
("dnk " "岤")
("dqt " "岠")
("df; " "岵")
("dza " "岯")
("dua " "岨")
("dpd " "岬")
("djz " "岟")
("dl; " "岣")
("dib " "岭")
("dqd " "岢")
("dtge" "岪")
("dj; " "岧")
("doe " "岝")
("dtb " "岥")
("dlp " "岶")
("dxb " "岰")
("dy " "岦")
("jdzh" "帗")
("jdtb" "帔")
("jdoz" "帙")
("tgj;" "弨")
("tgdb" "弢")
("tgkh" "弣")
("tgoa" "弤")
("wc " "彔")
(".ua " "徂")
(".ib " "彾")
(".oaa" "彽")
("y.n " "忞")
("on " "忥")
("nnl " "怭")
("nai " "怦")
("nf; " "怙")
("najk" "怲")
("ntss" "怋")
("nqx " "怴")
("nj; " "怊")
("ne; " "怗")
("n;s " "怳")
("nua " "怚")
("npf " "怞")
("n/ " "怬")
("noz " "怢")
("noe " "怍")
("nl; " "怐")
("nxb " "怮")
("nwb " "怓")
("ni " "怑")
("nza " "怌")
("nlts" "怉")
("nib " "怜")
("axax" "戔")
("ghf " "戽")
("ons " "抭")
("ors " "抴")
("ora " "拑")
("orx " "抾")
("ozjd" "抪")
("ooz " "抶")
("okfh" "拊")
("ok. " "抮")
("obq " "抳")
("oua " "抯")
("opd " "抻")
("ojr " "抩")
("ojz " "抰")
("oln " "抸")
("kj. " "攽")
("xo " "斨")
("hos " "斻")
("ph " "昉")
("py. " "旼")
("pzb " "昄")
("pl. " "昒")
("pg " "昈")
("py. " "旻")
("pzk " "昃")
("lzp " "昋")
("pp " "昍")
("plb " "昅")
("pads" "旽")
("pig " "昑")
("pkj " "昐")
("l.p " "曶")
("uaas" "朊")
("vaf " "枅")
("vaas" "杬")
("vz " "枎")
("vqdl" "枒")
("vads" "杶")
("vgr " "杻")
("vjk " "枘")
("vlq " "枆")
("vlx " "构")
("vjk " "杴")
("vig " "枍")
("vkj " "枌")
("vn " "杺")
("vaax" "枟")
("vaw " "枑")
("vzgs" "枙")
("vlaa" "枃")
("vo " "杽")
("vlb " "极")
("vsb " "杸")
("vkq " "杹")
("vig " "枔")
("pjk " "欥")
("amlz" "殀")
("aml." "歾")
("qqlq" "毞")
("ojk " "氝")
("cp " "沓")
("cnk " "泬")
("cyx " "泫")
("ci " "泮")
("cai " "泙")
("caac" "沶")
("cra " "泔")
("cvh " "沭")
("cqx " "泧")
("cz.h" "沷")
("ctb " "泐")
("cj; " "泂")
("cp " "沺")
("cl; " "泃")
("coz " "泆")
("ckfh" "泭")
("clgl" "泲")
("c.xk" "泒")
("coh " "泝")
("ck. " "沴")
("jsc " "沊")
("cc " "沝")
("cbgd" "沀")
("cnad" "泞")
("cgq " "泀")
("cqt " "洰")
("cva " "泍")
("cb; " "泇")
("cg " "沰")
("cpa " "泹")
("cdd " "泏")
("cor " "泩")
("cxb " "泑")
(",tk " "炔")
(",o " "炘")
("p, " "炅")
(",hf " "炓")
(",y. " "炆")
(",gr " "炄")
(",v " "炑")
(",ads" "炖")
(",kx " "炂")
("p, " "炚")
("kj, " "炃")
("ofof" "牪")
(".nk " "狖")
(".aac" "狋")
(".qx " "狘")
(".za " "狉")
(".f; " "狜")
(".tge" "狒")
(".bq " "狔")
(".pa " "狚")
(".or " "狌")
(".ib " "狑")
("arf " "玤")
("arql" "玡")
("arqq" "玭")
("artk" "玦")
("arkj" "玢")
("arke" "玠")
("arjy" "玬")
("arof" "玝")
(".xkh" "瓝")
("qqh " "瓨")
("pys " "甿")
("pae " "畀")
("wp " "甾")
("atc " "疌")
("hq " "疘")
("tbaf" "皯")
("jys " "盳")
("jaf " "盱盰")
("jos " "盵")
("gaf " "矸")
("gq " "矼")
("gas " "矹")
("gos " "矻")
("glq " "矺")
("ggf " "矷")
("yhgs" "祂")
("yhlh" "礿")
("lvlq" "秅")
("nkm " "穸")
("nkaf" "穻")
("lb " "竻")
(",f " "籵")
("xad " "糽")
("aead" "耵")
("kjkk" "肏")
("uys " "肮")
("uig " "肣")
("ukf " "肸")
("uo " "肵")
("ujk " "肭")
("lmj " "舠")
("fy. " "芠")
("fys " "苀")
("faas" "芫")
("fads" "芚")
("fqq " "芘")
("ftl " "芛")
("ftk " "芵")
("fbgd" "芧")
("fjk " "芮")
("flq " "芼")
("fo " "芞")
("flz " "芺")
("fl. " "芴")
("flb " "芨")
("fjk " "芡")
("fig " "芩")
("f, " "苂")
("fgfs" "芤")
("fzb " "苃")
("flx " "芶")
("fkaa" "芢")
("/ad " "虰")
("/sd " "虯")
("/j " "虭")
("/s " "虮")
("a.h " "豖")
("ysn " "迒")
("arn " "迋")
("qdln" "迓")
("adsn" "迍")
("zhn " "迖")
("ofn " "迕")
("lzn " "迗")
("nlt " "邲")
("ajkt" "邴")
("rat " "邯")
("zat " "邳")
("x;t " "邰")
("trx " "阹")
("te; " "阽")
("toe " "阼")
("toaa" "阺")
("tajk" "陃")
("khtx" "俍")
("kf,h" "俅")
("kawq" "俓")
("kzax" "侲")
("kat;" "俉")
("k;ts" "俋")
("k;gz" "俁")
("kjs " "俔")
("kpfg" "俜")
("k.zd" "俙")
("kk;s" "侻")
("kkkr" "侳")
("kj;s" "俛")
("k.ar" "俇")
("kz; " "俖")
("kdig" "侺")
("k.w " "俀")
("klrb" "侹")
("klvx" "俬")
("awqe" "剄")
("kkre" "剉")
("f;sb" "勀")
("o;b " "勂")
("qpw " "匽")
("asjs" "卼")
("zyf " "厗")
("zzsh" "厖")
("zq " "厙")
("zpr " "厘")
(";apa" "咺")
(";ae " "咡")
(";r; " "咭")
(";axr" "咥")
(";tx " "哏")
(";jq " "哃")
("fl; " "茍")
(";s, " "咷")
(";ov " "咮")
(";oq " "哖")
(";lf;" "咶")
(";l.d" "哅")
(";mm " "哆")
(";ae " "咠")
("eq; " "呰")
("m; " "咼")
(";;ag" "咢")
(";rlq" "咾")
(";eq " "呲")
(";xof" "哞")
(";lp " "咰")
("rnw " "垵")
("rnlq" "垞")
("rif " "垟")
("raxr" "垤")
("rjq " "垌")
("rs, " "垗")
("rjzs" "垝")
("rsv " "垛")
("a/r " "垔")
("rkzh" "垘")
("rtf " "垏")
("rcas" "垙")
("ri; " "垥")
("rrr " "垚")
(".qr " "垕")
("r;i " "壴")
("op. " "复")
("zmm " "奓")
("wlf;" "姡")
("wr; " "姞")
("wapa" "姮")
("wafx" "娀")
("wzag" "姱")
("wov " "姝")
("wos " "姺")
("wjzs" "姽")
("wmm " "姼")
("wi; " "姶")
("w.q " "姤")
("wnw " "姲")
("wzu " "姷")
("wjq " "姛")
("woq " "姩")
("wm; " "姳")
("wsad" "姵")
("wlj;" "姠")
("wir " "姾")
("amew" "姴")
("bbbw" "姭")
("ns, " "宨")
("b;jd" "屌")
("dyxk" "峐")
("dapa" "峘")
("daxr" "峌")
("djzs" "峗")
("dlp " "峋")
("dame" "峛")
("djzs" "峞")
("dzr " "峚")
("d.; " "峉")
("di; " "峇")
("led " "峊")
("dnw " "峖")
("dztg" "峓")
("drlq" "峔")
("dale" "峏")
("d.; " "峈")
("di; " "峆")
("dtx " "峎")
("dzu " "峟")
("dzgx" "峸")
("gcas" "巹")
("jdif" "帡")
("jdi;" "帢")
("izjd" "帣")
("ojd " "帠")
("w;jd" "帤")
("nif " "庰")
("nrfh" "庤")
("naxr" "庢")
("neq " "庛")
("ns, " "庣")
("nkv " "庥")
("i;f " "弇")
("iztg" "弮")
("w. " "彖")
(".a/ " "徆")
("vhn " "怷")
("kgdn" "怹")
("nyk." "恔")
("nif " "恲")
("nztg" "恞")
("nrlq" "恅")
("na/ " "恓")
("nqar" "恇")
("nqp " "恉")
("np; " "恛")
("ns, " "恌")
("nmm " "恀")
("nlp " "恂")
("nl.d" "恟")
("kfhn" "怤")
("nr; " "恄")
("nkv " "恘")
("nlj;" "恦")
("nir " "恮")
("ge; " "扂")
("gj; " "扃")
("wbo " "拏")
("oyk." "挍")
("oqdd" "挋")
("ozdf" "拵")
("ozag" "挎")
("oaxr" "挃")
("otx " "拫")
("obbb" "拹")
("ojq " "挏")
("o.; " "挌")
("omm " "拸")
("owm " "拶")
("o.ok" "挀")
("onlq" "挓")
("oylx" "挔")
("ovj " "拺")
("oae " "挕")
("oz, " "拻")
("okar" "拰")
("e;eb" "敁")
("tsa." "敃")
("l;o " "斪")
("hogf" "斿")
("hbp " "昶")
("pyx " "昡")
("ptge" "昲")
("pbq " "昵")
("pal." "昜")
("pze " "昦")
("pdd " "昢")
("poz " "昳")
("pl; " "昫")
("pajk" "昺")
(".kp " "昝")
("podj" "昴")
("phb " "昹")
("pqb " "昮")
("udd " "朏")
("ul; " "朐")
("vnq " "柁")
("vnl " "柲")
("vi " "柈")
("vva " "枺")
("vqt " "柜")
("vrs " "枻")
("vza " "柸")
("vg " "柘")
("vtb " "柀")
("vb; " "枷")
("vbq " "柅")
("vtge" "柫")
("vua " "柤")
("vjr " "柟")
("v;ag" "枵")
("vjz " "柍")
("v;k " "枳")
("v;s " "柷")
("v/ " "柶")
("vdd " "柮")
("voz " "柣")
("vogs" "柂")
("vlts" "枹")
("vkfh" "柎")
("v.xk" "柧")
("vaac" "柰")
("x;v " "枲")
("vnk " "柼")
("vy " "柆")
("vz.h" "柭")
("vgq " "柌")
("ve; " "枮")
("vpa " "柦")
("vpd " "柛")
("v;l " "柺")
("vln " "柉")
("v.h " "柊")
("vib " "柃")
("vxb " "柪")
("kaxv" "柋")
("l;jk" "欨")
("amua" "殂")
("amk." "殄")
("yrsb" "殶")
("qqnl" "毖")
("pqq " "毘")
("b;lq" "毠")
("opd " "氠")
("o.h " "氡")
("cyk." "洨")
("cif " "洴")
("cqar" "洭")
("cztg" "洟")
("crr " "洼")
("czag" "洿")
("ca/ " "洒")
("czdf" "洊")
("ceq " "泚")
("cw; " "洳")
("cp; " "洄")
("cov " "洙")
("cm; " "洺")
("c.q " "洚")
("ckzh" "洑")
("clm " "洀")
("cnw " "洝")
("ciz " "浂")
("cr; " "洁")
("crlg" "洘")
("caxr" "洷")
("cz, " "洃")
("cale" "洏")
("cpf " "浀")
("cpz " "洇")
("cxof" "洠")
("csam" "洬")
("cjzs" "洈")
("cktl" "洢")
("c.q " "洉")
("c.ad" "洐")
(",yr " "炷")
(",pa " "炟")
(",;s " "炾")
("x;, " "炱")
("lts," "炰")
(",ae " "炡")
(",jz " "炴")
(",.h " "炵")
(",ib " "炩")
("xqd " "牁")
("di " "牉")
("dj; " "牊")
("ofll" "牬")
("ofpf" "牰")
("ofsz" "牳")
("kaxf" "牮")
("jzh " "狊")
(".r; " "狤")
(".afx" "狨")
(".rlq" "狫")
(".apa" "狟")
(".jq " "狪")
(".jfd" "狦")
(".s, " "狣")
("yxcl" "玅")
("arnl" "珌")
("arqd" "珂")
("arb;" "珈")
("arpd" "珅")
("aryx" "玹")
("arai" "玶")
("arra" "玵")
("arrs" "玴")
("arzs" "珫")
("arj;" "玿")
("arua" "珇")
("arpd" "玾")
("arjr" "珃")
("arx;" "珆")
("arls" "玸")
("aroj" "珋")
("hqh " "瓬")
("kxqh" "瓮")
("l.jf" "甮")
("plaa" "畇")
("pzb " "畈")
("hoas" "疧")
("hqq " "疪")
("bsb " "癹")
("tgdu" "盄")
("jjs " "眈")
("jaax" "眃")
("jadg" "眄")
("jzb " "眅")
("jlq " "眊")
("jlaa" "盷")
("jig " "盻")
("jo " "盺")
("oztd" "矧")
("ozlz" "矨")
("gz " "砆")
("gqdl" "砑")
("gqq " "砒")
("gc " "砅")
("glb " "砐")
("gkj " "砏")
("gke " "砎")
("fg " "砉")
("gjy " "砃")
("gsb " "砓")
("yhh " "祊")
("yh;d" "祌")
("yhsb" "祋")
("yhlz" "祅")
("yhke" "祄")
("lvqq" "秕")
("lv;d" "种")
("lvlq" "秏")
("lvos" "秖")
("lvkj" "秎")
("nkas" "窀")
("nklz" "穾")
("yzx " "竑")
("lys " "笀")
("lq " "笁")
(",os " "籺")
(",sf " "籸")
(",w " "籹")
(",fh " "籿")
(",zk " "粀")
(",lf " "粁")
("xed " "紃")
("xlsh" "紈")
("x.h " "紁")
("/z " "罘")
("irjk" "羑")
("zif " "羍")
("bbq " "羾")
("rll;" "耇")
("aljz" "耎")
("alj." "耏")
("fkgf" "耔")
("zae " "耷")
("uyx " "胘")
("utge" "胇")
("urx " "胠")
("u;k " "胑")
("uz.h" "胈")
("upd " "胂")
("udd " "胐")
("uoz " "胅")
("uogs" "胣")
("uoe " "胙")
("uor " "胜")
("ul; " "胊")
("ukfh" "胕")
("ulp " "胉")
("ulgl" "胏")
("uk. " "胗")
("ujz " "胦")
("u.xk" "胍")
("afo " "臿")
("lmq " "舡")
("ddd " "芔")
("fy " "苙")
("fnl " "苾")
("fai " "苹")
("fz.h" "茇")
("fbq " "苨")
("ftge" "茀")
("fj; " "苕")
("fzs " "茺")
("fe; " "苫")
("fpf " "苖")
("fua " "苴")
("fpk " "苬")
("fxk " "苡")
("foe " "苲")
("foz " "苵")
("fkr " "茌")
("fkfh" "苻")
("fkc " "苶")
("ftgx" "苰")
("fajk" "苪")
("fza " "苤")
("ftss" "苠")
("fsz " "苺")
("f.h " "苳")
("fxb " "苭")
("/af " "虷")
("/lq " "虴")
("/os " "虼")
("/lh " "虳")
("yslu" "衁")
(".afd" "衎")
("ykaf" "衧")
("ykgs" "衪")
("ykbh" "衩")
("jsd " "觓")
("lsy " "訄")
("ly " "訇")
("rcb " "赲")
("rsn " "迣")
("bqn " "迡")
("oen " "迮")
("e;n " "迠")
("ift " "郱")
("rrt " "邽")
("rfht" "邿")
("zgxt" "郕")
("axrt" "郅")
("ovt " "邾")
("lpt " "郇")
("ljt " "郋")
(".qt " "郈")
("is " "釔釓")
("tyxk" "陔")
("tzu " "陏")
("tale" "陑")
("tzag" "陓")
("tmm " "陊")
("tov " "陎")
("ky;c" "倞")
("kykf" "倅")
("knms" "倇")
("k,, " "倓")
("katc" "倢")
("krk." "倰")
("krak" "倛")
("krlx" "俵")
("kaxx" "俴")
("kqtd" "倳")
("kzac" "倷")
("kepf" "倬")
("keab" "俶")
("kuts" "俷")
("kuu " "倗")
("kjr;" "倜")
("kky " "倠")
("knac" "倧")
("kaax" "倵")
("kvkx" "倯")
("kpqq" "倱")
("kjrk" "倎")
("cj;s" "党")
("p;af" "冔")
("rjr " "冓")
("kru " "凊")
("katw" "凄")
("kpf;" "凅")
("k.td" "凈")
("ki " "凎")
(",,e " "剡")
("qtde" "剚")
("rpe " "剒")
("zqde" "剞")
("bbbe" "剟")
("eee " "剕")
("a.he" "剢")
("y;cb" "勍")
("lzps" "匎")
("zee " "厞")
(";ccl" "唦")
(";arf" "哢")
(";rc " "唗")
(";ap " "唒")
(";rc " "哧")
(";oo " "哳")
(";zsh" "哤")
(";tjb" "唚")
("b;qd" "哿")
(";m " "唄")
(";;ts" "唈")
(";;c " "哫")
(";kkr" "唑")
(";ig;" "唅")
(";fjf" "哱")
(";zkk" "唊")
(";paf" "哻")
(";.fh" "哷")
(";.w " "哸")
(";o; " "哠")
(";lve" "唎")
(";j " "唃")
(";iv " "唋")
("py " "圁")
("pa. " "圂")
("rhtx" "埌")
("bjr " "堲")
("r;lr" "埕")
("r.fh" "埒")
("r.gf" "垺")
("rj " "埆")
("cor " "垽")
(".sbr" "垼")
("rnas" "垸")
("ryf " "垶")
("rnbd" "垿")
("rbjf" "埇")
("rtjb" "埐")
("rft " "垹")
("rdig" "埁")
("kkr." "夎")
("rrsz" "奊")
("wawq" "娙")
("w;c " "娖")
("wxoz" "娭")
("wy " "娮")
("wv; " "娕")
("wzsh" "娏")
("wlrb" "娗")
("wjs " "娊")
("w.w " "娞")
("wlve" "娳")
("zwgf" "孬")
("nqdd" "宧")
("ntl;" "宭")
("nzgx" "宬")
("qhfh" "尃")
("byf " "屖")
("oabq" "屔")
("dqh " "峬")
("dat;" "峿")
("dtl;" "峮")
(".grd" "峱")
("dyf " "峷")
("dhtx" "崀")
("ivd " "峹")
("jdcu" "帩")
("jdks" "帨")
("nrlf" "庨")
("nap " "庮")
("nofb" "庪")
("nzsh" "庬")
("tgaq" "弳")
("tgcu" "弰")
("qax." "彧")
("fjn " "恝")
("rrn " "恚")
("aljn" "恧")
("karn" "恁")
("nhtx" "悢")
("nafx" "悈")
("nbjf" "悀")
("n;ts" "悒")
("n;u " "悁")
("npr " "悝")
("npv " "悃")
("n.zd" "悕")
("nxk." "悛")
("nj;s" "悗")
("niv " "悇")
("n;lr" "悜")
("no; " "悎")
("jqax" "戙")
("gylx" "扆")
("rko " "拲")
("w;o " "挐")
("onas" "捖")
("ofjf" "挬")
("of,h" "捄")
("objf" "捅")
("obg;" "挶")
("otl;" "捃")
("obj " "揤")
("o;ts" "挹")
("o.fh" "捋")
("o.gf" "捊")
("o.w " "挼")
("ok;s" "挩")
("oo; " "捁")
("oosz" "挴")
("oxk." "捘")
("oj " "捔")
("oq " "捙")
("oap." "挭")
("orc " "捇")
("oawq" "挳")
("opr " "捚")
("opak" "捑")
("ojs " "挸")
("oec " "捗")
("o.f " "捀")
("oiv " "捈")
("eacb" "敊")
("i;eb" "敆")
("hoad" "旆")
("hojy" "旃")
("holq" "旄")
("hoo " "旂")
("paxr" "晊")
("pzgx" "晟")
("pzag" "晇")
("plj;" "晑")
("ujkk" "朒")
("us, " "朓")
("vif " "栟")
("viz " "栚")
("vnw " "桉")
("vrlg" "栲")
("vrlq" "栳")
("vaqx" "栻")
("vztg" "桋")
("vqt " "桏")
("va/ " "栖")
("vrk " "栱")
("vvj " "栜")
("vame" "栵")
("vzdf" "栫")
("vale" "栭")
("vzu " "栯")
("vaxr" "桎")
("vcas" "桄")
("vojy" "栴")
("vlf;" "栝")
("vlp " "栒")
("fjv " "栔")
("vadd" "栦")
("vaak" "栨")
("vae " "栮")
("vzag" "桍")
("vqp " "栺")
("aajv" "栥")
("karv" "栠")
("yxkk" "欬")
("r;jk" "欯")
("pzjk" "欭")
("i;jk" "欱")
("hbjk" "欴")
("erfh" "歭")
("amtf" "肂")
("amlu" "殈")
("aelq" "毦")
("kxsq" "毤")
("lqos" "毨")
("bblq" "毣")
("lqa/" "毢")
("lqax" "毧")
("oa/ " "氥")
("cn;d" "浺")
("cnas" "浣")
("cnzx" "浤")
("cnof" "浶")
("cqdd" "洍")
("cfjf" "浡")
("ctl;" "涒")
("cblq" "浘")
("cqi " "浢")
("cap." "浭")
("cat;" "浯")
("cv; " "涑")
("crlf" "涍")
("czu " "淯")
("cm " "浿")
("cpaf" "涆")
("c;c " "浞")
("c;lr" "浧")
("c.zd" "浠")
("ck;s" "涗")
("clve" "浰")
("cj;s" "浼")
("ckd." "浟")
("civ " "涂")
("cxoz" "涘")
("fjc " "洯")
("cnv " "浨")
("cnzh" "涋")
("crc " "浾")
("cjs " "涀")
("cpfg" "涄")
("c;gz" "洖")
("cpv " "涃")
("cjk;" "浻")
("c.w " "浽")
("cjy." "浵")
("clox" "涐")
(",apa" "烜")
(",rr " "烓")
(",s, " "烑")
("gca," "烝")
("kv, " "烋")
("ofd," "缹")
(",nlq" "烢")
(",yxk" "烗")
(",aqx" "烒")
(",vc " "烞")
(",zu " "烠")
(",jq " "烔")
(",os " "烍")
(",lu " "烅")
(",.ad" "烆")
(",ir " "烇")
(",i; " "烚")
("afa," "烎")
(",rk " "烡")
("xif " "牂")
("ofnf" "牸")
("ofir" "牷")
("izof" "牶")
(".ccl" "猀")
(".y " "狺")
(".qqr" "狴")
(".oo " "狾")
("..zd" "狶")
(".iv " "狳")
(".xk." "狻")
(".lve" "猁")
("ary." "珓")
("arrk" "珙")
("arae" "珥")
("arcs" "珖")
("areq" "玼")
("ars," "珧")
("arlp" "珣")
("ar.d" "珩")
("arif" "珜")
("artf" "珒")
("arzu" "珛")
("arzf" "珔")
("arbb" "珝")
("arpz" "珚")
("aros" "珗")
("arlm" "珘")
("ari;" "珨")
(".xkz" "瓞")
(".xks" "瓟")
("ibqh" "瓴")
("x;qh" "瓵")
("oror" "甡")
("pk. " "畛畟")
("hyr " "疰")
("he; " "痁")
("h;k " "疻")
("hoe " "痄")
("hl; " "痀")
("htge" "疿")
("hrs " "疶")
("hln " "疺")
("lpib" "皊")
("lvu " "盉")
("jnad" "眝")
("jav " "眛")
("jae " "眐")
("jqx " "眓")
("jpd " "眒")
("joz " "眣")
("jxb " "眑")
("jk. " "眕")
("jx; " "眙")
("orj " "眚")
("mgsj" "眢")
("jj; " "眧")
("gnq " "砣")
("gy " "砬")
("gqd " "砢")
("gva " "砵")
("gch " "砯")
("ggs " "砨")
("wbg " "砮")
("gyr " "砫")
("garh" "砡")
("gtge" "砩")
("gg " "砳")
("gsz " "砪")
("gib " "砱")
("yhkh" "祔")
("yhrx" "祛")
("yhg " "祏")
("yhf;" "祜")
("yhzh" "祓")
("yhj;" "祒")
("yhoz" "祑")
("lvvh" "秫")
("lvqt" "秬")
("lvza" "秠")
("lvx;" "秮")
("lvll" "秭")
("lvoa" "秪")
("lvbq" "秜")
("lvpf" "秞")
("lvlv" "秝")
("nkln" "窆")
("nkak" "窉")
("nkj " "窅")
("nkdd" "窋")
("nkoj" "窌")
("nk.k" "窊")
("nkls" "窇")
("yl; " "竘")
("lys " "笐")
("laf " "笄")
("lqq " "笓")
("l.. " "笅")
("ll. " "笏")
("llb " "笈")
("l.dk" "笊")
("laas" "笎")
("llaa" "笉")
("lig " "笒")
(",zb " "粄")
(",tds" "粑")
("qq, " "粊")
(",tgd" "粌")
(",gr " "粈")
(",lq " "粍")
(",l. " "粅")
("xjs " "紞")
("xar " "紝")
("xz " "紑")
("xzh " "紎")
("xzx " "紘")
("xtgd" "紖")
("xbgd" "紓")
("xig " "紟")
("xke " "紒")
("xhf " "紏")
("xzsh" "紌")
("/yr " "罜")
("/ae " "罡")
("/bgl" "罞")
("/tss" "罠")
("/ua " "罝")
("/.xk" "罛")
("ifsb" "羖")
("ifkj" "羒")
("zxbb" "翃")
("bbkj" "翂")
("bb;d" "翀")
("fkcl" "耖")
("aezx" "耾")
("aeig" "耹")
("unw " "胺")
("uyxk" "胲")
("uale" "胹")
("uaxr" "胵")
("us, " "脁")
("u.ad" "胻")
("gcau" "脀")
("of " "舁")
("lm;d" "舯")
("lmts" "舥")
("fcq " "茳")
("fyk." "茭")
("fyxk" "荄")
("fafx" "茙")
("fztg" "荑")
("frr " "茥")
("frlq" "荖")
("fqsh" "茿")
("fapa" "荁")
("fvj " "茦")
("fa/ " "茜")
("fame" "茢")
("fzag" "荂")
("faxr" "荎")
("ftx " "茛")
("fcas" "茪")
("feq " "茈")
("fjq " "茼")
("fsd." "荍")
("f.; " "茖")
("fmm " "茤")
("fkv " "茠")
("fkax" "茷")
("fkzh" "茯")
("f.q " "茩")
("f.ad" "荇")
("fi; " "荅")
("fnw " "荌")
("fif " "荓")
("fqdd" "茞")
("fzdr" "茬")
("fale" "荋")
("f/ " "茧")
("fmq " "荈")
("lses" "虓")
(".es " "虒")
("/ys " "蚢")
("/z " "蚨")
("/aas" "蚖")
("/qq " "蚍")
("/fb " "蚑")
("/v " "蚞")
("/bk " "蚇")
("/tk " "蚗")
("/tds" "蚆")
("/jk " "蚋")
("/o " "蚚")
("/.gs" "蚅")
("/k. " "蚥")
("/ig " "蚙")
("/kj " "蚡")
("/ke " "蚧")
("az/ " "蚕")
("/zsh" "蚘")
("/p " "蚎")
("/lq " "蚝")
("/laa" "蚐")
("/oas" "蚔")
("luz " "衃")
("lugr" "衄")
("ykz " "衭")
("ykp " "衵")
("yk;d" "衶")
("ykjk" "衲")
("ykla" "袀")
("yklb" "衱")
("ykig" "衿")
("ykkj" "衯")
("qjyx" "袃")
("igyx" "衾")
("ykjs" "衴")
("ykfb" "衼")
("yjh " "訒")
("qiq " "豇")
("asa." "豗")
(".af " "豻")
("mgds" "貤")
("axm " "貣")
("rcaf" "赶")
("rcd " "赸")
("slh " "趵")
("sos " "趷")
("saf " "趶")
("qz " "軑")
("qsh " "軓")
("amen" "迾")
("jqn " "迵")
("lf;n" "适")
("lpn " "迿")
("mmn " "迻")
(".qn " "逄")
("r;n " "迼")
("zun " "迶")
("qit " "郖")
("ap.t" "郠")
("qht " "郙")
("at;t" "郚")
("fjgt" "郣")
("zkkt" "郟")
("mt " "郥")
(";l;t" "郘")
(".gft" "郛")
(".zjt" "郗")
("o;t " "郜")
("kk;t" "郤")
("apaf" "酐")
("apfh" "酎")
("apgs" "酏")
("igd " "釕")
("ilg " "釢")
("ils " "釚")
("tzkk" "陜")
("tec " "陟")
("kyf " "隼")
("ibad" "飣")
("z. " "髟")
(".hhq" "鬯")
(".xs " "乿")
("kfjz" "偰")
("kqp " "偪")
("krqk" "偡")
("krsv" "偞")
("ka/w" "偠")
("kbar" "偓")
("kbif" "偋")
("kequ" "偝")
("kpn " "偲")
("kpls" "偈")
("kpac" "偍")
("k.jr" "偁")
("kafo" "偛")
("kl;m" "偊")
("klv," "偢")
("kof " "倕")
("kop " "偅")
("klpr" "偟")
("kjm " "偩")
("k.rh" "偫")
("kyp " "偣")
("kip " "偤")
("kzp " "偆")
("kfjz" "偀")
("k;ae" "偮")
("kdae" "偳")
("kclj" "偗")
("kx " "偑")
("ka/r" "凐")
("nrbe" "剫")
("baxe" "剭")
("dale" "剬")
("m;e " "剮")
("pjb " "勖")
("qqlb" "勓")
("qqls" "匭")
("zof " "厜")
(";ctb" "啵")
(";nac" "啶")
(";yw " "唼")
(";y;f" "啍")
(";ykf" "啐")
(";irs" "唴")
(";zf " "唪")
(";atc" "啑")
(";ajk" "啢")
(";rp " "唶")
(";zps" "唵")
(";bje" "唰")
(";bdd" "啒")
(";epf" "啅")
(";leb" "唌")
(";os " "唲")
(";if;" "啥")
("ofa;" "啎")
(";hkh" "唹")
(";rif" "啈")
(";rak" "唭")
(";vkk" "唻")
(";zrr" "啀")
(";.v " "啋")
("pru " "圊")
("pijf" "圇")
("ry;f" "埻")
("rjkv" "堔")
("rizs" "埢")
("rkrh" "埶")
("vvr " "埜")
("rfua" "埴")
("rbdd" "堀")
("rtc " "埭")
("rtjd" "埽")
("rjid" "堈")
("rpl." "埸")
("ruu " "堋")
("rjo " "埳")
("rleb" "埏")
("rr " "堇")
("r,, " "埮")
("rykf" "埣")
("rzf " "埲")
("rru " "埥")
("rvp " "埬")
("raea" "埡")
("rrk." "堎")
("rzqd" "埼")
("rzrr" "堐")
("ruak" "埧")
("rpv " "堁")
("rpf;" "堌")
("reab" "埱")
("r.td" "埩")
("r.v " "埰")
("rj;h" "堍")
("ros " "堄")
("eez " "奜")
("wne " "婠")
("wizs" "婘")
("watc" "婕")
("wru " "婧")
("wrif" "婞")
("wrak" "娸")
("waeb" "娵")
("waea" "婭")
("wpv " "婐")
("wpf;" "婟")
("wepf" "婥")
("w.lr" "婬")
("eew " "婓")
("wjr;" "婤")
("wos " "婗")
("wnac" "婃婝")
("w,, " "婒")
("wy; " "婄")
("wy;c" "婛")
("wrk." "婈")
("wrlp" "媎")
("wzrr" "娾")
("wzqd" "婍")
("wtgx" "娹")
("weab" "婌")
("wjrk" "婰")
("wdzf" "婩")
("w.v " "婇")
("wlvw" "婑")
("wazc" "婖")
("wlpd" "婂")
("qdtw" "婜")
("gfaa" "孲")
("gfnc" "孮")
("natc" "寁")
("n.v " "寀")
("btqd" "屙")
("dy;f" "崞")
("daff" "崋")
("dru " "崝")
("drk." "崚")
("dvp " "崠")
("dbf;" "崌")
("datc" "崨")
("dvkk" "崍")
("dzps" "崦")
("dlpf" "崥")
("doap" "崏")
("dwp " "崰")
("dykf" "崒")
("dlvw" "崣")
("di " "崟")
("dpf;" "崮")
("jdrp" "帾")
("jdax" "帴")
("nrk." "庱")
("nrp " "庴")
("nrbk" "庹")
("nvkk" "庲")
("nlpf" "庳")
("tgyc" "弶")
("tguu" "弸")
(".zqd" "徛")
(".nac" "徖")
(".jr;" "徟")
("oon " "悊")
(".,n " "悐")
("ivn " "悆")
("nnkq" "悾")
("nnac" "悰")
("nne " "悺")
("nizs" "惓")
("n,, " "惔")
("nvv " "惏")
("ntgx" "惤")
("nbbb" "惙")
("ncj;" "惝")
("npv " "惈")
("nee " "悱")
("noap" "惛")
("ngzh" "悷")
("ny;c" "惊")
("nlzc" "悿")
("npqq" "惃")
("ni " "惍")
("nijf" "惀")
("cclo" "挲")
("onms" "捥")
("oy; " "掊")
("one;" "掂")
("oykf" "捽")
("oica" "掽")
("o,, " "掞")
("oazc" "掭")
("oqax" "掝")
("oaea" "掗")
("oaeb" "掫")
("ozqd" "掎")
("oaxe" "捯")
("obbb" "掇")
("ojo " "掐")
("obf;" "据")
("oeu " "掯")
("ojrk" "捵")
("oos " "掜")
("olpf" "捭")
("ogu " "掮")
("olvw" "捼")
("ouu " "掤")
("oleb" "挻")
("onac" "掟")
("otc " "捸")
("oru " "掅")
("oqx " "掁")
("orak" "掑")
("opqq" "掍")
("opv " "捰")
("k;s." "敓")
("hoib" "旍")
("pnas" "晥")
("pqh " "晡")
("pjs " "晛")
("pxk." "晙")
("pktl" "晜")
("oop " "晢")
("uxk." "朘")
("vhtx" "桹")
("varf" "梇")
("vqqr" "梐")
("vzkk" "梜")
("vzax" "桭")
("vz; " "桮")
("vbg;" "梮")
("vtjb" "梫")
("vbj " "楖")
("v;lr" "桯")
("vdig" "梣")
("vpfg" "梬")
("vpr " "梩")
("v.w " "桵")
("v.gf" "桴")
("vk;s" "梲")
("vo; " "梏")
("vj " "桷")
("vig;" "梒")
("vkc " "桼")
("vccl" "桫")
("vfjf" "桲")
("vqi " "梪")
("vv; " "梀")
("vawq" "桱")
("vtl;" "桾")
("vgft" "梛")
("vm " "梖")
("v;u " "梋")
("v;l;" "梠")
("vxr " "梉")
("vdkj" "梤")
("v.zd" "桸")
("v.f " "桻")
("v., " "梑")
("viv " "梌")
("oov " "梊")
("vkkr" "桽")
("v;jk" "欶")
("ejfk" "欳")
(".zjk" "欷")
("xozk" "欸")
("amfs" "殑")
("amfh" "殏")
("am.f" "殍")
("amzk" "殎")
("amaq" "殌")
("of;s" "氪")
("cnac" "淀")
("cne " "涫")
("cnms" "涴")
("cnkq" "涳")
("cica" "湴")
("crif" "涬")
("crk." "淩")
("cqax" "淢")
("cvp " "涷")
("cvkk" "淶")
("cfua" "淔")
("czff" "渀")
("cbdd" "淈")
("cpae" "淠")
("cjrk" "淟")
("cepf" "淖")
("ccp " "涾")
("cwc " "淥")
("cuu " "淜")
("cuts" "淝")
("coae" "淛")
("cl.n" "淴")
("cjo " "淊")
("coap" "涽")
("cgv " "淭")
("cign" "淰")
("cbf;" "涺")
("crkr" "淕")
("cpah" "淂")
("cpaz" "淏")
("cpv " "淉")
("cpp " "淐")
("ces " "淲")
("cfh " "淓")
("cfe " "淽")
("cl, " "淗")
("cjr;" "淍")
("cos " "淣")
("cif;" "涻")
(",htx" "烺")
(",ktl" "焍")
(",nas" "烷")
(",bg;" "焗")
(",awq" "烴")
(",xk." "焌")
(",.gf" "烰")
("tl;," "焄")
(",qh " "烳")
(",at;" "焐")
(",a. " "烼")
(",jy." "烿")
(",;u " "焆")
(",ig;" "焓")
(",kk;" "焀")
(",osz" "烸")
(",lrb" "烶")
("xr, " "焋")
("kd.," "焂")
("oo, " "焎")
("ofa;" "牾")
("ofzh" "牻")
("ofaq" "牼")
("ofo;" "牿")
(".ykf" "猝")
(".zqd" "猗")
(".es " "猇")
(".pqq" "猑")
(".oae" "猘")
(".os " "猊")
(".lpf" "猈")
(".leb" "狿")
(".gu " "猏")
(".if;" "猞")
("yxok" "玈")
("arkl" "珶")
("ara;" "珸")
("ar;r" "珵")
("ar;u" "琄")
("aroc" "琁")
("arlb" "珽")
("arlg" "琇")
("ari;" "琀")
("art;" "珺")
("arm " "珼")
("ar;c" "珿")
("ardg" "琌")
("ar.d" "琋")
("arlx" "珴")
("ar.f" "琈")
("prfh" "畤")
("i;p " "畣")
("hyxk" "痎")
("hif " "痒")
("hzu " "痏")
("h/ " "痋")
("hjq " "痌")
("hmm " "痑")
("hp; " "痐")
("lpif" "皏")
("lpeq" "皉")
("cafu" "盓")
("jiz " "眹")
("j, " "眯")
("jrr " "眭")
("jztg" "眱")
("jae " "眲")
("jlp " "眴")
("jm; " "眳")
("j.ok" "眽")
("eqj " "眥")
("jif " "眻")
("jmm " "眵")
("gr; " "硈")
("ga/ " "硒")
("gtf " "硉")
("gtx " "硍")
("gjzs" "硊")
("g.; " "硌")
("eqg " "砦")
("grr " "硅")
("gjq " "硐")
("yhbb" "祤")
("yhs," "祧")
("yhov" "祩")
("yhjs" "祪")
("yhok" "祣")
("yhi;" "祫")
("eqac" "祡")
("y.dm" "离")
("lvnq" "秺")
("lvr;" "秸")
("aajv" "秶")
("lvar" "秷")
("nkcf" "窏")
("nky." "窔")
("nkrr" "窐")
("lcgs" "笵")
("lqt " "筇")
("lqd " "笴")
("lgq " "笥")
("ltge" "笰")
("ltss" "笢")
("lj; " "笤")
("lb; " "笳")
("le; " "笘")
("lpa " "笪")
("lpb " "笝")
("ll; " "笱")
("llgl" "笫")
("lib " "笭")
("lwb " "笯")
("lxf " "笲")
("lq; " "笸")
("lpd " "笚")
("llts" "笣")
(",qt " "粔")
(",e; " "粘")
(",va " "粖")
(",jf " "粣")
("xnad" "紵")
("xnq " "紽")
("xyr " "紸")
("xrx " "紶")
("xra " "紺")
("xj; " "絅")
("xpf " "紬")
("xoz " "紩")
("xogs" "絁")
("xl; " "絇")
("xk. " "紾")
("xx; " "紿")
("xva " "絊")
("xjz " "紻")
("xkfh" "紨")
("/rr " "罣")
("irhb" "羕")
("ifnd" "羜")
("ifoa" "羝")
("irte" "羛")
("ybb " "翊")
("bby " "翋")
("bbtb" "翍")
("bboz" "翐")
("bbl;" "翑")
("bbzh" "翇")
("bbk." "翏")
("vabb" "翉")
("fkqt" "耟")
("fkb;" "耞")
("fkx;" "耛")
("aeae" "聇")
("aejr" "聃")
("aexb" "聈")
("unas" "脘")
("uzkk" "脥")
("uf,h" "脙")
("uawq" "脛")
("u;lr" "脭")
("u.fh" "脟")
("u.gf" "脬")
("ukkr" "脞")
("ulrb" "脡")
("uj;s" "脕")
("uxk." "脧")
("uy;d" "脝")
("uosz" "脢")
("af;r" "舑")
("lmqd" "舸")
("lmpf" "舳")
("lmpd" "舺")
("lmoe" "舴")
("lmib" "舲")
("tges" "艴")
("fcjs" "莐")
("fysn" "莣")
("fhtx" "莨")
("ff,h" "莍")
("frla" "荺")
("fqi " "荳")
("fap " "莤")
("foz " "荴")
("focl" "莏")
("fqkk" "莁")
("fv; " "莕")
("ftl;" "莙")
("fjhn" "荵")
("fpkj" "莔")
("f.gf" "莩")
("f.w " "荽")
("f.zd" "莃")
("fk;s" "莌")
("fkkr" "莝")
("flrb" "莛")
("flox" "莪")
("fkoe" "莋")
("fxk." "荾")
("f.gr" "莥")
("fcv " "莯")
("fclb" "莈")
("fq " "莗")
("frjk" "莰")
("fzgx" "荿")
("fcu " "莦")
("fuab" "莇")
("fpb " "莮")
("f;ig" "荶")
("fleb" "莚")
("enl " "虙")
("eli " "虖")
("/yx " "蚿")
("/qt " "蚷")
("/z.h" "蛂")
("/j; " "蛁")
("/e; " "蛅")
("/jr " "蚺")
("/pf " "蚰")
("/oz " "蛈")
("/kfh" "蚹")
("/oaa" "蚳")
("/oh " "蚸")
("/.xk" "蛌")
("/xb " "蚴")
("vs/ " "蚻")
("/l; " "蚼")
("/ajk" "蛃")
("/za " "蚽")
("/tb " "蚾")
(".yxd" "衒")
("yknq" "袉")
("yknk" "袕")
("ykyx" "袨")
("yki " "袢")
("ykrx" "袪")
("ykzh" "袚")
("ykj;" "袑")
("ykjr" "袡")
("ykoz" "袟")
("ykos" "袘")
("ykl;" "袧")
("yklp" "袙")
("ykoa" "袛")
("ykk." "袗")
("ybgx" "袤")
("yx;x" "袬")
("yltx" "袌")
("ykua" "袓")
("ykxb" "袎")
("a/ln" "覂")
("jtk " "觖")
("jlb " "觙")
("ofj " "觕")
("yads" "訰")
("yzsh" "訧")
("ycl " "訬")
("ylz " "訞")
("kk;x" "谹")
("kk;f" "谻")
("a.af" "豜")
("a.ts" "豝")
(".jk " "豽")
("mys " "貥")
("rctk" "赽")
("rccl" "赻")
("rcla" "赹")
("saf " "趼")
("sfb " "跂")
("stk " "趹")
("slb " "趿")
("stds" "跁")
("qads" "軘")
("qlq " "軞")
("qoas" "軝")
("qjk " "軜")
("qsb " "軗")
("qlr " "軠")
("qig " "軡")
("ccln" "逤")
("qhn " "逋")
("f,hn" "逑")
("at;n" "逜")
("eptn" "逌")
("xk.n" "逡")
(",,t " "郯")
("atdt" "郪")
("aebt" "郰")
("vvt " "郴")
("vkkt" "郲")
("ost " "郳")
("lebt" "郔")
("lplt" "郫")
("rut " "郬")
(".zut" "郩")
("apjs" "酖")
("apsb" "酘")
("apkj" "酚")
("igap" "酓")
("aplq" "酕")
("iaf " "釬")
("iax " "釴")
("iz " "釱")
("ios " "釳")
("im " "釸")
("i. " "釤")
("iw " "釹")
("iaf " "釪")
("iaag" "釫")
("ir " "釷")
("igf " "釨")
("ifl " "釮")
("zlz " "镺")
("eaaa" "閆")
("eaf " "閈")
("trlp" "陼")
("tzqd" "陭")
("tee " "陫")
("tl, " "陱")
("tijf" "陯")
("axky" "隿")
("rfad" "靪")
("lsam" "頄")
("iblq" "飥")
("lsij" "馗")
("knk;" "傛")
("kjky" "傕")
("kitc" "傔")
("kirq" "傞")
("krjr" "傋")
("kzc " "傣")
("krx " "傃")
("kg, " "傌")
("kfuk" "傎")
("kpbb" "傝")
("keqv" "偨")
("kmod" "傜")
("k.xz" "傒")
("k.es" "傂")
("kfae" "傇")
("osos" "兟")
("kit;" "凔")
("lfi;" "匒")
("l.tg" "匑")
("zlvv" "厤")
("zfuk" "厧")
(";yp " "喑")
(";y;s" "喨")
(";nrb" "喥")
(";n. " "喭")
(";hbt" "啷")
(";hl," "噅")
(";afo" "喢")
(";a/w" "喓")
(";qqp" "喈")
(";fz;" "喏")
(";fp " "喵")
(";pm " "喁")
(";l;," "喣")
(";.kp" "喒")
(";lpr" "喤")
(";i;f" "啽")
(";;ad" "喌")
(";d;d" "喦")
(";rqk" "啿")
(";ale" "喕")
(";t;q" "喡")
(";m; " "喎")
("pdae" "圌")
("rnaa" "堩")
("ryp " "堷")
("ra/r" "堙")
("rrsv" "堞")
("ralz" "堧")
("rpm " "堣")
("rpls" "堨")
("rof " "埵")
("bqsr" "塈")
("bgdr" "堥")
("rv/ " "堜")
("rqp " "堛")
("rbj " "堳")
("rzqx" "堿")
("rzqu" "堶")
("r;;g" "堮")
("rop " "堹")
("rx " "堸")
("rlpr" "堭")
("riue" "堬")
("ctfr" "堻")
("alje" "奡")
("whl," "媯")
("wale" "媔")
("wrsv" "媟")
("bgdw" "婺")
("wpj " "媢")
("wpac" "媞")
("wpa." "婸")
("wpu " "媦")
("wfz;" "婼")
("wgjf" "媥")
("wk;v" "媬")
("wi;f" "媕")
("wiue" "媮")
("wof " "娷")
("wirz" "媄")
("wiue" "媊")
("wnaa" "媗")
("wbgv" "媃")
("wzp " "媋")
("wf;u" "媩")
("wfjf" "婻")
("wetb" "婽")
("wfp " "媌")
("wem " "媜")
("wdae" "媏")
("wlpr" "媓")
("lv,w" "媝")
("nhl," "寪")
("nnu " "寍")
("nrks" "寋")
("npac" "寔")
("nktb" "寑")
("nem " "寊")
("nxak" "寎")
("r;ih" "尌")
("zsop" "尰")
("dip " "崷")
("dn. " "嵃")
("dixx" "嵫")
("drqk" "嵁")
("dbj " "嵋")
("d;;g" "崿")
("dpa." "崵")
("dpls" "嵑")
("dpm " "嵎")
("d.d." "嵕")
("diue" "崳")
("dhos" "崺")
(";;;d" "嵒")
("dpn " "崽")
("dme " "崱")
("dlvf" "嵙")
("d.tf" "嵂")
("dykd" "崹")
("dy;d" "嵉")
("dalm" "崸")
("dpac" "崼")
("dlpr" "崲")
("drrh" "崶")
("dvyr" "嵀")
("dzqx" "嵅")
("jdbr" "幄")
("jdam" "幁")
("wqoq" "彘")
(".etb" "徦")
(".pac" "徥")
(".t;q" "徫")
("ce;n" "惉")
("nen " "悹")
("nmgn" "惌")
("nnn " "惢")
("rakn" "惎")
("eacn" "惄")
("nyp " "愔")
("njq " "惲")
("nqp " "愊")
("nrqk" "愖")
("nrf " "愅")
("nrsv" "惵")
("npa." "愓")
("nlpf" "惸")
("ngjf" "惼")
("n.d." "惾")
("von " "惁")
("nnaa" "愃")
("nn.;" "愘")
("nqpw" "愝")
("nale" "愐")
("npac" "惿")
("npax" "愄")
("n.ab" "愋")
("g,, " "扊")
("qdto" "掔")
("ooo " "掱")
("okjo" "掰")
("onaa" "揎")
("oykd" "揥")
("oy;d" "揨")
("onaa" "揯")
("oiue" "揃")
("ohl," "撝")
("ofjz" "揳")
("oqp " "揊")
("oqpw" "揠")
("oaet" "揶")
("orqk" "揕")
("orsv" "揲")
("otfb" "揵")
("obqs" "摡")
("ogcu" "揟")
("ow. " "掾")
("o.kp" "揝")
("oi;f" "揜")
("oiue" "揄")
("olpr" "揘")
("ohos" "揓")
("oip " "揂")
("ofjf" "揇")
("opn " "揌")
("opax" "揋")
("oly " "揈")
("oop " "揰")
("o.fj" "揗")
("ogjf" "揙")
("zqdb" "攲敧")
("bbb." "敪")
("pveb" "敤")
("ign." "敜")
("y;. " "敨")
(",,eb" "敥")
("y.ax" "斌")
(";;jf" "斝")
("okhf" "斞")
("rpo " "斮")
("hos," "旐")
("hozo" "旒")
("pnms" "晼")
("pykf" "晬")
("pzps" "晻")
("p.yr" "暀")
("p,, " "晱")
("ppl." "晹")
("pjrk" "晪")
("pos " "晲")
("qsqp" "朁")
("vnkq" "椌")
("vy; " "棓")
("vyw " "椄")
("vhkh" "棜")
("vica" "椪")
("vizs" "棬")
("v,, " "棪")
("vrk." "棱")
("vaea" "椏")
("vqx " "棖")
("vaeb" "棷")
("vqax" "棫")
("vrp " "棤")
("vvkk" "棶")
("va.h" "椓")
("vbf;" "椐")
("vbbb" "棳")
("vjid" "棡")
("vuak" "椇")
("v.v " "棌")
("vl, " "椈")
("vok " "楰")
("vleb" "梴")
("vlpf" "椑")
("vign" "棯")
("vijf" "棆")
("vwp " "椔")
("aebv" "棸")
("eev " "棐")
("vvig" "棽")
("vvkj" "棼")
("g.v " "棨")
("vy;c" "椋")
("vykf" "椊")
("vnac" "椗")
("vjkv" "棎")
("vru " "棈")
("vpf;" "棝")
("vplv" "棞")
("v.td" "棦")
("vujb" "棴")
("vee " "棑")
("vjr;" "椆")
("voap" "棔")
("ve " "棩")
("vkjv" "椕")
("voz;" "椥")
("vkxn" "棇")
("zqdk" "欹")
(",,jk" "欻")
("jojk" "欿")
("bbbk" "欼")
("amtc" "殔")
("amzs" "殗")
("amop" "殙")
("amy;" "殕")
(".zub" "殽")
("lqy;" "毰")
("bbbq" "毲")
("lqlq" "毳")
("oru " "氰")
("ccc " "淼")
("cyp " "湆")
("cyu " "湇")
("cy;d" "渟")
("cna;" "湉")
("chl," "溈")
("cirz" "渼")
("cr;x" "渽")
("cv/ " "湅")
("cqp " "湢")
("crsv" "渫")
("cvac" "渿")
("coi;" "湁")
("cqqp" "湝")
("cfjf" "湳")
("calz" "渜")
("ctge" "渳")
("ct;q" "湋")
("cbaz" "湀")
("cgcu" "湑")
("cclj" "渻")
("cfz;" "渃")
("cfqd" "渮")
("cem " "湞")
("cjzh" "湨")
("cpac" "湜")
("cpm " "湡")
("c/q " "渱")
("cpax" "渨")
("cdz," "湠")
("cfg " "湱")
("clv," "湫")
("cly " "渹")
("cx " "渢")
("ci;f" "渰")
("ckju" "湓")
("cnkh" "湥")
("cykd" "渧")
("cy;s" "湸")
("chos" "湤")
("czp " "湷")
("ctfb" "湕")
("czpr" "湹")
("c;ae" "湒")
("cpor" "湦")
("cfp " "渵")
("cfjz" "渶")
("cdxs" "湚")
(",ykf" "焠")
(",y;f" "焞")
(",epf" "焯")
(",leb" "烻")
(",ojk" "焮")
(",,, " "焱")
("aeb," "焣")
(",nmq" "焥")
(",nkq" "焢")
(",ykk" "焲")
(",rp " "焟")
(",pu " "焨")
(",plf" "焺")
("e, " "焛")
("daxx" "牋")
("cj;l" "牚")
("ofis" "犈")
("ofyf" "犉")
("offa" "犆")
("ofjd" "犅")
("ofuk" "犋")
("puzh" "猒")
("zhzh" "猋")
(".fjz" "猰")
(".f;u" "猢")
(".bgv" "猱")
(".etb" "猳")
(".m; " "猧")
(".pls" "猲")
(".w. " "猭")
(".x " "猦")
("..d." "猣")
(".gjf" "猵")
("vkkh" "猌")
("arnc" "琮")
("arns" "琬")
("ar,," "琰")
("arzf" "琫")
("arax" "琖")
("arb;" "琚")
("areb" "琡")
("arwc" "琭")
("arj;" "琱")
("ar.d" "琤")
("ary;" "琣")
("arp." "琝")
("arpp" "琩")
("arjk" "琠")
("aree" "琲")
(".zjh" "瓻")
("nnjf" "甯")
("pxk." "畯")
("ivp " "畬")
("hccl" "痧")
("hrlf" "痚")
("hqh " "痡")
("hat;" "痦")
("hzsh" "痝")
("hcu " "痟")
("hkkr" "痤")
("hosz" "痗")
("alpp" "皕")
("lplx" "皒")
("f,hu" "盚")
("jnas" "睆")
("jktl" "睇")
("jcu " "睄")
("jjs " "睍")
("jpaf" "睅")
("j;u " "睊")
("j.zd" "睎")
("jlox" "睋")
("jj;s" "睌")
("bgd;" "矞")
("ozkr" "矬")
("ghtx" "硠")
("gzkk" "硤")
("gzsh" "硥")
("gawq" "硜")
("gfys" "硭")
("gpv " "硱")
("glox" "硪")
("gj " "确")
("cclg" "硰")
("oog " "硩")
("gq " "硨")
("go; " "硞")
("giv " "硢")
("yhax" "祴")
("yhzx" "祳")
("yhtb" "祲")
("yho;" "祰")
("lvhx" "稂")
("lvkl" "稊")
("lv.f" "稃")
("lviv" "稌")
("lvx." "稄")
("nkrf" "窙")
("yv; " "竦")
("ynzx" "竤")
("lyk." "筊")
("lqj " "笻")
("ls, " "筄")
("llf;" "筈")
("lir " "筌")
("lw; " "筎")
("lrr " "筀")
("lo; " "筘")
("los " "筅")
("aaj," "粢")
(",a/ " "粞")
(",alp" "粨")
(",jq " "粡")
("xaak" "絘")
("xyxk" "絯")
("xif " "絣")
("xrr " "絓")
("xcas" "絖")
("xjq " "絧")
("xpz " "絪")
("xpx " "絏")
("izx " "絭")
("fjx " "絜")
("xxxx" "絫")
("xadd" "絒")
("xalp" "絔")
("xs, " "絩")
("xov " "絑")
("xir " "絟")
("x.ad" "絎")
("ofdf" "缾")
("ofdq" "缿")
("/;u " "罥")
("/.gf" "罦")
("ifax" "羢")
("ifzg" "羠")
("irak" "羡")
("mmbb" "翗")
("aeae" "聑聏")
("aer;" "聐")
("rjkx" "胾")
("eqjk" "胔")
("uizs" "腃")
("urp " "腊")
("ubf;" "腒")
("ubbb" "腏")
("ulvw" "腇")
("uky " "脽")
("uign" "腍")
("uykf" "脺")
("tdqd" "臦")
("ljkk" "臮")
("raxx" "臷")
("axrr" "臸")
("axrx" "臹")
("ol, " "舄")
("lmrk" "舼")
("lm.q" "舽")
("lmzg" "舿")
("ifjs" "艵")
("dddd" "茻")
("fcqd" "菏")
("fcua" "菹")
("fnac" "萣")
("fnms" "菀")
("fyw " "菨")
("fyks" "萒")
("fnoa" "菧")
("fizs" "菤")
("f,, " "菼")
("fzf " "菶")
("fatc" "萐")
("faeb" "菆")
("foy " "菈")
("fqr " "菫")
("fqdb" "菣")
("fvje" "莿")
("frak" "萁")
("fozh" "菝")
("fvo " "菥")
("fvkx" "菘")
("faxe" "菿")
("fgcd" "菡")
("f;av" "菋")
("fpqq" "菎")
("fpp " "菖")
("fjis" "菵")
("fwc " "菉")
("futs" "萉")
("fjo " "萏")
("flvl" "菞")
("fky " "萑")
("flpf" "萆")
("flph" "菂")
("fi " "菳")
("fijf" "菕")
("fgu " "菺")
("fwf;" "菇")
("fwp " "菑")
("fng " "菪")
("fnua" "萓")
("fcqt" "菃")
("fcj;" "菬")
("fntk" "菮")
("fvp " "菄")
("fvv " "菻")
("fopf" "菗")
("fols" "菢")
("fjf " "萛")
("fe " "菛")
("fazc" "菾")
("/if " "蛘蛢")
("/ztg" "蛦")
("r/x " "蛓")
("/r; " "蛣")
("/ame" "蛚")
("fj/ " "蛪")
("/tx " "蛝")
("/jzs" "蛫")
("/ktl" "蛜")
("rk/ " "蛬")
("qsh/" "蛩")
("le/ " "蛗")
("/alp" "蛨")
("/xof" "蛑")
("luae" "衈")
(".rkd" "衖")
(".jqd" "衕")
("ykr;" "袺")
("ykzo" "裗")
("ykap" "袹")
("ykzf" "袸")
("ykpz" "裀")
("ykov" "袾")
("yk.q" "袶")
("yk.;" "袼")
("yki;" "袷")
("ykw;" "袽")
("ymmx" "袲")
("pvlx" "褁")
("yktx" "裉")
("nljs" "覕")
("e;js" "覘")
("gqjs" "覗")
("joaa" "觝")
("j.xk" "觚")
("jpa " "觛")
("yqt " "詎")
("yrs " "詍")
("yvh " "訹")
("yz.h" "詙")
("ye; " "詀")
("yj; " "詗")
("ydd " "詘")
("yoz " "詄")
("yib " "詅")
("yx; " "詒")
("/y " "詈")
("ynq " "詑")
("yi " "詊")
("yra " "詌")
("yxb " "詏")
("a.gs" "豟")
(".nk " "貁")
(".dd " "貀")
("m;s " "貺")
("moaa" "貾")
("rsm " "貰")
("mor " "貹")
("xzm " "貵")
("rcua" "趄")
("rcll" "趀")
("rcdd" "趉")
("si " "跘")
("syr " "跓")
("sf; " "跍")
("srs " "跇")
("sg " "跖")
("sbq " "跜")
("sb; " "跏")
("se; " "跕")
("sua " "跙")
("sk. " "跈")
("skfh" "跗")
("soh " "跅")
("qai " "軯")
("qz.h" "軷")
("qj; " "軺")
("q;k " "軹")
("q;s " "軦")
("qjz " "軮")
("ql; " "軥")
("qkfh" "軵")
("qoaa" "軧")
("qib " "軨")
("qgs " "軶")
("qk. " "軫")
("q.xk" "軱")
("xzq " "軬")
("qyr " "軴")
("qx; " "軩")
("nen " "逭")
("epfn" "逴")
("wcn " "逯")
("jqt " "鄆")
("hlgt" "鄬")
("a/rt" "鄄")
("bjt " "郿")
("t;qt" "郼")
("bazt" "鄈")
("jzht" "郹")
("jswt" "郻")
("equt" "鄁")
("fz;t" "鄀")
("ktot" "鄇")
("l;mt" "鄅")
("iuet" "鄃")
("apnq" "酡")
("apf;" "酤")
("ape;" "酟")
("apoe" "酢")
("apqd" "酠")
("ih " "鈁")
("in " "鈊")
("i, " "鈥")
("iaf " "鈃")
("iqq " "鈚")
("izh " "鈦")
("itgd" "鈏")
("itk " "鈌")
("itds" "鈀")
("ilb " "鈒")
("io " "釿")
("i.dk" "釽")
("ikx " "鈆")
("ihf " "鈄")
("iys " "鈧")
("ijs " "鈂")
("izx " "鈜")
("ip " "鈤")
("ieb " "鈙")
("ixs " "鈗")
("iu " "鈅")
("ikj " "鈖")
("zoz " "镻")
("eh " "閍")
("eys " "閌")
("elq " "閐")
("tzax" "隇")
("talz" "陾")
("tpax" "隈")
("tor " "隉")
("tiue" "隃")
("top " "隀")
("igky" "雂")
("fky " "雈")
("afky" "雃")
("zh " "雱")
("zkj " "雰")
("rfaf" "靬")
("rfas" "靰")
("rflh" "靮")
("afam" "頇")
("x. " "颩")
("iblz" "飫")
("l,s " "鳦")
("ca, " "黹")
(",mqs" "亃")
("vqis" "亄")
("yp;a" "亶")
("kypf" "傽")
("kae," "傿")
("kqn " "僆")
("kqp " "傮")
("ka/c" "僄")
("ka/s" "僊")
("kq;;" "傴")
("kp/b" "僈")
("kp;w" "僂")
("kduu" "傰")
("kl,n" "僁")
("kmac" "傺")
("k.kc" "傱")
("kigm" "僋")
("i;;k" "僉")
("kzex" "傶")
("kz.." "傸")
("kdky" "凗")
("av.j" "剺")
("zfhe" "剸")
("duue" "剻")
("xxxe" "剼")
(";y;;" "嗃")
(";itc" "嗛")
(";iku" "嗌")
(";nr;" "嗐")
(";bbu" "嗋")
(";qm " "嗊")
(";qjd" "嗝")
("vqsb" "嗀")
(";fuk" "嗔")
(";al." "嗄")
(";cm " "嗩")
(";;;v" "喿")
(";fi;" "嗒")
(";eqv" "喍")
(";fkv" "嗏")
(";zah" "嗕")
(";/u " "嗢")
(";odb" "嗖")
(";w;s" "嗈")
(";k.m" "嗲")
(";idu" "嗍")
(";ykh" "嗙")
(";mod" "嗂")
("prxu" "圔")
("rjpk" "塓")
("rrkc" "塨")
("r;m " "塤")
("rdqi" "塏")
("uizr" "塍")
("rk,u" "塉")
("rohp" "塯")
("rkxb" "塕")
("rnk;" "塎")
("rykh" "塝")
("ry;;" "塙")
("rqjd" "塥")
("ra/v" "塛")
("r/ae" "堽")
("c;lr" "塣")
("hbur" "塱")
("vaea" "壼")
("wjpk" "嫇")
("wzlc" "嫄")
("wtgk" "嫋")
("wda." "媺")
("wda/" "媸")
("wmod" "媱")
("uizw" "媵")
("wldd" "媰")
("wox " "媿")
(",,jw" "嫈")
("lmsw" "媻")
("wnk;" "嫆")
("wzah" "媷")
("wzlv" "嫀")
("wrx " "嫊")
("wr;x" "媴")
("wfae" "媶")
("w.o " "嫍")
("wohp" "媹")
("qd;w" "媐")
("nctb" "寖")
("nfuk" "寘")
("n.xk" "寙")
("pacl" "尟")
("zsmu" "尳")
("dnk;" "嵱")
("dnt;" "嵣")
("dlvq" "嵊")
("dmqv" "嵥")
("dljv" "嵲")
("dox " "嵬")
("ivdd" "嵞")
("dl, " "嵨")
("dohp" "嵧")
("dit;" "嵢")
("awqo" "巰")
("jdn." "幏")
("jdjk" "幎")
("jdqm" "幊")
("jd.o" "幍")
("lmsd" "幋")
("nrxu" "廅")
("yag," "廌")
("nox " "廆")
("nodb" "廋")
("nohp" "廇")
("vatb" "彀")
("..xz" "徯")
(".mod" "徭")
("zpn " "惷")
("nyxp" "慉")
("nitc" "慊")
("nrx " "愫")
("nbh/" "慅")
("nbbu" "愶")
("nmu " "愲")
("nmod" "愮")
("n.o " "慆")
("nkyb" "愯")
("njpk" "慏")
("nqm " "愩")
("n.xz" "慀")
("ypax" "戠")
("rapx" "酨")
("bazx" "戣")
("porx" "戥")
("lgbx" "戤")
("gafo" "揅")
("cueo" "揱")
("lv,o" "揫")
("oyxp" "搐")
("oykh" "搒")
("ojky" "搉")
("oidu" "搠")
("oiku" "搤")
("onr;" "搳")
("oqm " "摃")
("oqaf" "搟")
("orxu" "搕")
("orlp" "搘")
("oqjd" "搹")
("ofuk" "搷")
("oaxp" "搢")
("ozax" "搣")
("obrx" "搌")
("otgk" "搦")
("omu " "搰")
("opbb" "搨")
("opzn" "摁")
("o/u " "搵")
("o.o " "搯")
("oldd" "搊")
("obbu" "搚")
("ol, " "摀")
("olen" "搥")
("ogbb" "搧")
("o.es" "搋")
("v;eo" "揧")
("oitc" "搛")
("oa/v" "搮")
("obbv" "搡")
("ogfx" "搎")
("tsab" "敯")
("y.gf" "斒")
("hocu" "旓")
("phos" "暆")
("pbaz" "暌")
("pv/ " "暕")
("pt;q" "暐")
("tsap" "暋")
("palm" "暊")
("pzp " "暙")
("pfjf" "暔")
("pae." "晸")
("ufjz" "朠")
("vnaa" "楦")
("vy;d" "楟")
("vhos" "椸")
("vjq " "楎")
("vip " "楢")
("vzaz" "楱")
("vzp " "椿")
("vqp " "楅")
("vrsv" "楪")
("vrqk" "椹")
("vvpa" "楂")
("vtfb" "楗")
("vbgv" "楙楺")
("vgcu" "楈")
("vfz;" "楉")
("vetb" "椵")
("vpls" "楬")
("vpax" "椳")
("vw. " "椽")
("v.ab" "楥")
("vof " "棰")
("vlv," "楸")
("vosb" "椴")
("vka." "楩")
("vl;m" "楀")
("v.fj" "楯")
("vgjf" "楄")
("aajv" "楶")
("bgdv" "楘")
("vn.;" "楁")
("vykd" "楴")
("vn. " "楌")
("vqpw" "椻")
("vv;e" "楋")
("vzqx" "椷")
("vf;u" "楜")
("vzrr" "楏")
("vbaz" "楑")
("vt;q" "椲")
("vpn " "楒")
("vdae" "椯")
("vlpr" "楻")
("v.cd" "椼")
("ypjk" "歆")
("a/rk" "歅")
("afok" "歃")
("dalk" "歂")
("iuek" "歈")
("rqkk" "歁")
("amaa" "殛")
("vqsb" "嗀")
("zquq" "毻")
("plkq" "毼")
("iueq" "毹")
("pjlq" "毷")
("lqpn" "毸")
("cnkk" "溛")
("cypx" "滖")
("cy;;" "滈")
("cnt;" "溏")
("cyxp" "滀")
("cjpk" "溟")
("citc" "溓")
("cir," "溔")
("cirq" "溠")
("czlv" "溱")
("cfjx" "溹")
("cqjd" "滆")
("cqdd" "滒")
("czah" "溽")
("ctiv" "滁")
("cbh/" "溞")
("cpcs" "滉")
("cpa." "溷")
("cdqi" "溰")
("cda/" "滍")
("cda." "溦")
("ck.i" "滏")
("codb" "溲")
("cox " "溾")
("ckxb" "滃")
("clpf" "滜")
("cjk;" "滘")
("czc " "溙")
("cr;x" "溒")
("cvrr" "溎")
("caxp" "溍")
("cg, " "溤")
("cprh" "溡")
("cpi " "溿")
("c;m " "溳")
("cmqv" "滐")
("co, " "滊")
("clvq" "溗")
("cled" "溮")
("ckif" "溣")
(",jq " "煇")
(",,e;" "煔")
(",t;q" "煒")
(",bgv" "煣")
(",rsv" "煠")
(",rqk" "煁")
(",bj " "煝")
(",,jh" "煢")
("k;v," "煲")
(",gjf" "煸")
(",ip " "煪")
(",tfb" "煡")
(",rf " "煂")
(",zqx" "煘")
(",zrr" "煃")
(",por" "煋")
(",;;;" "煰")
(",pu " "煟")
(",fjz" "煐")
(",dae" "煓")
(",op " "煄")
(",lv," "煍")
("pqt," "煚")
("diue" "牏")
("oftb" "犍")
("ofeb" "犌")
("ofjh" "犑")
("oflf" "犐")
("rrff" "犎")
(".qhh" "猼")
(".zlc" "獂")
(".gfx" "猻")
(".mod" "猺")
(".odb" "獀")
(".it;" "獊")
(".zlv" "獉")
("arna" "瑄")
("arzx" "瑊")
("artq" "瑋")
("arp." "瑒")
("arw." "瑑")
("ar.b" "瑗")
("arlm" "瑀")
("arnl" "瑏")
("arie" "瑐")
("arqp" "瑎")
("arbj" "瑂")
("arpr" "瑆")
("arjz" "瑍")
("arlc" "瑔")
("rifk" "瓡")
("y;qh" "瓿")
("lvwh" "瓾")
("cj;h" "瓽")
("esra" "甝")
("pnms" "畹")
("pbbb" "畷")
("vvp " "榃")
("hne " "痯")
("hrlp" "瘏")
("ha.h" "瘃")
("hzps" "痷")
("htqd" "痾")
("hpf;" "痼")
("hpae" "痹")
("hoae" "痸")
("hok " "瘐")
("hoap" "痻")
("hjrk" "痶")
("huu " "痭")
("hlvf" "痵")
("hky " "痽")
("volp" "皙")
("rptb" "皵")
("wcu " "盝")
("jnms" "睕")
("jykf" "睟")
("jizs" "睠")
("j,, " "睒")
("jrk." "睖")
("jzrr" "睚")
("jwc " "睩")
("joap" "睧")
("jijf" "睔")
("jgzh" "睙")
("jjr;" "睭")
("bgdp" "矠")
("gnac" "碇")
("gy; " "碚")
("gaax" "碔")
("grp " "碏")
("gvv " "碄")
("gzqd" "碕")
("gplv" "碅")
("ctbg" "碆")
("grsz" "碡")
("gru " "碃")
("gvkx" "硹")
("gjid" "碙")
("g.td" "碀")
("gijf" "碖")
("qdtg" "硻")
("yhpv" "祼")
("yhj;" "禂")
("yhyf" "祽")
("yhld" "祹")
("lvrr" "稑")
("lvrk" "稘")
("lvfa" "稙")
("lvp;" "稒")
("lvlf" "稗")
("lvyf" "稕")
("lvqx" "稢")
("lvrp" "稓")
("lvpv" "稛")
("lvif" "稐")
("nkyf" "窣")
("nkqx" "窢")
("nkjo" "窞")
("y.td" "竫")
("lnas" "筦")
("lhtx" "筤")
("larf" "筭")
("lzkk" "筴")
("lbjf" "筩")
("lcu " "筲")
("l;l;" "筥")
("llrb" "筳")
("lkd." "筱")
("lkoe" "筰")
("liv " "筡")
("lpaf" "筸")
("lo; " "筶")
("llve" "筣")
("emb," "粲")
(",pr " "粴")
(",js " "粯")
("xktl" "綈")
("xap." "綆")
("xv; " "綀")
("xfjf" "綍")
("xf,h" "絿")
("xtjb" "綅")
("x.zd" "絺")
("xlrb" "綎")
("xj;s" "絻")
("xcu " "綃")
("x. " "絼")
("xkk;" "綌")
("zaax" "綔")
("xnas" "綄")
("x;l;" "絽")
("x.gf" "綒")
("/qax" "罭")
("/rrc" "罫")
("/vv " "罧")
("/zps" "罨")
("/bbb" "罬")
("ifns" "羦")
("ifaq" "羥")
("ifx." "羧")
("kd.b" "翛")
("bbzk" "翜")
("fkub" "耡")
("uyp " "腤")
("uzaz" "腠")
("uqp " "腷")
("urav" "腜")
("ufjf" "腩")
("ubar" "腛")
("upm " "腢")
("upax" "腲")
("u.d." "朡")
("uw. " "腞")
("uosb" "腶")
("uiue" "腧")
("u.fj" "腯")
("uof " "腄")
("um; " "腡")
("twjq" "舝")
("lmbq" "艉")
("lmcu" "艄")
("lm.f" "艀艂")
("lmiv" "艅")
("fcif" "蓱")
("fcl;" "萿")
("fnkh" "葖")
("fy;d" "葶")
("fhos" "葹")
("fjap" "蒏")
("fhl," "蒍")
("fiue" "葥")
("frrh" "葑")
("fol;" "葀")
("fqsw" "蒆")
("ffjb" "葧")
("fv/ " "萰")
("fqp " "葍")
("fa/w" "葽")
("frqk" "葚")
("fvj " "葙")
("fzqx" "葴")
("fzax" "葳")
("fawb" "葝")
("fbqs" "蔇")
("ftge" "葞")
("fcue" "萷")
("fpj " "萺")
("fme " "萴")
("f;ae" "葺")
("fpoe" "葃")
("fpn " "葸")
("f.ab" "萲")
("fkka" "葅")
("flv," "萩")
("fof " "菙")
("ful;" "葋")
("fjm " "萯")
("fj;b" "葂")
("fl;m" "萭")
("flpr" "葟")
("fkx." "葰")
("fgjf" "萹")
("f.tf" "葎")
("fwww" "葌")
("fxq " "葒")
("fxlh" "葯")
("fczo" "蓅")
("fc.k" "蒎")
("fyp " "萻")
("fbgv" "葇")
("fzp " "萶")
("ffjf" "萳")
("fpax" "葨")
("fmgn" "葾")
("fuoe" "葄")
("flvp" "萫")
("fktb" "葠")
("fktz" "葔")
("fosb" "葮")
("fkju" "葐")
("/htx" "蜋")
("/zax" "蜄")
("/f,h" "蛷")
("/qqr" "蜌")
("/zkk" "蛺")
("/zsh" "蛖")
("/awq" "蛵")
("/bj " "蝍")
("/cu " "蛸")
("/;u " "蜎")
("/.gf" "蜉")
("/ogc" "蜁")
("/.fh" "蛶")
("/iv " "蜍")
("/qh " "蜅")
("ykzx" "裖")
("ykqi" "裋")
("ykpv" "裍")
("yk;r" "裎")
("ykks" "裞")
("y;tx" "裛")
("ooyx" "裚")
("ykzk" "裌")
("yk;u" "裐")
("a/w." "覅")
(".oks" "覛")
("jrr " "觟")
("jcas" "觥")
("jjzs" "觤")
("j.; " "觡")
("izj " "觠")
("fjj " "觢")
("eqj " "觜")
("j/ " "触")
("yadd" "詶")
("yqar" "誆")
("yrr " "詿")
("ybb " "詡")
("yeq " "訿")
("yjq " "詷")
("ys, " "誂")
("yfk " "誄")
("yos " "詵")
("ymm " "誃")
("yif " "誁")
("yzu " "詴")
("ym; " "詺")
("kk;k" "谼")
("mqi " "豋")
("pfqi" "豊")
("a.yk" "豥")
("a.tx" "豤")
("ea. " "豦")
(".apa" "貆")
(".tf " "貄")
(".kv " "貅")
("yxkm" "賌")
("rc/ " "赨")
("rcjs" "赩")
("rcak" "趑")
("rcr;" "趌")
("rcov" "趎")
("rcl;" "趏")
("rcmm" "趍")
("rcsv" "趓")
("rcae" "趔")
("rcbb" "趐")
("rcs," "趒")
("sif " "跰")
("sztg" "跠")
("srr " "跬")
("srfh" "跱")
("saxr" "跮")
("seq " "跐")
("spx " "跩")
("sos " "跣")
("smm " "跢")
("sir " "跧")
("si; " "跲")
("qshc" "跫")
("sa/ " "跴")
("qyxk" "輆")
("qif " "軿")
("qrk " "輁")
("qale" "輀")
("q.; " "輅")
("qir " "輇")
("qlm " "輈")
("rkq " "輂")
("dzq " "輋")
("ipn " "遒")
("paln" "逿")
("daln" "遄")
("emn " "遉")
("fz;n" "逽")
("yxpt" "鄐")
("jpyt" "鄍")
("zaat" "鄏")
("axxt" "鄑")
(";mt " "鄖")
("l,t " "鄔")
("odbt" "鄋")
("ljnt" "鄎")
("apjq" "酮")
("apqp" "酯")
("inq " "鉈")
("iyr " "鉒")
("iyjd" "鈰")
("iarh" "鈺")
("iae " "鉦")
("iqd " "鈳")
("ivh " "鉥")
("iqx " "鉞")
("izs " "銃")
("ibq " "鈮")
("ij; " "鉊")
("ie; " "鉆")
("ipa " "鉭")
("ij " "鉬")
("iua " "鉏")
("ijz " "鉠")
("isz " "鉧")
("ixk " "鉯")
("ix; " "鈶")
("ii " "鉡")
("igq " "鉰")
("itss" "鈱")
("iqjd" "鉔")
("irx " "鉣")
("ig " "鉐")
("ieac" "鉲")
("ior " "鉎")
("iojd" "鉓")
("ilv " "鉌")
("i.h " "鉖")
("i.xk" "鈲")
("enl " "閟")
("eqd " "閜")
("exf " "閞")
("eai " "閛")
("titc" "隒")
("tzqq" "隓")
("tdqi" "隑")
("tox " "隗")
("uaky" "雎")
("zbgl" "雺")
("zli " "雽")
("zra " "雸")
("zjz " "雵")
("rfo " "靳")
("rftd" "靷")
("rflb" "靸")
("rfig" "靲")
("ysam" "頏")
("fbam" "頍")
("oalm" "頎")
("xqdl" "颬")
("ibnl" "飶")
("iboj" "飹")
("g,af" "馯")
("g,lq" "馲")
("g,lh" "馰")
("g,f " "馵")
("muaf" "骭")
("mulh" "骫")
("u,j " "魛")
("cl, " "鳪")
("jl, " "鳭")
("l,s " "鳧")
("yqqq" "麀")
("jaaa" "黽")
("ky;h" "僦")
("kiph" "僔")
("k,,b" "僗")
("kffm" "僨")
("ka/," "僳")
("krak" "僛")
("kbg;" "僪")
("kbgf" "僝")
("k;;f" "僤")
("k;dm" "僓")
("kky," "僬")
("vjvk" "僰")
("k,mq" "僯")
("kzzp" "僣")
("kl,p" "僠")
("krao" "凘")
("bgde" "劀")
("ky,e" "劁")
("rsmb" "勩")
("l,pb" "勫")
("q;;f" "匰")
("zp.;" "厬")
(";nnd" "嘧")
(";ae," "嘕")
(";a/c" "嘌")
(";fft" "嘒")
(";fpz" "嗼")
("f;eb" "嘏")
(";fkm" "嘜")
(";zex" "嘁")
(";pqx" "嘓")
(";;s;" "嘂")
(";dky" "嗺")
(";jhf" "嘝")
(";lv " "嘄")
(";igm" "嗿")
(";qn " "嗹")
("rntf" "墉")
("rzfh" "塼")
("rrr " "墐")
("rfps" "墘")
("rrjd" "墆")
("rp/b" "墁")
("rp;w" "塿")
("rduu" "塴")
("rxx." "墋")
("nvvr" "塺")
("rypf" "墇")
("ryk;" "墑")
("ry;t" "墎")
("ryqq" "塶")
("ra/c" "墂")
("rrqb" "墈")
("rfpz" "塻")
("rdky" "墔")
("xmfr" "墏")
("r;it" "壾")
("zce " "奫")
("wypf" "嫜")
("wzag" "嫮")
("wzfh" "嫥")
("wqon" "嫕")
("wbb." "嫪")
("wp/b" "嫚")
("weli" "嫭")
("wfpz" "嫫")
(",.w " "嫳")
("zjsw" "嫢")
("av.w" "嫠")
("qozw" "嫛")
("wnr," "嫬")
("wntf" "嫞")
("wntc" "嫝")
("whoc" "嫙")
("wrz " "嫨")
("wqf;" "嫟")
("av.f" "孷")
("np;w" "寠")
("nxy " "寣")
("b.ec" "屣")
("dypf" "嶂")
("dzag" "嶀")
("drjd" "嵽")
("dqp " "嶆")
("dbb." "嵺")
("dp;w" "嶁")
("d.kc" "嵷")
("doky" "嶊")
("d;ky" "嶉")
("dxmh" "嶈")
("dxx." "嵾")
("dnor" "嵼")
("dbbp" "嶍")
("dtg/" "嵹")
("dadm" "嵿")
("jdrm" "幘")
("jdfz" "幙")
("jdx." "幓")
("nyqq" "廘")
("nrr " "廑")
("nrjd" "廗")
("nqam" "廎")
("nbrp" "廜")
("ntix" "廕")
("nprk" "廙")
("nrh." "廒")
("np;w" "廔")
("tgq;" "彄")
("tgpf" "彃")
("a/a." "彯")
(".,. " "徶")
("idun" "愬")
("vasn" "愨")
("pa.n" "慁")
("nypf" "慞")
("nzfh" "慱")
("nqdr" "慳")
("nqp " "慒")
("na/c" "慓")
("nrjk" "慲")
("nrr " "慬")
("nbb." "憀")
("nbbp" "慴")
("nfpz" "慔")
("np;w" "慺")
("ndky" "慛")
("no;n" "慥")
("gfln" "愻")
("nq;;" "慪")
("nz.." "慡")
("npqx" "慖")
("axxx" "戩")
("itlx" "戧")
("zuqx" "戫")
("lmso" "搫")
("onkp" "摍")
("oy.m" "摛")
("oyqq" "摝")
("ozag" "摴")
("ozfh" "摶")
("oqo " "摲")
("oq;;" "摳")
("oa/c" "摽")
("ozex" "摵")
("ozak" "摦")
("ozrp" "撦")
("obb." "摎")
("op.;" "撂")
("opx " "摞")
("osfm" "摜")
("o.vb" "摋")
("o.fn" "摓")
("olpn" "摠")
("o.kc" "摐")
("okyp" "摿")
("oi;o" "搿")
("oyps" "摬")
("ozjs" "摫")
("oqn " "摙")
("oop." "摥")
("owpv" "摷")
("dqi." "敳")
("rjrf" "斠")
("pkxb" "暡")
("py;;" "暠")
("pdqi" "暟")
("rxps" "朅")
("pdv/" "朄")
("qdtr" "朢")
("vypx" "榱")
("vnt;" "榶")
("vhoz" "槉")
("vjpk" "榠")
("virq" "槎")
("vavb" "榖")
("vrlp" "榰")
("vr;x" "榬")
("vrxu" "榼")
("vqhh" "榑")
("vfi;" "榙")
("val." "榎")
("vqee" "榧")
("vbcu" "榍")
("vey." "榩")
("vmu " "榾")
("vprh" "榯")
("vdqi" "榿")
("v.o " "槄")
("v.xz" "榽")
("vmqv" "榤")
("vlpf" "槔")
("v.es" "榹")
("iduv" "槊")
("vir," "榚")
("vitc" "槏")
("vnlb" "榳")
("vnlu" "榓")
("vg, " "榪")
("vrx " "榡")
("vzlc" "榞")
("vfuk" "槙")
("vaxp" "榗")
("vbrx" "榐")
("vgfx" "槂")
("vfae" "榵")
("vpcs" "榥")
("vflp" "槆")
("y;jk" "歊")
("l,jk" "歍")
(".esk" "歋")
("am;m" "殞")
("am/u" "殟")
("amlh" "殠")
("y;jb" "毃")
("q;sb" "毄")
("pbbq" "毾")
(",,jc" "滎")
("cnnd" "滵")
("cnab" "滱")
("cneb" "漃")
("cnkr" "漥")
("cyof" "滸")
("cy;t" "漷")
("cnor" "滻")
("cntc" "漮")
("cyqq" "漉")
("c,. " "潎")
("czfh" "漙")
("cq;;" "漚")
("cfps" "漧")
("czau" "漘")
("cbb." "漻")
("ctg/" "漒")
("cpff" "滭")
("cp;w" "漊")
("c;;n" "漶")
("cbrp" "潳")
("celi" "滹")
("ces." "滮")
("cfzf" "漭")
("c/kk" "潀")
("cduu" "漰")
("cdky" "漼")
("civ." "漵")
("ckdu" "滫")
("c.ec" "漇")
("c.kc" "漎")
("c..u" "潃")
("cwpv" "漅")
("cntf" "滽")
("crh." "滶")
("cae," "漹")
("cvvr" "漜")
("cvvh" "滼")
("cz.." "漺")
("ccjr" "漟")
("cpqx" "漍")
("c.js" "漞")
("cmac" "漈")
("cop." "漡")
(",y;;" "熇")
(",jpk" "熐")
(",;m " "熉")
(",pcs" "熀")
(",/u " "熅")
(",o, " "熂")
("o/, " "熏")
(",nt;" "煻")
(",rxu" "熆")
(",bbu" "熁")
(",it;" "熗")
("xit;" "牄")
("dykh" "牓")
("ofn;" "犗")
("ofrf" "犕")
("ofld" "犓")
("dqih" "獃")
(".yps" "獍")
(".qo " "獑")
(".p/b" "獌")
("arn;" "瑢")
("ariq" "瑳")
("arfk" "瑱")
("arb/" "瑵")
("ari;" "瑲")
("arzv" "瑧")
("arav" "瑮")
("ofqh" "甀")
("gjfh" "甂")
("lv,h" "甃")
("pop " "畽")
("fjpc" "疐")
("hyp " "瘖")
("hfjz" "瘈")
("hv;e" "瘌")
("hetb" "瘕")
("hm; " "瘑")
("hktz" "瘊")
("hff;" "瘔")
("jqtb" "皸")
("jjzh" "瞁")
("jpac" "睼")
("jlv," "瞅")
(".fjh" "瞂")
("jiue" "睮")
("bgdj" "瞀")
("tsaj" "睯")
("l/rf" "睾")
("j.fj" "瞃")
("gykd" "碲")
("grqk" "碪")
("gvpa" "碴")
("gpa." "碭")
("gpax" "碨")
("gof " "硾")
("gosb" "碫")
(";;;g" "碞")
("ggjf" "碥")
("gy;d" "碠")
("getb" "碬")
("gm; " "碢")
("gfjz" "碤")
("yhyd" "禘")
("yhfz" "禊")
("yhar" "禋")
("yhrv" "禖")
("yhtq" "禕")
("yhpc" "禔")
("yhp." "禓")
("yhpn" "禗")
("yhjq" "禈")
("yhw." "禒")
("yh.b" "禐")
("lvqp" "稫")
("lvbs" "穊")
("lvgu" "稰")
("lv.." "稯")
("lvgf" "稨")
("lvtq" "稦")
("nkyp" "窨")
("nkfz" "窫")
("nkie" "窬")
("ybif" "竮")
("lcx;" "箈")
("lnkq" "箜")
("lhkh" "箊")
("latc" "箑")
("lru " "箐")
("lvv " "箖")
("loqd" "箍")
("laxe" "箌")
("lgfk" "箛")
("les " "箎")
("lpae" "箅")
("lplv" "箘")
("li;e" "劄")
("lujb" "箙")
("lykf" "箤")
("lvkk" "箂")
(",qx " "粻")
(",pv " "粿")
(",mqs" "粼")
(",lpf" "粺")
("xy;f" "綧")
("xykf" "綷")
("x,, " "緂")
("xizs" "綣")
("xru " "綪")
("xatc" "緁")
("xatw" "緀")
("xaeb" "緅")
("xvv " "綝")
("xqax" "緎")
("xpqq" "緄")
("xpl." "緆")
("xee " "緋")
("xlvw" "緌")
("xlod" "綯")
("x.k;" "綹")
("xleb" "綖")
("xlpf" "綼")
("xgzh" "綟")
("rakx" "綦")
("g.x " "綮")
("xnms" "綩")
("xy;c" "綡")
("xajk" "緉")
("/pn " "罳")
("jr;b" "翢")
("bbyw" "翣")
("rlpb" "翥")
("bbyc" "翞")
("fkrp" "耤")
("aeqx" "聝")
("aenq" "聜")
("uiku" "膉")
("urx " "膆")
("u/u " "膃")
("ulen" "膇")
("ulpq" "膍")
("uk,u" "膌")
(",,ju" "膋")
("af;," "舕")
("fchx" "蒗")
("fciv" "蒤")
("fykh" "蒡")
("fyl;" "蒟")
("fhoz" "蒺")
("fnt;" "蓎")
("fjpk" "蓂")
("fjjh" "蒬")
("fjky" "蒮")
("firq" "蒫")
("fitc" "蒹")
("fidu" "蒴")
("fzlv" "蓁")
("frlp" "蓍")
("fqhh" "蒪")
("fqjd" "蒚")
("foqh" "蒱")
("fzah" "蓐")
("fzlc" "蒝")
("fzex" "蒧")
("ftgk" "蒻")
("ftiv" "蒢")
("fprh" "蒔")
("fmu " "蓇")
("fkk." "蓌")
("fofk" "蒛")
("flva" "蒩")
("fuue" "蒯")
("fkru" "蒨")
("flpq" "蓖")
("fw;o" "蒘")
("fxkj" "蒶")
("f.xk" "蓏")
("fljn" "蒠")
("f.rc" "蓗")
("fir," "蓔")
("fqaf" "蓒")
("fvj." "蓛")
("flmb" "蒰")
("f.tb" "蒑")
("ewak" "虡")
("/y;f" "蜳")
("/irs" "蜣")
("/atc" "蜨")
("/rlp" "蝫")
("/vp " "蝀")
("/qax" "蜮")
("/rak" "蜞")
("/rp " "蜡")
("/vkx" "蜙")
("/bf;" "蜛")
("/bbb" "蝃")
("/gcd" "蜬")
("aea/" "蝁")
("/pv " "蜾")
("/dff" "蝆")
("/plv" "蜠")
("/lvw" "蜲")
("/lod" "蜪")
("/jo " "蜭")
("/ky " "蜼")
("/leb" "蜒")
("/os " "蜺")
("/lpf" "蜱")
("/e " "蜵")
("/d.b" "蝂")
("/ijf" "蜦")
("/gzh" "蜧")
("qdt/" "蜸")
("vo/ " "蜤")
("ee/ " "蜚")
("utd/" "蜰")
("leb/" "蜑")
("ykis" "裷")
("yk,," "裧")
("ykrx" "裱")
("ykak" "裲")
("ykzs" "裺")
("ykb;" "裾")
("ykpp" "裮")
("ykp." "裼")
("ykee" "裶")
("eacx" "裻")
("ykbb" "裰")
("ykr." "裬")
("yke " "裫")
("af,s" "覝")
("qkks" "覡")
("rnjs" "覟")
("jsjs" "覞")
("jf,h" "觩")
("jv; " "觫")
("jqc " "觨")
("yzax" "誫")
("yawq" "誙")
("ytsn" "誋")
("yxoz" "誒")
("yhtx" "誏")
("yfjf" "誖")
("kk;;" "谽")
("a..d" "豨")
("a.a." "豩")
("mf,h" "賕")
("mm " "賏")
("m;;d" "賗")
("rckr" "趖")
("shtx" "踉")
("saes" "踂")
("src " "跿")
("srlf" "踍")
("stsn" "跽")
("sbjf" "踊")
("scu " "踃")
("sosz" "踇")
("sxk." "踆")
("oo;c" "踅")
("kd.c" "跾")
("s;c " "踀")
("sec " "踄")
("qnas" "輐")
("qtl;" "輑")
("qcu " "輎")
("qkk;" "輍")
("ypft" "鄣")
("yqqt" "鄜")
("zaat" "鄠")
("aeat" "鄢")
("zfht" "鄟")
("bbkt" "鄝")
("fpzt" "鄚")
("p/bt" "鄤")
("lvt " "鄡")
("wpvt" "鄛")
("apqh" "酺")
("ap;r" "酲")
("ap.h" "酹")
("apxu" "酳")
("iylx" "銥")
("i, " "銤")
("iafe" "鉶")
("iaf;" "銛")
("iae " "鉺")
("irlq" "銠")
("izf " "銔")
("izu " "銪")
("iaxr" "銍")
("ipz " "銦")
("is, " "銚")
("ijts" "銫")
("imm " "鉹")
("i.q " "銗")
("ii; " "鉿")
("iw; " "銣")
("izgx" "鋮")
("qshi" "銎")
("iadd" "銂")
("iztg" "銕")
("ihb " "銢")
("iaqx" "鉽")
("irr " "銈")
("ir; " "銡")
("izax" "銊")
("ialp" "銆")
("izdf" "銌")
("izag" "銙")
("icas" "銧")
("ixof" "鉾")
("ifk " "銇")
("iarx" "銩")
("ikv " "銝")
("ikar" "銋")
("eqi " "鈭")
("trh." "隞")
("tnor" "隡")
("zs, " "雿")
("rujs" "靘")
("rfi " "靽")
("rfva" "靺")
("rfrs" "靾")
("rftx" "鞃")
("rfj;" "鞀")
("rflv" "鞂")
("rfua" "靻")
("rfls" "鞄")
("rftb" "鞁")
("rfxb" "靿")
("t;qa" "韎")
("t;qh" "韍")
("ialm" "頖")
("xe; " "颭")
("xlts" "颮")
("iba;" "餂")
("ibf." "餀")
("ibjq" "餇")
("lvpl" "馝")
("lvpq" "馜")
("g,tk" "駃")
("g,p " "馹")
("g,xs" "馻")
("g,lb" "馺")
("qfg," "駂")
("g,;d" "馽")
("g,. " "駇")
("muke" "骱")
("z.h " "髣")
("z.js" "髧")
("oxfb" "鬾")
("oxo " "鬿")
("u,lq" "魠")
("u,lh" "魡")
("u,q " "魟")
("afl," "鳱")
("bl, " "鳲")
("sfl," "鳵")
("fkks" "麧")
("knrr" "僿")
("kypa" "儃")
("kfh," "儰")
("kvvc" "僸")
("kfl." "儆")
("k/qx" "儇")
("kjaa" "僶")
("k.j." "僾")
("kjzy" "儋")
("klp." "儌")
("klvn" "僽")
("kvvc" "儊")
(";;;e" "劋")
("ezae" "劌")
("fpmb" "勱")
("yp;b" "勯")
(";y;h" "噈")
(";iph" "噂")
(";k/p" "噌")
(";rrs" "嘵")
(";aen" "噁")
(";bg;" "噊")
(";qe." "噉")
(";qsp" "噆")
(";zik" "噘")
(";tqh" "噚")
(";tsk" "噀")
(";;dm" "嘳")
(";;;f" "嘽")
(";pab" "嘬")
(";a/f" "嘾")
(";or," "嘸")
(";/m " "嘪")
(";lz;" "嘺")
("p;dm" "圚")
("riph" "墫")
("rrrs" "墝")
("rbqi" "墱")
("r;;f" "墠")
("rcaz" "墣")
("nzqr" "墯")
("tw.r" "墬")
("rypr" "墥")
("rir;" "墡")
("riph" "壿")
("wtra" "嫿")
("wf;f" "嫴")
("wzkc" "嫽")
("wtzu" "嫷")
("wky," "嫶")
(".alw" "嬃")
("wir;" "嫸")
("wypx" "嬂")
("wrpk" "嫹")
("wbqi" "嬁")
("w;dm" "嬇")
("wfaf" "嬅")
("wl,p" "嬏")
("b.rv" "屧")
("d,mq" "嶙")
("d,,b" "嶗")
("diph" "嶟")
("dk/p" "嶒")
("drrs" "嶢")
("dl,p" "嶓")
("dky," "嶕")
("dlz;" "嶠")
("dqsp" "嶜")
("dzik" "嶡")
("dzkc" "嶚")
("tzqd" "嶞")
("jdfm" "幩")
("jd;f" "幝")
("jdo," "幠")
("jdpc" "幜")
("nfjx" "緳")
("nprr" "廛")
("nijk" "廞")
("nor," "廡")
("tgrk" "彉")
(".bcf" "徲")
(",.n " "憋")
("zon " "憃")
("rifn" "慹")
("ny;h" "憱")
("nbg;" "憰")
("nrrs" "憢")
("nr;." "憉")
("na/f" "憛")
("nzn " "憓")
("nqsp" "憯")
("nzkc" "憭")
("na/," "憟")
("n;dm" "憒")
("neu " "憪")
("nlvj" "憡")
("nlz;" "憍")
("f,hn" "慦")
("ntqh" "憳")
("napx" "戭")
("rh.o" "摮")
("rkro" "摰")
("oqe." "撖")
("ofpx" "撠")
("ozik" "撅")
("orpk" "撗")
("obqi" "撜")
("otqh" "撏")
("oear" "撋")
("oeu " "撊")
("o;dm" "撌")
("o;;f" "撣")
("olz;" "撟")
("obcf" "摨")
("otzu" "撱")
("oli;" "撘")
("tvp." "敶")
("q;;b" "敺")
("eja." "敹")
("jjk." "敻")
("stgo" "斲")
("rro " "斳")
("prz " "暵")
("p.kc" "暰")
("pmac" "暩")
("pypf" "暲")
("pzfh" "暷")
("prjk" "暪")
("pfpz" "暯")
("vyk;" "樀")
("vy.m" "樆")
("vzag" "樗")
("vfft" "槥")
("vrkh" "槸")
("vv;k" "樕")
("vap," "槱")
("vqn " "槤")
("vrjk" "樠")
("vrr " "槿")
("vzak" "槬")
("vbbp" "槢")
("vbb." "樛")
("veua" "樝")
("vp/b" "槾")
("v.vb" "樧")
("vjhf" "槲")
("vxx." "槮")
("vwpv" "樔")
("rkrv" "槷")
("qov " "槧")
("vzou" "橀")
("vyps" "樈")
("vntf" "槦")
("vzjs" "槻")
("vrm " "樍")
("zjsv" "槼")
("vzfh" "槫")
("vz.." "樉")
("vtvp" "樄")
("vcjr" "樘")
("vf.f" "樥")
("vpx " "樏")
("vpqx" "槶")
("vlyr" "樦")
("vkdu" "樇")
("vg;s" "槴")
("i;vd" "樖")
("elik" "歑")
("amnk" "殥")
("amrr" "殣")
("amrd" "殢")
("aml," "殦")
("lqfz" "氁")
("p;dq" "氀")
("xxxq" "毿")
("av.q" "氂")
("qcam" "潁")
("av.c" "漦")
("c,mq" "潾")
("c,,b" "澇")
("cffm" "濆")
("cqam" "澒")
("cr;h" "澍")
("cqe." "澉")
("crao" "澌")
("crpk" "潢")
("cbg;" "潏")
("ctra" "澅")
("ctde" "潚")
("cev " "澖")
("cp, " "潶")
("c;;f" "潬")
("cda." "澂")
("cor," "潕")
("clvu" "潲")
("cjp." "潒")
("cky," "潐")
("ckyv" "潗")
("clp;" "澔")
("c.o." "澓")
("ci;b" "潝")
("rbsc" "漀")
("cy;." "潡")
("cizx" "潫")
("cicp" "潽")
("ck/p" "潧")
("czax" "澐")
("czn " "潓")
("cpyc" "澋")
("cprk" "潩")
("cptq" "潿")
("cfaf" "澕")
("cey." "潣")
("cltf" "潷")
("cozp" "潪")
("clvc" "潻")
("q,am" "熲")
(",rz " "熯")
(",a/c" "熛")
(",q;;" "熰")
(",bbp" "熠")
(",pff" "熚")
(",g;s" "熩")
(",yk;" "熵")
(",yqq" "熝")
(",bjn" "熥")
(",qdr" "熞")
(",bby" "熤")
(",p;w" "熡")
(",lvm" "熪")
(",lpn" "熜")
(".kk," "熧")
(",p/b" "熳")
("nvvf" "犘")
("baaf" "犚")
(",.zh" "獘")
("rh.h" "獒")
(".ypr" "獞")
(".rrs" "獟")
(".zkc" "獠")
(".bg;" "獝")
(".caz" "獛")
(".ol," "獡")
(".rpk" "獚")
(".,. " "獙")
(".lz;" "獢")
("arhc" "璇")
("arqn" "璉")
("arrk" "璊")
("arb." "璆")
("arln" "璁")
("ar.c" "瑽")
("arwv" "璅")
("arr." "璈")
("arzh" "瑼")
("arfv" "瑹")
("ljvh" "甈")
(",,jh" "甇")
("ppp " "畾")
("hirq" "瘥")
("hzkr" "瘞")
("hbh/" "瘙")
("h/c " "瘝")
("hljn" "瘜")
("hox " "瘣")
("hidk" "瘚")
("hfuk" "瘨")
("hfjn" "瘛")
("lpy;" "皜")
("lpas" "皝")
("lplf" "皞")
("lplp" "皛")
("jodb" "瞍")
("/r;x" "瞏")
("vajb" "瞉")
("jkxb" "瞈")
("gnr;" "磍")
("gy;;" "碻")
("gitc" "磏")
("gfuk" "磌")
("gdqi" "磑")
("g.xz" "磎")
("gmqv" "磔")
("gox " "磈")
("g.es" "磃")
("gnt;" "磄")
("gbbv" "磉")
("yhi," "禚")
("yhg," "禡")
("yh.s" "禠")
(",,jc" "禜")
("yhpb" "禢")
("yhfk" "禛")
("eqpm" "歶")
("lvfk" "稹")
("nk,f" "窲")
("nkfk" "窴")
("nk.k" "窳")
("lhos" "箷")
("lqzk" "篋")
("lcue" "箾")
("lfz;" "箬")
("ljcl" "篎")
("lka." "箯")
("lxlh" "箹")
("lcrk" "篊")
("lclj" "箵")
(",bgv" "糅")
(",gcu" "糈")
(",.kp" "糌")
(",iue" "糋")
("xjq " "緷")
("xalz" "緛")
("xnaa" "緪")
("xip " "緧")
("xvj " "緗")
("xtsp" "緡")
("xgcu" "縃")
("xm; " "緺")
("xpn " "緦")
("xka." "緶")
("xktz" "緱")
("xiue" "緰")
("xop." "緮")
("xop " "緟")
("/ohp" "罶")
("ifzx" "羬")
("ifd," "羰")
("ifie" "羭")
("bbkz" "翭")
("bbls" "翫")
("bb.." "翪")
("bbjq" "翬")
("iueb" "翦")
("bbpc" "翨")
("aeyd" "聤")
("aebz" "聧")
("unkr" "膣")
("uyxf" "膟")
("uzfh" "膞")
("upqx" "膕")
("up;w" "膢")
("utg/" "膙")
("udky" "膗")
("if;h" "舖")
("lmij" "艏")
("lmrv" "艓")
("lmpj" "艒")
("lm.." "艐")
("lmlr" "艎")
("lmgf" "艑")
("fnnd" "蔤")
("fnab" "蔻")
("fyk;" "蔏")
("fy;t" "蔀")
("fnak" "蔩")
("fysb" "蔎")
("fykx" "蔉")
("fyqq" "蔍")
("fhoz" "蔟")
("f,pf" "蔊")
("ffft" "蔧")
("frh." "蔜")
("frih" "蓻")
("fae," "蔫")
("frkh" "蓺")
("fa/c" "蔈")
("fv;k" "蔌")
("fzfh" "蓴")
("fqo " "蔪")
("fq;;" "蓲")
("frjd" "蔕")
("foky" "蓷")
("fa.n" "蓫")
("frr " "蓳")
("fbb." "蓼")
("ftl," "蔒")
("fbjn" "蓪")
("fbgb" "蓩")
("feua" "蔖")
("feph" "蓾")
("fpis" "蔨")
("fj, " "蔝")
("fpqx" "蔮")
("fpx " "蔂")
("fpff" "蓽")
("fp;w" "蔞")
("f;ky" "蓶")
("f.vb" "蔱")
("fl, " "蔦")
("fkdv" "蓧")
("fkdu" "蓨")
("f.ec" "蓰")
("f.kc" "蓯")
("f.oj" "蓹")
("fxx." "蔘")
("fx.h" "蔠")
("fg;s" "蔰")
("fceb" "蔋")
("fhoc" "蔙")
("ftvp" "蔯")
(".fhs" "虢")
("/naa" "蝖")
("/hof" "蝣")
("/ip " "蝤")
("/nid" "蝷")
("/hl," "蟡")
("/rsz" "蝳")
("/qpw" "蝘")
("/qqp" "蝔")
("/zax" "蝛")
("/ale" "蝒")
("/alz" "蝡")
("/bgv" "蝚")
("/gcu" "蝑")
("/bj " "蝞")
("/pac" "蝭")
("/pa." "蝪")
("/pj " "蝐")
("/pls" "蝎")
("/pu " "蝟")
("/w. " "蝝")
("/.ab" "蝯")
("/.d." "蝬")
("/l;m" "蝺")
("/op." "蝮")
("/jm " "蝜")
("bgd/" "蝥")
("/y;d" "蝏")
("/fjf" "蝻")
("lv,/" "蝵")
("/alm" "蝢")
("/fjz" "蝧")
("/op " "蝩")
(".f;d" "衚")
("ykyd" "褅")
("ykjq" "褌")
("ykqp" "褔")
("ykrv" "褋")
("ykqw" "褗")
("yktq" "褘")
("ykeu" "褙")
("ypac" "褆")
("ykw." "褖")
("yk.b" "褑")
("yolx" "褎")
("ykfz" "褉")
(",,js" "覢")
("esjs" "覤")
("lvws" "覣")
("jzqd" "觭")
("jrlp" "觰")
("jos " "觬")
("yaeb" "諏")
("yrak" "諆")
("ytgx" "誸")
("yaxx" "諓")
("ya.h" "諑")
("yeab" "諔")
("yes " "諕")
("ycp " "誻")
("yign" "諗")
("ey " "誾")
("ylpf" "諀")
("raky" "諅")
("yrlx" "諘")
("yvv " "諃")
("yvkk" "誺")
("yos " "誽")
("yoap" "諙")
("kk;q" "谾")
("qilf" "豍")
(".lpf" "貏")
("mykf" "賥")
("mjrk" "賟")
("mjr;" "賙")
("naam" "賨")
("vkkm" "賚")
("mjkv" "賝")
("m,, " "賧")
("rcef" "趠")
("rcl," "趜")
("rcky" "趡")
("rci " "趛")
("snms" "踠")
("sy; " "踣")
("syw " "踥")
("sykf" "踤")
("sne;" "踮")
("satc" "踕")
("srkr" "踛")
("srp " "踖")
("srak" "踑")
("saeb" "踙")
("szqd" "踦")
("seab" "踧")
("sepf" "踔")
("slvw" "踒")
("sl, " "踘")
("sky " "踓")
("srk." "踜")
("sign" "踗")
("sijf" "踚")
("qy;c" "輬")
("qru " "輤")
("qrk." "輘")
("qaxx" "輚")
("qpv " "輠")
("quu " "輣")
("qjr;" "輖")
("qos " "輗")
("fkkn" "遳")
("rjjn" "遰")
("ua.n" "遯")
("ypfn" "遧")
("v;.n" "遫")
("irit" "鄯")
("k/pt" "鄫")
("tq;t" "鄩")
("tget" "鄪")
(";;pt" "鄲")
("or,t" "鄦")
("ohjt" "鄮")
("apy;" "醅")
("apax" "醆")
("apbb" "醊")
("apwc" "醁")
("apvv" "醂")
("apld" "醄")
("apky" "醀")
("inzx" "鋐")
("ihtx" "鋃")
("ia,b" "鋄")
("iqi " "鋀")
("iat;" "鋙")
("if,h" "銶")
("izkk" "鋏")
("ianx" "鋱")
("itjb" "鋟")
("i;gz" "鋘")
("ifys" "鋩")
("i;u " "鋗")
("i.fh" "鋝")
("ilrb" "鋌")
("io; " "鋯")
("iosz" "鋂")
("ilox" "鋨")
("ikk;" "鋊")
("clzi" "鋈")
("inas" "鋎")
("ibg;" "鋦")
("ifjf" "鋍")
("irn " "鋕")
("iv; " "鋉")
("izax" "鋠")
("iawq" "鋞")
("ijs " "鋧")
("ixk." "鋑")
("ilve" "鋓")
("i. " "銵")
("iig;" "鋡")
("rlai" "鋆")
("ooi " "銴")
("zbdd" "镼")
("ehtx" "閬")
("epv " "閫")
("elrb" "閮")
("eo " "閰")
("t;dm" "隤")
("trrs" "隢")
("ivky" "雓")
("zy " "霅")
("zcad" "霈")
("zcv " "霂")
("rujs" "靚")
("rfr;" "鞊")
("rftx" "鞎")
("rfi;" "鞈")
("t;q;" "韐")
("iztq" "韏")
("nwam" "頞")
("yk.m" "頝")
("yxkm" "頦")
("ifam" "頩")
("bbam" "頨")
("jzgm" "頠")
("fkam" "頛")
("leam" "頧")
("xame" "颲")
("aajx" "餈")
("eqix" "飺")
("ibff" "餑")
("ibqh" "餔")
("ibqi" "餖")
("ibv;" "餗")
("ibx." "餕")
("g,nl" "駜")
("g,ai" "駍")
("g,qt" "駏")
("g,za" "駓")
("g,ua" "駔")
("g,pf" "駎")
("g,j;" "駉")
("g,ib" "駖")
("g,x;" "駘")
("g,j;" "駋")
("g,k." "駗")
("mgs," "駌")
("mutb" "骳")
("z.za" "髬")
("z.j;" "髫")
("z.bl" "髳")
("z.tb" "髲")
("z.ls" "髱")
("oxqx" "魆")
("oxzh" "魃")
("u,ys" "魧")
("u,h " "魴")
("u,aw" "魱")
("u,cl" "魦")
("u,jk" "魶")
("u,kj" "魵")
("u,y." "魰")
("u,as" "魨")
("u,kq" "魤")
("u,zb" "魬")
("y.l," "鳼")
("zl, " "鳺")
("afl," "鳽")
("arl," "鳿")
("fbl," "鳷")
("qfl," "鴇")
("zl, " "鴀")
("igl," "鳹")
("kjl," "鳻")
("zkl," "鴈")
("jyl," "鴅")
("qkl," "鴄")
("yqq," "麃")
("p,ax" "黓")
("jjg " "鼏")
("lgjg" "鼐")
("knnd" "儜")
("kr;r" "儓")
("kqoc" "儗")
("kf/m" "儚")
("kpx," "儑")
("kdq," "凞")
("qljf" "匴")
("ejab" "叡")
(";ysy" "噰")
(";rin" "噠")
(";/qx" "噮")
(";e;z" "噳")
(";ezx" "噦")
(";/l/" "噣")
(";lp." "噭")
(";i/p" "噲")
(";i;k" "噞")
(";ypk" "噷")
("p/qx" "圜")
("p/rf" "圛")
("rypv" "壈")
("rlp." "墽")
("rea." "壉")
("r/rf" "墿")
("rljz" "墺")
("brkr" "壂")
("qdsr" "墼")
("o..r" "壆")
("wypa" "嬗")
("wfk;" "嬙")
("w/qx" "嬛")
("w.j." "嬡")
("wj;r" "嬔")
("wlp." "嬓")
("wi;k" "嬐")
("b;yw" "嬖")
("wixn" "嬨")
("wnic" "嬚")
("w;;v" "嬠")
("wfop" "嬞")
("nkyd" "寯")
("dirx" "嶬")
("dfps" "嶱")
("dpfx" "嶩")
("d/rf" "嶧")
("d/ee" "嶵")
("djjf" "嶰")
("di;k" "嶮")
("dcav" "嶪")
("o..d" "嶨")
("dkyd" "嶲")
("dlef" "嶭")
("d;ax" "嶯")
("ljld" "嶴")
("jd;v" "幧")
("jdjy" "幨")
("b;yd" "幦")
("jdlj" "幯")
("nypv" "廩")
("nfk;" "廧")
("nb;f" "廦")
("njjf" "廨")
("ni/p" "廥")
("tg/x" "彋")
(".lp." "徼")
("y;gn" "憝")
("qe.n" "憨")
("vkkn" "憖")
("nea." "懅")
("njaa" "憴")
("n;;v" "懆")
("n/qx" "懁")
("n/rf" "懌")
("njzy" "憺")
("nlp." "憿")
("ni;k" "憸")
("ilan" "憌")
("ob;f" "擗")
("ofps" "擖")
("o/qx" "擐")
("ofl." "擏")
("o/l/" "擉")
("olp." "撽")
("y;go" "撉")
("opfx" "擃")
("ofrv" "擛")
("olbj" "擳")
("oljz" "擙")
("fbth" "攳")
("lz;." "敿")
("r;ib" "敼")
("rpkf" "斢")
("pypr" "曈")
("py;." "暾")
("pvqi" "曀")
("ptgm" "曊")
("pa/f" "曋")
("psxt" "曏")
("p,mq" "暽")
("ppyc" "暻")
("p;;f" "暺")
("punq" "曌")
("uypr" "朣")
("vypx" "樴")
("vypr" "橦")
("v,mq" "橉")
("vk/p" "橧")
("vaax" "樲")
("vffm" "橨")
("vrcx" "樾")
("va/f" "橝")
("vf;f" "橭")
("vfpx" "橶")
("vzik" "橛")
("vzkc" "橑")
("vbcf" "樨")
("vtde" "橚")
("v;dm" "樻")
("v;;f" "樿")
("vllp" "橁")
("vmz," "橪")
("nnnv" "橤")
("qdjv" "橐")
("vir;" "橏")
("vy;." "橔")
("v,,b" "橯")
("v,,s" "橩")
("vymx" "橠")
("vbgf" "樼")
("vzn " "橞")
("vcjv" "橖")
("vcjl" "橕")
("vear" "橍")
("vl,p" "橎")
("orvv" "橆")
("ffmk" "歕")
("ewak" "歔")
("r;ik" "歖")
("amyh" "殧")
("amvi" "殪")
("am;f" "殫")
("ohdb" "毈")
("o,sb" "毇")
("bgdq" "氄")
("yprq" "氃")
("lqip" "氆")
("cysy" "澭")
("cvvc" "濋")
("cfpf" "澣")
("cfk;" "濇")
("cb;f" "澼")
("cjg " "濎")
("c;ax" "濈")
("cs.;" "潞")
("cm;n" "濄")
("cea." "澽")
("ce;z" "澞")
("cezx" "濊")
("clqk" "澨")
("clbj" "瀄")
("cjjf" "澥")
("ci/p" "澮")
("cypn" "澺")
("caam" "澬")
("czib" "澪")
("carl" "濏")
("cvvc" "澿")
("czqx" "澸")
("ccjp" "澢")
("cjky" "濉")
("cfpm" "澫")
("cfln" "濍")
("cem," "澯")
("ccav" "澲")
("ci;k" "澰")
("rkr," "燅")
(",a/f" "燂")
(",rpk" "熿")
(",qsp" "熸")
(",tqh" "燖")
(",;;f" "燀")
(",faf" "燁")
(",ky," "燋")
(",l,p" "燔")
(",,,v" "燊")
(",iph" "燇")
(",bg;" "燏")
(",tde" "熽")
(",ey." "燘")
(",prk" "熼")
(",lz;" "燆")
(",,,," "燚")
("tdq," "燛")
("ofyr" "犝")
("ofl;" "犞")
(".ezx" "獩")
(".fps" "獦")
("./qx" "獧")
(".jjf" "獬")
(".lp." "獥")
(".i;k" "獫")
(".i/p" "獪")
("qozh" "瑿")
("arb;" "璚")
("arlp" "璠")
("arkp" "璔")
("arbi" "璒")
("arth" "璕")
("arkn" "璡")
("ykjh" "甋")
("wpac" "疀")
("hhoz" "瘯")
("ha/c" "瘭")
("hzkn" "瘱")
("hrr " "瘽")
("hbb." "瘳")
("hfpz" "瘼")
("hmac" "瘵")
("h.kc" "瘲")
("hpx " "瘰")
("euab" "皻")
("igau" "盦")
("jnak" "瞚")
("jy.m" "瞝")
("jzjs" "瞡")
("jp;w" "瞜")
("j.kc" "瞛")
("f/jj" "瞢")
("j;;n" "瞣")
("jypf" "瞕")
("jfpz" "瞙")
("jl, " "瞗")
("grh." "磝")
("gzex" "磩")
("gpx " "磥")
("gdky" "磪")
("gduu" "磞")
("gxx." "磣")
("qog " "磛")
("grqb" "磡")
("gz.." "磢")
("gzau" "磭")
("gbb." "磟")
("geph" "磠")
("yh/b" "禤")
("lvmc" "穄")
("nvvv" "穈")
("lvx." "穇")
("nkpw" "窶")
("nkln" "窸")
("nkl," "窵")
("nkkv" "窱")
("nkaj" "窷")
("lcpq" "篞")
("lykh" "篣")
("ljky" "篧")
("lrjr" "篝")
("lrxu" "篕")
("la/v" "篥")
("lqee" "篚")
("ltiv" "篨")
("ljzs" "篹")
("l;m " "篔")
("l.es" "篪")
("lqm " "篢")
("lgc," "篜")
("lqso" "篫")
("lldd" "篘")
("lkru" "篟")
(",rlf" "糒")
(",bh/" "糔")
(",ljh" "糗")
(",qhh" "糐")
(",tgk" "糑")
("xirq" "縒")
("xnyf" "縡")
("xypx" "縗")
("xidn" "縌")
("xzah" "縟")
("vaxb" "縠")
("xzlc" "縓")
("xmu " "縎")
("x;m " "縜")
("x/u " "縕")
("x.o " "縚")
("uizx" "縢")
("xlen" "縋")
("lmsx" "縏")
("xnr;" "縖")
("xykh" "縍")
("xbbv" "縔")
("xzlv" "縥")
("xrx " "縤")
(",,jd" "罃")
("/bah" "罻")
("/pff" "罼")
("/wpv" "罺")
("ifzc" "羱")
("bby;" "翯")
("fkyh" "耪")
("fkrr" "耩")
("aekb" "聬")
("uypx" "膱")
("u,mq" "膦")
("urrs" "膮")
("uffm" "膹")
("ufyf" "膵")
("uzkc" "膫")
("ul,p" "膰")
("ulqq" "膬")
("uor," "膴")
("uky," "膲")
("usxt" "膷")
("uypr" "膧")
("ljvs" "臲")
("lmyh" "艕")
("lmiq" "艖")
("lmiu" "艗")
("fcqv" "蕖")
("fcpm" "蕅")
("fypr" "蕫")
("fcie" "蕍")
("fzax" "蕓")
("fffm" "蕡")
("frrs" "蕘")
("fvjj" "蕀")
("fzmx" "蕆")
("fa.r" "蕤")
("ftqh" "蕁")
("f;dm" "蕢")
("fen " "蕄")
("feu " "蕑")
("f;;f" "蕇")
("f.jq" "蕣")
("flvv" "蔾")
("flvl" "蕛")
("flvu" "蕱")
("flz;" "蕎")
("fol," "蕮")
("fmix" "蕵")
("f.ip" "蕕")
("f.o." "蕧")
("fw;x" "蕠")
("fsxt" "薌")
("f.am" "蕦")
("fxjs" "蕝")
("frib" "蕔")
("fqdy" "蕥")
("fxx " "蕬")
("aaes" "虣")
("esax" "虥")
("eses" "虤")
("/nr;" "螛")
("/hoz" "螏")
("/nt;" "螗")
("/zlv" "螓")
("fpf/" "螒")
("/zlc" "螈")
("/txn" "螁")
("/mu " "螖")
("/dqi" "螘")
("//u " "蝹")
("/.xz" "螇")
("uiz/" "螣")
("/ljn" "螅")
("/l, " "螐")
("/ljh" "螑")
("/ox " "螝")
("/led" "螄")
("/.es" "螔")
("vas/" "螜")
("xuq/" "螚")
("/kxb" "螉")
("yk/u" "褞")
("ykxq" "褦")
("nrkx" "褰")
("yg,x" "褭")
(",,jx" "褮")
("ae,x" "褧")
("y/cx" "褱")
("yoxx" "褢")
("lmsx" "褩")
("ykn;" "褣")
("yknd" "褯")
("ykbv" "褬")
("ykpb" "褟")
("zqxj" "觱")
("ynaa" "諠")
("yjq " "諢")
("ya/r" "諲")
("yzqx" "諴")
("yfjf" "諵")
("ygcu" "諝")
("yeqa" "謔")
("y;;g" "諤")
("ypac" "諟")
("ypn " "諰")
("yof " "諈")
("ygjf" "諞")
("yigu" "諡")
("yqp " "諨")
("y;ae" "諿")
("ydae" "諯")
("ylpr" "諻")
(".etb" "貑")
(".dae" "貒")
(".iue" "貐")
("mpj " "賵")
("tdam" "賮")
("mjq " "賱")
("mzp " "賰")
("mr;x" "賳")
("rcem" "赬")
("rceb" "赮")
("rcip" "趥")
("rcpc" "趧")
("szp " "踳")
("sqp " "踾")
("srqk" "踸")
("srsv" "蹀")
("svpa" "蹅")
("spac" "踶")
("spa." "踼")
("sl;m" "踽")
("sgjf" "蹁")
("siue" "踰")
("slv," "踿")
(".qpw" "躽")
("qip " "輶")
("qbgv" "輮")
("qpls" "輵")
("qdae" "輲")
("qop." "輹")
("qly " "輷")
("q.fj" "輴")
("rrrn" "遶")
("bgdn" "遹")
(";;in" "遻")
("bqin" "邆")
("mmws" "郺")
("jaat" "鄳")
(";;;t" "鄵")
("i/pt" "鄶")
("apju" "醓")
("apfu" "醐")
("apgu" "醑")
("appc" "醍")
("aprp" "醏")
("ine " "錧")
("iy;f" "錞")
("iizs" "錈")
("i,, " "錟")
("iru " "錆")
("iaea" "錏")
("irlp" "鍺")
("ivkk" "錸")
("izac" "錼")
("izff" "錛")
("ibbb" "錣")
("itqd" "錒")
("ipv " "錁")
("ie " "鍆")
("ijr;" "錭")
("ijo " "錎")
("ilpf" "錍")
("ileb" "鋋")
("inac" "錝")
("inms" "鋺")
("izu " "錥")
("iirs" "錓")
("iqx " "鋹")
("iaeb" "鋷")
("irkr" "錴")
("irk." "錂")
("irak" "錤")
("icj;" "鋿")
("ipp " "錩")
("ieu " "錹")
("ifkq" "錵")
("ijrk" "錪")
("icp " "錔")
("idzf" "錌")
("iuu " "錋")
("ilod" "鋾")
("ioap" "錉")
("iijf" "錀")
("qdti" "鋻")
("eaci" "錖")
("ehkh" "閼")
("erlp" "闍")
("eqax" "閾")
("ezps" "閹")
("epy." "閺")
("epp " "閶")
("e.jb" "閿")
("eky " "閵")
("eoap" "閽")
("tljz" "隩")
("kyky" "雔")
("zatw" "霋")
("zaag" "霒")
("zctx" "霐")
("rf;u" "鞙")
("kd.f" "鞗")
("rfjs" "鞔")
("emba" "韰")
("yp.f" "韸")
("tl;m" "頵")
("mfam" "頯")
("lrbm" "頲")
("ib,," "餤")
("ibbb" "餟")
("iblw" "餧")
("ibkk" "餩")
("lvpf" "馞")
("g,y." "駮")
("g,ae" "駬")
("g,ax" "駥")
("g,ar" "駤")
("g,pz" "駰")
("g,s," "駣")
("g,os" "駪")
("g,ir" "駩")
("g,jq" "駧")
("muy." "骹")
("muif" "骿")
("mueq" "骴")
("muzg" "骻")
("z.ae" "髶")
("z.l;" "髺")
("z.kv" "髹")
("z.pf" "髷")
("eqjd" "鬳")
("u,nq" "鮀")
("u,nl" "鮅")
("u,av" "鮇")
("u,rx" "魼")
("u,za" "魾")
("u,pd" "魻")
("u,pk" "鮂")
("u,oe" "鮓")
("u,kh" "鮒")
("u,x;" "鮐")
("u,qd" "魺")
("u,f;" "鮕")
("u,ra" "魽")
("u,l;" "鮈")
("l,nk" "鴥")
("yl, " "鴗")
("pal," "鴠")
(";ag," "鴞")
("lnl," "鴔")
("ozl," "鴩")
("l;l," "鴝")
("xfl," "鴘")
("xbl," "鴢")
("b;l," "鴐")
("ozl," "鴙")
("oas," "鴟")
("yqqr" "麈")
("yqqa" "麆")
("yqqv" "麇")
("fkkx" "麮")
("fkks" "麭")
("p,js" "黕")
("p,qs" "黖")
("ca,j" "黺")
("fljg" "鼒")
("ljps" "鼽")
("kyq," "儦")
("kr/m" "儥")
("kepn" "儢")
("kprc" "儤")
("kw/w" "儠")
("kmp." "儩")
("epnb" "勴")
(";nmc" "嚓")
(";yke" "嚌")
(";tdu" "嚍")
(";fy;" "嚆")
(";fkb" "嚄")
(";/cn" "嚃")
(";nkp" "噾")
(";qdu" "嚂")
(";bbf" "噿")
(";bby" "嚁")
("rzae" "壖")
("rrgh" "壔")
("rqdu" "壏")
("rfru" "壒")
("wak." "嬭")
("wbby" "嬥")
("pbwb" "嬲")
("wnnd" "嬣")
("wzae" "嬬")
("wtdu" "嬧")
("wrgh" "嬦")
("wr;r" "嬯")
("zpuw" "嬮")
("gftu" "孻")
("nxlv" "寱")
("nqoc" "寲")
("dqoc" "嶷")
("jdrh" "幬")
("jdf." "幪")
(".dy." "徾")
(".i/p" "徻")
("rrbn" "懃")
("b;yn" "憵")
("fl;n" "憼")
("nnnd" "懧")
("nyke" "懠")
("nfjc" "懥")
("nrgh" "懤")
("nzph" "懨")
("nfj." "懞")
("onam" "擯")
("ozae" "擩")
("orgh" "擣")
("ozph" "擫")
("olje" "擤")
("o.ek" "擨")
("/ri." "斁")
("/l/b" "斀")
("o/l/" "斶")
("hoac" "旚")
("plp." "曒")
("vypn" "檍")
("vi.n" "檖")
("vypv" "檁")
("virx" "檥")
("vaer" "檉")
("va/m" "檟")
("vm;n" "檛")
("v/rf" "檡")
("vjjf" "檞")
("vkyd" "檇")
("vorb" "檓")
("vkym" "檎")
("qdsv" "檕")
("t.qv" "檃")
("virk" "檨")
("viln" "檤")
("vzp " "檑")
("vapa" "橿")
("va/e" "檦")
("vvvc" "檚")
("vezx" "檅")
("v/ee" "檌")
("vvx " "檒")
("i;;k" "歛")
("amaa" "殭")
(";;;q" "氉")
("opcp" "濌")
("o..c" "澩")
("c,,c" "濴")
("cak." "濔")
("cfpf" "濣")
("ctdu" "濜")
("cfru" "濭")
("ccah" "濧")
("c.qn" "濦")
("clje" "濞")
("cvlb" "濲")
("crax" "濝")
("cbbf" "濢")
("cixn" "濨")
(",/rf" "燡")
(",ypn" "燱")
(",irx" "燨")
(",bbm" "燲")
(",fpm" "燤")
(",.j." "燰")
("o..," "燢")
(".zae" "獳")
(".ak." "獮")
(".o/," "獯")
("cpah" "璗")
("arin" "璲")
("arcp" "璫")
("ars;" "璐")
("ar;v" "璪")
("arjn" "璭")
("aral" "璱")
("arf." "璥")
("arip" "璯")
(",mqh" "甐")
("k/ph" "甑")
("or,h" "甒")
("r;ih" "甏")
("p,mq" "疄")
("ht.r" "癃")
("hbtb" "癈")
("h;;f" "癉")
("heu " "癇")
("lplp" "皤")
("rifu" "盩")
("j,mq" "瞵")
("ja/f" "瞫")
("jbg;" "瞲")
("jep " "瞷")
("j;dm" "瞶")
("jor," "瞴")
("jfaf" "瞱")
("jcaz" "瞨")
("ozkp" "矰")
("gk/p" "磳")
("grrs" "磽")
("gr;;" "礂")
("gl,p" "磻")
("gkyv" "磼")
("gcqv" "磲")
("gy;." "礅")
("ga/f" "磹")
("g;;f" "磾")
("glz;" "礄")
("yhaf" "禫")
("yhxx" "禨")
("lvyr" "穜")
("lvk," "穛")
("lvxx" "穖")
("lvrs" "穘")
("lvrk" "穔")
("lvl;" "穚")
("nkrk" "窾")
("nkas" "竀")
("nklq" "竁")
("lnor" "簅")
("lyqq" "簏")
("lfft" "篲")
("lrm " "簀")
("lzfh" "篿")
("la/c" "篻")
("lorp" "簎")
("la.n" "篴")
("ltxu" "簋")
("lpff" "篳")
("lpqx" "簂")
("lo;n" "簉")
("llvm" "簃")
("l.ec" "簁")
("lxx." "篸")
("l.oj" "篽")
("lna." "簆")
("ly;t" "篰")
("ly.m" "篱")
("lqjk" "簐")
("lrar" "簊")
(",tg/" "糨")
("xy.m" "縭")
("xhoc" "縼")
("xyxf" "繂")
("xzfh" "縳")
("qxam" "顈")
("xfpz" "縸")
("xpff" "縪")
("xjs," "繉")
("xdky" "繀")
("mofx" "繇")
("xmac" "縩")
("xlp." "繌")
("x.ec" "縰")
("nvvx" "縻")
("rifx" "縶")
("qozx" "繄")
("xqn " "縺")
("ofdi" "罅")
("/ypr" "罿")
("/k/p" "罾")
("/z,e" "罽")
("bbqn" "翴")
("a/ab" "翲")
("fkpw" "耬")
("uypa" "膻")
("uea." "臄")
("ur;b" "臌")
("u;;v" "臊")
("u/l/" "臅")
("ukyd" "臇")
("um;n" "膼")
("tdqe" "臩")
("lmpw" "艛")
("lmqp" "艚")
("lmrd" "艜")
("fcy;" "薃")
("fc/u" "薀")
("fypn" "薏")
("fy;q" "薧")
("fnic" "薕")
("f,am" "薠")
("faam" "薋")
("fr;b" "薣")
("fzrk" "蕻")
("fama" "薤")
("fam." "薚")
("famx" "薞")
("fbgm" "蕷")
("fztf" "蕼")
("fezx" "薉")
("fjg " "薡")
("f;ax" "蕺")
("fetn" "蕸")
("fs.;" "蕗")
("f/jx" "薎")
("fm;n" "薖")
("f.j." "薆")
("f.bs" "薍")
("fozy" "薙")
("fjzy" "薝")
("fljz" "薁")
("fjjf" "薢")
("flp." "薂")
("fi/p" "薈")
("fwzh" "薅")
("fysy" "蕹")
("fzib" "蕶")
("frin" "薘")
("flv." "薐")
("fi;k" "薟")
("evv." "虨")
("/nak" "螾")
("/yk;" "螪")
("/y.m" "螭")
("/nr," "蟅")
("/yqq" "螰")
("/qp " "螬")
("/qo " "螹")
("/a/c" "螵")
("/rr " "螼")
("/rjd" "螮")
("/bb." "蟉")
("/p/b" "蟃")
("/lv " "蟂")
("/lpn" "蟌")
("nlp/" "螷")
("rh./" "螯")
("rif/" "蟄")
("bgd/" "蟊")
("tvp/" "螴")
("qt//" "螶")
("xmf/" "螿")
("kk;/" "螸")
(".h//" "螽")
(",./ " "蟞")
("/nkr" "螲")
("ykym" "褵")
("ykqn" "褳")
("ykas" "褼")
("ykac" "褾")
("ykt/" "襁")
("yk,." "襒")
("yk.c" "褷")
("ykx." "襂")
("jpys" "覭")
("rjrs" "覯")
(",,js" "覮")
("jirf" "觲")
("vajb" "觳")
("yy;;" "謞")
("ybyf" "謘")
("ypk." "謖")
("y.xz" "謑")
("yldd" "謅")
("ymqv" "謋")
("ykyb" "謢")
("yodb" "謏")
("yit;" "謒")
("y.es" "謕")
("nrky" "謇")
(",,jy" "謍")
("prky" "謈")
("ygbb" "謆")
("yzlc" "謜")
("yfuk" "謓")
("yiku" "謚")
("qiic" "豏")
("vaab" "豰")
("a.zc" "豲")
("a./u" "豱")
("a..z" "豯")
("..xz" "貕")
(".lpq" "貔")
("miku" "賹")
("rcn;" "赯")
("sfuk" "蹎")
("sbrx" "蹍")
("sohp" "蹓")
("sk,u" "蹐")
("sit;" "蹌")
("nrkc" "蹇")
("qzlv" "轃")
("q/u " "轀")
("yp;n" "邅")
("lqkn" "遾")
("f/jt" "鄸")
("ap,n" "醚")
("apzu" "醢")
("apfr" "醛")
("apob" "醙")
(",,jp" "醟")
("apne" "醡")
("apiq" "醝")
("apju" "醠")
("iixx" "鎡")
("ic.k" "鎃")
("ihbt" "鎯")
("iafo" "鍤")
("irqk" "鍖")
("iqqp" "鍇")
("izqx" "鍼")
("ime " "鍘")
("ietb" "鍜")
("ipn " "鍶")
("ipac" "鍉")
("i.d." "鍐")
("iop." "鍑")
("ilpr" "鍠")
("iktz" "鍭")
("czoi" "鎏")
("cosi" "鍌")
("bgdi" "鍪")
("inaa" "鍹")
("iykd" "鍗")
("ijq " "鍕")
("ibgv" "鍒")
("it;q" "鍏")
("irsv" "鍱")
("izrr" "鍷")
("ipls" "鍻")
("ipax" "鍡")
("iem " "鍞")
("ifj;" "鍣")
("ily " "鍧")
("ikd." "鎀")
("i.fj" "鍎")
("crki" "鍙")
("eyp " "闇")
("erks" "闀")
("ea/r" "闉")
("ejzh" "闃")
("ejeb" "闅")
(".vhk" "閷")
("tyke" "隮")
("tpx," "隰")
("tak." "隬")
("zyig" "霠")
("zcrk" "霟")
("zcjq" "霘")
("z;;;" "霝")
("zfjz" "霙")
("rfnq" "鞚")
("rfoy" "鞡")
("rfcp" "鞜")
("rflf" "鞞")
("rfc;" "鞝")
("t;qf" "韕")
("t;qx" "韔")
("kkax" "韱")
("nacm" "顁")
("gcdm" "顄")
("lefm" "顊")
("ialm" "顉")
("guam" "顅")
(",,am" "顃")
("eeix" "餥")
("ibjq" "餫")
("ibfu" "餬")
("ibaz" "餪")
("ibp." "餳")
("ibps" "餲")
("ibw." "餯")
("iblr" "餭")
("ibkz" "餱")
("ib.d" "餰")
("iljx" "馘")
("lvps" "馣")
("lvpe" "馡")
("g,yf" "騂")
("g,hx" "駺")
("g,ax" "駴")
("g,v;" "駷")
("g,zh" "駹")
("g,tb" "駸")
("g,b;" "駶")
("g,pf" "駻")
("g,;u" "駽")
("g,ks" "駾")
("g,iv" "駼")
("g,xz" "騃")
("mua." "骾")
("z.cu" "髾")
("z.kr" "髽")
("z.le" "鬁")
("z..f" "髼")
("oxcu" "魈")
("u,r;" "鮚")
("u,qp" "鮨")
("u,ae" "鮞")
("u,ec" "鮛")
("u,jq" "鮦")
("u,s," "鮡")
("u,.;" "鮥")
("ame," "鮤")
("equ," "鮆")
("u,ov" "鮢")
("u,js" "鮠")
("u,i;" "鮯")
("nwl," "鴳")
("yk.," "鵁")
("ifl," "鵧")
("r;l," "鴶")
("zaa," "鴮")
("alj," "鴯")
("f.l," "鴱")
("ovl," "鴸")
("lf;," "鴰")
(".;l," "鵅")
("kvl," "鵂")
("lml," "鵃")
("xof," "鴾")
("ame," "鴷")
("kar," "鵀")
("w;l," "鴽")
("bbl," "翵")
("lel," "鴭")
(",yqq" "麊")
("afaq" "麉")
("yqqo" "麍")
("fkkf" "麰")
("rpkr" "黈")
("p,ra" "黚")
("ca,h" "黻")
("aasa" "黿")
("owy." "鼤")
("owzh" "鼣")
("owkj" "鼢")
("eiq " "齔")
("i;;f" "龠")
("kyuq" "儱")
("kyvs" "儭")
("kzle" "儮")
(";al." "嚘")
(";p,r" "嚜")
(";prc" "嚗")
(";;q;" "嚚")
(";nrk" "嚝")
(";ei " "嚙")
("///z" "奰")
("wohe" "嬼")
("b.l;" "屩")
("bnzc" "屪")
("dckx" "巀")
("jdfx" "幭")
("jdnh" "幮")
("crjn" "懘")
("cain" "懟")
("nnrk" "懭")
("nal." "懮")
("nf/x" "懱")
("nprc" "懪")
("nohe" "懰")
("noom" "懫")
("ilfn" "懖")
("nirx" "懩")
("oykn" "擿")
("oepn" "攄")
("olpv" "擽")
("ow/w" "擸")
("oirx" "攁")
("ofmc" "攃")
("ou,p" "擼")
("y./k" "斔")
("holp" "旛")
("pfj." "曚")
("po/," "曛")
("pzae" "曘")
("vyke" "櫅")
("vhod" "檹")
("vzae" "檽")
("vlrp" "櫡")
("voxf" "櫆")
("vy;." "檺")
("vzq;" "檶")
("vak." "檷")
("vtbm" "櫇")
("vfkb" "檴")
("vitx" "檭")
("pxxk" "歞")
("qozk" "毉")
("fjaq" "氋")
("cnrk" "瀇")
("cyq," "瀌")
("cnpr" "瀍")
("cirx" "瀁")
("c,,h" "瀅")
("cvab" "瀔")
("cf/x" "瀎")
("czfm" "濿")
("cal." "瀀")
("ct;m" "濻")
("ca.p" "瀦")
("clpv" "濼")
("ccrk" "濷")
("clmu" "瀊")
(",qdu" "爁")
(",bby" "燿")
("a.a," "燹")
(",,,v" "爃")
(",rgh" "燽")
(".al." "獶")
("arnm" "璸")
("arze" "瓀")
("arok" "璵")
("arfb" "瓁")
("arye" "璾")
("artu" "璶")
("arbf" "璻")
("arfu" "瓂")
("jzkh" "甔")
("b;yh" "甓")
("hbrb" "癜")
("hlbj" "癤")
("how " "癙")
("hi/p" "癐")
("hos." "癓")
("hzp " "癗")
("hjzy" "癚")
("lpl." "皦")
("yp;b" "皽")
("qdtu" "盬")
("j;;v" "矂")
("ji/p" "瞺")
("zlvg" "磿")
("gzp " "礌")
("gapa" "礓")
("gb;f" "礔")
("glp." "礉")
("o..g" "礐")
("girx" "礒")
("gcjp" "礑")
("yhin" "禭")
("yhip" "禬")
("lvin" "穟")
("lcp." "簜")
("l,,b" "簩")
("lfqh" "簙")
("lqhu" "簠")
("la/f" "簟")
("lfk;" "簭")
("lzkc" "簝")
("lbqi" "簦")
("ltsk" "簨")
("ley." "簢")
("llz;" "簥")
("ldlf" "簰")
("xiph" "繜")
("xzn " "繐")
("xru." "繖")
("xtra" "繣")
("xbg;" "繘")
("x;dm" "繢")
("x;;f" "繟")
("xlz;" "繑")
("nnnx" "繠")
("x,mq" "繗")
("xpab" "繓")
("iffm" "羵")
("iflp" "羳")
(",mqb" "翷")
("ffmb" "翸")
("ae;m" "聵")
("uzae" "臑")
("ufkb" "臒")
("uo/," "臐")
("lmyr" "艟")
("lml," "艞")
("fnnd" "薴")
("fnro" "藆")
("f,,," "藀")
("fy;k" "藃")
("faek" "藂")
("fr;n" "薳")
("frgh" "薵")
("fa/h" "薽")
("fozk" "藇")
("frax" "藄")
("fqoc" "薿")
("fbby" "藋")
("ftdu" "藎")
("fjbz" "藈")
("f/ye" "藅")
("fcah" "薱")
("f.pr" "薶")
("flvs" "藒")
("flp," "蘤")
("fcac" "薸")
("fzae" "薷")
("fak." "薾")
("cpcs" "虩")
("/,,b" "蟧")
("/ffm" "蟦")
("/r;;" "蟢")
("/r;." "蟛")
("/a/f" "蟫")
("/zn " "蟪")
("/rpk" "蟥")
("/zkc" "蟟")
("/tqh" "蟳")
("/tsk" "蟤")
("/p, " "蟔")
("/lz;" "蟜")
("/jp." "蟓")
("/ky," "蟭")
("/kam" "蟘")
("/xxx" "蟣")
("y./k" "螤")
("qdj/" "蟗")
("/ypx" "蟙")
("sxh/" "蠁")
("rak/" "蟴")
("zid/" "蟨")
("/cqv" "蟝")
("ykrs" "襓")
("ykvj" "襋")
("ykbb" "襏")
("yk;f" "襌")
("ykcz" "襆")
("ykj." "襐")
("ykth" "襑")
("ykeu" "襉")
("yyk;" "謪")
("yy.m" "謧")
("yzag" "謣")
("yq;;" "謳")
("yqn " "謰")
("ybbp" "謵")
("yzrp" "譇")
("yeua" "謯")
("yeli" "謼")
("yp/b" "謾")
("yp;w" "謱")
("ylpn" "謥")
("rh.y" "謷")
("rbsy" "謦")
("ynr," "謶")
("yrm " "謮")
("ya/c" "謤")
("ylvm" "謻")
("tgxy" "謽")
("rify" "謺")
("kk;." "豂")
("a..c" "豵")
(".q;;" "貙")
(".fpz" "貘")
(".p;w" "貗")
("qd;m" "賾")
("rifm" "贄")
("mxx." "贂")
("qozm" "贀")
("snkp" "蹜")
("syk;" "蹢")
("snr," "蹠")
("syqq" "蹗")
("szo " "蹖")
("sqam" "蹞")
("sqn " "蹥")
("sqp " "蹧")
("srjd" "蹛")
("scjr" "蹚")
("sxmh" "蹡")
("s.ec" "蹝")
(",.;c" "蹩")
("qo;c" "蹔")
("qyqq" "轆")
("qbb." "轇")
("qwpv" "轈")
("qqn " "轋")
(",.;s" "鄨")
("nrpt" "鄺")
("zzqt" "鄻")
("alut" "鄾")
("apym" "醨")
("apac" "醥")
("apq;" "醧")
("apzu" "醯")
("apb." "醪")
("ina." "鎵")
("iitc" "鎌")
("izah" "鎒")
("ig, " "鎷")
("iqhh" "鎛")
("ifi;" "鎝")
("ipbb" "鎉")
("idqi" "鎧")
("io, " "鎎")
("iodb" "鎪")
("ilpq" "鎞")
("iohp" "鎦")
("int;" "鎕")
("iirq" "鎈")
("iidu" "鎙")
("ibbv" "鎟")
("ifjx" "鎍")
("ir;x" "鎱")
("irxu" "鎑")
("icjs" "鎲")
("ipcs" "鎤")
("ikyf" "鎨")
("iljn" "鎴")
(",,ji" "鎣")
("kd.i" "鎥")
("epbb" "闒")
("edqi" "闓")
("eljv" "闑")
("tzqc" "隳")
("fpfy" "雗")
("f;;y" "雚")
("dky;" "巂雟")
("jyfb" "雘")
("w;ty" "雝")
("z;m " "霣")
("zu.k" "霢")
("zja." "霥")
("rftb" "鞬")
("rfpc" "鞮")
("rfps" "鞨")
("rfly" "鞫")
("rrff" "鞤")
("bgdf" "鞪")
("rfrv" "鞢")
("rfif" "鞥")
("t;qq" "韗")
("pacq" "韙")
("t;qv" "韖韘")
("ypfz" "韺")
("jqam" "顐")
("zqxm" "顑")
("pmam" "顒")
("xpn " "颸")
("ibru" "饁")
("ibo," "餼")
("ibqh" "餺")
("g,rk" "騏")
("g,vk" "騋")
("g,pq" "騉")
("g,pv" "騍")
("g,wc" "騄")
("g,ee" "騑")
("g,ld" "騊")
("g,ky" "騅")
("g,i;" "騇")
("g,j;" "騆")
("mulf" "髀")
("y;jf" "髜")
("z.is" "鬈")
("z.p." "鬄")
("z.uu" "鬅")
("eos " "鬩")
("qsqd" "鬵")
("oxqx" "魊")
("oxrk" "魌")
("oxky" "魋")
("u,ns" "鯇")
("u,qh" "鯆")
("u,a;" "鯃")
("u,as" "鮿")
("u,a." "鯁")
("u,ks" "鮵")
("u,js" "鮸")
("u,. " "鯓")
("u,t;" "鮶")
("u,fh" "鯄")
("u,cu" "鮹")
("u,iv" "鮽")
("ktg," "鵜")
("fjg," "鵓")
("qhl," "鵏")
("zkk," "鵊")
("awq," "鵛")
("tsn," "鵋")
("ml, " "鵙")
("lpq," "鵖")
("l,iv" "鵌")
(".zj," "鵗")
("kk;," "鵒")
("l,x." "鵔")
(".ar," "鵟")
("tl;," "鵘")
("lvs," "鵚")
("yqqx" "麎")
("yqqz" "麌")
("p,mm" "黟")
("rxja" "鼁")
("rkja" "鼀")
("ffrb" "鼖")
("owzh" "鼥")
("owg " "鼫")
("owor" "鼪")
("owl;" "鼩")
("ow.h" "鼨")
("ykd," "齌")
("eios" "齕")
("ky;x" "儴")
("kd.," "儵")
("j;qe" "劖")
("y;;b" "勷")
("zpud" "厴")
(";yvs" "嚫")
("r;i;" "嚭")
(";zle" "嚦")
(";epu" "嚧")
(";ejo" "嚪")
(";ecm" "嚬")
("repu" "壚")
("r;dn" "壝")
("rejo" "壛")
("alj." "夒")
("w/dz" "嬽")
("wv;m" "嬾")
("wre," "嬿")
("dyuq" "巃")
("jdnn" "幰")
(".yuq" "徿")
("neqk" "懻")
("onrn" "攇")
("onrx" "攐")
("oyuh" "攍")
("ozky" "攉")
("op/x" "攌")
("oepu" "攎")
("av.k" "斄")
("hoin" "旞")
("hoip" "旝")
("pzfm" "曞")
("vyrp" "櫧")
("vnbb" "櫠")
("val." "櫌")
("vppp" "櫑")
("vfq;" "櫙")
("vljh" "櫋")
("vlpv" "櫟")
("qdjv" "櫜")
("pppv" "櫐")
("a.rv" "櫫")
("va/n" "櫏")
("voom" "櫍")
("vxw." "櫞")
("bbbk" "歠")
("amrm" "殰")
("lqup" "氌")
("cyvs" "瀙")
("cyuq" "瀧")
("c,,x" "瀠")
("czky" "瀖")
("cvab" "瀫")
("ctzn" "瀡")
("c;dn" "瀢")
("cema" "瀣")
("clvm" "瀩")
("cnrn" "瀗")
("cy/x" "瀤")
("cqj/" "瀜")
("oszc" "瀪")
(",nrk" "爌")
(",yq," "爊")
("frk," "爇")
("ojq," "爂")
(",p,r" "爅")
("ofy," "犥")
("ofpc" "犦")
("of/q" "犤")
("ofww" "犣")
("ofzm" "犡")
("aryn" "瓋")
("arlv" "瓅")
("arq." "璷")
("arpp" "瓃")
("mmqh" "甖")
("hyke" "癠")
("jnam" "矉")
("jxld" "矊")
("jo/," "矄")
("ozfb" "矱")
("gzae" "礝")
("gqdu" "礛")
("gfqh" "礡")
("ozag" "礜")
("gnam" "礗")
("gfj." "礞")
("yha." "禰")
("lvye" "穧")
("lvsm" "穨")
("lfpf" "簳")
("lorr" "簼")
("lcjp" "簹")
("ls.;" "簬")
("lm;n" "簻")
(",/rp" "糬")
("b;y," "糪")
("xypn" "繶")
("xypa" "繵")
("xi.n" "繸")
("x;;v" "繰")
("xpfx" "繷")
("x/qx" "繯")
("xjt," "繺")
("xjjf" "繲")
("b;yx" "繴")
("xrin" "繨")
("ysxd" "罋")
("qdsd" "罊")
("/fpd" "羃")
("/xu," "羆")
("ifik" "羷")
("ezab" "翽")
("/qlb" "翾")
("aejy" "聸")
("unfh" "臗")
("uyq," "臕")
("lmix" "艤")
("lmcp" "艡")
("lmeb" "艣")
("fcaf" "藫")
("fhox" "藱")
("fnkg" "藭")
("fy.b" "藙")
("fykn" "藡")
("fyq," "藨")
("fr/m" "藚")
("fv;n" "藗")
("ft;m" "藬")
("fvq;" "藲")
("fa.p" "藸")
("fepn" "藘")
("fppp" "藟")
("f/xq" "藣")
("flvc" "藜")
("fjj." "藑")
("fohe" "藰")
("fnvo" "藦")
("fban" "藯")
("fggg" "藞")
("fol." "藢")
("/aam" "蠀")
("/ypa" "蟺")
("yu/h" "蠃")
("/aer" "蟶")
("/cjp" "蟷")
("//qx" "蠉")
("//rf" "蠌")
("//l/" "蠋")
("fpm/" "蠆")
("fl;/" "蟼")
("maf/" "蠈")
("qds/" "蟿")
("/nic" "蠊")
("/frv" "蠂")
("ykya" "襢")
("ykin" "襚")
("ykpx" "襛")
("yk/f" "襗")
("yk//" "襡")
("ykjy" "襜")
("ykip" "襘")
("ykik" "襝")
("yk;v" "襙")
("a/l." "覈")
("ewas" "覷")
(".bms" "覶")
("j;;f" "觶")
("yiph" "譐")
("yy;." "譈")
("yrrs" "譊")
("yqe." "譀")
("yzn " "譓")
("yqsp" "譖")
("ytsk" "譔")
("yeu " "譋")
("yor," "譕")
("ylz;" "譑")
("y;;f" "譂")
("yl,p" "譒")
("yli;" "譗")
("kk;." "豃")
("a.vi" "豷")
("a.fm" "豶")
(".;;f" "貚")
("mzhh" "贆")
("y.am" "贇")
("ma/f" "贉")
("rcrs" "趬")
("rcrk" "趪")
("rck," "趭")
("rcl;" "趫")
("sk/p" "蹭")
("s,mq" "蹸")
("sbtb" "蹳")
("s;dm" "蹪")
("sl,p" "蹯")
("slz;" "蹻")
(".,,b" "軂")
("qffm" "轒")
("qzkc" "轑")
("qbgf" "轏")
("qcaz" "轐")
("ql,p" "轓")
(";;px" "辴")
("reqt" "酀")
("f;;t" "鄿")
("apaf" "醰")
("apcz" "醭")
("intf" "鏞")
("ihoc" "鏇")
("ifft" "鏏")
("iq;;" "鏂")
("izex" "鏚")
("ibb." "鏐")
("itg/" "鏹")
("ieli" "鏬")
("ifpz" "鏌")
("idky" "鏙")
("i.vb" "鎩")
("i.kc" "鏦")
("rh.i" "鏊")
("inak" "鏔")
("intc" "鏮")
("inr," "鏣")
("iyqq" "鏕")
("izfh" "鏄")
("ipff" "鏎")
("ieph" "鏀")
("ixx." "鏒")
("rbsi" "鏧")
("zzkc" "镽")
("ezjs" "闚")
("ecjr" "闛")
("bbky" "雡")
("zy;t" "霩")
("zbbp" "霫")
("zprk" "霬")
("zbah" "霨")
("zvv." "霦")
("rff;" "鞳")
("qjif" "鞷")
("lmsf" "鞶")
("t;qr" "韝")
("t;qu" "韞")
("t;qf" "韟")
("rjrm" "顜")
("bbbm" "顙")
("muam" "顝")
("dqim" "顗")
("g,x " "颿")
("dqix" "颽")
("mofx" "颻")
("xbh/" "颾")
("ibir" "饈")
("ibq;" "饇")
("ibfz" "饃")
("lvpc" "馦")
("lvpu" "馧")
("g,ie" "騚")
("g,aw" "騕")
("g,bv" "騥")
("g,tb" "騝")
("g,bz" "騤")
("g,sd" "騛")
("g,eb" "騢")
("g,pc" "騠")
("g,m;" "騧")
("g,.." "騣")
("g,fg" "騞")
("g,lr" "騜")
("g,ps" "騔")
("mun;" "髂")
("z.ie" "鬋")
("z.zp" "鬊")
("z.ve" "鬎")
("z.zu" "鬌")
("qji." "鬷")
("u,r." "鯪")
("u,ab" "鯫")
("u,vk" "鯠")
("u,td" "鯞")
("u,pq" "鯤")
("u,.;" "鯦")
("u,os" "鯢")
("u,in" "鯰")
("u,wp" "鯔")
("irk," "鯗")
("lvl," "鯬")
("u,yw" "鯜")
("u,yf" "鯙")
("u,rr" "鯥")
("u,rk" "鯕")
("u,ee" "鯡")
("u,lf" "鯚")
("nmg," "鵷")
("y;c," "鶁")
("ntk," "鶊")
("rul," "鶄")
("atd," "鶈")
("rkr," "鵱")
("l,rk" "鶀")
("zqd," "鵸")
("vkk," "鶆")
("bf;," "鶋")
("bdd," "鶌")
("bbb," "鵽")
("epf," "鵫")
("l,l," "鵴")
("j;s," "鵵")
("jr;," "鵰")
("ujb," "鵩")
("wpl," "鶅")
("gul," "鵳")
("l,ky" "鵻")
("osl," "鶂")
("lpl," "鵯")
("lvl," "鵹")
("l,pf" "鵿")
("vpl," "鶇")
("if;," "鵨")
("yqq;" "麔")
("yqqs" "麑")
("nvvb" "黀")
("ca,h" "黼")
("owrh" "鼭")
("ljph" "齀")
("ljp;" "齁")
("ykdu" "齍")
("eiql" "齖")
("eio " "齗")
("eike" "齘")
("qjjy" "匷")
("y;gf" "嚲")
(";j;h" "嚵")
("o..;" "嚳")
("raew" "壣")
("wkkx" "孅")
("d,,;" "巆")
("deqx" "巇")
("nmmw" "廮")
("nu,f" "廯")
(".y;x" "忀")
(".pdc" "忁")
("ny;x" "懹")
("oyq," "攗")
("ommw" "攖")
("okkx" "攕")
("onrc" "攓")
("hook" "旟")
("pyuq" "曨")
("pre," "曣")
("pzky" "曤")
("vyuq" "櫳")
("vy/x" "櫰")
("vzle" "櫪")
("vepu" "櫨")
("vfte" "櫹")
("dlev" "櫱")
("vq;a" "櫮")
("vu,v" "櫯")
("cy;x" "瀼")
("c,pk" "瀵")
("c,,;" "瀯")
("cbbk" "瀷")
("cmmw" "瀴")
("c/ze" "瀱")
("c./h" "灂")
("ckkx" "瀸")
("cosx" "瀿")
("cj;h" "瀺")
("ci;f" "瀹")
("czvj" "灀")
("crpx" "瀻")
("cfn," "瀳")
("celc" "灁")
(",ejo" "爓")
(",irx" "爔")
("kykf" "犨")
(".y;x" "獽")
(".tg." "獼")
("ojqh" "璺")
("lpy," "皫")
("lplv" "皪")
("r/mb" "皾")
("xriu" "盭")
("jnrk" "矌")
("jjj." "矎")
("jljh" "矏")
("jjkb" "矍")
("oz/q" "矲")
("gqdm" "礥")
("gf/x" "礣")
("gppp" "礧")
("pppg" "礨")
("gfmc" "礤")
("goom" "礩")
("yhzm" "禲")
("lvy," "穮")
("lvnk" "穬")
("lvup" "穭")
("ypf." "竷")
("lr;r" "籉")
("la/h" "籈")
("lbby" "籊")
("ly;." "籇")
("lozk" "籅")
(",qdu" "糮")
("xzae" "繻")
("x;dn" "繾")
("xo/," "纁")
("xkcz" "纀")
("ifze" "羺")
("rgqb" "翿")
("aend" "聹")
("uzky" "臛")
("ure," "臙")
("ojqa" "舋")
("lmf." "艨")
("lmye" "艩")
("fyuq" "蘢")
("fzky" "藿")
("fq;a" "蘁")
("fv;m" "藾")
("frqu" "蘛")
("fo/f" "蘀")
("fzle" "藶")
("f;;o" "蘄")
("f/jb" "蘉")
("f.ud" "蘅")
("f.oc" "蘌")
("fyvs" "藽")
("/nam" "蠙")
("/yke" "蠐")
("/,,v" "蠑")
("/bby" "蠗")
("/fj." "蠓")
("/fkb" "蠖")
("ykle" "襣")
("ykze" "襦")
("jso." "覹")
("o..j" "觷")
("yypa" "譠")
("yfps" "譪")
("yjaa" "譝")
("ypfx" "譨")
("yi;k" "譣")
("lphy" "譥")
("ynic" "譧")
("yorb" "譭")
("rc;v" "趮")
("sea." "躆")
("slp." "躈")
("b;yc" "躄")
("qirx" "轙")
("qfk;" "轖")
("qzqx" "轗")
("qfps" "轕")
("q/qx" "轘")
("qdsq" "轚")
(".pwn" "邍")
("z;;t" "酃")
("j;qt" "酁")
("apyn" "醷")
("ape." "醵")
("appx" "醲")
("ap/f" "醳")
("icp." "鐋")
("iy;." "鐓")
("i,mq" "鏻")
("iicp" "鐠")
("iiph" "鐏")
("ia/f" "鐔")
("iru." "鏾")
("iqsp" "鐕")
("izkc" "鐐")
("itgm" "鐨")
("ibqi" "鐙")
("ibg;" "鐍")
("ifaf" "鏵")
("i;dm" "鐀")
("icaz" "鏷")
("il,p" "鐇")
("iky," "鐎")
("ixxx" "鐖")
("i,,b" "鐒")
("ibtb" "鏺")
("itsk" "鐉")
("izn " "鏸")
("itp." "鐊")
("icjv" "鏿")
("ilvj" "鏼")
("ijp." "鐌")
("ikyv" "鏶")
("ixr;" "鐑")
("ti.i" "鐆")
("eqe." "闞")
("e;dm" "闠")
("ei;b" "闟")
("zcrk" "霮")
("zbqi" "霯")
("rfyt" "鞹")
("rfpw" "鞻")
("igap" "韽")
("rbsp" "韾")
("a/am" "顠")
("rjdm" "顢")
("zeam" "顣")
("bbkm" "顟")
("bblx" "飁")
("xbb." "飂")
("ibvi" "饐")
("ibr;" "饎")
("ibfm" "饙")
("ibtk" "饌")
("ib;m" "饋")
("ibcv" "饓")
("g,ff" "騲")
("g,pw" "騴")
("g,.z" "騱")
("g,lq" "騬")
("g,ob" "騪")
("g,ld" "騶")
("g,ox" "騩")
("g,op" "騮")
("g,gb" "騸")
("tec," "騭")
("muy;" "髇")
("muiq" "髊")
("muqh" "髆")
("z.rp" "鬐")
("z.fk" "鬒")
("z.ic" "鬑")
("u,qw" "鰋")
("u,rv" "鰈")
("u,pc" "鯷")
("u,pm" "鰅")
("u,o." "鰒")
("u,kz" "鯸")
("bqs," "鱀")
("u,bv" "鰇")
("u,tb" "鰎")
("u,zp" "鰆")
("u,fu" "鰗")
("u,zx" "鰔")
("u,lr" "鰉")
("nkz," "鶟")
("ykj," "鶙")
("jql," "鶤")
("qpl," "鶝")
("v;b," "鶒")
("f;u," "鶘")
("vhn," "鶐")
("qql," "鶛")
("qpw," "鶠")
("bgd," "鶔")
("fbg," "鶜")
("jzh," "鶪")
("pac," "鶗")
("plk," "鶡")
(";;a," "鶚")
(".az," "鶢")
("w.l," "鶨")
(".fj," "鶞")
("gjf," "鶣")
("ixx," "鶿")
("bgd," "鶩")
("lv,," "鶖")
("f;u," "鶦")
("fjz," "鶧")
("yqqx" "麙")
("yqqe" "麛")
("yqqb" "麚")
("p,yc" "黥")
("p,zs" "黤")
("lvl," "黧")
("p,ns" "黦")
("owm " "鼰")
("owlb" "鼮")
("eirs" "齛")
("eij;" "齠")
("ei;k" "齞")
("eix;" "齝")
("eils" "齙")
("yuqz" "龑")
("krzy" "儺")
("kosm" "儹")
("nvve" "劘")
("osoe" "劗")
(";yky" "囃")
(";rhm" "嚽")
(";f;y" "嚾")
("wdk;" "孈")
("wkyb" "孇")
("dled" "巋")
("df;y" "巏")
("nw;y" "廱")
("nf;y" "懽")
("onkw" "攛")
("vfch" "欂")
("vkkx" "櫼")
("vj;h" "欃")
("vozf" "櫸")
("vy;x" "欀")
("cfdi" "灃")
("caee" "灄")
("cqsd" "灊")
("cjjy" "灈")
("cw;y" "灉")
("cppr" "灅")
("cfqu" "灆")
(",./h" "爝")
(",i;f" "爚")
(",y;x" "爙")
(".f;y" "獾")
("eqjh" "甗")
("hlvm" "癪")
("jzky" "矐")
("gzky" "礭")
("yuqg" "礱")
("g,,x" "礯")
("lp;." "籔")
("lclp" "籓")
(",zfm" "糲")
("xnrk" "纊")
(",xam" "纇")
("xr;m" "纈")
("xal." "纋")
("xp,r" "纆")
("pppx" "纍")
("pppd" "罍")
("ify." "羻")
("fka." "耰")
("yuph" "臝")
("fy;x" "蘘")
("fyq," "蘪")
("fz;;" "蘦")
("ft.n" "蘟")
("frpr" "蘣")
("frf," "蘜")
("fqob" "蘙")
("fean" "蘧")
("f/ze" "蘮")
("fmmw" "蘡")
("fxf;" "蘠")
("fosx" "蘩")
("fi;." "蘞")
("fi;f" "蘥")
("/yrp" "蠩")
("/ppp" "蠝")
("/f/x" "蠛")
("alp/" "蠠")
("ip//" "蠤")
("v../" "蠜")
(".e//" "蠫")
("lufx" "衊")
("ykrm" "襭襩")
("ykpc" "襮")
("ykzp" "襫")
("qozj" "觺")
("yy;." "譹")
("yrgh" "譸")
("yjhe" "譅")
("yqoc" "譺")
("mmy " "譻")
("mtdu" "贐")
("mmm " "贔")
("rcby" "趯")
("sak." "躎")
("sorq" "躌")
("qqdu" "轞")
("qcah" "轛")
("ozaq" "轝")
("fdft" "酆")
("f;;t" "酄")
("dkyt" "酅")
("apze" "醹")
("iypn" "鐿")
("iea." "鐻")
("i/qx" "鐶")
("ii.n" "鐩")
("irin" "鐽")
("iffm" "鐼")
("i;;v" "鐰")
("im;n" "鐹")
("iepb" "鐪")
("ifrv" "鐷")
("iezx" "鐬")
("i.j." "鑀")
("ii;k" "鐱")
("erin" "闥")
("e/qx" "闤")
("ecjp" "闣")
("z;ax" "霵")
("zos." "霺")
("rfxx" "鞿")
("t;qf" "韡")
("rrrm" "顤")
("xzkc" "飉")
("zhzx" "飆")
("xohp" "飀")
("ibya" "饘")
("ibex" "饖")
("g,rr" "騹")
("g,bp" "騽")
("g,pf" "驆")
("g,ln" "驄")
("g,x." "驂")
("rh.," "驁")
("rif," "騺")
("g,yf" "騿")
("munv" "髍")
("z.fz" "鬕")
("z.rk" "鬗")
("z.pb" "鬘")
("z.x." "鬖")
("qji." "鬺")
("oxac" "魒")
("u,n;" "鰫")
("u,y;" "鰝")
("u,ic" "鰜")
("u,e." "鰬")
("u,ph" "鰣")
("u,pb" "鰨")
("u,md" "鰩")
("u,ld" "鰤")
("u,op" "鰡")
("nr;," "鶷")
("ntd," "鶶")
("itc," "鶼")
("iku," "鷁")
("valb" "鷇")
("qji," "鷊")
("fua," "鷏")
("fpf," "鶾")
("a/v," "鷅")
("pnw," "鷃")
("mul," "鶻")
("ldl," "鶵")
("lpz," "鷎")
("ohj," "鶹")
("k,u," "鶺")
("itl," "鶬")
("l,.s" "鷈")
("nrk," "鶱")
("xhl," "鶭")
("l,g," "鷌")
("l,ld" "鶳")
("ljv," "鷍")
("kxb," "鶲")
("ep.q" "鹺")
("yqqv" "麜")
("p,ar" "黫")
("p,rk" "黮")
("p,if" "黭")
("r;i;" "鼛")
("r;ie" "鼘")
("r;ix" "鼚")
("owru" "鼱")
("ykdm" "齎")
("eipx" "齥")
("izei" "齤")
("yuqc" "龒")
("yoja" "亹")
(";fp/" "囆")
(";;px" "囅")
(";osm" "囋")
("yxxz" "奱")
("wajq" "孋")
("yxxw" "孌")
("dilw" "巕")
("dosm" "巑")
("najq" "廲")
("oy.y" "攡")
("onve" "攠")
("oajq" "攦")
("oosm" "攢")
("vjjy" "欋")
("vdk;" "欈")
("vcab" "欉")
("jjkq" "氍")
("cy.y" "灕")
("cnve" "灖")
("c/ya" "灗")
("cosm" "灒")
(",///" "爞")
(",f;y" "爟")
("lvwf" "犩")
(".al." "獿")
("arfy" "瓘")
("tgah" "瓕")
("arr," "瓙")
("ard;" "瓗")
("hmmw" "癭")
("lp.h" "皭")
("gzvj" "礵")
("yhif" "禴")
("lvyx" "穰")
("lv.h" "穱")
("lzky" "籗")
("lo/f" "籜")
("liwc" "籙")
("liax" "籛")
("lepu" "籚")
("k,by" "糴")
("dle," "糱")
("xepu" "纑")
("ofdu" "罏")
("/rfd" "羇")
("ujjy" "臞")
("lmeu" "艫")
("ffdi" "蘴")
("faex" "蘵")
("frpr" "蘳")
("fled" "蘬")
("fppr" "蘲")
("flvx" "蘶")
("/yuq" "蠬")
("/fte" "蠨")
("/epu" "蠦")
("yuq/" "蠪")
("dle/" "蠥")
("ykyq" "襱")
("r/ms" "覿")
("nl,s" "覾")
("jlpv" "觻")
("yiub" "譾")
("yppp" "讄")
("yjj." "讂")
(".t;y" "讆")
("ynlp" "讅")
("yffn" "譿")
("ohdm" "贕")
("snrh" "躕")
("snpr" "躔")
("sa/n" "躚")
("slpv" "躒")
("sw/w" "躐")
("sxxa" "躖")
(".t;c" "躗")
("qppp" "轠")
("qlpv" "轢")
("osot" "酇")
("inam" "鑌")
("izae" "鑐")
("ifkb" "鑊")
("qawi" "鑋")
("innd" "鑏")
("iyke" "鑇")
("i,,v" "鑅")
("iak." "鑈")
("ifru" "鑉")
("icah" "鑆")
("zbgj" "霿")
("t;q/" "韣")
("ezam" "顪")
("i;;m" "顩")
("xarl" "飋")
("ysxx" "饔")
("ibf." "饛")
("g,,q" "驎")
("g,kp" "驓")
("g,af" "驔")
("g,te" "驌")
("g,bf" "驏")
("g,b;" "驈")
("g,ff" "驊")
("g,ea" "驉")
("g,;f" "驒")
("g,y." "驐")
("murs" "髐")
("z.kp" "鬙")
("eqe." "鬫")
("tg,d" "鬻")
("oxea" "魖")
("oxxx" "魕")
("u,yf" "鱆")
("u,zt" "鱈")
("u,rm" "鰿")
("u,zh" "鱄")
("u,qr" "鰹")
("u,rb" "鰳")
("u,an" "鱁")
("u,bp" "鰼")
("u,kv" "鰷")
("ou,." "鰴")
("rh.," "鰲")
("u,qp" "鰽")
("u,mc" "鰶")
("ntj," "鷛")
("zfh," "鷒")
("z..," "鷞")
("bbk," "鷚")
("fiv," "鷋")
("pza," "鷐")
("p;d," "鷜")
("lyl," "鷑")
("hoo," "鷟")
(",.l," "鷩")
("rif," "鷙")
("v;.," "鷘")
("qoz," "鷖")
("brl," "鷵")
(";ky," "鷕")
("pff," "鷝")
("fkkm" "麶")
("p,fk" "黰")
("ownh" "鼵")
("owjh" "鼳")
("owjq" "鼲")
("ljpc" "齂")
("eipv" "齫")
("i;yq" "龕")
("i;;v" "龢")
("kppx" "儽")
("w./e" "劙")
("pppr" "壨")
("r;;." "壧")
("zrlf" "奲")
("w;;." "孍")
("deqh" "巘")
("nlp/" "蠯")
("tgjb" "彏")
("rzkn" "戁")
("ncj," "戃")
("njjb" "戄")
("ocj," "攩")
("oljx" "攥")
("y.oa" "斖")
("yxxp" "曫")
("vosm" "欑")
("yxxv" "欒")
("v/xy" "欏")
("rbs;" "毊")
("ce;f" "灛")
("co.s" "灚")
("nvv," "爢")
(".f;o" "玂")
(".;;." "玁")
(".jjb" "玃")
("hw;y" "癰")
("jf;y" "矔")
("lean" "籧")
("liop" "籦")
("xy;x" "纕")
("lmjh" "艬")
("fy.y" "蘺")
("fyka" "虀")
("fnyx" "蘹")
("fnve" "蘼")
("f,zm" "蘱")
("fqdx" "蘻")
("fryx" "蘾")
("/y;x" "蠰")
("iku/" "蠲")
("/qob" "蠮")
("/mmw" "蠳")
("ykrx" "襶")
("yke/" "襴")
("ykkx" "襳")
("jre," "觾")
("yre," "讌")
("kyyy" "讎")
("yuqy" "讋")
("yzle" "讈")
("kk;q" "豅")
("esem" "贙")
("syuq" "躘")
("qepu" "轤")
("qzle" "轣")
("apr," "醼")
("iepn" "鑢")
("ioom" "鑕")
("if.n" "鑝")
("ilvc" "鑗")
("iw/w" "鑞")
("rffb" "韄")
("rfp," "韅")
("ypfb" "頀")
("g,rx" "驖")
("g,ya" "驙")
("z.px" "鬞")
("z./x" "鬟")
("z.ip" "鬠")
("u,ih" "鱒")
("u,th" "鱘")
("u,te" "鱐")
("u,b;" "鱊")
("u,bb" "鱍")
("u,ea" "鱋")
("u,lp" "鱕")
("u,rs" "鱙")
("u,j." "鱌")
("u,l;" "鱎")
("l,y." "鷻")
("ipf," "鷷")
("zkp," "鷯")
("a/p," "鷣")
("tde," "鷫")
("bgd," "鷸")
(";;p," "鷤")
("/ml," "鷶")
("or,," "鷡")
("lz;," "鷮")
("ky,," "鷦")
("y;c," "鷲")
("req," "鷰")
("zid," "鷢")
("rpk," "鷬")
("evl," "鷴")
("eul," "鷳")
("faf," "鷨")
("l,p," "鷭")
("nvvm" "黂")
("lvkm" "黐")
("p,x." "黲")
("qoz," "黳")
("jpya" "鼆")
("r;i/" "鼜")
("owic" "鼸")
("ow.z" "鼷")
("ow.s" "鼶")
("ljps" "齃")
("ykda" "齏")
("eiab" "齱")
("eirp" "齰")
("eizd" "齮")
("eios" "齯")
(";fji" "囓")
("r;i;" "囍")
("wbc/" "孎")
("bmmm" "屭")
("ow./" "攭")
("pcj," "曭")
("p;;." "曮")
("vcj," "欓")
("cbc/" "灟")
("cfe/" "灡")
("cpym" "灝")
("cqds" "灠")
(",cj," "爣")
("areh" "瓛")
(".xk/" "瓥")
("yxxj" "矕")
("gosm" "礸")
("yh,m" "禷")
("yhom" "禶")
("lxxo" "籪")
("xdk;" "纗")
("/yxx" "羉")
("lmkb" "艭")
("fckx" "虃")
("/f;y" "蠸")
("/jjy" "蠷")
("/dk;" "蠵")
("tfau" "衋")
("yt.n" "讔")
("yev/" "讕")
("sy,b" "躞")
("sy;x" "躟")
("flec" "躠")
("sev/" "躝")
("apn," "醾")
("apz;" "醽")
("ap.h" "釂")
("iii " "鑫")
("iyuq" "鑨")
("iq;a" "鑩")
("kyky" "雥")
("zaan" "靆")
("zkyy" "靃")
("zyuq" "靇")
("rfrm" "韇")
("t;qm" "韥")
("g,nm" "驞")
("munm" "髕")
("cqox" "魙")
("u,ya" "鱣")
("u,pi" "鱧")
("u,ja" "鱦")
("u,;v" "鱢")
("u,/x" "鱞")
("u,ip" "鱠")
("c.x," "鸂")
("ypn," "鷾")
("yp;," "鸇")
("l,ix" "鸃")
("e;g," "鸆")
("/ri," "鸅")
("/l/," "鸀")
("yulh" "鸁")
("vpa," "鸉")
("b;y," "鷿")
("o..," "鷽")
("lph," "鸄")
("yqqa" "麠")
("r;ir" "鼞")
("ljps" "齆")
("ein." "齴")
("eipm" "齵")
("ei;g" "齶")
(";qdx" "囔")
("oqdx" "攮")
("bc/o" "斸")
("vbc/" "欘")
("vppx" "欙")
("vfe/" "欗")
("vw./" "欚")
("cqdx" "灢")
(",qds" "爦")
("ofi." "犪")
("jcj," "矘")
("jeq." "矙")
("g;;." "礹")
("lljn" "籩")
("losm" "籫")
("dd,y" "糶")
("xajq" "纚")
("xosm" "纘")
("rszx" "纛")
("x/xy" "纙")
("yxxk" "臠")
("rzkk" "臡")
("fppx" "虆")
("ftgy" "虇")
("fal;" "虈")
("ykaq" "襹")
("ykf/" "襺")
("ykfx" "襼")
("ykvo" "襻")
("jdk;" "觿")
("yaee" "讘")
("yf;y" "讙")
("snkw" "躥")
("sffp" "躤")
("sjjy" "躣")
("ifch" "鑮")
("iev/" "鑭")
("ikkx" "鑯")
("ij;h" "鑱")
("inrc" "鑳")
("zaa." "靉")
(",,ym" "顲")
("ibyx" "饟")
("u,cp" "鱨")
("u,ok" "鱮")
("u,ye" "鱭")
("nnu," "鸋")
("akj," "鸍")
("bbk," "鸐")
("fja," "鸏")
("oza," "鸒")
(".yz," "鸑")
("yqqe" "麡")
("p,jy" "黵")
(";;pa" "鼉")
("ljpa" "齇")
("eiiu" "齸")
("eifk" "齻")
("eild" "齺")
("irli" "齹")
("pyxv" "圞")
("cpxm" "灦")
("lyuh" "籯")
("/jjb" "蠼")
("rcom" "趲")
("sosm" "躦")
("apaq" "釃")
("idk;" "鑴")
("ippr" "鑸")
("ifzx" "鑶")
("if;y" "鑵")
("g,r," "驠")
("u,fx" "鱴")
("u,lv" "鱳")
("u,zm" "鱱")
("u,lx" "鱵")
("l,pc" "鸔")
("ppp," "鸓")
("zpu," "黶")
("b;ya" "鼊")
("i;;p" "龤")
("cypm" "灨")
("lpcc" "灥")
(",fe/" "糷")
("esk," "虪")
("/bc/" "蠾")
("cky/" "蠽")
("xxa/" "蠿")
("yeqh" "讞")
(".jjb" "貜")
("sjjb" "躩")
(".nam" "軉")
("zcze" "靋")
("aeam" "顳")
("f;;m" "顴")
("f;;x" "飌")
("ibom" "饡")
("lvpp" "馫")
("g,yx" "驤")
("g,zj" "驦")
("g,r," "驧")
("z.yx" "鬤")
("epu," "鸕")
("yuq," "鸗")
("ljpx" "齈")
("ypfn" "戇")
("vz;k" "欞")
(",z;k" "爧")
("f,.a" "虌")
("sil." "躨")
("icj," "钂")
("ieqh" "钀")
("ijjb" "钁")
("g,fy" "驩")
("g,d;" "驨")
("ejja" "鬮")
("i;;," "鸙")
(",vo." "爩")
("fojj" "虋")
("yr/y" "讟")
("ibc/" "钃")
("u,fy" "鱹")
("fkki" "麷")
("hyxk" "癵")
("g,g," "驫")
("u,aq" "鱺")
("ajh," "鸝")
("cfdu" "灩")
("cvo." "灪")
("yqqq" "麤")
("eqji" "齾")
("ljpx" "齉")
("yuqq" "龘")
("rakg" "碁")
("ilvg" "銹")
("yprx" "裏")
("rfk;" "墻")
("napa" "恒")
(",nr " "粧")
("weu " "嫺")
)
;; Local Variables:
;; version-control: never
;; no-update-autoloads: t
;; End:
